/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.util.ParseUtils;

public class SearchTopAnomalyResultRequest
extends ActionRequest {
    private static final String TASK_ID_FIELD = "task_id";
    private static final String SIZE_FIELD = "size";
    private static final String CATEGORY_FIELD_FIELD = "category_field";
    private static final String ORDER_FIELD = "order";
    private static final String START_TIME_FIELD = "start_time_ms";
    private static final String END_TIME_FIELD = "end_time_ms";
    private String detectorId;
    private String taskId;
    private boolean historical;
    private Integer size;
    private List<String> categoryFields;
    private String order;
    private Instant startTime;
    private Instant endTime;

    public SearchTopAnomalyResultRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorId = in.readOptionalString();
        this.taskId = in.readOptionalString();
        this.historical = in.readBoolean();
        this.size = in.readOptionalInt();
        this.categoryFields = in.readOptionalStringList();
        this.order = in.readOptionalString();
        this.startTime = in.readInstant();
        this.endTime = in.readInstant();
    }

    public SearchTopAnomalyResultRequest(String detectorId, String taskId, boolean historical, Integer size, List<String> categoryFields, String order, Instant startTime, Instant endTime) {
        this.detectorId = detectorId;
        this.taskId = taskId;
        this.historical = historical;
        this.size = size;
        this.categoryFields = categoryFields;
        this.order = order;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getId() {
        return this.detectorId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean getHistorical() {
        return this.historical;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<String> getCategoryFields() {
        return this.categoryFields;
    }

    public String getOrder() {
        return this.order;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setCategoryFields(List<String> categoryFields) {
        this.categoryFields = categoryFields;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public static SearchTopAnomalyResultRequest parse(XContentParser parser, String detectorId, boolean historical) throws IOException {
        String taskId = null;
        Integer size = null;
        List categoryFields = null;
        String order = null;
        Instant startTime = null;
        Instant endTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "task_id": {
                    taskId = parser.text();
                    break;
                }
                case "size": {
                    size = parser.intValue();
                    break;
                }
                case "category_field": {
                    categoryFields = parser.list();
                    break;
                }
                case "order": {
                    order = parser.text();
                    break;
                }
                case "start_time_ms": {
                    startTime = ParseUtils.toInstant(parser);
                    break;
                }
                case "end_time_ms": {
                    endTime = ParseUtils.toInstant(parser);
                    break;
                }
            }
        }
        List convertedCategoryFields = categoryFields;
        return new SearchTopAnomalyResultRequest(detectorId, taskId, historical, size, convertedCategoryFields, order, startTime, endTime);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.taskId);
        out.writeBoolean(this.historical);
        out.writeOptionalInt(this.size);
        out.writeOptionalStringCollection(this.categoryFields);
        out.writeOptionalString(this.order);
        out.writeInstant(this.startTime);
        out.writeInstant(this.endTime);
    }

    public ActionRequestValidationException validate() {
        if (this.startTime == null || this.endTime == null) {
            return ValidateActions.addValidationError((String)"Must set both start time and end time with epoch of milliseconds", null);
        }
        if (!this.startTime.isBefore(this.endTime)) {
            return ValidateActions.addValidationError((String)"Start time should be before end time", null);
        }
        return null;
    }
}

