/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionResponse;

public class AlterPartitionRequest
extends AbstractRequest {
    private final AlterPartitionRequestData data;

    public AlterPartitionRequest(AlterPartitionRequestData data, short apiVersion) {
        super(ApiKeys.ALTER_PARTITION, apiVersion);
        this.data = data;
    }

    @Override
    public AlterPartitionRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    public static AlterPartitionRequest parse(Readable readable, short version) {
        return new AlterPartitionRequest(new AlterPartitionRequestData(readable, version), version);
    }

    public static List<AlterPartitionRequestData.BrokerState> newIsrToSimpleNewIsrWithBrokerEpochs(List<Integer> newIsr) {
        return newIsr.stream().map(brokerId -> new AlterPartitionRequestData.BrokerState().setBrokerId((int)brokerId)).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterPartitionRequest> {
        private final AlterPartitionRequestData data;

        public Builder(AlterPartitionRequestData data) {
            super(ApiKeys.ALTER_PARTITION, ApiKeys.ALTER_PARTITION.oldestVersion(), ApiKeys.ALTER_PARTITION.latestVersion());
            this.data = data;
        }

        @Override
        public AlterPartitionRequest build(short version) {
            if (version < 3) {
                this.data.topics().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
                    if (!partitionData.newIsrWithEpochs().isEmpty()) {
                        ArrayList<Integer> newIsr = new ArrayList<Integer>(partitionData.newIsrWithEpochs().size());
                        partitionData.newIsrWithEpochs().forEach(brokerState -> newIsr.add(brokerState.brokerId()));
                        partitionData.setNewIsr(newIsr);
                        partitionData.setNewIsrWithEpochs(Collections.emptyList());
                    }
                }));
            }
            return new AlterPartitionRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

