/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.sdk.skeleton.PySkeletonUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PythonSdkUtil {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = com.jetbrains.python.sdk.legacy.PythonSdkUtil.BUILTIN_ROOT_TYPE;

    public static boolean isPythonSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(0);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isPythonSdk((Sdk)sdk);
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull Sdk> getAllSdks() {
        List list = com.jetbrains.python.sdk.legacy.PythonSdkUtil.getAllSdks();
        if (list == null) {
            PythonSdkUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk) {
        if (vFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(2);
        }
        return PySkeletonUtil.isStdLib(vFile, pythonSdk);
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.findPythonSdk((Module)module);
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isRemote((Sdk)sdk);
    }

    @NlsSafe
    public static String getUserSite() {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.getUserSite();
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(3);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.findSkeletonsDir((Sdk)sdk);
    }

    @Deprecated(forRemoval=true)
    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(4);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(5);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isDisposed((Sdk)sdk);
    }

    public static List<Sdk> getAllLocalCPythons() {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.getAllLocalCPythons();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        if (rootPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(6);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.getPythonExecutable((String)rootPath);
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(8);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.getExecutablePath((String)homeDirectory, (String)name);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static Path getExecutablePath(@NotNull Path homeDirectory, @NotNull String name) {
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            PythonSdkUtil.$$$reportNull$$$0(10);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.getExecutablePath((Path)homeDirectory, (String)name);
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkUtil.$$$reportNull$$$0(11);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.findSdkByKey((String)key);
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(12);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.findPythonSdk((PsiElement)element);
    }

    @Deprecated
    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.findSdkByPath((String)path);
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk) {
        if (pythonSdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(13);
        }
        return PySkeletonUtil.getSitePackagesDirectory(pythonSdk);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(14);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isVirtualEnv((Sdk)sdk);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path) {
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isVirtualEnv((String)path);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(15);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isCondaVirtualEnv((Sdk)sdk);
    }

    @Deprecated
    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(16);
        }
        return com.jetbrains.python.sdk.legacy.PythonSdkUtil.isConda((Sdk)sdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPythonSdk";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

