/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.InvalidFormatException;

public class NGramFeatureGenerator
implements FeatureGenerator {
    private final int minGram;
    private final int maxGram;

    public NGramFeatureGenerator(int minGram, int maxGram) throws InvalidFormatException {
        if (minGram > 0 && maxGram > 0) {
            if (minGram > maxGram) {
                throw new InvalidFormatException("Minimum range value (minGram) should be less than or equal to maximum range value (maxGram)!");
            }
        } else {
            throw new InvalidFormatException("Both minimum range value (minGram) & maximum range value (maxGram) should be greater than or equal to 1!");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public NGramFeatureGenerator() throws InvalidFormatException {
        this(2, 2);
    }

    @Override
    public Collection<String> extractFeatures(String[] text, Map<String, Object> extraInfo) {
        Objects.requireNonNull(text, "text must not be null");
        ArrayList<String> features = new ArrayList<String>();
        for (int i = 0; i <= text.length - this.minGram; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("ng=");
            for (int y = 0; y < this.maxGram && i + y < text.length; ++y) {
                sb.append(":");
                sb.append(text[i + y]);
                int gramCount = y + 1;
                if (this.maxGram < gramCount || gramCount < this.minGram) continue;
                features.add(sb.toString());
            }
        }
        return features;
    }
}

