/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.util.FileTypeMagicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetUploadTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ConfigSetUploadTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"n").longOpt("conf-name").hasArg().argName("NAME").required(false).desc("Configset name in ZooKeeper.").build(), Option.builder().longOpt("confname").hasArg().argName("NAME").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --conf-name instead").get()).required(false).desc("Configset name in ZooKeeper.").build(), Option.builder((String)"d").longOpt("conf-dir").hasArg().argName("DIR").required(false).desc("Local directory with configs.").build(), Option.builder().longOpt("confdir").hasArg().argName("DIR").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --conf-dir instead").get()).required(false).desc("Local directory with configs.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "upconfig";
    }

    @Override
    public String getUsage() {
        return "bin/solr zk upconfig [-d <DIR>] [-n <NAME>] [-s <HOST>] [-u <credentials>] [-z <HOST>]";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        String solrInstallDir = System.getProperty("solr.install.dir");
        Path solrInstallDirPath = Paths.get(solrInstallDir, new String[0]);
        String confName = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-name", "confname", null);
        String confDir = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-dir", "confdir", null);
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            Path configsetsDirPath = SolrCLI.getConfigSetsDir(solrInstallDirPath);
            Path confPath = ConfigSetService.getConfigsetPath(confDir, configsetsDirPath.toString());
            this.echo("Uploading " + String.valueOf(confPath.toAbsolutePath()) + " for config " + confName + " to ZooKeeper at " + zkHost);
            FileTypeMagicUtil.assertConfigSetFolderLegal(confPath);
            ZkMaintenanceUtils.uploadToZK((SolrZkClient)zkClient, (Path)confPath, (String)("/configs/" + confName), (Pattern)ZkMaintenanceUtils.UPLOAD_FILENAME_EXCLUDE_PATTERN);
        }
        catch (Exception e) {
            log.error("Could not complete upconfig operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

