/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class EnvUtils {
    private static final Map<String, String> CUSTOM_MAPPINGS = new HashMap<String, String>();
    private static final Map<String, String> camelCaseToDotsMap = new ConcurrentHashMap<String, String>();

    public static SortedMap<String, String> getProperties() {
        return System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString(), (e1, e2) -> e1, TreeMap::new));
    }

    public static String getProperty(String key) {
        return EnvUtils.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = EnvUtils.getPropertyWithCamelCaseFallback(key);
        return value != null ? value : defaultValue;
    }

    private static String getPropertyWithCamelCaseFallback(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        String altKey = EnvUtils.camelCaseToDotSeparated(key);
        return System.getProperty(altKey);
    }

    private static String camelCaseToDotSeparated(String key) {
        return camelCaseToDotsMap.computeIfAbsent(key, k -> String.join((CharSequence)".", k.split("(?=[A-Z])")).replace("..", ".").toLowerCase(Locale.ROOT));
    }

    public static Integer getPropertyAsInteger(String key) {
        return EnvUtils.getPropertyAsInteger(key, null);
    }

    public static Integer getPropertyAsInteger(String key, Integer defaultValue) {
        String value = EnvUtils.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Long getPropertyAsLong(String key) {
        return EnvUtils.getPropertyAsLong(key, null);
    }

    public static Long getPropertyAsLong(String key, Long defaultValue) {
        String value = EnvUtils.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static Boolean getPropertyAsBool(String key) {
        return EnvUtils.getPropertyAsBool(key, null);
    }

    public static Boolean getPropertyAsBool(String key, Boolean defaultValue) {
        String value = EnvUtils.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return StrUtils.parseBool(value);
    }

    public static List<String> getPropertyAsList(String key) {
        return EnvUtils.getPropertyAsList(key, null);
    }

    public static List<String> getPropertyAsList(String key, List<String> defaultValue) {
        return EnvUtils.getProperty(key) != null ? EnvUtils.stringValueToList(EnvUtils.getProperty(key)) : defaultValue;
    }

    public static void setProperty(String key, String value) {
        System.setProperty(key, value);
        System.setProperty(EnvUtils.camelCaseToDotSeparated(key), value);
    }

    static synchronized void init(boolean overwrite, Map<String, String> env) {
        for (String key : env.keySet()) {
            String sysPropKey;
            if (!key.startsWith("SOLR_") && !CUSTOM_MAPPINGS.containsKey(key) || (sysPropKey = EnvUtils.envNameToSyspropName(key)).isBlank() || !overwrite && EnvUtils.getProperty(sysPropKey, null) != null) continue;
            EnvUtils.setProperty(sysPropKey, env.get(key));
        }
    }

    protected static String envNameToSyspropName(String envName) {
        return CUSTOM_MAPPINGS.containsKey(envName) ? CUSTOM_MAPPINGS.get(envName) : envName.toLowerCase(Locale.ROOT).replace("_", ".");
    }

    private static List<String> stringValueToList(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            return (List)Utils.fromJSONString(string);
        }
        return StrUtils.splitSmart(string, ",", true).stream().map(String::trim).collect(Collectors.toList());
    }

    static {
        try {
            Properties props = new Properties();
            try (InputStream stream = EnvUtils.class.getClassLoader().getResourceAsStream("EnvToSyspropMappings.properties");){
                props.load(new InputStreamReader(Objects.requireNonNull(stream), StandardCharsets.UTF_8));
                for (String key : props.stringPropertyNames()) {
                    CUSTOM_MAPPINGS.put(key, props.getProperty(key));
                }
                EnvUtils.init(false, System.getenv());
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Failed loading env.var->properties mapping", (Throwable)e);
        }
    }
}

