
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarkitem_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BookmarkItem_Type = nullptr;
static PyTypeObject *Sbk_BookmarkItem_TypeF(void)
{
    return _Sbk_BookmarkItem_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void BookmarkItemWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::BookmarkItem::Type >("BookmarkItem::Type");
}

void BookmarkItemWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

BookmarkItemWrapper::BookmarkItemWrapper(::BookmarkItem::Type type, ::BookmarkItem * parent) : BookmarkItem(type, parent)
{
}

void BookmarkItemWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("BookmarkItem", funcName, gil, pyOverride, event);
}

void BookmarkItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarkItem", funcName, gil, pyOverride, signal);
}

void BookmarkItemWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("BookmarkItem", funcName, gil, pyOverride, event);
}

void BookmarkItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BookmarkItem", funcName, gil, pyOverride, signal);
}

bool BookmarkItemWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("BookmarkItem", funcName, gil, pyOverride, event);
}

bool BookmarkItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("BookmarkItem", funcName, gil, pyOverride, watched, event);
}

void BookmarkItemWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BookmarkItem_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("BookmarkItem", funcName, gil, pyOverride, event);
}

const QMetaObject *BookmarkItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return BookmarkItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BookmarkItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = BookmarkItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BookmarkItemWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< BookmarkItemWrapper *>(this));
    }
    return BookmarkItem::qt_metacast(_clname);
}

BookmarkItemWrapper::~BookmarkItemWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_BookmarkItem_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarkItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarkItem >()))
        return -1;

    BookmarkItemWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:BookmarkItem", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: BookmarkItem::BookmarkItem(BookmarkItem::Type,BookmarkItem*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
            overloadId = 0; // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);
            }
        }
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::BookmarkItem *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) BookmarkItemWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new BookmarkItemWrapper(cppArg0, cppArg1);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< BookmarkItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);
    };


    return 1;
}

static PyObject *Sbk_BookmarkItemFunc_addChild(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addChild", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addChild", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BookmarkItem::addChild(BookmarkItem*,int=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addChild(BookmarkItem*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // addChild(BookmarkItem*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addChild", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"index", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addChild", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addChild(BookmarkItem*,int)
            cppSelf->addChild(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_children(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // children()const
        QList<BookmarkItem*> cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->children();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // description()const
        QString cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->description();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()
        QIcon cppResult = cppSelf->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_isExpanded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isExpanded()const
        bool cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->isExpanded();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_isFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFolder()const
        bool cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->isFolder();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_isSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSeparator()const
        bool cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->isSeparator();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_isSidebarExpanded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSidebarExpanded()const
        bool cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->isSidebarExpanded();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_isUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isUrl()const
        bool cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->isUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_keyword(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // keyword()const
        QString cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->keyword();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // parent()const
        BookmarkItem * cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->parent();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);

        // Ownership transferences.
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_removeChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::removeChild(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // removeChild(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeChild", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeChild(BookmarkItem*)
            cppSelf->removeChild(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setDescription(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDescription", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDescription(QString)
            cppSelf->setDescription(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setExpanded(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setExpanded(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setExpanded", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setExpanded(bool)
            cppSelf->setExpanded(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setKeyword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setKeyword(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setKeyword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setKeyword", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeyword(QString)
            cppSelf->setKeyword(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setSidebarExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setSidebarExpanded(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSidebarExpanded(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSidebarExpanded", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSidebarExpanded(bool)
            cppSelf->setSidebarExpanded(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTitle", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setType(BookmarkItem::Type)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setType(BookmarkItem::Type)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setType", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setType(BookmarkItem::Type)
            cppSelf->setType(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUrl", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_setVisitCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setVisitCount(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVisitCount(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setVisitCount", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setVisitCount(int)
            cppSelf->setVisitCount(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        QString cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // type()const
        BookmarkItem::Type cppResult = BookmarkItem::Type(const_cast<const BookmarkItemWrapper *>(cppSelf)->type());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_typeFromString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarkItem::typeFromString(QString)->BookmarkItem::Type
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // typeFromString(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "typeFromString", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // typeFromString(QString)
            BookmarkItem::Type cppResult = BookmarkItem::Type(::BookmarkItem::typeFromString(cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_typeToString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarkItem::typeToString(BookmarkItem::Type)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // typeToString(BookmarkItem::Type)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "typeToString", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]);

    // Call function/method
    {
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // typeToString(BookmarkItem::Type)
            QString cppResult = ::BookmarkItem::typeToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_updateVisitCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateVisitCount()
        cppSelf->updateVisitCount();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarkItemFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // url()const
        QUrl cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->url();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_urlString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // urlString()const
        QString cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->urlString();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarkItemFunc_visitCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarkItemWrapper *>(reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // visitCount()const
        int cppResult = const_cast<const BookmarkItemWrapper *>(cppSelf)->visitCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_BookmarkItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_BookmarkItem_EnumFlagInfo[] = {
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarkItem_methods[] = {
    {"addChild", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_addChild), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"children", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_children), METH_NOARGS, nullptr},
    {"description", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_description), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_icon), METH_NOARGS, nullptr},
    {"isExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isExpanded), METH_NOARGS, nullptr},
    {"isFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isFolder), METH_NOARGS, nullptr},
    {"isSeparator", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isSeparator), METH_NOARGS, nullptr},
    {"isSidebarExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isSidebarExpanded), METH_NOARGS, nullptr},
    {"isUrl", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isUrl), METH_NOARGS, nullptr},
    {"keyword", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_keyword), METH_NOARGS, nullptr},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_parent), METH_NOARGS, nullptr},
    {"removeChild", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_removeChild), METH_O, nullptr},
    {"setDescription", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setDescription), METH_O, nullptr},
    {"setExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setExpanded), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setIcon), METH_O, nullptr},
    {"setKeyword", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setKeyword), METH_O, nullptr},
    {"setSidebarExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setSidebarExpanded), METH_O, nullptr},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setTitle), METH_O, nullptr},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setType), METH_O, nullptr},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setUrl), METH_O, nullptr},
    {"setVisitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setVisitCount), METH_O, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_title), METH_NOARGS, nullptr},
    {"type", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_type), METH_NOARGS, nullptr},
    {"typeFromString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_typeFromString), METH_O|METH_STATIC, nullptr},
    {"typeToString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_typeToString), METH_O|METH_STATIC, nullptr},
    {"updateVisitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_updateVisitCount), METH_NOARGS, nullptr},
    {"url", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_url), METH_NOARGS, nullptr},
    {"urlString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_urlString), METH_NOARGS, nullptr},
    {"visitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_visitCount), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_BookmarkItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<BookmarkItemWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_BookmarkItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BookmarkItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BookmarkItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_BookmarkItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarkItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarkItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarkItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarkItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarkItem_spec = {
    "1:PyFalkon.BookmarkItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarkItem_slots
};

} //extern "C"

static void *Sbk_BookmarkItem_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::BookmarkItem *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_BookmarkItem_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::BookmarkItem::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::BookmarkItem::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_BookmarkItem_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX])))
        return Enum_PythonToCpp_BookmarkItem_Type;
    return {};
}

static PyObject *BookmarkItem_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::BookmarkItem::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::BookmarkItem::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarkItem_PythonToCpp_BookmarkItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarkItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarkItem_PythonToCpp_BookmarkItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BookmarkItem_TypeF()))
        return BookmarkItem_PythonToCpp_BookmarkItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarkItem_PTR_CppToPython_BookmarkItem(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::BookmarkItem *>(const_cast<void *>(cppIn)), Sbk_BookmarkItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BookmarkItem_SignatureStrings[] = {
    "PyFalkon.BookmarkItem(self,type:PyFalkon.BookmarkItem.Type,parent:PyFalkon.BookmarkItem=nullptr)",
    "PyFalkon.BookmarkItem.addChild(self,child:PyFalkon.BookmarkItem,index:int=-1)",
    "PyFalkon.BookmarkItem.children(self)->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.BookmarkItem.description(self)->QString",
    "PyFalkon.BookmarkItem.icon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.BookmarkItem.isExpanded(self)->bool",
    "PyFalkon.BookmarkItem.isFolder(self)->bool",
    "PyFalkon.BookmarkItem.isSeparator(self)->bool",
    "PyFalkon.BookmarkItem.isSidebarExpanded(self)->bool",
    "PyFalkon.BookmarkItem.isUrl(self)->bool",
    "PyFalkon.BookmarkItem.keyword(self)->QString",
    "PyFalkon.BookmarkItem.parent(self)->PyFalkon.BookmarkItem",
    "PyFalkon.BookmarkItem.removeChild(self,child:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarkItem.setDescription(self,description:QString)",
    "PyFalkon.BookmarkItem.setExpanded(self,expanded:bool)",
    "PyFalkon.BookmarkItem.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.BookmarkItem.setKeyword(self,keyword:QString)",
    "PyFalkon.BookmarkItem.setSidebarExpanded(self,expanded:bool)",
    "PyFalkon.BookmarkItem.setTitle(self,title:QString)",
    "PyFalkon.BookmarkItem.setType(self,type:PyFalkon.BookmarkItem.Type)",
    "PyFalkon.BookmarkItem.setUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.BookmarkItem.setVisitCount(self,count:int)",
    "PyFalkon.BookmarkItem.title(self)->QString",
    "PyFalkon.BookmarkItem.type(self)->PyFalkon.BookmarkItem.Type",
    "PyFalkon.BookmarkItem.typeFromString(string:QString)->PyFalkon.BookmarkItem.Type",
    "PyFalkon.BookmarkItem.typeToString(type:PyFalkon.BookmarkItem.Type)->QString",
    "PyFalkon.BookmarkItem.updateVisitCount(self)",
    "PyFalkon.BookmarkItem.url(self)->PySide6.QtCore.QUrl",
    "PyFalkon.BookmarkItem.urlString(self)->QString",
    "PyFalkon.BookmarkItem.visitCount(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t BookmarkItem_SignatureByteSize = 412;
static constexpr uint8_t BookmarkItem_SignatureBytes[412] = {
    0x78, 0xda, 0x9d, 0x54, 0x3d, 0x6f, 0x83, 0x30, 0x10, 0xdd, 0xfb, 0x2b, 0x32, 0x26, 0x92, 0x83,
    0xd4, 0xa5, 0x03, 0x52, 0x32, 0x34, 0x6d, 0xaa, 0xa8, 0x1d, 0x40, 0x49, 0xba, 0x44, 0x19, 0x1c,
    0x7c, 0x6d, 0x2d, 0x0c, 0x46, 0xe6, 0x48, 0xc3, 0xbf, 0xaf, 0x21, 0x10, 0x52, 0x64, 0x13, 0xb7,
    0x13, 0x06, 0xbf, 0x77, 0x1f, 0xef, 0x1e, 0x17, 0x94, 0x4b, 0x2a, 0x62, 0x99, 0x7a, 0x8f, 0x52,
    0xc6, 0x09, 0x55, 0xf1, 0x0a, 0x21, 0x19, 0xe7, 0x20, 0x3e, 0x08, 0x96, 0x19, 0xf8, 0x81, 0xe9,
    0xde, 0xdb, 0xe8, 0x2b, 0x92, 0x51, 0x05, 0x29, 0x9a, 0x11, 0xb3, 0xb4, 0x10, 0x22, 0x43, 0x35,
    0xb9, 0x33, 0x07, 0xa0, 0x8c, 0x2d, 0xbe, 0xb8, 0x60, 0xe7, 0x4c, 0x51, 0x75, 0x34, 0x07, 0x22,
    0x3c, 0x65, 0x70, 0xf2, 0x79, 0x8a, 0xb3, 0xe9, 0xbd, 0x2d, 0x5a, 0xcd, 0xd7, 0xc5, 0xd4, 0xd1,
    0x26, 0xd3, 0x79, 0xf8, 0xc6, 0x73, 0xdc, 0x19, 0xb1, 0x7b, 0x4b, 0x08, 0x06, 0x79, 0xa4, 0x78,
    0x86, 0x5c, 0x76, 0x51, 0xd6, 0xa8, 0x78, 0xfa, 0x69, 0x21, 0xf0, 0xa8, 0x43, 0x06, 0xe5, 0x9a,
    0x33, 0x78, 0xf0, 0x42, 0x7c, 0x29, 0xb8, 0x17, 0xae, 0xf4, 0x95, 0x8d, 0x95, 0x3f, 0x9f, 0x32,
    0xaa, 0x5b, 0x62, 0x2d, 0xf7, 0x20, 0xa5, 0xb0, 0x82, 0x97, 0x52, 0x30, 0x50, 0x4e, 0xd0, 0x35,
    0xe8, 0x79, 0x50, 0x94, 0x8e, 0x68, 0x5d, 0xef, 0x81, 0xaa, 0x3f, 0x15, 0xb3, 0x55, 0xc2, 0x01,
    0x17, 0x43, 0xf9, 0x2d, 0x15, 0x73, 0x13, 0xf1, 0x6c, 0xa1, 0x4e, 0x46, 0x03, 0xc6, 0xc2, 0x54,
    0x90, 0xc8, 0x23, 0xb8, 0x79, 0xc8, 0x66, 0x9b, 0x1c, 0xf0, 0xa9, 0x37, 0x76, 0x72, 0xe5, 0x03,
    0xbf, 0xa9, 0x7d, 0x80, 0xfe, 0x4b, 0x3f, 0x02, 0xcd, 0x9b, 0x5f, 0xc9, 0x33, 0xc0, 0x5a, 0xb5,
    0xd6, 0x21, 0x95, 0x89, 0x7c, 0xfd, 0x9f, 0xe9, 0x2c, 0xde, 0x36, 0xd5, 0x39, 0x77, 0x06, 0x2b,
    0x91, 0x51, 0xef, 0x63, 0xc0, 0x4f, 0x09, 0xcd, 0xf6, 0x03, 0x19, 0x5e, 0xaf, 0x86, 0x40, 0x9a,
    0x89, 0x38, 0xb4, 0x63, 0x72, 0x85, 0x73, 0x57, 0x1b, 0x8e, 0x02, 0x9a, 0xcd, 0x51, 0x1d, 0x1d,
    0xf2, 0x55, 0x6b, 0xc4, 0x69, 0xd7, 0x0c, 0xc4, 0x68, 0x5d, 0x49, 0x0a, 0x25, 0x6c, 0x52, 0x2e,
    0xa4, 0x02, 0x2f, 0xd4, 0x48, 0x32, 0x6a, 0x8a, 0x1a, 0x12, 0xef, 0x9d, 0xe7, 0x5c, 0x53, 0x8a,
    0xc6, 0x98, 0x24, 0xaa, 0x8e, 0xd5, 0x06, 0xb2, 0x71, 0xf0, 0xd2, 0xf9, 0x4d, 0xc3, 0x63, 0xdb,
    0xb1, 0xcd, 0xee, 0x75, 0xbb, 0x03, 0xe4, 0xa5, 0x92, 0xc9, 0x39, 0xc3, 0x38, 0xaf, 0x1f, 0x17,
    0x99, 0xff, 0x19, 0x70, 0x23, 0x9b, 0x70, 0xb7, 0x46, 0x70, 0xab, 0xb5, 0x22, 0x63, 0x14, 0xa1,
    0x27, 0x9e, 0x4d, 0xb2, 0xa2, 0xdb, 0x25, 0x86, 0x31, 0xd9, 0x49, 0x6d, 0xeb, 0x2e, 0x5a, 0x1f,
    0x7b, 0xa5, 0x4c, 0xe7, 0x7a, 0x86, 0x77, 0x3f, 0x7f, 0x39, 0x8e, 0xb2
};
#endif

PyTypeObject *init_BookmarkItem(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX].type;

    Shiboken::AutoDecRef Sbk_BookmarkItem_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_BookmarkItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarkItem",
        "BookmarkItem*",
        &Sbk_BookmarkItem_spec,
        &Shiboken::callCppDestructor< BookmarkItem >,
        Sbk_BookmarkItem_Type_bases.object(),
        0);
    auto *pyType = Sbk_BookmarkItem_TypeF(); // references _Sbk_BookmarkItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BookmarkItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, BookmarkItem_SignatureBytes, BookmarkItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BookmarkItem_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BookmarkItem_PythonToCpp_BookmarkItem_PTR,
        is_BookmarkItem_PythonToCpp_BookmarkItem_PTR_Convertible,
        BookmarkItem_PTR_CppToPython_BookmarkItem);

    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem");
    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarkItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(BookmarkItemWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_BookmarkItem_TypeF(), &Sbk_BookmarkItem_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_BookmarkItem_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "Root",
        "Url",
        "Folder",
        "Separator",
        "Invalid",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(BookmarkItem::Type::Root),      //  0x00  0
        uint8_t(BookmarkItem::Type::Url),       //  0x01  1
        uint8_t(BookmarkItem::Type::Folder),    //  0x02  2
        uint8_t(BookmarkItem::Type::Separator), //  0x03  3
        uint8_t(BookmarkItem::Type::Invalid)    //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_BookmarkItem_TypeF(),
        "1:PyFalkon.BookmarkItem.Type",
        Type_Initializer, Type_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_BookmarkItem_Type_IDX].type = EType;
    // Register converter for enum 'BookmarkItem::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            BookmarkItem_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_BookmarkItem_Type,
            is_Enum_PythonToCpp_BookmarkItem_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "BookmarkItem::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    BookmarkItemWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::BookmarkItem::staticMetaObject, sizeof(BookmarkItemWrapper));

    return pyType;
}
