// This file was generated by qtwaylandscanner
// source file is xx-session-management-v1.xml

#ifndef QT_WAYLAND_SERVER_XX_SESSION_MANAGEMENT_V1
#define QT_WAYLAND_SERVER_XX_SESSION_MANAGEMENT_V1

#include "wayland-server-core.h"
#include "wayland-xx-session-management-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  xx_session_manager_v1
    {
    public:
        xx_session_manager_v1(struct ::wl_client *client, int id, int version);
        xx_session_manager_v1(struct ::wl_display *display, int version);
        xx_session_manager_v1(struct ::wl_resource *resource);
        xx_session_manager_v1();

        virtual ~xx_session_manager_v1();

        class Resource
        {
        public:
            Resource() : xx_session_manager_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            xx_session_manager_v1 *xx_session_manager_v1_object;
            xx_session_manager_v1 *object() { return xx_session_manager_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_in_use = 1, // a requested session is already in use
        };

        enum reason {
            reason_launch = 1,
            reason_recover = 2,
            reason_session_restore = 3,
        };

    protected:
        virtual Resource *xx_session_manager_v1_allocate();

        virtual void xx_session_manager_v1_destroy_global();

        virtual void xx_session_manager_v1_bind_resource(Resource *resource);
        virtual void xx_session_manager_v1_destroy_resource(Resource *resource);

        virtual void xx_session_manager_v1_destroy(Resource *resource);
        virtual void xx_session_manager_v1_get_session(Resource *resource, uint32_t id, uint32_t reason, const QString &session);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::xx_session_manager_v1_interface m_xx_session_manager_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_session(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t reason,
            const char *session);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            xx_session_manager_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  xx_session_v1
    {
    public:
        xx_session_v1(struct ::wl_client *client, int id, int version);
        xx_session_v1(struct ::wl_display *display, int version);
        xx_session_v1(struct ::wl_resource *resource);
        xx_session_v1();

        virtual ~xx_session_v1();

        class Resource
        {
        public:
            Resource() : xx_session_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            xx_session_v1 *xx_session_v1_object;
            xx_session_v1 *object() { return xx_session_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_invalid_restore = 1, // restore cannot be performed after initial toplevel commit
            error_name_in_use = 2, // toplevel name is already in used
            error_already_mapped = 3, // toplevel was already mapped when restored
        };

        void send_created(const QString &id);
        void send_created(struct ::wl_resource *resource, const QString &id);
        void send_restored();
        void send_restored(struct ::wl_resource *resource);
        void send_replaced();
        void send_replaced(struct ::wl_resource *resource);

    protected:
        virtual Resource *xx_session_v1_allocate();

        virtual void xx_session_v1_destroy_global();

        virtual void xx_session_v1_bind_resource(Resource *resource);
        virtual void xx_session_v1_destroy_resource(Resource *resource);

        virtual void xx_session_v1_destroy(Resource *resource);
        virtual void xx_session_v1_remove(Resource *resource);
        virtual void xx_session_v1_add_toplevel(Resource *resource, uint32_t id, struct ::wl_resource *toplevel, const QString &name);
        virtual void xx_session_v1_restore_toplevel(Resource *resource, uint32_t id, struct ::wl_resource *toplevel, const QString &name);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::xx_session_v1_interface m_xx_session_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_remove(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_add_toplevel(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *toplevel,
            const char *name);
        static void handle_restore_toplevel(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *toplevel,
            const char *name);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            xx_session_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  xx_toplevel_session_v1
    {
    public:
        xx_toplevel_session_v1(struct ::wl_client *client, int id, int version);
        xx_toplevel_session_v1(struct ::wl_display *display, int version);
        xx_toplevel_session_v1(struct ::wl_resource *resource);
        xx_toplevel_session_v1();

        virtual ~xx_toplevel_session_v1();

        class Resource
        {
        public:
            Resource() : xx_toplevel_session_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            xx_toplevel_session_v1 *xx_toplevel_session_v1_object;
            xx_toplevel_session_v1 *object() { return xx_toplevel_session_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_restored(struct ::wl_resource *surface);
        void send_restored(struct ::wl_resource *resource, struct ::wl_resource *surface);

    protected:
        virtual Resource *xx_toplevel_session_v1_allocate();

        virtual void xx_toplevel_session_v1_destroy_global();

        virtual void xx_toplevel_session_v1_bind_resource(Resource *resource);
        virtual void xx_toplevel_session_v1_destroy_resource(Resource *resource);

        virtual void xx_toplevel_session_v1_destroy(Resource *resource);
        virtual void xx_toplevel_session_v1_remove(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::xx_toplevel_session_v1_interface m_xx_toplevel_session_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_remove(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            xx_toplevel_session_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
