// components/services/storage/public/mojom/blob_storage_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-params-data.h"
namespace storage {
namespace mojom {

NOINLINE static const char* BlobDataItemTypeToStringHelper(BlobDataItemType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BlobDataItemType::kUnknown:
      return "kUnknown";
    case BlobDataItemType::kCacheStorage:
      return "kCacheStorage";
    case BlobDataItemType::kIndexedDB:
      return "kIndexedDB";
    default:
      return nullptr;
  }
}

std::string BlobDataItemTypeToString(BlobDataItemType value) {
  const char *str = BlobDataItemTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BlobDataItemType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BlobDataItemType value) {
  return os << BlobDataItemTypeToString(value);
}

NOINLINE static const char* WriteBlobToFileResultToStringHelper(WriteBlobToFileResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WriteBlobToFileResult::kError:
      return "kError";
    case WriteBlobToFileResult::kBadPath:
      return "kBadPath";
    case WriteBlobToFileResult::kInvalidBlob:
      return "kInvalidBlob";
    case WriteBlobToFileResult::kIOError:
      return "kIOError";
    case WriteBlobToFileResult::kTimestampError:
      return "kTimestampError";
    case WriteBlobToFileResult::kSuccess:
      return "kSuccess";
    default:
      return nullptr;
  }
}

std::string WriteBlobToFileResultToString(WriteBlobToFileResult value) {
  const char *str = WriteBlobToFileResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WriteBlobToFileResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WriteBlobToFileResult value) {
  return os << WriteBlobToFileResultToString(value);
}

namespace internal {


// static
bool BlobDataItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobDataItem_Data* object =
      static_cast<const BlobDataItem_Data*>(data);


  if (!::storage::mojom::internal::BlobDataItemType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_type, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_type, validation_context,
                                         &content_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->reader, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->reader,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BlobDataItem_Data::BlobDataItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobDataItemReader_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobDataItemReader_Read_Params_Data* object =
      static_cast<const BlobDataItemReader_Read_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pipe, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BlobDataItemReader_Read_Params_Data::BlobDataItemReader_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobDataItemReader_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobDataItemReader_Read_ResponseParams_Data* object =
      static_cast<const BlobDataItemReader_Read_ResponseParams_Data*>(data);

  return true;
}

BlobDataItemReader_Read_ResponseParams_Data::BlobDataItemReader_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobDataItemReader_ReadSideData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobDataItemReader_ReadSideData_Params_Data* object =
      static_cast<const BlobDataItemReader_ReadSideData_Params_Data*>(data);

  return true;
}

BlobDataItemReader_ReadSideData_Params_Data::BlobDataItemReader_ReadSideData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobDataItemReader_ReadSideData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobDataItemReader_ReadSideData_ResponseParams_Data* object =
      static_cast<const BlobDataItemReader_ReadSideData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

BlobDataItemReader_ReadSideData_ResponseParams_Data::BlobDataItemReader_ReadSideData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobStorageContext_RegisterFromDataItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobStorageContext_RegisterFromDataItem_Params_Data* object =
      static_cast<const BlobStorageContext_RegisterFromDataItem_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& uuid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->uuid, validation_context,
                                         &uuid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

BlobStorageContext_RegisterFromDataItem_Params_Data::BlobStorageContext_RegisterFromDataItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobStorageContext_RegisterFromMemory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobStorageContext_RegisterFromMemory_Params_Data* object =
      static_cast<const BlobStorageContext_RegisterFromMemory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& uuid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->uuid, validation_context,
                                         &uuid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

BlobStorageContext_RegisterFromMemory_Params_Data::BlobStorageContext_RegisterFromMemory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobStorageContext_WriteBlobToFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobStorageContext_WriteBlobToFile_Params_Data* object =
      static_cast<const BlobStorageContext_WriteBlobToFile_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  return true;
}

BlobStorageContext_WriteBlobToFile_Params_Data::BlobStorageContext_WriteBlobToFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobStorageContext_WriteBlobToFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobStorageContext_WriteBlobToFile_ResponseParams_Data* object =
      static_cast<const BlobStorageContext_WriteBlobToFile_ResponseParams_Data*>(data);


  if (!::storage::mojom::internal::WriteBlobToFileResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

BlobStorageContext_WriteBlobToFile_ResponseParams_Data::BlobStorageContext_WriteBlobToFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlobStorageContext_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlobStorageContext_Clone_Params_Data* object =
      static_cast<const BlobStorageContext_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BlobStorageContext_Clone_Params_Data::BlobStorageContext_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::BlobDataItemType>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::BlobDataItemType value) {
  return std::move(context).WriteString(::storage::mojom::BlobDataItemTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::WriteBlobToFileResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::WriteBlobToFileResult value) {
  return std::move(context).WriteString(::storage::mojom::WriteBlobToFileResultToString(value));
}

} // namespace perfetto