// content/browser/indexed_db/indexed_db_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/indexed_db/indexed_db_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-params-data.h"
namespace storage {
namespace mojom {

namespace internal {


// static
bool IdbPartitionMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbPartitionMetadata_Data* object =
      static_cast<const IdbPartitionMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partition_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->partition_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_list, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origin_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origin_list, validation_context,
                                         &origin_list_validate_params)) {
    return false;
  }

  return true;
}

IdbPartitionMetadata_Data::IdbPartitionMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data* object =
      static_cast<const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data*>(data);

  return true;
}

IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partitions, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& partitions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->partitions, validation_context,
                                         &partitions_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_DownloadBucketData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_DownloadBucketData_Params_Data* object =
      static_cast<const IdbInternalsHandler_DownloadBucketData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucketId, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucketId, validation_context))
    return false;

  return true;
}

IdbInternalsHandler_DownloadBucketData_Params_Data::IdbInternalsHandler_DownloadBucketData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_DownloadBucketData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_DownloadBucketData_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_DownloadBucketData_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_DownloadBucketData_ResponseParams_Data::IdbInternalsHandler_DownloadBucketData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_ForceClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_ForceClose_Params_Data* object =
      static_cast<const IdbInternalsHandler_ForceClose_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucketId, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucketId, validation_context))
    return false;

  return true;
}

IdbInternalsHandler_ForceClose_Params_Data::IdbInternalsHandler_ForceClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_ForceClose_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_ForceClose_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_ForceClose_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_ForceClose_ResponseParams_Data::IdbInternalsHandler_ForceClose_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_StartMetadataRecording_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_StartMetadataRecording_Params_Data* object =
      static_cast<const IdbInternalsHandler_StartMetadataRecording_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_id, validation_context))
    return false;

  return true;
}

IdbInternalsHandler_StartMetadataRecording_Params_Data::IdbInternalsHandler_StartMetadataRecording_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data::IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_StopMetadataRecording_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_StopMetadataRecording_Params_Data* object =
      static_cast<const IdbInternalsHandler_StopMetadataRecording_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_id, validation_context))
    return false;

  return true;
}

IdbInternalsHandler_StopMetadataRecording_Params_Data::IdbInternalsHandler_StopMetadataRecording_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->metadata, validation_context,
                                         &metadata_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data::IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_InspectClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_InspectClient_Params_Data* object =
      static_cast<const IdbInternalsHandler_InspectClient_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_info, validation_context))
    return false;

  return true;
}

IdbInternalsHandler_InspectClient_Params_Data::IdbInternalsHandler_InspectClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdbInternalsHandler_InspectClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdbInternalsHandler_InspectClient_ResponseParams_Data* object =
      static_cast<const IdbInternalsHandler_InspectClient_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

IdbInternalsHandler_InspectClient_ResponseParams_Data::IdbInternalsHandler_InspectClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage