// content/common/media/media_log_records.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_
#define CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/media/media_log_records.mojom-features.h"  // IWYU pragma: export
#include "content/common/media/media_log_records.mojom-shared.h"  // IWYU pragma: export
#include "content/common/media/media_log_records.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class MediaInternalLogRecordsProxy;

template <typename ImplRefTraits>
class MediaInternalLogRecordsStub;

class MediaInternalLogRecordsRequestValidator;


class CONTENT_EXPORT MediaInternalLogRecords
    : public MediaInternalLogRecordsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaInternalLogRecordsInterfaceBase;
  using Proxy_ = MediaInternalLogRecordsProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaInternalLogRecordsStub<ImplRefTraits>;

  using RequestValidator_ = MediaInternalLogRecordsRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Log_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaInternalLogRecords() = default;

  
  virtual void Log(const std::vector<::media::MediaLogRecord>& events) = 0;
};



class CONTENT_EXPORT MediaInternalLogRecordsProxy
    : public MediaInternalLogRecords {
 public:
  using InterfaceType = MediaInternalLogRecords;

  explicit MediaInternalLogRecordsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Log(const std::vector<::media::MediaLogRecord>& events) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT MediaInternalLogRecordsStubDispatch {
 public:
  static bool Accept(MediaInternalLogRecords* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaInternalLogRecords* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaInternalLogRecords>>
class MediaInternalLogRecordsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaInternalLogRecordsStub() = default;
  ~MediaInternalLogRecordsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaInternalLogRecordsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaInternalLogRecordsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT MediaInternalLogRecordsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_