// services/network/public/mojom/proxy_resolving_socket.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  ProxyResolvingSocket_UpgradeToTLS_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::HostPortPair_Data> host_port_pair;
  mojo::internal::Pointer<::network::mojom::internal::MutableNetworkTrafficAnnotationTag_Data> traffic_annotation;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data observer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ProxyResolvingSocket_UpgradeToTLS_Params_Data>;

  ProxyResolvingSocket_UpgradeToTLS_Params_Data();
  ~ProxyResolvingSocket_UpgradeToTLS_Params_Data() = delete;
};
static_assert(sizeof(ProxyResolvingSocket_UpgradeToTLS_Params_Data) == 40,
              "Bad sizeof(ProxyResolvingSocket_UpgradeToTLS_Params_Data)");
class  ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  mojo::internal::Handle_Data receive_stream;
  mojo::internal::Handle_Data send_stream;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data>;

  ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data();
  ~ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data() = delete;
};
static_assert(sizeof(ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data) == 24,
              "Bad sizeof(ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data)");
class  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  ::network::mojom::internal::NetworkAnonymizationKey_Data network_anonymization_key;
  mojo::internal::Pointer<internal::ProxyResolvingSocketOptions_Data> options;
  mojo::internal::Pointer<::network::mojom::internal::MutableNetworkTrafficAnnotationTag_Data> traffic_annotation;
  mojo::internal::Handle_Data socket;
  mojo::internal::Interface_Data observer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data>;

  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data();
  ~ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data() = delete;
};
static_assert(sizeof(ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data) == 64,
              "Bad sizeof(ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data)");
class  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  mojo::internal::Handle_Data receive_stream;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> local_addr;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> peer_addr;
  mojo::internal::Handle_Data send_stream;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data>;

  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data();
  ~ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data() = delete;
};
static_assert(sizeof(ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data) == 40,
              "Bad sizeof(ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data)");

}  // namespace internal


class ProxyResolvingSocket_UpgradeToTLS_ParamsDataView {
 public:
  ProxyResolvingSocket_UpgradeToTLS_ParamsDataView() = default;

  ProxyResolvingSocket_UpgradeToTLS_ParamsDataView(
      internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostPortPairDataView(
      ::network::mojom::HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostPortPair(UserType* output) {
    
    auto* pointer = data_->host_port_pair.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::TLSClientSocketInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyResolvingSocket_UpgradeToTLS_ResponseParamsDataView {
 public:
  ProxyResolvingSocket_UpgradeToTLS_ResponseParamsDataView() = default;

  ProxyResolvingSocket_UpgradeToTLS_ResponseParamsDataView(
      internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
  mojo::ScopedDataPipeConsumerHandle TakeReceiveStream() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->receive_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeSendStream() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->send_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView {
 public:
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView() = default;

  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView(
      internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNetworkAnonymizationKeyDataView(
      ::network::mojom::NetworkAnonymizationKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkAnonymizationKey(UserType* output) {
    
    auto* pointer = !data_->network_anonymization_key.is_null() ? &data_->network_anonymization_key : nullptr;
    return mojo::internal::Deserialize<::network::mojom::NetworkAnonymizationKeyDataView>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      ProxyResolvingSocketOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ProxyResolvingSocketOptionsDataView, UserType>(),
    "Attempting to read the optional `options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOptions` instead "
    "of `ReadOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyResolvingSocketOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyResolvingSocketInterfaceBase>>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView {
 public:
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView() = default;

  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView(
      internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t result() const {
    return data_->result;
  }
  inline void GetLocalAddrDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalAddr(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::IPEndPointDataView, UserType>(),
    "Attempting to read the optional `local_addr` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalAddr` instead "
    "of `ReadLocalAddr if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetPeerAddrDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPeerAddr(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::IPEndPointDataView, UserType>(),
    "Attempting to read the optional `peer_addr` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPeerAddr` instead "
    "of `ReadPeerAddr if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->peer_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeReceiveStream() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->receive_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeSendStream() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->send_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ProxyResolvingSocket_UpgradeToTLS_ParamsDataView::GetHostPortPairDataView(
    ::network::mojom::HostPortPairDataView* output) {
  auto pointer = data_->host_port_pair.Get();
  *output = ::network::mojom::HostPortPairDataView(pointer, message_);
}
inline void ProxyResolvingSocket_UpgradeToTLS_ParamsDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}




inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView::GetNetworkAnonymizationKeyDataView(
    ::network::mojom::NetworkAnonymizationKeyDataView* output) {
  auto pointer = &data_->network_anonymization_key;
  *output = ::network::mojom::NetworkAnonymizationKeyDataView(pointer, message_);
}
inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView::GetOptionsDataView(
    ProxyResolvingSocketOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ProxyResolvingSocketOptionsDataView(pointer, message_);
}
inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}


inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView::GetLocalAddrDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->local_addr.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView::GetPeerAddrDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->peer_addr.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_PARAMS_DATA_H_