// components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-params-data.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared-message-ids.h"

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-import-headers.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-test-utils.h"


namespace discardable_memory::mojom {
const char DiscardableSharedMemoryManager::Name_[] = "discardable_memory.mojom.DiscardableSharedMemoryManager";

DiscardableSharedMemoryManager::IPCStableHashFunction DiscardableSharedMemoryManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DiscardableSharedMemoryManager>(message.name())) {
    case messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory: {
      return &DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory_Sym::IPCStableHash;
    }
    case messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory: {
      return &DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DiscardableSharedMemoryManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DiscardableSharedMemoryManager>(message.name())) {
      case messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory:
            return "Receive discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory";
      case messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory:
            return "Receive discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory";
    }
  } else {
    switch (static_cast<messages::DiscardableSharedMemoryManager>(message.name())) {
      case messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory:
            return "Receive reply discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory";
      case messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory:
            return "Receive reply discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback(
      DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback(const DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback&) = delete;
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback& operator=(const DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback_;
};

DiscardableSharedMemoryManagerProxy::DiscardableSharedMemoryManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DiscardableSharedMemoryManagerProxy::AllocateLockedDiscardableSharedMemory(
    uint32_t in_size, int32_t in_id, AllocateLockedDiscardableSharedMemoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  params->size = in_size;
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("AllocateLockedDiscardableSharedMemory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DiscardableSharedMemoryManagerProxy::DeletedDiscardableSharedMemory(
    int32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("DeletedDiscardableSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder> proxy(
        new DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::UnsafeSharedMemoryRegion in_region);
};

bool DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DiscardableSharedMemoryManager.0
  bool success = true;
  ::base::UnsafeSharedMemoryRegion p_region{};
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRegion(&p_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscardableSharedMemoryManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_region));
  return true;
}

void DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::Run(
    ::base::UnsafeSharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("AllocateLockedDiscardableSharedMemory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DiscardableSharedMemoryManagerStubDispatch::Accept(
    DiscardableSharedMemoryManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DiscardableSharedMemoryManager>(message->header()->name)) {
    case messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory: {
      break;
    }
    case messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory: {
      DCHECK(message->is_serialized());
      internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data* params =
          reinterpret_cast<internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DiscardableSharedMemoryManager.1
      bool success = true;
      int32_t p_id{};
      DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscardableSharedMemoryManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeletedDiscardableSharedMemory(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool DiscardableSharedMemoryManagerStubDispatch::AcceptWithResponder(
    DiscardableSharedMemoryManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DiscardableSharedMemoryManager>(message->header()->name)) {
    case messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory: {
      internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data* params =
          reinterpret_cast<
              internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DiscardableSharedMemoryManager.0
      bool success = true;
      uint32_t p_size{};
      int32_t p_id{};
      DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscardableSharedMemoryManager::Name_, 0, false);
        return false;
      }
      DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback =
          DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllocateLockedDiscardableSharedMemory(        
        std::move(p_size), 
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDiscardableSharedMemoryManagerValidationInfo[] = {
    {base::to_underlying(messages::DiscardableSharedMemoryManager::kAllocateLockedDiscardableSharedMemory),
     { &internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data::Validate,
      &internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::DiscardableSharedMemoryManager::kDeletedDiscardableSharedMemory),
     { &internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DiscardableSharedMemoryManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::discardable_memory::mojom::DiscardableSharedMemoryManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDiscardableSharedMemoryManagerValidationInfo);
}

bool DiscardableSharedMemoryManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::discardable_memory::mojom::DiscardableSharedMemoryManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDiscardableSharedMemoryManagerValidationInfo);

}


}  // discardable_memory::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace discardable_memory::mojom {


void DiscardableSharedMemoryManagerInterceptorForTesting::AllocateLockedDiscardableSharedMemory(uint32_t size, int32_t id, AllocateLockedDiscardableSharedMemoryCallback callback) {
  GetForwardingInterface()->AllocateLockedDiscardableSharedMemory(
    std::move(size)
    , 
    std::move(id)
    , std::move(callback));
}
void DiscardableSharedMemoryManagerInterceptorForTesting::DeletedDiscardableSharedMemory(int32_t id) {
  GetForwardingInterface()->DeletedDiscardableSharedMemory(
    std::move(id)
    );
}
DiscardableSharedMemoryManagerAsyncWaiter::DiscardableSharedMemoryManagerAsyncWaiter(
    DiscardableSharedMemoryManager* proxy) : proxy_(proxy) {}

DiscardableSharedMemoryManagerAsyncWaiter::~DiscardableSharedMemoryManagerAsyncWaiter() = default;

void DiscardableSharedMemoryManagerAsyncWaiter::AllocateLockedDiscardableSharedMemory(
    uint32_t size, int32_t id, ::base::UnsafeSharedMemoryRegion* out_region) {
  base::RunLoop loop;
  proxy_->AllocateLockedDiscardableSharedMemory(
      std::move(size),
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnsafeSharedMemoryRegion* out_region
,
             ::base::UnsafeSharedMemoryRegion region) {*out_region = std::move(region);
            loop->Quit();
          },
          &loop,
          out_region));
  loop.Run();
}

::base::UnsafeSharedMemoryRegion DiscardableSharedMemoryManagerAsyncWaiter::AllocateLockedDiscardableSharedMemory(
    uint32_t size, int32_t id) {
  ::base::UnsafeSharedMemoryRegion async_wait_result;
  AllocateLockedDiscardableSharedMemory(std::move(size),std::move(id),&async_wait_result);
  return async_wait_result;
}






}  // discardable_memory::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif