// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace storage::mojom {
namespace internal {
class IdbOriginMetadata_Data;
class IdbStorageKeyMetadata_Data;
class IdbBucketMetadata_Data;
class IdbDatabaseMetadata_Data;
class IdbTransactionMetadata_Data;
class IdbTransactionMetadataStateHistory_Data;

struct IdbTransactionMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IdbTransactionState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  IdbOriginMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IdbStorageKeyMetadata_Data>>> storage_keys;

 private:
  friend class mojo::internal::MessageFragment<IdbOriginMetadata_Data>;

  IdbOriginMetadata_Data();
  ~IdbOriginMetadata_Data() = delete;
};
static_assert(sizeof(IdbOriginMetadata_Data) == 24,
              "Bad sizeof(IdbOriginMetadata_Data)");
// Used by IdbOriginMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbOriginMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbOriginMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbOriginMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbOriginMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbOriginMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IdbStorageKeyMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::SchemefulSite_Data> top_level_site;
  mojo::internal::Pointer<mojo::internal::String_Data> serialized_storage_key;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IdbBucketMetadata_Data>>> buckets;

 private:
  friend class mojo::internal::MessageFragment<IdbStorageKeyMetadata_Data>;

  IdbStorageKeyMetadata_Data();
  ~IdbStorageKeyMetadata_Data() = delete;
};
static_assert(sizeof(IdbStorageKeyMetadata_Data) == 32,
              "Bad sizeof(IdbStorageKeyMetadata_Data)");
// Used by IdbStorageKeyMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbStorageKeyMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbStorageKeyMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbStorageKeyMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbStorageKeyMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbStorageKeyMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IdbBucketMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::storage::mojom::internal::BucketLocator_Data> bucket_locator;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  uint64_t size;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data>>> paths;
  uint64_t connection_count;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IdbDatabaseMetadata_Data>>> databases;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::storage::mojom::internal::BucketClientInfo_Data>>> clients;
  uint64_t delta_recording_start_ms;

 private:
  friend class mojo::internal::MessageFragment<IdbBucketMetadata_Data>;

  IdbBucketMetadata_Data();
  ~IdbBucketMetadata_Data() = delete;
};
static_assert(sizeof(IdbBucketMetadata_Data) == 80,
              "Bad sizeof(IdbBucketMetadata_Data)");
// Used by IdbBucketMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbBucketMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbBucketMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbBucketMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbBucketMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbBucketMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IdbDatabaseMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  uint64_t connection_count;
  uint64_t active_open_delete;
  uint64_t pending_open_delete;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IdbTransactionMetadata_Data>>> transactions;

 private:
  friend class mojo::internal::MessageFragment<IdbDatabaseMetadata_Data>;

  IdbDatabaseMetadata_Data();
  ~IdbDatabaseMetadata_Data() = delete;
};
static_assert(sizeof(IdbDatabaseMetadata_Data) == 48,
              "Bad sizeof(IdbDatabaseMetadata_Data)");
// Used by IdbDatabaseMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbDatabaseMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbDatabaseMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbDatabaseMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbDatabaseMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbDatabaseMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IdbTransactionMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t mode;
  int32_t state;
  int64_t tid;
  int32_t connection_id;
  uint8_t pad3_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> client_token;
  double age;
  double runtime;
  double tasks_scheduled;
  double tasks_completed;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> scope;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IdbTransactionMetadataStateHistory_Data>>> state_history;

 private:
  friend class mojo::internal::MessageFragment<IdbTransactionMetadata_Data>;

  IdbTransactionMetadata_Data();
  ~IdbTransactionMetadata_Data() = delete;
};
static_assert(sizeof(IdbTransactionMetadata_Data) == 88,
              "Bad sizeof(IdbTransactionMetadata_Data)");
// Used by IdbTransactionMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbTransactionMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbTransactionMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbTransactionMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbTransactionMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbTransactionMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IdbTransactionMetadataStateHistory_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t state;
  uint8_t pad0_[4];
  double duration;

 private:
  friend class mojo::internal::MessageFragment<IdbTransactionMetadataStateHistory_Data>;

  IdbTransactionMetadataStateHistory_Data();
  ~IdbTransactionMetadataStateHistory_Data() = delete;
};
static_assert(sizeof(IdbTransactionMetadataStateHistory_Data) == 24,
              "Bad sizeof(IdbTransactionMetadataStateHistory_Data)");
// Used by IdbTransactionMetadataStateHistory::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IdbTransactionMetadataStateHistory_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IdbTransactionMetadataStateHistory_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IdbTransactionMetadataStateHistory_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IdbTransactionMetadataStateHistory_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IdbTransactionMetadataStateHistory_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_INTERNAL_H_