// components/services/storage/public/mojom/partition.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/partition.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/partition.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/partition.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/local_storage_control.mojom-forward.h"
#include "components/services/storage/public/mojom/origin_context.mojom-forward.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-forward.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class PartitionProxy;

template <typename ImplRefTraits>
class PartitionStub;

class PartitionRequestValidator;


class Partition
    : public PartitionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PartitionInterfaceBase;
  using Proxy_ = PartitionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PartitionStub<ImplRefTraits>;

  using RequestValidator_ = PartitionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindOriginContextMinVersion = 0,
    kBindSessionStorageControlMinVersion = 0,
    kBindLocalStorageControlMinVersion = 0,
    kBindServiceWorkerStorageControlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindOriginContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSessionStorageControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLocalStorageControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindServiceWorkerStorageControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Partition() = default;

  
  virtual void BindOriginContext(const ::url::Origin& origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> receiver) = 0;

  
  virtual void BindSessionStorageControl(::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) = 0;

  
  virtual void BindLocalStorageControl(::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) = 0;

  
  virtual void BindServiceWorkerStorageControl(::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl> receiver) = 0;
};



class  PartitionProxy
    : public Partition {
 public:
  using InterfaceType = Partition;

  explicit PartitionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindOriginContext(const ::url::Origin& origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> receiver) final;
  
  void BindSessionStorageControl(::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) final;
  
  void BindLocalStorageControl(::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) final;
  
  void BindServiceWorkerStorageControl(::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PartitionStubDispatch {
 public:
  static bool Accept(Partition* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Partition* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Partition>>
class PartitionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PartitionStub() = default;
  ~PartitionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PartitionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PartitionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PartitionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_