// extensions/common/mojom/stack_frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/stack_frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/stack_frame.mojom-params-data.h"
#include "extensions/common/mojom/stack_frame.mojom-shared-message-ids.h"

#include "extensions/common/mojom/stack_frame.mojom-import-headers.h"
#include "extensions/common/mojom/stack_frame.mojom-test-utils.h"


namespace extensions::mojom {
StackFrame::StackFrame()
    : line_number(),
      column_number(),
      source(),
      function() {}

StackFrame::StackFrame(
    uint32_t line_number_in,
    uint32_t column_number_in,
    const ::std::u16string& source_in,
    const ::std::u16string& function_in)
    : line_number(std::move(line_number_in)),
      column_number(std::move(column_number_in)),
      source(std::move(source_in)),
      function(std::move(function_in)) {}

StackFrame::~StackFrame() = default;

void StackFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line_number"), this->line_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column_number"), this->column_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "function"), this->function,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StackFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::StackFrame::DataView, ::extensions::mojom::StackFramePtr>::Read(
    ::extensions::mojom::StackFrame::DataView input,
    ::extensions::mojom::StackFramePtr* output) {
  bool success = true;
  ::extensions::mojom::StackFramePtr result(::extensions::mojom::StackFrame::New());
  
      if (success)
        result->line_number = input.line_number();
      if (success)
        result->column_number = input.column_number();
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadFunction(&result->function))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {




}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif