// services/network/public/mojom/early_hints.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_EARLY_HINTS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_EARLY_HINTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/early_hints.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/early_hints.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/early_hints.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include <string>
#include <vector>








namespace network::mojom {








class  EarlyHints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EarlyHints, T>::value>;
  using DataView = EarlyHintsDataView;
  using Data_ = internal::EarlyHints_Data;

  template <typename... Args>
  static EarlyHintsPtr New(Args&&... args) {
    return EarlyHintsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EarlyHintsPtr From(const U& u) {
    return mojo::TypeConverter<EarlyHintsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EarlyHints>::Convert(*this);
  }


  EarlyHints();

  EarlyHints(
      ::network::mojom::ParsedHeadersPtr headers,
      ::network::mojom::ReferrerPolicy referrer_policy,
      ::network::mojom::IPAddressSpace ip_address_space);

EarlyHints(const EarlyHints&) = delete;
EarlyHints& operator=(const EarlyHints&) = delete;

  ~EarlyHints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EarlyHintsPtr>
  EarlyHintsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EarlyHints::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EarlyHints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EarlyHints_UnserializedMessageContext<
            UserType, EarlyHints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EarlyHints::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EarlyHints::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EarlyHints_UnserializedMessageContext<
            UserType, EarlyHints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EarlyHints::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::ParsedHeadersPtr headers;
  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  ::network::mojom::IPAddressSpace ip_address_space;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EarlyHints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EarlyHintsPtr EarlyHints::Clone() const {
  return New(
      mojo::Clone(headers),
      mojo::Clone(referrer_policy),
      mojo::Clone(ip_address_space)
  );
}

template <typename T, EarlyHints::EnableIfSame<T>*>
bool EarlyHints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  return true;
}

template <typename T, EarlyHints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.ip_address_space < rhs.ip_address_space)
    return true;
  if (rhs.ip_address_space < lhs.ip_address_space)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::EarlyHints::DataView,
                                         ::network::mojom::EarlyHintsPtr> {
  static bool IsNull(const ::network::mojom::EarlyHintsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::EarlyHintsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::EarlyHints::headers)& headers(
      const ::network::mojom::EarlyHintsPtr& input) {
    return input->headers;
  }

  static decltype(::network::mojom::EarlyHints::referrer_policy) referrer_policy(
      const ::network::mojom::EarlyHintsPtr& input) {
    return input->referrer_policy;
  }

  static decltype(::network::mojom::EarlyHints::ip_address_space) ip_address_space(
      const ::network::mojom::EarlyHintsPtr& input) {
    return input->ip_address_space;
  }

  static bool Read(::network::mojom::EarlyHints::DataView input, ::network::mojom::EarlyHintsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_EARLY_HINTS_MOJOM_H_