// services/network/public/mojom/udp_socket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/udp_socket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/udp_socket.mojom-params-data.h"
#include "services/network/public/mojom/udp_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/udp_socket.mojom-import-headers.h"
#include "services/network/public/mojom/udp_socket.mojom-test-utils.h"


namespace network::mojom {
UDPSocketOptions::UDPSocketOptions()
    : allow_address_reuse(false),
      allow_broadcast(false),
      allow_address_sharing_for_multicast(false),
      multicast_interface(0U),
      multicast_time_to_live(1U),
      multicast_loopback_mode(true),
      send_buffer_size(0),
      receive_buffer_size(0),
      ipv6_only() {}

UDPSocketOptions::UDPSocketOptions(
    bool allow_address_reuse_in,
    bool allow_broadcast_in,
    bool allow_address_sharing_for_multicast_in,
    uint32_t multicast_interface_in,
    uint32_t multicast_time_to_live_in,
    bool multicast_loopback_mode_in,
    int32_t send_buffer_size_in,
    int32_t receive_buffer_size_in,
    ::network::mojom::OptionalBool ipv6_only_in)
    : allow_address_reuse(std::move(allow_address_reuse_in)),
      allow_broadcast(std::move(allow_broadcast_in)),
      allow_address_sharing_for_multicast(std::move(allow_address_sharing_for_multicast_in)),
      multicast_interface(std::move(multicast_interface_in)),
      multicast_time_to_live(std::move(multicast_time_to_live_in)),
      multicast_loopback_mode(std::move(multicast_loopback_mode_in)),
      send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      ipv6_only(std::move(ipv6_only_in)) {}

UDPSocketOptions::~UDPSocketOptions() = default;
size_t UDPSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->allow_address_reuse);
  seed = mojo::internal::Hash(seed, this->allow_broadcast);
  seed = mojo::internal::Hash(seed, this->allow_address_sharing_for_multicast);
  seed = mojo::internal::Hash(seed, this->multicast_interface);
  seed = mojo::internal::Hash(seed, this->multicast_time_to_live);
  seed = mojo::internal::Hash(seed, this->multicast_loopback_mode);
  seed = mojo::internal::Hash(seed, this->send_buffer_size);
  seed = mojo::internal::Hash(seed, this->receive_buffer_size);
  seed = mojo::internal::Hash(seed, this->ipv6_only);
  return seed;
}

void UDPSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_address_reuse"), this->allow_address_reuse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_broadcast"), this->allow_broadcast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_address_sharing_for_multicast"), this->allow_address_sharing_for_multicast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_interface"), this->multicast_interface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_time_to_live"), this->multicast_time_to_live,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_loopback_mode"), this->multicast_loopback_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ipv6_only"), this->ipv6_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UDPSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char UDPSocket::Name_[] = "network.mojom.UDPSocket";

UDPSocket::IPCStableHashFunction UDPSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UDPSocket>(message.name())) {
    case messages::UDPSocket::kBind: {
      return &UDPSocket::Bind_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kConnect: {
      return &UDPSocket::Connect_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kSetBroadcast: {
      return &UDPSocket::SetBroadcast_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kSetSendBufferSize: {
      return &UDPSocket::SetSendBufferSize_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kSetReceiveBufferSize: {
      return &UDPSocket::SetReceiveBufferSize_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kJoinGroup: {
      return &UDPSocket::JoinGroup_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kLeaveGroup: {
      return &UDPSocket::LeaveGroup_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kReceiveMore: {
      return &UDPSocket::ReceiveMore_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kReceiveMoreWithBufferSize: {
      return &UDPSocket::ReceiveMoreWithBufferSize_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kSendTo: {
      return &UDPSocket::SendTo_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kSend: {
      return &UDPSocket::Send_Sym::IPCStableHash;
    }
    case messages::UDPSocket::kClose: {
      return &UDPSocket::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UDPSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UDPSocket>(message.name())) {
      case messages::UDPSocket::kBind:
            return "Receive network::mojom::UDPSocket::Bind";
      case messages::UDPSocket::kConnect:
            return "Receive network::mojom::UDPSocket::Connect";
      case messages::UDPSocket::kSetBroadcast:
            return "Receive network::mojom::UDPSocket::SetBroadcast";
      case messages::UDPSocket::kSetSendBufferSize:
            return "Receive network::mojom::UDPSocket::SetSendBufferSize";
      case messages::UDPSocket::kSetReceiveBufferSize:
            return "Receive network::mojom::UDPSocket::SetReceiveBufferSize";
      case messages::UDPSocket::kJoinGroup:
            return "Receive network::mojom::UDPSocket::JoinGroup";
      case messages::UDPSocket::kLeaveGroup:
            return "Receive network::mojom::UDPSocket::LeaveGroup";
      case messages::UDPSocket::kReceiveMore:
            return "Receive network::mojom::UDPSocket::ReceiveMore";
      case messages::UDPSocket::kReceiveMoreWithBufferSize:
            return "Receive network::mojom::UDPSocket::ReceiveMoreWithBufferSize";
      case messages::UDPSocket::kSendTo:
            return "Receive network::mojom::UDPSocket::SendTo";
      case messages::UDPSocket::kSend:
            return "Receive network::mojom::UDPSocket::Send";
      case messages::UDPSocket::kClose:
            return "Receive network::mojom::UDPSocket::Close";
    }
  } else {
    switch (static_cast<messages::UDPSocket>(message.name())) {
      case messages::UDPSocket::kBind:
            return "Receive reply network::mojom::UDPSocket::Bind";
      case messages::UDPSocket::kConnect:
            return "Receive reply network::mojom::UDPSocket::Connect";
      case messages::UDPSocket::kSetBroadcast:
            return "Receive reply network::mojom::UDPSocket::SetBroadcast";
      case messages::UDPSocket::kSetSendBufferSize:
            return "Receive reply network::mojom::UDPSocket::SetSendBufferSize";
      case messages::UDPSocket::kSetReceiveBufferSize:
            return "Receive reply network::mojom::UDPSocket::SetReceiveBufferSize";
      case messages::UDPSocket::kJoinGroup:
            return "Receive reply network::mojom::UDPSocket::JoinGroup";
      case messages::UDPSocket::kLeaveGroup:
            return "Receive reply network::mojom::UDPSocket::LeaveGroup";
      case messages::UDPSocket::kReceiveMore:
            return "Receive reply network::mojom::UDPSocket::ReceiveMore";
      case messages::UDPSocket::kReceiveMoreWithBufferSize:
            return "Receive reply network::mojom::UDPSocket::ReceiveMoreWithBufferSize";
      case messages::UDPSocket::kSendTo:
            return "Receive reply network::mojom::UDPSocket::SendTo";
      case messages::UDPSocket::kSend:
            return "Receive reply network::mojom::UDPSocket::Send";
      case messages::UDPSocket::kClose:
            return "Receive reply network::mojom::UDPSocket::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UDPSocket::Bind_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::Bind");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::Connect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::Connect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::SetBroadcast_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::SetBroadcast");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::SetSendBufferSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::SetSendBufferSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::SetReceiveBufferSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::SetReceiveBufferSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::JoinGroup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::JoinGroup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::LeaveGroup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::LeaveGroup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::ReceiveMore_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::ReceiveMore");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::ReceiveMoreWithBufferSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::ReceiveMoreWithBufferSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::SendTo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::SendTo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::Send_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::Send");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UDPSocket::Close_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocket::Close");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UDPSocket_Bind_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_Bind_ForwardToCallback(
      UDPSocket::BindCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_Bind_ForwardToCallback(const UDPSocket_Bind_ForwardToCallback&) = delete;
  UDPSocket_Bind_ForwardToCallback& operator=(const UDPSocket_Bind_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::BindCallback callback_;
};

class UDPSocket_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_Connect_ForwardToCallback(
      UDPSocket::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_Connect_ForwardToCallback(const UDPSocket_Connect_ForwardToCallback&) = delete;
  UDPSocket_Connect_ForwardToCallback& operator=(const UDPSocket_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::ConnectCallback callback_;
};

class UDPSocket_SetBroadcast_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_SetBroadcast_ForwardToCallback(
      UDPSocket::SetBroadcastCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_SetBroadcast_ForwardToCallback(const UDPSocket_SetBroadcast_ForwardToCallback&) = delete;
  UDPSocket_SetBroadcast_ForwardToCallback& operator=(const UDPSocket_SetBroadcast_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::SetBroadcastCallback callback_;
};

class UDPSocket_SetSendBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_SetSendBufferSize_ForwardToCallback(
      UDPSocket::SetSendBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_SetSendBufferSize_ForwardToCallback(const UDPSocket_SetSendBufferSize_ForwardToCallback&) = delete;
  UDPSocket_SetSendBufferSize_ForwardToCallback& operator=(const UDPSocket_SetSendBufferSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::SetSendBufferSizeCallback callback_;
};

class UDPSocket_SetReceiveBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_SetReceiveBufferSize_ForwardToCallback(
      UDPSocket::SetReceiveBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_SetReceiveBufferSize_ForwardToCallback(const UDPSocket_SetReceiveBufferSize_ForwardToCallback&) = delete;
  UDPSocket_SetReceiveBufferSize_ForwardToCallback& operator=(const UDPSocket_SetReceiveBufferSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::SetReceiveBufferSizeCallback callback_;
};

class UDPSocket_JoinGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_JoinGroup_ForwardToCallback(
      UDPSocket::JoinGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_JoinGroup_ForwardToCallback(const UDPSocket_JoinGroup_ForwardToCallback&) = delete;
  UDPSocket_JoinGroup_ForwardToCallback& operator=(const UDPSocket_JoinGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::JoinGroupCallback callback_;
};

class UDPSocket_LeaveGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_LeaveGroup_ForwardToCallback(
      UDPSocket::LeaveGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_LeaveGroup_ForwardToCallback(const UDPSocket_LeaveGroup_ForwardToCallback&) = delete;
  UDPSocket_LeaveGroup_ForwardToCallback& operator=(const UDPSocket_LeaveGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::LeaveGroupCallback callback_;
};

class UDPSocket_SendTo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_SendTo_ForwardToCallback(
      UDPSocket::SendToCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_SendTo_ForwardToCallback(const UDPSocket_SendTo_ForwardToCallback&) = delete;
  UDPSocket_SendTo_ForwardToCallback& operator=(const UDPSocket_SendTo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::SendToCallback callback_;
};

class UDPSocket_Send_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UDPSocket_Send_ForwardToCallback(
      UDPSocket::SendCallback callback
      ) : callback_(std::move(callback)) {
  }

  UDPSocket_Send_ForwardToCallback(const UDPSocket_Send_ForwardToCallback&) = delete;
  UDPSocket_Send_ForwardToCallback& operator=(const UDPSocket_Send_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UDPSocket::SendCallback callback_;
};

UDPSocketProxy::UDPSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UDPSocketProxy::Bind(
    const ::net::IPEndPoint& in_local_addr, UDPSocketOptionsPtr in_socket_options, BindCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::Bind", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket_options"), in_socket_options,
                        "<value of type UDPSocketOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kBind), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Bind_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_addr.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_addr in UDPSocket.Bind request");
  mojo::internal::MessageFragment<
      typename decltype(params->socket_options)::BaseType> socket_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::UDPSocketOptionsDataView>(
      in_socket_options, socket_options_fragment);
  params->socket_options.Set(
      socket_options_fragment.is_null() ? nullptr : socket_options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Bind");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_Bind_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::Connect(
    const ::net::IPEndPoint& in_remote_addr, UDPSocketOptionsPtr in_socket_options, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr"), in_remote_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket_options"), in_socket_options,
                        "<value of type UDPSocketOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr)::BaseType> remote_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_addr, remote_addr_fragment);
  params->remote_addr.Set(
      remote_addr_fragment.is_null() ? nullptr : remote_addr_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_addr.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr in UDPSocket.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->socket_options)::BaseType> socket_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::UDPSocketOptionsDataView>(
      in_socket_options, socket_options_fragment);
  params->socket_options.Set(
      socket_options_fragment.is_null() ? nullptr : socket_options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::SetBroadcast(
    bool in_broadcast, SetBroadcastCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::SetBroadcast", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("broadcast"), in_broadcast,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetBroadcast), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetBroadcast_Params_Data> params(
          message);
  params.Allocate();
  params->broadcast = in_broadcast;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetBroadcast");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_SetBroadcast_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::SetSendBufferSize(
    int32_t in_send_buffer_size, SetSendBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::SetSendBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_buffer_size"), in_send_buffer_size,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetSendBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetSendBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->send_buffer_size = in_send_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_SetSendBufferSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::SetReceiveBufferSize(
    int32_t in_receive_buffer_size, SetReceiveBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::SetReceiveBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_buffer_size"), in_receive_buffer_size,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetReceiveBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetReceiveBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->receive_buffer_size = in_receive_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_SetReceiveBufferSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::JoinGroup(
    const ::net::IPAddress& in_group_address, JoinGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::JoinGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_address"), in_group_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kJoinGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_JoinGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_address)::BaseType> group_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_group_address, group_address_fragment);
  params->group_address.Set(
      group_address_fragment.is_null() ? nullptr : group_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_address in UDPSocket.JoinGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("JoinGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_JoinGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::LeaveGroup(
    const ::net::IPAddress& in_group_address, LeaveGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::LeaveGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_address"), in_group_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_LeaveGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_address)::BaseType> group_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_group_address, group_address_fragment);
  params->group_address.Set(
      group_address_fragment.is_null() ? nullptr : group_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_address in UDPSocket.LeaveGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("LeaveGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_LeaveGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::ReceiveMore(
    uint32_t in_num_additional_datagrams) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::ReceiveMore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_additional_datagrams"), in_num_additional_datagrams,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kReceiveMore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_ReceiveMore_Params_Data> params(
          message);
  params.Allocate();
  params->num_additional_datagrams = in_num_additional_datagrams;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("ReceiveMore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UDPSocketProxy::ReceiveMoreWithBufferSize(
    uint32_t in_num_additional_datagrams, uint32_t in_buffer_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::ReceiveMoreWithBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_additional_datagrams"), in_num_additional_datagrams,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_size"), in_buffer_size,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kReceiveMoreWithBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_ReceiveMoreWithBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->num_additional_datagrams = in_num_additional_datagrams;
  params->buffer_size = in_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("ReceiveMoreWithBufferSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UDPSocketProxy::SendTo(
    const ::net::IPEndPoint& in_dest_addr, ::base::span<const ::uint8_t> in_data, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, SendToCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::SendTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_addr"), in_dest_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSendTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SendTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dest_addr)::BaseType> dest_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_dest_addr, dest_addr_fragment);
  params->dest_addr.Set(
      dest_addr_fragment.is_null() ? nullptr : dest_addr_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dest_addr.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dest_addr in UDPSocket.SendTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UDPSocket.SendTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in UDPSocket.SendTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SendTo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_SendTo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::Send(
    ::base::span<const ::uint8_t> in_data, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, SendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocket::Send", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Send_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UDPSocket.Send request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in UDPSocket.Send request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Send");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UDPSocket_Send_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UDPSocketProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::UDPSocket::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class UDPSocket_Bind_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::BindCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_Bind_ProxyToResponder> proxy(
        new UDPSocket_Bind_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_Bind_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_Bind_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_Bind_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::BindCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out);
};

bool UDPSocket_Bind_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_Bind_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_Bind_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.0
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr_out{};
  UDPSocket_Bind_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddrOut(&p_local_addr_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr_out));
  return true;
}

void UDPSocket_Bind_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::Bind", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr_out"), in_local_addr_out,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kBind), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Bind_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr_out)::BaseType> local_addr_out_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr_out, local_addr_out_fragment);
  params->local_addr_out.Set(
      local_addr_out_fragment.is_null() ? nullptr : local_addr_out_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Bind");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_Connect_ProxyToResponder> proxy(
        new UDPSocket_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::ConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out);
};

bool UDPSocket_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.1
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr_out{};
  UDPSocket_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddrOut(&p_local_addr_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr_out));
  return true;
}

void UDPSocket_Connect_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::Connect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr_out"), in_local_addr_out,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr_out)::BaseType> local_addr_out_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr_out, local_addr_out_fragment);
  params->local_addr_out.Set(
      local_addr_out_fragment.is_null() ? nullptr : local_addr_out_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_SetBroadcast_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::SetBroadcastCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_SetBroadcast_ProxyToResponder> proxy(
        new UDPSocket_SetBroadcast_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_SetBroadcast_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_SetBroadcast_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_SetBroadcast_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::SetBroadcastCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_SetBroadcast_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_SetBroadcast_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_SetBroadcast_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.2
  bool success = true;
  int32_t p_result{};
  UDPSocket_SetBroadcast_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_SetBroadcast_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::SetBroadcast", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetBroadcast), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetBroadcast_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetBroadcast");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_SetSendBufferSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::SetSendBufferSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_SetSendBufferSize_ProxyToResponder> proxy(
        new UDPSocket_SetSendBufferSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_SetSendBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_SetSendBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_SetSendBufferSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::SetSendBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_SetSendBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_SetSendBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_SetSendBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.3
  bool success = true;
  int32_t p_result{};
  UDPSocket_SetSendBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_SetSendBufferSize_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::SetSendBufferSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetSendBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetSendBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_SetReceiveBufferSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::SetReceiveBufferSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_SetReceiveBufferSize_ProxyToResponder> proxy(
        new UDPSocket_SetReceiveBufferSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_SetReceiveBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_SetReceiveBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_SetReceiveBufferSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::SetReceiveBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_SetReceiveBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_SetReceiveBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_SetReceiveBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.4
  bool success = true;
  int32_t p_result{};
  UDPSocket_SetReceiveBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_SetReceiveBufferSize_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::SetReceiveBufferSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSetReceiveBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SetReceiveBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_JoinGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::JoinGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_JoinGroup_ProxyToResponder> proxy(
        new UDPSocket_JoinGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_JoinGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_JoinGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_JoinGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::JoinGroupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_JoinGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_JoinGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_JoinGroup_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.5
  bool success = true;
  int32_t p_result{};
  UDPSocket_JoinGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_JoinGroup_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::JoinGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kJoinGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_JoinGroup_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("JoinGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_LeaveGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::LeaveGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_LeaveGroup_ProxyToResponder> proxy(
        new UDPSocket_LeaveGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_LeaveGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_LeaveGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_LeaveGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::LeaveGroupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_LeaveGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_LeaveGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_LeaveGroup_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.6
  bool success = true;
  int32_t p_result{};
  UDPSocket_LeaveGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_LeaveGroup_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::LeaveGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_LeaveGroup_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("LeaveGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_SendTo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::SendToCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_SendTo_ProxyToResponder> proxy(
        new UDPSocket_SendTo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_SendTo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_SendTo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_SendTo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::SendToCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_SendTo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_SendTo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_SendTo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.9
  bool success = true;
  int32_t p_result{};
  UDPSocket_SendTo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_SendTo_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::SendTo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSendTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_SendTo_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("SendTo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UDPSocket_Send_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UDPSocket::SendCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UDPSocket_Send_ProxyToResponder> proxy(
        new UDPSocket_Send_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UDPSocket_Send_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UDPSocket_Send_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UDPSocket_Send_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UDPSocket::SendCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UDPSocket_Send_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UDPSocket_Send_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UDPSocket_Send_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for UDPSocket.10
  bool success = true;
  int32_t p_result{};
  UDPSocket_Send_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UDPSocket::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UDPSocket_Send_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::UDPSocket::Send", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocket::kSend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocket_Send_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocket::Name_);
  message.set_method_name("Send");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UDPSocketStubDispatch::Accept(
    UDPSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UDPSocket>(message->header()->name)) {
    case messages::UDPSocket::kBind: {
      break;
    }
    case messages::UDPSocket::kConnect: {
      break;
    }
    case messages::UDPSocket::kSetBroadcast: {
      break;
    }
    case messages::UDPSocket::kSetSendBufferSize: {
      break;
    }
    case messages::UDPSocket::kSetReceiveBufferSize: {
      break;
    }
    case messages::UDPSocket::kJoinGroup: {
      break;
    }
    case messages::UDPSocket::kLeaveGroup: {
      break;
    }
    case messages::UDPSocket::kReceiveMore: {
      DCHECK(message->is_serialized());
      internal::UDPSocket_ReceiveMore_Params_Data* params =
          reinterpret_cast<internal::UDPSocket_ReceiveMore_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UDPSocket.7
      bool success = true;
      uint32_t p_num_additional_datagrams{};
      UDPSocket_ReceiveMore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_additional_datagrams = input_data_view.num_additional_datagrams();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveMore(        
        std::move(p_num_additional_datagrams));
      return true;
    }
    case messages::UDPSocket::kReceiveMoreWithBufferSize: {
      DCHECK(message->is_serialized());
      internal::UDPSocket_ReceiveMoreWithBufferSize_Params_Data* params =
          reinterpret_cast<internal::UDPSocket_ReceiveMoreWithBufferSize_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UDPSocket.8
      bool success = true;
      uint32_t p_num_additional_datagrams{};
      uint32_t p_buffer_size{};
      UDPSocket_ReceiveMoreWithBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_additional_datagrams = input_data_view.num_additional_datagrams();
      if (success)
        p_buffer_size = input_data_view.buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveMoreWithBufferSize(        
        std::move(p_num_additional_datagrams), 
        std::move(p_buffer_size));
      return true;
    }
    case messages::UDPSocket::kSendTo: {
      break;
    }
    case messages::UDPSocket::kSend: {
      break;
    }
    case messages::UDPSocket::kClose: {
      DCHECK(message->is_serialized());
      internal::UDPSocket_Close_Params_Data* params =
          reinterpret_cast<internal::UDPSocket_Close_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UDPSocket.11
      bool success = true;
      UDPSocket_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool UDPSocketStubDispatch::AcceptWithResponder(
    UDPSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UDPSocket>(message->header()->name)) {
    case messages::UDPSocket::kBind: {
      internal::UDPSocket_Bind_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_Bind_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.0
      bool success = true;
      ::net::IPEndPoint p_local_addr{};
      UDPSocketOptionsPtr p_socket_options{};
      UDPSocket_Bind_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadSocketOptions(&p_socket_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 0, false);
        return false;
      }
      UDPSocket::BindCallback callback =
          UDPSocket_Bind_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Bind(        
        std::move(p_local_addr), 
        std::move(p_socket_options), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kConnect: {
      internal::UDPSocket_Connect_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_Connect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.1
      bool success = true;
      ::net::IPEndPoint p_remote_addr{};
      UDPSocketOptionsPtr p_socket_options{};
      UDPSocket_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemoteAddr(&p_remote_addr))
        success = false;
      if (success && !input_data_view.ReadSocketOptions(&p_socket_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 1, false);
        return false;
      }
      UDPSocket::ConnectCallback callback =
          UDPSocket_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_remote_addr), 
        std::move(p_socket_options), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kSetBroadcast: {
      internal::UDPSocket_SetBroadcast_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_SetBroadcast_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.2
      bool success = true;
      bool p_broadcast{};
      UDPSocket_SetBroadcast_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_broadcast = input_data_view.broadcast();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 2, false);
        return false;
      }
      UDPSocket::SetBroadcastCallback callback =
          UDPSocket_SetBroadcast_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBroadcast(        
        std::move(p_broadcast), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kSetSendBufferSize: {
      internal::UDPSocket_SetSendBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_SetSendBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.3
      bool success = true;
      int32_t p_send_buffer_size{};
      UDPSocket_SetSendBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_buffer_size = input_data_view.send_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 3, false);
        return false;
      }
      UDPSocket::SetSendBufferSizeCallback callback =
          UDPSocket_SetSendBufferSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSendBufferSize(        
        std::move(p_send_buffer_size), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kSetReceiveBufferSize: {
      internal::UDPSocket_SetReceiveBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_SetReceiveBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.4
      bool success = true;
      int32_t p_receive_buffer_size{};
      UDPSocket_SetReceiveBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_receive_buffer_size = input_data_view.receive_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 4, false);
        return false;
      }
      UDPSocket::SetReceiveBufferSizeCallback callback =
          UDPSocket_SetReceiveBufferSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReceiveBufferSize(        
        std::move(p_receive_buffer_size), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kJoinGroup: {
      internal::UDPSocket_JoinGroup_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_JoinGroup_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.5
      bool success = true;
      ::net::IPAddress p_group_address{};
      UDPSocket_JoinGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupAddress(&p_group_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 5, false);
        return false;
      }
      UDPSocket::JoinGroupCallback callback =
          UDPSocket_JoinGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JoinGroup(        
        std::move(p_group_address), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kLeaveGroup: {
      internal::UDPSocket_LeaveGroup_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_LeaveGroup_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.6
      bool success = true;
      ::net::IPAddress p_group_address{};
      UDPSocket_LeaveGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupAddress(&p_group_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 6, false);
        return false;
      }
      UDPSocket::LeaveGroupCallback callback =
          UDPSocket_LeaveGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveGroup(        
        std::move(p_group_address), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kReceiveMore: {
      break;
    }
    case messages::UDPSocket::kReceiveMoreWithBufferSize: {
      break;
    }
    case messages::UDPSocket::kSendTo: {
      internal::UDPSocket_SendTo_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_SendTo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.9
      bool success = true;
      ::net::IPEndPoint p_dest_addr{};
      ::base::span<const ::uint8_t> p_data{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      UDPSocket_SendTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDestAddr(&p_dest_addr))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 9, false);
        return false;
      }
      UDPSocket::SendToCallback callback =
          UDPSocket_SendTo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendTo(        
        std::move(p_dest_addr), 
        std::move(p_data), 
        std::move(p_traffic_annotation), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kSend: {
      internal::UDPSocket_Send_Params_Data* params =
          reinterpret_cast<
              internal::UDPSocket_Send_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for UDPSocket.10
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      UDPSocket_Send_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocket::Name_, 10, false);
        return false;
      }
      UDPSocket::SendCallback callback =
          UDPSocket_Send_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Send(        
        std::move(p_data), 
        std::move(p_traffic_annotation), std::move(callback));
      return true;
    }
    case messages::UDPSocket::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUDPSocketValidationInfo[] = {
    {base::to_underlying(messages::UDPSocket::kBind),
     { &internal::UDPSocket_Bind_Params_Data::Validate,
      &internal::UDPSocket_Bind_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kConnect),
     { &internal::UDPSocket_Connect_Params_Data::Validate,
      &internal::UDPSocket_Connect_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kSetBroadcast),
     { &internal::UDPSocket_SetBroadcast_Params_Data::Validate,
      &internal::UDPSocket_SetBroadcast_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kSetSendBufferSize),
     { &internal::UDPSocket_SetSendBufferSize_Params_Data::Validate,
      &internal::UDPSocket_SetSendBufferSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kSetReceiveBufferSize),
     { &internal::UDPSocket_SetReceiveBufferSize_Params_Data::Validate,
      &internal::UDPSocket_SetReceiveBufferSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kJoinGroup),
     { &internal::UDPSocket_JoinGroup_Params_Data::Validate,
      &internal::UDPSocket_JoinGroup_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kLeaveGroup),
     { &internal::UDPSocket_LeaveGroup_Params_Data::Validate,
      &internal::UDPSocket_LeaveGroup_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kReceiveMore),
     { &internal::UDPSocket_ReceiveMore_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UDPSocket::kReceiveMoreWithBufferSize),
     { &internal::UDPSocket_ReceiveMoreWithBufferSize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UDPSocket::kSendTo),
     { &internal::UDPSocket_SendTo_Params_Data::Validate,
      &internal::UDPSocket_SendTo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kSend),
     { &internal::UDPSocket_Send_Params_Data::Validate,
      &internal::UDPSocket_Send_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::UDPSocket::kClose),
     { &internal::UDPSocket_Close_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UDPSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::UDPSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUDPSocketValidationInfo);
}

bool UDPSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::UDPSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kUDPSocketValidationInfo);

}
const char UDPSocketListener::Name_[] = "network.mojom.UDPSocketListener";

UDPSocketListener::IPCStableHashFunction UDPSocketListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UDPSocketListener>(message.name())) {
    case messages::UDPSocketListener::kOnReceived: {
      return &UDPSocketListener::OnReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UDPSocketListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UDPSocketListener>(message.name())) {
      case messages::UDPSocketListener::kOnReceived:
            return "Receive network::mojom::UDPSocketListener::OnReceived";
    }
  } else {
    switch (static_cast<messages::UDPSocketListener>(message.name())) {
      case messages::UDPSocketListener::kOnReceived:
            return "Receive reply network::mojom::UDPSocketListener::OnReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UDPSocketListener::OnReceived_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::UDPSocketListener::OnReceived");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UDPSocketListenerProxy::UDPSocketListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UDPSocketListenerProxy::OnReceived(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_src_addr, std::optional<::base::span<const ::uint8_t>> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::UDPSocketListener::OnReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_addr"), in_src_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::optional<::base::span<const ::uint8_t>>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UDPSocketListener::kOnReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::UDPSocketListener_OnReceived_Params_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->src_addr)::BaseType> src_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_src_addr, src_addr_fragment);
  params->src_addr.Set(
      src_addr_fragment.is_null() ? nullptr : src_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UDPSocketListener::Name_);
  message.set_method_name("OnReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UDPSocketListenerStubDispatch::Accept(
    UDPSocketListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UDPSocketListener>(message->header()->name)) {
    case messages::UDPSocketListener::kOnReceived: {
      DCHECK(message->is_serialized());
      internal::UDPSocketListener_OnReceived_Params_Data* params =
          reinterpret_cast<internal::UDPSocketListener_OnReceived_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UDPSocketListener.0
      bool success = true;
      int32_t p_result{};
      std::optional<::net::IPEndPoint> p_src_addr{};
      std::optional<::base::span<const ::uint8_t>> p_data{};
      UDPSocketListener_OnReceived_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_result = input_data_view.result();
      if (success && !input_data_view.ReadSrcAddr(&p_src_addr))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UDPSocketListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceived(        
        std::move(p_result), 
        std::move(p_src_addr), 
        std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool UDPSocketListenerStubDispatch::AcceptWithResponder(
    UDPSocketListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UDPSocketListener>(message->header()->name)) {
    case messages::UDPSocketListener::kOnReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUDPSocketListenerValidationInfo[] = {
    {base::to_underlying(messages::UDPSocketListener::kOnReceived),
     { &internal::UDPSocketListener_OnReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UDPSocketListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::UDPSocketListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUDPSocketListenerValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::UDPSocketOptions::DataView, ::network::mojom::UDPSocketOptionsPtr>::Read(
    ::network::mojom::UDPSocketOptions::DataView input,
    ::network::mojom::UDPSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::UDPSocketOptionsPtr result(::network::mojom::UDPSocketOptions::New());
  
      if (success)
        result->allow_address_reuse = input.allow_address_reuse();
      if (success)
        result->allow_broadcast = input.allow_broadcast();
      if (success)
        result->allow_address_sharing_for_multicast = input.allow_address_sharing_for_multicast();
      if (success)
        result->multicast_interface = input.multicast_interface();
      if (success)
        result->multicast_time_to_live = input.multicast_time_to_live();
      if (success)
        result->multicast_loopback_mode = input.multicast_loopback_mode();
      if (success)
        result->send_buffer_size = input.send_buffer_size();
      if (success)
        result->receive_buffer_size = input.receive_buffer_size();
      if (success && !input.ReadIpv6Only(&result->ipv6_only))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void UDPSocketInterceptorForTesting::Bind(const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, BindCallback callback) {
  GetForwardingInterface()->Bind(
    std::move(local_addr)
    , 
    std::move(socket_options)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::Connect(const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(remote_addr)
    , 
    std::move(socket_options)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::SetBroadcast(bool broadcast, SetBroadcastCallback callback) {
  GetForwardingInterface()->SetBroadcast(
    std::move(broadcast)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) {
  GetForwardingInterface()->SetSendBufferSize(
    std::move(send_buffer_size)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) {
  GetForwardingInterface()->SetReceiveBufferSize(
    std::move(receive_buffer_size)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) {
  GetForwardingInterface()->JoinGroup(
    std::move(group_address)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) {
  GetForwardingInterface()->LeaveGroup(
    std::move(group_address)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::ReceiveMore(uint32_t num_additional_datagrams) {
  GetForwardingInterface()->ReceiveMore(
    std::move(num_additional_datagrams)
    );
}
void UDPSocketInterceptorForTesting::ReceiveMoreWithBufferSize(uint32_t num_additional_datagrams, uint32_t buffer_size) {
  GetForwardingInterface()->ReceiveMoreWithBufferSize(
    std::move(num_additional_datagrams)
    , 
    std::move(buffer_size)
    );
}
void UDPSocketInterceptorForTesting::SendTo(const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendToCallback callback) {
  GetForwardingInterface()->SendTo(
    std::move(dest_addr)
    , 
    std::move(data)
    , 
    std::move(traffic_annotation)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::Send(::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendCallback callback) {
  GetForwardingInterface()->Send(
    std::move(data)
    , 
    std::move(traffic_annotation)
    , std::move(callback));
}
void UDPSocketInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
UDPSocketAsyncWaiter::UDPSocketAsyncWaiter(
    UDPSocket* proxy) : proxy_(proxy) {}

UDPSocketAsyncWaiter::~UDPSocketAsyncWaiter() = default;

void UDPSocketAsyncWaiter::Bind(
    const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out) {
  base::RunLoop loop;
  proxy_->Bind(
      std::move(local_addr),
      std::move(socket_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr_out
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr_out) {*out_result = std::move(result);*out_local_addr_out = std::move(local_addr_out);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr_out));
  loop.Run();
}



void UDPSocketAsyncWaiter::Connect(
    const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(remote_addr),
      std::move(socket_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr_out
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr_out) {*out_result = std::move(result);*out_local_addr_out = std::move(local_addr_out);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr_out));
  loop.Run();
}



void UDPSocketAsyncWaiter::SetBroadcast(
    bool broadcast, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->SetBroadcast(
      std::move(broadcast),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::SetBroadcast(
    bool broadcast) {
  int32_t async_wait_result;
  SetBroadcast(std::move(broadcast),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::SetSendBufferSize(
    int32_t send_buffer_size, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->SetSendBufferSize(
      std::move(send_buffer_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::SetSendBufferSize(
    int32_t send_buffer_size) {
  int32_t async_wait_result;
  SetSendBufferSize(std::move(send_buffer_size),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::SetReceiveBufferSize(
    int32_t receive_buffer_size, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->SetReceiveBufferSize(
      std::move(receive_buffer_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::SetReceiveBufferSize(
    int32_t receive_buffer_size) {
  int32_t async_wait_result;
  SetReceiveBufferSize(std::move(receive_buffer_size),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::JoinGroup(
    const ::net::IPAddress& group_address, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->JoinGroup(
      std::move(group_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::JoinGroup(
    const ::net::IPAddress& group_address) {
  int32_t async_wait_result;
  JoinGroup(std::move(group_address),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::LeaveGroup(
    const ::net::IPAddress& group_address, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->LeaveGroup(
      std::move(group_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::LeaveGroup(
    const ::net::IPAddress& group_address) {
  int32_t async_wait_result;
  LeaveGroup(std::move(group_address),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::SendTo(
    const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->SendTo(
      std::move(dest_addr),
      std::move(data),
      std::move(traffic_annotation),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::SendTo(
    const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
  int32_t async_wait_result;
  SendTo(std::move(dest_addr),std::move(data),std::move(traffic_annotation),&async_wait_result);
  return async_wait_result;
}

void UDPSocketAsyncWaiter::Send(
    ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->Send(
      std::move(data),
      std::move(traffic_annotation),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UDPSocketAsyncWaiter::Send(
    ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
  int32_t async_wait_result;
  Send(std::move(data),std::move(traffic_annotation),&async_wait_result);
  return async_wait_result;
}




void UDPSocketListenerInterceptorForTesting::OnReceived(int32_t result, const std::optional<::net::IPEndPoint>& src_addr, std::optional<::base::span<const ::uint8_t>> data) {
  GetForwardingInterface()->OnReceived(
    std::move(result)
    , 
    std::move(src_addr)
    , 
    std::move(data)
    );
}
UDPSocketListenerAsyncWaiter::UDPSocketListenerAsyncWaiter(
    UDPSocketListener* proxy) : proxy_(proxy) {}

UDPSocketListenerAsyncWaiter::~UDPSocketListenerAsyncWaiter() = default;






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif