// services/tracing/public/mojom/background_tracing_agent.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/background_tracing_agent.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-params-data.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-import-headers.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-test-utils.h"


namespace tracing::mojom {
BackgroundTracingRule::BackgroundTracingRule()
    : rule_id() {}

BackgroundTracingRule::BackgroundTracingRule(
    const std::string& rule_id_in)
    : rule_id(std::move(rule_id_in)) {}

BackgroundTracingRule::~BackgroundTracingRule() = default;
size_t BackgroundTracingRule::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->rule_id);
  return seed;
}

void BackgroundTracingRule::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rule_id"), this->rule_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundTracingRule::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BackgroundTracingAgentClient::Name_[] = "tracing.mojom.BackgroundTracingAgentClient";

BackgroundTracingAgentClient::IPCStableHashFunction BackgroundTracingAgentClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BackgroundTracingAgentClient>(message.name())) {
    case messages::BackgroundTracingAgentClient::kOnInitialized: {
      return &BackgroundTracingAgentClient::OnInitialized_Sym::IPCStableHash;
    }
    case messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace: {
      return &BackgroundTracingAgentClient::OnTriggerBackgroundTrace_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BackgroundTracingAgentClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BackgroundTracingAgentClient>(message.name())) {
      case messages::BackgroundTracingAgentClient::kOnInitialized:
            return "Receive tracing::mojom::BackgroundTracingAgentClient::OnInitialized";
      case messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace:
            return "Receive tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace";
    }
  } else {
    switch (static_cast<messages::BackgroundTracingAgentClient>(message.name())) {
      case messages::BackgroundTracingAgentClient::kOnInitialized:
            return "Receive reply tracing::mojom::BackgroundTracingAgentClient::OnInitialized";
      case messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace:
            return "Receive reply tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BackgroundTracingAgentClient::OnInitialized_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnInitialized");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BackgroundTracingAgentClient::OnTriggerBackgroundTrace_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BackgroundTracingAgentClientProxy::BackgroundTracingAgentClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentClientProxy::OnInitialized(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tracing::mojom::BackgroundTracingAgentClient::OnInitialized");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackgroundTracingAgentClient::kOnInitialized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentClient_OnInitialized_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentClient::Name_);
  message.set_method_name("OnInitialized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BackgroundTracingAgentClientProxy::OnTriggerBackgroundTrace(
    BackgroundTracingRulePtr in_rule, std::optional<int32_t> in_histogram_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rule"), in_rule,
                        "<value of type BackgroundTracingRulePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_value"), in_histogram_value,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rule)::BaseType> rule_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::BackgroundTracingRuleDataView>(
      in_rule, rule_fragment);
  params->rule.Set(
      rule_fragment.is_null() ? nullptr : rule_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rule.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rule in BackgroundTracingAgentClient.OnTriggerBackgroundTrace request");
  params->histogram_value_$flag = in_histogram_value.has_value();
  if (in_histogram_value.has_value()) {
    params->histogram_value_$value = in_histogram_value.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentClient::Name_);
  message.set_method_name("OnTriggerBackgroundTrace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BackgroundTracingAgentClientStubDispatch::Accept(
    BackgroundTracingAgentClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BackgroundTracingAgentClient>(message->header()->name)) {
    case messages::BackgroundTracingAgentClient::kOnInitialized: {
      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentClient_OnInitialized_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentClient_OnInitialized_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BackgroundTracingAgentClient.0
      bool success = true;
      BackgroundTracingAgentClient_OnInitialized_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInitialized(        );
      return true;
    }
    case messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace: {
      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BackgroundTracingAgentClient.1
      bool success = true;
      BackgroundTracingRulePtr p_rule{};
      std::optional<int32_t> p_histogram_value{};
      BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRule(&p_rule))
        success = false;
      if (success) {
        p_histogram_value = input_data_view.histogram_value();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTriggerBackgroundTrace(        
        std::move(p_rule), 
        std::move(p_histogram_value));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentClientStubDispatch::AcceptWithResponder(
    BackgroundTracingAgentClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BackgroundTracingAgentClient>(message->header()->name)) {
    case messages::BackgroundTracingAgentClient::kOnInitialized: {
      break;
    }
    case messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentClientValidationInfo[] = {
    {base::to_underlying(messages::BackgroundTracingAgentClient::kOnInitialized),
     { &internal::BackgroundTracingAgentClient_OnInitialized_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::BackgroundTracingAgentClient::kOnTriggerBackgroundTrace),
     { &internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgentClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentClientValidationInfo);
}

const char BackgroundTracingAgent::Name_[] = "tracing.mojom.BackgroundTracingAgent";

BackgroundTracingAgent::IPCStableHashFunction BackgroundTracingAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BackgroundTracingAgent>(message.name())) {
    case messages::BackgroundTracingAgent::kSetUMACallback: {
      return &BackgroundTracingAgent::SetUMACallback_Sym::IPCStableHash;
    }
    case messages::BackgroundTracingAgent::kClearUMACallback: {
      return &BackgroundTracingAgent::ClearUMACallback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BackgroundTracingAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BackgroundTracingAgent>(message.name())) {
      case messages::BackgroundTracingAgent::kSetUMACallback:
            return "Receive tracing::mojom::BackgroundTracingAgent::SetUMACallback";
      case messages::BackgroundTracingAgent::kClearUMACallback:
            return "Receive tracing::mojom::BackgroundTracingAgent::ClearUMACallback";
    }
  } else {
    switch (static_cast<messages::BackgroundTracingAgent>(message.name())) {
      case messages::BackgroundTracingAgent::kSetUMACallback:
            return "Receive reply tracing::mojom::BackgroundTracingAgent::SetUMACallback";
      case messages::BackgroundTracingAgent::kClearUMACallback:
            return "Receive reply tracing::mojom::BackgroundTracingAgent::ClearUMACallback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BackgroundTracingAgent::SetUMACallback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)tracing::mojom::BackgroundTracingAgent::SetUMACallback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BackgroundTracingAgent::ClearUMACallback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)tracing::mojom::BackgroundTracingAgent::ClearUMACallback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BackgroundTracingAgentProxy::BackgroundTracingAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentProxy::SetUMACallback(
    BackgroundTracingRulePtr in_rule, const std::string& in_histogram_name, int32_t in_histogram_lower_value, int32_t in_histogram_upper_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracing::mojom::BackgroundTracingAgent::SetUMACallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rule"), in_rule,
                        "<value of type BackgroundTracingRulePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_name"), in_histogram_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_lower_value"), in_histogram_lower_value,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_upper_value"), in_histogram_upper_value,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackgroundTracingAgent::kSetUMACallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgent_SetUMACallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rule)::BaseType> rule_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::BackgroundTracingRuleDataView>(
      in_rule, rule_fragment);
  params->rule.Set(
      rule_fragment.is_null() ? nullptr : rule_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rule.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rule in BackgroundTracingAgent.SetUMACallback request");
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_name)::BaseType> histogram_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name, histogram_name_fragment);
  params->histogram_name.Set(
      histogram_name_fragment.is_null() ? nullptr : histogram_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in BackgroundTracingAgent.SetUMACallback request");
  params->histogram_lower_value = in_histogram_lower_value;
  params->histogram_upper_value = in_histogram_upper_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgent::Name_);
  message.set_method_name("SetUMACallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BackgroundTracingAgentProxy::ClearUMACallback(
    BackgroundTracingRulePtr in_rule) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracing::mojom::BackgroundTracingAgent::ClearUMACallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rule"), in_rule,
                        "<value of type BackgroundTracingRulePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackgroundTracingAgent::kClearUMACallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgent_ClearUMACallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rule)::BaseType> rule_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::BackgroundTracingRuleDataView>(
      in_rule, rule_fragment);
  params->rule.Set(
      rule_fragment.is_null() ? nullptr : rule_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rule.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rule in BackgroundTracingAgent.ClearUMACallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgent::Name_);
  message.set_method_name("ClearUMACallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BackgroundTracingAgentStubDispatch::Accept(
    BackgroundTracingAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BackgroundTracingAgent>(message->header()->name)) {
    case messages::BackgroundTracingAgent::kSetUMACallback: {
      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgent_SetUMACallback_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgent_SetUMACallback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BackgroundTracingAgent.0
      bool success = true;
      BackgroundTracingRulePtr p_rule{};
      std::string p_histogram_name{};
      int32_t p_histogram_lower_value{};
      int32_t p_histogram_upper_value{};
      BackgroundTracingAgent_SetUMACallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRule(&p_rule))
        success = false;
      if (success && !input_data_view.ReadHistogramName(&p_histogram_name))
        success = false;
      if (success)
        p_histogram_lower_value = input_data_view.histogram_lower_value();
      if (success)
        p_histogram_upper_value = input_data_view.histogram_upper_value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUMACallback(        
        std::move(p_rule), 
        std::move(p_histogram_name), 
        std::move(p_histogram_lower_value), 
        std::move(p_histogram_upper_value));
      return true;
    }
    case messages::BackgroundTracingAgent::kClearUMACallback: {
      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgent_ClearUMACallback_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgent_ClearUMACallback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BackgroundTracingAgent.1
      bool success = true;
      BackgroundTracingRulePtr p_rule{};
      BackgroundTracingAgent_ClearUMACallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRule(&p_rule))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUMACallback(        
        std::move(p_rule));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentStubDispatch::AcceptWithResponder(
    BackgroundTracingAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BackgroundTracingAgent>(message->header()->name)) {
    case messages::BackgroundTracingAgent::kSetUMACallback: {
      break;
    }
    case messages::BackgroundTracingAgent::kClearUMACallback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentValidationInfo[] = {
    {base::to_underlying(messages::BackgroundTracingAgent::kSetUMACallback),
     { &internal::BackgroundTracingAgent_SetUMACallback_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::BackgroundTracingAgent::kClearUMACallback),
     { &internal::BackgroundTracingAgent_ClearUMACallback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgent::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentValidationInfo);
}

const char BackgroundTracingAgentProvider::Name_[] = "tracing.mojom.BackgroundTracingAgentProvider";

BackgroundTracingAgentProvider::IPCStableHashFunction BackgroundTracingAgentProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BackgroundTracingAgentProvider>(message.name())) {
    case messages::BackgroundTracingAgentProvider::kCreate: {
      return &BackgroundTracingAgentProvider::Create_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BackgroundTracingAgentProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BackgroundTracingAgentProvider>(message.name())) {
      case messages::BackgroundTracingAgentProvider::kCreate:
            return "Receive tracing::mojom::BackgroundTracingAgentProvider::Create";
    }
  } else {
    switch (static_cast<messages::BackgroundTracingAgentProvider>(message.name())) {
      case messages::BackgroundTracingAgentProvider::kCreate:
            return "Receive reply tracing::mojom::BackgroundTracingAgentProvider::Create";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BackgroundTracingAgentProvider::Create_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)tracing::mojom::BackgroundTracingAgentProvider::Create");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BackgroundTracingAgentProviderProxy::BackgroundTracingAgentProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentProviderProxy::Create(
    uint64_t in_tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> in_client, ::mojo::PendingReceiver<BackgroundTracingAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracing::mojom::BackgroundTracingAgentProvider::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracing_process_id"), in_tracing_process_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BackgroundTracingAgentClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingReceiver<BackgroundTracingAgent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackgroundTracingAgentProvider::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentProvider_Create_Params_Data> params(
          message);
  params.Allocate();
  params->tracing_process_id = in_tracing_process_id;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::BackgroundTracingAgentClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in BackgroundTracingAgentProvider.Create request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::BackgroundTracingAgentInterfaceBase>>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent in BackgroundTracingAgentProvider.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentProvider::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BackgroundTracingAgentProviderStubDispatch::Accept(
    BackgroundTracingAgentProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BackgroundTracingAgentProvider>(message->header()->name)) {
    case messages::BackgroundTracingAgentProvider::kCreate: {
      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentProvider_Create_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentProvider_Create_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BackgroundTracingAgentProvider.0
      bool success = true;
      uint64_t p_tracing_process_id{};
      ::mojo::PendingRemote<BackgroundTracingAgentClient> p_client{};
      ::mojo::PendingReceiver<BackgroundTracingAgent> p_agent{};
      BackgroundTracingAgentProvider_Create_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tracing_process_id = input_data_view.tracing_process_id();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_tracing_process_id), 
        std::move(p_client), 
        std::move(p_agent));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentProviderStubDispatch::AcceptWithResponder(
    BackgroundTracingAgentProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BackgroundTracingAgentProvider>(message->header()->name)) {
    case messages::BackgroundTracingAgentProvider::kCreate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentProviderValidationInfo[] = {
    {base::to_underlying(messages::BackgroundTracingAgentProvider::kCreate),
     { &internal::BackgroundTracingAgentProvider_Create_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgentProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentProviderValidationInfo);
}



}  // tracing::mojom


namespace mojo {


// static
bool StructTraits<::tracing::mojom::BackgroundTracingRule::DataView, ::tracing::mojom::BackgroundTracingRulePtr>::Read(
    ::tracing::mojom::BackgroundTracingRule::DataView input,
    ::tracing::mojom::BackgroundTracingRulePtr* output) {
  bool success = true;
  ::tracing::mojom::BackgroundTracingRulePtr result(::tracing::mojom::BackgroundTracingRule::New());
  
      if (success && !input.ReadRuleId(&result->rule_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tracing::mojom {


void BackgroundTracingAgentClientInterceptorForTesting::OnInitialized() {
  GetForwardingInterface()->OnInitialized();
}
void BackgroundTracingAgentClientInterceptorForTesting::OnTriggerBackgroundTrace(BackgroundTracingRulePtr rule, std::optional<int32_t> histogram_value) {
  GetForwardingInterface()->OnTriggerBackgroundTrace(
    std::move(rule)
    , 
    std::move(histogram_value)
    );
}
BackgroundTracingAgentClientAsyncWaiter::BackgroundTracingAgentClientAsyncWaiter(
    BackgroundTracingAgentClient* proxy) : proxy_(proxy) {}

BackgroundTracingAgentClientAsyncWaiter::~BackgroundTracingAgentClientAsyncWaiter() = default;




void BackgroundTracingAgentInterceptorForTesting::SetUMACallback(BackgroundTracingRulePtr rule, const std::string& histogram_name, int32_t histogram_lower_value, int32_t histogram_upper_value) {
  GetForwardingInterface()->SetUMACallback(
    std::move(rule)
    , 
    std::move(histogram_name)
    , 
    std::move(histogram_lower_value)
    , 
    std::move(histogram_upper_value)
    );
}
void BackgroundTracingAgentInterceptorForTesting::ClearUMACallback(BackgroundTracingRulePtr rule) {
  GetForwardingInterface()->ClearUMACallback(
    std::move(rule)
    );
}
BackgroundTracingAgentAsyncWaiter::BackgroundTracingAgentAsyncWaiter(
    BackgroundTracingAgent* proxy) : proxy_(proxy) {}

BackgroundTracingAgentAsyncWaiter::~BackgroundTracingAgentAsyncWaiter() = default;




void BackgroundTracingAgentProviderInterceptorForTesting::Create(uint64_t tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> client, ::mojo::PendingReceiver<BackgroundTracingAgent> agent) {
  GetForwardingInterface()->Create(
    std::move(tracing_process_id)
    , 
    std::move(client)
    , 
    std::move(agent)
    );
}
BackgroundTracingAgentProviderAsyncWaiter::BackgroundTracingAgentProviderAsyncWaiter(
    BackgroundTracingAgentProvider* proxy) : proxy_(proxy) {}

BackgroundTracingAgentProviderAsyncWaiter::~BackgroundTracingAgentProviderAsyncWaiter() = default;






}  // tracing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif