// services/video_capture/public/mojom/video_source_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_source_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_source_provider.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/devices_changed_observer.mojom-forward.h"
#include "services/video_capture/public/mojom/producer.mojom-forward.h"
#include "services/video_capture/public/mojom/video_source.mojom-forward.h"
#include "services/video_capture/public/mojom/virtual_device.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class VideoSourceProviderProxy;

template <typename ImplRefTraits>
class VideoSourceProviderStub;

class VideoSourceProviderRequestValidator;
class VideoSourceProviderResponseValidator;


class VideoSourceProvider
    : public VideoSourceProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoSourceProviderInterfaceBase;
  using Proxy_ = VideoSourceProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoSourceProviderStub<ImplRefTraits>;

  using RequestValidator_ = VideoSourceProviderRequestValidator;
  using ResponseValidator_ = VideoSourceProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSourceInfosMinVersion = 0,
    kGetVideoSourceMinVersion = 0,
    kAddSharedMemoryVirtualDeviceMinVersion = 0,
    kAddTextureVirtualDeviceMinVersion = 0,
    kRegisterVirtualDevicesChangedObserverMinVersion = 0,
    kRegisterDevicesChangedObserverMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSourceInfos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddSharedMemoryVirtualDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddTextureVirtualDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterVirtualDevicesChangedObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterDevicesChangedObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using GetSourceInfosResult = VideoSourceProvider_GetSourceInfosResult;
  virtual ~VideoSourceProvider() = default;


  using GetSourceInfosCallback = base::OnceCallback<void(VideoSourceProvider::GetSourceInfosResult, const std::vector<::media::VideoCaptureDeviceInfo>&)>;
  
  virtual void GetSourceInfos(GetSourceInfosCallback callback) = 0;

  
  virtual void GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) = 0;

  
  virtual void AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) = 0;

  
  virtual void AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) = 0;

  
  virtual void RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) = 0;

  
  virtual void RegisterDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer) = 0;


  using CloseCallback = base::OnceCallback<void()>;
  
  virtual void Close(CloseCallback callback) = 0;
};



class  VideoSourceProviderProxy
    : public VideoSourceProvider {
 public:
  using InterfaceType = VideoSourceProvider;

  explicit VideoSourceProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSourceInfos(GetSourceInfosCallback callback) final;
  
  void GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) final;
  
  void AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) final;
  
  void AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) final;
  
  void RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) final;
  
  void RegisterDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoSourceProviderStubDispatch {
 public:
  static bool Accept(VideoSourceProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoSourceProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoSourceProvider>>
class VideoSourceProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoSourceProviderStub() = default;
  ~VideoSourceProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoSourceProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_