// ui/gfx/mojom/delegated_ink_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/delegated_ink_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace gfx::mojom {
class DelegatedInkMetadataDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::DelegatedInkMetadataDataView> {
  using Data = ::gfx::mojom::internal::DelegatedInkMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class DelegatedInkMetadataDataView {
 public:
  DelegatedInkMetadataDataView() = default;

  DelegatedInkMetadataDataView(
      internal::DelegatedInkMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoint(UserType* output) {
    
    auto* pointer = data_->point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  double diameter() const {
    return data_->diameter;
  }
  inline void GetColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetPresentationAreaDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentationArea(UserType* output) {
    
    auto* pointer = data_->presentation_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetFrameTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTime(UserType* output) {
    
    auto* pointer = data_->frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool is_hovering() const {
    return data_->is_hovering;
  }
 private:
  internal::DelegatedInkMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::DelegatedInkMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::DelegatedInkMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::DelegatedInkMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::point(input)) in_point = Traits::point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->point)::BaseType> point_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_point, point_fragment);
    fragment->point.Set(
        point_fragment.is_null() ? nullptr : point_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null point in DelegatedInkMetadata struct");
    fragment->diameter = Traits::diameter(input);
    decltype(Traits::color(input)) in_color = Traits::color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color)::BaseType> color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
        in_color, color_fragment);
    fragment->color.Set(
        color_fragment.is_null() ? nullptr : color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color in DelegatedInkMetadata struct");
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in DelegatedInkMetadata struct");
    decltype(Traits::presentation_area(input)) in_presentation_area = Traits::presentation_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->presentation_area)::BaseType> presentation_area_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_presentation_area, presentation_area_fragment);
    fragment->presentation_area.Set(
        presentation_area_fragment.is_null() ? nullptr : presentation_area_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->presentation_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presentation_area in DelegatedInkMetadata struct");
    decltype(Traits::frame_time(input)) in_frame_time = Traits::frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_time)::BaseType> frame_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_frame_time, frame_time_fragment);
    fragment->frame_time.Set(
        frame_time_fragment.is_null() ? nullptr : frame_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_time in DelegatedInkMetadata struct");
    fragment->is_hovering = Traits::is_hovering(input);
  }

  static bool Deserialize(::gfx::mojom::internal::DelegatedInkMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::DelegatedInkMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void DelegatedInkMetadataDataView::GetPointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DelegatedInkMetadataDataView::GetColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void DelegatedInkMetadataDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DelegatedInkMetadataDataView::GetPresentationAreaDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->presentation_area.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void DelegatedInkMetadataDataView::GetFrameTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->frame_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_SHARED_H_