// ui/latency/mojom/latency_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_H_
#define UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/latency/mojom/latency_info.mojom-features.h"  // IWYU pragma: export
#include "ui/latency/mojom/latency_info.mojom-shared.h"  // IWYU pragma: export
#include "ui/latency/mojom/latency_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "ui/latency/mojom/latency_info_mojom_traits.h"




namespace ui::mojom {








class  LatencyInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LatencyInfo, T>::value>;
  using DataView = LatencyInfoDataView;
  using Data_ = internal::LatencyInfo_Data;

  template <typename... Args>
  static LatencyInfoPtr New(Args&&... args) {
    return LatencyInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LatencyInfoPtr From(const U& u) {
    return mojo::TypeConverter<LatencyInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LatencyInfo>::Convert(*this);
  }


  LatencyInfo();

  LatencyInfo(
      const base::flat_map<::ui::LatencyComponentType, ::base::TimeTicks>& latency_components,
      int64_t trace_id,
      bool coalesced,
      bool began,
      bool terminated,
      int64_t gesture_scroll_id,
      int64_t touch_trace_id);


  ~LatencyInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LatencyInfoPtr>
  LatencyInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LatencyInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LatencyInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LatencyInfo_UnserializedMessageContext<
            UserType, LatencyInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LatencyInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LatencyInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LatencyInfo_UnserializedMessageContext<
            UserType, LatencyInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LatencyInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::ui::LatencyComponentType, ::base::TimeTicks> latency_components;
  
  int64_t trace_id;
  
  bool coalesced;
  
  bool began;
  
  bool terminated;
  
  int64_t gesture_scroll_id;
  
  int64_t touch_trace_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LatencyInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LatencyInfoPtr LatencyInfo::Clone() const {
  return New(
      mojo::Clone(latency_components),
      mojo::Clone(trace_id),
      mojo::Clone(coalesced),
      mojo::Clone(began),
      mojo::Clone(terminated),
      mojo::Clone(gesture_scroll_id),
      mojo::Clone(touch_trace_id)
  );
}

template <typename T, LatencyInfo::EnableIfSame<T>*>
bool LatencyInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->latency_components, other_struct.latency_components))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->coalesced, other_struct.coalesced))
    return false;
  if (!mojo::Equals(this->began, other_struct.began))
    return false;
  if (!mojo::Equals(this->terminated, other_struct.terminated))
    return false;
  if (!mojo::Equals(this->gesture_scroll_id, other_struct.gesture_scroll_id))
    return false;
  if (!mojo::Equals(this->touch_trace_id, other_struct.touch_trace_id))
    return false;
  return true;
}

template <typename T, LatencyInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.latency_components < rhs.latency_components)
    return true;
  if (rhs.latency_components < lhs.latency_components)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.coalesced < rhs.coalesced)
    return true;
  if (rhs.coalesced < lhs.coalesced)
    return false;
  if (lhs.began < rhs.began)
    return true;
  if (rhs.began < lhs.began)
    return false;
  if (lhs.terminated < rhs.terminated)
    return true;
  if (rhs.terminated < lhs.terminated)
    return false;
  if (lhs.gesture_scroll_id < rhs.gesture_scroll_id)
    return true;
  if (rhs.gesture_scroll_id < lhs.gesture_scroll_id)
    return false;
  if (lhs.touch_trace_id < rhs.touch_trace_id)
    return true;
  if (rhs.touch_trace_id < lhs.touch_trace_id)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::LatencyInfo::DataView,
                                         ::ui::mojom::LatencyInfoPtr> {
  static bool IsNull(const ::ui::mojom::LatencyInfoPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::LatencyInfoPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::LatencyInfo::latency_components)& latency_components(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->latency_components;
  }

  static decltype(::ui::mojom::LatencyInfo::trace_id) trace_id(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->trace_id;
  }

  static decltype(::ui::mojom::LatencyInfo::coalesced) coalesced(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->coalesced;
  }

  static decltype(::ui::mojom::LatencyInfo::began) began(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->began;
  }

  static decltype(::ui::mojom::LatencyInfo::terminated) terminated(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->terminated;
  }

  static decltype(::ui::mojom::LatencyInfo::gesture_scroll_id) gesture_scroll_id(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->gesture_scroll_id;
  }

  static decltype(::ui::mojom::LatencyInfo::touch_trace_id) touch_trace_id(
      const ::ui::mojom::LatencyInfoPtr& input) {
    return input->touch_trace_id;
  }

  static bool Read(::ui::mojom::LatencyInfo::DataView input, ::ui::mojom::LatencyInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_H_