/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/insertpeptide/insertpeptide.h"


namespace Avogadro::QtPlugins {

class InsertPeptideFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit InsertPeptideFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new InsertPeptide(parent_);
    object->setObjectName("InsertPeptide");
    return object;
  }

  QString identifier() const override { return "InsertPeptide"; }

  QString description() const override { return "Insert oligopeptide chains"; }

};

} // namespace Avogadro::QtPlugins

#include "InsertPeptidePlugin.moc"
