/* TasklistApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TasklistApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "tasklistapplet.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TASKLIST_PLUGIN_0_PROPERTY,
	TASKLIST_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* tasklist_plugin_properties[TASKLIST_PLUGIN_NUM_PROPERTIES];
enum  {
	TASKLIST_SETTINGS_0_PROPERTY,
	TASKLIST_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* tasklist_settings_properties[TASKLIST_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	TASKLIST_APPLET_0_PROPERTY,
	TASKLIST_APPLET_UUID_PROPERTY,
	TASKLIST_APPLET_NUM_PROPERTIES
};
static GParamSpec* tasklist_applet_properties[TASKLIST_APPLET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TasklistSettingsPrivate {
	GtkSwitch* switch_show_icons;
	GtkSwitch* switch_show_labels;
	GSettings* settings;
};

struct _TasklistAppletPrivate {
	gchar* _uuid;
	BudgiePopoverManager* popover_manager;
	GtkScrolledWindow* scrolled_window;
	GtkBox* container;
	GtkBox* main_container;
	GtkButton* left_scroll_button;
	GtkButton* right_scroll_button;
	GList* buttons;
	XfwScreen* screen;
	XfwWorkspaceManager* workspace_manager;
};

struct _Block1Data {
	int _ref_count_;
	TasklistApplet* self;
	XfwWindow* window;
};

static gpointer tasklist_plugin_parent_class = NULL;
static BudgiePluginIface * tasklist_plugin_budgie_plugin_parent_iface = NULL;
static GType tasklist_plugin_type_id = 0;
static gint TasklistSettings_private_offset;
static gpointer tasklist_settings_parent_class = NULL;
static GType tasklist_settings_type_id = 0;
static gint TasklistApplet_private_offset;
static gpointer tasklist_applet_parent_class = NULL;
static GType tasklist_applet_type_id = 0;

static BudgieApplet* tasklist_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                     const gchar* uuid);
static void tasklist_settings_settings_changed (TasklistSettings* self,
                                         const gchar* key);
static void _tasklist_settings_settings_changed_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self);
static void tasklist_settings_finalize (GObject * obj);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean __lambda9_ (TasklistApplet* self);
static void tasklist_applet_on_app_opened (TasklistApplet* self,
                                    XfwWindow* window);
static gboolean ___lambda9__gsource_func (gpointer self);
static gboolean tasklist_applet_real_scroll_event (GtkWidget* base,
                                            GdkEventScroll* event);
static GtkWidget* tasklist_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean tasklist_applet_real_supports_settings (BudgieApplet* base);
static void tasklist_applet_real_update_popovers (BudgieApplet* base,
                                           BudgiePopoverManager* manager);
static void tasklist_applet_setup_workspace_listener (TasklistApplet* self);
static void tasklist_applet_on_active_workspace_changed (TasklistApplet* self,
                                                  XfwWorkspace* previous_workspace);
static void _tasklist_applet_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                              XfwWorkspace* previously_active_workspace,
                                                                                                              gpointer self);
static void tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                                  BudgiePanelPosition position);
static gboolean __lambda12_ (TasklistApplet* self);
static void tasklist_applet_update_scroll_buttons_visibility (TasklistApplet* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void tasklist_applet_button_drag_data_get (TasklistApplet* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context,
                                           GtkSelectionData* data,
                                           guint info,
                                           guint time);
static void tasklist_applet_button_drag_begin (TasklistApplet* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context);
static void tasklist_applet_button_drag_data_received (TasklistApplet* self,
                                                GtkWidget* widget,
                                                GdkDragContext* context,
                                                gint x,
                                                gint y,
                                                GtkSelectionData* data,
                                                guint info,
                                                guint time);
static void tasklist_applet_button_drag_leave (TasklistApplet* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context,
                                        guint time);
static gboolean tasklist_applet_button_drag_motion (TasklistApplet* self,
                                             GtkWidget* widget,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             guint time);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static TasklistButton* tasklist_applet_get_button_for_window (TasklistApplet* self,
                                                       XfwWindow* window);
static void __lambda10_ (Block1Data* _data1_);
static void tasklist_applet_on_app_workspace_changed (TasklistApplet* self,
                                               XfwWindow* window);
static void ___lambda10__libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                              gpointer self);
static void _tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     GtkSelectionData* selection_data,
                                                                     guint info,
                                                                     guint time_,
                                                                     gpointer self);
static void _tasklist_applet_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               gpointer self);
static void _tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                               GdkDragContext* context,
                                                                               gint x,
                                                                               gint y,
                                                                               GtkSelectionData* selection_data,
                                                                               guint info,
                                                                               guint time_,
                                                                               gpointer self);
static gboolean _tasklist_applet_button_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     gint x,
                                                                     gint y,
                                                                     guint time_,
                                                                     gpointer self);
static void _tasklist_applet_button_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               guint time_,
                                                               gpointer self);
static gboolean tasklist_applet_on_button_release (TasklistApplet* self,
                                            GtkWidget* widget,
                                            GdkEventButton* event);
static gboolean _tasklist_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static gboolean __lambda11_ (TasklistApplet* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void tasklist_applet_on_app_closed (TasklistApplet* self,
                                    XfwWindow* window);
static gboolean __lambda13_ (TasklistApplet* self);
static gboolean ___lambda13__gsource_func (gpointer self);
static void tasklist_applet_on_active_window_changed (TasklistApplet* self,
                                               XfwWindow* old_window);
static void tasklist_applet_scroll_beginning (TasklistApplet* self);
static void tasklist_applet_scroll_end (TasklistApplet* self);
static GObject * tasklist_applet_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _tasklist_applet___lambda14_ (TasklistApplet* self);
static void __tasklist_applet___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _tasklist_applet___lambda15_ (TasklistApplet* self);
static void __tasklist_applet___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                                               gpointer self);
static void _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                     gpointer self);
static void _tasklist_applet___lambda16_ (TasklistApplet* self);
static gboolean __lambda17_ (TasklistApplet* self);
static gboolean ___lambda17__gsource_func (gpointer self);
static void __tasklist_applet___lambda16__gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self);
static void _tasklist_applet_on_app_opened_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                            XfwWindow* window,
                                                                            gpointer self);
static void _tasklist_applet_on_app_closed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                            XfwWindow* window,
                                                                            gpointer self);
static void _tasklist_applet_on_active_window_changed_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                               XfwWindow* window,
                                                                                               gpointer self);
static void tasklist_applet_finalize (GObject * obj);
static void _vala_tasklist_applet_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_tasklist_applet_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
GType tasklist_button_register_type (GTypeModule * module);
GType tasklist_button_popover_register_type (GTypeModule * module);

const GtkTargetEntry SOURCE_TARGETS[1] = {{"application/x-wnck-window-id", (guint) 0, (guint) 0}};

static BudgieApplet*
tasklist_plugin_real_get_panel_widget (BudgiePlugin* base,
                                       const gchar* uuid)
{
	TasklistPlugin * self;
	TasklistApplet* _tmp0_;
	BudgieApplet* result;
	self = (TasklistPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = tasklist_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

TasklistPlugin*
tasklist_plugin_construct (GType object_type)
{
	TasklistPlugin * self = NULL;
	self = (TasklistPlugin*) g_object_new (object_type, NULL);
	return self;
}

TasklistPlugin*
tasklist_plugin_new (void)
{
	return tasklist_plugin_construct (TYPE_TASKLIST_PLUGIN);
}

static void
tasklist_plugin_class_init (TasklistPluginClass * klass,
                            gpointer klass_data)
{
	tasklist_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
tasklist_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                              gpointer iface_data)
{
	tasklist_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) tasklist_plugin_real_get_panel_widget;
}

static void
tasklist_plugin_instance_init (TasklistPlugin * self,
                               gpointer klass)
{
}

GType
tasklist_plugin_get_type (void)
{
	return tasklist_plugin_type_id;
}

GType
tasklist_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistPlugin), 0, (GInstanceInitFunc) tasklist_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) tasklist_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	tasklist_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "TasklistPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, tasklist_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return tasklist_plugin_type_id;
}

static inline gpointer
tasklist_settings_get_instance_private (TasklistSettings* self)
{
	return G_STRUCT_MEMBER_P (self, TasklistSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tasklist_settings_settings_changed_g_settings_changed (GSettings* _sender,
                                                        const gchar* key,
                                                        gpointer self)
{
	tasklist_settings_settings_changed ((TasklistSettings*) self, key);
}

TasklistSettings*
tasklist_settings_construct (GType object_type,
                             GSettings* settings)
{
	TasklistSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	self = (TasklistSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_signal_connect_object (settings, "changed::show-icons", (GCallback) _tasklist_settings_settings_changed_g_settings_changed, self, 0);
	g_signal_connect_object (settings, "changed::show-labels", (GCallback) _tasklist_settings_settings_changed_g_settings_changed, self, 0);
	_tmp1_ = self->priv->switch_show_icons;
	g_settings_bind (settings, "show-icons", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_show_labels;
	g_settings_bind (settings, "show-labels", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	tasklist_settings_settings_changed (self, "show-icons");
	tasklist_settings_settings_changed (self, "show-labels");
	return self;
}

TasklistSettings*
tasklist_settings_new (GSettings* settings)
{
	return tasklist_settings_construct (TYPE_TASKLIST_SETTINGS, settings);
}

static void
tasklist_settings_settings_changed (TasklistSettings* self,
                                    const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("show-icons")))) {
		switch (0) {
			default:
			{
				gboolean show_icons = FALSE;
				GSettings* _tmp3_;
				_tmp3_ = self->priv->settings;
				show_icons = g_settings_get_boolean (_tmp3_, key);
				if (show_icons) {
					GtkSwitch* _tmp4_;
					_tmp4_ = self->priv->switch_show_labels;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
				} else {
					GtkSwitch* _tmp5_;
					_tmp5_ = self->priv->switch_show_labels;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("show-labels")))) {
		switch (0) {
			default:
			{
				gboolean show_labels = FALSE;
				GSettings* _tmp6_;
				_tmp6_ = self->priv->settings;
				show_labels = g_settings_get_boolean (_tmp6_, key);
				if (show_labels) {
					GtkSwitch* _tmp7_;
					_tmp7_ = self->priv->switch_show_icons;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
				} else {
					GtkSwitch* _tmp8_;
					_tmp8_ = self->priv->switch_show_icons;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("TasklistApplet.vala:68: Unknown settings key '%s'", key);
				break;
			}
		}
	}
}

static void
tasklist_settings_class_init (TasklistSettingsClass * klass,
                              gpointer klass_data)
{
	tasklist_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasklistSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tasklist_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/tasklist/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_icons", FALSE, TasklistSettings_private_offset + G_STRUCT_OFFSET (TasklistSettingsPrivate, switch_show_icons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_labels", FALSE, TasklistSettings_private_offset + G_STRUCT_OFFSET (TasklistSettingsPrivate, switch_show_labels));
}

static void
tasklist_settings_instance_init (TasklistSettings * self,
                                 gpointer klass)
{
	self->priv = tasklist_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
tasklist_settings_finalize (GObject * obj)
{
	TasklistSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_SETTINGS, TasklistSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (tasklist_settings_parent_class)->finalize (obj);
}

GType
tasklist_settings_get_type (void)
{
	return tasklist_settings_type_id;
}

GType
tasklist_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistSettings), 0, (GInstanceInitFunc) tasklist_settings_instance_init, NULL };
	tasklist_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "TasklistSettings", &g_define_type_info, 0);
	TasklistSettings_private_offset = sizeof (TasklistSettingsPrivate);
	return tasklist_settings_type_id;
}

static inline gpointer
tasklist_applet_get_instance_private (TasklistApplet* self)
{
	return G_STRUCT_MEMBER_P (self, TasklistApplet_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
__lambda9_ (TasklistApplet* self)
{
	XfwScreen* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_windows (_tmp0_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			XfwWindow* _tmp2_;
			XfwWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((XfwWindow*) window_it->data);
			window = _tmp2_;
			{
				XfwWindow* _tmp3_;
				_tmp3_ = window;
				tasklist_applet_on_app_opened (self, _tmp3_);
				_g_object_unref0 (window);
			}
		}
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((TasklistApplet*) self);
	return result;
}

TasklistApplet*
tasklist_applet_construct (GType object_type,
                           const gchar* uuid)
{
	TasklistApplet * self = NULL;
	GSettings* _tmp0_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (TasklistApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.tasklist");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/tasklist");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->settings);
	self->settings = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

TasklistApplet*
tasklist_applet_new (const gchar* uuid)
{
	return tasklist_applet_construct (TYPE_TASKLIST_APPLET, uuid);
}

static gboolean
tasklist_applet_real_scroll_event (GtkWidget* base,
                                   GdkEventScroll* event)
{
	TasklistApplet * self;
	GtkAdjustment* adjustment = NULL;
	GtkBox* _tmp0_;
	GtkAdjustment* _tmp9_;
	gboolean result;
	self = (TasklistApplet*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	adjustment = NULL;
	_tmp0_ = self->priv->container;
	if (gtk_orientable_get_orientation ((GtkOrientable*) _tmp0_) == GTK_ORIENTATION_HORIZONTAL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		_tmp1_ = self->priv->scrolled_window;
		_tmp2_ = gtk_scrolled_window_get_hadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp4_;
	} else {
		GtkScrolledWindow* _tmp5_;
		GtkAdjustment* _tmp6_;
		GtkAdjustment* _tmp7_;
		GtkAdjustment* _tmp8_;
		_tmp5_ = self->priv->scrolled_window;
		_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp8_;
	}
	_tmp9_ = adjustment;
	if (_tmp9_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (adjustment);
		return result;
	}
	switch (event->direction) {
		case GDK_SCROLL_UP:
		case GDK_SCROLL_LEFT:
		{
			GtkAdjustment* _tmp10_;
			GtkAdjustment* _tmp11_;
			gdouble _tmp12_;
			gdouble _tmp13_;
			GtkAdjustment* _tmp14_;
			gdouble _tmp15_;
			gdouble _tmp16_;
			_tmp10_ = adjustment;
			_tmp11_ = adjustment;
			_tmp12_ = gtk_adjustment_get_lower (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = adjustment;
			_tmp15_ = gtk_adjustment_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			gtk_adjustment_set_value (_tmp10_, MAX (_tmp13_, _tmp16_ - 50));
			break;
		}
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_RIGHT:
		{
			GtkAdjustment* _tmp17_;
			GtkAdjustment* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			GtkAdjustment* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			GtkAdjustment* _tmp24_;
			gdouble _tmp25_;
			gdouble _tmp26_;
			_tmp17_ = adjustment;
			_tmp18_ = adjustment;
			_tmp19_ = gtk_adjustment_get_upper (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = adjustment;
			_tmp22_ = gtk_adjustment_get_page_size (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = adjustment;
			_tmp25_ = gtk_adjustment_get_value (_tmp24_);
			_tmp26_ = _tmp25_;
			gtk_adjustment_set_value (_tmp17_, MIN (_tmp20_ - _tmp23_, _tmp26_ + 50));
			break;
		}
		default:
		{
			break;
		}
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (adjustment);
	return result;
}

static GtkWidget*
tasklist_applet_real_get_settings_ui (BudgieApplet* base)
{
	TasklistApplet * self;
	GSettings* applet_settings = NULL;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	TasklistSettings* _tmp2_;
	GtkWidget* result;
	self = (TasklistApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	applet_settings = _tmp1_;
	_tmp2_ = tasklist_settings_new (applet_settings);
	g_object_ref_sink (_tmp2_);
	result = (GtkWidget*) _tmp2_;
	_g_object_unref0 (applet_settings);
	return result;
}

static gboolean
tasklist_applet_real_supports_settings (BudgieApplet* base)
{
	TasklistApplet * self;
	gboolean result;
	self = (TasklistApplet*) base;
	result = TRUE;
	return result;
}

static void
tasklist_applet_real_update_popovers (BudgieApplet* base,
                                      BudgiePopoverManager* manager)
{
	TasklistApplet * self;
	self = (TasklistApplet*) base;
	self->priv->popover_manager = manager;
}

static void
_tasklist_applet_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                         XfwWorkspace* previously_active_workspace,
                                                                                                         gpointer self)
{
	tasklist_applet_on_active_workspace_changed ((TasklistApplet*) self, previously_active_workspace);
}

static void
tasklist_applet_setup_workspace_listener (TasklistApplet* self)
{
	XfwScreen* _tmp0_;
	XfwWorkspaceManager* _tmp1_;
	GList* groups = NULL;
	XfwWorkspaceManager* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* element = NULL;
	GList* _tmp5_;
	GList* _tmp6_;
	XfwWorkspaceGroup* group = NULL;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	XfwWorkspaceGroup* _tmp9_;
	XfwWorkspaceGroup* _tmp10_;
	XfwWorkspaceGroup* _tmp11_;
	XfwWorkspaceGroup* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_workspace_manager (_tmp0_);
	self->priv->workspace_manager = _tmp1_;
	_tmp2_ = self->priv->workspace_manager;
	_tmp3_ = xfw_workspace_manager_list_workspace_groups (_tmp2_);
	groups = _tmp3_;
	_tmp4_ = groups;
	if (_tmp4_ == NULL) {
		return;
	}
	_tmp5_ = groups;
	_tmp6_ = g_list_first (_tmp5_);
	element = _tmp6_;
	_tmp7_ = element;
	_tmp8_ = _tmp7_->data;
	_tmp9_ = (XfwWorkspaceGroup*) _tmp8_;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, xfw_workspace_group_get_type ()) ? ((XfwWorkspaceGroup*) _tmp9_) : NULL);
	group = _tmp10_;
	_tmp11_ = group;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (group);
		return;
	}
	_tmp12_ = group;
	g_signal_connect_object (_tmp12_, "active-workspace-changed", (GCallback) _tasklist_applet_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed, self, 0);
	_g_object_unref0 (group);
}

/**
 * Update the tasklist orientation to match the panel direction
 */
static gboolean
__lambda12_ (TasklistApplet* self)
{
	gboolean result;
	tasklist_applet_update_scroll_buttons_visibility (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((TasklistApplet*) self);
	return result;
}

static void
tasklist_applet_real_panel_position_changed (BudgieApplet* base,
                                             BudgiePanelPosition position)
{
	TasklistApplet * self;
	GtkOrientation orientation = 0;
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp1_;
	GtkScrolledWindow* _tmp40_;
	self = (TasklistApplet*) base;
	orientation = GTK_ORIENTATION_HORIZONTAL;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orientation = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->priv->container;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, orientation);
	if (orientation == GTK_ORIENTATION_HORIZONTAL) {
		GtkScrolledWindow* _tmp2_;
		GtkScrolledWindow* _tmp3_;
		GtkImage* left_image = NULL;
		GtkButton* _tmp4_;
		GtkWidget* _tmp5_;
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* right_image = NULL;
		GtkButton* _tmp12_;
		GtkWidget* _tmp13_;
		GtkImage* _tmp14_;
		GtkImage* _tmp15_;
		GtkBox* _tmp20_;
		_tmp2_ = self->priv->scrolled_window;
		g_object_set (_tmp2_, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
		_tmp3_ = self->priv->scrolled_window;
		g_object_set (_tmp3_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
		_tmp4_ = self->priv->left_scroll_button;
		_tmp5_ = gtk_button_get_image (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_image_get_type ()) ? ((GtkImage*) _tmp5_) : NULL);
		left_image = _tmp6_;
		_tmp7_ = left_image;
		if (_tmp7_ != NULL) {
			GtkImage* _tmp8_;
			_tmp8_ = left_image;
			gtk_image_set_from_icon_name (_tmp8_, "go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
		} else {
			GtkButton* _tmp9_;
			GtkImage* _tmp10_;
			GtkImage* _tmp11_;
			_tmp9_ = self->priv->left_scroll_button;
			_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
			g_object_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			gtk_button_set_image (_tmp9_, (GtkWidget*) _tmp11_);
			_g_object_unref0 (_tmp11_);
		}
		_tmp12_ = self->priv->right_scroll_button;
		_tmp13_ = gtk_button_get_image (_tmp12_);
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_image_get_type ()) ? ((GtkImage*) _tmp13_) : NULL);
		right_image = _tmp14_;
		_tmp15_ = right_image;
		if (_tmp15_ != NULL) {
			GtkImage* _tmp16_;
			_tmp16_ = right_image;
			gtk_image_set_from_icon_name (_tmp16_, "go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
		} else {
			GtkButton* _tmp17_;
			GtkImage* _tmp18_;
			GtkImage* _tmp19_;
			_tmp17_ = self->priv->right_scroll_button;
			_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
			g_object_ref_sink (_tmp18_);
			_tmp19_ = _tmp18_;
			gtk_button_set_image (_tmp17_, (GtkWidget*) _tmp19_);
			_g_object_unref0 (_tmp19_);
		}
		_tmp20_ = self->priv->main_container;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp20_, GTK_ORIENTATION_HORIZONTAL);
		_g_object_unref0 (right_image);
		_g_object_unref0 (left_image);
	} else {
		GtkScrolledWindow* _tmp21_;
		GtkScrolledWindow* _tmp22_;
		GtkImage* left_image = NULL;
		GtkButton* _tmp23_;
		GtkWidget* _tmp24_;
		GtkImage* _tmp25_;
		GtkImage* _tmp26_;
		GtkImage* right_image = NULL;
		GtkButton* _tmp31_;
		GtkWidget* _tmp32_;
		GtkImage* _tmp33_;
		GtkImage* _tmp34_;
		GtkBox* _tmp39_;
		_tmp21_ = self->priv->scrolled_window;
		g_object_set (_tmp21_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
		_tmp22_ = self->priv->scrolled_window;
		g_object_set (_tmp22_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
		_tmp23_ = self->priv->left_scroll_button;
		_tmp24_ = gtk_button_get_image (_tmp23_);
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gtk_image_get_type ()) ? ((GtkImage*) _tmp24_) : NULL);
		left_image = _tmp25_;
		_tmp26_ = left_image;
		if (_tmp26_ != NULL) {
			GtkImage* _tmp27_;
			_tmp27_ = left_image;
			gtk_image_set_from_icon_name (_tmp27_, "go-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
		} else {
			GtkButton* _tmp28_;
			GtkImage* _tmp29_;
			GtkImage* _tmp30_;
			_tmp28_ = self->priv->left_scroll_button;
			_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("go-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
			g_object_ref_sink (_tmp29_);
			_tmp30_ = _tmp29_;
			gtk_button_set_image (_tmp28_, (GtkWidget*) _tmp30_);
			_g_object_unref0 (_tmp30_);
		}
		_tmp31_ = self->priv->right_scroll_button;
		_tmp32_ = gtk_button_get_image (_tmp31_);
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gtk_image_get_type ()) ? ((GtkImage*) _tmp32_) : NULL);
		right_image = _tmp33_;
		_tmp34_ = right_image;
		if (_tmp34_ != NULL) {
			GtkImage* _tmp35_;
			_tmp35_ = right_image;
			gtk_image_set_from_icon_name (_tmp35_, "go-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
		} else {
			GtkButton* _tmp36_;
			GtkImage* _tmp37_;
			GtkImage* _tmp38_;
			_tmp36_ = self->priv->right_scroll_button;
			_tmp37_ = (GtkImage*) gtk_image_new_from_icon_name ("go-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
			g_object_ref_sink (_tmp37_);
			_tmp38_ = _tmp37_;
			gtk_button_set_image (_tmp36_, (GtkWidget*) _tmp38_);
			_g_object_unref0 (_tmp38_);
		}
		_tmp39_ = self->priv->main_container;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp39_, GTK_ORIENTATION_VERTICAL);
		_g_object_unref0 (right_image);
		_g_object_unref0 (left_image);
	}
	_tmp40_ = self->priv->scrolled_window;
	gtk_widget_queue_resize ((GtkWidget*) _tmp40_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

/**
 * Handles the drag_data_get signal for a tasklist button.
 *
 * This sets the button's window desktop-id as the drag data.
 */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
tasklist_applet_button_drag_data_get (TasklistApplet* self,
                                      GtkWidget* widget,
                                      GdkDragContext* context,
                                      GtkSelectionData* data,
                                      guint info,
                                      guint time)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	gchar* id = NULL;
	XfwWindow* _tmp1_;
	XfwWindow* _tmp2_;
	XfwApplication* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = _g_object_ref0 (IS_TASKLIST_BUTTON (widget) ? ((TasklistButton*) widget) : NULL);
	button = _tmp0_;
	_tmp1_ = tasklist_button_get_window (button);
	_tmp2_ = _tmp1_;
	_tmp3_ = xfw_window_get_application (_tmp2_);
	_tmp4_ = xfw_application_get_class_id (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	_tmp6_ = string_get_data (id, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	gtk_selection_data_set (data, gtk_selection_data_get_target (data), 8, _tmp8_, (gint) _tmp8__length1);
	_g_free0 (id);
	_g_object_unref0 (button);
}

/**
 * Handles the drag_begin signal for a tasklist button.
 *
 * This sets the icon at the cursor when the button is dragged.
 */
static void
tasklist_applet_button_drag_begin (TasklistApplet* self,
                                   GtkWidget* widget,
                                   GdkDragContext* context)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	gint size = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gint scale_factor = 0;
	TasklistButton* _tmp3_;
	GdkPixbuf* pixbuf = NULL;
	TasklistButton* _tmp4_;
	XfwWindow* _tmp5_;
	XfwWindow* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _g_object_ref0 (IS_TASKLIST_BUTTON (widget) ? ((TasklistButton*) widget) : NULL);
	button = _tmp0_;
	size = 0;
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp1_, NULL);
	size = _tmp1_;
	if (!_tmp2_) {
		size = 32;
	}
	_tmp3_ = button;
	scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) _tmp3_);
	_tmp4_ = button;
	_tmp5_ = tasklist_button_get_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = xfw_window_get_icon (_tmp6_, size, scale_factor);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	pixbuf = _tmp8_;
	_tmp9_ = pixbuf;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (button);
		return;
	}
	_tmp10_ = pixbuf;
	_tmp11_ = gdk_cairo_surface_create_from_pixbuf (_tmp10_, scale_factor, NULL);
	surface = _tmp11_;
	_tmp12_ = surface;
	gtk_drag_set_icon_surface (context, _tmp12_);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (button);
}

/**
 * Handles when a drag item is dropped on a tasklist button.
 *
 * If the source widget is another tasklist button, reorder the widgets in
 * our container so that the dropped button is put in the place of this
 * button.
 */
static void
tasklist_applet_button_drag_data_received (TasklistApplet* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context,
                                           gint x,
                                           gint y,
                                           GtkSelectionData* data,
                                           guint info,
                                           guint time)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	GtkWidget* source = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GList* children = NULL;
	GtkBox* _tmp4_;
	GList* _tmp5_;
	GList* _self_ = NULL;
	GList* _tmp6_;
	TasklistButton* _tmp7_;
	GList* _tmp8_;
	gint position = 0;
	GList* _tmp9_;
	GList* _tmp10_;
	GtkBox* _tmp11_;
	GtkWidget* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = _g_object_ref0 (IS_TASKLIST_BUTTON (widget) ? ((TasklistButton*) widget) : NULL);
	button = _tmp0_;
	_tmp1_ = gtk_drag_get_source_widget (context);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source = _tmp2_;
	_tmp3_ = source;
	if (!IS_TASKLIST_BUTTON (_tmp3_)) {
		_g_object_unref0 (source);
		_g_object_unref0 (button);
		return;
	}
	_tmp4_ = self->priv->container;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	children = _tmp5_;
	_tmp6_ = children;
	_tmp7_ = button;
	_tmp8_ = g_list_find (_tmp6_, (GtkWidget*) _tmp7_);
	_self_ = _tmp8_;
	_tmp9_ = children;
	_tmp10_ = _self_;
	position = g_list_position (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->container;
	_tmp12_ = source;
	gtk_box_reorder_child (_tmp11_, _tmp12_, position);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	_g_object_unref0 (source);
	_g_object_unref0 (button);
}

/**
 * Handles when the cursor leaves the space of a button during a drag.
 */
static void
tasklist_applet_button_drag_leave (TasklistApplet* self,
                                   GtkWidget* widget,
                                   GdkDragContext* context,
                                   guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	gtk_drag_unhighlight (widget);
}

/**
 * Handles when a widget is dragged over a tasklist button.
 */
static gboolean
tasklist_applet_button_drag_motion (TasklistApplet* self,
                                    GtkWidget* widget,
                                    GdkDragContext* context,
                                    gint x,
                                    gint y,
                                    guint time)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	GtkWidget* source = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_;
	GdkAtom ret = (GdkAtom) 0U;
	TasklistButton* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (IS_TASKLIST_BUTTON (widget) ? ((TasklistButton*) widget) : NULL);
	button = _tmp0_;
	_tmp1_ = gtk_drag_get_source_widget (context);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source = _tmp2_;
	_tmp4_ = source;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = source;
		_tmp3_ = !IS_TASKLIST_BUTTON (_tmp5_);
	}
	if (_tmp3_) {
		gdk_drag_status (context, 0, (guint32) time);
		result = TRUE;
		_g_object_unref0 (source);
		_g_object_unref0 (button);
		return result;
	}
	_tmp6_ = button;
	ret = gtk_drag_dest_find_target ((GtkWidget*) _tmp6_, context, NULL);
	if (ret != GDK_NONE) {
		TasklistButton* _tmp7_;
		_tmp7_ = button;
		gtk_drag_highlight ((GtkWidget*) _tmp7_);
		gdk_drag_status (context, GDK_ACTION_MOVE, (guint32) time);
		result = TRUE;
		_g_object_unref0 (source);
		_g_object_unref0 (button);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (source);
	_g_object_unref0 (button);
	return result;
}

/**
 * Create a button for the newly opened app and add it to our tracking map.
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TasklistApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda10_ (Block1Data* _data1_)
{
	TasklistApplet* self;
	self = _data1_->self;
	tasklist_applet_on_app_workspace_changed (self, _data1_->window);
}

static void
___lambda10__libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                         gpointer self)
{
	__lambda10_ (self);
}

static void
_tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                GdkDragContext* context,
                                                                GtkSelectionData* selection_data,
                                                                guint info,
                                                                guint time_,
                                                                gpointer self)
{
	tasklist_applet_button_drag_data_get ((TasklistApplet*) self, _sender, context, selection_data, info, time_);
}

static void
_tasklist_applet_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          gpointer self)
{
	tasklist_applet_button_drag_begin ((TasklistApplet*) self, _sender, context);
}

static void
_tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          gint x,
                                                                          gint y,
                                                                          GtkSelectionData* selection_data,
                                                                          guint info,
                                                                          guint time_,
                                                                          gpointer self)
{
	tasklist_applet_button_drag_data_received ((TasklistApplet*) self, _sender, context, x, y, selection_data, info, time_);
}

static gboolean
_tasklist_applet_button_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                            GdkDragContext* context,
                                                            gint x,
                                                            gint y,
                                                            guint time_,
                                                            gpointer self)
{
	gboolean result;
	result = tasklist_applet_button_drag_motion ((TasklistApplet*) self, _sender, context, x, y, time_);
	return result;
}

static void
_tasklist_applet_button_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          guint time_,
                                                          gpointer self)
{
	tasklist_applet_button_drag_leave ((TasklistApplet*) self, _sender, context, time_);
}

static gboolean
_tasklist_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self)
{
	gboolean result;
	result = tasklist_applet_on_button_release ((TasklistApplet*) self, _sender, event);
	return result;
}

static gboolean
__lambda11_ (TasklistApplet* self)
{
	gboolean result;
	tasklist_applet_update_scroll_buttons_visibility (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((TasklistApplet*) self);
	return result;
}

static void
tasklist_applet_on_app_opened (TasklistApplet* self,
                               XfwWindow* window)
{
	Block1Data* _data1_;
	XfwWindow* _tmp0_;
	TasklistButton* _tmp1_;
	TasklistButton* _tmp2_;
	gboolean _tmp3_;
	TasklistButton* button = NULL;
	BudgiePopoverManager* _tmp4_;
	GSettings* _tmp5_;
	TasklistButton* _tmp6_;
	TasklistButton* _tmp7_;
	TasklistButton* _tmp8_;
	TasklistButton* _tmp9_;
	TasklistButton* _tmp10_;
	TasklistButton* _tmp11_;
	TasklistButton* _tmp12_;
	TasklistButton* _tmp13_;
	TasklistButton* _tmp14_;
	GtkBox* _tmp15_;
	TasklistButton* _tmp16_;
	TasklistButton* _tmp17_;
	TasklistButton* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data1_->window);
	_data1_->window = _tmp0_;
	if (xfw_window_is_skip_tasklist (_data1_->window)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp1_ = tasklist_applet_get_button_for_window (self, _data1_->window);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	g_signal_connect_data (_data1_->window, "workspace-changed", (GCallback) ___lambda10__libxfce4windowing_window_workspace_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp4_ = self->priv->popover_manager;
	_tmp5_ = self->settings;
	_tmp6_ = tasklist_button_new (_data1_->window, _tmp4_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	button = _tmp6_;
	_tmp7_ = button;
	gtk_drag_source_set ((GtkWidget*) _tmp7_, GDK_BUTTON1_MASK, SOURCE_TARGETS, (gint) G_N_ELEMENTS (SOURCE_TARGETS), GDK_ACTION_MOVE);
	_tmp8_ = button;
	gtk_drag_dest_set ((GtkWidget*) _tmp8_, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, SOURCE_TARGETS, (gint) G_N_ELEMENTS (SOURCE_TARGETS), GDK_ACTION_MOVE);
	_tmp9_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "drag-data-get", (GCallback) _tasklist_applet_button_drag_data_get_gtk_widget_drag_data_get, self, 0);
	_tmp10_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "drag-begin", (GCallback) _tasklist_applet_button_drag_begin_gtk_widget_drag_begin, self, 0);
	_tmp11_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "drag-data-received", (GCallback) _tasklist_applet_button_drag_data_received_gtk_widget_drag_data_received, self, 0);
	_tmp12_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "drag-motion", (GCallback) _tasklist_applet_button_drag_motion_gtk_widget_drag_motion, self, 0);
	_tmp13_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "drag-leave", (GCallback) _tasklist_applet_button_drag_leave_gtk_widget_drag_leave, self, 0);
	_tmp14_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "button-release-event", (GCallback) _tasklist_applet_on_button_release_gtk_widget_button_release_event, self, 0);
	_tmp15_ = self->priv->container;
	_tmp16_ = button;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = button;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	self->priv->buttons = g_list_append (self->priv->buttons, _tmp18_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (button);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
 * Gracefully remove button associated with app and remove it from our
 * tracking map.
 */
static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static gboolean
__lambda13_ (TasklistApplet* self)
{
	gboolean result;
	tasklist_applet_update_scroll_buttons_visibility (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((TasklistApplet*) self);
	return result;
}

static void
tasklist_applet_on_app_closed (TasklistApplet* self,
                               XfwWindow* window)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	TasklistButton* _tmp1_;
	TasklistButton* _tmp2_;
	TasklistButton* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = tasklist_applet_get_button_for_window (self, window);
	button = _tmp0_;
	_tmp1_ = button;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (button);
		return;
	}
	_tmp2_ = button;
	tasklist_button_gracefully_die (_tmp2_);
	_tmp3_ = button;
	self->priv->buttons = vala_g_list_remove_full (self->priv->buttons, _tmp3_, _g_object_unref0_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (button);
}

/**
 * Manage active state of buttons, mark button associated with new active
 * app as active and previous active button as inactive.
 */
static void
tasklist_applet_on_active_window_changed (TasklistApplet* self,
                                          XfwWindow* old_window)
{
	XfwWindow* active_window = NULL;
	XfwScreen* _tmp3_;
	XfwWindow* _tmp4_;
	XfwWindow* _tmp5_;
	XfwWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	if (old_window != NULL) {
		TasklistButton* button = NULL;
		TasklistButton* _tmp0_;
		TasklistButton* _tmp1_;
		TasklistButton* _tmp2_;
		_tmp0_ = tasklist_applet_get_button_for_window (self, old_window);
		button = _tmp0_;
		_tmp1_ = button;
		if (_tmp1_ == NULL) {
			_g_object_unref0 (button);
			return;
		}
		_tmp2_ = button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, FALSE);
		_g_object_unref0 (button);
	}
	_tmp3_ = self->priv->screen;
	_tmp4_ = xfw_screen_get_active_window (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	active_window = _tmp5_;
	_tmp6_ = active_window;
	if (_tmp6_ != NULL) {
		TasklistButton* button = NULL;
		XfwWindow* _tmp7_;
		TasklistButton* _tmp8_;
		TasklistButton* _tmp9_;
		TasklistButton* _tmp10_;
		_tmp7_ = active_window;
		_tmp8_ = tasklist_applet_get_button_for_window (self, _tmp7_);
		button = _tmp8_;
		_tmp9_ = button;
		if (_tmp9_ == NULL) {
			_g_object_unref0 (button);
			_g_object_unref0 (active_window);
			return;
		}
		_tmp10_ = button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp10_, TRUE);
		_g_object_unref0 (button);
	}
	_g_object_unref0 (active_window);
}

/**
 * Go through the managed buttons list and check if they should be
 * displayed for the current workspace.
 */
static void
tasklist_applet_on_active_workspace_changed (TasklistApplet* self,
                                             XfwWorkspace* previous_workspace)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			TasklistButton* _tmp1_;
			TasklistButton* button = NULL;
			_tmp1_ = _g_object_ref0 ((TasklistButton*) button_it->data);
			button = _tmp1_;
			{
				TasklistButton* _tmp2_;
				XfwWindow* _tmp3_;
				XfwWindow* _tmp4_;
				_tmp2_ = button;
				_tmp3_ = tasklist_button_get_window (_tmp2_);
				_tmp4_ = _tmp3_;
				tasklist_applet_on_app_workspace_changed (self, _tmp4_);
				_g_object_unref0 (button);
			}
		}
	}
}

/**
 * Show / Hide button attached to the app depending on if it is in the
 * current workspace.
 */
static void
tasklist_applet_on_app_workspace_changed (TasklistApplet* self,
                                          XfwWindow* window)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	TasklistButton* _tmp1_;
	XfwWorkspace* _tmp2_;
	XfwWorkspace* _tmp3_;
	XfwWorkspace* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = tasklist_applet_get_button_for_window (self, window);
	button = _tmp0_;
	_tmp1_ = button;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (button);
		return;
	}
	g_object_get (window, "workspace", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = xfw_workspace_get_state (_tmp4_) == XFW_WORKSPACE_STATE_ACTIVE;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		TasklistButton* _tmp6_;
		TasklistButton* _tmp7_;
		_tmp6_ = button;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp7_ = button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, FALSE);
	} else {
		TasklistButton* _tmp8_;
		TasklistButton* _tmp9_;
		_tmp8_ = button;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		_tmp9_ = button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, TRUE);
	}
	_g_object_unref0 (button);
}

/**
 * Get the tasklist button for a window, if one exists.
 *
 * @returns a TasklistButton, or NULL
 */
static TasklistButton*
tasklist_applet_get_button_for_window (TasklistApplet* self,
                                       XfwWindow* window)
{
	GList* _tmp0_;
	TasklistButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = self->priv->buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			TasklistButton* _tmp1_;
			TasklistButton* button = NULL;
			_tmp1_ = _g_object_ref0 ((TasklistButton*) button_it->data);
			button = _tmp1_;
			{
				TasklistButton* _tmp2_;
				XfwWindow* _tmp3_;
				XfwWindow* _tmp4_;
				_tmp2_ = button;
				_tmp3_ = tasklist_button_get_window (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == window) {
					result = button;
					return result;
				}
				_g_object_unref0 (button);
			}
		}
	}
	result = NULL;
	return result;
}

/**
 * Scroll towards the beginning (left for horizontal, up for vertical).
 */
static void
tasklist_applet_scroll_beginning (TasklistApplet* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkBox* _tmp0_;
	GtkAdjustment* _tmp9_;
	g_return_if_fail (self != NULL);
	adjustment = NULL;
	_tmp0_ = self->priv->container;
	if (gtk_orientable_get_orientation ((GtkOrientable*) _tmp0_) == GTK_ORIENTATION_HORIZONTAL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		_tmp1_ = self->priv->scrolled_window;
		_tmp2_ = gtk_scrolled_window_get_hadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp4_;
	} else {
		GtkScrolledWindow* _tmp5_;
		GtkAdjustment* _tmp6_;
		GtkAdjustment* _tmp7_;
		GtkAdjustment* _tmp8_;
		_tmp5_ = self->priv->scrolled_window;
		_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp8_;
	}
	_tmp9_ = adjustment;
	if (_tmp9_ != NULL) {
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		GtkAdjustment* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		GtkAdjustment* _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_;
		_tmp10_ = adjustment;
		_tmp11_ = adjustment;
		_tmp12_ = gtk_adjustment_get_lower (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = adjustment;
		_tmp15_ = gtk_adjustment_get_value (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = adjustment;
		_tmp18_ = gtk_adjustment_get_page_size (_tmp17_);
		_tmp19_ = _tmp18_;
		gtk_adjustment_set_value (_tmp10_, MAX (_tmp13_, _tmp16_ - _tmp19_));
	}
	_g_object_unref0 (adjustment);
}

/**
 * Scroll towards the end (right for horizontal, down for vertical).
 */
static void
tasklist_applet_scroll_end (TasklistApplet* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkBox* _tmp0_;
	GtkAdjustment* _tmp9_;
	g_return_if_fail (self != NULL);
	adjustment = NULL;
	_tmp0_ = self->priv->container;
	if (gtk_orientable_get_orientation ((GtkOrientable*) _tmp0_) == GTK_ORIENTATION_HORIZONTAL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		_tmp1_ = self->priv->scrolled_window;
		_tmp2_ = gtk_scrolled_window_get_hadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp4_;
	} else {
		GtkScrolledWindow* _tmp5_;
		GtkAdjustment* _tmp6_;
		GtkAdjustment* _tmp7_;
		GtkAdjustment* _tmp8_;
		_tmp5_ = self->priv->scrolled_window;
		_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp8_;
	}
	_tmp9_ = adjustment;
	if (_tmp9_ != NULL) {
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		GtkAdjustment* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		GtkAdjustment* _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_;
		GtkAdjustment* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp10_ = adjustment;
		_tmp11_ = adjustment;
		_tmp12_ = gtk_adjustment_get_upper (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = adjustment;
		_tmp15_ = gtk_adjustment_get_page_size (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = adjustment;
		_tmp18_ = gtk_adjustment_get_value (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = adjustment;
		_tmp21_ = gtk_adjustment_get_page_size (_tmp20_);
		_tmp22_ = _tmp21_;
		gtk_adjustment_set_value (_tmp10_, MIN (_tmp13_ - _tmp16_, _tmp19_ + _tmp22_));
	}
	_g_object_unref0 (adjustment);
}

/**
 * Update the visibility and enabled state of scroll buttons based on whether scrolling is possible.
 */
static void
tasklist_applet_update_scroll_buttons_visibility (TasklistApplet* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkBox* _tmp0_;
	GtkAdjustment* _tmp9_;
	gboolean is_scrollable = FALSE;
	GtkAdjustment* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	GtkAdjustment* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gboolean can_scroll_beginning = FALSE;
	GtkAdjustment* _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	GtkAdjustment* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gboolean can_scroll_end = FALSE;
	GtkAdjustment* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	GtkAdjustment* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	GtkAdjustment* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	GtkButton* _tmp33_;
	GtkButton* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	g_return_if_fail (self != NULL);
	adjustment = NULL;
	_tmp0_ = self->priv->container;
	if (gtk_orientable_get_orientation ((GtkOrientable*) _tmp0_) == GTK_ORIENTATION_HORIZONTAL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		_tmp1_ = self->priv->scrolled_window;
		_tmp2_ = gtk_scrolled_window_get_hadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp4_;
	} else {
		GtkScrolledWindow* _tmp5_;
		GtkAdjustment* _tmp6_;
		GtkAdjustment* _tmp7_;
		GtkAdjustment* _tmp8_;
		_tmp5_ = self->priv->scrolled_window;
		_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (adjustment);
		adjustment = _tmp8_;
	}
	_tmp9_ = adjustment;
	if (_tmp9_ == NULL) {
		GtkButton* _tmp10_;
		GtkButton* _tmp11_;
		_tmp10_ = self->priv->left_scroll_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
		_tmp11_ = self->priv->right_scroll_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
		_g_object_unref0 (adjustment);
		return;
	}
	_tmp12_ = adjustment;
	_tmp13_ = gtk_adjustment_get_upper (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = adjustment;
	_tmp16_ = gtk_adjustment_get_page_size (_tmp15_);
	_tmp17_ = _tmp16_;
	is_scrollable = _tmp14_ > _tmp17_;
	_tmp18_ = adjustment;
	_tmp19_ = gtk_adjustment_get_value (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = adjustment;
	_tmp22_ = gtk_adjustment_get_lower (_tmp21_);
	_tmp23_ = _tmp22_;
	can_scroll_beginning = _tmp20_ > _tmp23_;
	_tmp24_ = adjustment;
	_tmp25_ = gtk_adjustment_get_value (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = adjustment;
	_tmp28_ = gtk_adjustment_get_upper (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = adjustment;
	_tmp31_ = gtk_adjustment_get_page_size (_tmp30_);
	_tmp32_ = _tmp31_;
	can_scroll_end = _tmp26_ < (_tmp29_ - _tmp32_);
	_tmp33_ = self->priv->left_scroll_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp33_, is_scrollable);
	_tmp34_ = self->priv->right_scroll_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp34_, is_scrollable);
	_tmp35_ = self->priv->left_scroll_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, can_scroll_beginning);
	_tmp36_ = self->priv->right_scroll_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, can_scroll_end);
	_g_object_unref0 (adjustment);
}

/**
 * Handle button release events for tasklist buttons.
 */
static gboolean
tasklist_applet_on_button_release (TasklistApplet* self,
                                   GtkWidget* widget,
                                   GdkEventButton* event)
{
	TasklistButton* button = NULL;
	TasklistButton* _tmp0_;
	guint32 time = 0U;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (IS_TASKLIST_BUTTON (widget) ? ((TasklistButton*) widget) : NULL);
	button = _tmp0_;
	time = event->time;
	switch (event->button) {
		case GDK_BUTTON_PRIMARY:
		{
			TasklistButton* _tmp1_;
			XfwWindow* _tmp2_;
			XfwWindow* _tmp3_;
			XfwWindowState _tmp4_;
			XfwWindowState _tmp5_;
			_tmp1_ = button;
			_tmp2_ = tasklist_button_get_window (_tmp1_);
			_tmp3_ = _tmp2_;
			g_object_get (_tmp3_, "state", &_tmp4_, NULL);
			_tmp5_ = _tmp4_;
			if (_tmp5_ == XFW_WINDOW_STATE_ACTIVE) {
				{
					TasklistButton* _tmp6_;
					XfwWindow* _tmp7_;
					XfwWindow* _tmp8_;
					_tmp6_ = button;
					_tmp7_ = tasklist_button_get_window (_tmp6_);
					_tmp8_ = _tmp7_;
					xfw_window_set_minimized (_tmp8_, TRUE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					TasklistButton* _tmp9_;
					XfwWindow* _tmp10_;
					XfwWindow* _tmp11_;
					const gchar* _tmp12_;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp9_ = button;
					_tmp10_ = tasklist_button_get_window (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = xfw_window_get_name (_tmp11_);
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_warning ("TasklistApplet.vala:580: Unable to minimize window '%s': %s", _tmp12_, _tmp14_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp15_ = FALSE;
					_g_object_unref0 (button);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp15_;
				}
			} else {
				{
					TasklistButton* _tmp16_;
					XfwWindow* _tmp17_;
					XfwWindow* _tmp18_;
					_tmp16_ = button;
					_tmp17_ = tasklist_button_get_window (_tmp16_);
					_tmp18_ = _tmp17_;
					xfw_window_activate (_tmp18_, NULL, (guint64) time, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					TasklistButton* _tmp19_;
					XfwWindow* _tmp20_;
					XfwWindow* _tmp21_;
					const gchar* _tmp22_;
					GError* _tmp23_;
					const gchar* _tmp24_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp19_ = button;
					_tmp20_ = tasklist_button_get_window (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = xfw_window_get_name (_tmp21_);
					_tmp23_ = e;
					_tmp24_ = _tmp23_->message;
					g_warning ("TasklistApplet.vala:586: Unable to activate window '%s': %s", _tmp22_, _tmp24_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp25_ = FALSE;
					_g_object_unref0 (button);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp25_;
				}
			}
			break;
		}
		case GDK_BUTTON_SECONDARY:
		{
			BudgiePopoverManager* _tmp26_;
			TasklistButton* _tmp27_;
			_tmp26_ = self->priv->popover_manager;
			_tmp27_ = button;
			budgie_popover_manager_show_popover (_tmp26_, (GtkWidget*) _tmp27_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (button);
			return result;
		}
		case GDK_BUTTON_MIDDLE:
		{
			{
				TasklistButton* _tmp28_;
				XfwWindow* _tmp29_;
				XfwWindow* _tmp30_;
				_tmp28_ = button;
				_tmp29_ = tasklist_button_get_window (_tmp28_);
				_tmp30_ = _tmp29_;
				xfw_window_close (_tmp30_, (guint64) time, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				TasklistButton* _tmp31_;
				XfwWindow* _tmp32_;
				XfwWindow* _tmp33_;
				const gchar* _tmp34_;
				GError* _tmp35_;
				const gchar* _tmp36_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp31_ = button;
				_tmp32_ = tasklist_button_get_window (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = xfw_window_get_name (_tmp33_);
				_tmp35_ = e;
				_tmp36_ = _tmp35_->message;
				g_warning ("TasklistApplet.vala:597: Unable to close window '%s': %s", _tmp34_, _tmp36_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp37_ = FALSE;
				_g_object_unref0 (button);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp37_;
			}
			result = GDK_EVENT_STOP;
			_g_object_unref0 (button);
			return result;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (button);
	return result;
}

const gchar*
tasklist_applet_get_uuid (TasklistApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
tasklist_applet_set_uuid (TasklistApplet* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasklist_applet_properties[TASKLIST_APPLET_UUID_PROPERTY]);
	}
}

static void
_tasklist_applet___lambda14_ (TasklistApplet* self)
{
	tasklist_applet_scroll_beginning (self);
}

static void
__tasklist_applet___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_tasklist_applet___lambda14_ ((TasklistApplet*) self);
}

static void
_tasklist_applet___lambda15_ (TasklistApplet* self)
{
	tasklist_applet_scroll_end (self);
}

static void
__tasklist_applet___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_tasklist_applet___lambda15_ ((TasklistApplet*) self);
}

static void
_tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                                          gpointer self)
{
	tasklist_applet_update_scroll_buttons_visibility ((TasklistApplet*) self);
}

static void
_tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                gpointer self)
{
	tasklist_applet_update_scroll_buttons_visibility ((TasklistApplet*) self);
}

static gboolean
__lambda17_ (TasklistApplet* self)
{
	gboolean result;
	tasklist_applet_update_scroll_buttons_visibility (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ ((TasklistApplet*) self);
	return result;
}

static void
_tasklist_applet___lambda16_ (TasklistApplet* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__tasklist_applet___lambda16__gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self)
{
	_tasklist_applet___lambda16_ ((TasklistApplet*) self);
}

static void
_tasklist_applet_on_app_opened_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                       XfwWindow* window,
                                                                       gpointer self)
{
	tasklist_applet_on_app_opened ((TasklistApplet*) self, window);
}

static void
_tasklist_applet_on_app_closed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                       XfwWindow* window,
                                                                       gpointer self)
{
	tasklist_applet_on_app_closed ((TasklistApplet*) self, window);
}

static void
_tasklist_applet_on_active_window_changed_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                          XfwWindow* window,
                                                                                          gpointer self)
{
	tasklist_applet_on_active_window_changed ((TasklistApplet*) self, window);
}

static GObject *
tasklist_applet_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasklistApplet * self;
	GtkStyleContext* _tmp0_;
	GtkBox* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* _tmp3_;
	GtkBox* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_;
	GtkButton* _tmp11_;
	GtkBox* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkBox* _tmp14_;
	GtkButton* _tmp15_;
	GtkBox* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkAdjustment* _tmp21_;
	GtkAdjustment* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkAdjustment* _tmp24_;
	GtkAdjustment* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkAdjustment* _tmp27_;
	GtkAdjustment* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	XfwScreen* _tmp30_;
	XfwScreen* _tmp31_;
	XfwScreen* _tmp32_;
	XfwScreen* _tmp33_;
	parent_class = G_OBJECT_CLASS (tasklist_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_APPLET, TasklistApplet);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "tasklist");
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	(self->priv->buttons == NULL) ? NULL : (self->priv->buttons = (_g_list_free__g_object_unref0_ (self->priv->buttons), NULL));
	self->priv->buttons = NULL;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp1_;
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (_tmp2_, GTK_SHADOW_NONE);
	g_object_set (_tmp2_, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (_tmp2_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_scrolled_window_set_propagate_natural_width (_tmp2_, TRUE);
	gtk_scrolled_window_set_propagate_natural_height (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp2_;
	_tmp3_ = self->priv->scrolled_window;
	_tmp4_ = self->priv->container;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->left_scroll_button);
	self->priv->left_scroll_button = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->right_scroll_button);
	self->priv->right_scroll_button = _tmp6_;
	_tmp7_ = self->priv->left_scroll_button;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) __tasklist_applet___lambda14__gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->right_scroll_button;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) __tasklist_applet___lambda15__gtk_button_clicked, self, 0);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->main_container);
	self->priv->main_container = _tmp9_;
	_tmp10_ = self->priv->main_container;
	_tmp11_ = self->priv->left_scroll_button;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->main_container;
	_tmp13_ = self->priv->scrolled_window;
	gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_tmp14_ = self->priv->main_container;
	_tmp15_ = self->priv->right_scroll_button;
	gtk_box_pack_end (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	_tmp16_ = self->priv->main_container;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->scrolled_window;
	_tmp18_ = gtk_scrolled_window_get_hadjustment (_tmp17_);
	_tmp19_ = _tmp18_;
	g_signal_connect_object (_tmp19_, "changed", (GCallback) _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_changed, self, 0);
	_tmp20_ = self->priv->scrolled_window;
	_tmp21_ = gtk_scrolled_window_get_hadjustment (_tmp20_);
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "value-changed", (GCallback) _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_value_changed, self, 0);
	_tmp23_ = self->priv->scrolled_window;
	_tmp24_ = gtk_scrolled_window_get_vadjustment (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_connect_object (_tmp25_, "changed", (GCallback) _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_changed, self, 0);
	_tmp26_ = self->priv->scrolled_window;
	_tmp27_ = gtk_scrolled_window_get_vadjustment (_tmp26_);
	_tmp28_ = _tmp27_;
	g_signal_connect_object (_tmp28_, "value-changed", (GCallback) _tasklist_applet_update_scroll_buttons_visibility_gtk_adjustment_value_changed, self, 0);
	_tmp29_ = self->priv->scrolled_window;
	g_signal_connect_object ((GtkWidget*) _tmp29_, "size-allocate", (GCallback) __tasklist_applet___lambda16__gtk_widget_size_allocate, self, 0);
	_tmp30_ = xfw_screen_get_default ();
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp30_;
	_tmp31_ = self->priv->screen;
	g_signal_connect_object (_tmp31_, "window-opened", (GCallback) _tasklist_applet_on_app_opened_libxfce4windowing_screen_window_opened, self, 0);
	_tmp32_ = self->priv->screen;
	g_signal_connect_object (_tmp32_, "window-closed", (GCallback) _tasklist_applet_on_app_closed_libxfce4windowing_screen_window_closed, self, 0);
	_tmp33_ = self->priv->screen;
	g_signal_connect_object (_tmp33_, "active-window-changed", (GCallback) _tasklist_applet_on_active_window_changed_libxfce4windowing_screen_active_window_changed, self, 0);
	tasklist_applet_setup_workspace_listener (self);
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
tasklist_applet_class_init (TasklistAppletClass * klass,
                            gpointer klass_data)
{
	tasklist_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasklistApplet_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) tasklist_applet_real_scroll_event;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) tasklist_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) tasklist_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) tasklist_applet_real_update_popovers;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) tasklist_applet_real_panel_position_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_tasklist_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasklist_applet_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasklist_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasklist_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_APPLET_UUID_PROPERTY, tasklist_applet_properties[TASKLIST_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tasklist_applet_instance_init (TasklistApplet * self,
                               gpointer klass)
{
	self->priv = tasklist_applet_get_instance_private (self);
	self->priv->popover_manager = NULL;
}

static void
tasklist_applet_finalize (GObject * obj)
{
	TasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_APPLET, TasklistApplet);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->main_container);
	_g_object_unref0 (self->priv->left_scroll_button);
	_g_object_unref0 (self->priv->right_scroll_button);
	(self->priv->buttons == NULL) ? NULL : (self->priv->buttons = (_g_list_free__g_object_unref0_ (self->priv->buttons), NULL));
	_g_object_unref0 (self->priv->screen);
	G_OBJECT_CLASS (tasklist_applet_parent_class)->finalize (obj);
}

GType
tasklist_applet_get_type (void)
{
	return tasklist_applet_type_id;
}

GType
tasklist_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistApplet), 0, (GInstanceInitFunc) tasklist_applet_instance_init, NULL };
	tasklist_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "TasklistApplet", &g_define_type_info, 0);
	TasklistApplet_private_offset = sizeof (TasklistAppletPrivate);
	return tasklist_applet_type_id;
}

static void
_vala_tasklist_applet_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	TasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_APPLET, TasklistApplet);
	switch (property_id) {
		case TASKLIST_APPLET_UUID_PROPERTY:
		g_value_set_string (value, tasklist_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasklist_applet_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	TasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_APPLET, TasklistApplet);
	switch (property_id) {
		case TASKLIST_APPLET_UUID_PROPERTY:
		tasklist_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	tasklist_plugin_register_type (module);
	tasklist_settings_register_type (module);
	tasklist_applet_register_type (module);
	tasklist_button_register_type (module);
	tasklist_button_popover_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_TASKLIST_PLUGIN);
	_g_object_unref0 (objmodule);
}

