/* ObexAgent.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ObexAgent.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BLUEZ_OBEX_ERROR (bluez_obex_error_get_type ())

#define BLUETOOTH_OBEX_TYPE_AGENT (bluetooth_obex_agent_get_type ())
#define BLUETOOTH_OBEX_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgent))
#define BLUETOOTH_OBEX_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgentClass))
#define BLUETOOTH_OBEX_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_AGENT))
#define BLUETOOTH_OBEX_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_OBEX_TYPE_AGENT))
#define BLUETOOTH_OBEX_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgentClass))

typedef struct _BluetoothObexAgent BluetoothObexAgent;
typedef struct _BluetoothObexAgentClass BluetoothObexAgentClass;
typedef struct _BluetoothObexAgentPrivate BluetoothObexAgentPrivate;
enum  {
	BLUETOOTH_OBEX_AGENT_0_PROPERTY,
	BLUETOOTH_OBEX_AGENT_NUM_PROPERTIES
};
static GParamSpec* bluetooth_obex_agent_properties[BLUETOOTH_OBEX_AGENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BLUETOOTH_OBEX_TYPE_SESSION (bluetooth_obex_session_get_type ())
#define BLUETOOTH_OBEX_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_SESSION, BluetoothObexSession))
#define BLUETOOTH_OBEX_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_SESSION))
#define BLUETOOTH_OBEX_SESSION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_SESSION, BluetoothObexSessionIface))

typedef struct _BluetoothObexSession BluetoothObexSession;
typedef struct _BluetoothObexSessionIface BluetoothObexSessionIface;

#define BLUETOOTH_OBEX_TYPE_SESSION_PROXY (bluetooth_obex_session_proxy_get_type ())
typedef struct _Block13Data Block13Data;

#define BLUETOOTH_OBEX_TYPE_TRANSFER (bluetooth_obex_transfer_get_type ())
#define BLUETOOTH_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransfer))
#define BLUETOOTH_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER))
#define BLUETOOTH_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransferIface))

typedef struct _BluetoothObexTransfer BluetoothObexTransfer;
typedef struct _BluetoothObexTransferIface BluetoothObexTransferIface;

#define BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY (bluetooth_obex_transfer_proxy_get_type ())
typedef struct _BluetoothObexAgentAuthorizePushData BluetoothObexAgentAuthorizePushData;
enum  {
	BLUETOOTH_OBEX_AGENT_RESPONSE_NOTIFY_SIGNAL,
	BLUETOOTH_OBEX_AGENT_RESPONSE_ACCEPTED_SIGNAL,
	BLUETOOTH_OBEX_AGENT_TRANSFER_VIEW_SIGNAL,
	BLUETOOTH_OBEX_AGENT_RESPONSE_CANCELED_SIGNAL,
	BLUETOOTH_OBEX_AGENT_NUM_SIGNALS
};
static guint bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_NUM_SIGNALS] = {0};
typedef struct _BluetoothObexAgentAuthorizePushReadyData BluetoothObexAgentAuthorizePushReadyData;

typedef enum  {
	BLUEZ_OBEX_ERROR_REJECTED,
	BLUEZ_OBEX_ERROR_CANCELED
} BluezObexError;
#define BLUEZ_OBEX_ERROR bluez_obex_error_quark ()

struct _BluetoothObexAgent {
	GObject parent_instance;
	BluetoothObexAgentPrivate * priv;
};

struct _BluetoothObexAgentClass {
	GObjectClass parent_class;
};

struct _BluetoothObexAgentPrivate {
	char* many_files;
};

struct _BluetoothObexSessionIface {
	GTypeInterface parent_iface;
	gchar* (*get_capabilities) (BluetoothObexSession* self, GError** error);
	gchar* (*get_source) (BluetoothObexSession* self);
	gchar* (*get_destination) (BluetoothObexSession* self);
	guchar (*get_channel) (BluetoothObexSession* self);
	gchar* (*get_target) (BluetoothObexSession* self);
	gchar* (*get_root) (BluetoothObexSession* self);
};

struct _Block13Data {
	int _ref_count_;
	BluetoothObexAgent* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GError* obex_error;
	BluetoothObexSession* session;
	char* object_path;
	gpointer _async_data_;
};

struct _BluetoothObexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (BluetoothObexTransfer* self, GError** error);
	void (*resume) (BluetoothObexTransfer* self, GError** error);
	void (*suspend) (BluetoothObexTransfer* self, GError** error);
	gchar* (*get_status) (BluetoothObexTransfer* self);
	char* (*get_session) (BluetoothObexTransfer* self);
	gchar* (*get_name) (BluetoothObexTransfer* self);
	gchar* (*get_Type) (BluetoothObexTransfer* self);
	guint64 (*get_time) (BluetoothObexTransfer* self);
	guint64 (*get_size) (BluetoothObexTransfer* self);
	guint64 (*get_transferred) (BluetoothObexTransfer* self);
	gchar* (*get_filename) (BluetoothObexTransfer* self);
};

struct _BluetoothObexAgentAuthorizePushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothObexAgent* self;
	char* object_path;
	gchar* result;
	Block13Data* _data13_;
	BluetoothObexTransfer* transfer;
	BluetoothObexTransfer* _tmp0_;
	BluetoothObexTransfer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	GError* _tmp6_;
	BluetoothObexTransfer* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	BluetoothObexSession* _tmp11_;
	BluetoothObexSession* _tmp12_;
	GSimpleAction* accept_action;
	const GVariantType* _tmp13_;
	GSimpleAction* _tmp14_;
	GApplication* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* cancel_action;
	const GVariantType* _tmp18_;
	GSimpleAction* _tmp19_;
	GApplication* _tmp20_;
	GSimpleAction* _tmp21_;
	GSimpleAction* _tmp22_;
	const char* _tmp23_;
	BluetoothObexSession* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	char* _tmp31_;
	BluetoothObexTransfer* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _inner_error0_;
};

struct _BluetoothObexAgentAuthorizePushReadyData {
	GDBusMethodInvocation* _invocation_;
	char* object_path;
};

static gint BluetoothObexAgent_private_offset;
static gpointer bluetooth_obex_agent_parent_class = NULL;

VALA_EXTERN GQuark bluez_obex_error_quark (void);
VALA_EXTERN GType bluez_obex_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bluetooth_obex_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexAgent, g_object_unref)
VALA_EXTERN guint bluetooth_obex_agent_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN BluetoothObexAgent* bluetooth_obex_agent_new (void);
VALA_EXTERN BluetoothObexAgent* bluetooth_obex_agent_construct (GType object_type);
static void bluetooth_obex_agent_on_name_get (BluetoothObexAgent* self,
                                       GDBusConnection* conn);
static void _bluetooth_obex_agent_on_name_get_gbus_acquired_callback (GDBusConnection* connection,
                                                               const gchar* name,
                                                               gpointer self);
VALA_EXTERN void bluetooth_obex_agent_transfer_active (BluetoothObexAgent* self,
                                           const gchar* session_path,
                                           GError** error);
VALA_EXTERN void bluetooth_obex_agent_release (BluetoothObexAgent* self,
                                   GError** error);
static void bluetooth_obex_agent_authorize_push_data_free (gpointer _data);
VALA_EXTERN void bluetooth_obex_agent_authorize_push (BluetoothObexAgent* self,
                                          const char* object_path,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN gchar* bluetooth_obex_agent_authorize_push_finish (BluetoothObexAgent* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gboolean bluetooth_obex_agent_authorize_push_co (BluetoothObexAgentAuthorizePushData* _data_);
VALA_EXTERN GType bluetooth_obex_session_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_session_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType bluetooth_obex_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexSession, g_object_unref)
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean _bluetooth_obex_agent_authorize_push_co_gsource_func (gpointer self);
VALA_EXTERN GType bluetooth_obex_transfer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_transfer_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexTransfer, g_object_unref)
VALA_EXTERN gchar* bluetooth_obex_transfer_get_name (BluetoothObexTransfer* self);
VALA_EXTERN char* bluetooth_obex_transfer_get_session (BluetoothObexTransfer* self);
static void __lambda13_ (Block13Data* _data13_,
                  GVariant* parameter);
VALA_EXTERN gchar* bluetooth_obex_session_get_destination (BluetoothObexSession* self);
static void ___lambda13__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda14_ (Block13Data* _data13_,
                  GVariant* parameter);
static void ___lambda14__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static gboolean ___lambda15_ (Block13Data* _data13_);
static gboolean ____lambda15__gsource_func (gpointer self);
VALA_EXTERN void bluetooth_obex_agent_cancel (BluetoothObexAgent* self,
                                  GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void bluetooth_obex_agent_finalize (GObject * obj);
static GType bluetooth_obex_agent_get_type_once (void);
static void _dbus_bluetooth_obex_agent_transfer_active (BluetoothObexAgent* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_obex_agent_release (BluetoothObexAgent* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_obex_agent_authorize_push (BluetoothObexAgent* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_obex_agent_authorize_push_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_);
static void _dbus_bluetooth_obex_agent_cancel (BluetoothObexAgent* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void bluetooth_obex_agent_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* bluetooth_obex_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean bluetooth_obex_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_bluetooth_obex_agent_response_notify (GObject* _sender,
                                                 const gchar* address,
                                                 const char* object_path,
                                                 gpointer* _data);
static void _dbus_bluetooth_obex_agent_response_accepted (GObject* _sender,
                                                   const gchar* address,
                                                   const char* object_path,
                                                   gpointer* _data);
static void _dbus_bluetooth_obex_agent_transfer_view (GObject* _sender,
                                               const gchar* session_path,
                                               gpointer* _data);
static void _dbus_bluetooth_obex_agent_response_canceled (GObject* _sender,
                                                   const char* object_path,
                                                   gpointer* _data);
static void _bluetooth_obex_agent_unregister_object (gpointer user_data);

static const GDBusErrorEntry bluez_obex_error_entries[] = {{BLUEZ_OBEX_ERROR_REJECTED, "org.bluez.obex.Error.Rejected"}, {BLUEZ_OBEX_ERROR_CANCELED, "org.bluez.obex.Error.Canceled"}};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_transfer_active_session_path = {-1, "session_path", "s", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_transfer_active_in[] = {&_bluetooth_obex_agent_dbus_arg_info_transfer_active_session_path, NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_transfer_active_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_obex_agent_dbus_method_info_transfer_active = {-1, "TransferActive", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_transfer_active_in), (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_transfer_active_out), NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_release_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_release_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_obex_agent_dbus_method_info_release = {-1, "Release", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_release_in), (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_release_out), NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_authorize_push_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_authorize_push_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_authorize_push_in[] = {&_bluetooth_obex_agent_dbus_arg_info_authorize_push_object_path, NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_authorize_push_out[] = {&_bluetooth_obex_agent_dbus_arg_info_authorize_push_result, NULL};
static const GDBusMethodInfo _bluetooth_obex_agent_dbus_method_info_authorize_push = {-1, "AuthorizePush", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_authorize_push_in), (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_authorize_push_out), NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_obex_agent_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_cancel_out), NULL};
static const GDBusMethodInfo * const _bluetooth_obex_agent_dbus_method_info[] = {&_bluetooth_obex_agent_dbus_method_info_transfer_active, &_bluetooth_obex_agent_dbus_method_info_release, &_bluetooth_obex_agent_dbus_method_info_authorize_push, &_bluetooth_obex_agent_dbus_method_info_cancel, NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_response_notify_address = {-1, "address", "s", NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_response_notify_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_response_notify[] = {&_bluetooth_obex_agent_dbus_arg_info_response_notify_address, &_bluetooth_obex_agent_dbus_arg_info_response_notify_object_path, NULL};
static const GDBusSignalInfo _bluetooth_obex_agent_dbus_signal_info_response_notify = {-1, "ResponseNotify", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_response_notify), NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_response_accepted_address = {-1, "address", "s", NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_response_accepted_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_response_accepted[] = {&_bluetooth_obex_agent_dbus_arg_info_response_accepted_address, &_bluetooth_obex_agent_dbus_arg_info_response_accepted_object_path, NULL};
static const GDBusSignalInfo _bluetooth_obex_agent_dbus_signal_info_response_accepted = {-1, "ResponseAccepted", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_response_accepted), NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_transfer_view_session_path = {-1, "session_path", "s", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_transfer_view[] = {&_bluetooth_obex_agent_dbus_arg_info_transfer_view_session_path, NULL};
static const GDBusSignalInfo _bluetooth_obex_agent_dbus_signal_info_transfer_view = {-1, "TransferView", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_transfer_view), NULL};
static const GDBusArgInfo _bluetooth_obex_agent_dbus_arg_info_response_canceled_object_path = {-1, "object_path", "o", NULL};
static const GDBusArgInfo * const _bluetooth_obex_agent_dbus_arg_info_response_canceled[] = {&_bluetooth_obex_agent_dbus_arg_info_response_canceled_object_path, NULL};
static const GDBusSignalInfo _bluetooth_obex_agent_dbus_signal_info_response_canceled = {-1, "ResponseCanceled", (GDBusArgInfo **) (&_bluetooth_obex_agent_dbus_arg_info_response_canceled), NULL};
static const GDBusSignalInfo * const _bluetooth_obex_agent_dbus_signal_info[] = {&_bluetooth_obex_agent_dbus_signal_info_response_notify, &_bluetooth_obex_agent_dbus_signal_info_response_accepted, &_bluetooth_obex_agent_dbus_signal_info_transfer_view, &_bluetooth_obex_agent_dbus_signal_info_response_canceled, NULL};
static const GDBusPropertyInfo * const _bluetooth_obex_agent_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _bluetooth_obex_agent_dbus_interface_info = {-1, "org.bluez.obex.Agent1", (GDBusMethodInfo **) (&_bluetooth_obex_agent_dbus_method_info), (GDBusSignalInfo **) (&_bluetooth_obex_agent_dbus_signal_info), (GDBusPropertyInfo **) (&_bluetooth_obex_agent_dbus_property_info), NULL};
static const GDBusInterfaceVTable _bluetooth_obex_agent_dbus_interface_vtable = {bluetooth_obex_agent_dbus_interface_method_call, bluetooth_obex_agent_dbus_interface_get_property, bluetooth_obex_agent_dbus_interface_set_property};

GQuark
bluez_obex_error_quark (void)
{
	static volatile gsize bluez_obex_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("bluez-obex-error-quark", &bluez_obex_error_quark_volatile, bluez_obex_error_entries, G_N_ELEMENTS (bluez_obex_error_entries));
	return (GQuark) bluez_obex_error_quark_volatile;
}

static inline gpointer
bluetooth_obex_agent_get_instance_private (BluetoothObexAgent* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothObexAgent_private_offset);
}

static void
_bluetooth_obex_agent_on_name_get_gbus_acquired_callback (GDBusConnection* connection,
                                                          const gchar* name,
                                                          gpointer self)
{
	bluetooth_obex_agent_on_name_get ((BluetoothObexAgent*) self, connection);
}

BluetoothObexAgent*
bluetooth_obex_agent_construct (GType object_type)
{
	BluetoothObexAgent * self = NULL;
	self = (BluetoothObexAgent*) g_object_new (object_type, NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.bluez.obex.Agent1", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_bluetooth_obex_agent_on_name_get_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _bluetooth_obex_agent_on_name_get_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

BluetoothObexAgent*
bluetooth_obex_agent_new (void)
{
	return bluetooth_obex_agent_construct (BLUETOOTH_OBEX_TYPE_AGENT);
}

static void
bluetooth_obex_agent_on_name_get (BluetoothObexAgent* self,
                                  GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		bluetooth_obex_agent_register_object (self, conn, "/org/bluez/obex/budgie", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp0_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e->message;
		g_error ("ObexAgent.vala:41: Error registering DBus name: %s", _tmp0_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
bluetooth_obex_agent_transfer_active (BluetoothObexAgent* self,
                                      const gchar* session_path,
                                      GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (session_path != NULL);
	g_signal_emit (self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_TRANSFER_VIEW_SIGNAL], 0, session_path);
}

/**
 * release:
 *
 * This method gets called when the service daemon
 * unregisters the agent. An agent can use it to do
 * cleanup tasks. There is no need to unregister the
 * agent, because when this method gets called it has
 * already been unregistered.
 */
void
bluetooth_obex_agent_release (BluetoothObexAgent* self,
                              GError** error)
{
	g_return_if_fail (self != NULL);
}

static void
bluetooth_obex_agent_authorize_push_data_free (gpointer _data)
{
	BluetoothObexAgentAuthorizePushData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothObexAgentAuthorizePushData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bluetooth_obex_agent_authorize_push (BluetoothObexAgent* self,
                                     const char* object_path,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BluetoothObexAgentAuthorizePushData* _data_;
	BluetoothObexAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_data_ = g_slice_new0 (BluetoothObexAgentAuthorizePushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_obex_agent_authorize_push_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (object_path);
	_g_free0 (_data_->object_path);
	_data_->object_path = _tmp1_;
	bluetooth_obex_agent_authorize_push_co (_data_);
}

gchar*
bluetooth_obex_agent_authorize_push_finish (BluetoothObexAgent* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	gchar* result;
	BluetoothObexAgentAuthorizePushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
 * authorize_push:
 * @object_path: The path to a Bluez #Transfer object.
 *
 * This method gets called when the service daemon
 * needs to accept/reject a Bluetooth object push request.
 *
 * Returns: The full path (including the filename) or the
 * folder name suffixed with '/' where the object shall
 * be stored. The transfer object will contain a Filename
 * property that contains the default location and name
 * that can be returned.
 */
static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		BluetoothObexAgent* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->session);
		_g_error_free0 (_data13_->obex_error);
		(_data13_->callback_target_destroy_notify == NULL) ? NULL : (_data13_->callback_target_destroy_notify (_data13_->callback_target), NULL);
		_data13_->callback = NULL;
		_data13_->callback_target = NULL;
		_data13_->callback_target_destroy_notify = NULL;
		_g_free0 (_data13_->object_path);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
_bluetooth_obex_agent_authorize_push_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bluetooth_obex_agent_authorize_push_co (self);
	return result;
}

static void
__lambda13_ (Block13Data* _data13_,
             GVariant* parameter)
{
	BluetoothObexAgent* self;
	BluetoothObexSession* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSourceFunc _tmp4_;
	gpointer _tmp4__target;
	self = _data13_->self;
	_tmp0_ = _data13_->session;
	_tmp1_ = bluetooth_obex_session_get_destination (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_signal_emit (self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_ACCEPTED_SIGNAL], 0, _tmp3_, _data13_->object_path);
	_g_free0 (_tmp3_);
	_tmp4_ = _data13_->callback;
	_tmp4__target = _data13_->callback_target;
	if (_tmp4_ != NULL) {
		GSourceFunc _tmp5_;
		gpointer _tmp5__target;
		GDestroyNotify _tmp5__target_destroy_notify;
		_tmp5_ = _data13_->callback;
		_tmp5__target = _data13_->callback_target;
		_tmp5__target_destroy_notify = _data13_->callback_target_destroy_notify;
		_data13_->callback = NULL;
		_data13_->callback_target = NULL;
		_data13_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify);
	}
}

static void
___lambda13__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda13_ (self, parameter);
}

static void
__lambda14_ (Block13Data* _data13_,
             GVariant* parameter)
{
	BluetoothObexAgent* self;
	GError* _tmp0_;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	self = _data13_->self;
	_tmp0_ = g_error_new_literal (BLUEZ_OBEX_ERROR, BLUEZ_OBEX_ERROR_CANCELED, "File transfer cancelled");
	_g_error_free0 (_data13_->obex_error);
	_data13_->obex_error = _tmp0_;
	g_signal_emit (self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_CANCELED_SIGNAL], 0, _data13_->object_path);
	_tmp1_ = _data13_->callback;
	_tmp1__target = _data13_->callback_target;
	if (_tmp1_ != NULL) {
		GSourceFunc _tmp2_;
		gpointer _tmp2__target;
		GDestroyNotify _tmp2__target_destroy_notify;
		_tmp2_ = _data13_->callback;
		_tmp2__target = _data13_->callback_target;
		_tmp2__target_destroy_notify = _data13_->callback_target_destroy_notify;
		_data13_->callback = NULL;
		_data13_->callback_target = NULL;
		_data13_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
	}
}

static void
___lambda14__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda14_ (self, parameter);
}

static gboolean
___lambda15_ (Block13Data* _data13_)
{
	BluetoothObexAgent* self;
	BluetoothObexSession* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSourceFunc _tmp4_;
	gpointer _tmp4__target;
	gboolean result;
	self = _data13_->self;
	_tmp0_ = _data13_->session;
	_tmp1_ = bluetooth_obex_session_get_destination (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_signal_emit (self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_ACCEPTED_SIGNAL], 0, _tmp3_, _data13_->object_path);
	_g_free0 (_tmp3_);
	_tmp4_ = _data13_->callback;
	_tmp4__target = _data13_->callback_target;
	if (_tmp4_ != NULL) {
		GSourceFunc _tmp5_;
		gpointer _tmp5__target;
		GDestroyNotify _tmp5__target_destroy_notify;
		_tmp5_ = _data13_->callback;
		_tmp5__target = _data13_->callback_target;
		_tmp5__target_destroy_notify = _data13_->callback_target_destroy_notify;
		_data13_->callback = NULL;
		_data13_->callback_target = NULL;
		_data13_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda15_ (self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
bluetooth_obex_agent_authorize_push_co (BluetoothObexAgentAuthorizePushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data13_ = g_slice_new0 (Block13Data);
	_data_->_data13_->_ref_count_ = 1;
	_data_->_data13_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data13_->object_path);
	_data_->_data13_->object_path = _data_->object_path;
	_data_->_data13_->_async_data_ = _data_;
	_data_->_data13_->callback = _bluetooth_obex_agent_authorize_push_co_gsource_func;
	_data_->_data13_->callback_target = _data_;
	_data_->_data13_->callback_target_destroy_notify = NULL;
	_data_->_data13_->obex_error = NULL;
	_data_->_tmp0_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_data_->_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_data13_->object_path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
	_data_->transfer = (BluetoothObexTransfer*) _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block13_data_unref (_data_->_data13_);
		_data_->_data13_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->transfer;
	_data_->_tmp2_ = bluetooth_obex_transfer_get_name (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_ == NULL;
	_g_free0 (_data_->_tmp4_);
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = g_error_new_literal (BLUEZ_OBEX_ERROR, BLUEZ_OBEX_ERROR_REJECTED, "File transfer rejected");
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transfer);
		block13_data_unref (_data_->_data13_);
		_data_->_data13_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->transfer;
	_data_->_tmp8_ = bluetooth_obex_transfer_get_session (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = (BluetoothObexSession*) g_initable_new (BLUETOOTH_OBEX_TYPE_SESSION_PROXY, NULL, &_data_->_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp10_, "g-interface-name", "org.bluez.obex.Session1", NULL);
	_data_->_tmp12_ = (BluetoothObexSession*) _data_->_tmp11_;
	_g_free0 (_data_->_tmp10_);
	_data_->_data13_->session = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transfer);
		block13_data_unref (_data_->_data13_);
		_data_->_data13_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp14_ = g_simple_action_new ("btaccept", _data_->_tmp13_);
	_data_->accept_action = _data_->_tmp14_;
	_data_->_tmp15_ = g_application_get_default ();
	_data_->_tmp16_ = _data_->accept_action;
	g_action_map_add_action ((GActionMap*) _data_->_tmp15_, (GAction*) _data_->_tmp16_);
	_data_->_tmp17_ = _data_->accept_action;
	g_signal_connect_data (_data_->_tmp17_, "activate", (GCallback) ___lambda13__g_simple_action_activate, block13_data_ref (_data_->_data13_), (GClosureNotify) block13_data_unref, 0);
	_data_->_tmp18_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp19_ = g_simple_action_new ("btcancel", _data_->_tmp18_);
	_data_->cancel_action = _data_->_tmp19_;
	_data_->_tmp20_ = g_application_get_default ();
	_data_->_tmp21_ = _data_->cancel_action;
	g_action_map_add_action ((GActionMap*) _data_->_tmp20_, (GAction*) _data_->_tmp21_);
	_data_->_tmp22_ = _data_->cancel_action;
	g_signal_connect_data (_data_->_tmp22_, "activate", (GCallback) ___lambda14__g_simple_action_activate, block13_data_ref (_data_->_data13_), (GClosureNotify) block13_data_unref, 0);
	_data_->_tmp23_ = _data_->self->priv->many_files;
	if (g_strcmp0 (_data_->_tmp23_, _data_->_data13_->object_path) == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda15__gsource_func, block13_data_ref (_data_->_data13_), block13_data_unref);
	} else {
		_data_->_tmp24_ = _data_->_data13_->session;
		_data_->_tmp25_ = bluetooth_obex_session_get_destination (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->_tmp26_;
		g_signal_emit (_data_->self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_NOTIFY_SIGNAL], 0, _data_->_tmp27_, _data_->_data13_->object_path);
		_g_free0 (_data_->_tmp27_);
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp28_ = _data_->_data13_->obex_error;
	if (_data_->_tmp28_ != NULL) {
		_data_->_tmp29_ = _data_->_data13_->obex_error;
		_data_->_tmp30_ = _g_error_copy0 (_data_->_tmp29_);
		_data_->_inner_error0_ = _data_->_tmp30_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cancel_action);
		_g_object_unref0 (_data_->accept_action);
		_g_object_unref0 (_data_->transfer);
		block13_data_unref (_data_->_data13_);
		_data_->_data13_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = g_strdup (_data_->_data13_->object_path);
	_g_free0 (_data_->self->priv->many_files);
	_data_->self->priv->many_files = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->transfer;
	_data_->_tmp33_ = bluetooth_obex_transfer_get_name (_data_->_tmp32_);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->result = _data_->_tmp34_;
	_g_object_unref0 (_data_->cancel_action);
	_g_object_unref0 (_data_->accept_action);
	_g_object_unref0 (_data_->transfer);
	block13_data_unref (_data_->_data13_);
	_data_->_data13_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
 * cancel:
 *
 * This method gets called to indicate that the agent
 * request failed before a reply was returned. It cancels
 * the previous request.
 */
void
bluetooth_obex_agent_cancel (BluetoothObexAgent* self,
                             GError** error)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_CANCELED_SIGNAL], 0, NULL);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
bluetooth_obex_agent_class_init (BluetoothObexAgentClass * klass,
                                 gpointer klass_data)
{
	bluetooth_obex_agent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothObexAgent_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bluetooth_obex_agent_finalize;
	bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_NOTIFY_SIGNAL] = g_signal_new ("response-notify", BLUETOOTH_OBEX_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_ACCEPTED_SIGNAL] = g_signal_new ("response-accepted", BLUETOOTH_OBEX_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_TRANSFER_VIEW_SIGNAL] = g_signal_new ("transfer-view", BLUETOOTH_OBEX_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	bluetooth_obex_agent_signals[BLUETOOTH_OBEX_AGENT_RESPONSE_CANCELED_SIGNAL] = g_signal_new ("response-canceled", BLUETOOTH_OBEX_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
bluetooth_obex_agent_instance_init (BluetoothObexAgent * self,
                                    gpointer klass)
{
	self->priv = bluetooth_obex_agent_get_instance_private (self);
}

static void
bluetooth_obex_agent_finalize (GObject * obj)
{
	BluetoothObexAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgent);
	_g_free0 (self->priv->many_files);
	G_OBJECT_CLASS (bluetooth_obex_agent_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
bluetooth_obex_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothObexAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_obex_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothObexAgent), 0, (GInstanceInitFunc) bluetooth_obex_agent_instance_init, NULL };
	GType bluetooth_obex_agent_type_id;
	bluetooth_obex_agent_type_id = g_type_register_static (G_TYPE_OBJECT, "BluetoothObexAgent", &g_define_type_info, 0);
	g_type_set_qdata (bluetooth_obex_agent_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) bluetooth_obex_agent_register_object);
	BluetoothObexAgent_private_offset = g_type_add_instance_private (bluetooth_obex_agent_type_id, sizeof (BluetoothObexAgentPrivate));
	return bluetooth_obex_agent_type_id;
}

GType
bluetooth_obex_agent_get_type (void)
{
	static volatile gsize bluetooth_obex_agent_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_obex_agent_type_id__once)) {
		GType bluetooth_obex_agent_type_id;
		bluetooth_obex_agent_type_id = bluetooth_obex_agent_get_type_once ();
		g_once_init_leave (&bluetooth_obex_agent_type_id__once, bluetooth_obex_agent_type_id);
	}
	return bluetooth_obex_agent_type_id__once;
}

static void
_dbus_bluetooth_obex_agent_transfer_active (BluetoothObexAgent* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* session_path = NULL;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	session_path = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	bluetooth_obex_agent_transfer_active (self, session_path, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (session_path);
	;
}

static void
_dbus_bluetooth_obex_agent_release (BluetoothObexAgent* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_obex_agent_release (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_bluetooth_obex_agent_authorize_push (BluetoothObexAgent* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothObexAgentAuthorizePushReadyData* _ready_data;
	GVariant* _tmp40_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothObexAgentAuthorizePushReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->object_path = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	bluetooth_obex_agent_authorize_push (self, _ready_data->object_path, (GAsyncReadyCallback) _dbus_bluetooth_obex_agent_authorize_push_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_obex_agent_authorize_push_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_)
{
	BluetoothObexAgentAuthorizePushReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = bluetooth_obex_agent_authorize_push_finish ((BluetoothObexAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->object_path);
	g_slice_free (BluetoothObexAgentAuthorizePushReadyData, _ready_data);
}

static void
_dbus_bluetooth_obex_agent_cancel (BluetoothObexAgent* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_obex_agent_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
bluetooth_obex_agent_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "TransferActive") == 0) {
		_dbus_bluetooth_obex_agent_transfer_active (object, parameters, invocation);
	} else if (strcmp (method_name, "Release") == 0) {
		_dbus_bluetooth_obex_agent_release (object, parameters, invocation);
	} else if (strcmp (method_name, "AuthorizePush") == 0) {
		_dbus_bluetooth_obex_agent_authorize_push (object, parameters, invocation);
	} else if (strcmp (method_name, "Cancel") == 0) {
		_dbus_bluetooth_obex_agent_cancel (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
bluetooth_obex_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
bluetooth_obex_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_bluetooth_obex_agent_response_notify (GObject* _sender,
                                            const gchar* address,
                                            const char* object_path,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (address));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.bluez.obex.Agent1", "ResponseNotify", _arguments, NULL);
}

static void
_dbus_bluetooth_obex_agent_response_accepted (GObject* _sender,
                                              const gchar* address,
                                              const char* object_path,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (address));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.bluez.obex.Agent1", "ResponseAccepted", _arguments, NULL);
}

static void
_dbus_bluetooth_obex_agent_transfer_view (GObject* _sender,
                                          const gchar* session_path,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.bluez.obex.Agent1", "TransferView", _arguments, NULL);
}

static void
_dbus_bluetooth_obex_agent_response_canceled (GObject* _sender,
                                              const char* object_path,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.bluez.obex.Agent1", "ResponseCanceled", _arguments, NULL);
}

guint
bluetooth_obex_agent_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_bluetooth_obex_agent_dbus_interface_info), &_bluetooth_obex_agent_dbus_interface_vtable, data, _bluetooth_obex_agent_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "response-notify", (GCallback) _dbus_bluetooth_obex_agent_response_notify, data);
	g_signal_connect (object, "response-accepted", (GCallback) _dbus_bluetooth_obex_agent_response_accepted, data);
	g_signal_connect (object, "transfer-view", (GCallback) _dbus_bluetooth_obex_agent_transfer_view, data);
	g_signal_connect (object, "response-canceled", (GCallback) _dbus_bluetooth_obex_agent_response_canceled, data);
	return result;
}

static void
_bluetooth_obex_agent_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_bluetooth_obex_agent_response_notify, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_bluetooth_obex_agent_response_accepted, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_bluetooth_obex_agent_transfer_view, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_bluetooth_obex_agent_response_canceled, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

