#ifndef WRITEODFPRESENTATION_H
#define WRITEODFPRESENTATION_H
#include "writeodf.h"
namespace writeodf {
class presentation_animation_group : public OdfWriter, public group_presentation_animation_elements {
public:
    presentation_animation_group(OdfWriter* x) :OdfWriter(x, "presentation:animation-group", true), group_presentation_animation_elements(*static_cast<OdfWriter*>(this)) {
    }
    presentation_animation_group(KoXmlWriter* x) :OdfWriter(x, "presentation:animation-group", true), group_presentation_animation_elements(*static_cast<OdfWriter*>(this)) {
    }
};
class presentation_date_time : public OdfWriter {
public:
    presentation_date_time(OdfWriter* x) :OdfWriter(x, "presentation:date-time", false) {
    }
    presentation_date_time(KoXmlWriter* x) :OdfWriter(x, "presentation:date-time", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_dim : public OdfWriter, public group_presentation_sound {
public:
    presentation_dim(OdfWriter* x, const QString& draw_color, const QString& draw_shape_id) :OdfWriter(x, "presentation:dim", true), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:color", draw_color);
        addAttribute("draw:shape-id", draw_shape_id);
    }
    presentation_dim(KoXmlWriter* x, const QString& draw_color, const QString& draw_shape_id) :OdfWriter(x, "presentation:dim", true), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:color", draw_color);
        addAttribute("draw:shape-id", draw_shape_id);
    }
};
class presentation_footer : public OdfWriter {
public:
    presentation_footer(OdfWriter* x) :OdfWriter(x, "presentation:footer", false) {
    }
    presentation_footer(KoXmlWriter* x) :OdfWriter(x, "presentation:footer", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_header : public OdfWriter {
public:
    presentation_header(OdfWriter* x) :OdfWriter(x, "presentation:header", false) {
    }
    presentation_header(KoXmlWriter* x) :OdfWriter(x, "presentation:header", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_hide_shape : public OdfWriter, public group_common_presentation_effect_attlist, public group_presentation_sound {
public:
    presentation_hide_shape(OdfWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:hide-shape", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
    presentation_hide_shape(KoXmlWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:hide-shape", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
};
class presentation_play : public OdfWriter {
public:
    presentation_play(OdfWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:play", false) {
        addAttribute("draw:shape-id", draw_shape_id);
    }
    presentation_play(KoXmlWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:play", false) {
        addAttribute("draw:shape-id", draw_shape_id);
    }
    template<class T>
    void set_presentation_speed(const T& value) {
        addAttribute("presentation:speed", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_show : public OdfWriter {
public:
    presentation_show(OdfWriter* x, const QString& presentation_name, const QString& presentation_pages) :OdfWriter(x, "presentation:show", false) {
        addAttribute("presentation:name", presentation_name);
        addAttribute("presentation:pages", presentation_pages);
    }
    presentation_show(KoXmlWriter* x, const QString& presentation_name, const QString& presentation_pages) :OdfWriter(x, "presentation:show", false) {
        addAttribute("presentation:name", presentation_name);
        addAttribute("presentation:pages", presentation_pages);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_show_text : public OdfWriter, public group_common_presentation_effect_attlist, public group_presentation_sound {
public:
    presentation_show_text(OdfWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:show-text", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
    presentation_show_text(KoXmlWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:show-text", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
};
class presentation_date_time_decl : public OdfWriter {
public:
    presentation_date_time_decl(OdfWriter* x, const QString& presentation_name, const QString& presentation_source) :OdfWriter(x, "presentation:date-time-decl", false) {
        addAttribute("presentation:name", presentation_name);
        addAttribute("presentation:source", presentation_source);
    }
    presentation_date_time_decl(KoXmlWriter* x, const QString& presentation_name, const QString& presentation_source) :OdfWriter(x, "presentation:date-time-decl", false) {
        addAttribute("presentation:name", presentation_name);
        addAttribute("presentation:source", presentation_source);
    }
    void set_style_data_style_name(const QString& value) {
        addAttribute("style:data-style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_footer_decl : public OdfWriter {
public:
    presentation_footer_decl(OdfWriter* x, const QString& presentation_name) :OdfWriter(x, "presentation:footer-decl", false) {
        addAttribute("presentation:name", presentation_name);
    }
    presentation_footer_decl(KoXmlWriter* x, const QString& presentation_name) :OdfWriter(x, "presentation:footer-decl", false) {
        addAttribute("presentation:name", presentation_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_hide_text : public OdfWriter, public group_common_presentation_effect_attlist, public group_presentation_sound {
public:
    presentation_hide_text(OdfWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:hide-text", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
    presentation_hide_text(KoXmlWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:hide-text", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
};
class presentation_placeholder : public OdfWriter {
public:
    presentation_placeholder(OdfWriter* x, const QString& presentation_object, const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "presentation:placeholder", false) {
        addAttribute("presentation:object", presentation_object);
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    presentation_placeholder(KoXmlWriter* x, const QString& presentation_object, const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "presentation:placeholder", false) {
        addAttribute("presentation:object", presentation_object);
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_show_shape : public OdfWriter, public group_common_presentation_effect_attlist, public group_presentation_sound {
public:
    presentation_show_shape(OdfWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:show-shape", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
    presentation_show_shape(KoXmlWriter* x, const QString& draw_shape_id) :OdfWriter(x, "presentation:show-shape", true), group_common_presentation_effect_attlist(*static_cast<OdfWriter*>(this), draw_shape_id), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
    }
};
class presentation_event_listener : public OdfWriter, public group_presentation_sound {
public:
    presentation_event_listener(OdfWriter* x, const QString& presentation_action, const QString& script_event_name) :OdfWriter(x, "presentation:event-listener", true), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
        addAttribute("presentation:action", presentation_action);
        addAttribute("script:event-name", script_event_name);
    }
    presentation_event_listener(KoXmlWriter* x, const QString& presentation_action, const QString& script_event_name) :OdfWriter(x, "presentation:event-listener", true), group_presentation_sound(*static_cast<OdfWriter*>(this)) {
        addAttribute("presentation:action", presentation_action);
        addAttribute("script:event-name", script_event_name);
    }
    template<class T>
    void set_presentation_direction(const T& value) {
        addAttribute("presentation:direction", value);
    }
    template<class T>
    void set_presentation_effect(const T& value) {
        addAttribute("presentation:effect", value);
    }
    template<class T>
    void set_presentation_speed(const T& value) {
        addAttribute("presentation:speed", value);
    }
    void set_presentation_start_scale(const QString& value) {
        addAttribute("presentation:start-scale", value);
    }
    void set_presentation_verb(quint64 value) {
        addAttribute("presentation:verb", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    void set_xlink_href(const QUrl& value) {
        addAttribute("xlink:href", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    template<class T>
    void set_xlink_type(const T& value) {
        addAttribute("xlink:type", value);
    }
};
class presentation_sound : public OdfWriter, public group_xml_id {
public:
    presentation_sound(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "presentation:sound", false), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    presentation_sound(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "presentation:sound", false), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    template<class T>
    void set_presentation_play_full(const T& value) {
        addAttribute("presentation:play-full", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_header_decl : public OdfWriter {
public:
    presentation_header_decl(OdfWriter* x, const QString& presentation_name) :OdfWriter(x, "presentation:header-decl", false) {
        addAttribute("presentation:name", presentation_name);
    }
    presentation_header_decl(KoXmlWriter* x, const QString& presentation_name) :OdfWriter(x, "presentation:header-decl", false) {
        addAttribute("presentation:name", presentation_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class presentation_settings : public OdfWriter {
public:
    presentation_settings(OdfWriter* x) :OdfWriter(x, "presentation:settings", true) {
    }
    presentation_settings(KoXmlWriter* x) :OdfWriter(x, "presentation:settings", true) {
    }
    presentation_show add_presentation_show(const QString& presentation_name, const QString& presentation_pages);
    template<class T>
    void set_presentation_animations(const T& value) {
        addAttribute("presentation:animations", value);
    }
    template<class T>
    void set_presentation_endless(const T& value) {
        addAttribute("presentation:endless", value);
    }
    template<class T>
    void set_presentation_force_manual(const T& value) {
        addAttribute("presentation:force-manual", value);
    }
    template<class T>
    void set_presentation_full_screen(const T& value) {
        addAttribute("presentation:full-screen", value);
    }
    template<class T>
    void set_presentation_mouse_as_pen(const T& value) {
        addAttribute("presentation:mouse-as-pen", value);
    }
    template<class T>
    void set_presentation_mouse_visible(const T& value) {
        addAttribute("presentation:mouse-visible", value);
    }
    void set_presentation_pause(Duration value) {
        addAttribute("presentation:pause", value);
    }
    void set_presentation_show(const QString& value) {
        addAttribute("presentation:show", value);
    }
    template<class T>
    void set_presentation_show_end_of_presentation_slide(const T& value) {
        addAttribute("presentation:show-end-of-presentation-slide", value);
    }
    template<class T>
    void set_presentation_show_logo(const T& value) {
        addAttribute("presentation:show-logo", value);
    }
    void set_presentation_start_page(const QString& value) {
        addAttribute("presentation:start-page", value);
    }
    template<class T>
    void set_presentation_start_with_navigator(const T& value) {
        addAttribute("presentation:start-with-navigator", value);
    }
    template<class T>
    void set_presentation_stay_on_top(const T& value) {
        addAttribute("presentation:stay-on-top", value);
    }
    template<class T>
    void set_presentation_transition_on_click(const T& value) {
        addAttribute("presentation:transition-on-click", value);
    }
};
class presentation_notes : public OdfWriter, public group_common_presentation_header_footer_attlist, public group_office_forms, public group_shape {
public:
    presentation_notes(OdfWriter* x) :OdfWriter(x, "presentation:notes", true), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
    }
    presentation_notes(KoXmlWriter* x) :OdfWriter(x, "presentation:notes", true), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_style_name(const QString& value) {
        addAttribute("draw:style-name", value);
    }
    void set_style_page_layout_name(const QString& value) {
        addAttribute("style:page-layout-name", value);
    }
};
class presentation_animations : public OdfWriter, public group_presentation_animation_elements {
public:
    presentation_animations(OdfWriter* x) :OdfWriter(x, "presentation:animations", true), group_presentation_animation_elements(*static_cast<OdfWriter*>(this)) {
    }
    presentation_animations(KoXmlWriter* x) :OdfWriter(x, "presentation:animations", true), group_presentation_animation_elements(*static_cast<OdfWriter*>(this)) {
    }
    presentation_animation_group add_presentation_animation_group();
};
}
inline writeodf::presentation_dim
writeodf::group_presentation_animation_elements::add_presentation_dim(const QString& draw_color, const QString& draw_shape_id) {
    return writeodf::presentation_dim(&xml, draw_color, draw_shape_id);
}
inline writeodf::presentation_hide_shape
writeodf::group_presentation_animation_elements::add_presentation_hide_shape(const QString& draw_shape_id) {
    return writeodf::presentation_hide_shape(&xml, draw_shape_id);
}
inline writeodf::presentation_hide_text
writeodf::group_presentation_animation_elements::add_presentation_hide_text(const QString& draw_shape_id) {
    return writeodf::presentation_hide_text(&xml, draw_shape_id);
}
inline writeodf::presentation_play
writeodf::group_presentation_animation_elements::add_presentation_play(const QString& draw_shape_id) {
    return writeodf::presentation_play(&xml, draw_shape_id);
}
inline writeodf::presentation_show_shape
writeodf::group_presentation_animation_elements::add_presentation_show_shape(const QString& draw_shape_id) {
    return writeodf::presentation_show_shape(&xml, draw_shape_id);
}
inline writeodf::presentation_show_text
writeodf::group_presentation_animation_elements::add_presentation_show_text(const QString& draw_shape_id) {
    return writeodf::presentation_show_text(&xml, draw_shape_id);
}
inline writeodf::presentation_notes
writeodf::group_presentation_notes::add_presentation_notes() {
    return writeodf::presentation_notes(&xml);
}
inline writeodf::presentation_sound
writeodf::group_presentation_sound::add_presentation_sound(const QUrl& xlink_href) {
    return writeodf::presentation_sound(&xml, xlink_href);
}
inline writeodf::presentation_show
writeodf::presentation_settings::add_presentation_show(const QString& presentation_name, const QString& presentation_pages) {
    return writeodf::presentation_show(this, presentation_name, presentation_pages);
}
inline writeodf::presentation_date_time
writeodf::group_paragraph_content::add_presentation_date_time() {
    return writeodf::presentation_date_time(&xml);
}
inline writeodf::presentation_footer
writeodf::group_paragraph_content::add_presentation_footer() {
    return writeodf::presentation_footer(&xml);
}
inline writeodf::presentation_header
writeodf::group_paragraph_content::add_presentation_header() {
    return writeodf::presentation_header(&xml);
}
inline writeodf::presentation_animation_group
writeodf::presentation_animations::add_presentation_animation_group() {
    return writeodf::presentation_animation_group(this);
}
#endif
