// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more of your secondary interfaces.
func (c *Client) DescribeSecondaryInterfaces(ctx context.Context, params *DescribeSecondaryInterfacesInput, optFns ...func(*Options)) (*DescribeSecondaryInterfacesOutput, error) {
	if params == nil {
		params = &DescribeSecondaryInterfacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSecondaryInterfaces", params, optFns, c.addOperationDescribeSecondaryInterfacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSecondaryInterfacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSecondaryInterfacesInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - attachment.attachment-id - The ID of the secondary interface attachment.
	//
	//   - attachment.instance-id - The ID of the instance to which the secondary
	//   interface is attached.
	//
	//   - attachment.instance-owner-id - The ID of the Amazon Web Services account
	//   that owns the instance to which the secondary interface is attached.
	//
	//   - attachment.status - The attachment status ( attaching | attached | detaching
	//   | detached ).
	//
	//   - private-ipv4-addresses.private-ip-address - The private IPv4 address
	//   associated with the secondary interface.
	//
	//   - owner-id - The ID of the Amazon Web Services account that owns the secondary
	//   interface.
	//
	//   - secondary-interface-arn - The ARN of the secondary interface.
	//
	//   - secondary-interface-id - The ID of the secondary interface.
	//
	//   - secondary-interface-type - The type of secondary interface ( secondary ).
	//
	//   - secondary-network-id - The ID of the secondary network.
	//
	//   - secondary-network-type - The type of the secondary network ( rdma ).
	//
	//   - secondary-subnet-id - The ID of the secondary subnet.
	//
	//   - status - The status of the secondary interface ( available | in-use ).
	//
	//   - tag : - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources assigned a tag with a specific key, regardless of the tag value.
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the secondary interfaces.
	SecondaryInterfaceIds []string

	noSmithyDocumentSerde
}

type DescribeSecondaryInterfacesOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the secondary interfaces.
	SecondaryInterfaces []types.SecondaryInterface

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSecondaryInterfacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeSecondaryInterfaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeSecondaryInterfaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSecondaryInterfaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSecondaryInterfaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeSecondaryInterfacesPaginatorOptions is the paginator options for
// DescribeSecondaryInterfaces
type DescribeSecondaryInterfacesPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSecondaryInterfacesPaginator is a paginator for
// DescribeSecondaryInterfaces
type DescribeSecondaryInterfacesPaginator struct {
	options   DescribeSecondaryInterfacesPaginatorOptions
	client    DescribeSecondaryInterfacesAPIClient
	params    *DescribeSecondaryInterfacesInput
	nextToken *string
	firstPage bool
}

// NewDescribeSecondaryInterfacesPaginator returns a new
// DescribeSecondaryInterfacesPaginator
func NewDescribeSecondaryInterfacesPaginator(client DescribeSecondaryInterfacesAPIClient, params *DescribeSecondaryInterfacesInput, optFns ...func(*DescribeSecondaryInterfacesPaginatorOptions)) *DescribeSecondaryInterfacesPaginator {
	if params == nil {
		params = &DescribeSecondaryInterfacesInput{}
	}

	options := DescribeSecondaryInterfacesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSecondaryInterfacesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSecondaryInterfacesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSecondaryInterfaces page.
func (p *DescribeSecondaryInterfacesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSecondaryInterfacesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeSecondaryInterfaces(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeSecondaryInterfacesAPIClient is a client that implements the
// DescribeSecondaryInterfaces operation.
type DescribeSecondaryInterfacesAPIClient interface {
	DescribeSecondaryInterfaces(context.Context, *DescribeSecondaryInterfacesInput, ...func(*Options)) (*DescribeSecondaryInterfacesOutput, error)
}

var _ DescribeSecondaryInterfacesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeSecondaryInterfaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSecondaryInterfaces",
	}
}
