
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "webpage_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_WebPage_Type = nullptr;
static PyTypeObject *Sbk_WebPage_TypeF(void)
{
    return _Sbk_WebPage_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void WebPageWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::WebPage::JsWorld >("WebPage::JsWorld");
}

void WebPageWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

WebPageWrapper::WebPageWrapper(::QObject * parent) : WebPage(parent)
{
}

void WebPageWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("WebPage", funcName, gil, pyOverride, event);
}

void WebPageWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebPage", funcName, gil, pyOverride, signal);
}

::QWebEnginePage * WebPageWrapper::createWindow(::QWebEnginePage::WebWindowType type)
{
    static const char *funcName = "createWindow";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEnginePage::createWindow(type);
    }
    return sbk_o_createWindow("WebPage", funcName, gil, pyOverride, type);
}

::QWebEnginePage * WebPageWrapper::sbk_o_createWindow(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::WebWindowType type)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_WebWindowType_IDX])))->converter, &type)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_WebWindowType_IDX])))->converter, &type)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QWebEnginePage >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWebEnginePage *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void WebPageWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("WebPage", funcName, gil, pyOverride, event);
}

void WebPageWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebPage", funcName, gil, pyOverride, signal);
}

bool WebPageWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEnginePage::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("WebPage", funcName, gil, pyOverride, arg__1);
}

bool WebPageWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("WebPage", funcName, gil, pyOverride, watched, event);
}

void WebPageWrapper::javaScriptAlert(const ::QUrl & securityOrigin, const ::QString & msg)
{
    static const char *funcName = "javaScriptAlert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebPage::javaScriptAlert(securityOrigin, msg);
    }
    sbk_o_javaScriptAlert("WebPage", funcName, gil, pyOverride, securityOrigin, msg);
}

void WebPageWrapper::sbk_o_javaScriptAlert(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

bool WebPageWrapper::javaScriptConfirm(const ::QUrl & securityOrigin, const ::QString & msg)
{
    static const char *funcName = "javaScriptConfirm";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebPage::javaScriptConfirm(securityOrigin, msg);
    }
    return sbk_o_javaScriptConfirm("WebPage", funcName, gil, pyOverride, securityOrigin, msg);
}

bool WebPageWrapper::sbk_o_javaScriptConfirm(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void WebPageWrapper::javaScriptConsoleMessage(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID)
{
    static const char *funcName = "javaScriptConsoleMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebPage::javaScriptConsoleMessage(level, message, lineNumber, sourceID);
    }
    sbk_o_javaScriptConsoleMessage("WebPage", funcName, gil, pyOverride, level, message, lineNumber, sourceID);
}

void WebPageWrapper::sbk_o_javaScriptConsoleMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_JavaScriptConsoleMessageLevel_IDX])))->converter, &level),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &lineNumber),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &sourceID)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_JavaScriptConsoleMessageLevel_IDX])))->converter, &level),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message),
        lineNumber,
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &sourceID)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

bool WebPageWrapper::javaScriptPrompt(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result)
{
    static const char *funcName = "javaScriptPrompt";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result);
    }
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtwebenginecore.cpp (qwebenginepage-javascriptprompt-virtual-redirect)]
    std::pair<bool, QString> resultPair = javaScriptPromptPyOverride(gil, pyOverride.object(), securityOrigin, msg, defaultValue);
    result->assign(resultPair.second);
    return resultPair.first;
    // END of custom code block [file: ../glue/qtwebenginecore.cpp (qwebenginepage-javascriptprompt-virtual-redirect)]
    // ========================================================================
    // End of code injection

    return sbk_o_javaScriptPrompt("WebPage", funcName, gil, pyOverride, securityOrigin, msg, defaultValue, result);
}

bool WebPageWrapper::sbk_o_javaScriptPrompt(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &defaultValue)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

void WebPageWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("WebPage", funcName, gil, pyOverride, event);
}

void WebPageWrapper::triggerAction(::QWebEnginePage::WebAction action, bool checked)
{
    static const char *funcName = "triggerAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebPage_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEnginePage::triggerAction(action, checked);
    }
    sbk_o_triggerAction("WebPage", funcName, gil, pyOverride, action, checked);
}

void WebPageWrapper::sbk_o_triggerAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::WebAction action, bool checked)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_WebAction_IDX])))->converter, &action),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &checked)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_WebAction_IDX])))->converter, &action),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &checked)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *WebPageWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return WebPage::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int WebPageWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = WebPage::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *WebPageWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< WebPageWrapper *>(this));
    }
    return WebPage::qt_metacast(_clname);
}

WebPageWrapper::~WebPageWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_WebPage_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

::std::pair<bool,QString> WebPageWrapper::javaScriptPromptPyOverride(Shiboken::GilState &gil, PyObject *pyOverride, ::QUrl securityOrigin, ::QString msg, ::QString defaultValue)
{
    SBK_UNUSED(gil)
    static const char *funcName = "javaScriptPromptPyOverride";
    const char ownerClassName[] = "WebPage";
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &defaultValue)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &securityOrigin),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &msg),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &defaultValue)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_std_pair_bool_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "tuple", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    std::pair<bool,QString> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebPage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebPage >()))
        return -1;

    WebPageWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:WebPage", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: WebPage::WebPage(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // WebPage(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // WebPage(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // WebPage(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) WebPageWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new WebPageWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< WebPage >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
    };


    return 1;
}

static PyObject *Sbk_WebPageFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "acceptNavigationRequest", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_NavigationType_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
        overloadId = 0; // acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "acceptNavigationRequest", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("acceptNavigationRequest(const QUrl &url, QWebEnginePage.NavigationType type, bool isMainFrame)");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_addSupportedScheme(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebPage::addSupportedScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addSupportedScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addSupportedScheme", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addSupportedScheme(QString)
            ::WebPage::addSupportedScheme(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_autoFillUsernames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoFillUsernames()const
        QStringList cppResult = const_cast<const WebPageWrapper *>(cppSelf)->autoFillUsernames();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_chooseFiles(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "chooseFiles", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)->QStringList
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_FileSelectionMode_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        overloadId = 0; // chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "chooseFiles", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("chooseFiles(QWebEnginePage.FileSelectionMode mode, const QStringList &oldFiles, const QStringList &acceptedMimeTypes)");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_execJavaScript(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "execJavaScript", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:execJavaScript", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebPage::execJavaScript(QString,quint32=,int=)->QVariant
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execJavaScript(QString,quint32,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // execJavaScript(QString,quint32,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // execJavaScript(QString,quint32,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "execJavaScript", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"worldId", 1}, {"timeout", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "execJavaScript", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        quint32 cppArg1 = WebPage::UnsafeJsWorld;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 500;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // execJavaScript(QString,quint32,int)
            QVariant cppResult = cppSelf->execJavaScript(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_execPrintPage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "execPrintPage", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    if (PyArg_ParseTuple(args, "|OO:execPrintPage", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebPage::execPrintPage(QPrinter*,int=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtPrintSupportTypeStructs[SBK_QPrinter_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execPrintPage(QPrinter*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // execPrintPage(QPrinter*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "execPrintPage", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"timeout", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "execPrintPage", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPrinter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 1000;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // execPrintPage(QPrinter*,int)
            bool cppResult = cppSelf->execPrintPage(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_finished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // finished()
        static_cast<WebPageWrapper *>(cppSelf)->WebPageWrapper::finished_protected();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_hitTestContent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::hitTestContent(QPoint)const->WebHitTestResult
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArg)))) {
        overloadId = 0; // hitTestContent(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hitTestContent", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // hitTestContent(QPoint)const
            WebHitTestResult cppResult = const_cast<const WebPageWrapper *>(cppSelf)->hitTestContent(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_internalSchemes(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalSchemes()
        QStringList cppResult = ::WebPage::internalSchemes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_isLoading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isLoading()const
        bool cppResult = const_cast<const WebPageWrapper *>(cppSelf)->isLoading();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_isRunningLoop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRunningLoop()
        bool cppResult = cppSelf->isRunningLoop();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_javaScriptAlert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "javaScriptAlert", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptAlert(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptAlert(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "javaScriptAlert", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // javaScriptAlert(QUrl,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptAlert(*cppArg0, cppArg1)
                : cppSelf->javaScriptAlert(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_javaScriptConfirm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "javaScriptConfirm", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConfirm(QUrl,QString)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptConfirm(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "javaScriptConfirm", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // javaScriptConfirm(QUrl,QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptConfirm(*cppArg0, cppArg1)
                : cppSelf->javaScriptConfirm(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_javaScriptConsoleMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "javaScriptConsoleMessage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_JavaScriptConsoleMessageLevel_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "javaScriptConsoleMessage", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        ::QWebEnginePage::JavaScriptConsoleMessageLevel cppArg0{QWebEnginePage::InfoMessageLevel};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_mapToViewport(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::mapToViewport(QPointF)const->QPointF
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // mapToViewport(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mapToViewport", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // mapToViewport(QPointF)const
            QPointF cppResult = const_cast<const WebPageWrapper *>(cppSelf)->mapToViewport(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_progress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::progress(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // progress(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "progress", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // progress(int)
            static_cast<WebPageWrapper *>(cppSelf)->WebPageWrapper::progress_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_registerProtocolHandlerRequestScheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // registerProtocolHandlerRequestScheme()const
        QString cppResult = const_cast<const WebPageWrapper *>(cppSelf)->registerProtocolHandlerRequestScheme();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_registerProtocolHandlerRequestUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // registerProtocolHandlerRequestUrl()const
        QUrl cppResult = const_cast<const WebPageWrapper *>(cppSelf)->registerProtocolHandlerRequestUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_removeSupportedScheme(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebPage::removeSupportedScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeSupportedScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeSupportedScheme", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeSupportedScheme(QString)
            ::WebPage::removeSupportedScheme(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_scroll(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "scroll", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebPage::scroll(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // scroll(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "scroll", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // scroll(int,int)
            cppSelf->scroll(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_setScrollPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::setScrollPosition(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setScrollPosition(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setScrollPosition", errInfo, SbkPyFalkonTypeStructs[SBK_WebPage_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setScrollPosition(QPointF)
            cppSelf->setScrollPosition(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebPageFunc_supportedSchemes(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // supportedSchemes()
        QStringList cppResult = ::WebPage::supportedSchemes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebPageFunc_view(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // view()const
        WebView * cppResult = const_cast<const WebPageWrapper *>(cppSelf)->view();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_WebPage_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_WebPage_EnumFlagInfo[] = {
    "JsWorld:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebPage_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_acceptNavigationRequest), METH_VARARGS, nullptr},
    {"addSupportedScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_addSupportedScheme), METH_O|METH_STATIC, nullptr},
    {"autoFillUsernames", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_autoFillUsernames), METH_NOARGS, nullptr},
    {"chooseFiles", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_chooseFiles), METH_VARARGS, nullptr},
    {"execJavaScript", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_execJavaScript), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"execPrintPage", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_execPrintPage), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_finished), METH_NOARGS, nullptr},
    {"hitTestContent", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_hitTestContent), METH_O, nullptr},
    {"internalSchemes", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_internalSchemes), METH_NOARGS|METH_STATIC, nullptr},
    {"isLoading", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_isLoading), METH_NOARGS, nullptr},
    {"isRunningLoop", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_isRunningLoop), METH_NOARGS, nullptr},
    {"javaScriptAlert", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptAlert), METH_VARARGS, nullptr},
    {"javaScriptConfirm", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptConfirm), METH_VARARGS, nullptr},
    {"javaScriptConsoleMessage", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptConsoleMessage), METH_VARARGS, nullptr},
    {"mapToViewport", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_mapToViewport), METH_O, nullptr},
    {"progress", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_progress), METH_O, nullptr},
    {"registerProtocolHandlerRequestScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_registerProtocolHandlerRequestScheme), METH_NOARGS, nullptr},
    {"registerProtocolHandlerRequestUrl", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_registerProtocolHandlerRequestUrl), METH_NOARGS, nullptr},
    {"removeSupportedScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_removeSupportedScheme), METH_O|METH_STATIC, nullptr},
    {"scroll", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_scroll), METH_VARARGS, nullptr},
    {"setScrollPosition", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_setScrollPosition), METH_O, nullptr},
    {"supportedSchemes", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_supportedSchemes), METH_NOARGS|METH_STATIC, nullptr},
    {"view", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_view), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_WebPage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<WebPageWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_WebPage_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_WebPage_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_WebPage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_WebPage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebPage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebPage_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebPage_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebPage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_WebPage_spec = {
    "1:PyFalkon.WebPage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_WebPage_slots
};

} //extern "C"

static void *Sbk_WebPage_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::WebPage *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_WebPage_JsWorld(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::WebPage::JsWorld>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::WebPage::JsWorld *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_WebPage_JsWorld_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_JsWorld_IDX])))
        return Enum_PythonToCpp_WebPage_JsWorld;
    return {};
}

static PyObject *WebPage_JsWorld_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::WebPage::JsWorld>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::WebPage::JsWorld *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebPage_PythonToCpp_WebPage_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebPage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebPage_PythonToCpp_WebPage_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_WebPage_TypeF()))
        return WebPage_PythonToCpp_WebPage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebPage_PTR_CppToPython_WebPage(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::WebPage *>(const_cast<void *>(cppIn)), Sbk_WebPage_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *WebPage_SignatureStrings[] = {
    "PyFalkon.WebPage(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.WebPage.acceptNavigationRequest(self,url:typing.Union[PySide6.QtCore.QUrl, QString],type:PySide6.QtWebEngineCore.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PyFalkon.WebPage.addSupportedScheme(scheme:QString)",
    "PyFalkon.WebPage.autoFillUsernames(self)->QStringList",
    "PyFalkon.WebPage.chooseFiles(self,mode:PySide6.QtWebEngineCore.QWebEnginePage.FileSelectionMode,oldFiles:QStringList,acceptedMimeTypes:QStringList)->QStringList",
    "PyFalkon.WebPage.execJavaScript(self,scriptSource:QString,worldId:quint32=WebPage.UnsafeJsWorld,timeout:int=500)->QVariant",
    "PyFalkon.WebPage.execPrintPage(self,printer:PySide6.QtPrintSupport.QPrinter,timeout:int=1000)->bool",
    "PyFalkon.WebPage.finished(self)",
    "PyFalkon.WebPage.hitTestContent(self,pos:PySide6.QtCore.QPoint)->PyFalkon.WebHitTestResult",
    "PyFalkon.WebPage.internalSchemes()->QStringList",
    "PyFalkon.WebPage.isLoading(self)->bool",
    "PyFalkon.WebPage.isRunningLoop(self)->bool",
    "PyFalkon.WebPage.javaScriptAlert(self,securityOrigin:typing.Union[PySide6.QtCore.QUrl, QString],msg:QString)",
    "PyFalkon.WebPage.javaScriptConfirm(self,securityOrigin:typing.Union[PySide6.QtCore.QUrl, QString],msg:QString)->bool",
    "PyFalkon.WebPage.javaScriptConsoleMessage(self,level:PySide6.QtWebEngineCore.QWebEnginePage.JavaScriptConsoleMessageLevel,message:QString,lineNumber:int,sourceID:QString)",
    "PyFalkon.WebPage.mapToViewport(self,pos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])->PySide6.QtCore.QPointF",
    "PyFalkon.WebPage.progress(self,prog:int)",
    "PyFalkon.WebPage.registerProtocolHandlerRequestScheme(self)->QString",
    "PyFalkon.WebPage.registerProtocolHandlerRequestUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebPage.removeSupportedScheme(scheme:QString)",
    "PyFalkon.WebPage.scroll(self,x:int,y:int)",
    "PyFalkon.WebPage.setScrollPosition(self,pos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "PyFalkon.WebPage.supportedSchemes()->QStringList",
    "PyFalkon.WebPage.view(self)->PyFalkon.WebView",
    nullptr}; // Sentinel
#else
static constexpr size_t WebPage_SignatureByteSize = 627;
static constexpr uint8_t WebPage_SignatureBytes[627] = {
    0x78, 0xda, 0xad, 0x54, 0x4d, 0x6f, 0xda, 0x40, 0x10, 0xbd, 0xe7, 0x57, 0xe4, 0x98, 0x48, 0x5b,
    0x44, 0x5b, 0xb5, 0x07, 0x4b, 0x54, 0xaa, 0xd2, 0xa2, 0x04, 0x41, 0x62, 0x30, 0x24, 0x87, 0x2a,
    0x87, 0xc5, 0x1e, 0xcc, 0xa6, 0xeb, 0x1d, 0x67, 0x77, 0x4d, 0xc2, 0xbf, 0xcf, 0xec, 0xda, 0xe6,
    0x23, 0x18, 0x08, 0x52, 0x4e, 0x66, 0x99, 0x99, 0xf7, 0xe6, 0xe3, 0xcd, 0x84, 0xcb, 0x2e, 0x97,
    0xff, 0x51, 0xb5, 0x1e, 0x60, 0x1a, 0xf2, 0x14, 0x2e, 0x0c, 0xc8, 0x19, 0xcb, 0xb9, 0x06, 0x65,
    0x83, 0x70, 0x19, 0x89, 0x04, 0x7e, 0xb6, 0x86, 0xf6, 0x0a, 0x35, 0xb4, 0x86, 0x77, 0xd3, 0x27,
    0x88, 0x6d, 0x47, 0x15, 0x52, 0xe6, 0x56, 0x5f, 0x9e, 0x85, 0xef, 0x82, 0x5b, 0x3c, 0x8e, 0x21,
    0xb7, 0xb7, 0x7c, 0x21, 0x52, 0x6e, 0x05, 0xaa, 0x11, 0x3c, 0x17, 0x60, 0x6c, 0x09, 0x5a, 0x68,
    0x19, 0xd8, 0x65, 0x2e, 0x54, 0xda, 0x9a, 0x28, 0x32, 0xfe, 0x7b, 0x0f, 0x3f, 0xd1, 0x92, 0x9d,
    0x0f, 0x23, 0xab, 0xc9, 0xe5, 0x91, 0x91, 0x2b, 0x6c, 0x64, 0x40, 0x14, 0x7f, 0x55, 0x2a, 0x14,
    0x94, 0xbe, 0xab, 0xa7, 0xe7, 0x5d, 0x33, 0x8e, 0x29, 0x8a, 0x09, 0x33, 0xe0, 0x42, 0x75, 0x35,
    0xcf, 0x20, 0x98, 0x22, 0xca, 0xcb, 0x2f, 0xbf, 0xdc, 0xa7, 0x21, 0xdf, 0x24, 0x89, 0x8a, 0x3c,
    0x47, 0x6d, 0x21, 0x89, 0xe2, 0x39, 0x64, 0x54, 0xbf, 0xff, 0x04, 0x55, 0x1a, 0x4d, 0x35, 0x16,
    0x16, 0xbb, 0x42, 0xca, 0x89, 0x01, 0xad, 0x88, 0xc1, 0xf8, 0xea, 0x88, 0xa2, 0x0a, 0xe9, 0x0b,
    0x63, 0x77, 0xa3, 0xe2, 0x39, 0xa2, 0x01, 0x8a, 0xab, 0xfc, 0x59, 0x86, 0xc9, 0x87, 0xcb, 0x73,
    0x61, 0x11, 0x48, 0xea, 0x3d, 0x55, 0x38, 0xa0, 0x40, 0x86, 0x32, 0xf1, 0x58, 0xc1, 0x06, 0x29,
    0x2b, 0xbb, 0x0f, 0xc9, 0x40, 0x64, 0xe0, 0xfa, 0xb0, 0x65, 0x3d, 0x96, 0x20, 0xbc, 0x42, 0xdc,
    0xe3, 0x0b, 0x1e, 0xc5, 0x5a, 0xe4, 0xd5, 0xc4, 0x8c, 0xff, 0x1d, 0x61, 0xa1, 0xe3, 0x55, 0x47,
    0xd8, 0x0b, 0x6a, 0x99, 0xdc, 0x24, 0xc1, 0x73, 0x21, 0x94, 0xfd, 0xfe, 0xad, 0x53, 0x03, 0x4c,
    0x94, 0xe1, 0x33, 0xe8, 0x99, 0x07, 0x67, 0x67, 0x96, 0x72, 0xc0, 0xc2, 0x06, 0xe4, 0xd3, 0xf9,
    0xd1, 0x6e, 0x3b, 0xf6, 0x7b, 0xae, 0x05, 0x57, 0x7b, 0xa8, 0x43, 0xc2, 0xb6, 0x1b, 0x02, 0x74,
    0x4f, 0xd0, 0x1b, 0x0d, 0xf2, 0x0e, 0xd5, 0xb0, 0x5a, 0xc3, 0xb0, 0xb4, 0x6f, 0xd1, 0x7c, 0x6d,
    0x7b, 0x9e, 0xe6, 0x49, 0xcf, 0x84, 0x12, 0x66, 0x0e, 0x49, 0x39, 0xac, 0x5d, 0xfb, 0x5c, 0xd8,
    0x31, 0x29, 0xf5, 0x0a, 0x09, 0x56, 0x55, 0xe5, 0xe7, 0x68, 0x76, 0x56, 0x20, 0x44, 0xa2, 0x22,
    0x96, 0x4d, 0x80, 0xeb, 0x32, 0x76, 0x04, 0xa6, 0x90, 0x0d, 0xe5, 0xf9, 0x4c, 0x15, 0x97, 0xa5,
    0xc0, 0xcc, 0xc5, 0xb1, 0x49, 0x08, 0xd3, 0x47, 0x9e, 0x90, 0xb9, 0x16, 0x56, 0x73, 0x45, 0xc2,
    0x8c, 0x0a, 0xa5, 0x1c, 0x0a, 0x62, 0x7e, 0xd8, 0xf5, 0x69, 0x35, 0xd7, 0xdf, 0x12, 0x74, 0x3d,
    0x5c, 0x88, 0x0b, 0x2d, 0xec, 0xf2, 0x4e, 0x0b, 0x12, 0xda, 0x29, 0x9b, 0x99, 0x99, 0xf4, 0xc0,
    0x7e, 0xac, 0xc9, 0xa8, 0x99, 0x33, 0xa1, 0xb3, 0xcf, 0xa4, 0x3b, 0x5e, 0x21, 0x91, 0x1a, 0x94,
    0x30, 0x00, 0x63, 0x56, 0x6a, 0x92, 0xb0, 0x00, 0xf9, 0xd1, 0x65, 0xeb, 0xed, 0x81, 0xea, 0x3b,
    0x10, 0x96, 0x95, 0x8f, 0xd5, 0x36, 0x48, 0x0a, 0xbb, 0x2d, 0xb2, 0x29, 0x69, 0x95, 0xe6, 0xcc,
    0x8c, 0xdf, 0x95, 0x9b, 0x3f, 0x07, 0xfa, 0x93, 0xf1, 0x7c, 0x8c, 0xf7, 0x02, 0x5e, 0x9c, 0x92,
    0xd7, 0x42, 0x3b, 0xd8, 0x10, 0xaf, 0xba, 0x2e, 0x3b, 0x6f, 0xfc, 0xff, 0xd1, 0xcb, 0xb1, 0x29,
    0x60, 0x97, 0x3c, 0xd7, 0x98, 0x6a, 0x2a, 0xa1, 0xde, 0x32, 0x4c, 0x5d, 0xda, 0x0d, 0x59, 0x6a,
    0x48, 0x49, 0x9c, 0xa0, 0x43, 0x8d, 0x16, 0x63, 0x94, 0xd7, 0x5c, 0x25, 0xa4, 0x9d, 0xea, 0xa0,
    0xd7, 0xb7, 0x72, 0xeb, 0xf0, 0x9d, 0x0a, 0x42, 0x53, 0xae, 0x11, 0x1a, 0x04, 0xd0, 0x84, 0x96,
    0xe1, 0x02, 0x4e, 0xbe, 0xd7, 0x74, 0xc4, 0x50, 0x96, 0x4c, 0xec, 0xd5, 0x0f, 0x69, 0xb9, 0xa7,
    0x66, 0x03, 0x54, 0x98, 0x73, 0x0e, 0xd1, 0x08, 0x77, 0x6a, 0x3f, 0x67, 0x3a, 0x0d, 0x44, 0xdb,
    0x35, 0x1c, 0x3f, 0x09, 0x0b, 0x92, 0xcb, 0xba, 0x57, 0x6b, 0xa3, 0x93, 0xd1, 0xd9, 0x1b, 0xca,
    0xca, 0xd8, 0xa5
};
#endif

PyTypeObject *init_WebPage(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_WebPage_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_WebPage_IDX].type;

    Shiboken::AutoDecRef Sbk_WebPage_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_IDX]))));

    _Sbk_WebPage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebPage",
        "WebPage*",
        &Sbk_WebPage_spec,
        &Shiboken::callCppDestructor< WebPage >,
        Sbk_WebPage_Type_bases.object(),
        0);
    auto *pyType = Sbk_WebPage_TypeF(); // references _Sbk_WebPage_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, WebPage_SignatureStrings);
#else
    InitSignatureBytes(pyType, WebPage_SignatureBytes, WebPage_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_WebPage_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_WebPage_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        WebPage_PythonToCpp_WebPage_PTR,
        is_WebPage_PythonToCpp_WebPage_PTR_Convertible,
        WebPage_PTR_CppToPython_WebPage);

    Shiboken::Conversions::registerConverterName(converter, "WebPage");
    Shiboken::Conversions::registerConverterName(converter, "WebPage*");
    Shiboken::Conversions::registerConverterName(converter, "WebPage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebPage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(WebPageWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_WebPage_TypeF(), &Sbk_WebPage_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_WebPage_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'JsWorld'.
    const char *JsWorld_Initializer[] = {
        "UnsafeJsWorld",
        "SafeJsWorld",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t JsWorld_InitializerValues[] = {
        uint8_t(WebPage::JsWorld::UnsafeJsWorld), //  0x00  0
        uint8_t(WebPage::JsWorld::SafeJsWorld)    //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_WebPage_TypeF(),
        "1:PyFalkon.WebPage.JsWorld",
        JsWorld_Initializer, JsWorld_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_WebPage_JsWorld_IDX].type = EType;
    // Register converter for enum 'WebPage::JsWorld'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            WebPage_JsWorld_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_WebPage_JsWorld,
            is_Enum_PythonToCpp_WebPage_JsWorld_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "WebPage::JsWorld");
        Shiboken::Conversions::registerConverterAlias(converter, "JsWorld");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'JsWorld' enum.

    PySide::Signal::registerSignals(pyType, &::WebPage::staticMetaObject);
    WebPageWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::WebPage::staticMetaObject, sizeof(WebPageWrapper));

    return pyType;
}
