
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "webtab_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_WebTab_Type = nullptr;
static PyTypeObject *Sbk_WebTab_TypeF(void)
{
    return _Sbk_WebTab_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void WebTabWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::WebTab::AddChildBehavior >("WebTab::AddChildBehavior");
}

void WebTabWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

WebTabWrapper::WebTabWrapper(::QWidget * parent) : WebTab(parent)
{
}

void WebTabWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebTab", funcName, gil, pyOverride, signal);
}

void WebTabWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("WebTab", funcName, gil, pyOverride, event);
}

int WebTabWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("WebTab", funcName, gil, pyOverride);
}

void WebTabWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebTab", funcName, gil, pyOverride, signal);
}

void WebTabWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("WebTab", funcName, gil, pyOverride, event);
}

bool WebTabWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("WebTab", funcName, gil, pyOverride, event);
}

bool WebTabWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("WebTab", funcName, gil, pyOverride, watched, event);
}

void WebTabWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("WebTab", funcName, gil, pyOverride, event);
}

bool WebTabWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("WebTab", funcName, gil, pyOverride, next);
}

void WebTabWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("WebTab", funcName, gil, pyOverride, event);
}

bool WebTabWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("WebTab", funcName, gil, pyOverride);
}

int WebTabWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("WebTab", funcName, gil, pyOverride, arg__1);
}

void WebTabWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("WebTab", funcName, gil, pyOverride, painter);
}

void WebTabWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("WebTab", funcName, gil, pyOverride, event);
}

::QVariant WebTabWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("WebTab", funcName, gil, pyOverride, arg__1);
}

void WebTabWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("WebTab", funcName, gil, pyOverride, event);
}

int WebTabWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("WebTab", funcName, gil, pyOverride, arg__1);
}

::QSize WebTabWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("WebTab", funcName, gil, pyOverride);
}

void WebTabWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("WebTab", funcName, gil, pyOverride, event);
}

bool WebTabWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("WebTab", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * WebTabWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("WebTab", funcName, gil, pyOverride);
}

void WebTabWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("WebTab", funcName, gil, pyOverride, event);
}

::QPaintDevice * WebTabWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("WebTab", funcName, gil, pyOverride, offset);
}

void WebTabWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("WebTab", funcName, gil, pyOverride, visible);
}

::QPainter * WebTabWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("WebTab", funcName, gil, pyOverride);
}

void WebTabWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("WebTab", funcName, gil, pyOverride, event);
}

::QSize WebTabWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("WebTab", funcName, gil, pyOverride);
}

void WebTabWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("WebTab", funcName, gil, pyOverride, event);
}

void WebTabWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebTab_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("WebTab", funcName, gil, pyOverride, event);
}

const QMetaObject *WebTabWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return WebTab::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int WebTabWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = WebTab::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *WebTabWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< WebTabWrapper *>(this));
    }
    return WebTab::qt_metacast(_clname);
}

WebTabWrapper::~WebTabWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_WebTab_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebTab_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebTab >()))
        return -1;

    WebTabWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:WebTab", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: WebTab::WebTab(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // WebTab(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // WebTab(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // WebTab(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) WebTabWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new WebTabWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< WebTab >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
    };


    return 1;
}

static PyObject *Sbk_WebTabFunc_addChildBehavior(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // addChildBehavior()
        WebTab::AddChildBehavior cppResult = WebTab::AddChildBehavior(::WebTab::addChildBehavior());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_AddChildBehavior_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_addChildTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addChildTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addChildTab", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::addChildTab(WebTab*,int=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addChildTab(WebTab*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // addChildTab(WebTab*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addChildTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"index", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addChildTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebTab *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addChildTab(WebTab*,int)
            cppSelf->addChildTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_attach(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::attach(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // attach(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "attach", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // attach(BrowserWindow*)
            cppSelf->attach(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_backgroundActivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backgroundActivity()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->backgroundActivity();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_browserWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // browserWindow()const
        BrowserWindow * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->browserWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_childTabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // childTabs()const
        QList<WebTab*> cppResult = const_cast<const WebTabWrapper *>(cppSelf)->childTabs();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_WebTabPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_closeTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeTab()
        cppSelf->closeTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_haveInspector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // haveInspector()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->haveInspector();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_history(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // history()const
        QWebEngineHistory * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->history();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineHistory_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_historyData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // historyData()const
        QByteArray cppResult = const_cast<const WebTabWrapper *>(cppSelf)->historyData();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_icon(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "icon", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    if (PyArg_ParseTuple(args, "|O:icon", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::icon(bool=)const->QIcon
    if (numArgs == 0) {
        overloadId = 0; // icon(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // icon(bool)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "icon", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowNull", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "icon", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // icon(bool)const
            QIcon cppResult = const_cast<const WebTabWrapper *>(cppSelf)->icon(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isCurrentTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCurrentTab()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isCurrentTab();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isLoading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isLoading()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isLoading();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isMuted()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isMuted();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isPinned(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isPinned()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isPinned();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isPlaying(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isPlaying()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isPlaying();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_isRestored(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRestored()const
        bool cppResult = const_cast<const WebTabWrapper *>(cppSelf)->isRestored();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_load(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::load(LoadRequest)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArg)))) {
        overloadId = 0; // load(LoadRequest)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "load", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::LoadRequest cppArg0_local;
        ::LoadRequest *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // load(LoadRequest)
            cppSelf->load(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_locationBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // locationBar()const
        LocationBar * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->locationBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_makeCurrentTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // makeCurrentTab()
        cppSelf->makeCurrentTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_moveTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::moveTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // moveTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "moveTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // moveTab(int)
            cppSelf->moveTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_p_restoreTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "p_restoreTab", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::p_restoreTab(QUrl,QByteArray,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // p_restoreTab(QUrl,QByteArray,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "p_restoreTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // p_restoreTab(QUrl,QByteArray,int)
            cppSelf->p_restoreTab(*cppArg0, *cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_parentTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // parentTab()const
        WebTab * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->parentTab();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_reload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reload()
        cppSelf->reload();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("resizeEvent(QResizeEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_sessionData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sessionData()const
        QHash<QString,QVariant> cppResult = const_cast<const WebTabWrapper *>(cppSelf)->sessionData();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QVariant_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_setAddChildBehavior(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebTab::setAddChildBehavior(WebTab::AddChildBehavior)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_AddChildBehavior_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setAddChildBehavior(WebTab::AddChildBehavior)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAddChildBehavior", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        ::WebTab::AddChildBehavior cppArg0{WebTab::AppendChild};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAddChildBehavior(WebTab::AddChildBehavior)
            ::WebTab::setAddChildBehavior(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_setMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::setMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMuted", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMuted(bool)
            cppSelf->setMuted(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_setParentTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::setParentTab(WebTab*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArg)))) {
        overloadId = 0; // setParentTab(WebTab*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setParentTab", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebTab *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setParentTab(WebTab*)
            cppSelf->setParentTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_setPinned(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::setPinned(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPinned(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPinned", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPinned(bool)
            cppSelf->setPinned(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_setSessionData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setSessionData", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::setSessionData(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
        overloadId = 0; // setSessionData(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setSessionData", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSessionData(QString,QVariant)
            cppSelf->setSessionData(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_setZoomLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebTab::setZoomLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setZoomLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setZoomLevel", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setZoomLevel(int)
            cppSelf->setZoomLevel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_showSearchToolBar(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showSearchToolBar", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    if (PyArg_ParseTuple(args, "|O:showSearchToolBar", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::showSearchToolBar(const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // showSearchToolBar(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // showSearchToolBar(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showSearchToolBar", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"searchText", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showSearchToolBar", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showSearchToolBar(QString)
            cppSelf->showSearchToolBar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_showWebInspector(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showWebInspector", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    if (PyArg_ParseTuple(args, "|O:showWebInspector", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::showWebInspector(bool=)
    if (numArgs == 0) {
        overloadId = 0; // showWebInspector(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // showWebInspector(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showWebInspector", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"inspectElement", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showWebInspector", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showWebInspector(bool)
            cppSelf->showWebInspector(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        cppSelf->stop();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_tabActivated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabActivated()
        cppSelf->tabActivated();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_tabIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabIcon()const
        TabIcon * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->tabIcon();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_tabIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabIndex()const
        int cppResult = const_cast<const WebTabWrapper *>(cppSelf)->tabIndex();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_title(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "title", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    if (PyArg_ParseTuple(args, "|O:title", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebTab::title(bool=)const->QString
    if (numArgs == 0) {
        overloadId = 0; // title(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // title(bool)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "title", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowEmpty", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "title", errInfo, SbkPyFalkonTypeStructs[SBK_WebTab_IDX]);
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // title(bool)const
            QString cppResult = const_cast<const WebTabWrapper *>(cppSelf)->title(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_toggleMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleMuted()
        cppSelf->toggleMuted();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_togglePinned(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // togglePinned()
        cppSelf->togglePinned();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_toggleWebInspector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleWebInspector()
        cppSelf->toggleWebInspector();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_unload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unload()
        cppSelf->unload();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebTabFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // url()const
        QUrl cppResult = const_cast<const WebTabWrapper *>(cppSelf)->url();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_webView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webView()const
        TabbedWebView * cppResult = const_cast<const WebTabWrapper *>(cppSelf)->webView();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebTabFunc_zoomLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebTabWrapper *>(reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // zoomLevel()const
        int cppResult = const_cast<const WebTabWrapper *>(cppSelf)->zoomLevel();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_WebTab_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_WebTab_EnumFlagInfo[] = {
    "AddChildBehavior:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebTab_methods[] = {
    {"addChildBehavior", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_addChildBehavior), METH_NOARGS|METH_STATIC, nullptr},
    {"addChildTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_addChildTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"attach", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_attach), METH_O, nullptr},
    {"backgroundActivity", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_backgroundActivity), METH_NOARGS, nullptr},
    {"browserWindow", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_browserWindow), METH_NOARGS, nullptr},
    {"childTabs", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_childTabs), METH_NOARGS, nullptr},
    {"closeTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_closeTab), METH_NOARGS, nullptr},
    {"haveInspector", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_haveInspector), METH_NOARGS, nullptr},
    {"history", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_history), METH_NOARGS, nullptr},
    {"historyData", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_historyData), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_icon), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"isCurrentTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isCurrentTab), METH_NOARGS, nullptr},
    {"isLoading", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isLoading), METH_NOARGS, nullptr},
    {"isMuted", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isMuted), METH_NOARGS, nullptr},
    {"isPinned", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isPinned), METH_NOARGS, nullptr},
    {"isPlaying", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isPlaying), METH_NOARGS, nullptr},
    {"isRestored", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_isRestored), METH_NOARGS, nullptr},
    {"load", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_load), METH_O, nullptr},
    {"locationBar", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_locationBar), METH_NOARGS, nullptr},
    {"makeCurrentTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_makeCurrentTab), METH_NOARGS, nullptr},
    {"moveTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_moveTab), METH_O, nullptr},
    {"p_restoreTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_p_restoreTab), METH_VARARGS, nullptr},
    {"parentTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_parentTab), METH_NOARGS, nullptr},
    {"reload", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_reload), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_resizeEvent), METH_O, nullptr},
    {"sessionData", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_sessionData), METH_NOARGS, nullptr},
    {"setAddChildBehavior", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setAddChildBehavior), METH_O|METH_STATIC, nullptr},
    {"setMuted", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setMuted), METH_O, nullptr},
    {"setParentTab", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setParentTab), METH_O, nullptr},
    {"setPinned", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setPinned), METH_O, nullptr},
    {"setSessionData", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setSessionData), METH_VARARGS, nullptr},
    {"setZoomLevel", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_setZoomLevel), METH_O, nullptr},
    {"showSearchToolBar", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_showSearchToolBar), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"showWebInspector", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_showWebInspector), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_stop), METH_NOARGS, nullptr},
    {"tabActivated", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_tabActivated), METH_NOARGS, nullptr},
    {"tabIcon", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_tabIcon), METH_NOARGS, nullptr},
    {"tabIndex", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_tabIndex), METH_NOARGS, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_title), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"toggleMuted", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_toggleMuted), METH_NOARGS, nullptr},
    {"togglePinned", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_togglePinned), METH_NOARGS, nullptr},
    {"toggleWebInspector", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_toggleWebInspector), METH_NOARGS, nullptr},
    {"unload", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_unload), METH_NOARGS, nullptr},
    {"url", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_url), METH_NOARGS, nullptr},
    {"webView", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_webView), METH_NOARGS, nullptr},
    {"zoomLevel", reinterpret_cast<PyCFunction>(Sbk_WebTabFunc_zoomLevel), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_WebTab_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::WebTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<WebTabWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_WebTab_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_WebTab_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_WebTabSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::WebTab *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_WebTab_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_WebTab_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebTab_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebTab_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebTab_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebTab_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_WebTab_spec = {
    "1:PyFalkon.WebTab",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_WebTab_slots
};

} //extern "C"

static void *Sbk_WebTab_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::WebTab *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::WebTab *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::WebTab *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_WebTab_AddChildBehavior(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::WebTab::AddChildBehavior>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::WebTab::AddChildBehavior *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_WebTab_AddChildBehavior_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_AddChildBehavior_IDX])))
        return Enum_PythonToCpp_WebTab_AddChildBehavior;
    return {};
}

static PyObject *WebTab_AddChildBehavior_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::WebTab::AddChildBehavior>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::WebTab::AddChildBehavior *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebTab_PythonToCpp_WebTab_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebTab_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebTab_PythonToCpp_WebTab_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_WebTab_TypeF()))
        return WebTab_PythonToCpp_WebTab_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebTab_PTR_CppToPython_WebTab(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::WebTab *>(const_cast<void *>(cppIn)), Sbk_WebTab_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *WebTab_SignatureStrings[] = {
    "PyFalkon.WebTab(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.WebTab.addChildBehavior()->PyFalkon.WebTab.AddChildBehavior",
    "PyFalkon.WebTab.addChildTab(self,tab:PyFalkon.WebTab,index:int=-1)",
    "PyFalkon.WebTab.attach(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.WebTab.backgroundActivity(self)->bool",
    "PyFalkon.WebTab.browserWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.WebTab.childTabs(self)->QList[PyFalkon.WebTab]",
    "PyFalkon.WebTab.closeTab(self)",
    "PyFalkon.WebTab.haveInspector(self)->bool",
    "PyFalkon.WebTab.history(self)->PySide6.QtWebEngineCore.QWebEngineHistory",
    "PyFalkon.WebTab.historyData(self)->PySide6.QtCore.QByteArray",
    "PyFalkon.WebTab.icon(self,allowNull:bool=false)->PySide6.QtGui.QIcon",
    "PyFalkon.WebTab.isCurrentTab(self)->bool",
    "PyFalkon.WebTab.isLoading(self)->bool",
    "PyFalkon.WebTab.isMuted(self)->bool",
    "PyFalkon.WebTab.isPinned(self)->bool",
    "PyFalkon.WebTab.isPlaying(self)->bool",
    "PyFalkon.WebTab.isRestored(self)->bool",
    "PyFalkon.WebTab.load(self,request:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl])",
    "PyFalkon.WebTab.locationBar(self)->PyFalkon.LocationBar",
    "PyFalkon.WebTab.makeCurrentTab(self)",
    "PyFalkon.WebTab.moveTab(self,to:int)",
    "PyFalkon.WebTab.p_restoreTab(self,url:typing.Union[PySide6.QtCore.QUrl, QString],history:typing.Union[PySide6.QtCore.QByteArray, char*],zoomLevel:int)",
    "PyFalkon.WebTab.parentTab(self)->PyFalkon.WebTab",
    "PyFalkon.WebTab.reload(self)",
    "PyFalkon.WebTab.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "PyFalkon.WebTab.sessionData(self)->QHash[QString, QVariant]",
    "PyFalkon.WebTab.setAddChildBehavior(behavior:PyFalkon.WebTab.AddChildBehavior)",
    "PyFalkon.WebTab.setMuted(self,muted:bool)",
    "PyFalkon.WebTab.setParentTab(self,tab:PyFalkon.WebTab)",
    "PyFalkon.WebTab.setPinned(self,state:bool)",
    "PyFalkon.WebTab.setSessionData(self,key:QString,value:QVariant)",
    "PyFalkon.WebTab.setZoomLevel(self,level:int)",
    "PyFalkon.WebTab.showSearchToolBar(self,searchText:QString=QString())",
    "PyFalkon.WebTab.showWebInspector(self,inspectElement:bool=false)",
    "PyFalkon.WebTab.stop(self)",
    "PyFalkon.WebTab.tabActivated(self)",
    "PyFalkon.WebTab.tabIcon(self)->PyFalkon.TabIcon",
    "PyFalkon.WebTab.tabIndex(self)->int",
    "PyFalkon.WebTab.title(self,allowEmpty:bool=false)->QString",
    "PyFalkon.WebTab.toggleMuted(self)",
    "PyFalkon.WebTab.togglePinned(self)",
    "PyFalkon.WebTab.toggleWebInspector(self)",
    "PyFalkon.WebTab.unload(self)",
    "PyFalkon.WebTab.url(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebTab.webView(self)->PyFalkon.TabbedWebView",
    "PyFalkon.WebTab.zoomLevel(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t WebTab_SignatureByteSize = 692;
static constexpr uint8_t WebTab_SignatureBytes[692] = {
    0x78, 0xda, 0x85, 0x55, 0xcb, 0x6e, 0xdb, 0x30, 0x10, 0xbc, 0xf7, 0x2b, 0x72, 0xb4, 0x0b, 0xc5,
    0x40, 0x2f, 0x3d, 0x08, 0x70, 0x81, 0x38, 0x75, 0x9b, 0x00, 0x6e, 0x61, 0xc7, 0x49, 0x0c, 0x34,
    0x30, 0x0a, 0x4a, 0xda, 0x58, 0x84, 0x69, 0x52, 0x25, 0x57, 0x52, 0x94, 0xaf, 0x2f, 0x65, 0xea,
    0x4d, 0x2a, 0x3e, 0x89, 0x92, 0x66, 0x86, 0xbb, 0xc3, 0xdd, 0xe5, 0xba, 0xf8, 0x41, 0xd8, 0x51,
    0xf0, 0xd9, 0x0e, 0x82, 0x47, 0x12, 0x4c, 0x14, 0xb0, 0x57, 0x2f, 0x21, 0x12, 0x38, 0xfa, 0xeb,
    0x62, 0x4b, 0x23, 0xf8, 0x3a, 0xdb, 0xe0, 0x8e, 0x46, 0x07, 0x40, 0x35, 0xdb, 0x98, 0xc5, 0x9c,
    0xa7, 0x8c, 0x25, 0x28, 0xa7, 0x9f, 0xd6, 0x7d, 0xfa, 0x8c, 0x44, 0xd1, 0x6d, 0x4c, 0x59, 0xb4,
    0x80, 0x98, 0x64, 0x54, 0xc8, 0xc9, 0xf4, 0xfa, 0xdb, 0x10, 0x73, 0x33, 0xc0, 0x8c, 0x8a, 0x34,
    0xf1, 0x20, 0x09, 0xfc, 0x01, 0xc8, 0xa3, 0x3c, 0x82, 0x37, 0x9f, 0x72, 0x9c, 0x5f, 0x7f, 0x71,
    0xc4, 0x81, 0x48, 0xc2, 0xd8, 0xb0, 0x73, 0x0d, 0x15, 0x79, 0x2b, 0xb0, 0x90, 0x22, 0x57, 0x20,
    0x77, 0xe7, 0xcf, 0x36, 0x35, 0x20, 0xe1, 0xf1, 0x20, 0x45, 0xca, 0xa3, 0x9b, 0x10, 0x69, 0x46,
    0xb1, 0x38, 0xcb, 0xe8, 0x44, 0x02, 0x21, 0x98, 0x0d, 0xef, 0xaa, 0xd5, 0x48, 0xf7, 0x5e, 0x16,
    0x37, 0xac, 0xb2, 0x54, 0x35, 0x6f, 0xb3, 0xa2, 0x0a, 0x5f, 0x06, 0xb0, 0xbd, 0xcd, 0x63, 0x42,
    0x41, 0xed, 0x8e, 0x9d, 0x81, 0xb6, 0x15, 0xee, 0xb9, 0x4a, 0x20, 0x44, 0x7d, 0x02, 0x1f, 0x05,
    0x1f, 0xeb, 0xed, 0x84, 0x2c, 0xda, 0xb0, 0x9b, 0x03, 0x87, 0x60, 0xc9, 0x0f, 0x94, 0xc3, 0xad,
    0x90, 0xa0, 0x8f, 0xbd, 0x7e, 0xbd, 0x33, 0x84, 0x31, 0xa1, 0xef, 0x04, 0x89, 0x2d, 0x66, 0x34,
    0x16, 0x05, 0xc2, 0x8d, 0x94, 0xc4, 0x26, 0xd3, 0x50, 0x70, 0x73, 0x54, 0x84, 0x31, 0x91, 0xff,
    0xd6, 0xc5, 0xe5, 0x97, 0xe1, 0xce, 0x5f, 0x09, 0x53, 0xd0, 0x93, 0xfa, 0x99, 0xd2, 0xd9, 0xe6,
    0x5e, 0xe3, 0x6d, 0x11, 0x75, 0x9b, 0xca, 0xb2, 0x6c, 0x1b, 0x5f, 0x46, 0x72, 0xa6, 0x6a, 0x25,
    0x48, 0x44, 0xf9, 0xe1, 0x02, 0xea, 0x57, 0x8a, 0x10, 0x5d, 0xc0, 0xac, 0x29, 0xe7, 0x97, 0x41,
    0x8c, 0x14, 0x97, 0xb7, 0x7b, 0x80, 0xd2, 0xc1, 0x0b, 0x62, 0x4c, 0x47, 0x6e, 0x9c, 0x92, 0xf0,
    0x2f, 0xd5, 0x0c, 0x1f, 0x8b, 0x44, 0x6b, 0xcf, 0x9e, 0x38, 0x15, 0xbc, 0x2d, 0x9c, 0x32, 0xc3,
    0x07, 0x83, 0xf0, 0xae, 0x86, 0x07, 0xf1, 0x24, 0xd9, 0x7e, 0xea, 0x90, 0x0e, 0x09, 0x6a, 0x91,
    0x05, 0x91, 0x56, 0x15, 0xaf, 0xda, 0x7f, 0x16, 0xef, 0x44, 0x8e, 0x30, 0x74, 0xde, 0x06, 0x89,
    0x0c, 0xda, 0x6e, 0x16, 0x65, 0xdb, 0xda, 0xa0, 0xe4, 0xaf, 0x34, 0x1e, 0x34, 0xc8, 0x54, 0xb2,
    0x61, 0x82, 0x56, 0x2a, 0xde, 0xd5, 0x66, 0x8b, 0x52, 0x43, 0xf6, 0x5e, 0x55, 0x84, 0x1f, 0x53,
    0x9a, 0x32, 0xf4, 0xae, 0xc2, 0x98, 0xc8, 0xcf, 0x7b, 0xef, 0x5d, 0x88, 0xd3, 0x0a, 0x32, 0x60,
    0x23, 0x61, 0x91, 0x41, 0x55, 0x0d, 0x00, 0x16, 0x41, 0x42, 0x73, 0x4c, 0x53, 0xc7, 0x4f, 0x45,
    0xdf, 0x61, 0x99, 0x69, 0x49, 0x93, 0x23, 0x64, 0xfd, 0x51, 0x7b, 0xae, 0xf0, 0x87, 0x16, 0x65,
    0x4b, 0x28, 0x50, 0x4a, 0x67, 0xd6, 0xed, 0xb5, 0xcd, 0x1d, 0x51, 0xf1, 0x4b, 0x65, 0x84, 0x76,
    0xe4, 0x99, 0x48, 0x4a, 0x38, 0xee, 0x1d, 0x5c, 0x1c, 0x8e, 0xdf, 0x49, 0x50, 0x2d, 0xfc, 0x4b,
    0x83, 0xda, 0x15, 0x0a, 0xb6, 0x6d, 0xe2, 0x9d, 0xca, 0xe5, 0xb9, 0x73, 0x9d, 0xc8, 0x75, 0xcf,
    0x48, 0xd7, 0x50, 0x77, 0xd3, 0xda, 0x1e, 0xf3, 0x14, 0x12, 0x84, 0xf1, 0x1d, 0xb6, 0x03, 0x67,
    0xbc, 0x23, 0x14, 0x7e, 0xed, 0x4a, 0x46, 0x58, 0x0a, 0x7e, 0x6d, 0x8d, 0x93, 0xff, 0xa7, 0xae,
    0x04, 0xc3, 0x66, 0xe3, 0x45, 0xa1, 0x62, 0x91, 0x6f, 0x81, 0xc8, 0x30, 0x7e, 0xd4, 0xc1, 0xd4,
    0x3d, 0xe3, 0x29, 0xf3, 0x09, 0xde, 0xb0, 0xde, 0x76, 0x5e, 0x3d, 0x27, 0x53, 0xb7, 0x88, 0x5e,
    0xf6, 0x47, 0xb5, 0xbe, 0xd8, 0xce, 0xaf, 0x4b, 0x06, 0xa7, 0xb2, 0x32, 0x3a, 0x83, 0xd0, 0x16,
    0x40, 0x91, 0x8c, 0xd4, 0x99, 0x76, 0xf7, 0x7c, 0x7d, 0x91, 0x66, 0x88, 0xb9, 0x20, 0xf7, 0xf5,
    0xe4, 0xed, 0x96, 0xf5, 0xa3, 0xf9, 0xee, 0xc4, 0x97, 0x97, 0x6e, 0x4d, 0xd0, 0xc6, 0xd8, 0x18,
    0x8a, 0x0c, 0x3a, 0xb3, 0x7c, 0x79, 0x4a, 0xb0, 0xe8, 0x0f, 0xf3, 0xca, 0x10, 0x9b, 0x2a, 0x0e,
    0x07, 0x06, 0x9d, 0xa9, 0x3b, 0x82, 0xe8, 0xce, 0xdc, 0x11, 0x88, 0x65, 0xaa, 0x0d, 0x4c, 0xf9,
    0x07, 0x4d, 0xaa, 0xe7, 0xce, 0xd8, 0x2d, 0xa6, 0x27, 0x8e, 0x05, 0xcf, 0x21, 0x78, 0xa6, 0x90,
    0xbb, 0x8c, 0x0c, 0x20, 0xda, 0x99, 0xbf, 0x16, 0xeb, 0xbd, 0x57, 0x6c, 0x95, 0x9f, 0xff, 0x01,
    0xe3, 0xa3, 0x71, 0x6a
};
#endif

PyTypeObject *init_WebTab(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_WebTab_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_WebTab_IDX].type;

    Shiboken::AutoDecRef Sbk_WebTab_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_WebTab_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebTab",
        "WebTab*",
        &Sbk_WebTab_spec,
        &Shiboken::callCppDestructor< WebTab >,
        Sbk_WebTab_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_WebTab_Type; // references _Sbk_WebTab_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, WebTab_SignatureStrings);
#else
    InitSignatureBytes(pyType, WebTab_SignatureBytes, WebTab_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_WebTab_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_WebTab_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        WebTab_PythonToCpp_WebTab_PTR,
        is_WebTab_PythonToCpp_WebTab_PTR_Convertible,
        WebTab_PTR_CppToPython_WebTab);

    Shiboken::Conversions::registerConverterName(converter, "WebTab");
    Shiboken::Conversions::registerConverterName(converter, "WebTab*");
    Shiboken::Conversions::registerConverterName(converter, "WebTab&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebTab).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(WebTabWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_WebTab_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_WebTab_TypeF(), &Sbk_WebTabSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_WebTab_TypeF(), &Sbk_WebTab_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_WebTab_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'AddChildBehavior'.
    const char *AddChildBehavior_Initializer[] = {
        "AppendChild",
        "PrependChild",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t AddChildBehavior_InitializerValues[] = {
        uint8_t(WebTab::AddChildBehavior::AppendChild), //  0x00  0
        uint8_t(WebTab::AddChildBehavior::PrependChild) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_WebTab_TypeF(),
        "1:PyFalkon.WebTab.AddChildBehavior",
        AddChildBehavior_Initializer, AddChildBehavior_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_WebTab_AddChildBehavior_IDX].type = EType;
    // Register converter for enum 'WebTab::AddChildBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            WebTab_AddChildBehavior_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_WebTab_AddChildBehavior,
            is_Enum_PythonToCpp_WebTab_AddChildBehavior_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "WebTab::AddChildBehavior");
        Shiboken::Conversions::registerConverterAlias(converter, "AddChildBehavior");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'AddChildBehavior' enum.

    PySide::Signal::registerSignals(pyType, &::WebTab::staticMetaObject);
    WebTabWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::WebTab::staticMetaObject, sizeof(WebTabWrapper));

    return pyType;
}
