/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-logitech-hidpp-rdfu-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_logitech_hidpp_rdfu_report_id_to_string(FuLogitechHidppRdfuReportId val)
{
    if (val == FU_LOGITECH_HIDPP_RDFU_REPORT_ID_SHORT)
        return "short";
    if (val == FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG)
        return "long";
    if (val == FU_LOGITECH_HIDPP_RDFU_REPORT_ID_VERY_LONG)
        return "very-long";
    if (val == FU_LOGITECH_HIDPP_RDFU_REPORT_ID_NOTIFICATION)
        return "notification";
    return NULL;
}


static gchar *
fu_logitech_hidpp_rdfu_func_to_string(FuLogitechHidppRdfuFunc val)
{
    const gchar *data[5] = {0};
    guint idx = 0;
    if (val == FU_LOGITECH_HIDPP_RDFU_FUNC_GET_CAPABILITIES)
        return g_strdup("get-capabilities");
    if (val & FU_LOGITECH_HIDPP_RDFU_FUNC_START_DFU)
        data[idx++] = "start-dfu";
    if (val & FU_LOGITECH_HIDPP_RDFU_FUNC_GET_DFU_STATUS)
        data[idx++] = "get-dfu-status";
    if (val & FU_LOGITECH_HIDPP_RDFU_FUNC_APPLY_DFU)
        data[idx++] = "apply-dfu";
    if (val & FU_LOGITECH_HIDPP_RDFU_FUNC_TRANSFER_DFU_DATA)
        data[idx++] = "transfer-dfu-data";
    return g_strjoinv(",", (gchar **)data);
}

const gchar *
fu_logitech_hidpp_rdfu_response_code_to_string(FuLogitechHidppRdfuResponseCode val)
{
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_NOT_STARTED)
        return "dfu-not-started";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DATA_TRANSFER_READY)
        return "data-transfer-ready";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DATA_TRANSFER_WAIT)
        return "data-transfer-wait";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_TRANSFER_COMPLETE)
        return "dfu-transfer-complete";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_APPLY_PENDING)
        return "dfu-apply-pending";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_TRANSFER_PKT_ACK)
        return "dfu-transfer-pkt-ack";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_ABORT)
        return "dfu-abort";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_INVALID_MAGIC_STRING)
        return "invalid-magic-string";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_INVALID_FW_ENTITY)
        return "invalid-fw-entity";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DEVICE_BUSY)
        return "device-busy";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DEVICE_OPERATION_FAILURE)
        return "device-operation-failure";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_NOT_SUPPORTED)
        return "not-supported";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_STATE_ERROR)
        return "dfu-state-error";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_INVALID_BLOCK)
        return "invalid-block";
    if (val == FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_GENERIC_ERROR)
        return "generic-error";
    return NULL;
}


/**
 * fu_struct_logitech_hidpp_rdfu_response_ref: (skip):
 **/
FuStructLogitechHidppRdfuResponse *
fu_struct_logitech_hidpp_rdfu_response_ref(FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_response_unref(FuStructLogitechHidppRdfuResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuResponse *
fu_struct_logitech_hidpp_rdfu_response_new_internal(void)
{
    FuStructLogitechHidppRdfuResponse *st = g_new0(FuStructLogitechHidppRdfuResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_report_id: (skip):
 **/
static FuLogitechHidppRdfuReportId
fu_struct_logitech_hidpp_rdfu_response_get_report_id(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_device_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_response_get_device_id(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_sub_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_response_get_sub_id(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_function_id: (skip):
 **/
FuLogitechHidppRdfuFunc
fu_struct_logitech_hidpp_rdfu_response_get_function_id(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_fw_entity: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_response_get_fw_entity(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_status_code: (skip):
 **/
FuLogitechHidppRdfuResponseCode
fu_struct_logitech_hidpp_rdfu_response_get_status_code(const FuStructLogitechHidppRdfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_logitech_hidpp_rdfu_response_get_parameters: (skip):
 **/
const guint8 *
fu_struct_logitech_hidpp_rdfu_response_get_parameters(const FuStructLogitechHidppRdfuResponse *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 14;
    return st->buf->data + 6;
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_response_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_response_to_string(const FuStructLogitechHidppRdfuResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_response_get_device_id(st));
    g_string_append_printf(str, "  sub_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_response_get_sub_id(st));
    {
        const gchar *tmp = fu_logitech_hidpp_rdfu_func_to_string(fu_struct_logitech_hidpp_rdfu_response_get_function_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  function_id: 0x%x [%s]\n", (guint) fu_struct_logitech_hidpp_rdfu_response_get_function_id(st), tmp);
        } else {
            g_string_append_printf(str, "  function_id: 0x%x\n", (guint) fu_struct_logitech_hidpp_rdfu_response_get_function_id(st));
        }
    }
    g_string_append_printf(str, "  fw_entity: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_response_get_fw_entity(st));
    {
        const gchar *tmp = fu_logitech_hidpp_rdfu_response_code_to_string(fu_struct_logitech_hidpp_rdfu_response_get_status_code(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status_code: 0x%x [%s]\n", (guint) fu_struct_logitech_hidpp_rdfu_response_get_status_code(st), tmp);
        } else {
            g_string_append_printf(str, "  status_code: 0x%x\n", (guint) fu_struct_logitech_hidpp_rdfu_response_get_status_code(st));
        }
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_logitech_hidpp_rdfu_response_get_parameters(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  parameters: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_response_validate_internal(FuStructLogitechHidppRdfuResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_response_get_report_id(st) != FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuResponse.report_id was not valid, "
                    "expected 'FuLogitechHidppRdfuReportId' and got '%s'",
                    fu_logitech_hidpp_rdfu_report_id_to_string(fu_struct_logitech_hidpp_rdfu_response_get_report_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_response_parse_internal(FuStructLogitechHidppRdfuResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_response_parse: (skip):
 **/
FuStructLogitechHidppRdfuResponse *
fu_struct_logitech_hidpp_rdfu_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuResponse) st = fu_struct_logitech_hidpp_rdfu_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_struct_logitech_hidpp_rdfu_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_ref: (skip):
 **/
FuStructLogitechHidppRdfuGetCapabilities *
fu_struct_logitech_hidpp_rdfu_get_capabilities_ref(FuStructLogitechHidppRdfuGetCapabilities *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_capabilities_unref(FuStructLogitechHidppRdfuGetCapabilities *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuGetCapabilities refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuGetCapabilities *
fu_struct_logitech_hidpp_rdfu_get_capabilities_new_internal(void)
{
    FuStructLogitechHidppRdfuGetCapabilities *st = g_new0(FuStructLogitechHidppRdfuGetCapabilities, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_set_report_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_get_capabilities_set_report_id(FuStructLogitechHidppRdfuGetCapabilities *st, FuLogitechHidppRdfuReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_set_device_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_capabilities_set_device_id(FuStructLogitechHidppRdfuGetCapabilities *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_set_sub_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_capabilities_set_sub_id(FuStructLogitechHidppRdfuGetCapabilities *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_set_function_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_get_capabilities_set_function_id(FuStructLogitechHidppRdfuGetCapabilities *st, FuLogitechHidppRdfuFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_set_data: (skip):
 **/
gboolean
fu_struct_logitech_hidpp_rdfu_get_capabilities_set_data(FuStructLogitechHidppRdfuGetCapabilities *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_capabilities_new: (skip):
 **/
FuStructLogitechHidppRdfuGetCapabilities *
fu_struct_logitech_hidpp_rdfu_get_capabilities_new(void)
{
    FuStructLogitechHidppRdfuGetCapabilities *st = fu_struct_logitech_hidpp_rdfu_get_capabilities_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    fu_struct_logitech_hidpp_rdfu_get_capabilities_set_report_id(st, FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG);
    fu_struct_logitech_hidpp_rdfu_get_capabilities_set_function_id(st, FU_LOGITECH_HIDPP_RDFU_FUNC_GET_CAPABILITIES);
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_ref: (skip):
 **/
FuStructLogitechHidppRdfuCapabilities *
fu_struct_logitech_hidpp_rdfu_capabilities_ref(FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_capabilities_unref(FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuCapabilities refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuCapabilities *
fu_struct_logitech_hidpp_rdfu_capabilities_new_internal(void)
{
    FuStructLogitechHidppRdfuCapabilities *st = g_new0(FuStructLogitechHidppRdfuCapabilities, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_report_id: (skip):
 **/
static FuLogitechHidppRdfuReportId
fu_struct_logitech_hidpp_rdfu_capabilities_get_report_id(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_device_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_capabilities_get_device_id(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_sub_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_capabilities_get_sub_id(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_function_id: (skip):
 **/
static FuLogitechHidppRdfuFunc
fu_struct_logitech_hidpp_rdfu_capabilities_get_function_id(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_capabilities: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_capabilities_get_capabilities(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_get_data: (skip):
 **/
const guint8 *
fu_struct_logitech_hidpp_rdfu_capabilities_get_data(const FuStructLogitechHidppRdfuCapabilities *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 15;
    return st->buf->data + 5;
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_capabilities_to_string(const FuStructLogitechHidppRdfuCapabilities *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuCapabilities:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_capabilities_get_device_id(st));
    g_string_append_printf(str, "  sub_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_capabilities_get_sub_id(st));
    g_string_append_printf(str, "  capabilities: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_capabilities_get_capabilities(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_logitech_hidpp_rdfu_capabilities_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_capabilities_validate_internal(FuStructLogitechHidppRdfuCapabilities *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_capabilities_get_report_id(st) != FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuCapabilities.report_id was not valid, "
                    "expected 'FuLogitechHidppRdfuReportId' and got '%s'",
                    fu_logitech_hidpp_rdfu_report_id_to_string(fu_struct_logitech_hidpp_rdfu_capabilities_get_report_id(st)));
        return FALSE;
    }
    if (fu_struct_logitech_hidpp_rdfu_capabilities_get_function_id(st) != FU_LOGITECH_HIDPP_RDFU_FUNC_GET_CAPABILITIES) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuCapabilities.function_id was not valid, "
                    "expected 'FuLogitechHidppRdfuFunc' and got '%s'",
                    fu_logitech_hidpp_rdfu_func_to_string(fu_struct_logitech_hidpp_rdfu_capabilities_get_function_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_capabilities_parse_internal(FuStructLogitechHidppRdfuCapabilities *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_capabilities_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_capabilities_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_capabilities_parse: (skip):
 **/
FuStructLogitechHidppRdfuCapabilities *
fu_struct_logitech_hidpp_rdfu_capabilities_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuCapabilities) st = fu_struct_logitech_hidpp_rdfu_capabilities_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuCapabilities: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_struct_logitech_hidpp_rdfu_capabilities_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_ref: (skip):
 **/
FuStructLogitechHidppRdfuGetDfuStatus *
fu_struct_logitech_hidpp_rdfu_get_dfu_status_ref(FuStructLogitechHidppRdfuGetDfuStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_unref(FuStructLogitechHidppRdfuGetDfuStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuGetDfuStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuGetDfuStatus *
fu_struct_logitech_hidpp_rdfu_get_dfu_status_new_internal(void)
{
    FuStructLogitechHidppRdfuGetDfuStatus *st = g_new0(FuStructLogitechHidppRdfuGetDfuStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_report_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_report_id(FuStructLogitechHidppRdfuGetDfuStatus *st, FuLogitechHidppRdfuReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_device_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_device_id(FuStructLogitechHidppRdfuGetDfuStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_sub_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_sub_id(FuStructLogitechHidppRdfuGetDfuStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_function_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_function_id(FuStructLogitechHidppRdfuGetDfuStatus *st, FuLogitechHidppRdfuFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_fw_entity: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_fw_entity(FuStructLogitechHidppRdfuGetDfuStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_get_dfu_status_new: (skip):
 **/
FuStructLogitechHidppRdfuGetDfuStatus *
fu_struct_logitech_hidpp_rdfu_get_dfu_status_new(void)
{
    FuStructLogitechHidppRdfuGetDfuStatus *st = fu_struct_logitech_hidpp_rdfu_get_dfu_status_new_internal();
    st->buf = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st->buf, 5, 0x0);
    fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_report_id(st, FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG);
    fu_struct_logitech_hidpp_rdfu_get_dfu_status_set_function_id(st, FU_LOGITECH_HIDPP_RDFU_FUNC_GET_DFU_STATUS);
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_ref: (skip):
 **/
FuStructLogitechHidppRdfuStartDfu *
fu_struct_logitech_hidpp_rdfu_start_dfu_ref(FuStructLogitechHidppRdfuStartDfu *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_start_dfu_unref(FuStructLogitechHidppRdfuStartDfu *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuStartDfu refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuStartDfu *
fu_struct_logitech_hidpp_rdfu_start_dfu_new_internal(void)
{
    FuStructLogitechHidppRdfuStartDfu *st = g_new0(FuStructLogitechHidppRdfuStartDfu, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_report_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_start_dfu_set_report_id(FuStructLogitechHidppRdfuStartDfu *st, FuLogitechHidppRdfuReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_device_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_start_dfu_set_device_id(FuStructLogitechHidppRdfuStartDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_sub_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_start_dfu_set_sub_id(FuStructLogitechHidppRdfuStartDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_function_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_start_dfu_set_function_id(FuStructLogitechHidppRdfuStartDfu *st, FuLogitechHidppRdfuFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_fw_entity: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_start_dfu_set_fw_entity(FuStructLogitechHidppRdfuStartDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_set_magic: (skip):
 **/
gboolean
fu_struct_logitech_hidpp_rdfu_start_dfu_set_magic(FuStructLogitechHidppRdfuStartDfu *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_new: (skip):
 **/
FuStructLogitechHidppRdfuStartDfu *
fu_struct_logitech_hidpp_rdfu_start_dfu_new(void)
{
    FuStructLogitechHidppRdfuStartDfu *st = fu_struct_logitech_hidpp_rdfu_start_dfu_new_internal();
    st->buf = g_byte_array_sized_new(15);
    fu_byte_array_set_size(st->buf, 15, 0x0);
    fu_struct_logitech_hidpp_rdfu_start_dfu_set_report_id(st, FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG);
    fu_struct_logitech_hidpp_rdfu_start_dfu_set_function_id(st, FU_LOGITECH_HIDPP_RDFU_FUNC_START_DFU);
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_ref: (skip):
 **/
FuStructLogitechHidppRdfuStartDfuResponse *
fu_struct_logitech_hidpp_rdfu_start_dfu_response_ref(FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_start_dfu_response_unref(FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuStartDfuResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuStartDfuResponse *
fu_struct_logitech_hidpp_rdfu_start_dfu_response_new_internal(void)
{
    FuStructLogitechHidppRdfuStartDfuResponse *st = g_new0(FuStructLogitechHidppRdfuStartDfuResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_report_id: (skip):
 **/
static FuLogitechHidppRdfuReportId
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_report_id(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_device_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_device_id(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_sub_id: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_sub_id(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_function_id: (skip):
 **/
static FuLogitechHidppRdfuFunc
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_function_id(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_fw_entity: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_fw_entity(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_code: (skip):
 **/
FuLogitechHidppRdfuResponseCode
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_code(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_params: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_params(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_additional_status_params: (skip):
 **/
guint8
fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_additional_status_params(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_start_dfu_response_to_string(const FuStructLogitechHidppRdfuStartDfuResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuStartDfuResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_device_id(st));
    g_string_append_printf(str, "  sub_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_sub_id(st));
    g_string_append_printf(str, "  fw_entity: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_fw_entity(st));
    {
        const gchar *tmp = fu_logitech_hidpp_rdfu_response_code_to_string(fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_code(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status_code: 0x%x [%s]\n", (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_code(st), tmp);
        } else {
            g_string_append_printf(str, "  status_code: 0x%x\n", (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_code(st));
        }
    }
    g_string_append_printf(str, "  status_params: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_status_params(st));
    g_string_append_printf(str, "  additional_status_params: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_additional_status_params(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_start_dfu_response_validate_internal(FuStructLogitechHidppRdfuStartDfuResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_report_id(st) != FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuStartDfuResponse.report_id was not valid, "
                    "expected 'FuLogitechHidppRdfuReportId' and got '%s'",
                    fu_logitech_hidpp_rdfu_report_id_to_string(fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_report_id(st)));
        return FALSE;
    }
    if (fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_function_id(st) != FU_LOGITECH_HIDPP_RDFU_FUNC_START_DFU) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuStartDfuResponse.function_id was not valid, "
                    "expected 'FuLogitechHidppRdfuFunc' and got '%s'",
                    fu_logitech_hidpp_rdfu_func_to_string(fu_struct_logitech_hidpp_rdfu_start_dfu_response_get_function_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_start_dfu_response_parse_internal(FuStructLogitechHidppRdfuStartDfuResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_start_dfu_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_start_dfu_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_start_dfu_response_parse: (skip):
 **/
FuStructLogitechHidppRdfuStartDfuResponse *
fu_struct_logitech_hidpp_rdfu_start_dfu_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuStartDfuResponse) st = fu_struct_logitech_hidpp_rdfu_start_dfu_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuStartDfuResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_logitech_hidpp_rdfu_start_dfu_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_ref: (skip):
 **/
FuStructLogitechHidppRdfuTransferDfuData *
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_ref(FuStructLogitechHidppRdfuTransferDfuData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_unref(FuStructLogitechHidppRdfuTransferDfuData *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuTransferDfuData refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuTransferDfuData *
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_new_internal(void)
{
    FuStructLogitechHidppRdfuTransferDfuData *st = g_new0(FuStructLogitechHidppRdfuTransferDfuData, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_report_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_report_id(FuStructLogitechHidppRdfuTransferDfuData *st, FuLogitechHidppRdfuReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_device_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_device_id(FuStructLogitechHidppRdfuTransferDfuData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_sub_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_sub_id(FuStructLogitechHidppRdfuTransferDfuData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_function_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_function_id(FuStructLogitechHidppRdfuTransferDfuData *st, FuLogitechHidppRdfuFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_data: (skip):
 **/
gboolean
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_data(FuStructLogitechHidppRdfuTransferDfuData *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_new: (skip):
 **/
FuStructLogitechHidppRdfuTransferDfuData *
fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_new(void)
{
    FuStructLogitechHidppRdfuTransferDfuData *st = fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_report_id(st, FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG);
    fu_struct_logitech_hidpp_rdfu_transfer_dfu_data_set_function_id(st, FU_LOGITECH_HIDPP_RDFU_FUNC_TRANSFER_DFU_DATA);
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_ref: (skip):
 **/
FuStructLogitechHidppRdfuDataTransferReady *
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_ref(FuStructLogitechHidppRdfuDataTransferReady *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_unref(FuStructLogitechHidppRdfuDataTransferReady *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuDataTransferReady refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuDataTransferReady *
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_new_internal(void)
{
    FuStructLogitechHidppRdfuDataTransferReady *st = g_new0(FuStructLogitechHidppRdfuDataTransferReady, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_status_code: (skip):
 **/
static FuLogitechHidppRdfuResponseCode
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_status_code(const FuStructLogitechHidppRdfuDataTransferReady *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_block_id: (skip):
 **/
guint16
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_block_id(const FuStructLogitechHidppRdfuDataTransferReady *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_to_string(const FuStructLogitechHidppRdfuDataTransferReady *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuDataTransferReady:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  block_id: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_block_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_validate_internal(FuStructLogitechHidppRdfuDataTransferReady *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_status_code(st) != FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DATA_TRANSFER_READY) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuDataTransferReady.status_code was not valid, "
                    "expected 'FuLogitechHidppRdfuResponseCode' and got '%s'",
                    fu_logitech_hidpp_rdfu_response_code_to_string(fu_struct_logitech_hidpp_rdfu_data_transfer_ready_get_status_code(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_parse_internal(FuStructLogitechHidppRdfuDataTransferReady *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_data_transfer_ready_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_data_transfer_ready_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_ready_parse: (skip):
 **/
FuStructLogitechHidppRdfuDataTransferReady *
fu_struct_logitech_hidpp_rdfu_data_transfer_ready_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuDataTransferReady) st = fu_struct_logitech_hidpp_rdfu_data_transfer_ready_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuDataTransferReady: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_logitech_hidpp_rdfu_data_transfer_ready_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_ref: (skip):
 **/
FuStructLogitechHidppRdfuDataTransferWait *
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_ref(FuStructLogitechHidppRdfuDataTransferWait *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_unref(FuStructLogitechHidppRdfuDataTransferWait *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuDataTransferWait refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuDataTransferWait *
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_new_internal(void)
{
    FuStructLogitechHidppRdfuDataTransferWait *st = g_new0(FuStructLogitechHidppRdfuDataTransferWait, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_status_code: (skip):
 **/
static FuLogitechHidppRdfuResponseCode
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_status_code(const FuStructLogitechHidppRdfuDataTransferWait *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_delay_ms: (skip):
 **/
guint16
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_delay_ms(const FuStructLogitechHidppRdfuDataTransferWait *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_to_string(const FuStructLogitechHidppRdfuDataTransferWait *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuDataTransferWait:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  delay_ms: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_delay_ms(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_validate_internal(FuStructLogitechHidppRdfuDataTransferWait *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_status_code(st) != FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DATA_TRANSFER_WAIT) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuDataTransferWait.status_code was not valid, "
                    "expected 'FuLogitechHidppRdfuResponseCode' and got '%s'",
                    fu_logitech_hidpp_rdfu_response_code_to_string(fu_struct_logitech_hidpp_rdfu_data_transfer_wait_get_status_code(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_parse_internal(FuStructLogitechHidppRdfuDataTransferWait *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_data_transfer_wait_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_data_transfer_wait_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_data_transfer_wait_parse: (skip):
 **/
FuStructLogitechHidppRdfuDataTransferWait *
fu_struct_logitech_hidpp_rdfu_data_transfer_wait_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuDataTransferWait) st = fu_struct_logitech_hidpp_rdfu_data_transfer_wait_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuDataTransferWait: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_logitech_hidpp_rdfu_data_transfer_wait_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_ref: (skip):
 **/
FuStructLogitechHidppRdfuDfuTransferPktAck *
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_ref(FuStructLogitechHidppRdfuDfuTransferPktAck *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_unref(FuStructLogitechHidppRdfuDfuTransferPktAck *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuDfuTransferPktAck refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuDfuTransferPktAck *
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_new_internal(void)
{
    FuStructLogitechHidppRdfuDfuTransferPktAck *st = g_new0(FuStructLogitechHidppRdfuDfuTransferPktAck, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_status_code: (skip):
 **/
static FuLogitechHidppRdfuResponseCode
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_status_code(const FuStructLogitechHidppRdfuDfuTransferPktAck *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_pkt_number: (skip):
 **/
guint32
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_pkt_number(const FuStructLogitechHidppRdfuDfuTransferPktAck *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_to_string: (skip):
 **/
static gchar *
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_to_string(const FuStructLogitechHidppRdfuDfuTransferPktAck *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLogitechHidppRdfuDfuTransferPktAck:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pkt_number: 0x%x\n",
                           (guint) fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_pkt_number(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_validate_internal(FuStructLogitechHidppRdfuDfuTransferPktAck *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_status_code(st) != FU_LOGITECH_HIDPP_RDFU_RESPONSE_CODE_DFU_TRANSFER_PKT_ACK) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLogitechHidppRdfuDfuTransferPktAck.status_code was not valid, "
                    "expected 'FuLogitechHidppRdfuResponseCode' and got '%s'",
                    fu_logitech_hidpp_rdfu_response_code_to_string(fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_get_status_code(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_parse_internal(FuStructLogitechHidppRdfuDfuTransferPktAck *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_parse: (skip):
 **/
FuStructLogitechHidppRdfuDfuTransferPktAck *
fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLogitechHidppRdfuDfuTransferPktAck) st = fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 5, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLogitechHidppRdfuDfuTransferPktAck: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 5);
    if (!fu_struct_logitech_hidpp_rdfu_dfu_transfer_pkt_ack_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_ref: (skip):
 **/
FuStructLogitechHidppRdfuApplyDfu *
fu_struct_logitech_hidpp_rdfu_apply_dfu_ref(FuStructLogitechHidppRdfuApplyDfu *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_unref: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_apply_dfu_unref(FuStructLogitechHidppRdfuApplyDfu *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLogitechHidppRdfuApplyDfu refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLogitechHidppRdfuApplyDfu *
fu_struct_logitech_hidpp_rdfu_apply_dfu_new_internal(void)
{
    FuStructLogitechHidppRdfuApplyDfu *st = g_new0(FuStructLogitechHidppRdfuApplyDfu, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_report_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_report_id(FuStructLogitechHidppRdfuApplyDfu *st, FuLogitechHidppRdfuReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_device_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_device_id(FuStructLogitechHidppRdfuApplyDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_sub_id: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_sub_id(FuStructLogitechHidppRdfuApplyDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_function_id: (skip):
 **/
static void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_function_id(FuStructLogitechHidppRdfuApplyDfu *st, FuLogitechHidppRdfuFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_fw_entity: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_fw_entity(FuStructLogitechHidppRdfuApplyDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_set_flags: (skip):
 **/
void
fu_struct_logitech_hidpp_rdfu_apply_dfu_set_flags(FuStructLogitechHidppRdfuApplyDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_logitech_hidpp_rdfu_apply_dfu_new: (skip):
 **/
FuStructLogitechHidppRdfuApplyDfu *
fu_struct_logitech_hidpp_rdfu_apply_dfu_new(void)
{
    FuStructLogitechHidppRdfuApplyDfu *st = fu_struct_logitech_hidpp_rdfu_apply_dfu_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    fu_struct_logitech_hidpp_rdfu_apply_dfu_set_report_id(st, FU_LOGITECH_HIDPP_RDFU_REPORT_ID_LONG);
    fu_struct_logitech_hidpp_rdfu_apply_dfu_set_function_id(st, FU_LOGITECH_HIDPP_RDFU_FUNC_APPLY_DFU);
    return st;
}
