/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-wistron-dock-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_wistron_dock_status_code_to_string:
 * @val: value, e.g. %FU_WISTRON_DOCK_STATUS_CODE_PREPARE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wistron_dock_status_code_to_string(FuWistronDockStatusCode val)
{
    if (val == FU_WISTRON_DOCK_STATUS_CODE_ENTER)
        return "enter";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_PREPARE)
        return "prepare";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_UPDATING)
        return "updating";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_COMPLETE)
        return "complete";
    return NULL;
}

/**
 * fu_wistron_dock_component_idx_to_string:
 * @val: value, e.g. %FU_WISTRON_DOCK_COMPONENT_IDX_PD
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wistron_dock_component_idx_to_string(FuWistronDockComponentIdx val)
{
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_MCU)
        return "mcu";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_PD)
        return "pd";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_AUDIO)
        return "audio";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_USB)
        return "usb";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_MST)
        return "mst";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_SPI)
        return "spi";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_DOCK)
        return "dock";
    return NULL;
}

/**
 * fu_wistron_dock_update_phase_to_string:
 * @val: value, e.g. %FU_WISTRON_DOCK_UPDATE_PHASE_DEPLOY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wistron_dock_update_phase_to_string(FuWistronDockUpdatePhase val)
{
    if (val == FU_WISTRON_DOCK_UPDATE_PHASE_DOWNLOAD)
        return "download";
    if (val == FU_WISTRON_DOCK_UPDATE_PHASE_DEPLOY)
        return "deploy";
    return NULL;
}


/**
 * fu_struct_wistron_dock_wdit_ref: (skip):
 **/
FuStructWistronDockWdit *
fu_struct_wistron_dock_wdit_ref(FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wistron_dock_wdit_unref: (skip):
 **/
void
fu_struct_wistron_dock_wdit_unref(FuStructWistronDockWdit *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWistronDockWdit refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wistron_dock_wdit_new_internal: (skip):
 **/
static FuStructWistronDockWdit *
fu_struct_wistron_dock_wdit_new_internal(void)
{
    FuStructWistronDockWdit *st = g_new0(FuStructWistronDockWdit, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wistron_dock_wdit_get_hid_id: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_hid_id(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wistron_dock_wdit_get_tag_id: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_tag_id(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_vid: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_vid(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_pid: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_pid(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_imgmode: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_imgmode(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_wistron_dock_wdit_get_update_state: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_update_state(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_wistron_dock_wdit_get_status_code: (skip):
 **/
FuWistronDockStatusCode
fu_struct_wistron_dock_wdit_get_status_code(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_wistron_dock_wdit_get_composite_version: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_get_composite_version(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 10, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_device_cnt: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_device_cnt(const FuStructWistronDockWdit *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}

/* setters */
/**
 * fu_struct_wistron_dock_wdit_to_string: (skip):
 **/
static gchar *
fu_struct_wistron_dock_wdit_to_string(const FuStructWistronDockWdit *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWistronDockWdit:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  hid_id: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_hid_id(st));
    g_string_append_printf(str, "  tag_id: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_tag_id(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_pid(st));
    g_string_append_printf(str, "  imgmode: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_imgmode(st));
    g_string_append_printf(str, "  update_state: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_update_state(st));
    {
        const gchar *tmp = fu_wistron_dock_status_code_to_string(fu_struct_wistron_dock_wdit_get_status_code(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status_code: 0x%x [%s]\n", (guint) fu_struct_wistron_dock_wdit_get_status_code(st), tmp);
        } else {
            g_string_append_printf(str, "  status_code: 0x%x\n", (guint) fu_struct_wistron_dock_wdit_get_status_code(st));
        }
    }
    g_string_append_printf(str, "  composite_version: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_composite_version(st));
    g_string_append_printf(str, "  device_cnt: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_device_cnt(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wistron_dock_wdit_validate_internal(FuStructWistronDockWdit *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wistron_dock_wdit_parse_internal(FuStructWistronDockWdit *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wistron_dock_wdit_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wistron_dock_wdit_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wistron_dock_wdit_parse: (skip):
 **/
FuStructWistronDockWdit *
fu_struct_wistron_dock_wdit_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWistronDockWdit) st = fu_struct_wistron_dock_wdit_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWistronDockWdit: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 16);
    if (!fu_struct_wistron_dock_wdit_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_wistron_dock_wdit_img_ref: (skip):
 **/
FuStructWistronDockWditImg *
fu_struct_wistron_dock_wdit_img_ref(FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wistron_dock_wdit_img_unref: (skip):
 **/
void
fu_struct_wistron_dock_wdit_img_unref(FuStructWistronDockWditImg *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWistronDockWditImg refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wistron_dock_wdit_img_new_internal: (skip):
 **/
static FuStructWistronDockWditImg *
fu_struct_wistron_dock_wdit_img_new_internal(void)
{
    FuStructWistronDockWditImg *st = g_new0(FuStructWistronDockWditImg, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wistron_dock_wdit_img_get_comp_id: (skip):
 **/
FuWistronDockComponentIdx
fu_struct_wistron_dock_wdit_img_get_comp_id(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_mode: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_img_get_mode(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_status: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_img_get_status(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version_build: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version_build(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version1: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version1(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version2: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version2(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_name: (skip):
 **/
gchar *
fu_struct_wistron_dock_wdit_img_get_name(const FuStructWistronDockWditImg *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 32, NULL);
}

/* setters */
/**
 * fu_struct_wistron_dock_wdit_img_to_string: (skip):
 **/
static gchar *
fu_struct_wistron_dock_wdit_img_to_string(const FuStructWistronDockWditImg *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWistronDockWditImg:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wistron_dock_component_idx_to_string(fu_struct_wistron_dock_wdit_img_get_comp_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  comp_id: 0x%x [%s]\n", (guint) fu_struct_wistron_dock_wdit_img_get_comp_id(st), tmp);
        } else {
            g_string_append_printf(str, "  comp_id: 0x%x\n", (guint) fu_struct_wistron_dock_wdit_img_get_comp_id(st));
        }
    }
    g_string_append_printf(str, "  mode: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_mode(st));
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_status(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version_build(st));
    g_string_append_printf(str, "  version1: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version1(st));
    g_string_append_printf(str, "  version2: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version2(st));
    {
        g_autofree gchar *tmp = fu_struct_wistron_dock_wdit_img_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wistron_dock_wdit_img_validate_internal(FuStructWistronDockWditImg *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wistron_dock_wdit_img_parse_internal(FuStructWistronDockWditImg *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wistron_dock_wdit_img_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wistron_dock_wdit_img_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wistron_dock_wdit_img_parse: (skip):
 **/
FuStructWistronDockWditImg *
fu_struct_wistron_dock_wdit_img_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWistronDockWditImg) st = fu_struct_wistron_dock_wdit_img_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWistronDockWditImg: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 48);
    if (!fu_struct_wistron_dock_wdit_img_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
