/* imap-response-code-type.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-response-code-type.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_RESPONSE_CODE_TYPE_0_PROPERTY,
	GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY,
	GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY,
	GEARY_IMAP_RESPONSE_CODE_TYPE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_response_code_type_properties[GEARY_IMAP_RESPONSE_CODE_TYPE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyImapResponseCodeTypePrivate {
	gchar* _original;
	gchar* _value;
};

static gint GearyImapResponseCodeType_private_offset;
static gpointer geary_imap_response_code_type_parent_class = NULL;
static GeeHashableIface * geary_imap_response_code_type_gee_hashable_parent_iface = NULL;

static void geary_imap_response_code_type_set_original (GearyImapResponseCodeType* self,
                                                 const gchar* value);
static void geary_imap_response_code_type_set_value (GearyImapResponseCodeType* self,
                                              const gchar* value);
static void geary_imap_response_code_type_init (GearyImapResponseCodeType* self,
                                         const gchar* ascii,
                                         GError** error);
static gboolean geary_imap_response_code_type_real_equal_to (GeeHashable* base,
                                                      GearyImapResponseCodeType* other);
static guint geary_imap_response_code_type_real_hash (GeeHashable* base);
static void geary_imap_response_code_type_finalize (GObject * obj);
static GType geary_imap_response_code_type_get_type_once (void);
static void _vala_geary_imap_response_code_type_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_geary_imap_response_code_type_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
geary_imap_response_code_type_get_instance_private (GearyImapResponseCodeType* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapResponseCodeType_private_offset);
}

const gchar*
geary_imap_response_code_type_get_original (GearyImapResponseCodeType* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self), NULL);
	_tmp0_ = self->priv->_original;
	result = _tmp0_;
	return result;
}

static void
geary_imap_response_code_type_set_original (GearyImapResponseCodeType* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self));
	old_value = geary_imap_response_code_type_get_original (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_original);
		self->priv->_original = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_response_code_type_properties[GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY]);
	}
}

const gchar*
geary_imap_response_code_type_get_value (GearyImapResponseCodeType* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
geary_imap_response_code_type_set_value (GearyImapResponseCodeType* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self));
	old_value = geary_imap_response_code_type_get_value (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_response_code_type_properties[GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY]);
	}
}

/**
     * Throws an {@link ImapError.INVALID} if the string cannot be represented as an
     * {link ResponseCodeType}.
     */
GearyImapResponseCodeType*
geary_imap_response_code_type_construct (GType object_type,
                                         const gchar* value,
                                         GError** error)
{
	GearyImapResponseCodeType * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyImapResponseCodeType*) geary_base_object_construct (object_type);
	geary_imap_response_code_type_init (self, value, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

GearyImapResponseCodeType*
geary_imap_response_code_type_new (const gchar* value,
                                   GError** error)
{
	return geary_imap_response_code_type_construct (GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, value, error);
}

/**
     * Throws an {@link ImapError.INVALID} if the {@link StringParameter} cannot be represented as
     * an {link ResponseCodeType}.
     */
GearyImapResponseCodeType*
geary_imap_response_code_type_construct_from_parameter (GType object_type,
                                                        GearyImapStringParameter* stringp,
                                                        GError** error)
{
	GearyImapResponseCodeType * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), NULL);
	self = (GearyImapResponseCodeType*) geary_base_object_construct (object_type);
	_tmp0_ = geary_imap_string_parameter_get_ascii (stringp);
	_tmp1_ = _tmp0_;
	geary_imap_response_code_type_init (self, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

GearyImapResponseCodeType*
geary_imap_response_code_type_new_from_parameter (GearyImapStringParameter* stringp,
                                                  GError** error)
{
	return geary_imap_response_code_type_construct_from_parameter (GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, stringp, error);
}

static void
geary_imap_response_code_type_init (GearyImapResponseCodeType* self,
                                    const gchar* ascii,
                                    GError** error)
{
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self));
	g_return_if_fail (ascii != NULL);
	if (geary_imap_data_format_is_quoting_required (ascii) != GEARY_IMAP_DATA_FORMAT_QUOTING_OPTIONAL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "\"%s\" cannot be represented as a ResponseCodeType", ascii);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	geary_imap_response_code_type_set_original (self, ascii);
	_tmp1_ = geary_ascii_strdown (ascii);
	_tmp2_ = _tmp1_;
	geary_imap_response_code_type_set_value (self, _tmp2_);
	_g_free0 (_tmp2_);
}

gboolean
geary_imap_response_code_type_is_value (GearyImapResponseCodeType* self,
                                        const gchar* str)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self), FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = self->priv->_value;
	result = geary_ascii_stri_equal (_tmp0_, str);
	return result;
}

GearyImapStringParameter*
geary_imap_response_code_type_to_parameter (GearyImapResponseCodeType* self)
{
	const gchar* _tmp0_;
	GearyImapAtomParameter* _tmp1_;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self), NULL);
	_tmp0_ = self->priv->_original;
	_tmp1_ = geary_imap_atom_parameter_new (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	return result;
}

static gboolean
geary_imap_response_code_type_real_equal_to (GeeHashable* base,
                                             GearyImapResponseCodeType* other)
{
	GearyImapResponseCodeType * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, GearyImapResponseCodeType);
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (other), FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_value;
		_tmp2_ = other->priv->_value;
		_tmp0_ = geary_ascii_stri_equal (_tmp1_, _tmp2_);
	}
	result = _tmp0_;
	return result;
}

static guint
geary_imap_response_code_type_real_hash (GeeHashable* base)
{
	GearyImapResponseCodeType * self;
	const gchar* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, GearyImapResponseCodeType);
	_tmp0_ = self->priv->_value;
	result = geary_ascii_stri_hash (_tmp0_);
	return result;
}

gchar*
geary_imap_response_code_type_to_string (GearyImapResponseCodeType* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE_TYPE (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_imap_response_code_type_class_init (GearyImapResponseCodeTypeClass * klass,
                                          gpointer klass_data)
{
	geary_imap_response_code_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapResponseCodeType_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_response_code_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_response_code_type_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_response_code_type_finalize;
	/**
	     * The original response code value submitted to the object (possibly off-the-wire).
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY, geary_imap_response_code_type_properties[GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY] = g_param_spec_string ("original", "original", "original", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The response code value set to lowercase, making it easy to compare to constant strings
	     * in a uniform way.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY, geary_imap_response_code_type_properties[GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY] = g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_response_code_type_gee_hashable_interface_init (GeeHashableIface * iface,
                                                           gpointer iface_data)
{
	geary_imap_response_code_type_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_response_code_type_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_response_code_type_real_hash;
}

static void
geary_imap_response_code_type_instance_init (GearyImapResponseCodeType * self,
                                             gpointer klass)
{
	self->priv = geary_imap_response_code_type_get_instance_private (self);
}

static void
geary_imap_response_code_type_finalize (GObject * obj)
{
	GearyImapResponseCodeType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, GearyImapResponseCodeType);
	_g_free0 (self->priv->_original);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (geary_imap_response_code_type_parent_class)->finalize (obj);
}

/**
 * An optional response code accompanying a {@link ServerResponse}.
 *
 * See
 * [[http://tools.ietf.org/html/rfc3501#section-7.1]],
 * [[http://tools.ietf.org/html/rfc5530]], and
 * [[http://tools.ietf.org/html/rfc4315]]
 * for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_response_code_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapResponseCodeTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_response_code_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapResponseCodeType), 0, (GInstanceInitFunc) geary_imap_response_code_type_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_response_code_type_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_response_code_type_type_id;
	geary_imap_response_code_type_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapResponseCodeType", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_response_code_type_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyImapResponseCodeType_private_offset = g_type_add_instance_private (geary_imap_response_code_type_type_id, sizeof (GearyImapResponseCodeTypePrivate));
	return geary_imap_response_code_type_type_id;
}

GType
geary_imap_response_code_type_get_type (void)
{
	static gsize geary_imap_response_code_type_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_response_code_type_type_id__once)) {
		GType geary_imap_response_code_type_type_id;
		geary_imap_response_code_type_type_id = geary_imap_response_code_type_get_type_once ();
		g_once_init_leave (&geary_imap_response_code_type_type_id__once, geary_imap_response_code_type_type_id);
	}
	return geary_imap_response_code_type_type_id__once;
}

static void
_vala_geary_imap_response_code_type_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapResponseCodeType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, GearyImapResponseCodeType);
	switch (property_id) {
		case GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY:
		g_value_set_string (value, geary_imap_response_code_type_get_original (self));
		break;
		case GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY:
		g_value_set_string (value, geary_imap_response_code_type_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_response_code_type_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapResponseCodeType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_RESPONSE_CODE_TYPE, GearyImapResponseCodeType);
	switch (property_id) {
		case GEARY_IMAP_RESPONSE_CODE_TYPE_ORIGINAL_PROPERTY:
		geary_imap_response_code_type_set_original (self, g_value_get_string (value));
		break;
		case GEARY_IMAP_RESPONSE_CODE_TYPE_VALUE_PROPERTY:
		geary_imap_response_code_type_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

