/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input ../../src/cmdline.ggo --output-dir=../../src --no-handle-version --no-handle-help 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "This program, given a skeleton source file with some\nparts to be replaced, generates a program that generates that source,\nand substitutes those parts as specified.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                Print help and exit",
  "  -V, --version             Print version and exit",
  "  -i, --input=file          input file (default std input)",
  "  -F, --file-name=name      name used for generating file (default stdout)",
  "  -f, --gen-name=STRING     prefix for generated code  (default=`gengen')",
  "      --output-format=lang  target language (cpp, c, lua)  (default=`cpp')",
  "      --output-dir=STRING   output directory (default current dir)",
  "      --separate-files      output to separate files (header, source). require \n                              --file-name",
  "      --expand-tabs         strings containing newlines are indented according \n                              to the current indentation level",
  "      --no-gen-version      do not put gengen version in the generated file",
  "      --test-mode           even with errors exit with 0 (this is only for \n                              testing purposes)",
  "      --force               force regeneration of output code",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->file_name_given = 0 ;
  args_info->gen_name_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->output_dir_given = 0 ;
  args_info->separate_files_given = 0 ;
  args_info->expand_tabs_given = 0 ;
  args_info->no_gen_version_given = 0 ;
  args_info->test_mode_given = 0 ;
  args_info->force_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->file_name_arg = NULL;
  args_info->file_name_orig = NULL;
  args_info->gen_name_arg = gengetopt_strdup ("gengen");
  args_info->gen_name_orig = NULL;
  args_info->output_format_arg = gengetopt_strdup ("cpp");
  args_info->output_format_orig = NULL;
  args_info->output_dir_arg = NULL;
  args_info->output_dir_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->input_help = gengetopt_args_info_help[2] ;
  args_info->file_name_help = gengetopt_args_info_help[3] ;
  args_info->gen_name_help = gengetopt_args_info_help[4] ;
  args_info->output_format_help = gengetopt_args_info_help[5] ;
  args_info->output_dir_help = gengetopt_args_info_help[6] ;
  args_info->separate_files_help = gengetopt_args_info_help[7] ;
  args_info->expand_tabs_help = gengetopt_args_info_help[8] ;
  args_info->no_gen_version_help = gengetopt_args_info_help[9] ;
  args_info->test_mode_help = gengetopt_args_info_help[10] ;
  args_info->force_help = gengetopt_args_info_help[11] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->file_name_arg));
  free_string_field (&(args_info->file_name_orig));
  free_string_field (&(args_info->gen_name_arg));
  free_string_field (&(args_info->gen_name_orig));
  free_string_field (&(args_info->output_format_arg));
  free_string_field (&(args_info->output_format_orig));
  free_string_field (&(args_info->output_dir_arg));
  free_string_field (&(args_info->output_dir_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->file_name_given)
    write_into_file(outfile, "file-name", args_info->file_name_orig, 0);
  if (args_info->gen_name_given)
    write_into_file(outfile, "gen-name", args_info->gen_name_orig, 0);
  if (args_info->output_format_given)
    write_into_file(outfile, "output-format", args_info->output_format_orig, 0);
  if (args_info->output_dir_given)
    write_into_file(outfile, "output-dir", args_info->output_dir_orig, 0);
  if (args_info->separate_files_given)
    write_into_file(outfile, "separate-files", 0, 0 );
  if (args_info->expand_tabs_given)
    write_into_file(outfile, "expand-tabs", 0, 0 );
  if (args_info->no_gen_version_given)
    write_into_file(outfile, "no-gen-version", 0, 0 );
  if (args_info->test_mode_given)
    write_into_file(outfile, "test-mode", 0, 0 );
  if (args_info->force_given)
    write_into_file(outfile, "force", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "file-name",	1, NULL, 'F' },
        { "gen-name",	1, NULL, 'f' },
        { "output-format",	1, NULL, 0 },
        { "output-dir",	1, NULL, 0 },
        { "separate-files",	0, NULL, 0 },
        { "expand-tabs",	0, NULL, 0 },
        { "no-gen-version",	0, NULL, 0 },
        { "test-mode",	0, NULL, 0 },
        { "force",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVi:F:f:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'i':	/* input file (default std input).  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* name used for generating file (default stdout).  */
        
        
          if (update_arg( (void *)&(args_info->file_name_arg), 
               &(args_info->file_name_orig), &(args_info->file_name_given),
              &(local_args_info.file_name_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "file-name", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* prefix for generated code.  */
        
        
          if (update_arg( (void *)&(args_info->gen_name_arg), 
               &(args_info->gen_name_orig), &(args_info->gen_name_given),
              &(local_args_info.gen_name_given), optarg, 0, "gengen", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "gen-name", 'f',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* target language (cpp, c).  */
          if (strcmp (long_options[option_index].name, "output-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_format_arg), 
                 &(args_info->output_format_orig), &(args_info->output_format_given),
                &(local_args_info.output_format_given), optarg, 0, "cpp", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-format", '-',
                additional_error))
              goto failure;
          
          }
          /* output directory (default current dir).  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_dir_arg), 
                 &(args_info->output_dir_orig), &(args_info->output_dir_given),
                &(local_args_info.output_dir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* output to separate files (header, source). require --file-name.  */
          else if (strcmp (long_options[option_index].name, "separate-files") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->separate_files_given),
                &(local_args_info.separate_files_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "separate-files", '-',
                additional_error))
              goto failure;
          
          }
          /* strings containing newlines are indented according to the current indentation level.  */
          else if (strcmp (long_options[option_index].name, "expand-tabs") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->expand_tabs_given),
                &(local_args_info.expand_tabs_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "expand-tabs", '-',
                additional_error))
              goto failure;
          
          }
          /* do not put gengen version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "no-gen-version") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_gen_version_given),
                &(local_args_info.no_gen_version_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-gen-version", '-',
                additional_error))
              goto failure;
          
          }
          /* even with errors exit with 0 (this is only for testing purposes).  */
          else if (strcmp (long_options[option_index].name, "test-mode") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->test_mode_given),
                &(local_args_info.test_mode_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "test-mode", '-',
                additional_error))
              goto failure;
          
          }
          /* force regeneration of output code.  */
          else if (strcmp (long_options[option_index].name, "force") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->force_given),
                &(local_args_info.force_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "force", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
