/* chess-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from chess-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2024 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define HISTORY_GO_FIRST_ACTION_NAME "go-first"
#define HISTORY_GO_PREVIOUS_ACTION_NAME "go-previous"
#define HISTORY_GO_NEXT_ACTION_NAME "go-next"
#define HISTORY_GO_LAST_ACTION_NAME "go-last"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHESS_WINDOW (chess_window_get_type ())
#define CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_WINDOW, ChessWindow))
#define CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_WINDOW, ChessWindowClass))
#define IS_CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_WINDOW))
#define IS_CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_WINDOW))
#define CHESS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_WINDOW, ChessWindowClass))

typedef struct _ChessWindow ChessWindow;
typedef struct _ChessWindowClass ChessWindowClass;
typedef struct _ChessWindowPrivate ChessWindowPrivate;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
enum  {
	CHESS_WINDOW_0_PROPERTY,
	CHESS_WINDOW_VIEW_PROPERTY,
	CHESS_WINDOW_SCENE_PROPERTY,
	CHESS_WINDOW_GAME_PROPERTY,
	CHESS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* chess_window_properties[CHESS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessWindow {
	AdwApplicationWindow parent_instance;
	ChessWindowPrivate * priv;
};

struct _ChessWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ChessWindowPrivate {
	ChessView* _view;
	ChessApplication* app;
	AdwToastOverlay* toast_overlay;
	GtkButton* pause_resume_button;
	GtkDropDown* history_dropdown;
	GtkStringList* history_model;
	GtkBox* clock_box;
	GtkDrawingArea* white_time_label;
	GtkDrawingArea* black_time_label;
};

struct _Block2Data {
	int _ref_count_;
	ChessWindow* self;
	GtkWidget* widget;
	cairo_t* c;
};

static gint ChessWindow_private_offset;
static gpointer chess_window_parent_class = NULL;

VALA_EXTERN GType chess_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessWindow, g_object_unref)
VALA_EXTERN GType chess_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessView, g_object_unref)
VALA_EXTERN GType chess_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessApplication, g_object_unref)
VALA_EXTERN ChessWindow* chess_window_new (ChessApplication* app);
VALA_EXTERN ChessWindow* chess_window_construct (GType object_type,
                                     ChessApplication* app);
VALA_EXTERN GType chess_scene_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessScene, g_object_unref)
VALA_EXTERN ChessScene* chess_scene_new (void);
VALA_EXTERN ChessScene* chess_scene_construct (GType object_type);
static void __lambda40_ (ChessWindow* self);
VALA_EXTERN void chess_window_update_history_panel (ChessWindow* self);
static void ___lambda40__chess_scene_changed (ChessScene* _sender,
                                       gpointer self);
VALA_EXTERN ChessView* chess_view_new (ChessScene* scene);
VALA_EXTERN ChessView* chess_view_construct (GType object_type,
                                 ChessScene* scene);
static void chess_window_set_view (ChessWindow* self,
                            ChessView* value);
VALA_EXTERN ChessView* chess_window_get_view (ChessWindow* self);
VALA_EXTERN void chess_window_update_pause_resume_button (ChessWindow* self);
static void chess_window_draw_white_time_label (ChessWindow* self,
                                         GtkDrawingArea* drawing_area,
                                         cairo_t* c,
                                         gint width,
                                         gint height);
static void _chess_window_draw_white_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                     cairo_t* cr,
                                                                     gint width,
                                                                     gint height,
                                                                     gpointer self);
static void chess_window_draw_black_time_label (ChessWindow* self,
                                         GtkDrawingArea* drawing_area,
                                         cairo_t* c,
                                         gint width,
                                         gint height);
static void _chess_window_draw_black_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                     cairo_t* cr,
                                                                     gint width,
                                                                     gint height,
                                                                     gpointer self);
static void chess_window_history_dropdown_button_setup_cb (ChessWindow* self,
                                                    GtkSignalListItemFactory* factory,
                                                    GObject* object);
static void _chess_window_history_dropdown_button_setup_cb_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                        GObject* object,
                                                                                        gpointer self);
static void chess_window_history_dropdown_button_bind_cb (ChessWindow* self,
                                                   GtkSignalListItemFactory* factory,
                                                   GObject* object);
static void _chess_window_history_dropdown_button_bind_cb_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                      GObject* object,
                                                                                      gpointer self);
VALA_EXTERN void chess_window_update_game_status (ChessWindow* self,
                                      const gchar* title,
                                      const gchar* info);
VALA_EXTERN gchar* chess_application_compute_current_title (ChessApplication* self);
VALA_EXTERN gchar* chess_application_compute_status_info (ChessApplication* self);
VALA_EXTERN ChessScene* chess_window_get_scene (ChessWindow* self);
VALA_EXTERN ChessGame* chess_scene_get_game (ChessScene* self);
VALA_EXTERN ChessGame* chess_window_get_game (ChessWindow* self);
VALA_EXTERN gint chess_scene_get_move_number (ChessScene* self);
VALA_EXTERN void chess_application_enable_action (ChessApplication* self,
                                      const gchar* name);
VALA_EXTERN void chess_application_disable_action (ChessApplication* self,
                                       const gchar* name);
VALA_EXTERN gchar* chess_window_get_move_text (ChessWindow* self,
                                   ChessMove* move);
VALA_EXTERN void chess_window_set_clock_visible (ChessWindow* self,
                                     gboolean visible);
static gint chess_window_compute_time_label_width_request (ChessWindow* self,
                                                    cairo_t* c);
static void chess_window_draw_time (ChessWindow* self,
                             GtkWidget* widget,
                             cairo_t* c,
                             gint width,
                             gint height,
                             const gchar* text,
                             gdouble* fg,
                             gint fg_length1,
                             gdouble* bg,
                             gint bg_length1);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda41_ (Block2Data* _data2_);
static gboolean ____lambda41__gsource_func (gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gchar* chess_window_make_clock_text (ChessWindow* self,
                                     ChessClock* clock,
                                     Color color);
static void chess_window_history_dropdown_selection_changed_cb (ChessWindow* self);
VALA_EXTERN void chess_scene_set_move_number (ChessScene* self,
                                  gint value);
static void _chess_window_history_dropdown_selection_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
VALA_EXTERN const gchar* chess_scene_get_move_format (ChessScene* self);
VALA_EXTERN void chess_window_start_game (ChessWindow* self);
static void ___lambda31_ (ChessWindow* self);
static void ____lambda31__chess_clock_tick (ChessClock* _sender,
                                     gpointer self);
VALA_EXTERN void chess_window_move (ChessWindow* self,
                        ChessMove* m);
VALA_EXTERN void chess_window_undo (ChessWindow* self);
VALA_EXTERN void chess_window_end_game (ChessWindow* self);
VALA_EXTERN ChessScene* chess_view_get_scene (ChessView* self);
static void chess_window_finalize (GObject * obj);
static GType chess_window_get_type_once (void);
static void _vala_chess_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_chess_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
chess_window_get_instance_private (ChessWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ChessWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda40_ (ChessWindow* self)
{
	chess_window_update_history_panel (self);
}

static void
___lambda40__chess_scene_changed (ChessScene* _sender,
                                  gpointer self)
{
	__lambda40_ ((ChessWindow*) self);
}

static void
_chess_window_draw_white_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                cairo_t* cr,
                                                                gint width,
                                                                gint height,
                                                                gpointer self)
{
	chess_window_draw_white_time_label ((ChessWindow*) self, drawing_area, cr, width, height);
}

static void
_chess_window_draw_black_time_label_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                cairo_t* cr,
                                                                gint width,
                                                                gint height,
                                                                gpointer self)
{
	chess_window_draw_black_time_label ((ChessWindow*) self, drawing_area, cr, width, height);
}

static void
_chess_window_history_dropdown_button_setup_cb_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                   GObject* object,
                                                                                   gpointer self)
{
	chess_window_history_dropdown_button_setup_cb ((ChessWindow*) self, _sender, object);
}

static void
_chess_window_history_dropdown_button_bind_cb_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self)
{
	chess_window_history_dropdown_button_bind_cb ((ChessWindow*) self, _sender, object);
}

ChessWindow*
chess_window_construct (GType object_type,
                        ChessApplication* app)
{
	ChessWindow * self = NULL;
	ChessApplication* _tmp0_;
	ChessScene* scene = NULL;
	ChessScene* _tmp1_;
	ChessView* _tmp2_;
	ChessView* _tmp3_;
	AdwToastOverlay* _tmp4_;
	ChessView* _tmp5_;
	GtkDrawingArea* _tmp6_;
	GtkDrawingArea* _tmp7_;
	GtkListItemFactory* list_factory = NULL;
	GtkDropDown* _tmp8_;
	GtkListItemFactory* _tmp9_;
	GtkListItemFactory* _tmp10_;
	GtkSignalListItemFactory* button_factory = NULL;
	GtkSignalListItemFactory* _tmp11_;
	GtkDropDown* _tmp12_;
	GtkDropDown* _tmp13_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (ChessWindow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	_tmp1_ = chess_scene_new ();
	scene = _tmp1_;
	g_signal_connect_object (scene, "changed", (GCallback) ___lambda40__chess_scene_changed, self, 0);
	_tmp2_ = chess_view_new (scene);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	chess_window_set_view (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->toast_overlay;
	_tmp5_ = self->priv->_view;
	adw_toast_overlay_set_child (_tmp4_, (GtkWidget*) _tmp5_);
	chess_window_update_pause_resume_button (self);
	_tmp6_ = self->priv->white_time_label;
	gtk_drawing_area_set_draw_func (_tmp6_, _chess_window_draw_white_time_label_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->black_time_label;
	gtk_drawing_area_set_draw_func (_tmp7_, _chess_window_draw_black_time_label_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->history_dropdown;
	_tmp9_ = gtk_drop_down_get_factory (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	list_factory = _tmp10_;
	_tmp11_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	button_factory = _tmp11_;
	g_signal_connect_object (button_factory, "setup", (GCallback) _chess_window_history_dropdown_button_setup_cb_gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (button_factory, "bind", (GCallback) _chess_window_history_dropdown_button_bind_cb_gtk_signal_list_item_factory_bind, self, 0);
	_tmp12_ = self->priv->history_dropdown;
	gtk_drop_down_set_factory (_tmp12_, (GtkListItemFactory*) button_factory);
	_tmp13_ = self->priv->history_dropdown;
	gtk_drop_down_set_list_factory (_tmp13_, list_factory);
	_g_object_unref0 (button_factory);
	_g_object_unref0 (list_factory);
	_g_object_unref0 (scene);
	return self;
}

ChessWindow*
chess_window_new (ChessApplication* app)
{
	return chess_window_construct (TYPE_CHESS_WINDOW, app);
}

void
chess_window_update_game_status (ChessWindow* self,
                                 const gchar* title,
                                 const gchar* info)
{
	gchar* _tmp0_ = NULL;
	gchar* toast = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	if (title != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (title);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		ChessApplication* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->app;
		_tmp3_ = chess_application_compute_current_title (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	_tmp4_ = g_strdup (info);
	toast = _tmp4_;
	_tmp5_ = toast;
	if (_tmp5_ == NULL) {
		ChessApplication* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->app;
		_tmp7_ = chess_application_compute_status_info (_tmp6_);
		_g_free0 (toast);
		toast = _tmp7_;
	}
	_tmp8_ = toast;
	if (_tmp8_ != NULL) {
		AdwToastOverlay* _tmp9_;
		const gchar* _tmp10_;
		AdwToast* _tmp11_;
		_tmp9_ = self->priv->toast_overlay;
		_tmp10_ = toast;
		_tmp11_ = adw_toast_new (_tmp10_);
		adw_toast_overlay_add_toast (_tmp9_, _tmp11_);
	}
	_g_free0 (toast);
	_g_free0 (_tmp0_);
}

void
chess_window_update_pause_resume_button (ChessWindow* self)
{
	ChessGame* game = NULL;
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	game = _tmp4_;
	_tmp6_ = game;
	if (_tmp6_ != NULL) {
		ChessGame* _tmp7_;
		ChessClock* _tmp8_;
		ChessClock* _tmp9_;
		_tmp7_ = game;
		_tmp8_ = chess_game_get_clock (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkButton* _tmp10_;
		_tmp10_ = self->priv->pause_resume_button;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	} else {
		GtkButton* _tmp11_;
		_tmp11_ = self->priv->pause_resume_button;
		gtk_widget_show ((GtkWidget*) _tmp11_);
	}
	_tmp13_ = game;
	if (_tmp13_ != NULL) {
		ChessGame* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = game;
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkButton* _tmp17_;
		GtkButton* _tmp18_;
		_tmp17_ = self->priv->pause_resume_button;
		gtk_button_set_icon_name (_tmp17_, "media-playback-start-symbolic");
		_tmp18_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Unpause the game"));
	} else {
		GtkButton* _tmp19_;
		GtkButton* _tmp20_;
		_tmp19_ = self->priv->pause_resume_button;
		gtk_button_set_icon_name (_tmp19_, "media-playback-pause-symbolic");
		_tmp20_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _ ("Pause the game"));
	}
	_g_object_unref0 (game);
}

void
chess_window_update_history_panel (ChessWindow* self)
{
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	gint move_number = 0;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint n_moves = 0;
	ChessGame* _tmp6_;
	ChessGame* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GtkDropDown* _tmp40_;
	ChessGame* _tmp41_;
	ChessGame* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gint i = 0;
	gchar** moves = NULL;
	gchar** _tmp45_;
	gint moves_length1;
	gint _moves_size_;
	ChessGame* _tmp46_;
	ChessGame* _tmp47_;
	GList* _tmp48_;
	GtkDropDown* _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_window_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = chess_window_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_;
	_tmp6_ = chess_window_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	n_moves = (gint) _tmp9_;
	if (move_number < 0) {
		move_number += 1 + n_moves;
	}
	if (n_moves > 0) {
		_tmp11_ = move_number != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ChessGame* _tmp12_;
		ChessGame* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = chess_window_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = chess_game_get_is_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp10_ = !_tmp15_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ChessApplication* _tmp16_;
		_tmp16_ = self->priv->app;
		chess_application_enable_action (_tmp16_, HISTORY_GO_FIRST_ACTION_NAME);
	} else {
		ChessApplication* _tmp17_;
		_tmp17_ = self->priv->app;
		chess_application_disable_action (_tmp17_, HISTORY_GO_FIRST_ACTION_NAME);
	}
	if (move_number > 0) {
		ChessGame* _tmp19_;
		ChessGame* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = chess_window_get_game (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = !_tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ChessApplication* _tmp23_;
		_tmp23_ = self->priv->app;
		chess_application_enable_action (_tmp23_, HISTORY_GO_PREVIOUS_ACTION_NAME);
	} else {
		ChessApplication* _tmp24_;
		_tmp24_ = self->priv->app;
		chess_application_disable_action (_tmp24_, HISTORY_GO_PREVIOUS_ACTION_NAME);
	}
	if (move_number < n_moves) {
		ChessGame* _tmp26_;
		ChessGame* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp26_ = chess_window_get_game (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = !_tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ChessApplication* _tmp30_;
		_tmp30_ = self->priv->app;
		chess_application_enable_action (_tmp30_, HISTORY_GO_NEXT_ACTION_NAME);
	} else {
		ChessApplication* _tmp31_;
		_tmp31_ = self->priv->app;
		chess_application_disable_action (_tmp31_, HISTORY_GO_NEXT_ACTION_NAME);
	}
	if (n_moves > 0) {
		_tmp33_ = move_number != n_moves;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ChessGame* _tmp34_;
		ChessGame* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp34_ = chess_window_get_game (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = chess_game_get_is_paused (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp32_ = !_tmp37_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ChessApplication* _tmp38_;
		_tmp38_ = self->priv->app;
		chess_application_enable_action (_tmp38_, HISTORY_GO_LAST_ACTION_NAME);
	} else {
		ChessApplication* _tmp39_;
		_tmp39_ = self->priv->app;
		chess_application_disable_action (_tmp39_, HISTORY_GO_LAST_ACTION_NAME);
	}
	_tmp40_ = self->priv->history_dropdown;
	_tmp41_ = chess_window_get_game (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = chess_game_get_is_paused (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp44_);
	i = 0;
	_tmp45_ = g_new0 (gchar*, n_moves + 1);
	moves = _tmp45_;
	moves_length1 = n_moves;
	_moves_size_ = moves_length1;
	_tmp46_ = chess_window_get_game (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = _tmp47_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp48_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp49_;
			ChessState* state = NULL;
			_tmp49_ = _g_object_ref0 ((ChessState*) state_it->data);
			state = _tmp49_;
			{
				ChessMove* move = NULL;
				ChessState* _tmp50_;
				ChessMove* _tmp51_;
				ChessMove* _tmp52_;
				gchar* _tmp53_ = NULL;
				ChessMove* _tmp54_;
				gchar** _tmp57_;
				gint _tmp57__length1;
				gint _tmp58_;
				gchar* _tmp59_;
				_tmp50_ = state;
				_tmp51_ = _tmp50_->last_move;
				_tmp52_ = _g_object_ref0 (_tmp51_);
				move = _tmp52_;
				_tmp54_ = move;
				if (_tmp54_ != NULL) {
					ChessMove* _tmp55_;
					gchar* _tmp56_;
					_tmp55_ = move;
					_tmp56_ = chess_window_get_move_text (self, _tmp55_);
					_g_free0 (_tmp53_);
					_tmp53_ = _tmp56_;
				} else {
					_g_free0 (_tmp53_);
					_tmp53_ = NULL;
				}
				_tmp57_ = moves;
				_tmp57__length1 = moves_length1;
				_tmp58_ = i;
				i = _tmp58_ + 1;
				_tmp59_ = g_strdup (_tmp53_);
				_g_free0 (_tmp57_[_tmp58_]);
				_tmp57_[_tmp58_] = _tmp59_;
				_g_free0 (_tmp53_);
				_g_object_unref0 (move);
				_g_object_unref0 (state);
			}
		}
	}
	_tmp60_ = self->priv->history_dropdown;
	gtk_drop_down_set_selected (_tmp60_, (guint) move_number);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
}

void
chess_window_set_clock_visible (ChessWindow* self,
                                gboolean visible)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
}

static gint
chess_window_compute_time_label_width_request (ChessWindow* self,
                                               cairo_t* c)
{
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_text_extents_t _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	cairo_text_extents_t _tmp6_;
	cairo_text_extents_t _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	cairo_text_extents_t _tmp10_;
	cairo_text_extents_t _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	cairo_text_extents_t _tmp14_;
	cairo_text_extents_t _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	cairo_text_extents_t _tmp18_;
	cairo_text_extents_t _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	cairo_text_extents_t _tmp22_;
	cairo_text_extents_t _tmp24_ = {0};
	gdouble _tmp25_ = 0.0;
	cairo_text_extents_t _tmp26_;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	cairo_text_extents_t _tmp30_;
	cairo_text_extents_t _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	cairo_text_extents_t _tmp34_;
	cairo_text_extents_t _tmp36_ = {0};
	gdouble _tmp37_ = 0.0;
	cairo_text_extents_t _tmp38_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (c != NULL, 0);
	max = (gdouble) 0;
	cairo_text_extents (c, "000∶00", &_tmp0_);
	extents = _tmp0_;
	_tmp2_ = extents;
	if (max > _tmp2_.width) {
		_tmp1_ = max;
	} else {
		cairo_text_extents_t _tmp3_;
		_tmp3_ = extents;
		_tmp1_ = _tmp3_.width;
	}
	max = _tmp1_;
	cairo_text_extents (c, "111∶11", &_tmp4_);
	extents = _tmp4_;
	_tmp6_ = extents;
	if (max > _tmp6_.width) {
		_tmp5_ = max;
	} else {
		cairo_text_extents_t _tmp7_;
		_tmp7_ = extents;
		_tmp5_ = _tmp7_.width;
	}
	max = _tmp5_;
	cairo_text_extents (c, "222∶22", &_tmp8_);
	extents = _tmp8_;
	_tmp10_ = extents;
	if (max > _tmp10_.width) {
		_tmp9_ = max;
	} else {
		cairo_text_extents_t _tmp11_;
		_tmp11_ = extents;
		_tmp9_ = _tmp11_.width;
	}
	max = _tmp9_;
	cairo_text_extents (c, "333∶33", &_tmp12_);
	extents = _tmp12_;
	_tmp14_ = extents;
	if (max > _tmp14_.width) {
		_tmp13_ = max;
	} else {
		cairo_text_extents_t _tmp15_;
		_tmp15_ = extents;
		_tmp13_ = _tmp15_.width;
	}
	max = _tmp13_;
	cairo_text_extents (c, "444∶44", &_tmp16_);
	extents = _tmp16_;
	_tmp18_ = extents;
	if (max > _tmp18_.width) {
		_tmp17_ = max;
	} else {
		cairo_text_extents_t _tmp19_;
		_tmp19_ = extents;
		_tmp17_ = _tmp19_.width;
	}
	max = _tmp17_;
	cairo_text_extents (c, "555∶55", &_tmp20_);
	extents = _tmp20_;
	_tmp22_ = extents;
	if (max > _tmp22_.width) {
		_tmp21_ = max;
	} else {
		cairo_text_extents_t _tmp23_;
		_tmp23_ = extents;
		_tmp21_ = _tmp23_.width;
	}
	max = _tmp21_;
	cairo_text_extents (c, "666∶66", &_tmp24_);
	extents = _tmp24_;
	_tmp26_ = extents;
	if (max > _tmp26_.width) {
		_tmp25_ = max;
	} else {
		cairo_text_extents_t _tmp27_;
		_tmp27_ = extents;
		_tmp25_ = _tmp27_.width;
	}
	max = _tmp25_;
	cairo_text_extents (c, "777∶77", &_tmp28_);
	extents = _tmp28_;
	_tmp30_ = extents;
	if (max > _tmp30_.width) {
		_tmp29_ = max;
	} else {
		cairo_text_extents_t _tmp31_;
		_tmp31_ = extents;
		_tmp29_ = _tmp31_.width;
	}
	max = _tmp29_;
	cairo_text_extents (c, "888∶88", &_tmp32_);
	extents = _tmp32_;
	_tmp34_ = extents;
	if (max > _tmp34_.width) {
		_tmp33_ = max;
	} else {
		cairo_text_extents_t _tmp35_;
		_tmp35_ = extents;
		_tmp33_ = _tmp35_.width;
	}
	max = _tmp33_;
	cairo_text_extents (c, "999∶99", &_tmp36_);
	extents = _tmp36_;
	_tmp38_ = extents;
	if (max > _tmp38_.width) {
		_tmp37_ = max;
	} else {
		cairo_text_extents_t _tmp39_;
		_tmp39_ = extents;
		_tmp37_ = _tmp39_.width;
	}
	max = _tmp37_;
	result = ((gint) ceil (max)) + 6;
	_vala_warn_if_fail (result > 0, "result > 0");
	return result;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ChessWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->widget);
		_cairo_destroy0 (_data2_->c);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
___lambda41_ (Block2Data* _data2_)
{
	ChessWindow* self;
	gboolean result;
	self = _data2_->self;
	gtk_widget_set_size_request (_data2_->widget, chess_window_compute_time_label_width_request (self, _data2_->c), -1);
	gtk_widget_queue_draw (_data2_->widget);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda41_ (self);
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
chess_window_draw_time (ChessWindow* self,
                        GtkWidget* widget,
                        cairo_t* c,
                        gint width,
                        gint height,
                        const gchar* text,
                        gdouble* fg,
                        gint fg_length1,
                        gdouble* bg,
                        gint bg_length1)
{
	Block2Data* _data2_;
	GtkWidget* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble alpha = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	PangoContext* pango_context = NULL;
	PangoContext* _tmp7_;
	PangoContext* _tmp8_;
	cairo_font_options_t* _tmp9_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp10_;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp12_;
	PangoFontDescription* _tmp13_;
	PangoFontDescription* _tmp14_;
	PangoLayout* _tmp15_;
	PangoAttrList* attributes = NULL;
	PangoAttrList* _tmp16_;
	PangoAttrList* _tmp17_;
	PangoAttrFontFeatures* _tmp18_;
	PangoLayout* _tmp19_;
	PangoAttrList* _tmp20_;
	gint layout_width = 0;
	gint layout_height = 0;
	PangoLayout* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	PangoLayout* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data2_->widget);
	_data2_->widget = _tmp0_;
	_tmp1_ = _cairo_reference0 (c);
	_cairo_destroy0 (_data2_->c);
	_data2_->c = _tmp1_;
	g_object_get (_data2_->widget, "width-request", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == -1) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda41__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	alpha = 1.0;
	if ((gtk_widget_get_state_flags (_data2_->widget) & GTK_STATE_FLAG_INSENSITIVE) != 0) {
		alpha = 0.5;
	}
	_tmp4_ = bg[0];
	_tmp5_ = bg[1];
	_tmp6_ = bg[2];
	cairo_set_source_rgba (_data2_->c, _tmp4_, _tmp5_, _tmp6_, alpha);
	cairo_paint (_data2_->c);
	_tmp7_ = pango_cairo_create_context (_data2_->c);
	pango_context = _tmp7_;
	_tmp8_ = pango_context;
	_tmp9_ = gtk_widget_get_font_options ((GtkWidget*) self);
	pango_cairo_context_set_font_options (_tmp8_, _tmp9_);
	_tmp10_ = pango_context;
	_tmp11_ = pango_layout_new (_tmp10_);
	layout = _tmp11_;
	_tmp12_ = layout;
	_tmp13_ = pango_font_description_from_string ("Sans Bold 14");
	_tmp14_ = _tmp13_;
	pango_layout_set_font_description (_tmp12_, _tmp14_);
	__vala_PangoFontDescription_free0 (_tmp14_);
	_tmp15_ = layout;
	pango_layout_set_text (_tmp15_, text, -1);
	_tmp16_ = pango_attr_list_new ();
	attributes = _tmp16_;
	_tmp17_ = attributes;
	_tmp18_ = (PangoAttrFontFeatures*) pango_attr_font_features_new ("tnum=1");
	pango_attr_list_insert (_tmp17_, (PangoAttribute*) _tmp18_);
	_tmp19_ = layout;
	_tmp20_ = attributes;
	pango_layout_set_attributes (_tmp19_, _tmp20_);
	_tmp21_ = layout;
	pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
	layout_width = _tmp22_;
	layout_height = _tmp23_;
	layout_width /= PANGO_SCALE;
	layout_height /= PANGO_SCALE;
	cairo_move_to (_data2_->c, (gdouble) ((gtk_widget_get_width (_data2_->widget) - layout_width) / 2), (gdouble) ((gtk_widget_get_height (_data2_->widget) - layout_height) / 2));
	_tmp24_ = fg[0];
	_tmp25_ = fg[1];
	_tmp26_ = fg[2];
	cairo_set_source_rgba (_data2_->c, _tmp24_, _tmp25_, _tmp26_, alpha);
	_tmp27_ = layout;
	pango_cairo_show_layout (_data2_->c, _tmp27_);
	_pango_attr_list_unref0 (attributes);
	_g_object_unref0 (layout);
	_g_object_unref0 (pango_context);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gchar*
chess_window_make_clock_text (ChessWindow* self,
                              ChessClock* clock,
                              Color color)
{
	gint time = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (clock != NULL, "clock != null", NULL);
	if (color == COLOR_WHITE) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = chess_clock_get_white_remaining_seconds (clock);
		_tmp1_ = _tmp0_;
		time = _tmp1_;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = chess_clock_get_black_remaining_seconds (clock);
		_tmp3_ = _tmp2_;
		time = _tmp3_;
	}
	if (time >= 60) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf ("%d:%02d", time / 60, time % 60);
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf (":%02d", time);
		result = _tmp5_;
		return result;
	}
}

static void
chess_window_draw_white_time_label (ChessWindow* self,
                                    GtkDrawingArea* drawing_area,
                                    cairo_t* c,
                                    gint width,
                                    gint height)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessClock* _tmp4_;
	ChessClock* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble* _tmp8_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_game_get_clock (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_window_make_clock_text (self, _tmp5_, COLOR_WHITE);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (gdouble, 3);
	_tmp8_[0] = 0.0;
	_tmp8_[1] = 0.0;
	_tmp8_[2] = 0.0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = g_new0 (gdouble, 3);
	_tmp10_[0] = 1.0;
	_tmp10_[1] = 1.0;
	_tmp10_[2] = 1.0;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 3;
	chess_window_draw_time (self, (GtkWidget*) drawing_area, c, width, height, _tmp7_, _tmp9_, (gint) 3, _tmp11_, (gint) 3);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_g_free0 (_tmp7_);
}

static void
chess_window_draw_black_time_label (ChessWindow* self,
                                    GtkDrawingArea* drawing_area,
                                    cairo_t* c,
                                    gint width,
                                    gint height)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessClock* _tmp4_;
	ChessClock* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble* _tmp8_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_game_get_clock (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_window_make_clock_text (self, _tmp5_, COLOR_BLACK);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (gdouble, 3);
	_tmp8_[0] = 1.0;
	_tmp8_[1] = 1.0;
	_tmp8_[2] = 1.0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = g_new0 (gdouble, 3);
	_tmp10_[0] = 0.0;
	_tmp10_[1] = 0.0;
	_tmp10_[2] = 0.0;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 3;
	chess_window_draw_time (self, (GtkWidget*) drawing_area, c, width, height, _tmp7_, _tmp9_, (gint) 3, _tmp11_, (gint) 3);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_g_free0 (_tmp7_);
}

static void
chess_window_history_dropdown_button_setup_cb (ChessWindow* self,
                                               GtkSignalListItemFactory* factory,
                                               GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp0_, (gfloat) 0);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_list_item_set_child (list_item, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
chess_window_history_dropdown_button_bind_cb (ChessWindow* self,
                                              GtkSignalListItemFactory* factory,
                                              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkStringObject* string_object = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkLabel* label = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_item (list_item);
	_tmp1_ = _tmp0_;
	string_object = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_string_object_get_type ()) ? ((GtkStringObject*) _tmp1_) : NULL;
	_tmp2_ = gtk_list_item_get_child (list_item);
	_tmp3_ = _tmp2_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp3_) : NULL;
	_tmp4_ = gtk_string_object_get_string (string_object);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (label, _tmp5_);
}

static void
chess_window_history_dropdown_selection_changed_cb (ChessWindow* self)
{
	gint move_number = 0;
	GtkDropDown* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_dropdown;
	move_number = (gint) gtk_drop_down_get_selected (_tmp0_);
	if (((guint) move_number) == GTK_INVALID_LIST_POSITION) {
		return;
	}
	_tmp2_ = chess_window_get_game (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ChessGame* _tmp4_;
		ChessGame* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		_tmp4_ = chess_window_get_game (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = chess_game_get_n_moves (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = ((guint) move_number) == _tmp7_;
	}
	if (_tmp1_) {
		ChessScene* _tmp8_;
		ChessScene* _tmp9_;
		_tmp8_ = chess_window_get_scene (self);
		_tmp9_ = _tmp8_;
		chess_scene_set_move_number (_tmp9_, -1);
	} else {
		ChessScene* _tmp10_;
		ChessScene* _tmp11_;
		_tmp10_ = chess_window_get_scene (self);
		_tmp11_ = _tmp10_;
		chess_scene_set_move_number (_tmp11_, move_number);
	}
}

static void
_chess_window_history_dropdown_selection_changed_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	chess_window_history_dropdown_selection_changed_cb ((ChessWindow*) self);
}

gchar*
chess_window_get_move_text (ChessWindow* self,
                            ChessMove* move)
{
	static const gchar* human_descriptions[72] = {N_ ("White pawn moves from %1$s to %2$s"), N_ ("White pawn at %1$s takes the black pawn at %2$s"), N_ ("White pawn at %1$s takes the black rook at %2$s"), N_ ("White pawn at %1$s takes the black knight at %2$s"), N_ ("White pawn at %1$s takes the black bishop at %2$s"), N_ ("White pawn at %1$s takes the black queen at %2$s"), N_ ("White rook moves from %1$s to %2$s"), N_ ("White rook at %1$s takes the black pawn at %2$s"), N_ ("White rook at %1$s takes the black rook at %2$s"), N_ ("White rook at %1$s takes the black knight at %2$s"), N_ ("White rook at %1$s takes the black bishop at %2$s"), N_ ("White rook at %1$s takes the black queen at %2$s"), N_ ("White knight moves from %1$s to %2$s"), N_ ("White knight at %1$s takes the black pawn at %2$s"), N_ ("White knight at %1$s takes the black rook at %2$s"), N_ ("White knight at %1$s takes the black knight at %2$s"), N_ ("White knight at %1$s takes the black bishop at %2$s"), N_ ("White knight at %1$s takes the black queen at %2$s"), N_ ("White bishop moves from %1$s to %2$s"), N_ ("White bishop at %1$s takes the black pawn at %2$s"), N_ ("White bishop at %1$s takes the black rook at %2$s"), N_ ("White bishop at %1$s takes the black knight at %2$s"), N_ ("White bishop at %1$s takes the black bishop at %2$s"), N_ ("White bishop at %1$s takes the black queen at %2$s"), N_ ("White queen moves from %1$s to %2$s"), N_ ("White queen at %1$s takes the black pawn at %2$s"), N_ ("White queen at %1$s takes the black rook at %2$s"), N_ ("White queen at %1$s takes the black knight at %2$s"), N_ ("White queen at %1$s takes the black bishop at %2$s"), N_ ("White queen at %1$s takes the black queen at %2$s"), N_ ("White king moves from %1$s to %2$s"), N_ ("White king at %1$s takes the black pawn at %2$s"), N_ ("White king at %1$s takes the black rook at %2$s"), N_ ("White king at %1$s takes the black knight at %2$s"), N_ ("White king at %1$s takes the black bishop at %2$s"), N_ ("White king at %1$s takes the black queen at %2$s"), N_ ("Black pawn moves from %1$s to %2$s"), N_ ("Black pawn at %1$s takes the white pawn at %2$s"), N_ ("Black pawn at %1$s takes the white rook at %2$s"), N_ ("Black pawn at %1$s takes the white knight at %2$s"), N_ ("Black pawn at %1$s takes the white bishop at %2$s"), N_ ("Black pawn at %1$s takes the white queen at %2$s"), N_ ("Black rook moves from %1$s to %2$s"), N_ ("Black rook at %1$s takes the white pawn at %2$s"), N_ ("Black rook at %1$s takes the white rook at %2$s"), N_ ("Black rook at %1$s takes the white knight at %2$s"), N_ ("Black rook at %1$s takes the white bishop at %2$s"), N_ ("Black rook at %1$s takes the white queen at %2$s"), N_ ("Black knight moves from %1$s to %2$s"), N_ ("Black knight at %1$s takes the white pawn at %2$s"), N_ ("Black knight at %1$s takes the white rook at %2$s"), N_ ("Black knight at %1$s takes the white knight at %2$s"), N_ ("Black knight at %1$s takes the white bishop at %2$s"), N_ ("Black knight at %1$s takes the white queen at %2$s"), N_ ("Black bishop moves from %1$s to %2$s"), N_ ("Black bishop at %1$s takes the white pawn at %2$s"), N_ ("Black bishop at %1$s takes the white rook at %2$s"), N_ ("Black bishop at %1$s takes the white knight at %2$s"), N_ ("Black bishop at %1$s takes the white bishop at %2$s"), N_ ("Black bishop at %1$s takes the white queen at %2$s"), N_ ("Black queen moves from %1$s to %2$s"), N_ ("Black queen at %1$s takes the white pawn at %2$s"), N_ ("Black queen at %1$s takes the white rook at %2$s"), N_ ("Black queen at %1$s takes the white knight at %2$s"), N_ ("Black queen at %1$s takes the white bishop at %2$s"), N_ ("Black queen at %1$s takes the white queen at %2$s"), N_ ("Black king moves from %1$s to %2$s"), N_ ("Black king at %1$s takes the white pawn at %2$s"), N_ ("Black king at %1$s takes the white rook at %2$s"), N_ ("Black king at %1$s takes the white knight at %2$s"), N_ ("Black king at %1$s takes the white bishop at %2$s"), N_ ("Black king at %1$s takes the white queen at %2$s")};
	gchar* move_text = NULL;
	gchar* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	gchar _tmp35_ = '\0';
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (move != NULL, NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = chess_window_get_scene (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_move_format (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessPiece* _tmp8_;
				_tmp8_ = move->castling_rook;
				if (_tmp8_ != NULL) {
					gboolean _tmp9_ = FALSE;
					if (move->f0 < move->f1) {
						_tmp9_ = move->r0 == 0;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gchar* _tmp10_;
						_tmp10_ = g_strdup (_ ("White castles kingside"));
						_g_free0 (move_text);
						move_text = _tmp10_;
					} else {
						gboolean _tmp11_ = FALSE;
						if (move->f1 < move->f0) {
							_tmp11_ = move->r0 == 0;
						} else {
							_tmp11_ = FALSE;
						}
						if (_tmp11_) {
							gchar* _tmp12_;
							_tmp12_ = g_strdup (_ ("White castles queenside"));
							_g_free0 (move_text);
							move_text = _tmp12_;
						} else {
							gboolean _tmp13_ = FALSE;
							if (move->f0 < move->f1) {
								_tmp13_ = move->r0 == 7;
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								gchar* _tmp14_;
								_tmp14_ = g_strdup (_ ("Black castles kingside"));
								_g_free0 (move_text);
								move_text = _tmp14_;
							} else {
								gboolean _tmp15_ = FALSE;
								if (move->f1 < move->f0) {
									_tmp15_ = move->r0 == 7;
								} else {
									_tmp15_ = FALSE;
								}
								if (_tmp15_) {
									gchar* _tmp16_;
									_tmp16_ = g_strdup (_ ("Black castles queenside"));
									_g_free0 (move_text);
									move_text = _tmp16_;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				} else {
					gint index = 0;
					ChessPiece* _tmp17_;
					ChessPiece* _tmp19_;
					ChessPiece* _tmp20_;
					ChessPlayer* _tmp21_;
					gchar* start = NULL;
					gchar* _tmp22_;
					gchar* end = NULL;
					gchar* _tmp23_;
					gchar* template = NULL;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp17_ = move->victim;
					if (_tmp17_ == NULL) {
						index = 0;
					} else {
						ChessPiece* _tmp18_;
						_tmp18_ = move->victim;
						index = (gint) (_tmp18_->type + 1);
					}
					_tmp19_ = move->piece;
					index += (gint) (_tmp19_->type * 6);
					_tmp20_ = move->piece;
					_tmp21_ = _tmp20_->player;
					if (_tmp21_->color == COLOR_BLACK) {
						index += 36;
					}
					_tmp22_ = g_strdup_printf ("%c%d", 'a' + move->f0, move->r0 + 1);
					start = _tmp22_;
					_tmp23_ = g_strdup_printf ("%c%d", 'a' + move->f1, move->r1 + 1);
					end = _tmp23_;
					_tmp24_ = human_descriptions[index];
					_tmp25_ = g_strdup (_ (_tmp24_));
					template = _tmp25_;
					if (move->en_passant) {
						if (move->r0 < move->r1) {
							gchar* _tmp26_;
							_tmp26_ = g_strdup (_ ("White pawn at %1$s takes the black pawn at %2$s en passant"));
							_g_free0 (template);
							template = _tmp26_;
						} else {
							gchar* _tmp27_;
							_tmp27_ = g_strdup (_ ("Black pawn at %1$s takes white pawn at %2$s en passant"));
							_g_free0 (template);
							template = _tmp27_;
						}
					}
					_tmp28_ = template;
					_tmp29_ = start;
					_tmp30_ = end;
					_tmp31_ = g_strdup_printf (_tmp28_, _tmp29_, _tmp30_);
					_g_free0 (move_text);
					move_text = _tmp31_;
					_g_free0 (template);
					_g_free0 (end);
					_g_free0 (start);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				gchar* _tmp32_;
				_tmp32_ = chess_move_get_san (move);
				_g_free0 (move_text);
				move_text = _tmp32_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				gchar* _tmp33_;
				_tmp33_ = chess_move_get_fan (move);
				_g_free0 (move_text);
				move_text = _tmp33_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp34_;
				_tmp34_ = chess_move_get_lan (move);
				_g_free0 (move_text);
				move_text = _tmp34_;
				break;
			}
		}
	}
	if ((move->number % 2) == 0) {
		_tmp35_ = 'b';
	} else {
		_tmp35_ = 'a';
	}
	_tmp36_ = move_text;
	_tmp37_ = g_strdup_printf ("%u%c. %s", (guint) ((move->number + 1) / 2), (gint) _tmp35_, _tmp36_);
	result = _tmp37_;
	_g_free0 (move_text);
	return result;
}

static void
___lambda31_ (ChessWindow* self)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}

static void
____lambda31__chess_clock_tick (ChessClock* _sender,
                                gpointer self)
{
	___lambda31_ ((ChessWindow*) self);
}

void
chess_window_start_game (ChessWindow* self)
{
	GtkStringList* _tmp0_;
	GtkStringList* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GtkStringList* _tmp4_;
	GtkDropDown* _tmp5_;
	GtkDrawingArea* _tmp6_;
	GtkDrawingArea* _tmp7_;
	ChessGame* _tmp8_;
	ChessGame* _tmp9_;
	ChessClock* _tmp10_;
	ChessClock* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_model;
	_tmp1_ = self->priv->history_model;
	g_object_get (_tmp1_, "n-items", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	gtk_string_list_splice (_tmp0_, (guint) 0, _tmp3_, NULL);
	_tmp4_ = self->priv->history_model;
	gtk_string_list_append (_tmp4_, _ ("Game Start"));
	_tmp5_ = self->priv->history_dropdown;
	gtk_drop_down_set_selected (_tmp5_, (guint) 0);
	_tmp6_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
	_tmp8_ = chess_window_get_game (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = chess_game_get_clock (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ChessGame* _tmp12_;
		ChessGame* _tmp13_;
		ChessClock* _tmp14_;
		ChessClock* _tmp15_;
		_tmp12_ = chess_window_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = chess_game_get_clock (_tmp13_);
		_tmp15_ = _tmp14_;
		g_signal_connect_object (_tmp15_, "tick", (GCallback) ____lambda31__chess_clock_tick, self, 0);
	}
}

void
chess_window_move (ChessWindow* self,
                   ChessMove* m)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	GtkStringList* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ChessGame* _tmp5_;
	ChessGame* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, -1);
	_tmp2_ = self->priv->history_model;
	_tmp3_ = chess_window_get_move_text (self, m);
	_tmp4_ = _tmp3_;
	gtk_string_list_append (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = chess_window_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_game_get_n_moves (_tmp6_);
	_tmp8_ = _tmp7_;
	if (((guint) m->number) == _tmp8_) {
		GtkDropDown* _tmp9_;
		_tmp9_ = self->priv->history_dropdown;
		gtk_drop_down_set_selected (_tmp9_, (guint) m->number);
	}
}

void
chess_window_undo (ChessWindow* self)
{
	GtkStringList* _tmp0_;
	GtkStringList* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	GtkDropDown* _tmp6_;
	GtkStringList* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	ChessView* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history_model;
	_tmp1_ = self->priv->history_model;
	g_object_get (_tmp1_, "n-items", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	gtk_string_list_remove (_tmp0_, _tmp3_ - 1);
	_tmp4_ = chess_window_get_scene (self);
	_tmp5_ = _tmp4_;
	chess_scene_set_move_number (_tmp5_, -1);
	_tmp6_ = self->priv->history_dropdown;
	_tmp7_ = self->priv->history_model;
	g_object_get (_tmp7_, "n-items", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	gtk_drop_down_set_selected (_tmp6_, _tmp9_ - 1);
	_tmp10_ = self->priv->_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp10_);
}

void
chess_window_end_game (ChessWindow* self)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}

ChessView*
chess_window_get_view (ChessWindow* self)
{
	ChessView* result;
	ChessView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
chess_window_set_view (ChessWindow* self,
                       ChessView* value)
{
	ChessView* old_value;
	g_return_if_fail (self != NULL);
	old_value = chess_window_get_view (self);
	if (old_value != value) {
		ChessView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, chess_window_properties[CHESS_WINDOW_VIEW_PROPERTY]);
	}
}

ChessScene*
chess_window_get_scene (ChessWindow* self)
{
	ChessScene* result;
	ChessView* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = chess_view_get_scene (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ChessGame*
chess_window_get_game (ChessWindow* self)
{
	ChessGame* result;
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_window_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
chess_window_class_init (ChessWindowClass * klass,
                         gpointer klass_data)
{
	chess_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_VIEW_PROPERTY, chess_window_properties[CHESS_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_CHESS_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_SCENE_PROPERTY, chess_window_properties[CHESS_WINDOW_SCENE_PROPERTY] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_WINDOW_GAME_PROPERTY, chess_window_properties[CHESS_WINDOW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/chess-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_resume_button", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, pause_resume_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "history_dropdown", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, history_dropdown));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "history_model", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, history_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_box", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, clock_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "white_time_label", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, white_time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "black_time_label", FALSE, ChessWindow_private_offset + G_STRUCT_OFFSET (ChessWindowPrivate, black_time_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "history_dropdown_selection_changed_cb", G_CALLBACK(_chess_window_history_dropdown_selection_changed_cb_g_object_notify));
}

static void
chess_window_instance_init (ChessWindow * self,
                            gpointer klass)
{
	self->priv = chess_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
chess_window_finalize (GObject * obj)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_WINDOW, ChessWindow);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->app);
	G_OBJECT_CLASS (chess_window_parent_class)->finalize (obj);
}

static GType
chess_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessWindow), 0, (GInstanceInitFunc) chess_window_instance_init, NULL };
	GType chess_window_type_id;
	chess_window_type_id = g_type_register_static (adw_application_window_get_type (), "ChessWindow", &g_define_type_info, 0);
	ChessWindow_private_offset = g_type_add_instance_private (chess_window_type_id, sizeof (ChessWindowPrivate));
	return chess_window_type_id;
}

GType
chess_window_get_type (void)
{
	static volatile gsize chess_window_type_id__once = 0;
	if (g_once_init_enter (&chess_window_type_id__once)) {
		GType chess_window_type_id;
		chess_window_type_id = chess_window_get_type_once ();
		g_once_init_leave (&chess_window_type_id__once, chess_window_type_id);
	}
	return chess_window_type_id__once;
}

static void
_vala_chess_window_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_WINDOW, ChessWindow);
	switch (property_id) {
		case CHESS_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, chess_window_get_view (self));
		break;
		case CHESS_WINDOW_SCENE_PROPERTY:
		g_value_set_object (value, chess_window_get_scene (self));
		break;
		case CHESS_WINDOW_GAME_PROPERTY:
		g_value_set_object (value, chess_window_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_window_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ChessWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_WINDOW, ChessWindow);
	switch (property_id) {
		case CHESS_WINDOW_VIEW_PROPERTY:
		chess_window_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

