/* game-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-view.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <librsvg/rsvg.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <gio/gio.h>

#define GAME_VIEW_TILE_SHAKE_DURATION_MS 250
#define GAME_VIEW_TILE_SHAKE_FREQUENCY 6
#define GAME_VIEW_MIN_TILE_SHAKE_AMPLITUDE 3
#define GAME_VIEW_TILE_SHAKE_SCALE_FACTOR 0.04
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _gsk_render_node_unref0(var) ((var == NULL) ? NULL : (var = (gsk_render_node_unref (var), NULL)))

#define GAME_TYPE_ITERATOR (game_iterator_get_type ())
#define GAME_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_TYPE_ITERATOR, GameIterator))
#define GAME_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_TYPE_ITERATOR, GameIteratorClass))
#define GAME_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_TYPE_ITERATOR))
#define GAME_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_TYPE_ITERATOR))
#define GAME_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_TYPE_ITERATOR, GameIteratorClass))

typedef struct _GameIterator GameIterator;
typedef struct _GameIteratorClass GameIteratorClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _game_iterator_unref0(var) ((var == NULL) ? NULL : (var = (game_iterator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
typedef struct _SlotPrivate SlotPrivate;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))

struct _GameView {
	GtkWidget parent_instance;
	GameViewPrivate * priv;
	RsvgHandle* theme_handle;
	GdkTexture* texture;
	cairo_pattern_t* cairo_pattern;
	gint initial_theme_width;
	gint initial_theme_height;
	gint loaded_theme_width;
	gint loaded_theme_height;
};

struct _GameViewClass {
	GtkWidgetClass parent_class;
};

struct _GameViewPrivate {
	gint x_offset;
	gint y_offset;
	gint tile_width;
	gint tile_height;
	gint tile_layer_offset_x;
	gint tile_layer_offset_y;
	gint tile_pattern_width;
	gint tile_pattern_height;
	gboolean using_cairo;
	gboolean using_vector;
	gchar* theme;
	gdouble theme_aspect;
	gint rendered_theme_width;
	gint rendered_theme_height;
	guint tick_id;
	Game* _game;
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint number;
	gboolean visible;
	gboolean highlighted;
	gint move;
	Slot* slot;
	gboolean shaking;
	gint shake_offset;
	gdouble shake_start_time;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _Slot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GTypeClass parent_class;
	void (*finalize) (Slot *self);
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;

VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN gpointer game_ref (gpointer instance);
VALA_EXTERN void game_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_game (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_game (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_game (const GValue* value);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, game_unref)
VALA_EXTERN GameView* game_view_new (gboolean using_cairo);
VALA_EXTERN GameView* game_view_construct (GType object_type,
                               gboolean using_cairo);
static void game_view_click_cb (GameView* self,
                         GtkGestureClick* _controller,
                         gint n_press,
                         gdouble event_x,
                         gdouble event_y);
static void _game_view_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y,
                                                    gpointer self);
static void game_view_real_snapshot (GtkWidget* base,
                              GtkSnapshot* snapshot);
VALA_EXTERN Game* game_view_get_game (GameView* self);
static void game_view_update_dimensions (GameView* self);
static void game_view_resize_theme (GameView* self);
VALA_EXTERN gpointer game_iterator_ref (gpointer instance);
VALA_EXTERN void game_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_param_spec_iterator (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void game_value_set_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN void game_value_take_iterator (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer game_value_get_iterator (const GValue* value);
VALA_EXTERN GType game_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameIterator, game_iterator_unref)
VALA_EXTERN GameIterator* game_iterator (Game* self);
VALA_EXTERN gboolean game_iterator_next (GameIterator* self);
VALA_EXTERN gpointer tile_ref (gpointer instance);
VALA_EXTERN void tile_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_tile (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_tile (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_tile (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_tile (const GValue* value);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, tile_unref)
VALA_EXTERN Tile* game_iterator_get (GameIterator* self);
VALA_EXTERN gpointer slot_ref (gpointer instance);
VALA_EXTERN void slot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slot (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_slot (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_slot (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_slot (const GValue* value);
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, slot_unref)
VALA_EXTERN gboolean game_get_paused (Game* self);
static gint game_view_get_image_offset (GameView* self,
                                 gint number);
static void game_view_get_tile_position (GameView* self,
                                  Tile* tile,
                                  gint* x,
                                  gint* y);
VALA_EXTERN void game_view_set_theme (GameView* self,
                          const gchar* theme_path,
                          GameView* game_view,
                          const gchar* fallback_theme_path);
static void game_view_get_theme_size (GameView* self,
                               gdouble* width,
                               gdouble* height);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
VALA_EXTERN gint map_get_width (Map* self);
VALA_EXTERN gint map_get_height (Map* self);
static void game_view_redraw_tile_cb (GameView* self,
                               Tile* tile);
static gboolean __lambda4_ (GameView* self,
                     GtkWidget* widget,
                     GdkFrameClock* frame_clock);
static gboolean ___lambda4__gtk_tick_callback (GtkWidget* widget,
                                        GdkFrameClock* frame_clock,
                                        gpointer self);
static void game_view_paused_changed_cb (GameView* self);
VALA_EXTERN gboolean game_get_inspecting (Game* self);
static Tile* game_view_find_tile (GameView* self,
                           gint x,
                           gint y);
VALA_EXTERN gboolean game_get_all_tiles_unblocked (Game* self);
VALA_EXTERN void game_autoplay_end_game (Game* self);
VALA_EXTERN gboolean tile_get_selectable (Tile* self);
VALA_EXTERN void game_shake_tile (Game* self,
                      Tile* tile,
                      gint64 start_time);
VALA_EXTERN Tile* game_get_selected_tile (Game* self);
VALA_EXTERN void game_set_selected_tile (Game* self,
                             Tile* value);
VALA_EXTERN gboolean tile_matches (Tile* self,
                       Tile* tile);
VALA_EXTERN gboolean game_remove_pair (Game* self,
                           Tile* tile0,
                           Tile* tile1);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* value);
static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender,
                                                 Tile* tile,
                                                 gpointer self);
static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender,
                                                       gpointer self);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);
static void _vala_game_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_game_view_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y,
                                               gpointer self)
{
	game_view_click_cb ((GameView*) self, _sender, n_press, x, y);
}

GameView*
game_view_construct (GType object_type,
                     gboolean using_cairo)
{
	GameView * self = NULL;
	GtkGestureClick* click_controller = NULL;
	GtkGestureClick* _tmp0_;
	GtkEventController* _tmp1_;
	self = (GameView*) g_object_new (object_type, NULL);
	self->priv->using_cairo = using_cairo;
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	click_controller = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GtkEventController*) click_controller);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	g_signal_connect_object (click_controller, "pressed", (GCallback) _game_view_click_cb_gtk_gesture_click_pressed, self, 0);
	_g_object_unref0 (click_controller);
	return self;
}

GameView*
game_view_new (gboolean using_cairo)
{
	return game_view_construct (TYPE_GAME_VIEW, using_cairo);
}

static void
game_view_real_snapshot (GtkWidget* base,
                         GtkSnapshot* snapshot)
{
	GameView * self;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GdkTexture* _tmp3_;
	GskRenderNode* texture_node = NULL;
	GdkTexture* _tmp5_;
	self = (GameView*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	game_view_update_dimensions (self);
	game_view_resize_theme (self);
	_tmp3_ = self->texture;
	if (_tmp3_ == NULL) {
		cairo_pattern_t* _tmp4_;
		_tmp4_ = self->cairo_pattern;
		_tmp2_ = _tmp4_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	texture_node = NULL;
	_tmp5_ = self->texture;
	if (_tmp5_ != NULL) {
		GtkSnapshot* texture_snapshot = NULL;
		GtkSnapshot* _tmp6_;
		GdkTexture* _tmp7_;
		GtkSnapshot* _tmp8_;
		GtkSnapshot* _tmp9_;
		GtkSnapshot* _tmp10_;
		GskRenderNode* _tmp11_;
		_tmp6_ = gtk_snapshot_new ();
		texture_snapshot = _tmp6_;
		_tmp7_ = self->texture;
		_tmp8_ = texture_snapshot;
		gdk_paintable_snapshot ((GdkPaintable*) _tmp7_, (GdkSnapshot*) _tmp8_, (gdouble) self->priv->rendered_theme_width, (gdouble) self->priv->rendered_theme_height);
		_tmp9_ = texture_snapshot;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_tmp11_ = gtk_snapshot_free_to_node (_tmp10_);
		_gsk_render_node_unref0 (texture_node);
		texture_node = _tmp11_;
		_g_object_unref0 (texture_snapshot);
	}
	{
		GameIterator* _tile_it = NULL;
		Game* _tmp12_;
		Game* _tmp13_;
		GameIterator* _tmp14_;
		_tmp12_ = game_view_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = game_iterator (_tmp13_);
		_tile_it = _tmp14_;
		while (TRUE) {
			GameIterator* _tmp15_;
			Tile* tile = NULL;
			GameIterator* _tmp16_;
			Tile* _tmp17_;
			Tile* _tmp18_;
			gint _tmp19_ = 0;
			Game* _tmp20_;
			Game* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			gint tile_number = 0;
			gint texture_x = 0;
			gint _tmp25_ = 0;
			Tile* _tmp26_;
			gint texture_y = 0;
			gint tile_x = 0;
			gint tile_y = 0;
			Tile* _tmp27_;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Tile* _tmp30_;
			graphene_rect_t tile_rect = {0};
			graphene_rect_t _tmp32_;
			GskRenderNode* _tmp33_;
			_tmp15_ = _tile_it;
			if (!game_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _tile_it;
			_tmp17_ = game_iterator_get (_tmp16_);
			tile = _tmp17_;
			_tmp18_ = tile;
			if (!_tmp18_->visible) {
				continue;
			}
			_tmp20_ = game_view_get_game (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = game_get_paused (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				_tmp19_ = -1;
			} else {
				Tile* _tmp24_;
				_tmp24_ = tile;
				_tmp19_ = _tmp24_->number;
			}
			tile_number = _tmp19_;
			texture_x = game_view_get_image_offset (self, tile_number) * self->priv->tile_pattern_width;
			_tmp26_ = tile;
			if (_tmp26_->highlighted) {
				_tmp25_ = self->priv->tile_pattern_height;
			} else {
				_tmp25_ = 0;
			}
			texture_y = _tmp25_;
			_tmp27_ = tile;
			game_view_get_tile_position (self, _tmp27_, &_tmp28_, &_tmp29_);
			tile_x = _tmp28_;
			tile_y = _tmp29_;
			_tmp30_ = tile;
			if (_tmp30_->shaking) {
				Tile* _tmp31_;
				_tmp31_ = tile;
				tile_x += _tmp31_->shake_offset;
			}
			memset (&tile_rect, 0, sizeof (graphene_rect_t));
			graphene_rect_init (&tile_rect, (gfloat) tile_x, (gfloat) tile_y, (gfloat) self->priv->tile_pattern_width, (gfloat) self->priv->tile_pattern_height);
			_tmp32_ = tile_rect;
			gtk_snapshot_push_clip (snapshot, &_tmp32_);
			_tmp33_ = texture_node;
			if (_tmp33_ != NULL) {
				graphene_point_t _tmp34_ = {0};
				GskRenderNode* _tmp35_;
				memset (&_tmp34_, 0, sizeof (graphene_point_t));
				_tmp34_.x = (gfloat) (tile_x - texture_x);
				_tmp34_.y = (gfloat) (tile_y - texture_y);
				gtk_snapshot_translate (snapshot, &_tmp34_);
				_tmp35_ = texture_node;
				gtk_snapshot_append_node (snapshot, _tmp35_);
			} else {
				cairo_t* ctx = NULL;
				graphene_rect_t _tmp36_;
				cairo_t* _tmp37_;
				cairo_matrix_t matrix = {0};
				cairo_pattern_t* _tmp38_;
				cairo_matrix_t _tmp39_;
				cairo_t* _tmp40_;
				cairo_pattern_t* _tmp41_;
				cairo_t* _tmp42_;
				cairo_t* _tmp43_;
				_tmp36_ = tile_rect;
				_tmp37_ = gtk_snapshot_append_cairo (snapshot, &_tmp36_);
				ctx = _tmp37_;
				cairo_matrix_init_identity (&matrix);
				cairo_matrix_scale (&matrix, ((gdouble) self->loaded_theme_width) / ((gdouble) self->priv->rendered_theme_width), ((gdouble) self->loaded_theme_height) / ((gdouble) self->priv->rendered_theme_height));
				cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
				_tmp38_ = self->cairo_pattern;
				_tmp39_ = matrix;
				cairo_pattern_set_matrix (_tmp38_, &_tmp39_);
				_tmp40_ = ctx;
				_tmp41_ = self->cairo_pattern;
				cairo_set_source (_tmp40_, _tmp41_);
				_tmp42_ = ctx;
				cairo_rectangle (_tmp42_, (gdouble) tile_x, (gdouble) tile_y, (gdouble) self->priv->tile_pattern_width, (gdouble) self->priv->tile_pattern_height);
				_tmp43_ = ctx;
				cairo_fill (_tmp43_);
				_cairo_destroy0 (ctx);
			}
			gtk_snapshot_pop (snapshot);
		}
		_game_iterator_unref0 (_tile_it);
	}
	_gsk_render_node_unref0 (texture_node);
}

static gpointer
_cairo_pattern_reference0 (gpointer self)
{
	return self ? cairo_pattern_reference (self) : NULL;
}

void
game_view_set_theme (GameView* self,
                     const gchar* theme_path,
                     GameView* game_view,
                     const gchar* fallback_theme_path)
{
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->texture);
	self->texture = NULL;
	_cairo_pattern_destroy0 (self->cairo_pattern);
	self->cairo_pattern = NULL;
	if (theme_path == NULL) {
		_g_object_unref0 (self->theme_handle);
		self->theme_handle = NULL;
		return;
	}
	if (game_view == NULL) {
		GInputStream* stream = NULL;
		RsvgHandle* _tmp0_;
		RsvgHandle* _tmp1_;
		gdouble width = 0.0;
		gdouble height = 0.0;
		RsvgHandle* _tmp14_;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp0_ = rsvg_handle_new ();
		_g_object_unref0 (self->theme_handle);
		self->theme_handle = _tmp0_;
		_tmp1_ = self->theme_handle;
		rsvg_handle_set_base_uri (_tmp1_, "resource://");
		{
			GInputStream* _tmp2_ = NULL;
			GInputStream* _tmp3_;
			GInputStream* _tmp4_;
			RsvgHandle* _tmp5_;
			GInputStream* _tmp6_;
			_tmp3_ = g_resources_open_stream (theme_path, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (stream);
			stream = _tmp4_;
			_tmp5_ = self->theme_handle;
			_tmp6_ = stream;
			rsvg_handle_read_stream_sync (_tmp5_, _tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp2_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			{
				GInputStream* _tmp7_ = NULL;
				GInputStream* _tmp8_;
				GInputStream* _tmp9_;
				RsvgHandle* _tmp10_;
				GInputStream* _tmp11_;
				_tmp8_ = g_resources_open_stream (fallback_theme_path, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
				_tmp7_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp9_ = _tmp7_;
				_tmp7_ = NULL;
				_g_object_unref0 (stream);
				stream = _tmp9_;
				_tmp10_ = self->theme_handle;
				_tmp11_ = stream;
				rsvg_handle_read_stream_sync (_tmp10_, _tmp11_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp7_);
					goto __catch1_g_error;
				}
				_g_object_unref0 (_tmp7_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				const gchar* _tmp13_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_g_object_unref0 (self->theme_handle);
				self->theme_handle = NULL;
				_tmp12_ = e;
				_tmp13_ = _tmp12_->message;
				g_warning ("game-view.vala:156: Could not load theme %s: %s", theme_path, _tmp13_);
				_g_error_free0 (e);
				_g_object_unref0 (stream);
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp14_ = self->theme_handle;
		rsvg_handle_get_intrinsic_size_in_pixels (_tmp14_, &_tmp15_, &_tmp16_);
		width = _tmp15_;
		height = _tmp16_;
		self->initial_theme_width = (gint) width;
		self->initial_theme_height = (gint) height;
		self->loaded_theme_width = 0;
		self->loaded_theme_height = 0;
		_g_object_unref0 (stream);
	} else {
		RsvgHandle* _tmp17_;
		RsvgHandle* _tmp18_;
		GdkTexture* _tmp19_;
		GdkTexture* _tmp20_;
		cairo_pattern_t* _tmp21_;
		cairo_pattern_t* _tmp22_;
		_tmp17_ = game_view->theme_handle;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (self->theme_handle);
		self->theme_handle = _tmp18_;
		_tmp19_ = game_view->texture;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (self->texture);
		self->texture = _tmp20_;
		_tmp21_ = game_view->cairo_pattern;
		_tmp22_ = _cairo_pattern_reference0 (_tmp21_);
		_cairo_pattern_destroy0 (self->cairo_pattern);
		self->cairo_pattern = _tmp22_;
		self->initial_theme_width = game_view->initial_theme_width;
		self->initial_theme_height = game_view->initial_theme_height;
		self->loaded_theme_width = game_view->loaded_theme_width;
		self->loaded_theme_height = game_view->loaded_theme_height;
	}
	self->priv->using_vector = g_str_has_suffix (theme_path, "postmodern");
	self->priv->theme_aspect = (((gdouble) self->initial_theme_height) / 2) / (((gdouble) self->initial_theme_width) / 43);
	_tmp23_ = g_strdup (theme_path);
	_g_free0 (self->priv->theme);
	self->priv->theme = _tmp23_;
	game_view_resize_theme (self);
}

static void
game_view_get_theme_size (GameView* self,
                          gdouble* width,
                          gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gint* scale_factors = NULL;
	gint* _tmp0_;
	gint scale_factors_length1;
	gint _scale_factors_size_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gdouble scale = 0.0;
	GtkNative* _tmp3_;
	GdkSurface* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gint, 3);
	_tmp0_[0] = 8;
	_tmp0_[1] = 4;
	_tmp0_[2] = 2;
	scale_factors = _tmp0_;
	scale_factors_length1 = 3;
	_scale_factors_size_ = scale_factors_length1;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	_tmp1_ = scale_factors;
	_tmp1__length1 = scale_factors_length1;
	{
		gint* factor_collection = NULL;
		gint factor_collection_length1 = 0;
		gint _factor_collection_size_ = 0;
		gint factor_it = 0;
		factor_collection = _tmp1_;
		factor_collection_length1 = _tmp1__length1;
		for (factor_it = 0; factor_it < factor_collection_length1; factor_it = factor_it + 1) {
			gint factor = 0;
			factor = factor_collection[factor_it];
			{
				gint scaled_width = 0;
				scaled_width = self->initial_theme_width / factor;
				if (self->priv->rendered_theme_width < scaled_width) {
					_vala_width = (gdouble) scaled_width;
					_vala_height = (gdouble) (self->initial_theme_height / factor);
					break;
				}
			}
		}
	}
	if (_vala_width == ((gdouble) 0)) {
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			if (!(_vala_width < ((gdouble) self->priv->rendered_theme_width))) {
				break;
			}
			if (!self->priv->using_vector) {
				_tmp2_ = _vala_width > ((gdouble) self->initial_theme_width);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_vala_width = (gdouble) self->initial_theme_width;
				_vala_height = (gdouble) self->initial_theme_height;
				break;
			}
			_vala_width = _vala_width + self->initial_theme_width;
			_vala_height = _vala_height + self->initial_theme_height;
		}
	}
	_tmp3_ = gtk_widget_get_native ((GtkWidget*) self);
	_tmp4_ = gtk_native_get_surface (_tmp3_);
	scale = gdk_surface_get_scale (_tmp4_);
	_vala_width = _vala_width * scale;
	_vala_height = _vala_height * scale;
	scale_factors = (g_free (scale_factors), NULL);
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
game_view_resize_theme (GameView* self)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Game* _tmp2_;
	gdouble new_exact_theme_width = 0.0;
	gdouble new_exact_theme_height = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gint new_theme_width = 0;
	gint new_theme_height = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->theme;
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->rendered_theme_width == 0) {
		return;
	}
	game_view_get_theme_size (self, &_tmp4_, &_tmp5_);
	new_exact_theme_width = _tmp4_;
	new_exact_theme_height = _tmp5_;
	new_theme_width = (gint) new_exact_theme_width;
	new_theme_height = (gint) new_exact_theme_height;
	if (new_theme_width == self->loaded_theme_width) {
		return;
	}
	self->loaded_theme_width = new_theme_width;
	self->loaded_theme_height = new_theme_height;
	{
		cairo_surface_t* theme_surface = NULL;
		cairo_surface_t* _tmp6_;
		cairo_t* context = NULL;
		cairo_surface_t* _tmp7_;
		cairo_t* _tmp8_;
		RsvgRectangle rect = {0};
		RsvgRectangle _tmp9_ = {0};
		RsvgHandle* _tmp10_;
		cairo_t* _tmp11_;
		RsvgRectangle _tmp12_;
		_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, new_theme_width, new_theme_height);
		theme_surface = _tmp6_;
		_tmp7_ = theme_surface;
		_tmp8_ = cairo_create (_tmp7_);
		context = _tmp8_;
		memset (&_tmp9_, 0, sizeof (RsvgRectangle));
		_tmp9_.x = (gdouble) 0;
		_tmp9_.y = (gdouble) 0;
		_tmp9_.width = new_exact_theme_width;
		_tmp9_.height = new_exact_theme_height;
		rect = _tmp9_;
		_tmp10_ = self->theme_handle;
		_tmp11_ = context;
		_tmp12_ = rect;
		rsvg_handle_render_document (_tmp10_, _tmp11_, &_tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_cairo_destroy0 (context);
			_cairo_surface_destroy0 (theme_surface);
			goto __catch0_g_error;
		}
		if (self->priv->using_cairo) {
			cairo_surface_t* _tmp13_;
			cairo_pattern_t* _tmp14_;
			cairo_pattern_t* _tmp15_;
			_tmp13_ = theme_surface;
			_tmp14_ = cairo_pattern_create_for_surface (_tmp13_);
			_cairo_pattern_destroy0 (self->cairo_pattern);
			self->cairo_pattern = _tmp14_;
			_tmp15_ = self->cairo_pattern;
			cairo_pattern_set_filter (_tmp15_, CAIRO_FILTER_BILINEAR);
		} else {
			guchar* data = NULL;
			cairo_surface_t* _tmp16_;
			guchar* _tmp17_;
			gint data_length1;
			gint _data_size_;
			gint rowstride = 0;
			GdkMemoryFormat _tmp18_ = 0;
			GdkMemoryFormat format = 0;
			GdkMemoryTexture* new_texture = NULL;
			guchar* _tmp19_;
			gint _tmp19__length1;
			guint8* _tmp20_;
			gint _tmp20__length1;
			GBytes* _tmp21_;
			GBytes* _tmp22_;
			GdkMemoryTexture* _tmp23_;
			GdkMemoryTexture* _tmp24_;
			GdkMemoryTexture* _tmp25_;
			GdkTexture* _tmp26_;
			_tmp16_ = theme_surface;
			_tmp17_ = cairo_image_surface_get_data (_tmp16_);
			data = _tmp17_;
			data_length1 = -1;
			_data_size_ = data_length1;
			rowstride = new_theme_width * 4;
			if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
				_tmp18_ = GDK_MEMORY_B8G8R8A8_PREMULTIPLIED;
			} else {
				_tmp18_ = GDK_MEMORY_A8R8G8B8_PREMULTIPLIED;
			}
			format = _tmp18_;
			data_length1 = new_theme_height * rowstride;
			_tmp19_ = data;
			_tmp19__length1 = data_length1;
			_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup3 (_tmp19_, _tmp19__length1) : _tmp19_;
			_tmp20__length1 = _tmp19__length1;
			_tmp21_ = g_bytes_new_take (_tmp20_, _tmp20__length1);
			_tmp22_ = _tmp21_;
			_tmp23_ = (GdkMemoryTexture*) gdk_memory_texture_new (new_theme_width, new_theme_height, format, _tmp22_, (gsize) rowstride);
			_tmp24_ = _tmp23_;
			_g_bytes_unref0 (_tmp22_);
			new_texture = _tmp24_;
			_tmp25_ = new_texture;
			_tmp26_ = _g_object_ref0 ((GdkTexture*) _tmp25_);
			_g_object_unref0 (self->texture);
			self->texture = _tmp26_;
			_g_object_unref0 (new_texture);
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (theme_surface);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp27_;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = self->priv->theme;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("game-view.vala:275: Could not load theme %s: %s", _tmp27_, _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
game_view_update_dimensions (GameView* self)
{
	const gchar* _tmp0_;
	gint width = 0;
	gint height = 0;
	gfloat h_border = 0.0F;
	gfloat v_border = 0.0F;
	gfloat map_width = 0.0F;
	Game* _tmp1_;
	Game* _tmp2_;
	Map* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	Map* _tmp8_;
	gdouble map_height = 0.0;
	Game* _tmp9_;
	Game* _tmp10_;
	Map* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Game* _tmp14_;
	Game* _tmp15_;
	Map* _tmp16_;
	gint unit_width = 0;
	gint unit_height = 0;
	Game* _tmp17_;
	Game* _tmp18_;
	Map* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	Game* _tmp22_;
	Game* _tmp23_;
	Map* _tmp24_;
	Game* _tmp25_;
	Game* _tmp26_;
	Map* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	Game* _tmp30_;
	Game* _tmp31_;
	Map* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->theme;
	if (_tmp0_ == NULL) {
		return;
	}
	width = gtk_widget_get_width ((GtkWidget*) self);
	height = gtk_widget_get_height ((GtkWidget*) self);
	h_border = ((gfloat) width) / 220;
	v_border = ((gfloat) height) / 560;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->map;
	_tmp4_ = map_get_width (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_view_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->map;
	map_width = (_tmp5_ + (_tmp8_->h_overhang / 4)) + h_border;
	_tmp9_ = game_view_get_game (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_->map;
	_tmp12_ = map_get_height (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_->map;
	map_height = ((_tmp13_ + (_tmp16_->v_overhang / 4)) + v_border) * self->priv->theme_aspect;
	unit_width = (gint) MIN ((gdouble) (width / map_width), height / map_height);
	unit_height = (gint) (unit_width * self->priv->theme_aspect);
	self->priv->tile_width = unit_width * 2;
	self->priv->tile_height = unit_height * 2;
	self->priv->tile_layer_offset_x = self->priv->tile_width / 7;
	self->priv->tile_layer_offset_y = self->priv->tile_height / 10;
	_tmp17_ = game_view_get_game (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_->map;
	_tmp20_ = map_get_width (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = game_view_get_game (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_->map;
	self->priv->x_offset = ((gint) (width - ((_tmp21_ + (_tmp24_->h_overhang / 4)) * unit_width))) / 2;
	_tmp25_ = game_view_get_game (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_->map;
	_tmp28_ = map_get_height (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = game_view_get_game (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_->map;
	self->priv->y_offset = ((gint) (height - ((_tmp29_ * unit_height) - ((_tmp32_->v_overhang * unit_height) / 8)))) / 2;
	self->priv->tile_pattern_width = self->priv->tile_width + self->priv->tile_layer_offset_x;
	self->priv->tile_pattern_height = self->priv->tile_height + self->priv->tile_layer_offset_y;
	self->priv->rendered_theme_width = self->priv->tile_pattern_width * 43;
	self->priv->rendered_theme_height = self->priv->tile_pattern_height * 2;
}

static void
game_view_get_tile_position (GameView* self,
                             Tile* tile,
                             gint* x,
                             gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	Slot* _tmp0_;
	Slot* _tmp1_;
	Slot* _tmp2_;
	Slot* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = tile->slot;
	_tmp1_ = tile->slot;
	_vala_x = (self->priv->x_offset + ((_tmp0_->x * self->priv->tile_width) / 2)) + (_tmp1_->layer * self->priv->tile_layer_offset_x);
	_tmp2_ = tile->slot;
	_tmp3_ = tile->slot;
	_vala_y = (self->priv->y_offset + ((_tmp2_->y * self->priv->tile_height) / 2)) - (_tmp3_->layer * self->priv->tile_layer_offset_y);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static gint
game_view_get_image_offset (GameView* self,
                            gint number)
{
	gint set = 0;
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	set = number / 4;
	if (number < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = set >= 36;
	}
	if (_tmp0_) {
		result = 42;
		return result;
	}
	if (set == 33) {
		result = 33 + (number % 4);
		return result;
	}
	if (set == 35) {
		result = 38 + (number % 4);
		return result;
	}
	if (set == 34) {
		result = 37;
		return result;
	}
	result = set;
	return result;
}

static gboolean
__lambda4_ (GameView* self,
            GtkWidget* widget,
            GdkFrameClock* frame_clock)
{
	gboolean animating = FALSE;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	animating = FALSE;
	{
		GameIterator* _t_it = NULL;
		Game* _tmp0_;
		Game* _tmp1_;
		GameIterator* _tmp2_;
		_tmp0_ = game_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = game_iterator (_tmp1_);
		_t_it = _tmp2_;
		while (TRUE) {
			GameIterator* _tmp3_;
			Tile* t = NULL;
			GameIterator* _tmp4_;
			Tile* _tmp5_;
			Tile* _tmp6_;
			gdouble elapsed_ms = 0.0;
			Tile* _tmp7_;
			gdouble elapsed_s = 0.0;
			gdouble amplitude = 0.0;
			Tile* _tmp11_;
			_tmp3_ = _t_it;
			if (!game_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _t_it;
			_tmp5_ = game_iterator_get (_tmp4_);
			t = _tmp5_;
			_tmp6_ = t;
			if (!_tmp6_->shaking) {
				continue;
			}
			_tmp7_ = t;
			elapsed_ms = (gdk_frame_clock_get_frame_time (frame_clock) - _tmp7_->shake_start_time) / 1000;
			elapsed_s = elapsed_ms / 1000;
			if (elapsed_ms > ((gdouble) GAME_VIEW_TILE_SHAKE_DURATION_MS)) {
				Tile* _tmp8_;
				Tile* _tmp9_;
				Tile* _tmp10_;
				_tmp8_ = t;
				_tmp8_->shaking = FALSE;
				_tmp9_ = t;
				_tmp9_->shake_offset = 0;
				_tmp10_ = t;
				_tmp10_->shake_start_time = 0.0;
				continue;
			}
			amplitude = fmax ((gdouble) GAME_VIEW_MIN_TILE_SHAKE_AMPLITUDE, self->priv->tile_width * GAME_VIEW_TILE_SHAKE_SCALE_FACTOR);
			_tmp11_ = t;
			_tmp11_->shake_offset = (gint) (amplitude * sin (((2 * G_PI) * GAME_VIEW_TILE_SHAKE_FREQUENCY) * elapsed_s));
			animating = TRUE;
		}
		_game_iterator_unref0 (_t_it);
	}
	if (!animating) {
		self->priv->tick_id = (guint) 0;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = animating;
	return result;
}

static gboolean
___lambda4__gtk_tick_callback (GtkWidget* widget,
                               GdkFrameClock* frame_clock,
                               gpointer self)
{
	gboolean result;
	result = __lambda4_ ((GameView*) self, widget, frame_clock);
	return result;
}

static void
game_view_redraw_tile_cb (GameView* self,
                          Tile* tile)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	if (!tile->shaking) {
		gtk_widget_queue_draw ((GtkWidget*) self);
		return;
	}
	if (self->priv->tick_id != ((guint) 0)) {
		return;
	}
	self->priv->tick_id = gtk_widget_add_tick_callback ((GtkWidget*) self, ___lambda4__gtk_tick_callback, g_object_ref (self), g_object_unref);
}

static void
game_view_paused_changed_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
game_view_click_cb (GameView* self,
                    GtkGestureClick* _controller,
                    gint n_press,
                    gdouble event_x,
                    gdouble event_y)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	Game* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean click_blocked = FALSE;
	Tile* tile = NULL;
	Tile* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Tile* _tmp25_;
	Tile* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	Game* _tmp33_;
	Game* _tmp34_;
	Tile* _tmp35_;
	Tile* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_controller != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_inspecting (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		Game* _tmp8_;
		Game* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = game_view_get_game (self);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (_tmp9_, "attempt-move", &_tmp10_);
		_tmp3_ = !_tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Game* _tmp11_;
		Game* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = game_view_get_game (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = game_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	click_blocked = _tmp2_;
	if (click_blocked) {
		return;
	}
	_tmp15_ = game_view_find_tile (self, (gint) event_x, (gint) event_y);
	tile = _tmp15_;
	if (n_press == 2) {
		Tile* _tmp18_;
		_tmp18_ = tile;
		_tmp17_ = _tmp18_ == NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		Game* _tmp19_;
		Game* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = game_view_get_game (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = game_get_all_tiles_unblocked (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Game* _tmp23_;
		Game* _tmp24_;
		_tmp23_ = game_view_get_game (self);
		_tmp24_ = _tmp23_;
		game_autoplay_end_game (_tmp24_);
	}
	_tmp25_ = tile;
	if (_tmp25_ == NULL) {
		_tile_unref0 (tile);
		return;
	}
	_tmp26_ = tile;
	_tmp27_ = tile_get_selectable (_tmp26_);
	_tmp28_ = _tmp27_;
	if (!_tmp28_) {
		gint64 start_time = 0LL;
		GdkFrameClock* _tmp29_;
		Game* _tmp30_;
		Game* _tmp31_;
		Tile* _tmp32_;
		_tmp29_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
		start_time = gdk_frame_clock_get_frame_time (_tmp29_);
		_tmp30_ = game_view_get_game (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = tile;
		game_shake_tile (_tmp31_, _tmp32_, start_time);
		_tile_unref0 (tile);
		return;
	}
	_tmp33_ = game_view_get_game (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = game_get_selected_tile (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == NULL) {
		Game* _tmp37_;
		Game* _tmp38_;
		Tile* _tmp39_;
		_tmp37_ = game_view_get_game (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = tile;
		game_set_selected_tile (_tmp38_, _tmp39_);
	} else {
		Tile* _tmp40_;
		Game* _tmp41_;
		Game* _tmp42_;
		Tile* _tmp43_;
		Tile* _tmp44_;
		_tmp40_ = tile;
		_tmp41_ = game_view_get_game (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = game_get_selected_tile (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp40_ == _tmp44_) {
			Game* _tmp45_;
			Game* _tmp46_;
			_tmp45_ = game_view_get_game (self);
			_tmp46_ = _tmp45_;
			game_set_selected_tile (_tmp46_, NULL);
		} else {
			Tile* _tmp47_;
			Game* _tmp48_;
			Game* _tmp49_;
			Tile* _tmp50_;
			Tile* _tmp51_;
			_tmp47_ = tile;
			_tmp48_ = game_view_get_game (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = game_get_selected_tile (_tmp49_);
			_tmp51_ = _tmp50_;
			if (tile_matches (_tmp47_, _tmp51_)) {
				Game* _tmp52_;
				Game* _tmp53_;
				Game* _tmp54_;
				Game* _tmp55_;
				Tile* _tmp56_;
				Tile* _tmp57_;
				Tile* _tmp58_;
				_tmp52_ = game_view_get_game (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = game_view_get_game (self);
				_tmp55_ = _tmp54_;
				_tmp56_ = game_get_selected_tile (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = tile;
				game_remove_pair (_tmp53_, _tmp57_, _tmp58_);
			} else {
				Game* _tmp59_;
				Game* _tmp60_;
				Tile* _tmp61_;
				_tmp59_ = game_view_get_game (self);
				_tmp60_ = _tmp59_;
				_tmp61_ = tile;
				game_set_selected_tile (_tmp60_, _tmp61_);
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tile_unref0 (tile);
}

static gpointer
_tile_ref0 (gpointer self)
{
	return self ? tile_ref (self) : NULL;
}

static Tile*
game_view_find_tile (GameView* self,
                     gint x,
                     gint y)
{
	Tile* topmost_tile = NULL;
	gint previous_layer = 0;
	Tile* _tmp17_;
	Tile* _tmp18_;
	Tile* result;
	g_return_val_if_fail (self != NULL, NULL);
	topmost_tile = NULL;
	previous_layer = -1;
	{
		GameIterator* _tile_it = NULL;
		Game* _tmp0_;
		Game* _tmp1_;
		GameIterator* _tmp2_;
		_tmp0_ = game_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = game_iterator (_tmp1_);
		_tile_it = _tmp2_;
		while (TRUE) {
			GameIterator* _tmp3_;
			Tile* tile = NULL;
			GameIterator* _tmp4_;
			Tile* _tmp5_;
			Tile* _tmp6_;
			gint tile_x = 0;
			gint tile_y = 0;
			Tile* _tmp7_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			Tile* _tmp12_;
			Slot* _tmp13_;
			_tmp3_ = _tile_it;
			if (!game_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _tile_it;
			_tmp5_ = game_iterator_get (_tmp4_);
			tile = _tmp5_;
			_tmp6_ = tile;
			if (!_tmp6_->visible) {
				continue;
			}
			_tmp7_ = tile;
			game_view_get_tile_position (self, _tmp7_, &_tmp8_, &_tmp9_);
			tile_x = _tmp8_;
			tile_y = _tmp9_;
			_tmp12_ = tile;
			_tmp13_ = _tmp12_->slot;
			if (_tmp13_->layer > previous_layer) {
				gint _tmp14_;
				_tmp14_ = x;
				_tmp11_ = (tile_x <= _tmp14_) && (_tmp14_ <= (tile_x + self->priv->tile_pattern_width));
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gint _tmp15_;
				_tmp15_ = y;
				_tmp10_ = (tile_y <= _tmp15_) && (_tmp15_ <= (tile_y + self->priv->tile_pattern_height));
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				Tile* _tmp16_;
				_tmp16_ = tile;
				topmost_tile = _tmp16_;
			}
		}
		_game_iterator_unref0 (_tile_it);
	}
	_tmp17_ = topmost_tile;
	_tmp18_ = _tile_ref0 (_tmp17_);
	result = _tmp18_;
	return result;
}

Game*
game_view_get_game (GameView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static gpointer
_game_ref0 (gpointer self)
{
	return self ? game_ref (self) : NULL;
}

static void
_game_view_redraw_tile_cb_game_redraw_tile (Game* _sender,
                                            Tile* tile,
                                            gpointer self)
{
	game_view_redraw_tile_cb ((GameView*) self, tile);
}

static void
_game_view_paused_changed_cb_game_paused_changed (Game* _sender,
                                                  gpointer self)
{
	game_view_paused_changed_cb ((GameView*) self);
}

void
game_view_set_game (GameView* self,
                    Game* value)
{
	Game* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->tick_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->tick_id);
		self->priv->tick_id = (guint) 0;
	}
	_tmp0_ = _game_ref0 (value);
	_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp0_;
	if (value == NULL) {
		return;
	}
	_tmp1_ = self->priv->_game;
	g_signal_connect_object (_tmp1_, "redraw-tile", (GCallback) _game_view_redraw_tile_cb_game_redraw_tile, self, 0);
	_tmp2_ = self->priv->_game;
	g_signal_connect_object (_tmp2_, "paused-changed", (GCallback) _game_view_paused_changed_cb_game_paused_changed, self, 0);
	game_view_update_dimensions (self);
	game_view_resize_theme (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) game_view_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = param_spec_game ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	self->priv = game_view_get_instance_private (self);
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->theme_handle);
	_g_object_unref0 (self->texture);
	_cairo_pattern_destroy0 (self->cairo_pattern);
	_g_free0 (self->priv->theme);
	_game_unref0 (self->priv->_game);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (gtk_widget_get_type (), "GameView", &g_define_type_info, 0);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

static void
_vala_game_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		value_set_game (value, game_view_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, value_get_game (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

