/* print-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#define SUDOKU_PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
#define SUDOKU_PRINT_DIALOG_MAX_PUZZLES_PER_PAGE 15
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_PRINT_DIALOG (sudoku_print_dialog_get_type ())
#define SUDOKU_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialog))
#define SUDOKU_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialogClass))
#define IS_SUDOKU_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINT_DIALOG))
#define IS_SUDOKU_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINT_DIALOG))
#define SUDOKU_PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialogClass))

typedef struct _SudokuPrintDialog SudokuPrintDialog;
typedef struct _SudokuPrintDialogClass SudokuPrintDialogClass;
typedef struct _SudokuPrintDialogPrivate SudokuPrintDialogPrivate;

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
enum  {
	SUDOKU_PRINT_DIALOG_0_PROPERTY,
	SUDOKU_PRINT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* sudoku_print_dialog_properties[SUDOKU_PRINT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SudokuPrintDialog {
	AdwDialog parent_instance;
	SudokuPrintDialogPrivate * priv;
};

struct _SudokuPrintDialogClass {
	AdwDialogClass parent_class;
};

struct _SudokuPrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkButton* print_button;
	AdwPreferencesGroup* options_group;
	AdwSpinRow* n_puzzles;
	AdwSpinRow* n_puzzles_per_page;
	AdwComboRow* difficulty;
	GCancellable* cancellable;
	SudokuWindow* window;
};

struct _Block5Data {
	int _ref_count_;
	SudokuPrintDialog* self;
	GtkAdjustment* total;
	GtkAdjustment* per_page;
};

struct _Block6Data {
	int _ref_count_;
	SudokuPrintDialog* self;
	gint npuzzles_per_page;
};

static gint SudokuPrintDialog_private_offset;
static gpointer sudoku_print_dialog_parent_class = NULL;

VALA_EXTERN GType sudoku_print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrintDialog, g_object_unref)
VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN SudokuPrintDialog* sudoku_print_dialog_new (SudokuSaver* saver,
                                            SudokuWindow* window);
VALA_EXTERN SudokuPrintDialog* sudoku_print_dialog_construct (GType object_type,
                                                  SudokuSaver* saver,
                                                  SudokuWindow* window);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda12_ (Block5Data* _data5_);
static void ___lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda13_ (Block5Data* _data5_);
static void ___lambda13__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda14_ (SudokuPrintDialog* self);
VALA_EXTERN void sudoku_print_dialog_print (SudokuPrintDialog* self);
static void ___lambda14__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda15_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self,
                                                     GtkWindow* window);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void sudoku_print_dialog_finalize (GObject * obj);
static GType sudoku_print_dialog_get_type_once (void);

static inline gpointer
sudoku_print_dialog_get_instance_private (SudokuPrintDialog* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuPrintDialog_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SudokuPrintDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->per_page);
		_g_object_unref0 (_data5_->total);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda12_ (Block5Data* _data5_)
{
	SudokuPrintDialog* self;
	gint total_value = 0;
	GSettings* _tmp0_;
	gint max_per_page = 0;
	gint per_page_value = 0;
	self = _data5_->self;
	total_value = (gint) gtk_adjustment_get_value (_data5_->total);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print", total_value);
	max_per_page = MIN (SUDOKU_PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, total_value);
	per_page_value = (gint) gtk_adjustment_get_value (_data5_->per_page);
	per_page_value = MIN (per_page_value, max_per_page);
	gtk_adjustment_set_upper (_data5_->per_page, (gdouble) max_per_page);
	gtk_adjustment_set_value (_data5_->per_page, (gdouble) per_page_value);
}

static void
___lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda12_ (self);
}

static void
__lambda13_ (Block5Data* _data5_)
{
	SudokuPrintDialog* self;
	gint per_page_value = 0;
	GSettings* _tmp0_;
	self = _data5_->self;
	per_page_value = (gint) gtk_adjustment_get_value (_data5_->per_page);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print-per-page", per_page_value);
}

static void
___lambda13__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda13_ (self);
}

static void
__lambda14_ (SudokuPrintDialog* self)
{
	sudoku_print_dialog_print (self);
}

static void
___lambda14__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda14_ ((SudokuPrintDialog*) self);
}

SudokuPrintDialog*
sudoku_print_dialog_construct (GType object_type,
                               SudokuSaver* saver,
                               SudokuWindow* window)
{
	SudokuPrintDialog * self = NULL;
	Block5Data* _data5_;
	SudokuWindow* _tmp0_;
	SudokuSaver* _tmp1_;
	GSettings* _tmp2_;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp3_;
	AdwComboRow* _tmp4_;
	gint initial_total_value = 0;
	GSettings* _tmp5_;
	gint initial_per_page_value = 0;
	GSettings* _tmp6_;
	AdwSpinRow* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	AdwSpinRow* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
	gint initial_max_per_page = 0;
	GtkButton* _tmp13_;
	g_return_val_if_fail (saver != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	self = (SudokuPrintDialog*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp0_;
	_tmp1_ = _g_object_ref0 (saver);
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = self->priv->settings;
	saved_difficulty = (DifficultyCategory) g_settings_get_enum (_tmp3_, SUDOKU_PRINT_DIALOG_DIFFICULTY_KEY_NAME);
	_tmp4_ = self->priv->difficulty;
	adw_combo_row_set_selected (_tmp4_, (guint) (((gint) saved_difficulty) - 1));
	_tmp5_ = self->priv->settings;
	initial_total_value = g_settings_get_int (_tmp5_, "print-multiple-sudokus-to-print");
	_tmp6_ = self->priv->settings;
	initial_per_page_value = g_settings_get_int (_tmp6_, "print-multiple-sudokus-to-print-per-page");
	_tmp7_ = self->priv->n_puzzles;
	_tmp8_ = adw_spin_row_get_adjustment (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_data5_->total = _tmp9_;
	_tmp10_ = self->priv->n_puzzles_per_page;
	_tmp11_ = adw_spin_row_get_adjustment (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_data5_->per_page = _tmp12_;
	gtk_adjustment_set_value (_data5_->total, (gdouble) initial_total_value);
	initial_max_per_page = MIN (SUDOKU_PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, initial_total_value);
	gtk_adjustment_set_value (_data5_->per_page, (gdouble) MIN (initial_max_per_page, initial_per_page_value));
	gtk_adjustment_set_upper (_data5_->per_page, (gdouble) initial_max_per_page);
	g_signal_connect_data (_data5_->total, "value-changed", (GCallback) ___lambda12__gtk_adjustment_value_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (_data5_->per_page, "value-changed", (GCallback) ___lambda13__gtk_adjustment_value_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp13_ = self->priv->print_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda14__gtk_button_clicked, self, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}

SudokuPrintDialog*
sudoku_print_dialog_new (SudokuSaver* saver,
                         SudokuWindow* window)
{
	return sudoku_print_dialog_construct (TYPE_SUDOKU_PRINT_DIALOG, saver, window);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SudokuPrintDialog* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda15_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	SudokuPrintDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GeeList* boards = NULL;
		GeeList* _tmp0_;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp1_;
		SudokuPrinter* _tmp2_;
		SudokuWindow* _tmp3_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = sudoku_printer_new (boards, _data6_->npuzzles_per_page);
		printer = _tmp1_;
		_tmp2_ = printer;
		_tmp3_ = self->priv->window;
		if (sudoku_printer_print_sudoku (_tmp2_, (GtkWindow*) _tmp3_) == GTK_PRINT_OPERATION_RESULT_APPLY) {
			{
				GeeList* _board_list = NULL;
				gint _board_size = 0;
				GeeList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _board_index = 0;
				_board_list = boards;
				_tmp4_ = _board_list;
				_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_board_size = _tmp6_;
				_board_index = -1;
				while (TRUE) {
					gint _tmp7_;
					gint _tmp8_;
					SudokuBoard* board = NULL;
					GeeList* _tmp9_;
					gpointer _tmp10_;
					SudokuSaver* _tmp11_;
					SudokuBoard* _tmp12_;
					SudokuGame* _tmp13_;
					SudokuGame* _tmp14_;
					_board_index = _board_index + 1;
					_tmp7_ = _board_index;
					_tmp8_ = _board_size;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = _board_list;
					_tmp10_ = gee_list_get (_tmp9_, _board_index);
					board = (SudokuBoard*) _tmp10_;
					_tmp11_ = self->priv->saver;
					_tmp12_ = board;
					_tmp13_ = sudoku_game_new (_tmp12_);
					_tmp14_ = _tmp13_;
					sudoku_saver_add_game_to_finished (_tmp11_, _tmp14_, FALSE, TRUE);
					_g_object_unref0 (_tmp14_);
					_g_object_unref0 (board);
				}
			}
		}
		_g_object_unref0 (printer);
		_g_object_unref0 (boards);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e->message;
		g_error ("print-dialog.vala:108: Thread error: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		if (!g_error_matches (_tmp16_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("print-dialog.vala:113: Error: %s\n", _tmp18_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	adw_dialog_close ((AdwDialog*) self);
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block6_data_unref (self);
}

void
sudoku_print_dialog_print (SudokuPrintDialog* self)
{
	Block6Data* _data6_;
	gint npuzzles = 0;
	AdwSpinRow* _tmp0_;
	GtkAdjustment* _tmp1_;
	AdwSpinRow* _tmp2_;
	GtkAdjustment* _tmp3_;
	DifficultyCategory level = 0;
	AdwComboRow* _tmp4_;
	GSettings* _tmp5_;
	GtkButton* _tmp6_;
	AdwPreferencesGroup* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->n_puzzles;
	_tmp1_ = adw_spin_row_get_adjustment (_tmp0_);
	npuzzles = (gint) gtk_adjustment_get_value (_tmp1_);
	_tmp2_ = self->priv->n_puzzles_per_page;
	_tmp3_ = adw_spin_row_get_adjustment (_tmp2_);
	_data6_->npuzzles_per_page = (gint) gtk_adjustment_get_value (_tmp3_);
	_tmp4_ = self->priv->difficulty;
	level = ((DifficultyCategory) adw_combo_row_get_selected (_tmp4_)) + 1;
	_tmp5_ = self->priv->settings;
	g_settings_set_enum (_tmp5_, SUDOKU_PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) level);
	_tmp6_ = self->priv->print_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	_tmp7_ = self->priv->options_group;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp8_;
	_tmp9_ = self->priv->cancellable;
	sudoku_generator_generate_boards_async (npuzzles, level, _tmp9_, ___lambda15__gasync_ready_callback, block6_data_ref (_data6_));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
sudoku_print_dialog_class_init (SudokuPrintDialogClass * klass,
                                gpointer klass_data)
{
	sudoku_print_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuPrintDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sudoku_print_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/print-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_button", FALSE, SudokuPrintDialog_private_offset + G_STRUCT_OFFSET (SudokuPrintDialogPrivate, print_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "options_group", FALSE, SudokuPrintDialog_private_offset + G_STRUCT_OFFSET (SudokuPrintDialogPrivate, options_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_puzzles", FALSE, SudokuPrintDialog_private_offset + G_STRUCT_OFFSET (SudokuPrintDialogPrivate, n_puzzles));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_puzzles_per_page", FALSE, SudokuPrintDialog_private_offset + G_STRUCT_OFFSET (SudokuPrintDialogPrivate, n_puzzles_per_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "difficulty", FALSE, SudokuPrintDialog_private_offset + G_STRUCT_OFFSET (SudokuPrintDialogPrivate, difficulty));
}

static void
sudoku_print_dialog_instance_init (SudokuPrintDialog * self,
                                   gpointer klass)
{
	self->priv = sudoku_print_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sudoku_print_dialog_finalize (GObject * obj)
{
	SudokuPrintDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialog);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (sudoku_print_dialog_parent_class)->finalize (obj);
}

static GType
sudoku_print_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuPrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrintDialog), 0, (GInstanceInitFunc) sudoku_print_dialog_instance_init, NULL };
	GType sudoku_print_dialog_type_id;
	sudoku_print_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "SudokuPrintDialog", &g_define_type_info, 0);
	SudokuPrintDialog_private_offset = g_type_add_instance_private (sudoku_print_dialog_type_id, sizeof (SudokuPrintDialogPrivate));
	return sudoku_print_dialog_type_id;
}

GType
sudoku_print_dialog_get_type (void)
{
	static volatile gsize sudoku_print_dialog_type_id__once = 0;
	if (g_once_init_enter (&sudoku_print_dialog_type_id__once)) {
		GType sudoku_print_dialog_type_id;
		sudoku_print_dialog_type_id = sudoku_print_dialog_get_type_once ();
		g_once_init_leave (&sudoku_print_dialog_type_id__once, sudoku_print_dialog_type_id);
	}
	return sudoku_print_dialog_type_id__once;
}

