/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_tagged_decoder = R"doc(General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

Constructor Specific Documentation:

Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

Args:
    my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
    input_item_size : The size of the input items (often the my_decoder object can tell us this).
    output_item_size : The size of the output items (often the my_decoder object can tell us this).
    lengthtagname : Key name of the tagged stream frame size.
    mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_tagged_decoder_tagged_decoder_0 = R"doc()doc";


static const char* __doc_gr_fec_tagged_decoder_tagged_decoder_1 = R"doc()doc";


static const char* __doc_gr_fec_tagged_decoder_make = R"doc(General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

Constructor Specific Documentation:

Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

Args:
    my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
    input_item_size : The size of the input items (often the my_decoder object can tell us this).
    output_item_size : The size of the output items (often the my_decoder object can tell us this).
    lengthtagname : Key name of the tagged stream frame size.
    mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_tagged_decoder_work = R"doc(Just like gr::block::general_work, but makes sure the input is valid.

The user must override work to define the signal processing code. Check the documentation for general_work() to see what happens here.


Like gr::sync_block, this calls consume() for you (it consumes ninput_items[i] items from the i-th port).


A note on tag propagation: The PDU length tags are handled by other functions, but all other tags are handled just as in any other . So, most likely, you either set the tag propagation policy to TPP_DONT and handle the tag propagation manually, or you propagate tags through the scheduler and don't do anything here.)doc";


static const char* __doc_gr_fec_tagged_decoder_calculate_output_stream_length =
    R"doc()doc";
