{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Contains information that is useful to compute the size of a drag surface.
-- 
-- /Since: 4.12/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.DragSurfaceSize
    ( 

-- * Exported types
    DragSurfaceSize(..)                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- [setSize]("GI.Gdk.Structs.DragSurfaceSize#g:method:setSize").

#if defined(ENABLE_OVERLOADING)
    ResolveDragSurfaceSizeMethod            ,
#endif

-- ** setSize #method:setSize#

#if defined(ENABLE_OVERLOADING)
    DragSurfaceSizeSetSizeMethodInfo        ,
#endif
    dragSurfaceSizeSetSize                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype DragSurfaceSize = DragSurfaceSize (SP.ManagedPtr DragSurfaceSize)
    deriving (Eq)

instance SP.ManagedPtrNewtype DragSurfaceSize where
    toManagedPtr (DragSurfaceSize p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr DragSurfaceSize where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DragSurfaceSize
type instance O.AttributeList DragSurfaceSize = DragSurfaceSizeAttributeList
type DragSurfaceSizeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method DragSurfaceSize::set_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragSurfaceSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDragSurfaceSize`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_surface_size_set_size" gdk_drag_surface_size_set_size :: 
    Ptr DragSurfaceSize ->                  -- size : TInterface (Name {namespace = "Gdk", name = "DragSurfaceSize"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the size the drag surface prefers to be resized to.
-- 
-- /Since: 4.12/
dragSurfaceSizeSetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DragSurfaceSize
    -- ^ /@size@/: a @GdkDragSurfaceSize@
    -> Int32
    -- ^ /@width@/: the width
    -> Int32
    -- ^ /@height@/: the height
    -> m ()
dragSurfaceSizeSetSize size width height = liftIO $ do
    size' <- unsafeManagedPtrGetPtr size
    gdk_drag_surface_size_set_size size' width height
    touchManagedPtr size
    return ()

#if defined(ENABLE_OVERLOADING)
data DragSurfaceSizeSetSizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod DragSurfaceSizeSetSizeMethodInfo DragSurfaceSize signature where
    overloadedMethod = dragSurfaceSizeSetSize

instance O.OverloadedMethodInfo DragSurfaceSizeSetSizeMethodInfo DragSurfaceSize where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.DragSurfaceSize.dragSurfaceSizeSetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-DragSurfaceSize.html#v:dragSurfaceSizeSetSize"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDragSurfaceSizeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDragSurfaceSizeMethod "setSize" o = DragSurfaceSizeSetSizeMethodInfo
    ResolveDragSurfaceSizeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDragSurfaceSizeMethod t DragSurfaceSize, O.OverloadedMethod info DragSurfaceSize p) => OL.IsLabel t (DragSurfaceSize -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDragSurfaceSizeMethod t DragSurfaceSize, O.OverloadedMethod info DragSurfaceSize p, R.HasField t DragSurfaceSize p) => R.HasField t DragSurfaceSize p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDragSurfaceSizeMethod t DragSurfaceSize, O.OverloadedMethodInfo info DragSurfaceSize) => OL.IsLabel t (O.MethodProxy info DragSurfaceSize) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


