{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node that can contain other render nodes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ContainerNode
    ( 

-- * Exported types
    ContainerNode(..)                       ,
    IsContainerNode                         ,
    toContainerNode                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.ContainerNode#g:method:getChild"), [getNChildren]("GI.Gsk.Objects.ContainerNode#g:method:getNChildren"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveContainerNodeMethod              ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ContainerNodeGetChildMethodInfo         ,
#endif
    containerNodeGetChild                   ,


-- ** getNChildren #method:getNChildren#

#if defined(ENABLE_OVERLOADING)
    ContainerNodeGetNChildrenMethodInfo     ,
#endif
    containerNodeGetNChildren               ,


-- ** new #method:new#

    containerNodeNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype ContainerNode = ContainerNode (SP.ManagedPtr ContainerNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ContainerNode where
    toManagedPtr (ContainerNode p) = p

foreign import ccall "gsk_container_node_get_type"
    c_gsk_container_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ContainerNode where
    glibType = c_gsk_container_node_get_type

-- | Type class for types which can be safely cast to t'ContainerNode', for instance with `toContainerNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ContainerNode o) => IsContainerNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ContainerNode o) => IsContainerNode o

instance O.HasParentTypes ContainerNode
type instance O.ParentTypes ContainerNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ContainerNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toContainerNode :: (MIO.MonadIO m, IsContainerNode o) => o -> m ContainerNode
toContainerNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ContainerNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveContainerNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveContainerNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveContainerNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveContainerNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveContainerNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveContainerNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveContainerNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveContainerNodeMethod "getChild" o = ContainerNodeGetChildMethodInfo
    ResolveContainerNodeMethod "getNChildren" o = ContainerNodeGetNChildrenMethodInfo
    ResolveContainerNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveContainerNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveContainerNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveContainerNodeMethod t ContainerNode, O.OverloadedMethod info ContainerNode p) => OL.IsLabel t (ContainerNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveContainerNodeMethod t ContainerNode, O.OverloadedMethod info ContainerNode p, R.HasField t ContainerNode p) => R.HasField t ContainerNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveContainerNodeMethod t ContainerNode, O.OverloadedMethodInfo info ContainerNode) => OL.IsLabel t (O.MethodProxy info ContainerNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ContainerNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ContainerNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "children"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The children of the node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_children"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Number of children in the @children array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_children"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "Number of children in the @children array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "ContainerNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_container_node_new" gsk_container_node_new :: 
    Ptr (Ptr Gsk.RenderNode.RenderNode) ->  -- children : TCArray False (-1) 1 (TInterface (Name {namespace = "Gsk", name = "RenderNode"}))
    Word32 ->                               -- n_children : TBasicType TUInt
    IO (Ptr ContainerNode)

-- | Creates a new @GskRenderNode@ instance for holding the given /@children@/.
-- 
-- The new node will acquire a reference to each of the children.
containerNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Gsk.RenderNode.RenderNode]
    -- ^ /@children@/: The children of the node
    -> m ContainerNode
    -- ^ __Returns:__ the new @GskRenderNode@
containerNodeNew children = liftIO $ do
    let nChildren = fromIntegral $ P.length children
    children' <- mapM unsafeManagedPtrCastPtr children
    children'' <- packPtrArray children'
    result <- gsk_container_node_new children'' nChildren
    checkUnexpectedReturnNULL "containerNodeNew" result
    result' <- (wrapPtr ContainerNode) result
    mapM_ touchManagedPtr children
    freeMem children''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ContainerNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ContainerNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a container `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the child to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_container_node_get_child" gsk_container_node_get_child :: 
    Ptr ContainerNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "ContainerNode"})
    Word32 ->                               -- idx : TBasicType TUInt
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets one of the children of /@container@/.
containerNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsContainerNode a) =>
    a
    -- ^ /@node@/: a container @GskRenderNode@
    -> Word32
    -- ^ /@idx@/: the position of the child to get
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the /@idx@/\'th child of /@container@/
containerNodeGetChild node idx = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_container_node_get_child node' idx
    checkUnexpectedReturnNULL "containerNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ContainerNodeGetChildMethodInfo
instance (signature ~ (Word32 -> m Gsk.RenderNode.RenderNode), MonadIO m, IsContainerNode a) => O.OverloadedMethod ContainerNodeGetChildMethodInfo a signature where
    overloadedMethod = containerNodeGetChild

instance O.OverloadedMethodInfo ContainerNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ContainerNode.containerNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ContainerNode.html#v:containerNodeGetChild"
        })


#endif

-- method ContainerNode::get_n_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ContainerNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a container `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_container_node_get_n_children" gsk_container_node_get_n_children :: 
    Ptr ContainerNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "ContainerNode"})
    IO Word32

-- | Retrieves the number of direct children of /@node@/.
containerNodeGetNChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsContainerNode a) =>
    a
    -- ^ /@node@/: a container @GskRenderNode@
    -> m Word32
    -- ^ __Returns:__ the number of children of the @GskRenderNode@
containerNodeGetNChildren node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_container_node_get_n_children node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data ContainerNodeGetNChildrenMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsContainerNode a) => O.OverloadedMethod ContainerNodeGetNChildrenMethodInfo a signature where
    overloadedMethod = containerNodeGetNChildren

instance O.OverloadedMethodInfo ContainerNodeGetNChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ContainerNode.containerNodeGetNChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ContainerNode.html#v:containerNodeGetNChildren"
        })


#endif


