# 12 "saver.mll"
 
open Lexing
open SaveUtils

module type Config = sig
  type t
  val of_string : string -> t
  val of_out : Out.t -> t
end

module type S = sig
  type out
  val opt : Lexing.lexbuf -> out
  val arg : Lexing.lexbuf -> out
  val arg2 : Lexing.lexbuf -> out
end

module Make(C:Config) = struct
  type out = C.t


# 24 "saver.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\253\255\254\255\255\255\002\000\007\000\003\000\250\255\
    \035\000\252\255\253\255\254\255\255\255\251\255\000\000\116\000\
    \002\000\253\255\009\000\255\255\037\000\248\255\249\255\002\000\
    \197\000\253\255\254\255\004\000\012\000\251\255\001\000\022\001\
    \103\001\184\001\009\002\067\002\252\255\148\002\250\255\017\000\
    \255\255\051\000\053\000\068\002\250\255\202\002\008\003\253\255\
    \254\255\255\255\252\255\003\000\106\003";
  Lexing.lex_backtrk =
   "\003\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \005\000\255\255\255\255\255\255\255\255\255\255\004\000\004\000\
    \255\255\255\255\001\000\255\255\008\000\255\255\255\255\006\000\
    \006\000\255\255\255\255\000\000\000\000\255\255\004\000\004\000\
    \004\000\004\000\004\000\255\255\255\255\003\000\255\255\001\000\
    \255\255\001\000\000\000\255\255\255\255\003\000\004\000\255\255\
    \255\255\255\255\255\255\003\000\003\000";
  Lexing.lex_default =
   "\255\255\000\000\000\000\000\000\255\255\255\255\007\000\000\000\
    \013\000\000\000\000\000\000\000\000\000\000\000\255\255\255\255\
    \017\000\000\000\255\255\000\000\022\000\000\000\000\000\255\255\
    \029\000\000\000\000\000\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\036\000\000\000\255\255\000\000\255\255\
    \000\000\255\255\255\255\045\000\000\000\045\000\050\000\000\000\
    \000\000\000\000\000\000\255\255\255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\005\000\004\000\004\000\018\000\005\000\027\000\004\000\
    \005\000\004\000\018\000\000\000\005\000\028\000\018\000\000\000\
    \000\000\028\000\039\000\040\000\000\000\000\000\039\000\000\000\
    \005\000\000\000\004\000\000\000\000\000\002\000\000\000\005\000\
    \009\000\018\000\013\000\029\000\028\000\050\000\028\000\027\000\
    \000\000\039\000\028\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\041\000\042\000\042\000\042\000\
    \041\000\000\000\042\000\000\000\000\000\028\000\000\000\000\000\
    \023\000\000\000\025\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\041\000\000\000\042\000\000\000\000\000\
    \000\000\000\000\000\000\003\000\000\000\003\000\000\000\008\000\
    \010\000\000\000\003\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\012\000\014\000\
    \011\000\024\000\000\000\000\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\013\000\000\000\
    \026\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\019\000\255\255\000\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \000\000\030\000\000\000\255\255\000\000\021\000\031\000\032\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \029\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\000\000\000\000\000\000\000\000\000\000\000\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\029\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\033\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\029\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \034\000\031\000\031\000\029\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\000\000\035\000\000\000\000\000\
    \000\000\047\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\000\000\000\000\
    \046\000\000\000\000\000\000\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\036\000\049\000\
    \000\000\048\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\044\000\255\255\000\000\255\255\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\000\000\051\000\000\000\000\000\000\000\
    \000\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\050\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\004\000\016\000\000\000\027\000\004\000\
    \005\000\005\000\018\000\255\255\005\000\028\000\018\000\255\255\
    \255\255\028\000\039\000\039\000\255\255\255\255\039\000\255\255\
    \000\000\255\255\004\000\255\255\255\255\000\000\255\255\005\000\
    \006\000\018\000\014\000\030\000\028\000\051\000\020\000\020\000\
    \255\255\039\000\020\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\041\000\041\000\042\000\042\000\
    \041\000\255\255\042\000\255\255\255\255\020\000\255\255\255\255\
    \020\000\255\255\020\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\041\000\255\255\042\000\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\004\000\255\255\006\000\
    \006\000\255\255\005\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\006\000\008\000\
    \006\000\020\000\255\255\255\255\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\015\000\255\255\
    \020\000\255\255\020\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\016\000\006\000\255\255\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \255\255\024\000\255\255\008\000\255\255\020\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \031\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\255\255\255\255\255\255\255\255\255\255\255\255\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\032\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\032\000\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\255\255\255\255\255\255\024\000\255\255\255\255\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\033\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \033\000\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\033\000\033\000\033\000\033\000\033\000\
    \033\000\033\000\033\000\034\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\255\255\034\000\255\255\255\255\
    \255\255\043\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
    \034\000\034\000\034\000\034\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\255\255\255\255\
    \043\000\255\255\255\255\255\255\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\037\000\043\000\
    \255\255\043\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\045\000\
    \255\255\255\255\255\255\255\255\255\255\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\045\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\035\000\043\000\045\000\255\255\045\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\255\255\046\000\255\255\255\255\255\255\
    \255\255\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\052\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\255\255\255\255\255\255\
    \255\255\255\255\045\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \046\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec opt lexbuf =
   __ocaml_lex_opt_rec lexbuf 0
and __ocaml_lex_opt_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 39 "saver.mll"
    (put_echo (lexeme lexbuf) ;
    opt2 lexbuf)
# 358 "saver.ml"

  | 1 ->
# 41 "saver.mll"
      ( skip_comment lexbuf ; opt lexbuf )
# 363 "saver.ml"

  | 2 ->
# 42 "saver.mll"
        (raise Eof)
# 368 "saver.ml"

  | 3 ->
# 43 "saver.mll"
        (raise NoOpt)
# 373 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_opt_rec lexbuf __ocaml_lex_state

and opt2 lexbuf =
   __ocaml_lex_opt2_rec lexbuf 6
and __ocaml_lex_opt2_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 47 "saver.mll"
              (incr brace_nesting;
                 put_both_char '{' ; opt2 lexbuf)
# 386 "saver.ml"

  | 1 ->
# 49 "saver.mll"
             ( decr brace_nesting;
               if !brace_nesting >= 0 then begin
                 put_both_char '}' ; opt2 lexbuf
               end else begin
                 error "Bad brace nesting in optional argument"
               end)
# 396 "saver.ml"

  | 2 ->
# 56 "saver.mll"
    (if !brace_nesting > 0 then begin
      put_both_char ']' ; opt2 lexbuf
    end else begin
      put_echo_char ']' ;
      C.of_out arg_buff
    end)
# 406 "saver.ml"

  | 3 ->
# 62 "saver.mll"
      ( skip_comment lexbuf ; opt2 lexbuf )
# 411 "saver.ml"

  | 4 ->
let
# 63 "saver.mll"
                  lxm
# 417 "saver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 64 "saver.mll"
   (put_both lxm ; opt2 lexbuf )
# 421 "saver.ml"

  | 5 ->
let
# 65 "saver.mll"
       lxm
# 427 "saver.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 66 "saver.mll"
   (put_both_char lxm ; opt2 lexbuf )
# 431 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_opt2_rec lexbuf __ocaml_lex_state

and skip_comment lexbuf =
   __ocaml_lex_skip_comment_rec lexbuf 16
and __ocaml_lex_skip_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 69 "saver.mll"
              (())
# 443 "saver.ml"

  | 1 ->
# 70 "saver.mll"
                (())
# 448 "saver.ml"

  | 2 ->
# 71 "saver.mll"
              (skip_comment lexbuf)
# 453 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_comment_rec lexbuf __ocaml_lex_state

and arg lexbuf =
   __ocaml_lex_arg_rec lexbuf 20
and __ocaml_lex_arg_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 74 "saver.mll"
                    (put_echo (lexeme lexbuf) ; arg lexbuf)
# 465 "saver.ml"

  | 1 ->
# 76 "saver.mll"
      (incr brace_nesting;
      put_echo_char '{' ;
      arg2 lexbuf)
# 472 "saver.ml"

  | 2 ->
# 80 "saver.mll"
     (skip_comment lexbuf  ; arg lexbuf)
# 477 "saver.ml"

  | 3 ->
# 82 "saver.mll"
     (let lxm = lexeme lexbuf in
     put_echo lxm ;
     C.of_string lxm)
# 484 "saver.ml"

  | 4 ->
# 86 "saver.mll"
     (blit_both lexbuf ;
     skip_blanks lexbuf)
# 490 "saver.ml"

  | 5 ->
# 89 "saver.mll"
     (let lxm = lexeme lexbuf in
     put_echo lxm ;
     C.of_string lxm)
# 497 "saver.ml"

  | 6 ->
# 93 "saver.mll"
      (let c = lexeme_char lexbuf 0 in
      put_both_char c ;
      C.of_out arg_buff)
# 504 "saver.ml"

  | 7 ->
# 96 "saver.mll"
           (raise Eof)
# 509 "saver.ml"

  | 8 ->
# 97 "saver.mll"
           (error "Argument expected")
# 514 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_arg_rec lexbuf __ocaml_lex_state

and skip_blanks lexbuf =
   __ocaml_lex_skip_blanks_rec lexbuf 39
and __ocaml_lex_skip_blanks_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 101 "saver.mll"
                 lxm
# 527 "saver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 102 "saver.mll"
    (seen_par := false ;
    put_echo lxm ;
    more_skip lexbuf)
# 533 "saver.ml"

  | 1 ->
let
# 105 "saver.mll"
             lxm
# 539 "saver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 106 "saver.mll"
    (put_echo lxm ; C.of_out arg_buff)
# 543 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_blanks_rec lexbuf __ocaml_lex_state

and more_skip lexbuf =
   __ocaml_lex_more_skip_rec lexbuf 41
and __ocaml_lex_more_skip_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 109 "saver.mll"
                           lxm
# 556 "saver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 110 "saver.mll"
   (seen_par := true ;
   put_echo lxm ;
   more_skip lexbuf)
# 562 "saver.ml"

  | 1 ->
let
# 113 "saver.mll"
            lxm
# 568 "saver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 114 "saver.mll"
  ( put_echo lxm ; C.of_out arg_buff)
# 572 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_more_skip_rec lexbuf __ocaml_lex_state

and arg2 lexbuf =
   __ocaml_lex_arg2_rec lexbuf 43
and __ocaml_lex_arg2_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 118 "saver.mll"
     (incr brace_nesting;
     put_both_char '{' ;
     arg2 lexbuf)
# 586 "saver.ml"

  | 1 ->
# 122 "saver.mll"
     (decr brace_nesting;
     if !brace_nesting > 0 then begin
       put_both_char '}' ; arg2 lexbuf
     end else begin
       put_echo_char '}' ;
       C.of_out arg_buff
     end)
# 597 "saver.ml"

  | 2 ->
# 130 "saver.mll"
     (skip_comment lexbuf  ; arg2 lexbuf)
# 602 "saver.ml"

  | 3 ->
# 133 "saver.mll"
      (blit_both lexbuf ; arg2 lexbuf )
# 607 "saver.ml"

  | 4 ->
# 135 "saver.mll"
    (let c = lexeme_char lexbuf 0 in
    put_both_char c ; arg2 lexbuf)
# 613 "saver.ml"

  | 5 ->
# 138 "saver.mll"
    (error "End of file in argument")
# 618 "saver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_arg2_rec lexbuf __ocaml_lex_state

;;

# 141 "saver.mll"
 

end

module String =
  Make
    (struct
      type t = string
      let of_string x = x
      let of_out = Out.to_string
    end)

module List =
  Make
    (struct
      type t = string list
      let of_string x = [x]
      let of_out = Out.to_list
    end)


# 647 "saver.ml"
