//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/access_loggers/open_telemetry/v3/logs_service.proto

package open_telemetryv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on OpenTelemetryAccessLogConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *OpenTelemetryAccessLogConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OpenTelemetryAccessLogConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// OpenTelemetryAccessLogConfigMultiError, or nil if none found.
func (m *OpenTelemetryAccessLogConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *OpenTelemetryAccessLogConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetCommonConfig() == nil {
		err := OpenTelemetryAccessLogConfigValidationError{
			field:  "CommonConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetCommonConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "CommonConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "CommonConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OpenTelemetryAccessLogConfigValidationError{
				field:  "CommonConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DisableBuiltinLabels

	if all {
		switch v := interface{}(m.GetResourceAttributes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "ResourceAttributes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "ResourceAttributes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResourceAttributes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OpenTelemetryAccessLogConfigValidationError{
				field:  "ResourceAttributes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetBody()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OpenTelemetryAccessLogConfigValidationError{
				field:  "Body",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAttributes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "Attributes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
					field:  "Attributes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAttributes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OpenTelemetryAccessLogConfigValidationError{
				field:  "Attributes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for StatPrefix

	for idx, item := range m.GetFormatters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
						field:  fmt.Sprintf("Formatters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OpenTelemetryAccessLogConfigValidationError{
						field:  fmt.Sprintf("Formatters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OpenTelemetryAccessLogConfigValidationError{
					field:  fmt.Sprintf("Formatters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return OpenTelemetryAccessLogConfigMultiError(errors)
	}

	return nil
}

// OpenTelemetryAccessLogConfigMultiError is an error wrapping multiple
// validation errors returned by OpenTelemetryAccessLogConfig.ValidateAll() if
// the designated constraints aren't met.
type OpenTelemetryAccessLogConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OpenTelemetryAccessLogConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OpenTelemetryAccessLogConfigMultiError) AllErrors() []error { return m }

// OpenTelemetryAccessLogConfigValidationError is the validation error returned
// by OpenTelemetryAccessLogConfig.Validate if the designated constraints
// aren't met.
type OpenTelemetryAccessLogConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OpenTelemetryAccessLogConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OpenTelemetryAccessLogConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OpenTelemetryAccessLogConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OpenTelemetryAccessLogConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OpenTelemetryAccessLogConfigValidationError) ErrorName() string {
	return "OpenTelemetryAccessLogConfigValidationError"
}

// Error satisfies the builtin error interface
func (e OpenTelemetryAccessLogConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOpenTelemetryAccessLogConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OpenTelemetryAccessLogConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OpenTelemetryAccessLogConfigValidationError{}
