#ifndef itkNeighborhoodOperatorImageFilterSwigInterface_h
#define itkNeighborhoodOperatorImageFilterSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageBoundaryCondition.h"
#include "itkNeighborhoodOperatorImageFilter.h"

using itkImageBoundaryConditionSC2SC2 = itk::ImageBoundaryCondition< itk::Image< signed char, 2 >, itk::Image< signed char, 2 > >;
using itkImageBoundaryConditionSS2SS2 = itk::ImageBoundaryCondition< itk::Image< signed short, 2 >, itk::Image< signed short, 2 > >;
using itkImageBoundaryConditionUC2UC2 = itk::ImageBoundaryCondition< itk::Image< unsigned char, 2 >, itk::Image< unsigned char, 2 > >;
using itkImageBoundaryConditionULL2ULL2 = itk::ImageBoundaryCondition< itk::Image< unsigned long long, 2 >, itk::Image< unsigned long long, 2 > >;
using itkImageBoundaryConditionUS2US2 = itk::ImageBoundaryCondition< itk::Image< unsigned short, 2 >, itk::Image< unsigned short, 2 > >;
using itkImageBoundaryConditionF2F2 = itk::ImageBoundaryCondition< itk::Image< float, 2 >, itk::Image< float, 2 > >;
using itkImageBoundaryConditionD2D2 = itk::ImageBoundaryCondition< itk::Image< double, 2 >, itk::Image< double, 2 > >;
using itkImageBoundaryConditionSC3SC3 = itk::ImageBoundaryCondition< itk::Image< signed char, 3 >, itk::Image< signed char, 3 > >;
using itkImageBoundaryConditionSS3SS3 = itk::ImageBoundaryCondition< itk::Image< signed short, 3 >, itk::Image< signed short, 3 > >;
using itkImageBoundaryConditionUC3UC3 = itk::ImageBoundaryCondition< itk::Image< unsigned char, 3 >, itk::Image< unsigned char, 3 > >;
using itkImageBoundaryConditionULL3ULL3 = itk::ImageBoundaryCondition< itk::Image< unsigned long long, 3 >, itk::Image< unsigned long long, 3 > >;
using itkImageBoundaryConditionUS3US3 = itk::ImageBoundaryCondition< itk::Image< unsigned short, 3 >, itk::Image< unsigned short, 3 > >;
using itkImageBoundaryConditionF3F3 = itk::ImageBoundaryCondition< itk::Image< float, 3 >, itk::Image< float, 3 > >;
using itkImageBoundaryConditionD3D3 = itk::ImageBoundaryCondition< itk::Image< double, 3 >, itk::Image< double, 3 > >;
using itkImageBoundaryConditionSC4SC4 = itk::ImageBoundaryCondition< itk::Image< signed char, 4 >, itk::Image< signed char, 4 > >;
using itkImageBoundaryConditionSS4SS4 = itk::ImageBoundaryCondition< itk::Image< signed short, 4 >, itk::Image< signed short, 4 > >;
using itkImageBoundaryConditionUC4UC4 = itk::ImageBoundaryCondition< itk::Image< unsigned char, 4 >, itk::Image< unsigned char, 4 > >;
using itkImageBoundaryConditionULL4ULL4 = itk::ImageBoundaryCondition< itk::Image< unsigned long long, 4 >, itk::Image< unsigned long long, 4 > >;
using itkImageBoundaryConditionUS4US4 = itk::ImageBoundaryCondition< itk::Image< unsigned short, 4 >, itk::Image< unsigned short, 4 > >;
using itkImageBoundaryConditionF4F4 = itk::ImageBoundaryCondition< itk::Image< float, 4 >, itk::Image< float, 4 > >;
using itkImageBoundaryConditionD4D4 = itk::ImageBoundaryCondition< itk::Image< double, 4 >, itk::Image< double, 4 > >;
using itkNeighborhoodOperatorImageFilterSC2SC2SC = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 2 >, itk::Image< signed char, 2 >, signed char >;
using itkNeighborhoodOperatorImageFilterSC2SC2SC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 2 >, itk::Image< signed char, 2 >, signed char >::Pointer;
using itkNeighborhoodOperatorImageFilterSS2SS2SS = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 2 >, itk::Image< signed short, 2 >, signed short >;
using itkNeighborhoodOperatorImageFilterSS2SS2SS_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 2 >, itk::Image< signed short, 2 >, signed short >::Pointer;
using itkNeighborhoodOperatorImageFilterUC2UC2UC = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 2 >, itk::Image< unsigned char, 2 >, unsigned char >;
using itkNeighborhoodOperatorImageFilterUC2UC2UC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 2 >, itk::Image< unsigned char, 2 >, unsigned char >::Pointer;
using itkNeighborhoodOperatorImageFilterULL2ULL2ULL = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 2 >, itk::Image< unsigned long long, 2 >, unsigned long long >;
using itkNeighborhoodOperatorImageFilterULL2ULL2ULL_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 2 >, itk::Image< unsigned long long, 2 >, unsigned long long >::Pointer;
using itkNeighborhoodOperatorImageFilterUS2US2US = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 2 >, itk::Image< unsigned short, 2 >, unsigned short >;
using itkNeighborhoodOperatorImageFilterUS2US2US_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 2 >, itk::Image< unsigned short, 2 >, unsigned short >::Pointer;
using itkNeighborhoodOperatorImageFilterF2F2F = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 2 >, itk::Image< float, 2 >, float >;
using itkNeighborhoodOperatorImageFilterF2F2F_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 2 >, itk::Image< float, 2 >, float >::Pointer;
using itkNeighborhoodOperatorImageFilterD2D2D = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 2 >, itk::Image< double, 2 >, double >;
using itkNeighborhoodOperatorImageFilterD2D2D_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 2 >, itk::Image< double, 2 >, double >::Pointer;
using itkNeighborhoodOperatorImageFilterSC3SC3SC = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 3 >, itk::Image< signed char, 3 >, signed char >;
using itkNeighborhoodOperatorImageFilterSC3SC3SC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 3 >, itk::Image< signed char, 3 >, signed char >::Pointer;
using itkNeighborhoodOperatorImageFilterSS3SS3SS = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 3 >, itk::Image< signed short, 3 >, signed short >;
using itkNeighborhoodOperatorImageFilterSS3SS3SS_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 3 >, itk::Image< signed short, 3 >, signed short >::Pointer;
using itkNeighborhoodOperatorImageFilterUC3UC3UC = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 3 >, itk::Image< unsigned char, 3 >, unsigned char >;
using itkNeighborhoodOperatorImageFilterUC3UC3UC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 3 >, itk::Image< unsigned char, 3 >, unsigned char >::Pointer;
using itkNeighborhoodOperatorImageFilterULL3ULL3ULL = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 3 >, itk::Image< unsigned long long, 3 >, unsigned long long >;
using itkNeighborhoodOperatorImageFilterULL3ULL3ULL_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 3 >, itk::Image< unsigned long long, 3 >, unsigned long long >::Pointer;
using itkNeighborhoodOperatorImageFilterUS3US3US = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 3 >, itk::Image< unsigned short, 3 >, unsigned short >;
using itkNeighborhoodOperatorImageFilterUS3US3US_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 3 >, itk::Image< unsigned short, 3 >, unsigned short >::Pointer;
using itkNeighborhoodOperatorImageFilterF3F3F = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 3 >, itk::Image< float, 3 >, float >;
using itkNeighborhoodOperatorImageFilterF3F3F_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 3 >, itk::Image< float, 3 >, float >::Pointer;
using itkNeighborhoodOperatorImageFilterD3D3D = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 3 >, itk::Image< double, 3 >, double >;
using itkNeighborhoodOperatorImageFilterD3D3D_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 3 >, itk::Image< double, 3 >, double >::Pointer;
using itkNeighborhoodOperatorImageFilterSC4SC4SC = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 4 >, itk::Image< signed char, 4 >, signed char >;
using itkNeighborhoodOperatorImageFilterSC4SC4SC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed char, 4 >, itk::Image< signed char, 4 >, signed char >::Pointer;
using itkNeighborhoodOperatorImageFilterSS4SS4SS = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 4 >, itk::Image< signed short, 4 >, signed short >;
using itkNeighborhoodOperatorImageFilterSS4SS4SS_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< signed short, 4 >, itk::Image< signed short, 4 >, signed short >::Pointer;
using itkNeighborhoodOperatorImageFilterUC4UC4UC = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 4 >, itk::Image< unsigned char, 4 >, unsigned char >;
using itkNeighborhoodOperatorImageFilterUC4UC4UC_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned char, 4 >, itk::Image< unsigned char, 4 >, unsigned char >::Pointer;
using itkNeighborhoodOperatorImageFilterULL4ULL4ULL = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 4 >, itk::Image< unsigned long long, 4 >, unsigned long long >;
using itkNeighborhoodOperatorImageFilterULL4ULL4ULL_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned long long, 4 >, itk::Image< unsigned long long, 4 >, unsigned long long >::Pointer;
using itkNeighborhoodOperatorImageFilterUS4US4US = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 4 >, itk::Image< unsigned short, 4 >, unsigned short >;
using itkNeighborhoodOperatorImageFilterUS4US4US_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< unsigned short, 4 >, itk::Image< unsigned short, 4 >, unsigned short >::Pointer;
using itkNeighborhoodOperatorImageFilterF4F4F = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 4 >, itk::Image< float, 4 >, float >;
using itkNeighborhoodOperatorImageFilterF4F4F_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< float, 4 >, itk::Image< float, 4 >, float >::Pointer;
using itkNeighborhoodOperatorImageFilterD4D4D = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 4 >, itk::Image< double, 4 >, double >;
using itkNeighborhoodOperatorImageFilterD4D4D_Pointer = itk::NeighborhoodOperatorImageFilter< itk::Image< double, 4 >, itk::Image< double, 4 >, double >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkImageToImageFilterASwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkNeighborhoodOperatorImageFilterSwigInterface.h"
#include "itkNeighborhoodSwigInterface.h"
#include "itkOffsetSwigInterface.h"
#include "itkIndexSwigInterface.h"
#endif
