
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kjob_wrapper.h"

// Wrappers providing overrides
#include "ksignalhandler_wrapper.h"
#include "kprocess_wrapper.h"
#include "kjobuidelegate_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <kjobuidelegate.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJob_Type = nullptr;
static PyTypeObject *Sbk_KJob_TypeF(void)
{
    return _Sbk_KJob_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KJobWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KJobWrapper::KJobWrapper(::QObject * parent) : KJob(parent)
{
}

void KJobWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KJob", funcName, gil, pyOverride, event);
}

void KJobWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJob", funcName, gil, pyOverride, signal);
}

void KJobWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KJob", funcName, gil, pyOverride, event);
}

void KJobWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJob", funcName, gil, pyOverride, signal);
}

bool KJobWrapper::doKill()
{
    static const char *funcName = "doKill";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doKill();
    }
    return KProcessWrapper::sbk_o_atEnd("KJob", funcName, gil, pyOverride);
}

bool KJobWrapper::doResume()
{
    static const char *funcName = "doResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doResume();
    }
    return KProcessWrapper::sbk_o_atEnd("KJob", funcName, gil, pyOverride);
}

bool KJobWrapper::doSuspend()
{
    static const char *funcName = "doSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doSuspend();
    }
    return KProcessWrapper::sbk_o_atEnd("KJob", funcName, gil, pyOverride);
}

::QString KJobWrapper::errorString() const
{
    // This method belongs to a property.
    static const char *funcName = "1:errorString";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::errorString();
    }
    return sbk_o_errorString("KJob", funcName, gil, pyOverride);
}

::QString KJobWrapper::sbk_o_errorString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KJobWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KJob", funcName, gil, pyOverride, event);
}

bool KJobWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KJob", funcName, gil, pyOverride, watched, event);
}

void KJobWrapper::start()
{
    static const char *funcName = "start";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KJob.start");
        return;
    }
    KJobUiDelegateWrapper::sbk_o_showErrorMessage("KJob", funcName, gil, pyOverride);
}

void KJobWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJob_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KJob", funcName, gil, pyOverride, event);
}

const QMetaObject *KJobWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KJob::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KJobWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KJob::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KJobWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KJobWrapper *>(this));
    }
    return KJob::qt_metacast(_clname);
}

KJobWrapper::~KJobWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KJob_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KJob_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KJob");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KJob >()))
        return -1;

    KJobWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KJob", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KJob::KJob(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KJob(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KJob(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KJob(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KJobWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KJobWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KJob >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KJobFunc_capabilities(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // capabilities()const
        QFlags<KJob::Capability> cppResult = const_cast<const ::KJob *>(cppSelf)->capabilities();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJob_Capability_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_doKill(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // doKill()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KJob::doKill()
            : cppSelf->doKill();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_doResume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // doResume()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KJob::doResume()
            : cppSelf->doResume();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_doSuspend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // doSuspend()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KJob::doSuspend()
            : cppSelf->doSuspend();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_elapsedTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // elapsedTime()const
        qint64 cppResult = const_cast<const ::KJob *>(cppSelf)->elapsedTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_emitPercent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "emitPercent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJob::emitPercent(qulonglong,qulonglong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[1])))) {
        overloadId = 0; // emitPercent(qulonglong,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "emitPercent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        qulonglong cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qulonglong cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitPercent(qulonglong,qulonglong)
            cppSelf->emitPercent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_emitResult(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emitResult()
        cppSelf->emitResult();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_emitSpeed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::emitSpeed(ulong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // emitSpeed(ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emitSpeed", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitSpeed(ulong)
            cppSelf->emitSpeed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // error()const
        int cppResult = const_cast<const ::KJob *>(cppSelf)->error();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // errorString()const
        QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KJob *>(cppSelf)->::KJob::errorString()
            : const_cast<const ::KJob *>(cppSelf)->errorString();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_errorText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // errorText()const
        QString cppResult = const_cast<const ::KJob *>(cppSelf)->errorText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_exec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;
    pcm.setBlocking();

    // Call function/method
    {

        // exec()
        bool cppResult = cppSelf->exec();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_isAutoDelete(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isAutoDelete()const
        bool cppResult = const_cast<const ::KJob *>(cppSelf)->isAutoDelete();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFinished()const
        bool cppResult = const_cast<const ::KJob *>(cppSelf)->isFinished();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_isFinishedNotificationHidden(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFinishedNotificationHidden()const
        bool cppResult = const_cast<const ::KJob *>(cppSelf)->isFinishedNotificationHidden();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_isStartedWithExec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isStartedWithExec()const
        bool cppResult = const_cast<const ::KJob *>(cppSelf)->isStartedWithExec();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_isSuspended(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSuspended()const
        bool cppResult = const_cast<const ::KJob *>(cppSelf)->isSuspended();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_kill(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "kill", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    if (PyArg_ParseTuple(args, "|O:kill", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJob::kill(KJob::KillVerbosity=)->bool
    if (numArgs == 0) {
        overloadId = 0; // kill(KJob::KillVerbosity)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_KillVerbosity_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // kill(KJob::KillVerbosity)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "kill", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"verbosity", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_KillVerbosity_IDX])))->converter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "kill", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
            }
        }
        ::KJob::KillVerbosity cppArg0(KJob::Quietly);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // kill(KJob::KillVerbosity)
            bool cppResult = cppSelf->kill(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_percent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // percent()const
        unsigned long cppResult = const_cast<const ::KJob *>(cppSelf)->percent();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_processedAmount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::processedAmount(KJob::Unit)const->qulonglong
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // processedAmount(KJob::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "processedAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::KJob::Unit cppArg0{KJob::Bytes};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processedAmount(KJob::Unit)const
            qulonglong cppResult = const_cast<const ::KJob *>(cppSelf)->processedAmount(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resume()
        bool cppResult = cppSelf->resume();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_setAutoDelete(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setAutoDelete(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoDelete(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoDelete", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoDelete(bool)
            cppSelf->setAutoDelete(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setCapabilities(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setCapabilities(QFlags<KJob::Capability>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJob_Capability_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setCapabilities(QFlags<KJob::Capability>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCapabilities", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::QFlags<KJob::Capability> cppArg0 = QFlags<KJob::Capability>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCapabilities(QFlags<KJob::Capability>)
            cppSelf->setCapabilities(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setError(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setError(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setError", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setError(int)
            cppSelf->setError(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setErrorText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setErrorText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setErrorText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setErrorText", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setErrorText(QString)
            cppSelf->setErrorText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setFinishedNotificationHidden(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setFinishedNotificationHidden", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    if (PyArg_ParseTuple(args, "|O:setFinishedNotificationHidden", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJob::setFinishedNotificationHidden(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setFinishedNotificationHidden(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setFinishedNotificationHidden(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setFinishedNotificationHidden", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"hide", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setFinishedNotificationHidden", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFinishedNotificationHidden(bool)
            cppSelf->setFinishedNotificationHidden(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setPercent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setPercent(ulong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // setPercent(ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPercent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPercent(ulong)
            cppSelf->setPercent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setProcessedAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setProcessedAmount", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJob::setProcessedAmount(KJob::Unit,qulonglong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[1])))) {
        overloadId = 0; // setProcessedAmount(KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setProcessedAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::KJob::Unit cppArg0{KJob::Bytes};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qulonglong cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setProcessedAmount(KJob::Unit,qulonglong)
            cppSelf->setProcessedAmount(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setProgressUnit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setProgressUnit(KJob::Unit)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setProgressUnit(KJob::Unit)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setProgressUnit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::KJob::Unit cppArg0{KJob::Bytes};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setProgressUnit(KJob::Unit)
            cppSelf->setProgressUnit(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setTotalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTotalAmount", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJob::setTotalAmount(KJob::Unit,qulonglong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[1])))) {
        overloadId = 0; // setTotalAmount(KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTotalAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::KJob::Unit cppArg0{KJob::Bytes};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qulonglong cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTotalAmount(KJob::Unit,qulonglong)
            cppSelf->setTotalAmount(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_setUiDelegate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::setUiDelegate(KJobUiDelegate*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), (pyArg)))) {
        overloadId = 0; // setUiDelegate(KJobUiDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUiDelegate", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJobUiDelegate *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUiDelegate(KJobUiDelegate*)
            cppSelf->setUiDelegate(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("KJob.start");
            return {};
        }
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_startElapsedTimer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startElapsedTimer()
        cppSelf->startElapsedTimer();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobFunc_suspend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // suspend()
        bool cppResult = cppSelf->suspend();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_totalAmount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJob::totalAmount(KJob::Unit)const->qulonglong
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // totalAmount(KJob::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "totalAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]);

    // Call function/method
    {
        ::KJob::Unit cppArg0{KJob::Bytes};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob::Unit)const
            qulonglong cppResult = const_cast<const ::KJob *>(cppSelf)->totalAmount(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobFunc_uiDelegate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // uiDelegate()const
        KJobUiDelegate * cppResult = const_cast<const ::KJob *>(cppSelf)->uiDelegate();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KJob_PropertyStrings[] = {
    "capabilities:",
    "error:",
    "errorString:",
    "errorText:",
    "percent:",
    nullptr // Sentinel
};

static const char *Sbk_KJob_EnumFlagInfo[] = {
    "Capability:IntFlag:Capabilities",
    "KillVerbosity:IntEnum",
    "Unit:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJob_methods[] = {
    {"capabilities", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_capabilities), METH_NOARGS, nullptr},
    {"doKill", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_doKill), METH_NOARGS, nullptr},
    {"doResume", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_doResume), METH_NOARGS, nullptr},
    {"doSuspend", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_doSuspend), METH_NOARGS, nullptr},
    {"elapsedTime", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_elapsedTime), METH_NOARGS, nullptr},
    {"emitPercent", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_emitPercent), METH_VARARGS, nullptr},
    {"emitResult", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_emitResult), METH_NOARGS, nullptr},
    {"emitSpeed", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_emitSpeed), METH_O, nullptr},
    {"error", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_error), METH_NOARGS, nullptr},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_errorString), METH_NOARGS, nullptr},
    {"errorText", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_errorText), METH_NOARGS, nullptr},
    {"exec", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_exec), METH_NOARGS, nullptr},
    {"isAutoDelete", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_isAutoDelete), METH_NOARGS, nullptr},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_isFinished), METH_NOARGS, nullptr},
    {"isFinishedNotificationHidden", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_isFinishedNotificationHidden), METH_NOARGS, nullptr},
    {"isStartedWithExec", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_isStartedWithExec), METH_NOARGS, nullptr},
    {"isSuspended", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_isSuspended), METH_NOARGS, nullptr},
    {"kill", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_kill), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_percent), METH_NOARGS, nullptr},
    {"processedAmount", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_processedAmount), METH_O, nullptr},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_resume), METH_NOARGS, nullptr},
    {"setAutoDelete", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setAutoDelete), METH_O, nullptr},
    {"setCapabilities", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setCapabilities), METH_O, nullptr},
    {"setError", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setError), METH_O, nullptr},
    {"setErrorText", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setErrorText), METH_O, nullptr},
    {"setFinishedNotificationHidden", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setFinishedNotificationHidden), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setPercent", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setPercent), METH_O, nullptr},
    {"setProcessedAmount", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setProcessedAmount), METH_VARARGS, nullptr},
    {"setProgressUnit", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setProgressUnit), METH_O, nullptr},
    {"setTotalAmount", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setTotalAmount), METH_VARARGS, nullptr},
    {"setUiDelegate", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_setUiDelegate), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_start), METH_NOARGS, nullptr},
    {"startElapsedTimer", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_startElapsedTimer), METH_NOARGS, nullptr},
    {"suspend", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_suspend), METH_NOARGS, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_totalAmount), METH_O, nullptr},
    {"uiDelegate", reinterpret_cast<PyCFunction>(Sbk_KJobFunc_uiDelegate), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KJob_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KJobWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KJob_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJob_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJob_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KJob_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJob_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJob_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJob_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJob_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJob_spec = {
    "1:KCoreAddons.KJob",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJob_slots
};

} //extern "C"

static void *Sbk_KJob_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KJob *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KJob_Unit(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KJob::Unit>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KJob::Unit *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KJob_Unit_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))
        return Enum_PythonToCpp_KJob_Unit;
    return {};
}

static PyObject *KJob_Unit_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KJob::Unit>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KJob::Unit *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KJob_Capability(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KJob::Capability>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KJob::Capability *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KJob_Capability_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Capability_IDX])))
        return Enum_PythonToCpp_KJob_Capability;
    return {};
}

static PyObject *KJob_Capability_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KJob::Capability>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KJob::Capability *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KJob_Capability(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KJob::Capability>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KJob::Capability> *>(cppOut) = value;

}

static PyObject *KJob_Capability_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KJob::Capability> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Capability_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KJob_KillVerbosity(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KJob::KillVerbosity>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KJob::KillVerbosity *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KJob_KillVerbosity_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_KillVerbosity_IDX])))
        return Enum_PythonToCpp_KJob_KillVerbosity;
    return {};
}

static PyObject *KJob_KillVerbosity_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KJob::KillVerbosity>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KJob::KillVerbosity *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KJob_PythonToCpp_KJob_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KJob_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KJob_PythonToCpp_KJob_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KJob_TypeF()))
        return KJob_PythonToCpp_KJob_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KJob_PTR_CppToPython_KJob(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KJob *>(const_cast<void *>(cppIn)), Sbk_KJob_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KJob_SignatureStrings[] = {
    "KCoreAddons.KJob(self,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,error:int=None,errorText:QString=None,errorString:QString=None,percent:ulong=None,capabilities:KCoreAddons.KJob.Capability=None)",
    "KCoreAddons.KJob.capabilities(self)->KCoreAddons.KJob.Capability",
    "KCoreAddons.KJob.doKill(self)->bool",
    "KCoreAddons.KJob.doResume(self)->bool",
    "KCoreAddons.KJob.doSuspend(self)->bool",
    "KCoreAddons.KJob.elapsedTime(self)->qint64",
    "KCoreAddons.KJob.emitPercent(self,processedAmount:qulonglong,totalAmount:qulonglong)",
    "KCoreAddons.KJob.emitResult(self)",
    "KCoreAddons.KJob.emitSpeed(self,speed:unsigned long)",
    "KCoreAddons.KJob.error(self)->int",
    "KCoreAddons.KJob.errorString(self)->QString",
    "KCoreAddons.KJob.errorText(self)->QString",
    "KCoreAddons.KJob.exec(self)->bool",
    "KCoreAddons.KJob.isAutoDelete(self)->bool",
    "KCoreAddons.KJob.isFinished(self)->bool",
    "KCoreAddons.KJob.isFinishedNotificationHidden(self)->bool",
    "KCoreAddons.KJob.isStartedWithExec(self)->bool",
    "KCoreAddons.KJob.isSuspended(self)->bool",
    "KCoreAddons.KJob.kill(self,verbosity:KCoreAddons.KJob.KillVerbosity=KJob.Quietly)->bool",
    "KCoreAddons.KJob.percent(self)->unsigned long",
    "KCoreAddons.KJob.processedAmount(self,unit:KCoreAddons.KJob.Unit)->qulonglong",
    "KCoreAddons.KJob.resume(self)->bool",
    "KCoreAddons.KJob.setAutoDelete(self,autodelete:bool)",
    "KCoreAddons.KJob.setCapabilities(self,capabilities:KCoreAddons.KJob.Capability)",
    "KCoreAddons.KJob.setError(self,errorCode:int)",
    "KCoreAddons.KJob.setErrorText(self,errorText:QString)",
    "KCoreAddons.KJob.setFinishedNotificationHidden(self,hide:bool=true)",
    "KCoreAddons.KJob.setPercent(self,percentage:unsigned long)",
    "KCoreAddons.KJob.setProcessedAmount(self,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KCoreAddons.KJob.setProgressUnit(self,unit:KCoreAddons.KJob.Unit)",
    "KCoreAddons.KJob.setTotalAmount(self,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KCoreAddons.KJob.setUiDelegate(self,delegate:KCoreAddons.KJobUiDelegate)",
    "KCoreAddons.KJob.start(self)",
    "KCoreAddons.KJob.startElapsedTimer(self)",
    "KCoreAddons.KJob.suspend(self)->bool",
    "KCoreAddons.KJob.totalAmount(self,unit:KCoreAddons.KJob.Unit)->qulonglong",
    "KCoreAddons.KJob.uiDelegate(self)->KCoreAddons.KJobUiDelegate",
    nullptr}; // Sentinel
#else
static constexpr size_t KJob_SignatureByteSize = 528;
static constexpr uint8_t KJob_SignatureBytes[528] = {
    0x78, 0xda, 0xad, 0x55, 0x4d, 0x6f, 0xdb, 0x30, 0x0c, 0xbd, 0xf7, 0x57, 0xec, 0xb8, 0x0c, 0x5e,
    0x4e, 0x43, 0x0f, 0x06, 0x32, 0x20, 0xc8, 0x32, 0x0c, 0x35, 0xd0, 0x36, 0x73, 0xba, 0x9d, 0x65,
    0x8b, 0x75, 0xd8, 0x29, 0x92, 0x2b, 0x51, 0x5b, 0xf3, 0xef, 0x27, 0xd9, 0x71, 0x1c, 0xc7, 0x72,
    0xec, 0x01, 0x3b, 0x04, 0x88, 0xa8, 0xc7, 0x67, 0x7e, 0x3c, 0x52, 0xc9, 0x4a, 0x69, 0x58, 0x72,
    0xae, 0xa4, 0x99, 0x27, 0x77, 0x2a, 0x7b, 0x6f, 0x40, 0x3c, 0x47, 0x25, 0xd3, 0x20, 0x29, 0x7e,
    0x3c, 0xa4, 0xc8, 0xe1, 0x76, 0xbe, 0x21, 0x8f, 0x9a, 0x6f, 0x1e, 0xb2, 0x17, 0xc8, 0x69, 0x21,
    0xad, 0x10, 0x25, 0xe9, 0xe8, 0x43, 0x9c, 0xc0, 0xe1, 0x8f, 0xd2, 0xfc, 0x41, 0x8a, 0xc3, 0xe2,
    0x5e, 0x49, 0x88, 0x40, 0x6b, 0xa5, 0x63, 0x94, 0x74, 0x76, 0xdc, 0xc2, 0x1b, 0xc5, 0x9b, 0x94,
    0x34, 0xca, 0xe2, 0xcc, 0x5c, 0x1b, 0xba, 0x17, 0x25, 0xe8, 0xdc, 0x7f, 0xd8, 0x0a, 0xd5, 0x98,
    0x72, 0x56, 0xb2, 0x0c, 0x05, 0x12, 0x82, 0x89, 0x93, 0x8b, 0x68, 0xe7, 0xab, 0xe6, 0xb6, 0xfe,
    0xfe, 0xec, 0xa6, 0x87, 0x38, 0xf7, 0xaf, 0x92, 0x9b, 0x7d, 0xfc, 0x7c, 0x85, 0xa6, 0x4f, 0xc0,
    0x55, 0x82, 0x42, 0x34, 0xae, 0x99, 0x52, 0x22, 0x84, 0xf9, 0x0e, 0xc6, 0xee, 0x61, 0x0c, 0x95,
    0x5a, 0x53, 0x82, 0xe4, 0xd7, 0x61, 0x20, 0x58, 0x69, 0x80, 0x6f, 0xb1, 0xe5, 0x7b, 0x75, 0x15,
    0xbd, 0xfd, 0x14, 0x80, 0xee, 0x91, 0x1e, 0xeb, 0x9a, 0x1d, 0x1b, 0xa7, 0x55, 0x0e, 0xc6, 0x79,
    0x2f, 0xf7, 0xca, 0xba, 0x42, 0xbe, 0x56, 0x95, 0xf4, 0xbf, 0x88, 0x14, 0x31, 0xd1, 0x33, 0xcf,
    0xc2, 0xa4, 0x3e, 0x1d, 0x51, 0x73, 0x0e, 0x20, 0xd2, 0x12, 0xa0, 0x4e, 0x24, 0x32, 0xfe, 0x6f,
    0x6c, 0xa5, 0xc1, 0x42, 0x02, 0x7f, 0x37, 0x44, 0xeb, 0x9b, 0xde, 0x24, 0xe4, 0xf2, 0x19, 0x40,
    0xd4, 0x72, 0x68, 0x70, 0x47, 0x75, 0x0c, 0x60, 0xbd, 0xb2, 0xc6, 0x91, 0x6f, 0x90, 0x5f, 0x2f,
    0x38, 0x9a, 0xa5, 0x25, 0xf5, 0x05, 0x04, 0x10, 0x8c, 0x21, 0xbf, 0xa2, 0x44, 0xb3, 0x03, 0x3e,
    0x15, 0x77, 0xaf, 0x08, 0x9f, 0x31, 0x67, 0x84, 0x4a, 0x7e, 0x43, 0xce, 0x41, 0x8e, 0x79, 0xa6,
    0xc4, 0x34, 0x01, 0xff, 0x89, 0xb4, 0x5b, 0x4f, 0x08, 0xfd, 0x28, 0xa9, 0xb1, 0x88, 0x7e, 0x35,
    0x1a, 0x8e, 0x7e, 0x83, 0xce, 0x94, 0x71, 0x52, 0xef, 0x4f, 0x93, 0x17, 0xfa, 0x8f, 0xe6, 0x7a,
    0x51, 0x99, 0x36, 0x16, 0x81, 0xc4, 0x61, 0x90, 0xb7, 0x3c, 0x53, 0x9f, 0x03, 0x75, 0x44, 0x10,
    0x40, 0x77, 0xe5, 0x59, 0x07, 0x64, 0x25, 0x52, 0x3f, 0x96, 0x27, 0x67, 0xf5, 0xca, 0x3f, 0x29,
    0xb5, 0xcf, 0xa6, 0x27, 0xcc, 0x9c, 0x01, 0xba, 0x68, 0x6e, 0xc4, 0xdc, 0x99, 0x57, 0xe7, 0xd8,
    0xfb, 0xcc, 0x82, 0x4e, 0xab, 0xcb, 0xb5, 0x31, 0x79, 0x11, 0x85, 0xf9, 0xd6, 0x27, 0xf5, 0xd7,
    0xdb, 0x6f, 0xe5, 0x42, 0xf0, 0x7b, 0xf2, 0x0a, 0xfa, 0xa4, 0xee, 0xfe, 0x1a, 0x0d, 0x7b, 0x8d,
    0x68, 0x2e, 0xda, 0xb9, 0x65, 0x5e, 0xa5, 0xbc, 0x20, 0x6d, 0x21, 0xcc, 0xd1, 0xdd, 0x26, 0xf5,
    0x81, 0x15, 0x30, 0x3a, 0xdd, 0xde, 0xf5, 0xdf, 0x9a, 0x1b, 0xb1, 0x09, 0xbb, 0xa8, 0xa6, 0x2d,
    0x5c, 0xa7, 0x8d, 0xf7, 0x19, 0x15, 0x4c, 0x90, 0x61, 0xdb, 0x6e, 0xbe, 0xff, 0x15, 0xd4, 0x13,
    0x7a, 0x45, 0x15, 0xac, 0xd1, 0x14, 0x3f, 0x9e, 0x7a, 0xac, 0x2d, 0x30, 0x44, 0xe4, 0x47, 0x7d,
    0x68, 0xc9, 0x56, 0x97, 0xeb, 0xf6, 0x2d, 0xd0, 0x83, 0xc0, 0x29, 0x8f, 0x0a, 0x4d, 0xaf, 0xc1,
    0xc8, 0xd4, 0xd9, 0x6e, 0xea, 0x81, 0xe7, 0xb4, 0xcd, 0xf9, 0xe6, 0x2f, 0x45, 0xc9, 0x08, 0xf7
};
#endif

PyTypeObject *init_KJob(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KJob_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KJob_IDX].type;

    Shiboken::AutoDecRef Sbk_KJob_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KJob_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJob",
        "KJob*",
        &Sbk_KJob_spec,
        &Shiboken::callCppDestructor< KJob >,
        Sbk_KJob_Type_bases.object(),
        0);
    auto *pyType = Sbk_KJob_TypeF(); // references _Sbk_KJob_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KJob_SignatureStrings);
#else
    InitSignatureBytes(pyType, KJob_SignatureBytes, KJob_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJob_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KJob_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KJob_PythonToCpp_KJob_PTR,
        is_KJob_PythonToCpp_KJob_PTR_Convertible,
        KJob_PTR_CppToPython_KJob);

    Shiboken::Conversions::registerConverterName(converter, "KJob");
    Shiboken::Conversions::registerConverterName(converter, "KJob*");
    Shiboken::Conversions::registerConverterName(converter, "KJob&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KJob).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KJobWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KJob_TypeF(), &Sbk_KJob_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KJob_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Unit'.
    const char *Unit_Initializer[] = {
        "Bytes",
        "Files",
        "Directories",
        "Items",
        "UnitsCount",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Unit_InitializerValues[] = {
        uint8_t(KJob::Unit::Bytes),       //  0x00  0
        uint8_t(KJob::Unit::Files),       //  0x01  1
        uint8_t(KJob::Unit::Directories), //  0x02  2
        uint8_t(KJob::Unit::Items),       //  0x03  3
        uint8_t(KJob::Unit::UnitsCount)   //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KJob_TypeF(),
        "1:KCoreAddons.KJob.Unit",
        Unit_Initializer, Unit_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX].type = EType;
    // Register converter for enum 'KJob::Unit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KJob_Unit_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KJob_Unit,
            is_Enum_PythonToCpp_KJob_Unit_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KJob::Unit");
        Shiboken::Conversions::registerConverterAlias(converter, "Unit");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Unit' enum.

    // Initialization of enum 'Capability'.
    const char *Capability_Initializer[] = {
        "NoCapabilities",
        "Killable",
        "Suspendable",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Capability_InitializerValues[] = {
        uint8_t(KJob::Capability::NoCapabilities), //  0x00  0
        uint8_t(KJob::Capability::Killable),       //  0x01  1
        uint8_t(KJob::Capability::Suspendable)     //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KJob_TypeF(),
        "1:KCoreAddons.KJob.Capability",
        Capability_Initializer, Capability_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KJob_Capability_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KJob_Capability_IDX].type =
        EType;
    // Register converter for enum 'KJob::Capability'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KJob_Capability_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KJob_Capability,
            is_Enum_PythonToCpp_KJob_Capability_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KJob::Capability");
        Shiboken::Conversions::registerConverterAlias(converter, "Capability");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KJob_Capability_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KJob_Capability,
            is_Enum_PythonToCpp_KJob_Capability_Convertible);
        // Register converter for flag 'QFlags<KJob::Capability>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KJob::Capability>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KJob::Capabilities");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Capability' enum/flags.

    // Initialization of enum 'KillVerbosity'.
    const char *KillVerbosity_Initializer[] = {
        "Quietly",
        "EmitResult",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KillVerbosity_InitializerValues[] = {
        uint8_t(KJob::KillVerbosity::Quietly),   //  0x00  0
        uint8_t(KJob::KillVerbosity::EmitResult) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KJob_TypeF(),
        "1:KCoreAddons.KJob.KillVerbosity",
        KillVerbosity_Initializer, KillVerbosity_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KJob_KillVerbosity_IDX].type = EType;
    // Register converter for enum 'KJob::KillVerbosity'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KJob_KillVerbosity_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KJob_KillVerbosity,
            is_Enum_PythonToCpp_KJob_KillVerbosity_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KJob::KillVerbosity");
        Shiboken::Conversions::registerConverterAlias(converter, "KillVerbosity");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'KillVerbosity' enum.

    PySide::Signal::registerSignals(pyType, &::KJob::staticMetaObject);
    qRegisterMetaType< ::KJob::Unit >("KJob::Unit");
    qRegisterMetaType< ::KJob::Capability >("KJob::Capability");
    qRegisterMetaType< ::KJob::KillVerbosity >("KJob::KillVerbosity");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KJob::staticMetaObject, sizeof(KJobWrapper));

    return pyType;
}
