
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "knotifications_python.h"

// main header
#include "knotificationreplyaction_wrapper.h"

// Wrappers providing overrides
#include "knotificationreplyaction_wrapper.h"

// Argument includes
#include <QString>
#include <knotificationreplyaction.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNotificationReplyAction_Type = nullptr;
static PyTypeObject *Sbk_KNotificationReplyAction_TypeF(void)
{
    return _Sbk_KNotificationReplyAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNotificationReplyActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNotificationReplyActionWrapper::KNotificationReplyActionWrapper(const ::QString & label) : KNotificationReplyAction(label)
{
}

void KNotificationReplyActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    sbk_o_childEvent("KNotificationReplyAction", funcName, gil, pyOverride, event);
}

void KNotificationReplyActionWrapper::sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationReplyActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    sbk_o_connectNotify("KNotificationReplyAction", funcName, gil, pyOverride, signal);
}

void KNotificationReplyActionWrapper::sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationReplyActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    sbk_o_customEvent("KNotificationReplyAction", funcName, gil, pyOverride, event);
}

void KNotificationReplyActionWrapper::sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationReplyActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationReplyActionWrapper::sbk_o_connectNotify("KNotificationReplyAction", funcName, gil, pyOverride, signal);
}

bool KNotificationReplyActionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return sbk_o_event("KNotificationReplyAction", funcName, gil, pyOverride, event);
}

bool KNotificationReplyActionWrapper::sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KNotificationReplyActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KNotificationReplyAction", funcName, gil, pyOverride, watched, event);
}

bool KNotificationReplyActionWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg2 = Py_REFCNT(pyArgArray[1]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg2 = Py_REFCNT(PyTuple_GetItem(pyArgs, 1)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(pyArgArray[1]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 1));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KNotificationReplyActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationReplyAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    sbk_o_timerEvent("KNotificationReplyAction", funcName, gil, pyOverride, event);
}

void KNotificationReplyActionWrapper::sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *KNotificationReplyActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNotificationReplyAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNotificationReplyActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNotificationReplyAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNotificationReplyActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNotificationReplyActionWrapper *>(this));
    }
    return KNotificationReplyAction::qt_metacast(_clname);
}

KNotificationReplyActionWrapper::~KNotificationReplyActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNotificationReplyAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNotificationReplyAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNotificationReplyAction >()))
        return -1;

    KNotificationReplyActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KNotificationReplyAction", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNotificationReplyAction::KNotificationReplyAction(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // KNotificationReplyAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KNotificationReplyAction(QString)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KNotificationReplyActionWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KNotificationReplyActionWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNotificationReplyAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNotificationReplyActionFunc_fallbackBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fallbackBehavior()const
        KNotificationReplyAction::FallbackBehavior cppResult = const_cast<const ::KNotificationReplyAction *>(cppSelf)->fallbackBehavior();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_FallbackBehavior_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationReplyActionFunc_label(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // label()const
        QString cppResult = const_cast<const ::KNotificationReplyAction *>(cppSelf)->label();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationReplyActionFunc_placeholderText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // placeholderText()const
        QString cppResult = const_cast<const ::KNotificationReplyAction *>(cppSelf)->placeholderText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationReplyActionFunc_setFallbackBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationReplyAction::setFallbackBehavior(KNotificationReplyAction::FallbackBehavior)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_FallbackBehavior_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setFallbackBehavior(KNotificationReplyAction::FallbackBehavior)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFallbackBehavior", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    // Call function/method
    {
        ::KNotificationReplyAction::FallbackBehavior cppArg0{KNotificationReplyAction::FallbackBehavior::HideAction};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFallbackBehavior(KNotificationReplyAction::FallbackBehavior)
            cppSelf->setFallbackBehavior(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationReplyActionFunc_setLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationReplyAction::setLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLabel", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLabel(QString)
            cppSelf->setLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationReplyActionFunc_setPlaceholderText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationReplyAction::setPlaceholderText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPlaceholderText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPlaceholderText", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPlaceholderText(QString)
            cppSelf->setPlaceholderText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationReplyActionFunc_setSubmitButtonIconName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationReplyAction::setSubmitButtonIconName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSubmitButtonIconName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSubmitButtonIconName", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSubmitButtonIconName(QString)
            cppSelf->setSubmitButtonIconName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationReplyActionFunc_setSubmitButtonText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationReplyAction::setSubmitButtonText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSubmitButtonText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSubmitButtonText", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSubmitButtonText(QString)
            cppSelf->setSubmitButtonText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationReplyActionFunc_submitButtonIconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // submitButtonIconName()const
        QString cppResult = const_cast<const ::KNotificationReplyAction *>(cppSelf)->submitButtonIconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationReplyActionFunc_submitButtonText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // submitButtonText()const
        QString cppResult = const_cast<const ::KNotificationReplyAction *>(cppSelf)->submitButtonText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KNotificationReplyAction_PropertyStrings[] = {
    "fallbackBehavior::",
    "label::",
    "placeholderText::",
    "submitButtonIconName::",
    "submitButtonText::",
    nullptr // Sentinel
};

static const char *Sbk_KNotificationReplyAction_EnumFlagInfo[] = {
    "FallbackBehavior:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNotificationReplyAction_methods[] = {
    {"fallbackBehavior", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_fallbackBehavior), METH_NOARGS, nullptr},
    {"label", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_label), METH_NOARGS, nullptr},
    {"placeholderText", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_placeholderText), METH_NOARGS, nullptr},
    {"setFallbackBehavior", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_setFallbackBehavior), METH_O, nullptr},
    {"setLabel", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_setLabel), METH_O, nullptr},
    {"setPlaceholderText", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_setPlaceholderText), METH_O, nullptr},
    {"setSubmitButtonIconName", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_setSubmitButtonIconName), METH_O, nullptr},
    {"setSubmitButtonText", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_setSubmitButtonText), METH_O, nullptr},
    {"submitButtonIconName", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_submitButtonIconName), METH_NOARGS, nullptr},
    {"submitButtonText", reinterpret_cast<PyCFunction>(Sbk_KNotificationReplyActionFunc_submitButtonText), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNotificationReplyAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNotificationReplyAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNotificationReplyActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNotificationReplyAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNotificationReplyAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNotificationReplyAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNotificationReplyAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNotificationReplyAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNotificationReplyAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNotificationReplyAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNotificationReplyAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNotificationReplyAction_spec = {
    "1:KNotifications.KNotificationReplyAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNotificationReplyAction_slots
};

} //extern "C"

static void *Sbk_KNotificationReplyAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNotificationReplyAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KNotificationReplyAction_FallbackBehavior(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNotificationReplyAction::FallbackBehavior>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNotificationReplyAction::FallbackBehavior *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNotificationReplyAction_FallbackBehavior_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_FallbackBehavior_IDX])))
        return Enum_PythonToCpp_KNotificationReplyAction_FallbackBehavior;
    return {};
}

static PyObject *KNotificationReplyAction_FallbackBehavior_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNotificationReplyAction::FallbackBehavior>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNotificationReplyAction::FallbackBehavior *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNotificationReplyAction_PythonToCpp_KNotificationReplyAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNotificationReplyAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNotificationReplyAction_PythonToCpp_KNotificationReplyAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNotificationReplyAction_TypeF()))
        return KNotificationReplyAction_PythonToCpp_KNotificationReplyAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNotificationReplyAction_PTR_CppToPython_KNotificationReplyAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNotificationReplyAction *>(const_cast<void *>(cppIn)), Sbk_KNotificationReplyAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNotificationReplyAction_SignatureStrings[] = {
    "KNotifications.KNotificationReplyAction(self,label:QString,*:KeywordOnly=None,label:QString=None,placeholderText:QString=None,submitButtonText:QString=None,submitButtonIconName:QString=None,fallbackBehavior:KNotifications.KNotificationReplyAction.FallbackBehavior=None)",
    "KNotifications.KNotificationReplyAction.fallbackBehavior(self)->KNotifications.KNotificationReplyAction.FallbackBehavior",
    "KNotifications.KNotificationReplyAction.label(self)->QString",
    "KNotifications.KNotificationReplyAction.placeholderText(self)->QString",
    "KNotifications.KNotificationReplyAction.setFallbackBehavior(self,fallbackBehavior:KNotifications.KNotificationReplyAction.FallbackBehavior)",
    "KNotifications.KNotificationReplyAction.setLabel(self,label:QString)",
    "KNotifications.KNotificationReplyAction.setPlaceholderText(self,placeholderText:QString)",
    "KNotifications.KNotificationReplyAction.setSubmitButtonIconName(self,submitButtonIconName:QString)",
    "KNotifications.KNotificationReplyAction.setSubmitButtonText(self,submitButtonText:QString)",
    "KNotifications.KNotificationReplyAction.submitButtonIconName(self)->QString",
    "KNotifications.KNotificationReplyAction.submitButtonText(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KNotificationReplyAction_SignatureByteSize = 228;
static constexpr uint8_t KNotificationReplyAction_SignatureBytes[228] = {
    0x78, 0xda, 0xad, 0x53, 0x5b, 0x0e, 0x82, 0x30, 0x10, 0xfc, 0xf7, 0x24, 0x62, 0x90, 0x03, 0x90,
    0x68, 0x22, 0x1f, 0x24, 0x06, 0x83, 0x0f, 0xbc, 0x40, 0x29, 0x8b, 0x34, 0x2e, 0x2d, 0x81, 0xa2,
    0x72, 0x7b, 0x23, 0xf8, 0x00, 0x02, 0xa4, 0x10, 0xff, 0xda, 0xee, 0xee, 0xcc, 0xee, 0xec, 0xd4,
    0x71, 0x85, 0x64, 0x21, 0xa3, 0x44, 0x32, 0xc1, 0x33, 0xc3, 0xa9, 0x5f, 0x4f, 0x90, 0x60, 0xb1,
    0xa1, 0xaf, 0xe3, 0x3c, 0x03, 0x0c, 0x75, 0x24, 0x3e, 0xa0, 0x79, 0xf4, 0x64, 0xca, 0xf8, 0x45,
    0x5f, 0x98, 0x0e, 0x14, 0x77, 0x91, 0x06, 0x7b, 0x8e, 0xc5, 0xca, 0x15, 0x1c, 0x9a, 0x09, 0xd5,
    0x53, 0x82, 0x84, 0x42, 0x24, 0x30, 0x80, 0xf4, 0x0c, 0x0f, 0xd9, 0x0c, 0x66, 0xb9, 0x1f, 0x33,
    0x69, 0xe5, 0x52, 0x0a, 0x3e, 0x1c, 0xdd, 0x52, 0xc1, 0x5d, 0x12, 0x43, 0x33, 0x23, 0x24, 0x88,
    0x3e, 0xa1, 0x57, 0x0b, 0x22, 0x72, 0x63, 0x22, 0x35, 0x1d, 0xb5, 0x71, 0x0c, 0xbb, 0x55, 0x58,
    0xc2, 0x69, 0x33, 0xd5, 0xf2, 0x36, 0x6f, 0x29, 0x8f, 0xb6, 0x5c, 0x4f, 0xa5, 0x57, 0x26, 0x2e,
    0x05, 0xfe, 0xb0, 0xbd, 0xa5, 0x50, 0x2e, 0x6e, 0xad, 0x62, 0x2a, 0x4c, 0x06, 0xd2, 0xee, 0x9a,
    0xff, 0x7f, 0xdb, 0xd0, 0xc6, 0xf4, 0xb2, 0xfb, 0x4a, 0xd2, 0xb4, 0xdf, 0x28, 0x90, 0x43, 0x87,
    0x34, 0x7d, 0xd6, 0x1d, 0x05, 0xec, 0x75, 0x78, 0xb8, 0x42, 0x1f, 0x72, 0xf7, 0x64, 0x8a, 0x5f,
    0xf3, 0x7d, 0x5f, 0x6b, 0x04, 0x74, 0x5f, 0xeb, 0x53, 0x3c, 0xd3, 0xd5, 0x63, 0x0d, 0xe7, 0x09,
    0x2e, 0x4d, 0xbb, 0x2d
};
#endif

PyTypeObject *init_KNotificationReplyAction(PyObject *module)
{
    if (SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX].type != nullptr)
        return SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KNotificationReplyAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KNotificationReplyAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNotificationReplyAction",
        "KNotificationReplyAction*",
        &Sbk_KNotificationReplyAction_spec,
        &Shiboken::callCppDestructor< KNotificationReplyAction >,
        Sbk_KNotificationReplyAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KNotificationReplyAction_Type; // references _Sbk_KNotificationReplyAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNotificationReplyAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNotificationReplyAction_SignatureBytes, KNotificationReplyAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNotificationReplyAction_PropertyStrings);
    SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNotificationReplyAction_PythonToCpp_KNotificationReplyAction_PTR,
        is_KNotificationReplyAction_PythonToCpp_KNotificationReplyAction_PTR_Convertible,
        KNotificationReplyAction_PTR_CppToPython_KNotificationReplyAction);

    Shiboken::Conversions::registerConverterName(converter, "KNotificationReplyAction");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationReplyAction*");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationReplyAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNotificationReplyAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNotificationReplyActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNotificationReplyAction_TypeF(), &Sbk_KNotificationReplyAction_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KNotificationReplyAction_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'FallbackBehavior'.
    const char *FallbackBehavior_Initializer[] = {
        "HideAction",
        "UseRegularAction",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t FallbackBehavior_InitializerValues[] = {
        int8_t(KNotificationReplyAction::FallbackBehavior::HideAction),      //  0x00  0
        int8_t(KNotificationReplyAction::FallbackBehavior::UseRegularAction) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNotificationReplyAction_TypeF(),
        "1:KNotifications.KNotificationReplyAction.FallbackBehavior",
        FallbackBehavior_Initializer, FallbackBehavior_InitializerValues);
    SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_FallbackBehavior_IDX].type = EType;
    // Register converter for enum 'KNotificationReplyAction::FallbackBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNotificationReplyAction_FallbackBehavior_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNotificationReplyAction_FallbackBehavior,
            is_Enum_PythonToCpp_KNotificationReplyAction_FallbackBehavior_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNotificationReplyAction::FallbackBehavior");
        Shiboken::Conversions::registerConverterAlias(converter, "FallbackBehavior");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'FallbackBehavior' enum.

    PySide::Signal::registerSignals(pyType, &::KNotificationReplyAction::staticMetaObject);
    qRegisterMetaType< ::KNotificationReplyAction::FallbackBehavior >("KNotificationReplyAction::FallbackBehavior");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNotificationReplyAction::staticMetaObject, sizeof(KNotificationReplyActionWrapper));

    return pyType;
}
