
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "knotifications_python.h"

// main header
#include "knotifyconfig_wrapper.h"

// Argument includes
#include <QString>
#include <knotifyconfig.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNotifyConfig_Type = nullptr;
static PyTypeObject *Sbk_KNotifyConfig_TypeF(void)
{
    return _Sbk_KNotifyConfig_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNotifyConfig_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNotifyConfig >()))
        return -1;

    ::KNotifyConfig *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KNotifyConfig", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNotifyConfig::KNotifyConfig(KNotifyConfig)
    // 1: KNotifyConfig::KNotifyConfig(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // KNotifyConfig(QString,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KNotifyConfig(KNotifyConfig)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KNotifyConfig(const KNotifyConfig &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KNotifyConfig *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KNotifyConfig(KNotifyConfig)
                cptr = new ::KNotifyConfig(*cppArg0);
            }
            break;
        }
        case 1: // KNotifyConfig(const QString &applicationName, const QString &eventId)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KNotifyConfig(QString,QString)
                cptr = new ::KNotifyConfig(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KNotifyConfig >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KNotifyConfigFunc_applicationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // applicationName()const
        QString cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->applicationName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_eventId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // eventId()const
        QString cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->eventId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_readEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotifyConfig::readEntry(QString)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // readEntry(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "readEntry", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readEntry(QString)const
            QString cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->readEntry(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_readGlobalEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotifyConfig::readGlobalEntry(QString)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // readGlobalEntry(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "readGlobalEntry", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readGlobalEntry(QString)const
            QString cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->readGlobalEntry(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_readPathEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotifyConfig *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotifyConfig::readPathEntry(QString)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // readPathEntry(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "readPathEntry", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readPathEntry(QString)const
            QString cppResult = const_cast<const ::KNotifyConfig *>(cppSelf)->readPathEntry(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotifyConfigFunc_reparseConfiguration(PyObject *self)
{
    SBK_UNUSED(self)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reparseConfiguration()
        ::KNotifyConfig::reparseConfiguration();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotifyConfigFunc_reparseSingleConfiguration(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KNotifyConfig::reparseSingleConfiguration(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // reparseSingleConfiguration(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "reparseSingleConfiguration", errInfo, SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // reparseSingleConfiguration(QString)
            ::KNotifyConfig::reparseSingleConfiguration(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNotifyConfig_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNotifyConfig_methods[] = {
    {"applicationName", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_applicationName), METH_NOARGS, nullptr},
    {"eventId", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_eventId), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_isValid), METH_NOARGS, nullptr},
    {"readEntry", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_readEntry), METH_O, nullptr},
    {"readGlobalEntry", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_readGlobalEntry), METH_O, nullptr},
    {"readPathEntry", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_readPathEntry), METH_O, nullptr},
    {"reparseConfiguration", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_reparseConfiguration), METH_NOARGS|METH_STATIC, nullptr},
    {"reparseSingleConfiguration", reinterpret_cast<PyCFunction>(Sbk_KNotifyConfigFunc_reparseSingleConfiguration), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KNotifyConfig_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNotifyConfig_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNotifyConfig_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNotifyConfig_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNotifyConfig_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNotifyConfig_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNotifyConfig_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNotifyConfig_spec = {
    "1:KNotifications.KNotifyConfig",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNotifyConfig_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNotifyConfig_PythonToCpp_KNotifyConfig_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNotifyConfig_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNotifyConfig_PythonToCpp_KNotifyConfig_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNotifyConfig_TypeF()))
        return KNotifyConfig_PythonToCpp_KNotifyConfig_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNotifyConfig_PTR_CppToPython_KNotifyConfig(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KNotifyConfig_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KNotifyConfig_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNotifyConfig_SignatureStrings[] = {
    "1:KNotifications.KNotifyConfig(self,other:KNotifications.KNotifyConfig)",
    "0:KNotifications.KNotifyConfig(self,applicationName:QString,eventId:QString)",
    "KNotifications.KNotifyConfig.applicationName(self)->QString",
    "KNotifications.KNotifyConfig.eventId(self)->QString",
    "KNotifications.KNotifyConfig.isValid(self)->bool",
    "KNotifications.KNotifyConfig.readEntry(self,key:QString)->QString",
    "KNotifications.KNotifyConfig.readGlobalEntry(self,key:QString)->QString",
    "KNotifications.KNotifyConfig.readPathEntry(self,key:QString)->QString",
    "KNotifications.KNotifyConfig.reparseConfiguration()",
    "KNotifications.KNotifyConfig.reparseSingleConfiguration(app:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNotifyConfig_SignatureByteSize = 174;
static constexpr uint8_t KNotifyConfig_SignatureBytes[174] = {
    0x78, 0xda, 0xa5, 0x91, 0xc1, 0x0a, 0x82, 0x40, 0x10, 0x86, 0xef, 0x3e, 0x89, 0x0b, 0x26, 0x75,
    0xf5, 0xd0, 0x25, 0x22, 0x22, 0x90, 0x42, 0xe8, 0x3e, 0xe6, 0xa8, 0x43, 0xd3, 0xae, 0xec, 0x6e,
    0x81, 0x6f, 0x9f, 0xb9, 0x66, 0xe0, 0x61, 0x31, 0x3c, 0xfe, 0xcc, 0x7c, 0xdf, 0x30, 0xfc, 0x9b,
    0xe4, 0x94, 0x2a, 0x4b, 0x25, 0xdd, 0xc0, 0x92, 0x92, 0x26, 0x76, 0xb1, 0xdd, 0x29, 0x59, 0x52,
    0x15, 0x1a, 0xe4, 0x32, 0x52, 0xb6, 0x46, 0xed, 0xdd, 0x13, 0xc1, 0x7a, 0x86, 0x07, 0x9a, 0x86,
    0x87, 0x79, 0x0a, 0x0f, 0x4c, 0x2e, 0x99, 0xd5, 0x24, 0xab, 0x08, 0x5f, 0x28, 0xed, 0xb1, 0xf8,
    0x66, 0x11, 0xf8, 0x54, 0xf1, 0xc4, 0xd2, 0xab, 0xc5, 0x6a, 0x3b, 0xc0, 0x7e, 0x76, 0xb8, 0xf4,
    0x17, 0x43, 0xe6, 0x0a, 0x4c, 0x23, 0x93, 0x2b, 0xc5, 0x7e, 0x40, 0x23, 0x14, 0x7b, 0x69, 0x75,
    0xeb, 0xbe, 0xbe, 0x63, 0x3b, 0x7e, 0x36, 0xf3, 0xe4, 0xc7, 0x70, 0x60, 0x95, 0x03, 0x2f, 0xf7,
    0x9c, 0xc1, 0xd6, 0x4b, 0x2d, 0x0d, 0x68, 0x83, 0x2e, 0x3d, 0x75, 0xbf, 0x13, 0x8a, 0x59, 0x4c,
    0xd6, 0xc9, 0x79, 0x42, 0x76, 0xfd, 0xfd, 0x9a, 0x7e, 0x03, 0x90, 0x8c, 0xee, 0x67
};
#endif

PyTypeObject *init_KNotifyConfig(PyObject *module)
{
    if (SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX].type != nullptr)
        return SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX].type;

    Shiboken::AutoDecRef Sbk_KNotifyConfig_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KNotifyConfig_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNotifyConfig",
        "KNotifyConfig*",
        &Sbk_KNotifyConfig_spec,
        &Shiboken::callCppDestructor< ::KNotifyConfig >,
        Sbk_KNotifyConfig_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KNotifyConfig_Type; // references _Sbk_KNotifyConfig_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNotifyConfig_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNotifyConfig_SignatureBytes, KNotifyConfig_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNotifyConfig_PropertyStrings);
    SbkKNotificationsTypeStructs[SBK_KNotifyConfig_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNotifyConfig_PythonToCpp_KNotifyConfig_PTR,
        is_KNotifyConfig_PythonToCpp_KNotifyConfig_PTR_Convertible,
        KNotifyConfig_PTR_CppToPython_KNotifyConfig);

    Shiboken::Conversions::registerConverterName(converter, "KNotifyConfig");
    Shiboken::Conversions::registerConverterName(converter, "KNotifyConfig*");
    Shiboken::Conversions::registerConverterName(converter, "KNotifyConfig&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNotifyConfig).name());

    qRegisterMetaType< ::KNotifyConfig *>();

    return pyType;
}
