//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package v1

import (
	context "context"
	fmt "fmt"

	resourcev1 "k8s.io/api/resource/v1"
	equality "k8s.io/apimachinery/pkg/api/equality"
	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	sets "k8s.io/apimachinery/pkg/util/sets"
	field "k8s.io/apimachinery/pkg/util/validation/field"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *runtime.Scheme) error {
	// type DeviceClass
	scheme.AddValidationFunc((*resourcev1.DeviceClass)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_DeviceClass(ctx, op, nil /* fldPath */, obj.(*resourcev1.DeviceClass), safe.Cast[*resourcev1.DeviceClass](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type DeviceClassList
	scheme.AddValidationFunc((*resourcev1.DeviceClassList)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_DeviceClassList(ctx, op, nil /* fldPath */, obj.(*resourcev1.DeviceClassList), safe.Cast[*resourcev1.DeviceClassList](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceClaim
	scheme.AddValidationFunc((*resourcev1.ResourceClaim)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/", "/status":
			return Validate_ResourceClaim(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceClaim), safe.Cast[*resourcev1.ResourceClaim](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceClaimList
	scheme.AddValidationFunc((*resourcev1.ResourceClaimList)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ResourceClaimList(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceClaimList), safe.Cast[*resourcev1.ResourceClaimList](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceClaimTemplate
	scheme.AddValidationFunc((*resourcev1.ResourceClaimTemplate)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ResourceClaimTemplate(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceClaimTemplate), safe.Cast[*resourcev1.ResourceClaimTemplate](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceClaimTemplateList
	scheme.AddValidationFunc((*resourcev1.ResourceClaimTemplateList)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ResourceClaimTemplateList(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceClaimTemplateList), safe.Cast[*resourcev1.ResourceClaimTemplateList](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceSlice
	scheme.AddValidationFunc((*resourcev1.ResourceSlice)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ResourceSlice(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceSlice), safe.Cast[*resourcev1.ResourceSlice](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type ResourceSliceList
	scheme.AddValidationFunc((*resourcev1.ResourceSliceList)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ResourceSliceList(ctx, op, nil /* fldPath */, obj.(*resourcev1.ResourceSliceList), safe.Cast[*resourcev1.ResourceSliceList](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_AllocatedDeviceStatus validates an instance of AllocatedDeviceStatus according
// to declarative validation rules in the API schema.
func Validate_AllocatedDeviceStatus(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.AllocatedDeviceStatus) (errs field.ErrorList) {
	// field resourcev1.AllocatedDeviceStatus.Driver has no validation
	// field resourcev1.AllocatedDeviceStatus.Pool has no validation
	// field resourcev1.AllocatedDeviceStatus.Device has no validation

	// field resourcev1.AllocatedDeviceStatus.ShareID
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.UUID(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("shareID"), obj.ShareID, safe.Field(oldObj, func(oldObj *resourcev1.AllocatedDeviceStatus) *string { return oldObj.ShareID }), oldObj != nil)...)

	// field resourcev1.AllocatedDeviceStatus.Conditions has no validation
	// field resourcev1.AllocatedDeviceStatus.Data has no validation

	// field resourcev1.AllocatedDeviceStatus.NetworkData
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.NetworkDeviceData, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_NetworkDeviceData(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("networkData"), obj.NetworkData, safe.Field(oldObj, func(oldObj *resourcev1.AllocatedDeviceStatus) *resourcev1.NetworkDeviceData {
			return oldObj.NetworkData
		}), oldObj != nil)...)

	return errs
}

var symbolsForAllocationConfigSource = sets.New(resourcev1.AllocationConfigSourceClaim, resourcev1.AllocationConfigSourceClass)

// Validate_AllocationConfigSource validates an instance of AllocationConfigSource according
// to declarative validation rules in the API schema.
func Validate_AllocationConfigSource(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.AllocationConfigSource) (errs field.ErrorList) {
	errs = append(errs, validate.Enum(ctx, op, fldPath, obj, oldObj, symbolsForAllocationConfigSource, nil)...)

	return errs
}

// Validate_AllocationResult validates an instance of AllocationResult according
// to declarative validation rules in the API schema.
func Validate_AllocationResult(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.AllocationResult) (errs field.ErrorList) {
	// field resourcev1.AllocationResult.Devices
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationResult, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceAllocationResult(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("devices"), &obj.Devices, safe.Field(oldObj, func(oldObj *resourcev1.AllocationResult) *resourcev1.DeviceAllocationResult { return &oldObj.Devices }), oldObj != nil)...)

	// field resourcev1.AllocationResult.NodeSelector has no validation
	// field resourcev1.AllocationResult.AllocationTimestamp has no validation
	return errs
}

// Validate_CounterSet validates an instance of CounterSet according
// to declarative validation rules in the API schema.
func Validate_CounterSet(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.CounterSet) (errs field.ErrorList) {
	// field resourcev1.CounterSet.Name
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ShortName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("name"), &obj.Name, safe.Field(oldObj, func(oldObj *resourcev1.CounterSet) *string { return &oldObj.Name }), oldObj != nil)...)

	// field resourcev1.CounterSet.Counters has no validation
	return errs
}

// Validate_Device validates an instance of Device according
// to declarative validation rules in the API schema.
func Validate_Device(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.Device) (errs field.ErrorList) {
	// field resourcev1.Device.Name has no validation

	// field resourcev1.Device.Attributes
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[resourcev1.QualifiedName]resourcev1.DeviceAttribute, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the map and call the value type's validation function
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual, Validate_DeviceAttribute)...)
			return
		}(fldPath.Child("attributes"), obj.Attributes, safe.Field(oldObj, func(oldObj *resourcev1.Device) map[resourcev1.QualifiedName]resourcev1.DeviceAttribute {
			return oldObj.Attributes
		}), oldObj != nil)...)

	// field resourcev1.Device.Capacity has no validation

	// field resourcev1.Device.ConsumesCounters
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceCounterConsumption, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 2); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceCounterConsumption, b resourcev1.DeviceCounterConsumption) bool {
				return a.CounterSet == b.CounterSet
			})...)
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceCounterConsumption, b resourcev1.DeviceCounterConsumption) bool {
				return a.CounterSet == b.CounterSet
			}, validate.SemanticDeepEqual, Validate_DeviceCounterConsumption)...)
			return
		}(fldPath.Child("consumesCounters"), obj.ConsumesCounters, safe.Field(oldObj, func(oldObj *resourcev1.Device) []resourcev1.DeviceCounterConsumption { return oldObj.ConsumesCounters }), oldObj != nil)...)

	// field resourcev1.Device.NodeName has no validation
	// field resourcev1.Device.NodeSelector has no validation
	// field resourcev1.Device.AllNodes has no validation

	// field resourcev1.Device.Taints
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceTaint, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceTaint)...)
			return
		}(fldPath.Child("taints"), obj.Taints, safe.Field(oldObj, func(oldObj *resourcev1.Device) []resourcev1.DeviceTaint { return oldObj.Taints }), oldObj != nil)...)

	// field resourcev1.Device.BindsToNode has no validation

	// field resourcev1.Device.BindingConditions
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 4); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("bindingConditions"), obj.BindingConditions, safe.Field(oldObj, func(oldObj *resourcev1.Device) []string { return oldObj.BindingConditions }), oldObj != nil)...)

	// field resourcev1.Device.BindingFailureConditions
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 4); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("bindingFailureConditions"), obj.BindingFailureConditions, safe.Field(oldObj, func(oldObj *resourcev1.Device) []string { return oldObj.BindingFailureConditions }), oldObj != nil)...)

	// field resourcev1.Device.AllowMultipleAllocations has no validation
	return errs
}

// Validate_DeviceAllocationConfiguration validates an instance of DeviceAllocationConfiguration according
// to declarative validation rules in the API schema.
func Validate_DeviceAllocationConfiguration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationConfiguration) (errs field.ErrorList) {
	// field resourcev1.DeviceAllocationConfiguration.Source
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.AllocationConfigSource, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_AllocationConfigSource(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("source"), &obj.Source, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAllocationConfiguration) *resourcev1.AllocationConfigSource {
			return &oldObj.Source
		}), oldObj != nil)...)

	// field resourcev1.DeviceAllocationConfiguration.Requests
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with set semantics require unique values
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("requests"), obj.Requests, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAllocationConfiguration) []string { return oldObj.Requests }), oldObj != nil)...)

	// field resourcev1.DeviceAllocationConfiguration.DeviceConfiguration
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceConfiguration(ctx, op, fldPath, obj, oldObj)...)
			return
		}(safe.Value(fldPath, func() *field.Path { return fldPath.Child("resourcev1.DeviceConfiguration") }), &obj.DeviceConfiguration, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAllocationConfiguration) *resourcev1.DeviceConfiguration {
			return &oldObj.DeviceConfiguration
		}), oldObj != nil)...)

	return errs
}

var symbolsForDeviceAllocationMode = sets.New(resourcev1.DeviceAllocationModeAll, resourcev1.DeviceAllocationModeExactCount)

// Validate_DeviceAllocationMode validates an instance of DeviceAllocationMode according
// to declarative validation rules in the API schema.
func Validate_DeviceAllocationMode(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationMode) (errs field.ErrorList) {
	errs = append(errs, validate.Enum(ctx, op, fldPath, obj, oldObj, symbolsForDeviceAllocationMode, nil)...)

	return errs
}

// Validate_DeviceAllocationResult validates an instance of DeviceAllocationResult according
// to declarative validation rules in the API schema.
func Validate_DeviceAllocationResult(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationResult) (errs field.ErrorList) {
	// field resourcev1.DeviceAllocationResult.Results
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceRequestAllocationResult, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceRequestAllocationResult)...)
			return
		}(fldPath.Child("results"), obj.Results, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAllocationResult) []resourcev1.DeviceRequestAllocationResult {
			return oldObj.Results
		}), oldObj != nil)...)

	// field resourcev1.DeviceAllocationResult.Config
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceAllocationConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 64); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceAllocationConfiguration)...)
			return
		}(fldPath.Child("config"), obj.Config, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAllocationResult) []resourcev1.DeviceAllocationConfiguration {
			return oldObj.Config
		}), oldObj != nil)...)

	return errs
}

var unionMembershipFor_k8s_io_api_resource_v1_DeviceAttribute_ = validate.NewUnionMembership(validate.NewUnionMember("int"), validate.NewUnionMember("bool"), validate.NewUnionMember("string"), validate.NewUnionMember("version"))

// Validate_DeviceAttribute validates an instance of DeviceAttribute according
// to declarative validation rules in the API schema.
func Validate_DeviceAttribute(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceAttribute) (errs field.ErrorList) {
	errs = append(errs, validate.Union(ctx, op, fldPath, obj, oldObj, unionMembershipFor_k8s_io_api_resource_v1_DeviceAttribute_, func(obj *resourcev1.DeviceAttribute) bool {
		if obj == nil {
			return false
		}
		return obj.IntValue != nil
	}, func(obj *resourcev1.DeviceAttribute) bool {
		if obj == nil {
			return false
		}
		return obj.BoolValue != nil
	}, func(obj *resourcev1.DeviceAttribute) bool {
		if obj == nil {
			return false
		}
		return obj.StringValue != nil
	}, func(obj *resourcev1.DeviceAttribute) bool {
		if obj == nil {
			return false
		}
		return obj.VersionValue != nil
	})...)

	// field resourcev1.DeviceAttribute.IntValue
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int64, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("int"), obj.IntValue, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAttribute) *int64 { return oldObj.IntValue }), oldObj != nil)...)

	// field resourcev1.DeviceAttribute.BoolValue
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *bool, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("bool"), obj.BoolValue, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAttribute) *bool { return oldObj.BoolValue }), oldObj != nil)...)

	// field resourcev1.DeviceAttribute.StringValue
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("string"), obj.StringValue, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAttribute) *string { return oldObj.StringValue }), oldObj != nil)...)

	// field resourcev1.DeviceAttribute.VersionValue
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("version"), obj.VersionValue, safe.Field(oldObj, func(oldObj *resourcev1.DeviceAttribute) *string { return oldObj.VersionValue }), oldObj != nil)...)

	return errs
}

// Validate_DeviceClaim validates an instance of DeviceClaim according
// to declarative validation rules in the API schema.
func Validate_DeviceClaim(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClaim) (errs field.ErrorList) {
	// field resourcev1.DeviceClaim.Requests
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceRequest, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceRequest, b resourcev1.DeviceRequest) bool { return a.Name == b.Name })...)
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceRequest, b resourcev1.DeviceRequest) bool { return a.Name == b.Name }, validate.SemanticDeepEqual, Validate_DeviceRequest)...)
			return
		}(fldPath.Child("requests"), obj.Requests, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClaim) []resourcev1.DeviceRequest { return oldObj.Requests }), oldObj != nil)...)

	// field resourcev1.DeviceClaim.Constraints
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceConstraint, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceConstraint)...)
			return
		}(fldPath.Child("constraints"), obj.Constraints, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClaim) []resourcev1.DeviceConstraint { return oldObj.Constraints }), oldObj != nil)...)

	// field resourcev1.DeviceClaim.Config
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceClaimConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceClaimConfiguration)...)
			return
		}(fldPath.Child("config"), obj.Config, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClaim) []resourcev1.DeviceClaimConfiguration { return oldObj.Config }), oldObj != nil)...)

	return errs
}

// Validate_DeviceClaimConfiguration validates an instance of DeviceClaimConfiguration according
// to declarative validation rules in the API schema.
func Validate_DeviceClaimConfiguration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClaimConfiguration) (errs field.ErrorList) {
	// field resourcev1.DeviceClaimConfiguration.Requests
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with set semantics require unique values
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("requests"), obj.Requests, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClaimConfiguration) []string { return oldObj.Requests }), oldObj != nil)...)

	// field resourcev1.DeviceClaimConfiguration.DeviceConfiguration
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceConfiguration(ctx, op, fldPath, obj, oldObj)...)
			return
		}(safe.Value(fldPath, func() *field.Path { return fldPath.Child("resourcev1.DeviceConfiguration") }), &obj.DeviceConfiguration, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClaimConfiguration) *resourcev1.DeviceConfiguration {
			return &oldObj.DeviceConfiguration
		}), oldObj != nil)...)

	return errs
}

// Validate_DeviceClass validates an instance of DeviceClass according
// to declarative validation rules in the API schema.
func Validate_DeviceClass(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClass) (errs field.ErrorList) {
	// field resourcev1.DeviceClass.TypeMeta has no validation

	// field resourcev1.DeviceClass.ObjectMeta
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *metav1.ObjectMeta, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			func() { // cohort name
				earlyReturn := false
				if e := validate.Subfield(ctx, op, fldPath, obj, oldObj, "name", func(o *metav1.ObjectMeta) *string { return &o.Name }, validate.DirectEqualPtr, validate.OptionalValue); len(e) != 0 {
					earlyReturn = true
				}
				if earlyReturn {
					return // do not proceed
				}
				errs = append(errs, validate.Subfield(ctx, op, fldPath, obj, oldObj, "name", func(o *metav1.ObjectMeta) *string { return &o.Name }, validate.DirectEqualPtr, validate.LongName)...)
			}()
			return
		}(fldPath.Child("metadata"), &obj.ObjectMeta, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClass) *metav1.ObjectMeta { return &oldObj.ObjectMeta }), oldObj != nil)...)

	// field resourcev1.DeviceClass.Spec
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceClassSpec, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceClassSpec(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("spec"), &obj.Spec, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClass) *resourcev1.DeviceClassSpec { return &oldObj.Spec }), oldObj != nil)...)

	return errs
}

// Validate_DeviceClassConfiguration validates an instance of DeviceClassConfiguration according
// to declarative validation rules in the API schema.
func Validate_DeviceClassConfiguration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClassConfiguration) (errs field.ErrorList) {
	// field resourcev1.DeviceClassConfiguration.DeviceConfiguration
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceConfiguration(ctx, op, fldPath, obj, oldObj)...)
			return
		}(safe.Value(fldPath, func() *field.Path { return fldPath.Child("resourcev1.DeviceConfiguration") }), &obj.DeviceConfiguration, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClassConfiguration) *resourcev1.DeviceConfiguration {
			return &oldObj.DeviceConfiguration
		}), oldObj != nil)...)

	return errs
}

// Validate_DeviceClassList validates an instance of DeviceClassList according
// to declarative validation rules in the API schema.
func Validate_DeviceClassList(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClassList) (errs field.ErrorList) {
	// field resourcev1.DeviceClassList.TypeMeta has no validation
	// field resourcev1.DeviceClassList.ListMeta has no validation

	// field resourcev1.DeviceClassList.Items
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceClass, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceClass)...)
			return
		}(fldPath.Child("items"), obj.Items, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClassList) []resourcev1.DeviceClass { return oldObj.Items }), oldObj != nil)...)

	return errs
}

// Validate_DeviceClassSpec validates an instance of DeviceClassSpec according
// to declarative validation rules in the API schema.
func Validate_DeviceClassSpec(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceClassSpec) (errs field.ErrorList) {
	// field resourcev1.DeviceClassSpec.Selectors
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceSelector, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("selectors"), obj.Selectors, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClassSpec) []resourcev1.DeviceSelector { return oldObj.Selectors }), oldObj != nil)...)

	// field resourcev1.DeviceClassSpec.Config
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceClassConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceClassConfiguration)...)
			return
		}(fldPath.Child("config"), obj.Config, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClassSpec) []resourcev1.DeviceClassConfiguration { return oldObj.Config }), oldObj != nil)...)

	// field resourcev1.DeviceClassSpec.ExtendedResourceName
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ExtendedResourceName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("extendedResourceName"), obj.ExtendedResourceName, safe.Field(oldObj, func(oldObj *resourcev1.DeviceClassSpec) *string { return oldObj.ExtendedResourceName }), oldObj != nil)...)

	return errs
}

// Validate_DeviceConfiguration validates an instance of DeviceConfiguration according
// to declarative validation rules in the API schema.
func Validate_DeviceConfiguration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceConfiguration) (errs field.ErrorList) {
	// field resourcev1.DeviceConfiguration.Opaque
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.OpaqueDeviceConfiguration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_OpaqueDeviceConfiguration(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("opaque"), obj.Opaque, safe.Field(oldObj, func(oldObj *resourcev1.DeviceConfiguration) *resourcev1.OpaqueDeviceConfiguration {
			return oldObj.Opaque
		}), oldObj != nil)...)

	return errs
}

// Validate_DeviceConstraint validates an instance of DeviceConstraint according
// to declarative validation rules in the API schema.
func Validate_DeviceConstraint(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceConstraint) (errs field.ErrorList) {
	// field resourcev1.DeviceConstraint.Requests
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with set semantics require unique values
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("requests"), obj.Requests, safe.Field(oldObj, func(oldObj *resourcev1.DeviceConstraint) []string { return oldObj.Requests }), oldObj != nil)...)

	// field resourcev1.DeviceConstraint.MatchAttribute
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.FullyQualifiedName, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ResourceFullyQualifiedName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("matchAttribute"), obj.MatchAttribute, safe.Field(oldObj, func(oldObj *resourcev1.DeviceConstraint) *resourcev1.FullyQualifiedName { return oldObj.MatchAttribute }), oldObj != nil)...)

	// field resourcev1.DeviceConstraint.DistinctAttribute has no validation
	return errs
}

// Validate_DeviceCounterConsumption validates an instance of DeviceCounterConsumption according
// to declarative validation rules in the API schema.
func Validate_DeviceCounterConsumption(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceCounterConsumption) (errs field.ErrorList) {
	// field resourcev1.DeviceCounterConsumption.CounterSet
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ShortName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("counterSet"), &obj.CounterSet, safe.Field(oldObj, func(oldObj *resourcev1.DeviceCounterConsumption) *string { return &oldObj.CounterSet }), oldObj != nil)...)

	// field resourcev1.DeviceCounterConsumption.Counters has no validation
	return errs
}

// Validate_DeviceRequest validates an instance of DeviceRequest according
// to declarative validation rules in the API schema.
func Validate_DeviceRequest(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceRequest) (errs field.ErrorList) {
	// field resourcev1.DeviceRequest.Name has no validation

	// field resourcev1.DeviceRequest.Exactly
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ExactDeviceRequest, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_ExactDeviceRequest(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("exactly"), obj.Exactly, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequest) *resourcev1.ExactDeviceRequest { return oldObj.Exactly }), oldObj != nil)...)

	// field resourcev1.DeviceRequest.FirstAvailable
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceSubRequest, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 8); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceSubRequest, b resourcev1.DeviceSubRequest) bool { return a.Name == b.Name })...)
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a resourcev1.DeviceSubRequest, b resourcev1.DeviceSubRequest) bool { return a.Name == b.Name }, validate.SemanticDeepEqual, Validate_DeviceSubRequest)...)
			return
		}(fldPath.Child("firstAvailable"), obj.FirstAvailable, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequest) []resourcev1.DeviceSubRequest { return oldObj.FirstAvailable }), oldObj != nil)...)

	return errs
}

// Validate_DeviceRequestAllocationResult validates an instance of DeviceRequestAllocationResult according
// to declarative validation rules in the API schema.
func Validate_DeviceRequestAllocationResult(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceRequestAllocationResult) (errs field.ErrorList) {
	// field resourcev1.DeviceRequestAllocationResult.Request has no validation

	// field resourcev1.DeviceRequestAllocationResult.Driver
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.LongNameCaseless(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("driver"), &obj.Driver, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) *string { return &oldObj.Driver }), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.Pool
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ResourcePoolName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("pool"), &obj.Pool, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) *string { return &oldObj.Pool }), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.Device has no validation
	// field resourcev1.DeviceRequestAllocationResult.AdminAccess has no validation

	// field resourcev1.DeviceRequestAllocationResult.Tolerations
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceToleration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceToleration)...)
			return
		}(fldPath.Child("tolerations"), obj.Tolerations, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) []resourcev1.DeviceToleration {
			return oldObj.Tolerations
		}), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.BindingConditions
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 4); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("bindingConditions"), obj.BindingConditions, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) []string { return oldObj.BindingConditions }), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.BindingFailureConditions
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 4); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("bindingFailureConditions"), obj.BindingFailureConditions, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) []string {
			return oldObj.BindingFailureConditions
		}), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.ShareID
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *types.UID, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.UUID(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("shareID"), obj.ShareID, safe.Field(oldObj, func(oldObj *resourcev1.DeviceRequestAllocationResult) *types.UID { return oldObj.ShareID }), oldObj != nil)...)

	// field resourcev1.DeviceRequestAllocationResult.ConsumedCapacity has no validation
	return errs
}

// Validate_DeviceSubRequest validates an instance of DeviceSubRequest according
// to declarative validation rules in the API schema.
func Validate_DeviceSubRequest(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceSubRequest) (errs field.ErrorList) {
	// field resourcev1.DeviceSubRequest.Name has no validation

	// field resourcev1.DeviceSubRequest.DeviceClassName
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.LongName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("deviceClassName"), &obj.DeviceClassName, safe.Field(oldObj, func(oldObj *resourcev1.DeviceSubRequest) *string { return &oldObj.DeviceClassName }), oldObj != nil)...)

	// field resourcev1.DeviceSubRequest.Selectors
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceSelector, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("selectors"), obj.Selectors, safe.Field(oldObj, func(oldObj *resourcev1.DeviceSubRequest) []resourcev1.DeviceSelector { return oldObj.Selectors }), oldObj != nil)...)

	// field resourcev1.DeviceSubRequest.AllocationMode
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationMode, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceAllocationMode(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("allocationMode"), &obj.AllocationMode, safe.Field(oldObj, func(oldObj *resourcev1.DeviceSubRequest) *resourcev1.DeviceAllocationMode {
			return &oldObj.AllocationMode
		}), oldObj != nil)...)

	// field resourcev1.DeviceSubRequest.Count has no validation

	// field resourcev1.DeviceSubRequest.Tolerations
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceToleration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceToleration)...)
			return
		}(fldPath.Child("tolerations"), obj.Tolerations, safe.Field(oldObj, func(oldObj *resourcev1.DeviceSubRequest) []resourcev1.DeviceToleration { return oldObj.Tolerations }), oldObj != nil)...)

	// field resourcev1.DeviceSubRequest.Capacity has no validation
	return errs
}

// Validate_DeviceTaint validates an instance of DeviceTaint according
// to declarative validation rules in the API schema.
func Validate_DeviceTaint(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceTaint) (errs field.ErrorList) {
	// field resourcev1.DeviceTaint.Key has no validation
	// field resourcev1.DeviceTaint.Value has no validation

	// field resourcev1.DeviceTaint.Effect
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceTaintEffect, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceTaintEffect(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("effect"), &obj.Effect, safe.Field(oldObj, func(oldObj *resourcev1.DeviceTaint) *resourcev1.DeviceTaintEffect { return &oldObj.Effect }), oldObj != nil)...)

	// field resourcev1.DeviceTaint.TimeAdded has no validation
	return errs
}

var symbolsForDeviceTaintEffect = sets.New(resourcev1.DeviceTaintEffectNoExecute, resourcev1.DeviceTaintEffectNoSchedule, resourcev1.DeviceTaintEffectNone)

// Validate_DeviceTaintEffect validates an instance of DeviceTaintEffect according
// to declarative validation rules in the API schema.
func Validate_DeviceTaintEffect(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceTaintEffect) (errs field.ErrorList) {
	errs = append(errs, validate.Enum(ctx, op, fldPath, obj, oldObj, symbolsForDeviceTaintEffect, nil)...)

	return errs
}

// Validate_DeviceToleration validates an instance of DeviceToleration according
// to declarative validation rules in the API schema.
func Validate_DeviceToleration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceToleration) (errs field.ErrorList) {
	// field resourcev1.DeviceToleration.Key
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.LabelKey(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("key"), &obj.Key, safe.Field(oldObj, func(oldObj *resourcev1.DeviceToleration) *string { return &oldObj.Key }), oldObj != nil)...)

	// field resourcev1.DeviceToleration.Operator
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceTolerationOperator, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceTolerationOperator(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("operator"), &obj.Operator, safe.Field(oldObj, func(oldObj *resourcev1.DeviceToleration) *resourcev1.DeviceTolerationOperator {
			return &oldObj.Operator
		}), oldObj != nil)...)

	// field resourcev1.DeviceToleration.Value has no validation

	// field resourcev1.DeviceToleration.Effect
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceTaintEffect, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceTaintEffect(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("effect"), &obj.Effect, safe.Field(oldObj, func(oldObj *resourcev1.DeviceToleration) *resourcev1.DeviceTaintEffect { return &oldObj.Effect }), oldObj != nil)...)

	// field resourcev1.DeviceToleration.TolerationSeconds has no validation
	return errs
}

var symbolsForDeviceTolerationOperator = sets.New(resourcev1.DeviceTolerationOpEqual, resourcev1.DeviceTolerationOpExists)

// Validate_DeviceTolerationOperator validates an instance of DeviceTolerationOperator according
// to declarative validation rules in the API schema.
func Validate_DeviceTolerationOperator(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.DeviceTolerationOperator) (errs field.ErrorList) {
	errs = append(errs, validate.Enum(ctx, op, fldPath, obj, oldObj, symbolsForDeviceTolerationOperator, nil)...)

	return errs
}

// Validate_ExactDeviceRequest validates an instance of ExactDeviceRequest according
// to declarative validation rules in the API schema.
func Validate_ExactDeviceRequest(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ExactDeviceRequest) (errs field.ErrorList) {
	// field resourcev1.ExactDeviceRequest.DeviceClassName has no validation

	// field resourcev1.ExactDeviceRequest.Selectors
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceSelector, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 32); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("selectors"), obj.Selectors, safe.Field(oldObj, func(oldObj *resourcev1.ExactDeviceRequest) []resourcev1.DeviceSelector { return oldObj.Selectors }), oldObj != nil)...)

	// field resourcev1.ExactDeviceRequest.AllocationMode
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceAllocationMode, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceAllocationMode(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("allocationMode"), &obj.AllocationMode, safe.Field(oldObj, func(oldObj *resourcev1.ExactDeviceRequest) *resourcev1.DeviceAllocationMode {
			return &oldObj.AllocationMode
		}), oldObj != nil)...)

	// field resourcev1.ExactDeviceRequest.Count has no validation
	// field resourcev1.ExactDeviceRequest.AdminAccess has no validation

	// field resourcev1.ExactDeviceRequest.Tolerations
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.DeviceToleration, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_DeviceToleration)...)
			return
		}(fldPath.Child("tolerations"), obj.Tolerations, safe.Field(oldObj, func(oldObj *resourcev1.ExactDeviceRequest) []resourcev1.DeviceToleration { return oldObj.Tolerations }), oldObj != nil)...)

	// field resourcev1.ExactDeviceRequest.Capacity has no validation
	return errs
}

// Validate_NetworkDeviceData validates an instance of NetworkDeviceData according
// to declarative validation rules in the API schema.
func Validate_NetworkDeviceData(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.NetworkDeviceData) (errs field.ErrorList) {
	// field resourcev1.NetworkDeviceData.InterfaceName
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.MaxLength(ctx, op, fldPath, obj, oldObj, 256)...)
			return
		}(fldPath.Child("interfaceName"), &obj.InterfaceName, safe.Field(oldObj, func(oldObj *resourcev1.NetworkDeviceData) *string { return &oldObj.InterfaceName }), oldObj != nil)...)

	// field resourcev1.NetworkDeviceData.IPs
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 16); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with set semantics require unique values
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("ips"), obj.IPs, safe.Field(oldObj, func(oldObj *resourcev1.NetworkDeviceData) []string { return oldObj.IPs }), oldObj != nil)...)

	// field resourcev1.NetworkDeviceData.HardwareAddress
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.MaxLength(ctx, op, fldPath, obj, oldObj, 128)...)
			return
		}(fldPath.Child("hardwareAddress"), &obj.HardwareAddress, safe.Field(oldObj, func(oldObj *resourcev1.NetworkDeviceData) *string { return &oldObj.HardwareAddress }), oldObj != nil)...)

	return errs
}

// Validate_OpaqueDeviceConfiguration validates an instance of OpaqueDeviceConfiguration according
// to declarative validation rules in the API schema.
func Validate_OpaqueDeviceConfiguration(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.OpaqueDeviceConfiguration) (errs field.ErrorList) {
	// field resourcev1.OpaqueDeviceConfiguration.Driver
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.LongNameCaseless(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("driver"), &obj.Driver, safe.Field(oldObj, func(oldObj *resourcev1.OpaqueDeviceConfiguration) *string { return &oldObj.Driver }), oldObj != nil)...)

	// field resourcev1.OpaqueDeviceConfiguration.Parameters has no validation
	return errs
}

// Validate_ResourceClaim validates an instance of ResourceClaim according
// to declarative validation rules in the API schema.
func Validate_ResourceClaim(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaim) (errs field.ErrorList) {
	// field resourcev1.ResourceClaim.TypeMeta has no validation
	// field resourcev1.ResourceClaim.ObjectMeta has no validation

	// field resourcev1.ResourceClaim.Spec
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimSpec, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.Immutable(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_ResourceClaimSpec(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("spec"), &obj.Spec, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaim) *resourcev1.ResourceClaimSpec { return &oldObj.Spec }), oldObj != nil)...)

	// field resourcev1.ResourceClaim.Status
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimStatus, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_ResourceClaimStatus(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("status"), &obj.Status, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaim) *resourcev1.ResourceClaimStatus { return &oldObj.Status }), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimList validates an instance of ResourceClaimList according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimList(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimList) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimList.TypeMeta has no validation
	// field resourcev1.ResourceClaimList.ListMeta has no validation

	// field resourcev1.ResourceClaimList.Items
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.ResourceClaim, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_ResourceClaim)...)
			return
		}(fldPath.Child("items"), obj.Items, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimList) []resourcev1.ResourceClaim { return oldObj.Items }), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimSpec validates an instance of ResourceClaimSpec according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimSpec(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimSpec) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimSpec.Devices
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.DeviceClaim, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_DeviceClaim(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("devices"), &obj.Devices, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimSpec) *resourcev1.DeviceClaim { return &oldObj.Devices }), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimStatus validates an instance of ResourceClaimStatus according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimStatus(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimStatus) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimStatus.Allocation
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.AllocationResult, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if e := validate.UpdatePointer(ctx, op, fldPath, obj, oldObj, validate.NoModify); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// call the type's validation function
			errs = append(errs, Validate_AllocationResult(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("allocation"), obj.Allocation, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimStatus) *resourcev1.AllocationResult { return oldObj.Allocation }), oldObj != nil)...)

	// field resourcev1.ResourceClaimStatus.ReservedFor
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.ResourceClaimConsumerReference, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 256); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.ResourceClaimConsumerReference, b resourcev1.ResourceClaimConsumerReference) bool {
				return a.UID == b.UID
			})...)
			return
		}(fldPath.Child("reservedFor"), obj.ReservedFor, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimStatus) []resourcev1.ResourceClaimConsumerReference {
			return oldObj.ReservedFor
		}), oldObj != nil)...)

	// field resourcev1.ResourceClaimStatus.Devices
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.AllocatedDeviceStatus, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.AllocatedDeviceStatus, b resourcev1.AllocatedDeviceStatus) bool {
				return a.Driver == b.Driver && a.Device == b.Device && a.Pool == b.Pool && ((a.ShareID == nil && b.ShareID == nil) || (a.ShareID != nil && b.ShareID != nil && *a.ShareID == *b.ShareID))
			})...)
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a resourcev1.AllocatedDeviceStatus, b resourcev1.AllocatedDeviceStatus) bool {
				return a.Driver == b.Driver && a.Device == b.Device && a.Pool == b.Pool && ((a.ShareID == nil && b.ShareID == nil) || (a.ShareID != nil && b.ShareID != nil && *a.ShareID == *b.ShareID))
			}, validate.SemanticDeepEqual, Validate_AllocatedDeviceStatus)...)
			return
		}(fldPath.Child("devices"), obj.Devices, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimStatus) []resourcev1.AllocatedDeviceStatus { return oldObj.Devices }), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimTemplate validates an instance of ResourceClaimTemplate according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimTemplate(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimTemplate) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimTemplate.TypeMeta has no validation
	// field resourcev1.ResourceClaimTemplate.ObjectMeta has no validation

	// field resourcev1.ResourceClaimTemplate.Spec
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimTemplateSpec, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_ResourceClaimTemplateSpec(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("spec"), &obj.Spec, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimTemplate) *resourcev1.ResourceClaimTemplateSpec {
			return &oldObj.Spec
		}), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimTemplateList validates an instance of ResourceClaimTemplateList according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimTemplateList(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimTemplateList) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimTemplateList.TypeMeta has no validation
	// field resourcev1.ResourceClaimTemplateList.ListMeta has no validation

	// field resourcev1.ResourceClaimTemplateList.Items
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.ResourceClaimTemplate, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_ResourceClaimTemplate)...)
			return
		}(fldPath.Child("items"), obj.Items, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimTemplateList) []resourcev1.ResourceClaimTemplate {
			return oldObj.Items
		}), oldObj != nil)...)

	return errs
}

// Validate_ResourceClaimTemplateSpec validates an instance of ResourceClaimTemplateSpec according
// to declarative validation rules in the API schema.
func Validate_ResourceClaimTemplateSpec(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimTemplateSpec) (errs field.ErrorList) {
	// field resourcev1.ResourceClaimTemplateSpec.ObjectMeta has no validation

	// field resourcev1.ResourceClaimTemplateSpec.Spec
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ResourceClaimSpec, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_ResourceClaimSpec(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("spec"), &obj.Spec, safe.Field(oldObj, func(oldObj *resourcev1.ResourceClaimTemplateSpec) *resourcev1.ResourceClaimSpec { return &oldObj.Spec }), oldObj != nil)...)

	return errs
}

// Validate_ResourceSlice validates an instance of ResourceSlice according
// to declarative validation rules in the API schema.
func Validate_ResourceSlice(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceSlice) (errs field.ErrorList) {
	// field resourcev1.ResourceSlice.TypeMeta has no validation
	// field resourcev1.ResourceSlice.ObjectMeta has no validation

	// field resourcev1.ResourceSlice.Spec
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *resourcev1.ResourceSliceSpec, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_ResourceSliceSpec(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("spec"), &obj.Spec, safe.Field(oldObj, func(oldObj *resourcev1.ResourceSlice) *resourcev1.ResourceSliceSpec { return &oldObj.Spec }), oldObj != nil)...)

	return errs
}

// Validate_ResourceSliceList validates an instance of ResourceSliceList according
// to declarative validation rules in the API schema.
func Validate_ResourceSliceList(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceSliceList) (errs field.ErrorList) {
	// field resourcev1.ResourceSliceList.TypeMeta has no validation
	// field resourcev1.ResourceSliceList.ListMeta has no validation

	// field resourcev1.ResourceSliceList.Items
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.ResourceSlice, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_ResourceSlice)...)
			return
		}(fldPath.Child("items"), obj.Items, safe.Field(oldObj, func(oldObj *resourcev1.ResourceSliceList) []resourcev1.ResourceSlice { return oldObj.Items }), oldObj != nil)...)

	return errs
}

// Validate_ResourceSliceSpec validates an instance of ResourceSliceSpec according
// to declarative validation rules in the API schema.
func Validate_ResourceSliceSpec(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *resourcev1.ResourceSliceSpec) (errs field.ErrorList) {
	// field resourcev1.ResourceSliceSpec.Driver has no validation
	// field resourcev1.ResourceSliceSpec.Pool has no validation
	// field resourcev1.ResourceSliceSpec.NodeName has no validation
	// field resourcev1.ResourceSliceSpec.NodeSelector has no validation
	// field resourcev1.ResourceSliceSpec.AllNodes has no validation

	// field resourcev1.ResourceSliceSpec.Devices
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.Device, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_Device)...)
			return
		}(fldPath.Child("devices"), obj.Devices, safe.Field(oldObj, func(oldObj *resourcev1.ResourceSliceSpec) []resourcev1.Device { return oldObj.Devices }), oldObj != nil)...)

	// field resourcev1.ResourceSliceSpec.PerDeviceNodeSelection has no validation

	// field resourcev1.ResourceSliceSpec.SharedCounters
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []resourcev1.CounterSet, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.MaxItems(ctx, op, fldPath, obj, oldObj, 8); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			// lists with map semantics require unique keys
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, func(a resourcev1.CounterSet, b resourcev1.CounterSet) bool { return a.Name == b.Name })...)
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a resourcev1.CounterSet, b resourcev1.CounterSet) bool { return a.Name == b.Name }, validate.SemanticDeepEqual, Validate_CounterSet)...)
			return
		}(fldPath.Child("sharedCounters"), obj.SharedCounters, safe.Field(oldObj, func(oldObj *resourcev1.ResourceSliceSpec) []resourcev1.CounterSet { return oldObj.SharedCounters }), oldObj != nil)...)

	return errs
}
