/*
 * Copyright Imagination Technologies Ltd.
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

enum pco_usclib_target {
    PCO_USCLIB_TARGET_COMMON = 0,
    PCO_USCLIB_NUM_TARGETS,
};
extern const uint64_t pco_usclib_target_id_map[PCO_USCLIB_NUM_TARGETS];
enum pco_usclib_program {
    VS_NOP_COMMON = 0,
    FS_NOP_COMMON = 1,
    CS_NOP_COMMON = 2,
    VS_PASSTHROUGH_COMMON = 3,
    VS_PASSTHROUGH_RTA_COMMON = 4,
    CS_QUERY_AVAILABILITY_COMMON = 5,
    CS_QUERY_COPY_COMMON = 6,
    CS_QUERY_RESET_COMMON = 7,
    CS_STORE_SR_1024_COMMON = 8,
    CS_LOAD_SR_256_COMMON = 9,
    CS_LOAD_SR_16_COMMON = 10,
    CS_IDFWDF_COMMON = 11,
    PCO_USCLIB_NUM_PROGRAMS,
};


#define vs_nop_common_struct(_context, _grid, _barrier, _data) do { \
   struct vs_nop_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define vs_nop_common(_context, _grid, _barrier) do { \
   struct vs_nop_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define fs_nop_common_struct(_context, _grid, _barrier, _data) do { \
   struct fs_nop_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, FS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define fs_nop_common(_context, _grid, _barrier) do { \
   struct fs_nop_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, FS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_nop_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_nop_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_nop_common(_context, _grid, _barrier) do { \
   struct cs_nop_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_NOP_COMMON, &_args, sizeof(_args)); \
} while(0);

#define vs_passthrough_common_struct(_context, _grid, _barrier, _data) do { \
   struct vs_passthrough_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_PASSTHROUGH_COMMON, &_args, sizeof(_args)); \
} while(0);

#define vs_passthrough_common(_context, _grid, _barrier) do { \
   struct vs_passthrough_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_PASSTHROUGH_COMMON, &_args, sizeof(_args)); \
} while(0);

#define vs_passthrough_rta_common_struct(_context, _grid, _barrier, _data) do { \
   struct vs_passthrough_rta_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_PASSTHROUGH_RTA_COMMON, &_args, sizeof(_args)); \
} while(0);

#define vs_passthrough_rta_common(_context, _grid, _barrier) do { \
   struct vs_passthrough_rta_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, VS_PASSTHROUGH_RTA_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_availability_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_query_availability_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_AVAILABILITY_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_availability_common(_context, _grid, _barrier) do { \
   struct cs_query_availability_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_AVAILABILITY_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_copy_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_query_copy_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_COPY_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_copy_common(_context, _grid, _barrier) do { \
   struct cs_query_copy_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_COPY_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_reset_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_query_reset_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_RESET_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_query_reset_common(_context, _grid, _barrier) do { \
   struct cs_query_reset_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_QUERY_RESET_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_store_sr_1024_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_store_sr_1024_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_STORE_SR_1024_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_store_sr_1024_common(_context, _grid, _barrier) do { \
   struct cs_store_sr_1024_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_STORE_SR_1024_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_load_sr_256_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_load_sr_256_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_LOAD_SR_256_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_load_sr_256_common(_context, _grid, _barrier) do { \
   struct cs_load_sr_256_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_LOAD_SR_256_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_load_sr_16_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_load_sr_16_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_LOAD_SR_16_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_load_sr_16_common(_context, _grid, _barrier) do { \
   struct cs_load_sr_16_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_LOAD_SR_16_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_idfwdf_common_struct(_context, _grid, _barrier, _data) do { \
   struct cs_idfwdf_common_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_IDFWDF_COMMON, &_args, sizeof(_args)); \
} while(0);

#define cs_idfwdf_common(_context, _grid, _barrier) do { \
   struct cs_idfwdf_common_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, CS_IDFWDF_COMMON, &_args, sizeof(_args)); \
} while(0);


struct vs_nop_common_args {
} PACKED;

static_assert(sizeof(struct vs_nop_common_args) == 0, "");

struct fs_nop_common_args {
} PACKED;

static_assert(sizeof(struct fs_nop_common_args) == 0, "");

struct cs_nop_common_args {
} PACKED;

static_assert(sizeof(struct cs_nop_common_args) == 0, "");

struct vs_passthrough_common_args {
} PACKED;

static_assert(sizeof(struct vs_passthrough_common_args) == 0, "");

struct vs_passthrough_rta_common_args {
} PACKED;

static_assert(sizeof(struct vs_passthrough_rta_common_args) == 0, "");

struct cs_query_availability_common_args {
} PACKED;

static_assert(sizeof(struct cs_query_availability_common_args) == 0, "");

struct cs_query_copy_common_args {
} PACKED;

static_assert(sizeof(struct cs_query_copy_common_args) == 0, "");

struct cs_query_reset_common_args {
} PACKED;

static_assert(sizeof(struct cs_query_reset_common_args) == 0, "");

struct cs_store_sr_1024_common_args {
} PACKED;

static_assert(sizeof(struct cs_store_sr_1024_common_args) == 0, "");

struct cs_load_sr_256_common_args {
} PACKED;

static_assert(sizeof(struct cs_load_sr_256_common_args) == 0, "");

struct cs_load_sr_16_common_args {
} PACKED;

static_assert(sizeof(struct cs_load_sr_16_common_args) == 0, "");

struct cs_idfwdf_common_args {
} PACKED;

static_assert(sizeof(struct cs_idfwdf_common_args) == 0, "");

extern const uint32_t *pco_usclib_common[PCO_USCLIB_NUM_PROGRAMS];
extern const uint32_t **pco_usclib_targets[PCO_USCLIB_NUM_TARGETS];
extern const uint32_t pco_usclib_0_nir[4172];
