#ifndef A6XX_XML_STRUCTS
#define A6XX_XML_STRUCTS

/* Autogenerated file, DO NOT EDIT manually! */

#ifdef __KERNEL__
#include <linux/bug.h>
#define assert(x) BUG_ON(!(x))
#else
#include <assert.h>
#endif

#ifdef __cplusplus
#define __struct_cast(X)
#define CONSTEXPR constexpr
#else
#define __struct_cast(X) (struct X)
#define CONSTEXPR
#endif

#if defined(__clang__) && !defined(FD_NO_DEPRECATED_PACK)
#define __FD_DEPRECATED _Pragma ("GCC warning \"Deprecated reg builder\"")
#else
#define __FD_DEPRECATED
#endif

struct A6XX_CP_RB_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_RB_BASE(struct A6XX_CP_RB_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000800,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_RB_BASE(...) pack_A6XX_CP_RB_BASE(__struct_cast(A6XX_CP_RB_BASE) { __VA_ARGS__ })

struct A6XX_CP_RB_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_RB_CNTL(struct A6XX_CP_RB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000802,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_CNTL(...) pack_A6XX_CP_RB_CNTL(__struct_cast(A6XX_CP_RB_CNTL) { __VA_ARGS__ })

struct A7XX_CP_RB_RPTR_WR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_RB_RPTR_WR(...) pack_A7XX_CP_RB_RPTR_WR(__struct_cast(A7XX_CP_RB_RPTR_WR) { __VA_ARGS__ })

struct A6XX_CP_RB_RPTR_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_RB_RPTR_ADDR(struct A6XX_CP_RB_RPTR_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000804,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_RB_RPTR_ADDR(...) pack_A6XX_CP_RB_RPTR_ADDR(__struct_cast(A6XX_CP_RB_RPTR_ADDR) { __VA_ARGS__ })

struct A6XX_CP_RB_RPTR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_RB_RPTR(struct A6XX_CP_RB_RPTR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000806,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_RPTR(...) pack_A6XX_CP_RB_RPTR(__struct_cast(A6XX_CP_RB_RPTR) { __VA_ARGS__ })

struct A6XX_CP_RB_WPTR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_RB_WPTR(struct A6XX_CP_RB_WPTR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000807,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_WPTR(...) pack_A6XX_CP_RB_WPTR(__struct_cast(A6XX_CP_RB_WPTR) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_ADDR_BV {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_RPTR_ADDR_BV(...) pack_A8XX_CP_RB_RPTR_ADDR_BV(__struct_cast(A8XX_CP_RB_RPTR_ADDR_BV) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_BV {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_RPTR_BV(...) pack_A8XX_CP_RB_RPTR_BV(__struct_cast(A8XX_CP_RB_RPTR_BV) { __VA_ARGS__ })

struct A8XX_CP_RB_BASE_LPAC {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_RB_BASE_LPAC(...) pack_A8XX_CP_RB_BASE_LPAC(__struct_cast(A8XX_CP_RB_BASE_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_CNTL_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_CNTL_LPAC(...) pack_A8XX_CP_RB_CNTL_LPAC(__struct_cast(A8XX_CP_RB_CNTL_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_WR_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_RPTR_WR_LPAC(...) pack_A8XX_CP_RB_RPTR_WR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_WR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_ADDR_LPAC {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_RB_RPTR_ADDR_LPAC(...) pack_A8XX_CP_RB_RPTR_ADDR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_ADDR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_RPTR_LPAC(...) pack_A8XX_CP_RB_RPTR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_WPTR_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RB_WPTR_LPAC(...) pack_A8XX_CP_RB_WPTR_LPAC(__struct_cast(A8XX_CP_RB_WPTR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_SMMU_STREAM_ID_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SMMU_STREAM_ID_LPAC(...) pack_A8XX_CP_SMMU_STREAM_ID_LPAC(__struct_cast(A8XX_CP_SMMU_STREAM_ID_LPAC) { __VA_ARGS__ })

struct A6XX_CP_SQE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SQE_CNTL(...) pack_A6XX_CP_SQE_CNTL(__struct_cast(A6XX_CP_SQE_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_CNTL(...) pack_A8XX_CP_SQE_CNTL(__struct_cast(A8XX_CP_SQE_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_INSTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_SQE_INSTR_BASE(...) pack_A8XX_CP_SQE_INSTR_BASE(__struct_cast(A8XX_CP_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A8XX_CP_AQE_INSTR_BASE_0 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_AQE_INSTR_BASE_0(...) pack_A8XX_CP_AQE_INSTR_BASE_0(__struct_cast(A8XX_CP_AQE_INSTR_BASE_0) { __VA_ARGS__ })

struct A8XX_CP_AQE_INSTR_BASE_1 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_AQE_INSTR_BASE_1(...) pack_A8XX_CP_AQE_INSTR_BASE_1(__struct_cast(A8XX_CP_AQE_INSTR_BASE_1) { __VA_ARGS__ })

struct A6XX_CP_CP2GMU_STATUS {
    bool							ifpc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_CP2GMU_STATUS(...) pack_A6XX_CP_CP2GMU_STATUS(__struct_cast(A6XX_CP_CP2GMU_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CP2GMU_STATUS {
    bool							ifpc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CP2GMU_STATUS(...) pack_A8XX_CP_CP2GMU_STATUS(__struct_cast(A8XX_CP_CP2GMU_STATUS) { __VA_ARGS__ })

struct A6XX_CP_HW_FAULT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_HW_FAULT(...) pack_A6XX_CP_HW_FAULT(__struct_cast(A6XX_CP_HW_FAULT) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_STATUS {
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_PROTECT_STATUS(...) pack_A6XX_CP_PROTECT_STATUS(__struct_cast(A6XX_CP_PROTECT_STATUS) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_STATUS_PIPE {
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PROTECT_STATUS_PIPE(...) pack_A8XX_CP_PROTECT_STATUS_PIPE(__struct_cast(A8XX_CP_PROTECT_STATUS_PIPE) { __VA_ARGS__ })

struct A6XX_CP_STATUS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_STATUS_1(...) pack_A6XX_CP_STATUS_1(__struct_cast(A6XX_CP_STATUS_1) { __VA_ARGS__ })

struct A8XX_CP_SEMAPHORE_REG_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SEMAPHORE_REG_0(...) pack_A8XX_CP_SEMAPHORE_REG_0(__struct_cast(A8XX_CP_SEMAPHORE_REG_0) { __VA_ARGS__ })

struct A8XX_CP_SCRATCH_GLOBAL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SCRATCH_GLOBAL_REG(__i, ...) pack_A8XX_CP_SCRATCH_GLOBAL_REG(__i, __struct_cast(A8XX_CP_SCRATCH_GLOBAL_REG) { __VA_ARGS__ })

struct A8XX_CP_SCRATCH_PIPE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SCRATCH_PIPE_REG(__i, ...) pack_A8XX_CP_SCRATCH_PIPE_REG(__i, __struct_cast(A8XX_CP_SCRATCH_PIPE_REG) { __VA_ARGS__ })

struct A8XX_CP_RL_ERROR_DETAILS_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RL_ERROR_DETAILS_0(...) pack_A8XX_CP_RL_ERROR_DETAILS_0(__struct_cast(A8XX_CP_RL_ERROR_DETAILS_0) { __VA_ARGS__ })

struct A8XX_CP_RL_ERROR_DETAILS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RL_ERROR_DETAILS_1(...) pack_A8XX_CP_RL_ERROR_DETAILS_1(__struct_cast(A8XX_CP_RL_ERROR_DETAILS_1) { __VA_ARGS__ })

struct A6XX_CP_SQE_INSTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_SQE_INSTR_BASE(...) pack_A6XX_CP_SQE_INSTR_BASE(__struct_cast(A6XX_CP_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A6XX_CP_MISC_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MISC_CNTL(...) pack_A6XX_CP_MISC_CNTL(__struct_cast(A6XX_CP_MISC_CNTL) { __VA_ARGS__ })

struct A8XX_CP_MISC_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_MISC_CNTL(...) pack_A8XX_CP_MISC_CNTL(__struct_cast(A8XX_CP_MISC_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_ICACHE_CNTL_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_ICACHE_CNTL_PIPE(...) pack_A8XX_CP_SQE_ICACHE_CNTL_PIPE(__struct_cast(A8XX_CP_SQE_ICACHE_CNTL_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_DCACHE_CNTL_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_DCACHE_CNTL_PIPE(...) pack_A8XX_CP_SQE_DCACHE_CNTL_PIPE(__struct_cast(A8XX_CP_SQE_DCACHE_CNTL_PIPE) { __VA_ARGS__ })

struct A8XX_CP_HW_FAULT_STATUS_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_HW_FAULT_STATUS_PIPE(...) pack_A8XX_CP_HW_FAULT_STATUS_PIPE(__struct_cast(A8XX_CP_HW_FAULT_STATUS_PIPE) { __VA_ARGS__ })

struct A8XX_CP_HW_FAULT_STATUS_MASK_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE(...) pack_A8XX_CP_HW_FAULT_STATUS_MASK_PIPE(__struct_cast(A8XX_CP_HW_FAULT_STATUS_MASK_PIPE) { __VA_ARGS__ })

struct A8XX_CP_INTERRUPT_STATUS_MASK_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE(...) pack_A8XX_CP_INTERRUPT_STATUS_MASK_PIPE(__struct_cast(A8XX_CP_INTERRUPT_STATUS_MASK_PIPE) { __VA_ARGS__ })

struct A8XX_CP_PIPE_STATUS_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PIPE_STATUS_PIPE(...) pack_A8XX_CP_PIPE_STATUS_PIPE(__struct_cast(A8XX_CP_PIPE_STATUS_PIPE) { __VA_ARGS__ })

struct A8XX_CP_GPU_BATCH_ID_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_GPU_BATCH_ID_PIPE(...) pack_A8XX_CP_GPU_BATCH_ID_PIPE(__struct_cast(A8XX_CP_GPU_BATCH_ID_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_STATUS_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_STATUS_PIPE(...) pack_A8XX_CP_SQE_STATUS_PIPE(__struct_cast(A8XX_CP_SQE_STATUS_PIPE) { __VA_ARGS__ })

struct A6XX_CP_APRIV_CNTL {
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_APRIV_CNTL(...) pack_A6XX_CP_APRIV_CNTL(__struct_cast(A6XX_CP_APRIV_CNTL) { __VA_ARGS__ })

struct A8XX_CP_APRIV_CNTL_PIPE {
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_APRIV_CNTL_PIPE(...) pack_A8XX_CP_APRIV_CNTL_PIPE(__struct_cast(A8XX_CP_APRIV_CNTL_PIPE) { __VA_ARGS__ })

struct A6XX_CP_PREEMPT_THRESHOLD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_PREEMPT_THRESHOLD(...) pack_A6XX_CP_PREEMPT_THRESHOLD(__struct_cast(A6XX_CP_PREEMPT_THRESHOLD) { __VA_ARGS__ })

struct A8XX_CP_PREEMPT_THRESHOLD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PREEMPT_THRESHOLD(...) pack_A8XX_CP_PREEMPT_THRESHOLD(__struct_cast(A8XX_CP_PREEMPT_THRESHOLD) { __VA_ARGS__ })

struct A6XX_CP_ROQ_THRESHOLDS_1 {
    uint32_t							mrb_start;
    uint32_t							vsd_start;
    uint32_t							ib1_start;
    uint32_t							ib2_start;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_THRESHOLDS_1(...) pack_A6XX_CP_ROQ_THRESHOLDS_1(__struct_cast(A6XX_CP_ROQ_THRESHOLDS_1) { __VA_ARGS__ })

struct A6XX_CP_ROQ_THRESHOLDS_2 {
    uint32_t							sds_start;
    uint32_t							roq_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_THRESHOLDS_2(...) pack_A6XX_CP_ROQ_THRESHOLDS_2(__struct_cast(A6XX_CP_ROQ_THRESHOLDS_2) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MEM_POOL_SIZE(...) pack_A6XX_CP_MEM_POOL_SIZE(__struct_cast(A6XX_CP_MEM_POOL_SIZE) { __VA_ARGS__ })

struct A6XX_CP_CHICKEN_DBG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_CHICKEN_DBG(...) pack_A6XX_CP_CHICKEN_DBG(__struct_cast(A6XX_CP_CHICKEN_DBG) { __VA_ARGS__ })

struct A8XX_CP_CHICKEN_DBG_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CHICKEN_DBG_PIPE(...) pack_A8XX_CP_CHICKEN_DBG_PIPE(__struct_cast(A8XX_CP_CHICKEN_DBG_PIPE) { __VA_ARGS__ })

struct A6XX_CP_ADDR_MODE_CNTL {
    enum a5xx_address_mode					cp_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ADDR_MODE_CNTL(...) pack_A6XX_CP_ADDR_MODE_CNTL(__struct_cast(A6XX_CP_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_CP_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_DBG_ECO_CNTL(...) pack_A6XX_CP_DBG_ECO_CNTL(__struct_cast(A6XX_CP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_CP_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_DBG_ECO_CNTL(...) pack_A8XX_CP_DBG_ECO_CNTL(__struct_cast(A8XX_CP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_CNTL {
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_PROTECT_CNTL(...) pack_A6XX_CP_PROTECT_CNTL(__struct_cast(A6XX_CP_PROTECT_CNTL) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_CNTL_PIPE {
    uint32_t							halt_sqe_range;
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PROTECT_CNTL_PIPE(...) pack_A8XX_CP_PROTECT_CNTL_PIPE(__struct_cast(A8XX_CP_PROTECT_CNTL_PIPE) { __VA_ARGS__ })

struct A6XX_CP_SCRATCH_REG {
    uint32_t							cp_scratch_reg;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SCRATCH_REG(__i, ...) pack_A6XX_CP_SCRATCH_REG(__i, __struct_cast(A6XX_CP_SCRATCH_REG) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_PROTECT_REG(__i, ...) pack_A6XX_CP_PROTECT_REG(__i, __struct_cast(A6XX_CP_PROTECT_REG) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_GLOBAL_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PROTECT_GLOBAL_REG(__i, ...) pack_A8XX_CP_PROTECT_GLOBAL_REG(__i, __struct_cast(A8XX_CP_PROTECT_GLOBAL_REG) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_PIPE_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PROTECT_PIPE_REG(__i, ...) pack_A8XX_CP_PROTECT_PIPE_REG(__i, __struct_cast(A8XX_CP_PROTECT_PIPE_REG) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_CNTL {
    bool							stop;
    uint32_t							level;
    bool							uses_gmem;
    bool							skip_save_restore;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_CONTEXT_SWITCH_CNTL(...) pack_A6XX_CP_CONTEXT_SWITCH_CNTL(__struct_cast(A6XX_CP_CONTEXT_SWITCH_CNTL) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_CNTL {
    bool							stop;
    uint32_t							level;
    bool							uses_gmem;
    bool							skip_save_restore;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_CNTL(...) pack_A8XX_CP_CONTEXT_SWITCH_CNTL(__struct_cast(A8XX_CP_CONTEXT_SWITCH_CNTL) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_SMMU_INFO {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_CONTEXT_SWITCH_SMMU_INFO(...) pack_A6XX_CP_CONTEXT_SWITCH_SMMU_INFO(__struct_cast(A6XX_CP_CONTEXT_SWITCH_SMMU_INFO) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(...) pack_A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(__struct_cast(A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_SMMU_INFO {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_SMMU_INFO(...) pack_A8XX_CP_CONTEXT_SWITCH_SMMU_INFO(__struct_cast(A8XX_CP_CONTEXT_SWITCH_SMMU_INFO) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(...) pack_A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(__struct_cast(A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS) { __VA_ARGS__ })

struct A6XX_CP_PERFCTR_CP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_PERFCTR_CP_SEL_REG(__i, ...) pack_A6XX_CP_PERFCTR_CP_SEL_REG(__i, __struct_cast(A6XX_CP_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A8XX_CP_PERFCTR_CP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_PERFCTR_CP_SEL_REG(__i, ...) pack_A8XX_CP_PERFCTR_CP_SEL_REG(__i, __struct_cast(A8XX_CP_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A7XX_CP_BV_PERFCTR_CP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_PERFCTR_CP_SEL_REG(__i, ...) pack_A7XX_CP_BV_PERFCTR_CP_SEL_REG(__i, __struct_cast(A7XX_CP_BV_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_SCRIPT_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_CRASH_DUMP_SCRIPT_BASE(...) pack_A6XX_CP_CRASH_DUMP_SCRIPT_BASE(__struct_cast(A6XX_CP_CRASH_DUMP_SCRIPT_BASE) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_CRASH_DUMP_CNTL(...) pack_A6XX_CP_CRASH_DUMP_CNTL(__struct_cast(A6XX_CP_CRASH_DUMP_CNTL) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_CRASH_DUMP_STATUS(...) pack_A6XX_CP_CRASH_DUMP_STATUS(__struct_cast(A6XX_CP_CRASH_DUMP_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_SCRIPT_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_CRASH_DUMP_SCRIPT_BASE(...) pack_A8XX_CP_CRASH_DUMP_SCRIPT_BASE(__struct_cast(A8XX_CP_CRASH_DUMP_SCRIPT_BASE) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CRASH_DUMP_CNTL(...) pack_A8XX_CP_CRASH_DUMP_CNTL(__struct_cast(A8XX_CP_CRASH_DUMP_CNTL) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_CRASH_DUMP_STATUS(...) pack_A8XX_CP_CRASH_DUMP_STATUS(__struct_cast(A8XX_CP_CRASH_DUMP_STATUS) { __VA_ARGS__ })

struct A6XX_CP_SQE_STAT_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SQE_STAT_ADDR(...) pack_A6XX_CP_SQE_STAT_ADDR(__struct_cast(A6XX_CP_SQE_STAT_ADDR) { __VA_ARGS__ })

struct A6XX_CP_SQE_STAT_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SQE_STAT_DATA(...) pack_A6XX_CP_SQE_STAT_DATA(__struct_cast(A6XX_CP_SQE_STAT_DATA) { __VA_ARGS__ })

struct A6XX_CP_DRAW_STATE_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_DRAW_STATE_ADDR(...) pack_A6XX_CP_DRAW_STATE_ADDR(__struct_cast(A6XX_CP_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_DRAW_STATE_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_DRAW_STATE_DATA(...) pack_A6XX_CP_DRAW_STATE_DATA(__struct_cast(A6XX_CP_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A6XX_CP_ROQ_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_DBG_ADDR(...) pack_A6XX_CP_ROQ_DBG_ADDR(__struct_cast(A6XX_CP_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_ROQ_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_DBG_DATA(...) pack_A6XX_CP_ROQ_DBG_DATA(__struct_cast(A6XX_CP_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MEM_POOL_DBG_ADDR(...) pack_A6XX_CP_MEM_POOL_DBG_ADDR(__struct_cast(A6XX_CP_MEM_POOL_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MEM_POOL_DBG_DATA(...) pack_A6XX_CP_MEM_POOL_DBG_DATA(__struct_cast(A6XX_CP_MEM_POOL_DBG_DATA) { __VA_ARGS__ })

struct A6XX_CP_SQE_UCODE_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SQE_UCODE_DBG_ADDR(...) pack_A6XX_CP_SQE_UCODE_DBG_ADDR(__struct_cast(A6XX_CP_SQE_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_SQE_UCODE_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SQE_UCODE_DBG_DATA(...) pack_A6XX_CP_SQE_UCODE_DBG_DATA(__struct_cast(A6XX_CP_SQE_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A8XX_CP_SQE_STAT_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_STAT_ADDR_PIPE(...) pack_A8XX_CP_SQE_STAT_ADDR_PIPE(__struct_cast(A8XX_CP_SQE_STAT_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_STAT_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_STAT_DATA_PIPE(...) pack_A8XX_CP_SQE_STAT_DATA_PIPE(__struct_cast(A8XX_CP_SQE_STAT_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_DRAW_STATE_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_DRAW_STATE_ADDR_PIPE(...) pack_A8XX_CP_DRAW_STATE_ADDR_PIPE(__struct_cast(A8XX_CP_DRAW_STATE_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_DRAW_STATE_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_DRAW_STATE_DATA_PIPE(...) pack_A8XX_CP_DRAW_STATE_DATA_PIPE(__struct_cast(A8XX_CP_DRAW_STATE_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_ROQ_DBG_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_DBG_ADDR_PIPE(...) pack_A8XX_CP_ROQ_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_ROQ_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_ROQ_DBG_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_DBG_DATA_PIPE(...) pack_A8XX_CP_ROQ_DBG_DATA_PIPE(__struct_cast(A8XX_CP_ROQ_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_MEM_POOL_DBG_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_MEM_POOL_DBG_ADDR_PIPE(...) pack_A8XX_CP_MEM_POOL_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_MEM_POOL_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_MEM_POOL_DBG_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_MEM_POOL_DBG_DATA_PIPE(...) pack_A8XX_CP_MEM_POOL_DBG_DATA_PIPE(__struct_cast(A8XX_CP_MEM_POOL_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE(...) pack_A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_UCODE_DBG_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SQE_UCODE_DBG_DATA_PIPE(...) pack_A8XX_CP_SQE_UCODE_DBG_DATA_PIPE(__struct_cast(A8XX_CP_SQE_UCODE_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV(...) pack_A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV(__struct_cast(A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV) { __VA_ARGS__ })

struct A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV(...) pack_A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV(__struct_cast(A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_ADDR_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_FIFO_DBG_ADDR_LPAC(...) pack_A8XX_CP_FIFO_DBG_ADDR_LPAC(__struct_cast(A8XX_CP_FIFO_DBG_ADDR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_DATA_LPAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_FIFO_DBG_DATA_LPAC(...) pack_A8XX_CP_FIFO_DBG_DATA_LPAC(__struct_cast(A8XX_CP_FIFO_DBG_DATA_LPAC) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE(...) pack_A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE(__struct_cast(A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_DATA_DDE_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_FIFO_DBG_DATA_DDE_PIPE(...) pack_A8XX_CP_FIFO_DBG_DATA_DDE_PIPE(__struct_cast(A8XX_CP_FIFO_DBG_DATA_DDE_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(...) pack_A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE(...) pack_A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE(__struct_cast(A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_CHICKEN_DBG_PIPE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SLICE_CHICKEN_DBG_PIPE(...) pack_A8XX_CP_SLICE_CHICKEN_DBG_PIPE(__struct_cast(A8XX_CP_SLICE_CHICKEN_DBG_PIPE) { __VA_ARGS__ })

struct A6XX_CP_IB1_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_IB1_BASE(...) pack_A6XX_CP_IB1_BASE(__struct_cast(A6XX_CP_IB1_BASE) { __VA_ARGS__ })

struct A6XX_CP_IB1_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_IB1_REM_SIZE(...) pack_A6XX_CP_IB1_REM_SIZE(__struct_cast(A6XX_CP_IB1_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_IB2_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_IB2_BASE(...) pack_A6XX_CP_IB2_BASE(__struct_cast(A6XX_CP_IB2_BASE) { __VA_ARGS__ })

struct A6XX_CP_IB2_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_IB2_REM_SIZE(...) pack_A6XX_CP_IB2_REM_SIZE(__struct_cast(A6XX_CP_IB2_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_SDS_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_SDS_BASE(...) pack_A6XX_CP_SDS_BASE(__struct_cast(A6XX_CP_SDS_BASE) { __VA_ARGS__ })

struct A6XX_CP_SDS_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SDS_REM_SIZE(...) pack_A6XX_CP_SDS_REM_SIZE(__struct_cast(A6XX_CP_SDS_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_MRB_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_MRB_BASE(...) pack_A6XX_CP_MRB_BASE(__struct_cast(A6XX_CP_MRB_BASE) { __VA_ARGS__ })

struct A6XX_CP_MRB_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MRB_REM_SIZE(...) pack_A6XX_CP_MRB_REM_SIZE(__struct_cast(A6XX_CP_MRB_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_VSD_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_VSD_BASE(...) pack_A6XX_CP_VSD_BASE(__struct_cast(A6XX_CP_VSD_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB1_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_IB1_BASE(...) pack_A8XX_CP_IB1_BASE(__struct_cast(A8XX_CP_IB1_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB1_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB1_REM_SIZE(...) pack_A8XX_CP_IB1_REM_SIZE(__struct_cast(A8XX_CP_IB1_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB1_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB1_INIT_SIZE(...) pack_A8XX_CP_IB1_INIT_SIZE(__struct_cast(A8XX_CP_IB1_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB2_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_IB2_BASE(...) pack_A8XX_CP_IB2_BASE(__struct_cast(A8XX_CP_IB2_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB2_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB2_REM_SIZE(...) pack_A8XX_CP_IB2_REM_SIZE(__struct_cast(A8XX_CP_IB2_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB2_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB2_INIT_SIZE(...) pack_A8XX_CP_IB2_INIT_SIZE(__struct_cast(A8XX_CP_IB2_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB3_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_IB3_BASE(...) pack_A8XX_CP_IB3_BASE(__struct_cast(A8XX_CP_IB3_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB3_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB3_REM_SIZE(...) pack_A8XX_CP_IB3_REM_SIZE(__struct_cast(A8XX_CP_IB3_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB3_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_IB3_INIT_SIZE(...) pack_A8XX_CP_IB3_INIT_SIZE(__struct_cast(A8XX_CP_IB3_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_SDS_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_SDS_BASE(...) pack_A8XX_CP_SDS_BASE(__struct_cast(A8XX_CP_SDS_BASE) { __VA_ARGS__ })

struct A8XX_CP_SDS_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SDS_REM_SIZE(...) pack_A8XX_CP_SDS_REM_SIZE(__struct_cast(A8XX_CP_SDS_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_SDS_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_SDS_INIT_SIZE(...) pack_A8XX_CP_SDS_INIT_SIZE(__struct_cast(A8XX_CP_SDS_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_MRB_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_MRB_BASE(...) pack_A8XX_CP_MRB_BASE(__struct_cast(A8XX_CP_MRB_BASE) { __VA_ARGS__ })

struct A8XX_CP_MRB_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_MRB_REM_SIZE(...) pack_A8XX_CP_MRB_REM_SIZE(__struct_cast(A8XX_CP_MRB_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_MRB_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_MRB_INIT_SIZE(...) pack_A8XX_CP_MRB_INIT_SIZE(__struct_cast(A8XX_CP_MRB_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_VSD_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_VSD_BASE(...) pack_A8XX_CP_VSD_BASE(__struct_cast(A8XX_CP_VSD_BASE) { __VA_ARGS__ })

struct A8XX_CP_VSD_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_VSD_REM_SIZE(...) pack_A8XX_CP_VSD_REM_SIZE(__struct_cast(A8XX_CP_VSD_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_VSD_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_VSD_INIT_SIZE(...) pack_A8XX_CP_VSD_INIT_SIZE(__struct_cast(A8XX_CP_VSD_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_ROQ_RB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_RB_STATUS(...) pack_A6XX_CP_ROQ_RB_STATUS(__struct_cast(A6XX_CP_ROQ_RB_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_IB1_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_IB1_STATUS(...) pack_A6XX_CP_ROQ_IB1_STATUS(__struct_cast(A6XX_CP_ROQ_IB1_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_IB2_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_IB2_STATUS(...) pack_A6XX_CP_ROQ_IB2_STATUS(__struct_cast(A6XX_CP_ROQ_IB2_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_SDS_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_SDS_STATUS(...) pack_A6XX_CP_ROQ_SDS_STATUS(__struct_cast(A6XX_CP_ROQ_SDS_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_MRB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_MRB_STATUS(...) pack_A6XX_CP_ROQ_MRB_STATUS(__struct_cast(A6XX_CP_ROQ_MRB_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_VSD_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_VSD_STATUS(...) pack_A6XX_CP_ROQ_VSD_STATUS(__struct_cast(A6XX_CP_ROQ_VSD_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_RB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_RB_STATUS(...) pack_A8XX_CP_ROQ_RB_STATUS(__struct_cast(A8XX_CP_ROQ_RB_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB1_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_IB1_STATUS(...) pack_A8XX_CP_ROQ_IB1_STATUS(__struct_cast(A8XX_CP_ROQ_IB1_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB2_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_IB2_STATUS(...) pack_A8XX_CP_ROQ_IB2_STATUS(__struct_cast(A8XX_CP_ROQ_IB2_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB3_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_IB3_STATUS(...) pack_A8XX_CP_ROQ_IB3_STATUS(__struct_cast(A8XX_CP_ROQ_IB3_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_SDS_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_SDS_STATUS(...) pack_A8XX_CP_ROQ_SDS_STATUS(__struct_cast(A8XX_CP_ROQ_SDS_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_MRB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_MRB_STATUS(...) pack_A8XX_CP_ROQ_MRB_STATUS(__struct_cast(A8XX_CP_ROQ_MRB_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_VSD_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_VSD_STATUS(...) pack_A8XX_CP_ROQ_VSD_STATUS(__struct_cast(A8XX_CP_ROQ_VSD_STATUS) { __VA_ARGS__ })

struct A6XX_CP_IB1_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_IB1_INIT_SIZE(...) pack_A6XX_CP_IB1_INIT_SIZE(__struct_cast(A6XX_CP_IB1_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_IB2_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_IB2_INIT_SIZE(...) pack_A6XX_CP_IB2_INIT_SIZE(__struct_cast(A6XX_CP_IB2_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_SDS_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_SDS_INIT_SIZE(...) pack_A6XX_CP_SDS_INIT_SIZE(__struct_cast(A6XX_CP_SDS_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_MRB_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_MRB_INIT_SIZE(...) pack_A6XX_CP_MRB_INIT_SIZE(__struct_cast(A6XX_CP_MRB_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_VSD_INIT_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_VSD_INIT_SIZE(...) pack_A6XX_CP_VSD_INIT_SIZE(__struct_cast(A6XX_CP_VSD_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_RB {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_RB(...) pack_A6XX_CP_ROQ_AVAIL_RB(__struct_cast(A6XX_CP_ROQ_AVAIL_RB) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_IB1 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_IB1(...) pack_A6XX_CP_ROQ_AVAIL_IB1(__struct_cast(A6XX_CP_ROQ_AVAIL_IB1) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_IB2 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_IB2(...) pack_A6XX_CP_ROQ_AVAIL_IB2(__struct_cast(A6XX_CP_ROQ_AVAIL_IB2) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_SDS {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_SDS(...) pack_A6XX_CP_ROQ_AVAIL_SDS(__struct_cast(A6XX_CP_ROQ_AVAIL_SDS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_MRB {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_MRB(...) pack_A6XX_CP_ROQ_AVAIL_MRB(__struct_cast(A6XX_CP_ROQ_AVAIL_MRB) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_VSD {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_ROQ_AVAIL_VSD(...) pack_A6XX_CP_ROQ_AVAIL_VSD(__struct_cast(A6XX_CP_ROQ_AVAIL_VSD) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_RB {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_RB(...) pack_A8XX_CP_ROQ_AVAIL_RB(__struct_cast(A8XX_CP_ROQ_AVAIL_RB) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB1 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_IB1(...) pack_A8XX_CP_ROQ_AVAIL_IB1(__struct_cast(A8XX_CP_ROQ_AVAIL_IB1) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB2 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_IB2(...) pack_A8XX_CP_ROQ_AVAIL_IB2(__struct_cast(A8XX_CP_ROQ_AVAIL_IB2) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB3 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_IB3(...) pack_A8XX_CP_ROQ_AVAIL_IB3(__struct_cast(A8XX_CP_ROQ_AVAIL_IB3) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_SDS {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_SDS(...) pack_A8XX_CP_ROQ_AVAIL_SDS(__struct_cast(A8XX_CP_ROQ_AVAIL_SDS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_MRB {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_MRB(...) pack_A8XX_CP_ROQ_AVAIL_MRB(__struct_cast(A8XX_CP_ROQ_AVAIL_MRB) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_VSD {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_ROQ_AVAIL_VSD(...) pack_A8XX_CP_ROQ_AVAIL_VSD(__struct_cast(A8XX_CP_ROQ_AVAIL_VSD) { __VA_ARGS__ })

struct A6XX_CP_ALWAYS_ON_COUNTER {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_ALWAYS_ON_COUNTER(...) pack_A6XX_CP_ALWAYS_ON_COUNTER(__struct_cast(A6XX_CP_ALWAYS_ON_COUNTER) { __VA_ARGS__ })

struct A6XX_CP_ALWAYS_ON_CONTEXT {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_ALWAYS_ON_CONTEXT(...) pack_A6XX_CP_ALWAYS_ON_CONTEXT(__struct_cast(A6XX_CP_ALWAYS_ON_CONTEXT) { __VA_ARGS__ })

struct A8XX_CP_ALWAYS_ON_COUNTER {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_ALWAYS_ON_COUNTER(...) pack_A8XX_CP_ALWAYS_ON_COUNTER(__struct_cast(A8XX_CP_ALWAYS_ON_COUNTER) { __VA_ARGS__ })

struct A8XX_CP_ALWAYS_ON_CONTEXT {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_CP_ALWAYS_ON_CONTEXT(...) pack_A8XX_CP_ALWAYS_ON_CONTEXT(__struct_cast(A8XX_CP_ALWAYS_ON_CONTEXT) { __VA_ARGS__ })

struct A6XX_CP_AHB_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_AHB_CNTL(...) pack_A6XX_CP_AHB_CNTL(__struct_cast(A6XX_CP_AHB_CNTL) { __VA_ARGS__ })

struct A8XX_CP_AHB_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_AHB_CNTL(...) pack_A8XX_CP_AHB_CNTL(__struct_cast(A8XX_CP_AHB_CNTL) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_HOST {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_APERTURE_CNTL_HOST(...) pack_A6XX_CP_APERTURE_CNTL_HOST(__struct_cast(A6XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A7XX_CP_APERTURE_CNTL_HOST {
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_APERTURE_CNTL_HOST(...) pack_A7XX_CP_APERTURE_CNTL_HOST(__struct_cast(A7XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_SQE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_APERTURE_CNTL_SQE(...) pack_A6XX_CP_APERTURE_CNTL_SQE(__struct_cast(A6XX_CP_APERTURE_CNTL_SQE) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_CD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_APERTURE_CNTL_CD(...) pack_A6XX_CP_APERTURE_CNTL_CD(__struct_cast(A6XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_APERTURE_CNTL_CD {
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_APERTURE_CNTL_CD(...) pack_A7XX_CP_APERTURE_CNTL_CD(__struct_cast(A7XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_RESERVED_REG_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_RESERVED_REG_REG(__i, ...) pack_A7XX_CP_RESERVED_REG_REG(__i, __struct_cast(A7XX_CP_RESERVED_REG_REG) { __VA_ARGS__ })

struct A8XX_CP_RESERVED_REG_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_RESERVED_REG_REG(__i, ...) pack_A8XX_CP_RESERVED_REG_REG(__i, __struct_cast(A8XX_CP_RESERVED_REG_REG) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_HOST {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_APERTURE_CNTL_HOST(...) pack_A8XX_CP_APERTURE_CNTL_HOST(__struct_cast(A8XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_GMU {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_APERTURE_CNTL_GMU(...) pack_A8XX_CP_APERTURE_CNTL_GMU(__struct_cast(A8XX_CP_APERTURE_CNTL_GMU) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_CD {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CP_APERTURE_CNTL_CD(...) pack_A8XX_CP_APERTURE_CNTL_CD(__struct_cast(A8XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_BV_PROTECT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_PROTECT_STATUS(...) pack_A7XX_CP_BV_PROTECT_STATUS(__struct_cast(A7XX_CP_BV_PROTECT_STATUS) { __VA_ARGS__ })

struct A7XX_CP_BV_HW_FAULT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_HW_FAULT(...) pack_A7XX_CP_BV_HW_FAULT(__struct_cast(A7XX_CP_BV_HW_FAULT) { __VA_ARGS__ })

struct A7XX_CP_BV_RB_RPTR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_RB_RPTR(...) pack_A7XX_CP_BV_RB_RPTR(__struct_cast(A7XX_CP_BV_RB_RPTR) { __VA_ARGS__ })

struct A7XX_CP_BV_IB1_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_CP_BV_IB1_BASE(...) pack_A7XX_CP_BV_IB1_BASE(__struct_cast(A7XX_CP_BV_IB1_BASE) { __VA_ARGS__ })

struct A7XX_CP_BV_IB1_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_IB1_REM_SIZE(...) pack_A7XX_CP_BV_IB1_REM_SIZE(__struct_cast(A7XX_CP_BV_IB1_REM_SIZE) { __VA_ARGS__ })

struct A7XX_CP_BV_IB2_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_CP_BV_IB2_BASE(...) pack_A7XX_CP_BV_IB2_BASE(__struct_cast(A7XX_CP_BV_IB2_BASE) { __VA_ARGS__ })

struct A7XX_CP_BV_IB2_REM_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_IB2_REM_SIZE(...) pack_A7XX_CP_BV_IB2_REM_SIZE(__struct_cast(A7XX_CP_BV_IB2_REM_SIZE) { __VA_ARGS__ })

struct A7XX_CP_BV_DRAW_STATE_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_DRAW_STATE_ADDR(...) pack_A7XX_CP_BV_DRAW_STATE_ADDR(__struct_cast(A7XX_CP_BV_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_DRAW_STATE_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_DRAW_STATE_DATA(...) pack_A7XX_CP_BV_DRAW_STATE_DATA(__struct_cast(A7XX_CP_BV_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_ROQ_DBG_ADDR(...) pack_A7XX_CP_BV_ROQ_DBG_ADDR(__struct_cast(A7XX_CP_BV_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_ROQ_DBG_DATA(...) pack_A7XX_CP_BV_ROQ_DBG_DATA(__struct_cast(A7XX_CP_BV_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_UCODE_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_SQE_UCODE_DBG_ADDR(...) pack_A7XX_CP_BV_SQE_UCODE_DBG_ADDR(__struct_cast(A7XX_CP_BV_SQE_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_UCODE_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_SQE_UCODE_DBG_DATA(...) pack_A7XX_CP_BV_SQE_UCODE_DBG_DATA(__struct_cast(A7XX_CP_BV_SQE_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_STAT_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_SQE_STAT_ADDR(...) pack_A7XX_CP_BV_SQE_STAT_ADDR(__struct_cast(A7XX_CP_BV_SQE_STAT_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_STAT_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_SQE_STAT_DATA(...) pack_A7XX_CP_BV_SQE_STAT_DATA(__struct_cast(A7XX_CP_BV_SQE_STAT_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_AVAIL_RB {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_ROQ_AVAIL_RB(...) pack_A7XX_CP_BV_ROQ_AVAIL_RB(__struct_cast(A7XX_CP_BV_ROQ_AVAIL_RB) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_AVAIL_IB1 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_ROQ_AVAIL_IB1(...) pack_A7XX_CP_BV_ROQ_AVAIL_IB1(__struct_cast(A7XX_CP_BV_ROQ_AVAIL_IB1) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_AVAIL_IB2 {
    uint32_t							rem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_ROQ_AVAIL_IB2(...) pack_A7XX_CP_BV_ROQ_AVAIL_IB2(__struct_cast(A7XX_CP_BV_ROQ_AVAIL_IB2) { __VA_ARGS__ })

struct A7XX_CP_BV_MEM_POOL_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_MEM_POOL_DBG_ADDR(...) pack_A7XX_CP_BV_MEM_POOL_DBG_ADDR(__struct_cast(A7XX_CP_BV_MEM_POOL_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_MEM_POOL_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_MEM_POOL_DBG_DATA(...) pack_A7XX_CP_BV_MEM_POOL_DBG_DATA(__struct_cast(A7XX_CP_BV_MEM_POOL_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_RB_RPTR_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_CP_BV_RB_RPTR_ADDR(...) pack_A7XX_CP_BV_RB_RPTR_ADDR(__struct_cast(A7XX_CP_BV_RB_RPTR_ADDR) { __VA_ARGS__ })

struct A7XX_CP_RESOURCE_TABLE_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_RESOURCE_TABLE_DBG_ADDR(...) pack_A7XX_CP_RESOURCE_TABLE_DBG_ADDR(__struct_cast(A7XX_CP_RESOURCE_TABLE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_RESOURCE_TABLE_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_RESOURCE_TABLE_DBG_DATA(...) pack_A7XX_CP_RESOURCE_TABLE_DBG_DATA(__struct_cast(A7XX_CP_RESOURCE_TABLE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_APRIV_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_APRIV_CNTL(...) pack_A7XX_CP_BV_APRIV_CNTL(__struct_cast(A7XX_CP_BV_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_BV_CHICKEN_DBG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_BV_CHICKEN_DBG(...) pack_A7XX_CP_BV_CHICKEN_DBG(__struct_cast(A7XX_CP_BV_CHICKEN_DBG) { __VA_ARGS__ })

struct A7XX_CP_LPAC_DRAW_STATE_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_DRAW_STATE_ADDR(...) pack_A7XX_CP_LPAC_DRAW_STATE_ADDR(__struct_cast(A7XX_CP_LPAC_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_LPAC_DRAW_STATE_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_DRAW_STATE_DATA(...) pack_A7XX_CP_LPAC_DRAW_STATE_DATA(__struct_cast(A7XX_CP_LPAC_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_ROQ_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_ROQ_DBG_ADDR(...) pack_A7XX_CP_LPAC_ROQ_DBG_ADDR(__struct_cast(A7XX_CP_LPAC_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_UCODE_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_SQE_AC_UCODE_DBG_ADDR(...) pack_A7XX_CP_SQE_AC_UCODE_DBG_ADDR(__struct_cast(A7XX_CP_SQE_AC_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_UCODE_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_SQE_AC_UCODE_DBG_DATA(...) pack_A7XX_CP_SQE_AC_UCODE_DBG_DATA(__struct_cast(A7XX_CP_SQE_AC_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_STAT_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_SQE_AC_STAT_ADDR(...) pack_A7XX_CP_SQE_AC_STAT_ADDR(__struct_cast(A7XX_CP_SQE_AC_STAT_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_STAT_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_SQE_AC_STAT_DATA(...) pack_A7XX_CP_SQE_AC_STAT_DATA(__struct_cast(A7XX_CP_SQE_AC_STAT_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_APRIV_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_APRIV_CNTL(...) pack_A7XX_CP_LPAC_APRIV_CNTL(__struct_cast(A7XX_CP_LPAC_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_LPAC_PROG_FIFO_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_PROG_FIFO_SIZE(...) pack_A7XX_CP_LPAC_PROG_FIFO_SIZE(__struct_cast(A7XX_CP_LPAC_PROG_FIFO_SIZE) { __VA_ARGS__ })

struct A7XX_CP_LPAC_ROQ_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_ROQ_DBG_DATA(...) pack_A7XX_CP_LPAC_ROQ_DBG_DATA(__struct_cast(A7XX_CP_LPAC_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_FIFO_DBG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_FIFO_DBG_DATA(...) pack_A7XX_CP_LPAC_FIFO_DBG_DATA(__struct_cast(A7XX_CP_LPAC_FIFO_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_FIFO_DBG_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_LPAC_FIFO_DBG_ADDR(...) pack_A7XX_CP_LPAC_FIFO_DBG_ADDR(__struct_cast(A7XX_CP_LPAC_FIFO_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_LPAC_SQE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CP_LPAC_SQE_CNTL(...) pack_A6XX_CP_LPAC_SQE_CNTL(__struct_cast(A6XX_CP_LPAC_SQE_CNTL) { __VA_ARGS__ })

struct A6XX_CP_LPAC_SQE_INSTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_CP_LPAC_SQE_INSTR_BASE(...) pack_A6XX_CP_LPAC_SQE_INSTR_BASE(__struct_cast(A6XX_CP_LPAC_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A7XX_CP_AQE_INSTR_BASE_0 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_CP_AQE_INSTR_BASE_0(...) pack_A7XX_CP_AQE_INSTR_BASE_0(__struct_cast(A7XX_CP_AQE_INSTR_BASE_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_INSTR_BASE_1 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_CP_AQE_INSTR_BASE_1(...) pack_A7XX_CP_AQE_INSTR_BASE_1(__struct_cast(A7XX_CP_AQE_INSTR_BASE_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_APRIV_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_APRIV_CNTL(...) pack_A7XX_CP_AQE_APRIV_CNTL(__struct_cast(A7XX_CP_AQE_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_ADDR_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_ROQ_DBG_ADDR_0(...) pack_A7XX_CP_AQE_ROQ_DBG_ADDR_0(__struct_cast(A7XX_CP_AQE_ROQ_DBG_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_ADDR_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_ROQ_DBG_ADDR_1(...) pack_A7XX_CP_AQE_ROQ_DBG_ADDR_1(__struct_cast(A7XX_CP_AQE_ROQ_DBG_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_DATA_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_ROQ_DBG_DATA_0(...) pack_A7XX_CP_AQE_ROQ_DBG_DATA_0(__struct_cast(A7XX_CP_AQE_ROQ_DBG_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_DATA_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_ROQ_DBG_DATA_1(...) pack_A7XX_CP_AQE_ROQ_DBG_DATA_1(__struct_cast(A7XX_CP_AQE_ROQ_DBG_DATA_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_ADDR_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_UCODE_DBG_ADDR_0(...) pack_A7XX_CP_AQE_UCODE_DBG_ADDR_0(__struct_cast(A7XX_CP_AQE_UCODE_DBG_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_ADDR_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_UCODE_DBG_ADDR_1(...) pack_A7XX_CP_AQE_UCODE_DBG_ADDR_1(__struct_cast(A7XX_CP_AQE_UCODE_DBG_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_DATA_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_UCODE_DBG_DATA_0(...) pack_A7XX_CP_AQE_UCODE_DBG_DATA_0(__struct_cast(A7XX_CP_AQE_UCODE_DBG_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_DATA_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_UCODE_DBG_DATA_1(...) pack_A7XX_CP_AQE_UCODE_DBG_DATA_1(__struct_cast(A7XX_CP_AQE_UCODE_DBG_DATA_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_ADDR_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_STAT_ADDR_0(...) pack_A7XX_CP_AQE_STAT_ADDR_0(__struct_cast(A7XX_CP_AQE_STAT_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_ADDR_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_STAT_ADDR_1(...) pack_A7XX_CP_AQE_STAT_ADDR_1(__struct_cast(A7XX_CP_AQE_STAT_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_DATA_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_STAT_DATA_0(...) pack_A7XX_CP_AQE_STAT_DATA_0(__struct_cast(A7XX_CP_AQE_STAT_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_DATA_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CP_AQE_STAT_DATA_1(...) pack_A7XX_CP_AQE_STAT_DATA_1(__struct_cast(A7XX_CP_AQE_STAT_DATA_1) { __VA_ARGS__ })

struct A6XX_VSC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					vsc_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VSC_ADDR_MODE_CNTL(...) pack_A6XX_VSC_ADDR_MODE_CNTL(__struct_cast(A6XX_VSC_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GPR0_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_GPR0_CNTL(...) pack_A6XX_RBBM_GPR0_CNTL(__struct_cast(A6XX_RBBM_GPR0_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS {
    bool							gpu_busy_ign_ahb;
    bool							gpu_busy_ign_ahb_cp;
    bool							hlsq_busy;
    bool							vsc_busy;
    bool							tpl1_busy;
    bool							sp_busy;
    bool							uche_busy;
    bool							vpc_busy;
    bool							vfd_busy;
    bool							tess_busy;
    bool							pc_vsd_busy;
    bool							pc_dcall_busy;
    bool							com_dcom_busy;
    bool							lrz_busy;
    bool							a2d_busy;
    bool							ccu_busy;
    bool							rb_busy;
    bool							ras_busy;
    bool							tse_busy;
    bool							vbif_busy;
    bool							gfx_dbgc_busy;
    bool							cp_busy;
    bool							cp_ahb_busy_cp_master;
    bool							cp_ahb_busy_cx_master;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_STATUS(...) pack_A6XX_RBBM_STATUS(__struct_cast(A6XX_RBBM_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_STATUS1(...) pack_A6XX_RBBM_STATUS1(__struct_cast(A6XX_RBBM_STATUS1) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_STATUS2(...) pack_A6XX_RBBM_STATUS2(__struct_cast(A6XX_RBBM_STATUS2) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS3 {
    bool							smmu_stalled_on_fault;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_STATUS3(...) pack_A6XX_RBBM_STATUS3(__struct_cast(A6XX_RBBM_STATUS3) { __VA_ARGS__ })

struct A8XX_RBBM_STATUS {
    bool							gpu_busy_ign_ahb;
    bool							gpu_busy_ign_ahb_cp;
    bool							slice_busy_ign_cp;
    bool							cp_slice_busy;
    bool							unslice_busy_ign_ahb;
    bool							unslice_busy_ign_ahb_cp;
    bool							cp_slice_rl_busy;
    bool							unslice_top_busy;
    bool							ufc_busy;
    bool							hlsq_busy;
    bool							vsc_busy;
    bool							uche_busy;
    bool							vpc_busy;
    bool							pc_busy;
    bool							cmp_busy;
    bool							dcmp_busy;
    bool							vbif_gx_busy;
    bool							dbgc_perf_busy;
    bool							gfx_dbgc_busy;
    bool							cp_busy;
    bool							cp_ahb_busy_cp_master;
    bool							cp_ahb_busy_cx_master;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_STATUS(...) pack_A8XX_RBBM_STATUS(__struct_cast(A8XX_RBBM_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_STATUS1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_STATUS1(...) pack_A8XX_RBBM_STATUS1(__struct_cast(A8XX_RBBM_STATUS1) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GFX_STATUS(...) pack_A8XX_RBBM_GFX_STATUS(__struct_cast(A8XX_RBBM_GFX_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_STATUS1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GFX_STATUS1(...) pack_A8XX_RBBM_GFX_STATUS1(__struct_cast(A8XX_RBBM_GFX_STATUS1) { __VA_ARGS__ })

struct A8XX_RBBM_LPAC_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_LPAC_STATUS(...) pack_A8XX_RBBM_LPAC_STATUS(__struct_cast(A8XX_RBBM_LPAC_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_BR_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GFX_BR_STATUS(...) pack_A8XX_RBBM_GFX_BR_STATUS(__struct_cast(A8XX_RBBM_GFX_BR_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_BV_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GFX_BV_STATUS(...) pack_A8XX_RBBM_GFX_BV_STATUS(__struct_cast(A8XX_RBBM_GFX_BV_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_MISC_STATUS {
    bool							smmu_stalled_on_fault;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_MISC_STATUS(...) pack_A8XX_RBBM_MISC_STATUS(__struct_cast(A8XX_RBBM_MISC_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_VBIF_GX_RESET_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_VBIF_GX_RESET_STATUS(...) pack_A6XX_RBBM_VBIF_GX_RESET_STATUS(__struct_cast(A6XX_RBBM_VBIF_GX_RESET_STATUS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_CP {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE_CP(...) pack_A7XX_RBBM_CLOCK_MODE_CP(__struct_cast(A7XX_RBBM_CLOCK_MODE_CP) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_LRZ {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE_BV_LRZ(...) pack_A7XX_RBBM_CLOCK_MODE_BV_LRZ(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_LRZ) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE_BV_GRAS(...) pack_A7XX_RBBM_CLOCK_MODE_BV_GRAS(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_GRAS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE2_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE2_GRAS(...) pack_A7XX_RBBM_CLOCK_MODE2_GRAS(__struct_cast(A7XX_RBBM_CLOCK_MODE2_GRAS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_VFD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE_BV_VFD(...) pack_A7XX_RBBM_CLOCK_MODE_BV_VFD(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_VFD) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_GPC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_MODE_BV_GPC(...) pack_A7XX_RBBM_CLOCK_MODE_BV_GPC(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_GPC) { __VA_ARGS__ })

struct A7XX_RBBM_SW_FUSE_INT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_SW_FUSE_INT_STATUS(...) pack_A7XX_RBBM_SW_FUSE_INT_STATUS(__struct_cast(A7XX_RBBM_SW_FUSE_INT_STATUS) { __VA_ARGS__ })

struct A7XX_RBBM_SW_FUSE_INT_MASK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_SW_FUSE_INT_MASK(...) pack_A7XX_RBBM_SW_FUSE_INT_MASK(__struct_cast(A7XX_RBBM_SW_FUSE_INT_MASK) { __VA_ARGS__ })

struct A8XX_RBBM_SW_FUSE_INT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SW_FUSE_INT_STATUS(...) pack_A8XX_RBBM_SW_FUSE_INT_STATUS(__struct_cast(A8XX_RBBM_SW_FUSE_INT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SW_FUSE_INT_MASK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SW_FUSE_INT_MASK(...) pack_A8XX_RBBM_SW_FUSE_INT_MASK(__struct_cast(A8XX_RBBM_SW_FUSE_INT_MASK) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_PC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_TP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RB_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_PC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_TP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_SP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RB_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_UFC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_UFC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_UFC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_UFC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_HLSQ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR2_HLSQ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_HLSQ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_HLSQ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_CP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR2_CP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_CP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_CP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_SP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR2_SP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_SP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_SP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_TP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR2_TP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_TP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_TP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_UFC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR2_UFC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_UFC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_UFC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_PC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_PC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_PC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_PC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_VFD_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_VFD_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_VFD_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_VFD_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_VPC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_VPC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_VPC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_VPC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_TSE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_TSE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_TSE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_TSE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_RAS_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_RAS_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_RAS_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_RAS_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_LRZ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_PERFCTR_BV_LRZ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_LRZ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_PC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_TP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RB_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_UFC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_UFC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_UFC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_UFC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_HLSQ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR2_HLSQ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_HLSQ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_HLSQ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_CP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR2_CP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_CP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_CP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_SP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR2_SP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_SP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_SP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_TP_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR2_TP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_TP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_TP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_UFC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR2_UFC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_UFC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_UFC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_PC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_PC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_PC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_PC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_VFD_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_VFD_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_VFD_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_VFD_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_VPC_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_VPC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_VPC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_VPC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_TSE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_TSE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_TSE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_TSE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_RAS_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_RAS_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_RAS_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_RAS_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_LRZ_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_LRZ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_LRZ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_CCU_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_CCU_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_CCU_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_CCU_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_RB_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_BV_RB_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_RB_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_RB_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_CNTL(...) pack_A6XX_RBBM_PERFCTR_CNTL(__struct_cast(A6XX_RBBM_PERFCTR_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_CNTL(...) pack_A8XX_RBBM_PERFCTR_CNTL(__struct_cast(A8XX_RBBM_PERFCTR_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LOAD_CMD0(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD0(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD0) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LOAD_CMD1(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD1(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD1) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LOAD_CMD2(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD2(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD2) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LOAD_CMD3(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD3(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD3) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_VALUE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PERFCTR_LOAD_VALUE(...) pack_A6XX_RBBM_PERFCTR_LOAD_VALUE(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_VALUE) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RBBM_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RBBM_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED(...) pack_A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED(__struct_cast(A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED(...) pack_A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED(__struct_cast(A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SRAM_INIT_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_SRAM_INIT_CMD(...) pack_A6XX_RBBM_PERFCTR_SRAM_INIT_CMD(__struct_cast(A6XX_RBBM_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SRAM_INIT_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_SRAM_INIT_CMD(...) pack_A8XX_RBBM_PERFCTR_SRAM_INIT_CMD(__struct_cast(A8XX_RBBM_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS(...) pack_A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS(__struct_cast(A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS(...) pack_A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS(__struct_cast(A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS(...) pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS(__struct_cast(A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD(...) pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD(__struct_cast(A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_ISDB_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_ISDB_CNT(...) pack_A6XX_RBBM_ISDB_CNT(__struct_cast(A6XX_RBBM_ISDB_CNT) { __VA_ARGS__ })

struct A8XX_RBBM_ISDB_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_ISDB_CNT(...) pack_A8XX_RBBM_ISDB_CNT(__struct_cast(A8XX_RBBM_ISDB_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_NC_MODE_CNTL(...) pack_A6XX_RBBM_NC_MODE_CNTL(__struct_cast(A6XX_RBBM_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_NC_MODE_CNTL(...) pack_A8XX_RBBM_NC_MODE_CNTL(__struct_cast(A8XX_RBBM_NC_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_SNAPSHOT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_SNAPSHOT_STATUS(...) pack_A7XX_RBBM_SNAPSHOT_STATUS(__struct_cast(A7XX_RBBM_SNAPSHOT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SNAPSHOT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SNAPSHOT_STATUS(...) pack_A8XX_RBBM_SNAPSHOT_STATUS(__struct_cast(A8XX_RBBM_SNAPSHOT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_PERFCTR_CNTL(...) pack_A8XX_RBBM_SLICE_PERFCTR_CNTL(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL(...) pack_A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL(__struct_cast(A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(...) pack_A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(...) pack_A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SLICE_NC_MODE_CNTL(...) pack_A8XX_RBBM_SLICE_NC_MODE_CNTL(__struct_cast(A8XX_RBBM_SLICE_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_IAVERTICES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_IAVERTICES(...) pack_A6XX_RBBM_PIPESTAT_IAVERTICES(__struct_cast(A6XX_RBBM_PIPESTAT_IAVERTICES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_IAPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_IAPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_IAPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_IAPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_VSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_VSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_VSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_VSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_HSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_HSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_HSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_HSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_DSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_DSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_DSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_DSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_GSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_GSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_GSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_GSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_GSPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_GSPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_GSPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_GSPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_CINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_CINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_CINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_CPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_CPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_CPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_PSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_PSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_PSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_PSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RBBM_PIPESTAT_CSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_CSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_CSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_IAVERTICES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_IAVERTICES(...) pack_A8XX_RBBM_PIPESTAT_IAVERTICES(__struct_cast(A8XX_RBBM_PIPESTAT_IAVERTICES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_IAPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_IAPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_IAPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_IAPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_VSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_VSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_VSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_VSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_GSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_GSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_GSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_GSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_GSPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_GSPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_GSPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_GSPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_CINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_CINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_CINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_CPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_CPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_CPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_PSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_PSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_PSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_PSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_HSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_HSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_HSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_HSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_DSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_DSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_DSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_DSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_CSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_CSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_CSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_ASINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_ASINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_ASINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_ASINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_MSINVOCATIONS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_MSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_MSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_MSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_MSPRIMITIVES {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_RBBM_PIPESTAT_MSPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_MSPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_MSPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TRUST_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TRUST_CNTL(struct A6XX_RBBM_SECVID_TRUST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f400,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TRUST_CNTL(...) pack_A6XX_RBBM_SECVID_TRUST_CNTL(__struct_cast(A6XX_RBBM_SECVID_TRUST_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_TRUSTED_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(struct A6XX_RBBM_SECVID_TSB_TRUSTED_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f800,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(...) pack_A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(__struct_cast(A6XX_RBBM_SECVID_TSB_TRUSTED_BASE) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(struct A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f802,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(...) pack_A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(__struct_cast(A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_CNTL(struct A6XX_RBBM_SECVID_TSB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f803,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TSB_CNTL(...) pack_A6XX_RBBM_SECVID_TSB_CNTL(__struct_cast(A6XX_RBBM_SECVID_TSB_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL {
    enum a5xx_address_mode					rbbm_secvid_tsb_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL(...) pack_A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL(__struct_cast(A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_SECVID_TSB_STATUS {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_RBBM_SECVID_TSB_STATUS(...) pack_A7XX_RBBM_SECVID_TSB_STATUS(__struct_cast(A7XX_RBBM_SECVID_TSB_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_VBIF_CLIENT_QOS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_VBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_VBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_VBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_CLIENT_QOS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_GBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_GBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_CLIENT_QOS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GBIF_CLIENT_QOS_CNTL(...) pack_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL(__struct_cast(A8XX_RBBM_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_HALT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_GBIF_HALT(...) pack_A6XX_RBBM_GBIF_HALT(__struct_cast(A6XX_RBBM_GBIF_HALT) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_HALT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GBIF_HALT(...) pack_A8XX_RBBM_GBIF_HALT(__struct_cast(A8XX_RBBM_GBIF_HALT) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_HALT_ACK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_GBIF_HALT_ACK(...) pack_A6XX_RBBM_GBIF_HALT_ACK(__struct_cast(A6XX_RBBM_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_HALT_ACK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_GBIF_HALT_ACK(...) pack_A8XX_RBBM_GBIF_HALT_ACK(__struct_cast(A8XX_RBBM_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD {
    bool							wait_gpu_idle;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD(...) pack_A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD(__struct_cast(A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(...) pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(...) pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(__struct_cast(A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2) { __VA_ARGS__ })

struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(...) pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(__struct_cast(A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2) { __VA_ARGS__ })

struct A6XX_RBBM_INTERFACE_HANG_INT_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_INTERFACE_HANG_INT_CNTL(...) pack_A6XX_RBBM_INTERFACE_HANG_INT_CNTL(__struct_cast(A6XX_RBBM_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_INTERFACE_HANG_INT_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_INTERFACE_HANG_INT_CNTL(...) pack_A8XX_RBBM_INTERFACE_HANG_INT_CNTL(__struct_cast(A8XX_RBBM_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_INT_2_MASK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_INT_2_MASK(...) pack_A7XX_RBBM_INT_2_MASK(__struct_cast(A7XX_RBBM_INT_2_MASK) { __VA_ARGS__ })

struct A8XX_RBBM_INT_2_MASK {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_INT_2_MASK(...) pack_A8XX_RBBM_INT_2_MASK(__struct_cast(A8XX_RBBM_INT_2_MASK) { __VA_ARGS__ })

struct A6XX_RBBM_SP_HYST_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_SP_HYST_CNT(...) pack_A6XX_RBBM_SP_HYST_CNT(__struct_cast(A6XX_RBBM_SP_HYST_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_SW_RESET_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_SW_RESET_CMD(...) pack_A6XX_RBBM_SW_RESET_CMD(__struct_cast(A6XX_RBBM_SW_RESET_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SW_RESET_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_SW_RESET_CMD(...) pack_A8XX_RBBM_SW_RESET_CMD(__struct_cast(A8XX_RBBM_SW_RESET_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_RAC_THRESHOLD_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_RAC_THRESHOLD_CNT(...) pack_A6XX_RBBM_RAC_THRESHOLD_CNT(__struct_cast(A6XX_RBBM_RAC_THRESHOLD_CNT) { __VA_ARGS__ })

struct A8XX_RBBM_RAC_THRESHOLD_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_RAC_THRESHOLD_CNT(...) pack_A8XX_RBBM_RAC_THRESHOLD_CNT(__struct_cast(A8XX_RBBM_RAC_THRESHOLD_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_BLOCK_SW_RESET_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_BLOCK_SW_RESET_CMD(...) pack_A6XX_RBBM_BLOCK_SW_RESET_CMD(__struct_cast(A6XX_RBBM_BLOCK_SW_RESET_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_BLOCK_SW_RESET_CMD2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_BLOCK_SW_RESET_CMD2(...) pack_A6XX_RBBM_BLOCK_SW_RESET_CMD2(__struct_cast(A6XX_RBBM_BLOCK_SW_RESET_CMD2) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_CNTL_GLOBAL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_CNTL_GLOBAL(...) pack_A7XX_RBBM_CLOCK_CNTL_GLOBAL(__struct_cast(A7XX_RBBM_CLOCK_CNTL_GLOBAL) { __VA_ARGS__ })

struct A8XX_RBBM_CLOCK_CNTL_GLOBAL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CLOCK_CNTL_GLOBAL(...) pack_A8XX_RBBM_CLOCK_CNTL_GLOBAL(__struct_cast(A8XX_RBBM_CLOCK_CNTL_GLOBAL) { __VA_ARGS__ })

struct A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE(...) pack_A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE(__struct_cast(A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE) { __VA_ARGS__ })

struct A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE(...) pack_A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE(__struct_cast(A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL(...) pack_A6XX_RBBM_CLOCK_CNTL(__struct_cast(A6XX_RBBM_CLOCK_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_SP0(...) pack_A6XX_RBBM_CLOCK_CNTL_SP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_SP1(...) pack_A6XX_RBBM_CLOCK_CNTL_SP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_SP2(...) pack_A6XX_RBBM_CLOCK_CNTL_SP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_SP3(...) pack_A6XX_RBBM_CLOCK_CNTL_SP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_SP0(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_SP1(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_SP2(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_SP3(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_SP0(...) pack_A6XX_RBBM_CLOCK_DELAY_SP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_SP1(...) pack_A6XX_RBBM_CLOCK_DELAY_SP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_SP2(...) pack_A6XX_RBBM_CLOCK_DELAY_SP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_SP3(...) pack_A6XX_RBBM_CLOCK_DELAY_SP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_SP0(...) pack_A6XX_RBBM_CLOCK_HYST_SP0(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_SP1(...) pack_A6XX_RBBM_CLOCK_HYST_SP1(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_SP2(...) pack_A6XX_RBBM_CLOCK_HYST_SP2(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_SP3(...) pack_A6XX_RBBM_CLOCK_HYST_SP3(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL3_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL3_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL3_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL3_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL4_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL4_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL4_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL4_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY2_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY2_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY2_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY2_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY3_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY3_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY3_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY3_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY4_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY4_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY4_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY4_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TP0(...) pack_A6XX_RBBM_CLOCK_HYST_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TP1(...) pack_A6XX_RBBM_CLOCK_HYST_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TP2(...) pack_A6XX_RBBM_CLOCK_HYST_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TP3(...) pack_A6XX_RBBM_CLOCK_HYST_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST2_TP0(...) pack_A6XX_RBBM_CLOCK_HYST2_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST2_TP1(...) pack_A6XX_RBBM_CLOCK_HYST2_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST2_TP2(...) pack_A6XX_RBBM_CLOCK_HYST2_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST2_TP3(...) pack_A6XX_RBBM_CLOCK_HYST2_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST3_TP0(...) pack_A6XX_RBBM_CLOCK_HYST3_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST3_TP1(...) pack_A6XX_RBBM_CLOCK_HYST3_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST3_TP2(...) pack_A6XX_RBBM_CLOCK_HYST3_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST3_TP3(...) pack_A6XX_RBBM_CLOCK_HYST3_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST4_TP0(...) pack_A6XX_RBBM_CLOCK_HYST4_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST4_TP1(...) pack_A6XX_RBBM_CLOCK_HYST4_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST4_TP2(...) pack_A6XX_RBBM_CLOCK_HYST4_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST4_TP3(...) pack_A6XX_RBBM_CLOCK_HYST4_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_RB0(...) pack_A6XX_RBBM_CLOCK_CNTL_RB0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_RB1(...) pack_A6XX_RBBM_CLOCK_CNTL_RB1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_RB2(...) pack_A6XX_RBBM_CLOCK_CNTL_RB2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_RB3(...) pack_A6XX_RBBM_CLOCK_CNTL_RB3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_RB0(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_RB1(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_RB2(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_RB3(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_CCU0(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_CCU1(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_CCU2(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_CCU3(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_RB_CCU0(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU0(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_RB_CCU1(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU1(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_RB_CCU2(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU2(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_RB_CCU3(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU3(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_RAC(...) pack_A6XX_RBBM_CLOCK_CNTL_RAC(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_RAC(...) pack_A6XX_RBBM_CLOCK_CNTL2_RAC(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_RAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_RAC(...) pack_A6XX_RBBM_CLOCK_DELAY_RAC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RAC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_RAC(...) pack_A6XX_RBBM_CLOCK_HYST_RAC(__struct_cast(A6XX_RBBM_CLOCK_HYST_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL2_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL2_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL3_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL3_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL4_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL4_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_UCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_UCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_UCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_UCHE(...) pack_A6XX_RBBM_CLOCK_HYST_UCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_VFD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_MODE_VFD(...) pack_A6XX_RBBM_CLOCK_MODE_VFD(__struct_cast(A6XX_RBBM_CLOCK_MODE_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_VFD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_VFD(...) pack_A6XX_RBBM_CLOCK_DELAY_VFD(__struct_cast(A6XX_RBBM_CLOCK_DELAY_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_VFD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_VFD(...) pack_A6XX_RBBM_CLOCK_HYST_VFD(__struct_cast(A6XX_RBBM_CLOCK_HYST_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_GPC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_MODE_GPC(...) pack_A6XX_RBBM_CLOCK_MODE_GPC(__struct_cast(A6XX_RBBM_CLOCK_MODE_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GPC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_GPC(...) pack_A6XX_RBBM_CLOCK_DELAY_GPC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GPC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_GPC(...) pack_A6XX_RBBM_CLOCK_HYST_GPC(__struct_cast(A6XX_RBBM_CLOCK_HYST_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_HLSQ_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_HLSQ_2(...) pack_A6XX_RBBM_CLOCK_DELAY_HLSQ_2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_HLSQ_2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_GMU_GX {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_GMU_GX(...) pack_A6XX_RBBM_CLOCK_CNTL_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_CNTL_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GMU_GX {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_GMU_GX(...) pack_A6XX_RBBM_CLOCK_DELAY_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GMU_GX {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_GMU_GX(...) pack_A6XX_RBBM_CLOCK_HYST_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_HYST_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_HLSQ {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_MODE_HLSQ(...) pack_A6XX_RBBM_CLOCK_MODE_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_MODE_HLSQ) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_HLSQ {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_HLSQ(...) pack_A6XX_RBBM_CLOCK_DELAY_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_DELAY_HLSQ) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_HLSQ {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_HLSQ(...) pack_A6XX_RBBM_CLOCK_HYST_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_HYST_HLSQ) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_GLOBAL_LOAD_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CGC_GLOBAL_LOAD_CMD(...) pack_A7XX_RBBM_CGC_GLOBAL_LOAD_CMD(__struct_cast(A7XX_RBBM_CGC_GLOBAL_LOAD_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_GLOBAL_LOAD_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CGC_GLOBAL_LOAD_CMD(...) pack_A8XX_RBBM_CGC_GLOBAL_LOAD_CMD(__struct_cast(A8XX_RBBM_CGC_GLOBAL_LOAD_CMD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_TRIG_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CGC_P2S_TRIG_CMD(...) pack_A7XX_RBBM_CGC_P2S_TRIG_CMD(__struct_cast(A7XX_RBBM_CGC_P2S_TRIG_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_TRIG_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CGC_P2S_TRIG_CMD(...) pack_A8XX_RBBM_CGC_P2S_TRIG_CMD(__struct_cast(A8XX_RBBM_CGC_P2S_TRIG_CMD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CGC_P2S_CNTL(...) pack_A7XX_RBBM_CGC_P2S_CNTL(__struct_cast(A7XX_RBBM_CGC_P2S_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CGC_P2S_CNTL(...) pack_A8XX_RBBM_CGC_P2S_CNTL(__struct_cast(A8XX_RBBM_CGC_P2S_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TEX_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TEX_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TEX_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TEX_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TEX_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_HYST_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_TEX_FCHE) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_STATUS {
    bool							txdone;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CGC_P2S_STATUS(...) pack_A7XX_RBBM_CGC_P2S_STATUS(__struct_cast(A7XX_RBBM_CGC_P2S_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_STATUS {
    bool							txdone;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CGC_P2S_STATUS(...) pack_A8XX_RBBM_CGC_P2S_STATUS(__struct_cast(A8XX_RBBM_CGC_P2S_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_FCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_FCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_FCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_FCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_FCHE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_FCHE(...) pack_A6XX_RBBM_CLOCK_HYST_FCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_MHUB {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_MHUB(...) pack_A6XX_RBBM_CLOCK_CNTL_MHUB(__struct_cast(A6XX_RBBM_CLOCK_CNTL_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_MHUB {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_MHUB(...) pack_A6XX_RBBM_CLOCK_DELAY_MHUB(__struct_cast(A6XX_RBBM_CLOCK_DELAY_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_MHUB {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_MHUB(...) pack_A6XX_RBBM_CLOCK_HYST_MHUB(__struct_cast(A6XX_RBBM_CLOCK_HYST_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GLC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_DELAY_GLC(...) pack_A6XX_RBBM_CLOCK_DELAY_GLC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GLC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GLC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_HYST_GLC(...) pack_A6XX_RBBM_CLOCK_HYST_GLC(__struct_cast(A6XX_RBBM_CLOCK_HYST_GLC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_GLC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_CLOCK_CNTL_GLC(...) pack_A6XX_RBBM_CLOCK_CNTL_GLC(__struct_cast(A6XX_RBBM_CLOCK_CNTL_GLC) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_HYST2_VFD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CLOCK_HYST2_VFD(...) pack_A7XX_RBBM_CLOCK_HYST2_VFD(__struct_cast(A7XX_RBBM_CLOCK_HYST2_VFD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_0_PC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RBBM_CGC_0_PC(...) pack_A7XX_RBBM_CGC_0_PC(__struct_cast(A7XX_RBBM_CGC_0_PC) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_0_PC {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_CGC_0_PC(...) pack_A8XX_RBBM_CGC_0_PC(__struct_cast(A8XX_RBBM_CGC_0_PC) { __VA_ARGS__ })

struct A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(...) pack_A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(__struct_cast(A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_A {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_A(struct A6XX_DBGC_CFG_DBGBUS_SEL_A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000600,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_A(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_A(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_A) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_B {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_B(struct A6XX_DBGC_CFG_DBGBUS_SEL_B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000601,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_B(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_B(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_B) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_C {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_C(struct A6XX_DBGC_CFG_DBGBUS_SEL_C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000602,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_C(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_C(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_C) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_D {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_DBGC_CFG_DBGBUS_SEL_D(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_D(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_D) { __VA_ARGS__ })

struct A7XX_DBGC_CFG_DBGBUS_SEL_D {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_DBGC_CFG_DBGBUS_SEL_D(...) pack_A7XX_DBGC_CFG_DBGBUS_SEL_D(__struct_cast(A7XX_DBGC_CFG_DBGBUS_SEL_D) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CNTLT {
    uint32_t							traceen;
    uint32_t							granu;
    uint32_t							segt;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CNTLT(struct A6XX_DBGC_CFG_DBGBUS_CNTLT fields)
{
#ifndef NDEBUG
    assert((fields.traceen                           & 0xffffffc0) == 0);
    assert((fields.granu                             & 0xfffffff8) == 0);
    assert((fields.segt                              & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xf000703f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000604,
        .value =
            (fields.traceen                           <<  0) |
            (fields.granu                             << 12) |
            (fields.segt                              << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CNTLT(...) pack_A6XX_DBGC_CFG_DBGBUS_CNTLT(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CNTLT) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CNTLM {
    uint32_t							enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CNTLM(struct A6XX_DBGC_CFG_DBGBUS_CNTLM fields)
{
#ifndef NDEBUG
    assert((fields.enable                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0f000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000605,
        .value =
            (fields.enable                            << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CNTLM(...) pack_A6XX_DBGC_CFG_DBGBUS_CNTLM(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CNTLM) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OPL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OPL(struct A6XX_DBGC_CFG_DBGBUS_OPL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000606,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OPL(...) pack_A6XX_DBGC_CFG_DBGBUS_OPL(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OPL) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OPE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OPE(struct A6XX_DBGC_CFG_DBGBUS_OPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000607,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OPE(...) pack_A6XX_DBGC_CFG_DBGBUS_OPE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OPE) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_0(struct A6XX_DBGC_CFG_DBGBUS_IVTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000608,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_1(struct A6XX_DBGC_CFG_DBGBUS_IVTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000609,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_2(struct A6XX_DBGC_CFG_DBGBUS_IVTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_2(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_3(struct A6XX_DBGC_CFG_DBGBUS_IVTL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_3(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_0(struct A6XX_DBGC_CFG_DBGBUS_MASKL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_1(struct A6XX_DBGC_CFG_DBGBUS_MASKL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_2(struct A6XX_DBGC_CFG_DBGBUS_MASKL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_2(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_3(struct A6XX_DBGC_CFG_DBGBUS_MASKL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_3(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_BYTEL_0 {
    uint32_t							bytel0;
    uint32_t							bytel1;
    uint32_t							bytel2;
    uint32_t							bytel3;
    uint32_t							bytel4;
    uint32_t							bytel5;
    uint32_t							bytel6;
    uint32_t							bytel7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_0(struct A6XX_DBGC_CFG_DBGBUS_BYTEL_0 fields)
{
#ifndef NDEBUG
    assert((fields.bytel0                            & 0xfffffff0) == 0);
    assert((fields.bytel1                            & 0xfffffff0) == 0);
    assert((fields.bytel2                            & 0xfffffff0) == 0);
    assert((fields.bytel3                            & 0xfffffff0) == 0);
    assert((fields.bytel4                            & 0xfffffff0) == 0);
    assert((fields.bytel5                            & 0xfffffff0) == 0);
    assert((fields.bytel6                            & 0xfffffff0) == 0);
    assert((fields.bytel7                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000610,
        .value =
            (fields.bytel0                            <<  0) |
            (fields.bytel1                            <<  4) |
            (fields.bytel2                            <<  8) |
            (fields.bytel3                            << 12) |
            (fields.bytel4                            << 16) |
            (fields.bytel5                            << 20) |
            (fields.bytel6                            << 24) |
            (fields.bytel7                            << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_BYTEL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_BYTEL_1 {
    uint32_t							bytel8;
    uint32_t							bytel9;
    uint32_t							bytel10;
    uint32_t							bytel11;
    uint32_t							bytel12;
    uint32_t							bytel13;
    uint32_t							bytel14;
    uint32_t							bytel15;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_1(struct A6XX_DBGC_CFG_DBGBUS_BYTEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.bytel8                            & 0xfffffff0) == 0);
    assert((fields.bytel9                            & 0xfffffff0) == 0);
    assert((fields.bytel10                           & 0xfffffff0) == 0);
    assert((fields.bytel11                           & 0xfffffff0) == 0);
    assert((fields.bytel12                           & 0xfffffff0) == 0);
    assert((fields.bytel13                           & 0xfffffff0) == 0);
    assert((fields.bytel14                           & 0xfffffff0) == 0);
    assert((fields.bytel15                           & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000611,
        .value =
            (fields.bytel8                            <<  0) |
            (fields.bytel9                            <<  4) |
            (fields.bytel10                           <<  8) |
            (fields.bytel11                           << 12) |
            (fields.bytel12                           << 16) |
            (fields.bytel13                           << 20) |
            (fields.bytel14                           << 24) |
            (fields.bytel15                           << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_BYTEL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_0(struct A6XX_DBGC_CFG_DBGBUS_IVTE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000612,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_0(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_1(struct A6XX_DBGC_CFG_DBGBUS_IVTE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000613,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_1(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_2(struct A6XX_DBGC_CFG_DBGBUS_IVTE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000614,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_2(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_3(struct A6XX_DBGC_CFG_DBGBUS_IVTE_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000615,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_3(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_0(struct A6XX_DBGC_CFG_DBGBUS_MASKE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000616,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_0(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_1(struct A6XX_DBGC_CFG_DBGBUS_MASKE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000617,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_1(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_2(struct A6XX_DBGC_CFG_DBGBUS_MASKE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000618,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_2(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_3(struct A6XX_DBGC_CFG_DBGBUS_MASKE_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000619,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_3(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_NIBBLEE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_NIBBLEE(struct A6XX_DBGC_CFG_DBGBUS_NIBBLEE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_NIBBLEE(...) pack_A6XX_DBGC_CFG_DBGBUS_NIBBLEE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_NIBBLEE) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PTRC0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PTRC0(struct A6XX_DBGC_CFG_DBGBUS_PTRC0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PTRC0(...) pack_A6XX_DBGC_CFG_DBGBUS_PTRC0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PTRC0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PTRC1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PTRC1(struct A6XX_DBGC_CFG_DBGBUS_PTRC1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PTRC1(...) pack_A6XX_DBGC_CFG_DBGBUS_PTRC1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PTRC1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_LOADREG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_LOADREG(struct A6XX_DBGC_CFG_DBGBUS_LOADREG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_LOADREG(...) pack_A6XX_DBGC_CFG_DBGBUS_LOADREG(__struct_cast(A6XX_DBGC_CFG_DBGBUS_LOADREG) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IDX {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IDX(struct A6XX_DBGC_CFG_DBGBUS_IDX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IDX(...) pack_A6XX_DBGC_CFG_DBGBUS_IDX(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IDX) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CLRC {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CLRC(struct A6XX_DBGC_CFG_DBGBUS_CLRC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CLRC(...) pack_A6XX_DBGC_CFG_DBGBUS_CLRC(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CLRC) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_LOADIVT {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_LOADIVT(struct A6XX_DBGC_CFG_DBGBUS_LOADIVT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000620,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_LOADIVT(...) pack_A6XX_DBGC_CFG_DBGBUS_LOADIVT(__struct_cast(A6XX_DBGC_CFG_DBGBUS_LOADIVT) { __VA_ARGS__ })

struct A6XX_DBGC_VBIF_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_VBIF_DBG_CNTL(struct A6XX_DBGC_VBIF_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000621,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_VBIF_DBG_CNTL(...) pack_A6XX_DBGC_VBIF_DBG_CNTL(__struct_cast(A6XX_DBGC_VBIF_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LO_HI_GPIO {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LO_HI_GPIO(struct A6XX_DBGC_DBG_LO_HI_GPIO fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000622,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LO_HI_GPIO(...) pack_A6XX_DBGC_DBG_LO_HI_GPIO(__struct_cast(A6XX_DBGC_DBG_LO_HI_GPIO) { __VA_ARGS__ })

struct A6XX_DBGC_EXT_TRACE_BUS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EXT_TRACE_BUS_CNTL(struct A6XX_DBGC_EXT_TRACE_BUS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000623,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EXT_TRACE_BUS_CNTL(...) pack_A6XX_DBGC_EXT_TRACE_BUS_CNTL(__struct_cast(A6XX_DBGC_EXT_TRACE_BUS_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_READ_AHB_THROUGH_DBG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_READ_AHB_THROUGH_DBG(struct A6XX_DBGC_READ_AHB_THROUGH_DBG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000624,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_READ_AHB_THROUGH_DBG(...) pack_A6XX_DBGC_READ_AHB_THROUGH_DBG(__struct_cast(A6XX_DBGC_READ_AHB_THROUGH_DBG) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(struct A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000625,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(...) pack_A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(__struct_cast(A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OVER {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OVER(struct A6XX_DBGC_CFG_DBGBUS_OVER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000626,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OVER(...) pack_A6XX_DBGC_CFG_DBGBUS_OVER(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OVER) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT0(struct A6XX_DBGC_CFG_DBGBUS_COUNT0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000627,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT0(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT1(struct A6XX_DBGC_CFG_DBGBUS_COUNT1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000628,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT1(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT2(struct A6XX_DBGC_CFG_DBGBUS_COUNT2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000629,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT2(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT3(struct A6XX_DBGC_CFG_DBGBUS_COUNT3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT3(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT4 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT4(struct A6XX_DBGC_CFG_DBGBUS_COUNT4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT4(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT4(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT4) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT5 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT5(struct A6XX_DBGC_CFG_DBGBUS_COUNT5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT5(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT5(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT5) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(struct A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000630,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000631,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000632,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISR0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISR0(struct A6XX_DBGC_CFG_DBGBUS_MISR0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000633,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISR0(...) pack_A6XX_DBGC_CFG_DBGBUS_MISR0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISR0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISR1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISR1(struct A6XX_DBGC_CFG_DBGBUS_MISR1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000634,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISR1(...) pack_A6XX_DBGC_CFG_DBGBUS_MISR1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISR1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_CFG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_CFG(struct A6XX_DBGC_EVT_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000635,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_CFG(...) pack_A6XX_DBGC_EVT_CFG(__struct_cast(A6XX_DBGC_EVT_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_0(struct A6XX_DBGC_EVT_INTF_SEL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000636,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_0(...) pack_A6XX_DBGC_EVT_INTF_SEL_0(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_0) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_1(struct A6XX_DBGC_EVT_INTF_SEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000637,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_1(...) pack_A6XX_DBGC_EVT_INTF_SEL_1(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_SLICE_CFG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_SLICE_CFG(struct A6XX_DBGC_EVT_SLICE_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000638,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_SLICE_CFG(...) pack_A6XX_DBGC_EVT_SLICE_CFG(__struct_cast(A6XX_DBGC_EVT_SLICE_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_QDSS_TIMESTAMP_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_QDSS_TIMESTAMP_0(struct A6XX_DBGC_QDSS_TIMESTAMP_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000639,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_QDSS_TIMESTAMP_0(...) pack_A6XX_DBGC_QDSS_TIMESTAMP_0(__struct_cast(A6XX_DBGC_QDSS_TIMESTAMP_0) { __VA_ARGS__ })

struct A6XX_DBGC_QDSS_TIMESTAMP_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_QDSS_TIMESTAMP_1(struct A6XX_DBGC_QDSS_TIMESTAMP_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_QDSS_TIMESTAMP_1(...) pack_A6XX_DBGC_QDSS_TIMESTAMP_1(__struct_cast(A6XX_DBGC_QDSS_TIMESTAMP_1) { __VA_ARGS__ })

struct A6XX_DBGC_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_ECO_CNTL(struct A6XX_DBGC_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_ECO_CNTL(...) pack_A6XX_DBGC_ECO_CNTL(__struct_cast(A6XX_DBGC_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_AHB_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_AHB_DBG_CNTL(struct A6XX_DBGC_AHB_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_AHB_DBG_CNTL(...) pack_A6XX_DBGC_AHB_DBG_CNTL(__struct_cast(A6XX_DBGC_AHB_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_2(struct A6XX_DBGC_EVT_INTF_SEL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_2(...) pack_A6XX_DBGC_EVT_INTF_SEL_2(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000640,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000641,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000642,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000643,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISC_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISC_MODE(struct A6XX_DBGC_CFG_DBGBUS_MISC_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000644,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISC_MODE(...) pack_A6XX_DBGC_CFG_DBGBUS_MISC_MODE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISC_MODE) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_0(struct A6XX_DBGC_EVT_INTF_SEL_3_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000650,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_0(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_0(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_0) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_1(struct A6XX_DBGC_EVT_INTF_SEL_3_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000651,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_1(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_1(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_2(struct A6XX_DBGC_EVT_INTF_SEL_3_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000652,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_2(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_2(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_2) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_3(struct A6XX_DBGC_EVT_INTF_SEL_3_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000653,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_3(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_3(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_3) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_4(struct A6XX_DBGC_EVT_INTF_SEL_3_4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000654,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_4(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_4(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_4) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_5 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_5(struct A6XX_DBGC_EVT_INTF_SEL_3_5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000655,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_5(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_5(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_5) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_STATUS(struct A6XX_DBGC_TRACE_BUFFER_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000660,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_STATUS(...) pack_A6XX_DBGC_TRACE_BUFFER_STATUS(__struct_cast(A6XX_DBGC_TRACE_BUFFER_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_CMD(struct A6XX_DBGC_TRACE_BUFFER_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000661,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_CMD(...) pack_A6XX_DBGC_TRACE_BUFFER_CMD(__struct_cast(A6XX_DBGC_TRACE_BUFFER_CMD) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000662,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(...) pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(__struct_cast(A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000663,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(...) pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(__struct_cast(A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(struct A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000664,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(...) pack_A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(__struct_cast(A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(struct A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000665,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(...) pack_A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(__struct_cast(A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_RD_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(struct A6XX_DBGC_DBG_LOPC_SB_RD_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000666,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(...) pack_A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_RD_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_RD_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_RD_DATA(struct A6XX_DBGC_DBG_LOPC_SB_RD_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000667,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_RD_DATA(...) pack_A6XX_DBGC_DBG_LOPC_SB_RD_DATA(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_RD_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_WR_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(struct A6XX_DBGC_DBG_LOPC_SB_WR_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000668,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(...) pack_A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_WR_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_WR_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_WR_DATA(struct A6XX_DBGC_DBG_LOPC_SB_WR_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000669,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_WR_DATA(...) pack_A6XX_DBGC_DBG_LOPC_SB_WR_DATA(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_WR_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_INTERRUPT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_INTERRUPT_STATUS(struct A6XX_DBGC_INTERRUPT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000066a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_INTERRUPT_STATUS(...) pack_A6XX_DBGC_INTERRUPT_STATUS(__struct_cast(A6XX_DBGC_INTERRUPT_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_BASE(struct A6XX_DBGC_GBIF_DBG_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000680,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_DBGC_GBIF_DBG_BASE(...) pack_A6XX_DBGC_GBIF_DBG_BASE(__struct_cast(A6XX_DBGC_GBIF_DBG_BASE) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_BUFF_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_BUFF_SIZE(struct A6XX_DBGC_GBIF_DBG_BUFF_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000682,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_BUFF_SIZE(...) pack_A6XX_DBGC_GBIF_DBG_BUFF_SIZE(__struct_cast(A6XX_DBGC_GBIF_DBG_BUFF_SIZE) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_CNTL(struct A6XX_DBGC_GBIF_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000683,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_CNTL(...) pack_A6XX_DBGC_GBIF_DBG_CNTL(__struct_cast(A6XX_DBGC_GBIF_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_CMD(struct A6XX_DBGC_GBIF_DBG_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000684,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_CMD(...) pack_A6XX_DBGC_GBIF_DBG_CMD(__struct_cast(A6XX_DBGC_GBIF_DBG_CMD) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_STATUS(struct A6XX_DBGC_GBIF_DBG_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000685,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_STATUS(...) pack_A6XX_DBGC_GBIF_DBG_STATUS(__struct_cast(A6XX_DBGC_GBIF_DBG_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US(...) pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US(__struct_cast(A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_QOS_CTRL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_QOS_CTRL(...) pack_A8XX_DBGC_CFG_GBIF_QOS_CTRL(__struct_cast(A8XX_DBGC_CFG_GBIF_QOS_CTRL) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID(...) pack_A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID(__struct_cast(A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US(...) pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US(__struct_cast(A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD(...) pack_A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD(__struct_cast(A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_INTERRUPT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LOPC_INTERRUPT_STATUS(...) pack_A8XX_DBGC_LOPC_INTERRUPT_STATUS(__struct_cast(A8XX_DBGC_LOPC_INTERRUPT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_BUFFER_PTR_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LOPC_BUFFER_PTR_STATUS(...) pack_A8XX_DBGC_LOPC_BUFFER_PTR_STATUS(__struct_cast(A8XX_DBGC_LOPC_BUFFER_PTR_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_SCOPING_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_SCOPING_STATUS(...) pack_A8XX_DBGC_PERF_SCOPING_STATUS(__struct_cast(A8XX_DBGC_PERF_SCOPING_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_PKT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_COUNTER_PKT_STATUS(...) pack_A8XX_DBGC_PERF_COUNTER_PKT_STATUS(__struct_cast(A8XX_DBGC_PERF_COUNTER_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS(...) pack_A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_GC_ALW_MBX_PKT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_GC_ALW_MBX_PKT_STATUS(...) pack_A8XX_DBGC_GC_ALW_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_GC_ALW_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_AO_CNTR_LO_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_AO_CNTR_LO_STATUS(...) pack_A8XX_DBGC_AO_CNTR_LO_STATUS(__struct_cast(A8XX_DBGC_AO_CNTR_LO_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_AO_CNTR_HI_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_AO_CNTR_HI_STATUS(...) pack_A8XX_DBGC_AO_CNTR_HI_STATUS(__struct_cast(A8XX_DBGC_AO_CNTR_HI_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS(...) pack_A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS(__struct_cast(A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US(...) pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US(__struct_cast(A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US(...) pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US(__struct_cast(A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_MBX_PKT_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_MBX_PKT_STATUS(...) pack_A8XX_DBGC_LPAC_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_LPAC_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_SCOPING_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_PERF_SCOPING_STATUS(...) pack_A8XX_DBGC_LPAC_PERF_SCOPING_STATUS(__struct_cast(A8XX_DBGC_LPAC_PERF_SCOPING_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS(...) pack_A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS(__struct_cast(A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S(...) pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S(__struct_cast(A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S(...) pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S(...) pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S(__struct_cast(A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S(...) pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S(__struct_cast(A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TRIG_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S(...) pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S(__struct_cast(A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S) { __VA_ARGS__ })

struct A6XX_VSC_PERFCTR_VSC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PERFCTR_VSC_SEL_REG(uint32_t __i, struct A6XX_VSC_PERFCTR_VSC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000cd8 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PERFCTR_VSC_SEL_REG(__i, ...) pack_A6XX_VSC_PERFCTR_VSC_SEL_REG(__i, __struct_cast(A6XX_VSC_PERFCTR_VSC_SEL_REG) { __VA_ARGS__ })

struct A6XX_HLSQ_DBG_AHB_READ_APERTURE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_DBG_AHB_READ_APERTURE(struct A6XX_HLSQ_DBG_AHB_READ_APERTURE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000c800,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_DBG_AHB_READ_APERTURE(...) pack_A6XX_HLSQ_DBG_AHB_READ_APERTURE(__struct_cast(A6XX_HLSQ_DBG_AHB_READ_APERTURE) { __VA_ARGS__ })

struct A6XX_HLSQ_DBG_READ_SEL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_DBG_READ_SEL(struct A6XX_HLSQ_DBG_READ_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d000,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_DBG_READ_SEL(...) pack_A6XX_HLSQ_DBG_READ_SEL(__struct_cast(A6XX_HLSQ_DBG_READ_SEL) { __VA_ARGS__ })

struct A6XX_UCHE_ADDR_MODE_CNTL {
    enum a5xx_address_mode					uche_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_ADDR_MODE_CNTL(...) pack_A6XX_UCHE_ADDR_MODE_CNTL(__struct_cast(A6XX_UCHE_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_UCHE_MODE_CNTL(struct A6XX_UCHE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_MODE_CNTL(...) pack_A6XX_UCHE_MODE_CNTL(__struct_cast(A6XX_UCHE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_WRITE_RANGE_MAX {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_UCHE_WRITE_RANGE_MAX(...) pack_A6XX_UCHE_WRITE_RANGE_MAX(__struct_cast(A6XX_UCHE_WRITE_RANGE_MAX) { __VA_ARGS__ })

struct A6XX_UCHE_WRITE_THRU_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_UCHE_WRITE_THRU_BASE(...) pack_A6XX_UCHE_WRITE_THRU_BASE(__struct_cast(A6XX_UCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_WRITE_THRU_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_WRITE_THRU_BASE(...) pack_A8XX_UCHE_WRITE_THRU_BASE(__struct_cast(A8XX_UCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A6XX_UCHE_TRAP_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_UCHE_TRAP_BASE(...) pack_A6XX_UCHE_TRAP_BASE(__struct_cast(A6XX_UCHE_TRAP_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_TRAP_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_TRAP_BASE(...) pack_A8XX_UCHE_TRAP_BASE(__struct_cast(A8XX_UCHE_TRAP_BASE) { __VA_ARGS__ })

struct A6XX_UCHE_GMEM_RANGE_MIN {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_UCHE_GMEM_RANGE_MIN(...) pack_A6XX_UCHE_GMEM_RANGE_MIN(__struct_cast(A6XX_UCHE_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A6XX_UCHE_GMEM_RANGE_MAX {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_UCHE_GMEM_RANGE_MAX(...) pack_A6XX_UCHE_GMEM_RANGE_MAX(__struct_cast(A6XX_UCHE_GMEM_RANGE_MAX) { __VA_ARGS__ })

struct A6XX_UCHE_CACHE_WAYS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_CACHE_WAYS(...) pack_A6XX_UCHE_CACHE_WAYS(__struct_cast(A6XX_UCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A8XX_UCHE_CACHE_WAYS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_CACHE_WAYS(...) pack_A8XX_UCHE_CACHE_WAYS(__struct_cast(A8XX_UCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A6XX_UCHE_FILTER_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_UCHE_FILTER_CNTL(struct A6XX_UCHE_FILTER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e18,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_FILTER_CNTL(...) pack_A6XX_UCHE_FILTER_CNTL(__struct_cast(A6XX_UCHE_FILTER_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_CLIENT_PF {
    uint32_t							perfsel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_CLIENT_PF(...) pack_A6XX_UCHE_CLIENT_PF(__struct_cast(A6XX_UCHE_CLIENT_PF) { __VA_ARGS__ })

struct A6XX_UCHE_PERFCTR_UCHE_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, ...) pack_A6XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, __struct_cast(A6XX_UCHE_PERFCTR_UCHE_SEL_REG) { __VA_ARGS__ })

struct A8XX_UCHE_PERFCTR_UCHE_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, ...) pack_A8XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, __struct_cast(A8XX_UCHE_PERFCTR_UCHE_SEL_REG) { __VA_ARGS__ })

struct A6XX_UCHE_GBIF_GX_CONFIG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_GBIF_GX_CONFIG(...) pack_A6XX_UCHE_GBIF_GX_CONFIG(__struct_cast(A6XX_UCHE_GBIF_GX_CONFIG) { __VA_ARGS__ })

struct A8XX_UCHE_GBIF_GX_CONFIG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_GBIF_GX_CONFIG(...) pack_A8XX_UCHE_GBIF_GX_CONFIG(__struct_cast(A8XX_UCHE_GBIF_GX_CONFIG) { __VA_ARGS__ })

struct A6XX_UCHE_CMDQ_CONFIG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_CMDQ_CONFIG(...) pack_A6XX_UCHE_CMDQ_CONFIG(__struct_cast(A6XX_UCHE_CMDQ_CONFIG) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_CCHE_MODE_CNTL(...) pack_A8XX_UCHE_CCHE_MODE_CNTL(__struct_cast(A8XX_UCHE_CCHE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_CACHE_WAYS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_CCHE_CACHE_WAYS(...) pack_A8XX_UCHE_CCHE_CACHE_WAYS(__struct_cast(A8XX_UCHE_CCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_WRITE_THRU_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_CCHE_WRITE_THRU_BASE(...) pack_A8XX_UCHE_CCHE_WRITE_THRU_BASE(__struct_cast(A8XX_UCHE_CCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_TRAP_BASE {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_CCHE_TRAP_BASE(...) pack_A8XX_UCHE_CCHE_TRAP_BASE(__struct_cast(A8XX_UCHE_CCHE_TRAP_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN(...) pack_A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN(__struct_cast(A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN(...) pack_A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN(__struct_cast(A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_HW_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_CCHE_HW_DBG_CNTL(...) pack_A8XX_UCHE_CCHE_HW_DBG_CNTL(__struct_cast(A8XX_UCHE_CCHE_HW_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_VBIF_VERSION {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_VERSION(...) pack_A6XX_VBIF_VERSION(__struct_cast(A6XX_VBIF_VERSION) { __VA_ARGS__ })

struct A6XX_VBIF_CLKON {
    bool							force_on_testbus;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_CLKON(...) pack_A6XX_VBIF_CLKON(__struct_cast(A6XX_VBIF_CLKON) { __VA_ARGS__ })

struct A6XX_VBIF_GATE_OFF_WRREQ_EN {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_GATE_OFF_WRREQ_EN(...) pack_A6XX_VBIF_GATE_OFF_WRREQ_EN(__struct_cast(A6XX_VBIF_GATE_OFF_WRREQ_EN) { __VA_ARGS__ })

struct A6XX_VBIF_XIN_HALT_CTRL0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_XIN_HALT_CTRL0(...) pack_A6XX_VBIF_XIN_HALT_CTRL0(__struct_cast(A6XX_VBIF_XIN_HALT_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_XIN_HALT_CTRL1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_XIN_HALT_CTRL1(...) pack_A6XX_VBIF_XIN_HALT_CTRL1(__struct_cast(A6XX_VBIF_XIN_HALT_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS_OUT_CTRL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS_OUT_CTRL(...) pack_A6XX_VBIF_TEST_BUS_OUT_CTRL(__struct_cast(A6XX_VBIF_TEST_BUS_OUT_CTRL) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS1_CTRL0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS1_CTRL0(...) pack_A6XX_VBIF_TEST_BUS1_CTRL0(__struct_cast(A6XX_VBIF_TEST_BUS1_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS1_CTRL1 {
    uint32_t							data_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS1_CTRL1(...) pack_A6XX_VBIF_TEST_BUS1_CTRL1(__struct_cast(A6XX_VBIF_TEST_BUS1_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS2_CTRL0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS2_CTRL0(...) pack_A6XX_VBIF_TEST_BUS2_CTRL0(__struct_cast(A6XX_VBIF_TEST_BUS2_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS2_CTRL1 {
    uint32_t							data_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS2_CTRL1(...) pack_A6XX_VBIF_TEST_BUS2_CTRL1(__struct_cast(A6XX_VBIF_TEST_BUS2_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS_OUT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_TEST_BUS_OUT(...) pack_A6XX_VBIF_TEST_BUS_OUT(__struct_cast(A6XX_VBIF_TEST_BUS_OUT) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_SEL0(...) pack_A6XX_VBIF_PERF_CNT_SEL0(__struct_cast(A6XX_VBIF_PERF_CNT_SEL0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_SEL1(...) pack_A6XX_VBIF_PERF_CNT_SEL1(__struct_cast(A6XX_VBIF_PERF_CNT_SEL1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_SEL2(...) pack_A6XX_VBIF_PERF_CNT_SEL2(__struct_cast(A6XX_VBIF_PERF_CNT_SEL2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_SEL3(...) pack_A6XX_VBIF_PERF_CNT_SEL3(__struct_cast(A6XX_VBIF_PERF_CNT_SEL3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_LOW0(...) pack_A6XX_VBIF_PERF_CNT_LOW0(__struct_cast(A6XX_VBIF_PERF_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_LOW1(...) pack_A6XX_VBIF_PERF_CNT_LOW1(__struct_cast(A6XX_VBIF_PERF_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_LOW2(...) pack_A6XX_VBIF_PERF_CNT_LOW2(__struct_cast(A6XX_VBIF_PERF_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_LOW3(...) pack_A6XX_VBIF_PERF_CNT_LOW3(__struct_cast(A6XX_VBIF_PERF_CNT_LOW3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_HIGH0(...) pack_A6XX_VBIF_PERF_CNT_HIGH0(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_HIGH1(...) pack_A6XX_VBIF_PERF_CNT_HIGH1(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_HIGH2(...) pack_A6XX_VBIF_PERF_CNT_HIGH2(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_CNT_HIGH3(...) pack_A6XX_VBIF_PERF_CNT_HIGH3(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_EN0(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_EN1(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_EN2(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_LOW0(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_LOW1(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_LOW2(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_HIGH0(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_HIGH1(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VBIF_PERF_PWR_CNT_HIGH2(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH2) { __VA_ARGS__ })

struct A8XX_GBIF_CX_CONFIG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_CX_CONFIG(...) pack_A8XX_GBIF_CX_CONFIG(__struct_cast(A8XX_GBIF_CX_CONFIG) { __VA_ARGS__ })

struct A6XX_GBIF_SCACHE_CNTL0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_SCACHE_CNTL0(struct A6XX_GBIF_SCACHE_CNTL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_SCACHE_CNTL0(...) pack_A6XX_GBIF_SCACHE_CNTL0(__struct_cast(A6XX_GBIF_SCACHE_CNTL0) { __VA_ARGS__ })

struct A6XX_GBIF_SCACHE_CNTL1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_SCACHE_CNTL1(struct A6XX_GBIF_SCACHE_CNTL1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c02,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_SCACHE_CNTL1(...) pack_A6XX_GBIF_SCACHE_CNTL1(__struct_cast(A6XX_GBIF_SCACHE_CNTL1) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE0(struct A6XX_GBIF_QSB_SIDE0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c03,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE0(...) pack_A6XX_GBIF_QSB_SIDE0(__struct_cast(A6XX_GBIF_QSB_SIDE0) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE1(struct A6XX_GBIF_QSB_SIDE1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c04,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE1(...) pack_A6XX_GBIF_QSB_SIDE1(__struct_cast(A6XX_GBIF_QSB_SIDE1) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE2(struct A6XX_GBIF_QSB_SIDE2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c05,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE2(...) pack_A6XX_GBIF_QSB_SIDE2(__struct_cast(A6XX_GBIF_QSB_SIDE2) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE3(struct A6XX_GBIF_QSB_SIDE3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c06,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE3(...) pack_A6XX_GBIF_QSB_SIDE3(__struct_cast(A6XX_GBIF_QSB_SIDE3) { __VA_ARGS__ })

struct A6XX_GBIF_HALT {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_HALT(struct A6XX_GBIF_HALT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c45,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_HALT(...) pack_A6XX_GBIF_HALT(__struct_cast(A6XX_GBIF_HALT) { __VA_ARGS__ })

struct A6XX_GBIF_HALT_ACK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_HALT_ACK(struct A6XX_GBIF_HALT_ACK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c46,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_HALT_ACK(...) pack_A6XX_GBIF_HALT_ACK(__struct_cast(A6XX_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A8XX_GBIF_REINIT_ENABLE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_REINIT_ENABLE(...) pack_A8XX_GBIF_REINIT_ENABLE(__struct_cast(A8XX_GBIF_REINIT_ENABLE) { __VA_ARGS__ })

struct A8XX_GBIF_REINIT_DONE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_REINIT_DONE(...) pack_A8XX_GBIF_REINIT_DONE(__struct_cast(A8XX_GBIF_REINIT_DONE) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_EN {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_PWR_CNT_EN(struct A6XX_GBIF_PERF_PWR_CNT_EN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_PWR_CNT_EN(...) pack_A6XX_GBIF_PERF_PWR_CNT_EN(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_EN) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_CLR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_PWR_CNT_CLR(struct A6XX_GBIF_PERF_PWR_CNT_CLR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_PWR_CNT_CLR(...) pack_A6XX_GBIF_PERF_PWR_CNT_CLR(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_CLR) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_SEL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_SEL(struct A6XX_GBIF_PERF_CNT_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_SEL(...) pack_A6XX_GBIF_PERF_CNT_SEL(__struct_cast(A6XX_GBIF_PERF_CNT_SEL) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_SEL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_SEL_1(...) pack_A8XX_GBIF_PERF_CNT_SEL_1(__struct_cast(A8XX_GBIF_PERF_CNT_SEL_1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_SEL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_PWR_CNT_SEL(...) pack_A6XX_GBIF_PERF_PWR_CNT_SEL(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_SEL) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_LOW0(...) pack_A6XX_GBIF_PERF_CNT_LOW0(__struct_cast(A6XX_GBIF_PERF_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_LOW1(...) pack_A6XX_GBIF_PERF_CNT_LOW1(__struct_cast(A6XX_GBIF_PERF_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_LOW2(...) pack_A6XX_GBIF_PERF_CNT_LOW2(__struct_cast(A6XX_GBIF_PERF_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_LOW3(...) pack_A6XX_GBIF_PERF_CNT_LOW3(__struct_cast(A6XX_GBIF_PERF_CNT_LOW3) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_HIGH0(...) pack_A6XX_GBIF_PERF_CNT_HIGH0(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_HIGH1(...) pack_A6XX_GBIF_PERF_CNT_HIGH1(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_HIGH2(...) pack_A6XX_GBIF_PERF_CNT_HIGH2(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH2) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PERF_CNT_HIGH3(...) pack_A6XX_GBIF_PERF_CNT_HIGH3(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH3) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_LOW0(...) pack_A6XX_GBIF_PWR_CNT_LOW0(__struct_cast(A6XX_GBIF_PWR_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_LOW1(...) pack_A6XX_GBIF_PWR_CNT_LOW1(__struct_cast(A6XX_GBIF_PWR_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_LOW2(...) pack_A6XX_GBIF_PWR_CNT_LOW2(__struct_cast(A6XX_GBIF_PWR_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_HIGH0(...) pack_A6XX_GBIF_PWR_CNT_HIGH0(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_HIGH1(...) pack_A6XX_GBIF_PWR_CNT_HIGH1(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GBIF_PWR_CNT_HIGH2(...) pack_A6XX_GBIF_PWR_CNT_HIGH2(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH2) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_SEL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_SEL(...) pack_A8XX_GBIF_PWR_CNT_SEL(__struct_cast(A8XX_GBIF_PWR_CNT_SEL) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_0(...) pack_A8XX_GBIF_PERF_CNT_LO_0(__struct_cast(A8XX_GBIF_PERF_CNT_LO_0) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_0(...) pack_A8XX_GBIF_PERF_CNT_HI_0(__struct_cast(A8XX_GBIF_PERF_CNT_HI_0) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_1(...) pack_A8XX_GBIF_PERF_CNT_LO_1(__struct_cast(A8XX_GBIF_PERF_CNT_LO_1) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_1(...) pack_A8XX_GBIF_PERF_CNT_HI_1(__struct_cast(A8XX_GBIF_PERF_CNT_HI_1) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_2(...) pack_A8XX_GBIF_PERF_CNT_LO_2(__struct_cast(A8XX_GBIF_PERF_CNT_LO_2) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_2(...) pack_A8XX_GBIF_PERF_CNT_HI_2(__struct_cast(A8XX_GBIF_PERF_CNT_HI_2) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_3(...) pack_A8XX_GBIF_PERF_CNT_LO_3(__struct_cast(A8XX_GBIF_PERF_CNT_LO_3) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_3(...) pack_A8XX_GBIF_PERF_CNT_HI_3(__struct_cast(A8XX_GBIF_PERF_CNT_HI_3) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_4(...) pack_A8XX_GBIF_PERF_CNT_LO_4(__struct_cast(A8XX_GBIF_PERF_CNT_LO_4) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_4(...) pack_A8XX_GBIF_PERF_CNT_HI_4(__struct_cast(A8XX_GBIF_PERF_CNT_HI_4) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_5 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_5(...) pack_A8XX_GBIF_PERF_CNT_LO_5(__struct_cast(A8XX_GBIF_PERF_CNT_LO_5) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_5 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_5(...) pack_A8XX_GBIF_PERF_CNT_HI_5(__struct_cast(A8XX_GBIF_PERF_CNT_HI_5) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_6 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_6(...) pack_A8XX_GBIF_PERF_CNT_LO_6(__struct_cast(A8XX_GBIF_PERF_CNT_LO_6) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_6 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_6(...) pack_A8XX_GBIF_PERF_CNT_HI_6(__struct_cast(A8XX_GBIF_PERF_CNT_HI_6) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_7 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_LO_7(...) pack_A8XX_GBIF_PERF_CNT_LO_7(__struct_cast(A8XX_GBIF_PERF_CNT_LO_7) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_7 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PERF_CNT_HI_7(...) pack_A8XX_GBIF_PERF_CNT_HI_7(__struct_cast(A8XX_GBIF_PERF_CNT_HI_7) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_LO_0(...) pack_A8XX_GBIF_PWR_CNT_LO_0(__struct_cast(A8XX_GBIF_PWR_CNT_LO_0) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_LO_1(...) pack_A8XX_GBIF_PWR_CNT_LO_1(__struct_cast(A8XX_GBIF_PWR_CNT_LO_1) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_LO_2(...) pack_A8XX_GBIF_PWR_CNT_LO_2(__struct_cast(A8XX_GBIF_PWR_CNT_LO_2) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_HI_0(...) pack_A8XX_GBIF_PWR_CNT_HI_0(__struct_cast(A8XX_GBIF_PWR_CNT_HI_0) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_HI_1(...) pack_A8XX_GBIF_PWR_CNT_HI_1(__struct_cast(A8XX_GBIF_PWR_CNT_HI_1) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GBIF_PWR_CNT_HI_2(...) pack_A8XX_GBIF_PWR_CNT_HI_2(__struct_cast(A8XX_GBIF_PWR_CNT_HI_2) { __VA_ARGS__ })

struct A6XX_VSC_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_DBG_ECO_CNTL(struct A6XX_VSC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_DBG_ECO_CNTL(...) pack_A6XX_VSC_DBG_ECO_CNTL(__struct_cast(A6XX_VSC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_VSC_KMD_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VSC_KMD_DBG_ECO_CNTL(...) pack_A8XX_VSC_KMD_DBG_ECO_CNTL(__struct_cast(A8XX_VSC_KMD_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_VSC_BIN_SIZE {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VSC_BIN_SIZE(...) pack_A6XX_VSC_BIN_SIZE(__struct_cast(A6XX_VSC_BIN_SIZE) { __VA_ARGS__ })

struct A8XX_VSC_BIN_SIZE {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VSC_BIN_SIZE(...) pack_A8XX_VSC_BIN_SIZE(__struct_cast(A8XX_VSC_BIN_SIZE) { __VA_ARGS__ })

struct A6XX_VSC_SIZE_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_SIZE_BASE(struct A6XX_VSC_SIZE_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c03,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_VSC_SIZE_BASE(...) pack_A6XX_VSC_SIZE_BASE(__struct_cast(A6XX_VSC_SIZE_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_EXPANDED_BIN_CNTL {
    uint32_t							nx;
    uint32_t							ny;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_EXPANDED_BIN_CNTL(struct A6XX_VSC_EXPANDED_BIN_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.nx                                & 0xfffffc00) == 0);
    assert((fields.ny                                & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x001ffffe) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c06,
        .value =
            (fields.nx                                <<  1) |
            (fields.ny                                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_EXPANDED_BIN_CNTL(...) pack_A6XX_VSC_EXPANDED_BIN_CNTL(__struct_cast(A6XX_VSC_EXPANDED_BIN_CNTL) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_CONFIG_REG {
    uint32_t							x;
    uint32_t							y;
    uint32_t							w;
    uint32_t							h;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_CONFIG_REG(uint32_t __i, struct A6XX_VSC_PIPE_CONFIG_REG fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xfffffc00) == 0);
    assert((fields.y                                 & 0xfffffc00) == 0);
    assert((fields.w                                 & 0xffffffc0) == 0);
    assert((fields.h                                 & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c10 + 0x1*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 10) |
            (fields.w                                 << 20) |
            (fields.h                                 << 26) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_CONFIG_REG(__i, ...) pack_A6XX_VSC_PIPE_CONFIG_REG(__i, __struct_cast(A6XX_VSC_PIPE_CONFIG_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_BASE(struct A6XX_VSC_PIPE_DATA_PRIM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c30,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_BASE(...) pack_A6XX_VSC_PIPE_DATA_PRIM_BASE(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_PIPE_DATA_PRIM_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_STRIDE(struct A6XX_VSC_PIPE_DATA_PRIM_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c32,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_STRIDE(...) pack_A6XX_VSC_PIPE_DATA_PRIM_STRIDE(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_STRIDE) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_LENGTH {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_LENGTH(struct A6XX_VSC_PIPE_DATA_PRIM_LENGTH fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c33,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_LENGTH(...) pack_A6XX_VSC_PIPE_DATA_PRIM_LENGTH(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_LENGTH) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_BASE(struct A6XX_VSC_PIPE_DATA_DRAW_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c34,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_BASE(...) pack_A6XX_VSC_PIPE_DATA_DRAW_BASE(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_PIPE_DATA_DRAW_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_STRIDE(struct A6XX_VSC_PIPE_DATA_DRAW_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c36,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_STRIDE(...) pack_A6XX_VSC_PIPE_DATA_DRAW_STRIDE(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_STRIDE) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_LENGTH {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_LENGTH(struct A6XX_VSC_PIPE_DATA_DRAW_LENGTH fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c37,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_LENGTH(...) pack_A6XX_VSC_PIPE_DATA_DRAW_LENGTH(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_LENGTH) { __VA_ARGS__ })

struct A6XX_VSC_CHANNEL_VISIBILITY_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VSC_CHANNEL_VISIBILITY_REG(uint32_t __i, struct A6XX_VSC_CHANNEL_VISIBILITY_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c38 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_CHANNEL_VISIBILITY_REG(__i, ...) pack_A6XX_VSC_CHANNEL_VISIBILITY_REG(__i, __struct_cast(A6XX_VSC_CHANNEL_VISIBILITY_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG(__i, ...) pack_A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG(__i, __struct_cast(A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG(__i, ...) pack_A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG(__i, __struct_cast(A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG) { __VA_ARGS__ })

struct A7XX_VSC_UNKNOWN_0D08 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VSC_UNKNOWN_0D08(...) pack_A7XX_VSC_UNKNOWN_0D08(__struct_cast(A7XX_VSC_UNKNOWN_0D08) { __VA_ARGS__ })

struct A7XX_UCHE_UNKNOWN_0E10 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_UCHE_UNKNOWN_0E10(...) pack_A7XX_UCHE_UNKNOWN_0E10(__struct_cast(A7XX_UCHE_UNKNOWN_0E10) { __VA_ARGS__ })

struct A8XX_UCHE_VARB_IDLE_TIMEOUT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_VARB_IDLE_TIMEOUT(...) pack_A8XX_UCHE_VARB_IDLE_TIMEOUT(__struct_cast(A8XX_UCHE_VARB_IDLE_TIMEOUT) { __VA_ARGS__ })

struct A7XX_UCHE_UNKNOWN_0E11 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_UCHE_UNKNOWN_0E11(...) pack_A7XX_UCHE_UNKNOWN_0E11(__struct_cast(A7XX_UCHE_UNKNOWN_0E11) { __VA_ARGS__ })

struct A8XX_UCHE_CLIENT_PF {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_CLIENT_PF(...) pack_A8XX_UCHE_CLIENT_PF(__struct_cast(A8XX_UCHE_CLIENT_PF) { __VA_ARGS__ })

struct A6XX_UCHE_UNKNOWN_0E12 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_UCHE_UNKNOWN_0E12(...) pack_A6XX_UCHE_UNKNOWN_0E12(__struct_cast(A6XX_UCHE_UNKNOWN_0E12) { __VA_ARGS__ })

struct A8XX_UCHE_DBG_ECO_CNTL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_DBG_ECO_CNTL_0(...) pack_A8XX_UCHE_DBG_ECO_CNTL_0(__struct_cast(A8XX_UCHE_DBG_ECO_CNTL_0) { __VA_ARGS__ })

struct A8XX_UCHE_HW_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_UCHE_HW_DBG_CNTL(...) pack_A8XX_UCHE_HW_DBG_CNTL(__struct_cast(A8XX_UCHE_HW_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_CL_CNTL {
    bool							clip_disable;
    bool							znear_clip_disable;
    bool							zfar_clip_disable;
    bool							z_clamp_enable;
    bool							zero_gb_scale_z;
    bool							vp_clip_code_ignore;
    bool							vp_xform_disable;
    bool							persp_division_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_CNTL(...) pack_A6XX_GRAS_CL_CNTL(__struct_cast(A6XX_GRAS_CL_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_CL_CNTL {
    bool							clip_disable;
    bool							znear_clip_disable;
    bool							zfar_clip_disable;
    bool							z_clamp_enable;
    bool							zero_gb_scale_z;
    bool							vp_clip_code_ignore;
    bool							vp_xform_disable;
    bool							persp_division_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_CNTL(...) pack_A8XX_GRAS_CL_CNTL(__struct_cast(A8XX_GRAS_CL_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_ARRAY_SIZE {
    uint32_t							gras_cl_array_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_ARRAY_SIZE(...) pack_A6XX_GRAS_CL_ARRAY_SIZE(__struct_cast(A6XX_GRAS_CL_ARRAY_SIZE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_ARRAY_SIZE {
    uint32_t							gras_cl_array_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_ARRAY_SIZE(...) pack_A8XX_GRAS_CL_ARRAY_SIZE(__struct_cast(A8XX_GRAS_CL_ARRAY_SIZE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							unk10;
    bool							unk11;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_INTERP_CNTL(...) pack_A6XX_GRAS_CL_INTERP_CNTL(__struct_cast(A6XX_GRAS_CL_INTERP_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_CL_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							unk10;
    bool							unk11;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_INTERP_CNTL(...) pack_A8XX_GRAS_CL_INTERP_CNTL(__struct_cast(A8XX_GRAS_CL_INTERP_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT {
    bool							binscaleen;
    enum a7xx_bin_scale						xscale_0;
    enum a7xx_bin_scale						yscale_0;
    enum a7xx_bin_scale						xscale_1;
    enum a7xx_bin_scale						yscale_1;
    enum a7xx_bin_scale						xscale_2;
    enum a7xx_bin_scale						yscale_2;
    enum a7xx_bin_scale						xscale_3;
    enum a7xx_bin_scale						yscale_3;
    enum a7xx_bin_scale						xscale_4;
    enum a7xx_bin_scale						yscale_4;
    enum a7xx_bin_scale						xscale_5;
    enum a7xx_bin_scale						yscale_5;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_BIN_FOVEAT(...) pack_A7XX_GRAS_BIN_FOVEAT(__struct_cast(A7XX_GRAS_BIN_FOVEAT) { __VA_ARGS__ })

struct A8XX_GRAS_BIN_FOVEAT {
    bool							binscaleen;
    enum a7xx_bin_scale						xscale_0;
    enum a7xx_bin_scale						yscale_0;
    enum a7xx_bin_scale						xscale_1;
    enum a7xx_bin_scale						yscale_1;
    enum a7xx_bin_scale						xscale_2;
    enum a7xx_bin_scale						yscale_2;
    enum a7xx_bin_scale						xscale_3;
    enum a7xx_bin_scale						yscale_3;
    enum a7xx_bin_scale						xscale_4;
    enum a7xx_bin_scale						yscale_4;
    enum a7xx_bin_scale						xscale_5;
    enum a7xx_bin_scale						yscale_5;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_BIN_FOVEAT(...) pack_A8XX_GRAS_BIN_FOVEAT(__struct_cast(A8XX_GRAS_BIN_FOVEAT) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_0 {
    uint32_t							xoffset_0;
    uint32_t							xoffset_1;
    uint32_t							xoffset_2;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_0(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_0) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_1 {
    uint32_t							xoffset_3;
    uint32_t							xoffset_4;
    uint32_t							xoffset_5;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_1(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_1) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_2 {
    uint32_t							yoffset_0;
    uint32_t							yoffset_1;
    uint32_t							yoffset_2;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_2(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_2) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_3 {
    uint32_t							yoffset_3;
    uint32_t							yoffset_4;
    uint32_t							yoffset_5;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_3(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_3) { __VA_ARGS__ })

struct A8XX_GRAS_BIN_FOVEAT_XY_OFFSET {
    uint32_t							xoffset;
    uint32_t							yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_BIN_FOVEAT_XY_OFFSET(__i, ...) pack_A8XX_GRAS_BIN_FOVEAT_XY_OFFSET(__i, __struct_cast(A8XX_GRAS_BIN_FOVEAT_XY_OFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET {
    uint32_t							xoffset;
    uint32_t							yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET(__i, ...) pack_A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET(__i, __struct_cast(A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_XOFFSET {
    float							gras_cl_viewport_xoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_XOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_XOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_XOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_XSCALE {
    float							gras_cl_viewport_xscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_XSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_XSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_XSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_YOFFSET {
    float							gras_cl_viewport_yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_YOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_YOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_YOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_YSCALE {
    float							gras_cl_viewport_yscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_YSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_YSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_YSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZOFFSET {
    float							gras_cl_viewport_zoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZSCALE {
    float							gras_cl_viewport_zscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_ZSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_XOFFSET {
    float							gras_cl_viewport_xoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_XOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_XOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_XOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_XSCALE {
    float							gras_cl_viewport_xscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_XSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_XSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_XSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_YOFFSET {
    float							gras_cl_viewport_yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_YOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_YOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_YOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_YSCALE {
    float							gras_cl_viewport_yscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_YSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_YSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_YSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZOFFSET {
    float							gras_cl_viewport_zoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZSCALE {
    float							gras_cl_viewport_zscale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_ZSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN {
    float							gras_cl_viewport_zclamp_min;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX {
    float							gras_cl_viewport_zclamp_max;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN {
    float							gras_cl_viewport_zclamp_min;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX {
    float							gras_cl_viewport_zclamp_max;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A6XX_GRAS_SU_CNTL {
    bool							cull_front;
    bool							cull_back;
    bool							front_cw;
    float							linehalfwidth;
    bool							poly_offset;
    uint32_t							unk12;
    enum a5xx_line_mode						line_mode;
    uint32_t							unk15;
    bool							multiview_enable;
    bool							rendertargetindexincr;
    bool							viewportindexincr;
    uint32_t							unk20;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_CNTL(...) pack_A6XX_GRAS_SU_CNTL(__struct_cast(A6XX_GRAS_SU_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_CNTL {
    bool							cull_front;
    bool							cull_back;
    bool							front_cw;
    float							linehalfwidth;
    bool							poly_offset;
    uint32_t							unk12;
    enum a5xx_line_mode						line_mode;
    uint32_t							unk15;
    bool							multiview_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_CNTL(...) pack_A8XX_GRAS_SU_CNTL(__struct_cast(A8XX_GRAS_SU_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_STEREO_CNTL {
    bool							rendertargetindexincr;
    bool							viewportindexincr;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_STEREO_CNTL(...) pack_A8XX_GRAS_SU_STEREO_CNTL(__struct_cast(A8XX_GRAS_SU_STEREO_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POINT_MINMAX {
    float							min;
    float							max;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_POINT_MINMAX(...) pack_A6XX_GRAS_SU_POINT_MINMAX(__struct_cast(A6XX_GRAS_SU_POINT_MINMAX) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POINT_MINMAX {
    float							min;
    float							max;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_POINT_MINMAX(...) pack_A8XX_GRAS_SU_POINT_MINMAX(__struct_cast(A8XX_GRAS_SU_POINT_MINMAX) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POINT_SIZE {
    float							gras_su_point_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_POINT_SIZE(...) pack_A6XX_GRAS_SU_POINT_SIZE(__struct_cast(A6XX_GRAS_SU_POINT_SIZE) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POINT_SIZE {
    float							gras_su_point_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_POINT_SIZE(...) pack_A8XX_GRAS_SU_POINT_SIZE(__struct_cast(A8XX_GRAS_SU_POINT_SIZE) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_CNTL {
    bool							z_test_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_DEPTH_CNTL(...) pack_A6XX_GRAS_SU_DEPTH_CNTL(__struct_cast(A6XX_GRAS_SU_DEPTH_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_CNTL {
    bool							z_test_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_DEPTH_CNTL(...) pack_A8XX_GRAS_SU_DEPTH_CNTL(__struct_cast(A8XX_GRAS_SU_DEPTH_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_STENCIL_CNTL {
    bool							stencil_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_STENCIL_CNTL(...) pack_A6XX_GRAS_SU_STENCIL_CNTL(__struct_cast(A6XX_GRAS_SU_STENCIL_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_STENCIL_CNTL {
    bool							stencil_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_STENCIL_CNTL(...) pack_A8XX_GRAS_SU_STENCIL_CNTL(__struct_cast(A8XX_GRAS_SU_STENCIL_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_SU_RENDER_CNTL {
    bool							fs_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_SU_RENDER_CNTL(...) pack_A7XX_GRAS_SU_RENDER_CNTL(__struct_cast(A7XX_GRAS_SU_RENDER_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_RENDER_CNTL {
    bool							fs_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_RENDER_CNTL(...) pack_A8XX_GRAS_SU_RENDER_CNTL(__struct_cast(A8XX_GRAS_SU_RENDER_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_DEPTH_PLANE_CNTL(...) pack_A6XX_GRAS_SU_DEPTH_PLANE_CNTL(__struct_cast(A6XX_GRAS_SU_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_DEPTH_PLANE_CNTL(...) pack_A8XX_GRAS_SU_DEPTH_PLANE_CNTL(__struct_cast(A8XX_GRAS_SU_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_SCALE {
    float							gras_su_poly_offset_scale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_POLY_OFFSET_SCALE(...) pack_A6XX_GRAS_SU_POLY_OFFSET_SCALE(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_SCALE) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_SCALE {
    float							gras_su_poly_offset_scale;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_POLY_OFFSET_SCALE(...) pack_A8XX_GRAS_SU_POLY_OFFSET_SCALE(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_SCALE) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET {
    float							gras_su_poly_offset_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET(...) pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_OFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET {
    float							gras_su_poly_offset_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET(...) pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_OFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP {
    float							gras_su_poly_offset_offset_clamp;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(...) pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP {
    float							gras_su_poly_offset_offset_clamp;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(...) pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_DEPTH_BUFFER_INFO(...) pack_A6XX_GRAS_SU_DEPTH_BUFFER_INFO(__struct_cast(A6XX_GRAS_SU_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_DEPTH_BUFFER_INFO(...) pack_A8XX_GRAS_SU_DEPTH_BUFFER_INFO(__struct_cast(A8XX_GRAS_SU_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    enum a6xx_shift_amount					shiftamount;
    bool							innerconservativerasen;
    uint32_t							unk4;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(...) pack_A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    enum a6xx_shift_amount					shiftamount;
    bool							innerconservativerasen;
    uint32_t							unk4;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(...) pack_A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_PATH_RENDERING_CNTL {
    bool							unk0;
    bool							linelengthen;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_SU_PATH_RENDERING_CNTL(struct A6XX_GRAS_SU_PATH_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000809a,
        .value =
            (fields.unk0                              <<  0) |
            (fields.linelengthen                      <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_PATH_RENDERING_CNTL(...) pack_A6XX_GRAS_SU_PATH_RENDERING_CNTL(__struct_cast(A6XX_GRAS_SU_PATH_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_VS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_VS_SIV_CNTL(...) pack_A6XX_GRAS_SU_VS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_VS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_GS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_GS_SIV_CNTL(...) pack_A6XX_GRAS_SU_GS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_GS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SU_DS_SIV_CNTL(...) pack_A6XX_GRAS_SU_DS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_VS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_VS_SIV_CNTL(...) pack_A8XX_GRAS_SU_VS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_VS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_GS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_GS_SIV_CNTL(...) pack_A8XX_GRAS_SU_GS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_GS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SU_DS_SIV_CNTL(...) pack_A8XX_GRAS_SU_DS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_RAST_CNTL(...) pack_A8XX_GRAS_RAST_CNTL(__struct_cast(A8XX_GRAS_RAST_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_CNTL {
    enum a6xx_single_prim_mode					single_prim_mode;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    enum a6xx_sequenced_thread_dist				sequenced_thread_distribution;
    bool							unk9;
    uint32_t							rotation;
    bool							earlyvizouten;
    uint32_t							ccusinglecachelinesize;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_CNTL(...) pack_A6XX_GRAS_SC_CNTL(__struct_cast(A6XX_GRAS_SC_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_CNTL {
    enum a6xx_single_prim_mode					single_prim_mode;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    enum a6xx_sequenced_thread_dist				sequenced_thread_distribution;
    bool							unk9;
    uint32_t							rotation;
    bool							earlyvizouten;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_CNTL(...) pack_A8XX_GRAS_SC_CNTL(__struct_cast(A8XX_GRAS_SC_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_BIN_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_buffers_location					buffers_location;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_BIN_CNTL(...) pack_A6XX_GRAS_SC_BIN_CNTL(__struct_cast(A6XX_GRAS_SC_BIN_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_BIN_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_write_dis;
    bool							cons_vis_in_binning;
    bool							force_bi_dir_lrz_disable;
    bool							force_lrz_dis;
    bool							bin_vrs_dis;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_BIN_CNTL(...) pack_A8XX_GRAS_SC_BIN_CNTL(__struct_cast(A8XX_GRAS_SC_BIN_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_RAS_MSAA_CNTL(...) pack_A6XX_GRAS_SC_RAS_MSAA_CNTL(__struct_cast(A6XX_GRAS_SC_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_RAS_MSAA_CNTL(...) pack_A8XX_GRAS_SC_RAS_MSAA_CNTL(__struct_cast(A8XX_GRAS_SC_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_DEST_MSAA_CNTL(...) pack_A6XX_GRAS_SC_DEST_MSAA_CNTL(__struct_cast(A6XX_GRAS_SC_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_DEST_MSAA_CNTL(...) pack_A8XX_GRAS_SC_DEST_MSAA_CNTL(__struct_cast(A8XX_GRAS_SC_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(...) pack_A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(__struct_cast(A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(...) pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(...) pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(...) pack_A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(__struct_cast(A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3) { __VA_ARGS__ })

struct A7XX_GRAS_ROTATION_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_ROTATION_CNTL(...) pack_A7XX_GRAS_ROTATION_CNTL(__struct_cast(A7XX_GRAS_ROTATION_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_ROTATION_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_ROTATION_CNTL(...) pack_A8XX_GRAS_ROTATION_CNTL(__struct_cast(A8XX_GRAS_ROTATION_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL {
    bool							scissor_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL(...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL(__struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL {
    bool							scissor_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL(...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL(__struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, ...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, __struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, ...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, __struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, ...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, __struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, ...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, __struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_BR) { __VA_ARGS__ })

struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, ...) pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, __struct_cast(A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, ...) pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, __struct_cast(A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, ...) pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, __struct_cast(A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, ...) pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, __struct_cast(A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL {
    bool							inclusion;
    bool							vp0_inv_scissor_0_en;
    bool							vp0_inv_scissor_1_en;
    bool							vp1_inv_scissor_0_en;
    bool							vp1_inv_scissor_1_en;
    bool							vp2_inv_scissor_0_en;
    bool							vp2_inv_scissor_1_en;
    bool							vp3_inv_scissor_0_en;
    bool							vp3_inv_scissor_1_en;
    bool							vp4_inv_scissor_0_en;
    bool							vp4_inv_scissor_1_en;
    bool							vp5_inv_scissor_0_en;
    bool							vp5_inv_scissor_1_en;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL(...) pack_A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL(__struct_cast(A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL(__i, ...) pack_A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL(__i, __struct_cast(A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR(__i, ...) pack_A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR(__i, __struct_cast(A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL(__i, ...) pack_A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL(__i, __struct_cast(A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR(__i, ...) pack_A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR(__i, __struct_cast(A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR) { __VA_ARGS__ })

struct A6XX_GRAS_SC_WINDOW_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL(...) pack_A6XX_GRAS_SC_WINDOW_SCISSOR_TL(__struct_cast(A6XX_GRAS_SC_WINDOW_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_WINDOW_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR(...) pack_A6XX_GRAS_SC_WINDOW_SCISSOR_BR(__struct_cast(A6XX_GRAS_SC_WINDOW_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL(...) pack_A8XX_GRAS_SC_WINDOW_SCISSOR_TL(__struct_cast(A8XX_GRAS_SC_WINDOW_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR(...) pack_A8XX_GRAS_SC_WINDOW_SCISSOR_BR(__struct_cast(A8XX_GRAS_SC_WINDOW_SCISSOR_BR) { __VA_ARGS__ })

struct A7XX_GRAS_VRS_CONFIG {
    bool							pipeline_fsr_enable;
    uint32_t							frag_size_x;
    uint32_t							frag_size_y;
    enum a6xx_fsr_combiner					combiner_op_1;
    enum a6xx_fsr_combiner					combiner_op_2;
    enum a6xx_fsr_combiner_clamp_mode				combiner_clamp_mode;
    bool							attachment_fsr_enable;
    bool							primitive_fsr_enable;
    uint32_t							quality_buffer_shift_x;
    uint32_t							quality_buffer_shift_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_VRS_CONFIG(...) pack_A7XX_GRAS_VRS_CONFIG(__struct_cast(A7XX_GRAS_VRS_CONFIG) { __VA_ARGS__ })

struct A8XX_GRAS_VRS_CONFIG {
    bool							pipeline_fsr_enable;
    uint32_t							frag_size_x;
    uint32_t							frag_size_y;
    enum a6xx_fsr_combiner					combiner_op_1;
    enum a6xx_fsr_combiner					combiner_op_2;
    enum a6xx_fsr_combiner_clamp_mode				combiner_clamp_mode;
    bool							attachment_fsr_enable;
    bool							primitive_fsr_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_VRS_CONFIG(...) pack_A8XX_GRAS_VRS_CONFIG(__struct_cast(A8XX_GRAS_VRS_CONFIG) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_INFO {
    bool							layered;
    enum a6xx_tile_mode						tile_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_QUALITY_BUFFER_INFO(...) pack_A7XX_GRAS_QUALITY_BUFFER_INFO(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_INFO {
    bool							layered;
    enum a6xx_tile_mode						tile_mode;
    uint32_t							quality_buffer_shift_x;
    uint32_t							quality_buffer_shift_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_QUALITY_BUFFER_INFO(...) pack_A8XX_GRAS_QUALITY_BUFFER_INFO(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION(...) pack_A7XX_GRAS_QUALITY_BUFFER_DIMENSION(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_DIMENSION) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION(...) pack_A8XX_GRAS_QUALITY_BUFFER_DIMENSION(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_DIMENSION) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_GRAS_QUALITY_BUFFER_BASE(...) pack_A7XX_GRAS_QUALITY_BUFFER_BASE(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_GRAS_QUALITY_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_GRAS_QUALITY_BUFFER_BASE(...) pack_A8XX_GRAS_QUALITY_BUFFER_BASE(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_GRAS_QUALITY_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_QUALITY_BUFFER_PITCH(...) pack_A7XX_GRAS_QUALITY_BUFFER_PITCH(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_QUALITY_BUFFER_PITCH(...) pack_A8XX_GRAS_QUALITY_BUFFER_PITCH(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_CNTL {
    bool							enable;
    bool							lrz_write;
    bool							greater;
    bool							z_write_enable;
    bool							z_bounds_enable;
    enum a6xx_lrz_dir_status					dir;
    bool							dir_write;
    enum adreno_compare_func					z_func;
    bool							fc_enable;
    bool							disable_on_wrong_dir;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_LRZ_CNTL(...) pack_A6XX_GRAS_LRZ_CNTL(__struct_cast(A6XX_GRAS_LRZ_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_CNTL {
    bool							enable;
    bool							lrz_write;
    bool							greater;
    bool							z_write_enable;
    bool							z_bounds_enable;
    enum a6xx_lrz_dir_status					dir;
    bool							dir_write;
    enum adreno_compare_func					z_func;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_CNTL(...) pack_A7XX_GRAS_LRZ_CNTL(__struct_cast(A7XX_GRAS_LRZ_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_CNTL {
    bool							enable;
    bool							lrz_write;
    bool							greater;
    bool							z_write_enable;
    bool							z_bounds_enable;
    enum a6xx_lrz_dir_status					dir;
    bool							dir_write;
    enum adreno_compare_func					z_func;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_CNTL(...) pack_A8XX_GRAS_LRZ_CNTL(__struct_cast(A8XX_GRAS_LRZ_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_CB_CNTL {
    uint32_t							double_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_CB_CNTL(...) pack_A7XX_GRAS_LRZ_CB_CNTL(__struct_cast(A7XX_GRAS_LRZ_CB_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_CB_CNTL {
    uint32_t							double_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_CB_CNTL(...) pack_A8XX_GRAS_LRZ_CB_CNTL(__struct_cast(A8XX_GRAS_LRZ_CB_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_PS_INPUT_CNTL {
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_LRZ_PS_INPUT_CNTL(...) pack_A6XX_GRAS_LRZ_PS_INPUT_CNTL(__struct_cast(A6XX_GRAS_LRZ_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_PS_INPUT_CNTL {
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_PS_INPUT_CNTL(...) pack_A8XX_GRAS_LRZ_PS_INPUT_CNTL(__struct_cast(A8XX_GRAS_LRZ_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0 {
    enum a6xx_format						color_format;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0(...) pack_A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0(__struct_cast(A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0 {
    enum a6xx_format						color_format;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0(...) pack_A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0(__struct_cast(A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_GRAS_LRZ_BUFFER_BASE(...) pack_A6XX_GRAS_LRZ_BUFFER_BASE(__struct_cast(A6XX_GRAS_LRZ_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_GRAS_LRZ_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_GRAS_LRZ_BUFFER_BASE(...) pack_A8XX_GRAS_LRZ_BUFFER_BASE(__struct_cast(A8XX_GRAS_LRZ_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_GRAS_LRZ_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_LRZ_BUFFER_PITCH(...) pack_A6XX_GRAS_LRZ_BUFFER_PITCH(__struct_cast(A6XX_GRAS_LRZ_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_BUFFER_PITCH(...) pack_A8XX_GRAS_LRZ_BUFFER_PITCH(__struct_cast(A8XX_GRAS_LRZ_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_BUFFER_STRIDE(...) pack_A8XX_GRAS_LRZ_BUFFER_STRIDE(__struct_cast(A8XX_GRAS_LRZ_BUFFER_STRIDE) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(struct A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008106,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(...) pack_A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(__struct_cast(A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL {
    bool							per_samp_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(struct A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008109,
        .value =
            (fields.per_samp_mode                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(...) pack_A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(__struct_cast(A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_VIEW_INFO {
    uint32_t							base_layer;
    uint32_t							layer_count;
    uint32_t							base_mip_level;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_VIEW_INFO(struct A6XX_GRAS_LRZ_VIEW_INFO fields)
{
#ifndef NDEBUG
    assert((fields.base_layer                        & 0xfffff800) == 0);
    assert((fields.layer_count                       & 0xfffff800) == 0);
    assert((fields.base_mip_level                    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xf7ff07ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810a,
        .value =
            (fields.base_layer                        <<  0) |
            (fields.layer_count                       << 16) |
            (fields.base_mip_level                    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_VIEW_INFO(...) pack_A6XX_GRAS_LRZ_VIEW_INFO(__struct_cast(A6XX_GRAS_LRZ_VIEW_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_CNTL2 {
    bool							disable_on_wrong_dir;
    bool							fc_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_CNTL2(...) pack_A7XX_GRAS_LRZ_CNTL2(__struct_cast(A7XX_GRAS_LRZ_CNTL2) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH {
    uint32_t							gras_lrz_buffer_slice_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(...) pack_A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(__struct_cast(A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH) { __VA_ARGS__ })

struct A6XX_GRAS_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_MODE_CNTL(...) pack_A6XX_GRAS_MODE_CNTL(__struct_cast(A6XX_GRAS_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_MODE_CNTL(...) pack_A8XX_GRAS_MODE_CNTL(__struct_cast(A8XX_GRAS_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_DEPTH_CLEAR {
    float							gras_lrz_depth_clear;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_DEPTH_CLEAR(...) pack_A7XX_GRAS_LRZ_DEPTH_CLEAR(__struct_cast(A7XX_GRAS_LRZ_DEPTH_CLEAR) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_DEPTH_CLEAR {
    float							gras_lrz_depth_clear;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_DEPTH_CLEAR(...) pack_A8XX_GRAS_LRZ_DEPTH_CLEAR(__struct_cast(A8XX_GRAS_LRZ_DEPTH_CLEAR) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO(...) pack_A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO(__struct_cast(A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO(...) pack_A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO(__struct_cast(A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, ...) pack_A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, __struct_cast(A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, ...) pack_A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, __struct_cast(A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_COLOR_COMP_MASK {
    uint32_t							mrt0;
    uint32_t							mrt1;
    uint32_t							mrt2;
    uint32_t							mrt3;
    uint32_t							mrt4;
    uint32_t							mrt5;
    uint32_t							mrt6;
    uint32_t							mrt7;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_LRZ_COLOR_COMP_MASK(...) pack_A8XX_GRAS_LRZ_COLOR_COMP_MASK(__struct_cast(A8XX_GRAS_LRZ_COLOR_COMP_MASK) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_BLT_CNTL(...) pack_A6XX_GRAS_A2D_BLT_CNTL(__struct_cast(A6XX_GRAS_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_XMIN {
    int32_t							gras_a2d_src_xmin;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SRC_XMIN(...) pack_A6XX_GRAS_A2D_SRC_XMIN(__struct_cast(A6XX_GRAS_A2D_SRC_XMIN) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_XMAX {
    int32_t							gras_a2d_src_xmax;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SRC_XMAX(...) pack_A6XX_GRAS_A2D_SRC_XMAX(__struct_cast(A6XX_GRAS_A2D_SRC_XMAX) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_YMIN {
    int32_t							gras_a2d_src_ymin;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SRC_YMIN(...) pack_A6XX_GRAS_A2D_SRC_YMIN(__struct_cast(A6XX_GRAS_A2D_SRC_YMIN) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_YMAX {
    int32_t							gras_a2d_src_ymax;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SRC_YMAX(...) pack_A6XX_GRAS_A2D_SRC_YMAX(__struct_cast(A6XX_GRAS_A2D_SRC_YMAX) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_DEST_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_DEST_TL(...) pack_A6XX_GRAS_A2D_DEST_TL(__struct_cast(A6XX_GRAS_A2D_DEST_TL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_DEST_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_DEST_BR(...) pack_A6XX_GRAS_A2D_DEST_BR(__struct_cast(A6XX_GRAS_A2D_DEST_BR) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8407 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8407(struct A6XX_GRAS_2D_UNKNOWN_8407 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008407,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8407(...) pack_A6XX_GRAS_2D_UNKNOWN_8407(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8407) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8408 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8408(struct A6XX_GRAS_2D_UNKNOWN_8408 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008408,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8408(...) pack_A6XX_GRAS_2D_UNKNOWN_8408(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8408) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8409 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8409(struct A6XX_GRAS_2D_UNKNOWN_8409 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008409,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8409(...) pack_A6XX_GRAS_2D_UNKNOWN_8409(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8409) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SCISSOR_TL(...) pack_A6XX_GRAS_A2D_SCISSOR_TL(__struct_cast(A6XX_GRAS_A2D_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_A2D_SCISSOR_BR(...) pack_A6XX_GRAS_A2D_SCISSOR_BR(__struct_cast(A6XX_GRAS_A2D_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_BLT_CNTL(...) pack_A8XX_GRAS_A2D_BLT_CNTL(__struct_cast(A8XX_GRAS_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_XMIN {
    int32_t							gras_a2d_src_xmin;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SRC_XMIN(...) pack_A8XX_GRAS_A2D_SRC_XMIN(__struct_cast(A8XX_GRAS_A2D_SRC_XMIN) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_XMAX {
    int32_t							gras_a2d_src_xmax;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SRC_XMAX(...) pack_A8XX_GRAS_A2D_SRC_XMAX(__struct_cast(A8XX_GRAS_A2D_SRC_XMAX) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_YMIN {
    int32_t							gras_a2d_src_ymin;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SRC_YMIN(...) pack_A8XX_GRAS_A2D_SRC_YMIN(__struct_cast(A8XX_GRAS_A2D_SRC_YMIN) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_YMAX {
    int32_t							gras_a2d_src_ymax;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SRC_YMAX(...) pack_A8XX_GRAS_A2D_SRC_YMAX(__struct_cast(A8XX_GRAS_A2D_SRC_YMAX) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_DEST_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_DEST_TL(...) pack_A8XX_GRAS_A2D_DEST_TL(__struct_cast(A8XX_GRAS_A2D_DEST_TL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_DEST_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_DEST_BR(...) pack_A8XX_GRAS_A2D_DEST_BR(__struct_cast(A8XX_GRAS_A2D_DEST_BR) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SCISSOR_TL(...) pack_A8XX_GRAS_A2D_SCISSOR_TL(__struct_cast(A8XX_GRAS_A2D_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_A2D_SCISSOR_BR(...) pack_A8XX_GRAS_A2D_SCISSOR_BR(__struct_cast(A8XX_GRAS_A2D_SCISSOR_BR) { __VA_ARGS__ })

struct A6XX_GRAS_DBG_ECO_CNTL {
    bool							unk7;
    bool							lrzcachelockdis;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_DBG_ECO_CNTL(...) pack_A6XX_GRAS_DBG_ECO_CNTL(__struct_cast(A6XX_GRAS_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_TSEFE_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_TSEFE_DBG_ECO_CNTL(...) pack_A8XX_GRAS_TSEFE_DBG_ECO_CNTL(__struct_cast(A8XX_GRAS_TSEFE_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_DBG_ECO_CNTL(...) pack_A8XX_GRAS_DBG_ECO_CNTL(__struct_cast(A8XX_GRAS_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_ADDR_MODE_CNTL {
    enum a5xx_address_mode					gras_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_ADDR_MODE_CNTL(...) pack_A6XX_GRAS_ADDR_MODE_CNTL(__struct_cast(A6XX_GRAS_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_GRAS_NC_MODE_CNTL(...) pack_A7XX_GRAS_NC_MODE_CNTL(__struct_cast(A7XX_GRAS_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_NC_MODE_CNTL(...) pack_A8XX_GRAS_NC_MODE_CNTL(__struct_cast(A8XX_GRAS_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_TSE_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_PERFCTR_TSE_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_TSE_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_TSE_SEL_REG) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_RAS_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_PERFCTR_RAS_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_RAS_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_RAS_SEL_REG) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_LRZ_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_LRZ_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_TSEFE_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_PERFCTR_TSEFE_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_TSEFE_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_TSEFE_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_TSE_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_PERFCTR_TSE_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_TSE_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_TSE_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_RAS_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_PERFCTR_RAS_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_RAS_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_RAS_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_LRZ_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_LRZ_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_buffers_location					buffers_location;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_CNTL(...) pack_A6XX_RB_CNTL(__struct_cast(A6XX_RB_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_write_dis;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_CNTL(...) pack_A8XX_RB_CNTL(__struct_cast(A8XX_RB_CNTL) { __VA_ARGS__ })

struct A6XX_RB_RENDER_CNTL {
    uint32_t							ccusinglecachelinesize;
    bool							earlyvizouten;
    bool							fs_disable;
    uint32_t							unk8;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    bool							conservativerasen;
    bool							innerconservativerasen;
    bool							flag_depth;
    uint32_t							flag_mrts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_RENDER_CNTL(...) pack_A6XX_RB_RENDER_CNTL(__struct_cast(A6XX_RB_RENDER_CNTL) { __VA_ARGS__ })

struct A7XX_RB_RENDER_CNTL {
    bool							earlyvizouten;
    bool							fs_disable;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    bool							conservativerasen;
    bool							innerconservativerasen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_RENDER_CNTL(...) pack_A7XX_RB_RENDER_CNTL(__struct_cast(A7XX_RB_RENDER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RAS_MSAA_CNTL(struct A6XX_RB_RAS_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unk2                              & 0xfffffffe) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008802,
        .value =
            (fields.samples                           <<  0) |
            (fields.unk2                              <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RAS_MSAA_CNTL(...) pack_A6XX_RB_RAS_MSAA_CNTL(__struct_cast(A6XX_RB_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEST_MSAA_CNTL(struct A6XX_RB_DEST_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008803,
        .value =
            (fields.samples                           <<  0) |
            (fields.msaa_disable                      <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEST_MSAA_CNTL(...) pack_A6XX_RB_DEST_MSAA_CNTL(__struct_cast(A6XX_RB_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_RB_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MSAA_SAMPLE_POS_CNTL(struct A6XX_RB_MSAA_SAMPLE_POS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008804,
        .value =
            (fields.unk0                              <<  0) |
            (fields.location_enable                   <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MSAA_SAMPLE_POS_CNTL(...) pack_A6XX_RB_MSAA_SAMPLE_POS_CNTL(__struct_cast(A6XX_RB_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_0(struct A6XX_RB_PROGRAMMABLE_MSAA_POS_0 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008805,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0(...) pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A6XX_RB_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A6XX_RB_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_1(struct A6XX_RB_PROGRAMMABLE_MSAA_POS_1 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008806,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1(...) pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A6XX_RB_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A8XX_RB_PROGRAMMABLE_MSAA_POS_2 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2(...) pack_A8XX_RB_PROGRAMMABLE_MSAA_POS_2(__struct_cast(A8XX_RB_PROGRAMMABLE_MSAA_POS_2) { __VA_ARGS__ })

struct A8XX_RB_PROGRAMMABLE_MSAA_POS_3 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3(...) pack_A8XX_RB_PROGRAMMABLE_MSAA_POS_3(__struct_cast(A8XX_RB_PROGRAMMABLE_MSAA_POS_3) { __VA_ARGS__ })

struct A6XX_RB_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							interp_en;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_INTERP_CNTL(struct A6XX_RB_INTERP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.coord_mask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008809,
        .value =
            (fields.ij_persp_pixel                    <<  0) |
            (fields.ij_persp_centroid                 <<  1) |
            (fields.ij_persp_sample                   <<  2) |
            (fields.ij_linear_pixel                   <<  3) |
            (fields.ij_linear_centroid                <<  4) |
            (fields.ij_linear_sample                  <<  5) |
            (fields.coord_mask                        <<  6) |
            (fields.interp_en                         << 10) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_INTERP_CNTL(...) pack_A6XX_RB_INTERP_CNTL(__struct_cast(A6XX_RB_INTERP_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_INPUT_CNTL {
    bool							samplemask;
    bool							postdepthcoverage;
    bool							faceness;
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    bool							centerrhw;
    bool							linelengthen;
    bool							foveation;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PS_INPUT_CNTL(struct A6XX_RB_PS_INPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.fragcoordsamplemode               & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880a,
        .value =
            (fields.samplemask                        <<  0) |
            (fields.postdepthcoverage                 <<  1) |
            (fields.faceness                          <<  2) |
            (fields.sampleid                          <<  3) |
            (fields.fragcoordsamplemode               <<  4) |
            (fields.centerrhw                         <<  6) |
            (fields.linelengthen                      <<  7) |
            (fields.foveation                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_INPUT_CNTL(...) pack_A6XX_RB_PS_INPUT_CNTL(__struct_cast(A6XX_RB_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_OUTPUT_CNTL {
    bool							dual_color_in_enable;
    bool							frag_writes_z;
    bool							frag_writes_sampmask;
    bool							frag_writes_stencilref;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PS_OUTPUT_CNTL(struct A6XX_RB_PS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880b,
        .value =
            (fields.dual_color_in_enable              <<  0) |
            (fields.frag_writes_z                     <<  1) |
            (fields.frag_writes_sampmask              <<  2) |
            (fields.frag_writes_stencilref            <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_OUTPUT_CNTL(...) pack_A6XX_RB_PS_OUTPUT_CNTL(__struct_cast(A6XX_RB_PS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_MRT_CNTL {
    uint32_t							mrt;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PS_MRT_CNTL(struct A6XX_RB_PS_MRT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mrt                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880c,
        .value =
            (fields.mrt                               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_MRT_CNTL(...) pack_A6XX_RB_PS_MRT_CNTL(__struct_cast(A6XX_RB_PS_MRT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_OUTPUT_MASK {
    uint32_t							rt0;
    uint32_t							rt1;
    uint32_t							rt2;
    uint32_t							rt3;
    uint32_t							rt4;
    uint32_t							rt5;
    uint32_t							rt6;
    uint32_t							rt7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PS_OUTPUT_MASK(struct A6XX_RB_PS_OUTPUT_MASK fields)
{
#ifndef NDEBUG
    assert((fields.rt0                               & 0xfffffff0) == 0);
    assert((fields.rt1                               & 0xfffffff0) == 0);
    assert((fields.rt2                               & 0xfffffff0) == 0);
    assert((fields.rt3                               & 0xfffffff0) == 0);
    assert((fields.rt4                               & 0xfffffff0) == 0);
    assert((fields.rt5                               & 0xfffffff0) == 0);
    assert((fields.rt6                               & 0xfffffff0) == 0);
    assert((fields.rt7                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880d,
        .value =
            (fields.rt0                               <<  0) |
            (fields.rt1                               <<  4) |
            (fields.rt2                               <<  8) |
            (fields.rt3                               << 12) |
            (fields.rt4                               << 16) |
            (fields.rt5                               << 20) |
            (fields.rt6                               << 24) |
            (fields.rt7                               << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_OUTPUT_MASK(...) pack_A6XX_RB_PS_OUTPUT_MASK(__struct_cast(A6XX_RB_PS_OUTPUT_MASK) { __VA_ARGS__ })

struct A6XX_RB_DITHER_CNTL {
    enum adreno_rb_dither_mode					dither_mode_mrt0;
    enum adreno_rb_dither_mode					dither_mode_mrt1;
    enum adreno_rb_dither_mode					dither_mode_mrt2;
    enum adreno_rb_dither_mode					dither_mode_mrt3;
    enum adreno_rb_dither_mode					dither_mode_mrt4;
    enum adreno_rb_dither_mode					dither_mode_mrt5;
    enum adreno_rb_dither_mode					dither_mode_mrt6;
    enum adreno_rb_dither_mode					dither_mode_mrt7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DITHER_CNTL(struct A6XX_RB_DITHER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.dither_mode_mrt0                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt1                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt2                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt3                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt4                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt5                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt6                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt7                  & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880e,
        .value =
            (fields.dither_mode_mrt0                  <<  0) |
            (fields.dither_mode_mrt1                  <<  2) |
            (fields.dither_mode_mrt2                  <<  4) |
            (fields.dither_mode_mrt3                  <<  6) |
            (fields.dither_mode_mrt4                  <<  8) |
            (fields.dither_mode_mrt5                  << 10) |
            (fields.dither_mode_mrt6                  << 12) |
            (fields.dither_mode_mrt7                  << 14) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DITHER_CNTL(...) pack_A6XX_RB_DITHER_CNTL(__struct_cast(A6XX_RB_DITHER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_SRGB_CNTL {
    bool							srgb_mrt0;
    bool							srgb_mrt1;
    bool							srgb_mrt2;
    bool							srgb_mrt3;
    bool							srgb_mrt4;
    bool							srgb_mrt5;
    bool							srgb_mrt6;
    bool							srgb_mrt7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_SRGB_CNTL(struct A6XX_RB_SRGB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880f,
        .value =
            (fields.srgb_mrt0                         <<  0) |
            (fields.srgb_mrt1                         <<  1) |
            (fields.srgb_mrt2                         <<  2) |
            (fields.srgb_mrt3                         <<  3) |
            (fields.srgb_mrt4                         <<  4) |
            (fields.srgb_mrt5                         <<  5) |
            (fields.srgb_mrt6                         <<  6) |
            (fields.srgb_mrt7                         <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SRGB_CNTL(...) pack_A6XX_RB_SRGB_CNTL(__struct_cast(A6XX_RB_SRGB_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_SAMPLEFREQ_CNTL {
    bool							per_samp_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PS_SAMPLEFREQ_CNTL(struct A6XX_RB_PS_SAMPLEFREQ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008810,
        .value =
            (fields.per_samp_mode                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_SAMPLEFREQ_CNTL(...) pack_A6XX_RB_PS_SAMPLEFREQ_CNTL(__struct_cast(A6XX_RB_PS_SAMPLEFREQ_CNTL) { __VA_ARGS__ })

struct A6XX_RB_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MODE_CNTL(struct A6XX_RB_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008811,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MODE_CNTL(...) pack_A6XX_RB_MODE_CNTL(__struct_cast(A6XX_RB_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_BUFFER_CNTL {
    bool							z_sysmem;
    bool							s_sysmem;
    bool							rt0_sysmem;
    bool							rt1_sysmem;
    bool							rt2_sysmem;
    bool							rt3_sysmem;
    bool							rt4_sysmem;
    bool							rt5_sysmem;
    bool							rt6_sysmem;
    bool							rt7_sysmem;
    bool							z_full_in_gmem;
    bool							s_full_in_gmem;
    bool							rt0_full_in_gmem;
    bool							rt1_full_in_gmem;
    bool							rt2_full_in_gmem;
    bool							rt3_full_in_gmem;
    bool							rt4_full_in_gmem;
    bool							rt5_full_in_gmem;
    bool							rt6_full_in_gmem;
    bool							rt7_full_in_gmem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_BUFFER_CNTL(...) pack_A7XX_RB_BUFFER_CNTL(__struct_cast(A7XX_RB_BUFFER_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CR_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_CR_CNTL(...) pack_A8XX_RB_RESOLVE_CR_CNTL(__struct_cast(A8XX_RB_RESOLVE_CR_CNTL) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8818 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8818(struct A6XX_RB_UNKNOWN_8818 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008818,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8818(...) pack_A6XX_RB_UNKNOWN_8818(__struct_cast(A6XX_RB_UNKNOWN_8818) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8819 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8819(struct A6XX_RB_UNKNOWN_8819 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008819,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8819(...) pack_A6XX_RB_UNKNOWN_8819(__struct_cast(A6XX_RB_UNKNOWN_8819) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881A {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881A(struct A6XX_RB_UNKNOWN_881A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881A(...) pack_A6XX_RB_UNKNOWN_881A(__struct_cast(A6XX_RB_UNKNOWN_881A) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881B {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881B(struct A6XX_RB_UNKNOWN_881B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881B(...) pack_A6XX_RB_UNKNOWN_881B(__struct_cast(A6XX_RB_UNKNOWN_881B) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881C {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881C(struct A6XX_RB_UNKNOWN_881C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881C(...) pack_A6XX_RB_UNKNOWN_881C(__struct_cast(A6XX_RB_UNKNOWN_881C) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881D {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881D(struct A6XX_RB_UNKNOWN_881D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881D(...) pack_A6XX_RB_UNKNOWN_881D(__struct_cast(A6XX_RB_UNKNOWN_881D) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881E {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881E(struct A6XX_RB_UNKNOWN_881E fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881E(...) pack_A6XX_RB_UNKNOWN_881E(__struct_cast(A6XX_RB_UNKNOWN_881E) { __VA_ARGS__ })

struct A8XX_RB_PS_CNTL {
    bool							pixlodenable;
    bool							lodpixmask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_PS_CNTL(...) pack_A8XX_RB_PS_CNTL(__struct_cast(A8XX_RB_PS_CNTL) { __VA_ARGS__ })

struct A6XX_RB_MRT_CONTROL {
    bool							color_blend_en;
    bool							alpha_blend_en;
    bool							rop_enable;
    enum a3xx_rop_code						rop_code;
    uint32_t							component_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_CONTROL(uint32_t __i, struct A6XX_RB_MRT_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.rop_code                          & 0xfffffff0) == 0);
    assert((fields.component_enable                  & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008820 + 0x8*__i),
        .value =
            (fields.color_blend_en                    <<  0) |
            (fields.alpha_blend_en                    <<  1) |
            (fields.rop_enable                        <<  2) |
            (fields.rop_code                          <<  3) |
            (fields.component_enable                  <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_CONTROL(__i, ...) pack_A6XX_RB_MRT_CONTROL(__i, __struct_cast(A6XX_RB_MRT_CONTROL) { __VA_ARGS__ })

struct A6XX_RB_MRT_BLEND_CONTROL {
    enum adreno_rb_blend_factor					rgb_src_factor;
    enum a3xx_rb_blend_opcode					rgb_blend_opcode;
    enum adreno_rb_blend_factor					rgb_dest_factor;
    enum adreno_rb_blend_factor					alpha_src_factor;
    enum a3xx_rb_blend_opcode					alpha_blend_opcode;
    enum adreno_rb_blend_factor					alpha_dest_factor;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_BLEND_CONTROL(uint32_t __i, struct A6XX_RB_MRT_BLEND_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.rgb_src_factor                    & 0xffffffe0) == 0);
    assert((fields.rgb_blend_opcode                  & 0xfffffff8) == 0);
    assert((fields.rgb_dest_factor                   & 0xffffffe0) == 0);
    assert((fields.alpha_src_factor                  & 0xffffffe0) == 0);
    assert((fields.alpha_blend_opcode                & 0xfffffff8) == 0);
    assert((fields.alpha_dest_factor                 & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x1fff1fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008821 + 0x8*__i),
        .value =
            (fields.rgb_src_factor                    <<  0) |
            (fields.rgb_blend_opcode                  <<  5) |
            (fields.rgb_dest_factor                   <<  8) |
            (fields.alpha_src_factor                  << 16) |
            (fields.alpha_blend_opcode                << 21) |
            (fields.alpha_dest_factor                 << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_BLEND_CONTROL(__i, ...) pack_A6XX_RB_MRT_BLEND_CONTROL(__i, __struct_cast(A6XX_RB_MRT_BLEND_CONTROL) { __VA_ARGS__ })

struct A6XX_RB_MRT_BUF_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						color_tile_mode;
    uint32_t							unk10;
    enum a3xx_color_swap					color_swap;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_MRT_BUF_INFO(__i, ...) pack_A6XX_RB_MRT_BUF_INFO(__i, __struct_cast(A6XX_RB_MRT_BUF_INFO) { __VA_ARGS__ })

struct A7XX_RB_MRT_BUF_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						color_tile_mode;
    uint32_t							unk10;
    bool							losslesscompen;
    enum a3xx_color_swap					color_swap;
    bool							mutableen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_MRT_BUF_INFO(__i, ...) pack_A7XX_RB_MRT_BUF_INFO(__i, __struct_cast(A7XX_RB_MRT_BUF_INFO) { __VA_ARGS__ })

struct A6XX_RB_MRT_PITCH {
    uint32_t							rb_mrt_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_PITCH(uint32_t __i, struct A6XX_RB_MRT_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_mrt_pitch >> 6)               & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008823 + 0x8*__i),
        .value =
            ((fields.rb_mrt_pitch >> 6)               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_PITCH(__i, ...) pack_A6XX_RB_MRT_PITCH(__i, __struct_cast(A6XX_RB_MRT_PITCH) { __VA_ARGS__ })

struct A6XX_RB_MRT_ARRAY_PITCH {
    uint32_t							rb_mrt_array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_ARRAY_PITCH(uint32_t __i, struct A6XX_RB_MRT_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_mrt_array_pitch >> 6)         & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008824 + 0x8*__i),
        .value =
            ((fields.rb_mrt_array_pitch >> 6)         <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_ARRAY_PITCH(__i, ...) pack_A6XX_RB_MRT_ARRAY_PITCH(__i, __struct_cast(A6XX_RB_MRT_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_MRT_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_BASE(uint32_t __i, struct A6XX_RB_MRT_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008825 + 0x8*__i),
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_MRT_BASE(__i, ...) pack_A6XX_RB_MRT_BASE(__i, __struct_cast(A6XX_RB_MRT_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_MRT_BASE_GMEM {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_MRT_BASE_GMEM(uint32_t __i, struct A6XX_RB_MRT_BASE_GMEM fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008827 + 0x8*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_BASE_GMEM(__i, ...) pack_A6XX_RB_MRT_BASE_GMEM(__i, __struct_cast(A6XX_RB_MRT_BASE_GMEM) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_RED_FP32 {
    float							rb_blend_constant_red_fp32;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_RED_FP32(struct A6XX_RB_BLEND_CONSTANT_RED_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_red_fp32)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008860,
        .value =
            (fui(fields.rb_blend_constant_red_fp32)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_RED_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_RED_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_RED_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_GREEN_FP32 {
    float							rb_blend_constant_green_fp32;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_GREEN_FP32(struct A6XX_RB_BLEND_CONSTANT_GREEN_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_green_fp32) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008861,
        .value =
            (fui(fields.rb_blend_constant_green_fp32) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_GREEN_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_GREEN_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_GREEN_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_BLUE_FP32 {
    float							rb_blend_constant_blue_fp32;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_BLUE_FP32(struct A6XX_RB_BLEND_CONSTANT_BLUE_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_blue_fp32)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008862,
        .value =
            (fui(fields.rb_blend_constant_blue_fp32)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_BLUE_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_BLUE_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_BLUE_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_ALPHA_FP32 {
    float							rb_blend_constant_alpha_fp32;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(struct A6XX_RB_BLEND_CONSTANT_ALPHA_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_alpha_fp32) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008863,
        .value =
            (fui(fields.rb_blend_constant_alpha_fp32) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_ALPHA_FP32) { __VA_ARGS__ })

struct A6XX_RB_ALPHA_TEST_CNTL {
    uint32_t							alpha_ref;
    bool							alpha_test;
    enum adreno_compare_func					alpha_test_func;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_ALPHA_TEST_CNTL(struct A6XX_RB_ALPHA_TEST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.alpha_ref                         & 0xffffff00) == 0);
    assert((fields.alpha_test_func                   & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008864,
        .value =
            (fields.alpha_ref                         <<  0) |
            (fields.alpha_test                        <<  8) |
            (fields.alpha_test_func                   <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_ALPHA_TEST_CNTL(...) pack_A6XX_RB_ALPHA_TEST_CNTL(__struct_cast(A6XX_RB_ALPHA_TEST_CNTL) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CNTL {
    uint32_t							blend_reads_dest;
    bool							independent_blend;
    bool							dual_color_in_enable;
    bool							alpha_to_coverage;
    bool							alpha_to_one;
    uint32_t							sample_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CNTL(struct A6XX_RB_BLEND_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.blend_reads_dest                  & 0xffffff00) == 0);
    assert((fields.sample_mask                       & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008865,
        .value =
            (fields.blend_reads_dest                  <<  0) |
            (fields.independent_blend                 <<  8) |
            (fields.dual_color_in_enable              <<  9) |
            (fields.alpha_to_coverage                 << 10) |
            (fields.alpha_to_one                      << 11) |
            (fields.sample_mask                       << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CNTL(...) pack_A6XX_RB_BLEND_CNTL(__struct_cast(A6XX_RB_BLEND_CNTL) { __VA_ARGS__ })

struct A8XX_RB_LB_PARAM_LIMIT {
    uint32_t							primallocthreshold;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_LB_PARAM_LIMIT(...) pack_A8XX_RB_LB_PARAM_LIMIT(__struct_cast(A8XX_RB_LB_PARAM_LIMIT) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_PLANE_CNTL(struct A6XX_RB_DEPTH_PLANE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.z_mode                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008870,
        .value =
            (fields.z_mode                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_PLANE_CNTL(...) pack_A6XX_RB_DEPTH_PLANE_CNTL(__struct_cast(A6XX_RB_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_CNTL {
    bool							z_test_enable;
    bool							z_write_enable;
    enum adreno_compare_func					zfunc;
    bool							z_clamp_enable;
    bool							z_read_enable;
    bool							z_bounds_enable;
    bool							o_depth_01_clamp_en;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_CNTL(struct A6XX_RB_DEPTH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.zfunc                             & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008871,
        .value =
            (fields.z_test_enable                     <<  0) |
            (fields.z_write_enable                    <<  1) |
            (fields.zfunc                             <<  2) |
            (fields.z_clamp_enable                    <<  5) |
            (fields.z_read_enable                     <<  6) |
            (fields.z_bounds_enable                   <<  7) |
            (fields.o_depth_01_clamp_en               <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_CNTL(...) pack_A6XX_RB_DEPTH_CNTL(__struct_cast(A6XX_RB_DEPTH_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_DEPTH_BUFFER_INFO(...) pack_A6XX_RB_DEPTH_BUFFER_INFO(__struct_cast(A6XX_RB_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_RB_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    bool							read_only;
    uint32_t							prt;
    enum a6xx_tile_mode						tilemode;
    bool							losslesscompen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_DEPTH_BUFFER_INFO(...) pack_A7XX_RB_DEPTH_BUFFER_INFO(__struct_cast(A7XX_RB_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_PITCH {
    uint32_t							rb_depth_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_PITCH(struct A6XX_RB_DEPTH_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_depth_buffer_pitch >> 6)      & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x00003fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008873,
        .value =
            ((fields.rb_depth_buffer_pitch >> 6)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BUFFER_PITCH(...) pack_A6XX_RB_DEPTH_BUFFER_PITCH(__struct_cast(A6XX_RB_DEPTH_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH {
    uint32_t							rb_depth_buffer_array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(struct A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_depth_buffer_array_pitch >> 6) & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008874,
        .value =
            ((fields.rb_depth_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_BASE(struct A6XX_RB_DEPTH_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008875,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_DEPTH_BUFFER_BASE(...) pack_A6XX_RB_DEPTH_BUFFER_BASE(__struct_cast(A6XX_RB_DEPTH_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_DEPTH_GMEM_BASE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_GMEM_BASE(struct A6XX_RB_DEPTH_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008877,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_GMEM_BASE(...) pack_A6XX_RB_DEPTH_GMEM_BASE(__struct_cast(A6XX_RB_DEPTH_GMEM_BASE) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BOUND_MIN {
    float							rb_depth_bound_min;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BOUND_MIN(struct A6XX_RB_DEPTH_BOUND_MIN fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_depth_bound_min)           & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008878,
        .value =
            (fui(fields.rb_depth_bound_min)           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BOUND_MIN(...) pack_A6XX_RB_DEPTH_BOUND_MIN(__struct_cast(A6XX_RB_DEPTH_BOUND_MIN) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BOUND_MAX {
    float							rb_depth_bound_max;
    uint32_t							dword;
    uint32_t							unknown;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BOUND_MAX(struct A6XX_RB_DEPTH_BOUND_MAX fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_depth_bound_max)           & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008879,
        .value =
            (fui(fields.rb_depth_bound_max)           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BOUND_MAX(...) pack_A6XX_RB_DEPTH_BOUND_MAX(__struct_cast(A6XX_RB_DEPTH_BOUND_MAX) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_CNTL {
    bool							stencil_enable;
    bool							stencil_enable_bf;
    bool							stencil_read;
    enum adreno_compare_func					func;
    enum adreno_stencil_op					fail;
    enum adreno_stencil_op					zpass;
    enum adreno_stencil_op					zfail;
    enum adreno_compare_func					func_bf;
    enum adreno_stencil_op					fail_bf;
    enum adreno_stencil_op					zpass_bf;
    enum adreno_stencil_op					zfail_bf;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_CNTL(struct A6XX_RB_STENCIL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.func                              & 0xfffffff8) == 0);
    assert((fields.fail                              & 0xfffffff8) == 0);
    assert((fields.zpass                             & 0xfffffff8) == 0);
    assert((fields.zfail                             & 0xfffffff8) == 0);
    assert((fields.func_bf                           & 0xfffffff8) == 0);
    assert((fields.fail_bf                           & 0xfffffff8) == 0);
    assert((fields.zpass_bf                          & 0xfffffff8) == 0);
    assert((fields.zfail_bf                          & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0xffffff07) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008880,
        .value =
            (fields.stencil_enable                    <<  0) |
            (fields.stencil_enable_bf                 <<  1) |
            (fields.stencil_read                      <<  2) |
            (fields.func                              <<  8) |
            (fields.fail                              << 11) |
            (fields.zpass                             << 14) |
            (fields.zfail                             << 17) |
            (fields.func_bf                           << 20) |
            (fields.fail_bf                           << 23) |
            (fields.zpass_bf                          << 26) |
            (fields.zfail_bf                          << 29) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_CNTL(...) pack_A6XX_RB_STENCIL_CNTL(__struct_cast(A6XX_RB_STENCIL_CNTL) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_INFO {
    bool							separate_stencil;
    bool							unk1;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_STENCIL_BUFFER_INFO(...) pack_A6XX_RB_STENCIL_BUFFER_INFO(__struct_cast(A6XX_RB_STENCIL_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_RB_STENCIL_BUFFER_INFO {
    bool							separate_stencil;
    bool							unk1;
    enum a6xx_tile_mode						tilemode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_STENCIL_BUFFER_INFO(...) pack_A7XX_RB_STENCIL_BUFFER_INFO(__struct_cast(A7XX_RB_STENCIL_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_PITCH {
    uint32_t							rb_stencil_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_PITCH(struct A6XX_RB_STENCIL_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_stencil_buffer_pitch >> 6)    & 0xfffff000) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008882,
        .value =
            ((fields.rb_stencil_buffer_pitch >> 6)    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_BUFFER_PITCH(...) pack_A6XX_RB_STENCIL_BUFFER_PITCH(__struct_cast(A6XX_RB_STENCIL_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH {
    uint32_t							rb_stencil_buffer_array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(struct A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_stencil_buffer_array_pitch >> 6) & 0xff000000) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008883,
        .value =
            ((fields.rb_stencil_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_BASE(struct A6XX_RB_STENCIL_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008884,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_STENCIL_BUFFER_BASE(...) pack_A6XX_RB_STENCIL_BUFFER_BASE(__struct_cast(A6XX_RB_STENCIL_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_STENCIL_GMEM_BASE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_GMEM_BASE(struct A6XX_RB_STENCIL_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008886,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_GMEM_BASE(...) pack_A6XX_RB_STENCIL_GMEM_BASE(__struct_cast(A6XX_RB_STENCIL_GMEM_BASE) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_REF_CNTL {
    uint32_t							ref;
    uint32_t							bfref;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_REF_CNTL(struct A6XX_RB_STENCIL_REF_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.ref                               & 0xffffff00) == 0);
    assert((fields.bfref                             & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008887,
        .value =
            (fields.ref                               <<  0) |
            (fields.bfref                             <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_REF_CNTL(...) pack_A6XX_RB_STENCIL_REF_CNTL(__struct_cast(A6XX_RB_STENCIL_REF_CNTL) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_MASK {
    uint32_t							mask;
    uint32_t							bfmask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_MASK(struct A6XX_RB_STENCIL_MASK fields)
{
#ifndef NDEBUG
    assert((fields.mask                              & 0xffffff00) == 0);
    assert((fields.bfmask                            & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008888,
        .value =
            (fields.mask                              <<  0) |
            (fields.bfmask                            <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_MASK(...) pack_A6XX_RB_STENCIL_MASK(__struct_cast(A6XX_RB_STENCIL_MASK) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_WRITE_MASK {
    uint32_t							wrmask;
    uint32_t							bfwrmask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_WRITE_MASK(struct A6XX_RB_STENCIL_WRITE_MASK fields)
{
#ifndef NDEBUG
    assert((fields.wrmask                            & 0xffffff00) == 0);
    assert((fields.bfwrmask                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008889,
        .value =
            (fields.wrmask                            <<  0) |
            (fields.bfwrmask                          <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_WRITE_MASK(...) pack_A6XX_RB_STENCIL_WRITE_MASK(__struct_cast(A6XX_RB_STENCIL_WRITE_MASK) { __VA_ARGS__ })

struct A6XX_RB_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_WINDOW_OFFSET(struct A6XX_RB_WINDOW_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008890,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_WINDOW_OFFSET(...) pack_A6XX_RB_WINDOW_OFFSET(__struct_cast(A6XX_RB_WINDOW_OFFSET) { __VA_ARGS__ })

struct A6XX_RB_SAMPLE_COUNTER_CNTL {
    bool							disable;
    bool							copy;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_SAMPLE_COUNTER_CNTL(struct A6XX_RB_SAMPLE_COUNTER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008891,
        .value =
            (fields.disable                           <<  0) |
            (fields.copy                              <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SAMPLE_COUNTER_CNTL(...) pack_A6XX_RB_SAMPLE_COUNTER_CNTL(__struct_cast(A6XX_RB_SAMPLE_COUNTER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_LRZ_CNTL {
    bool							enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_LRZ_CNTL(struct A6XX_RB_LRZ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008898,
        .value =
            (fields.enable                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_LRZ_CNTL(...) pack_A6XX_RB_LRZ_CNTL(__struct_cast(A6XX_RB_LRZ_CNTL) { __VA_ARGS__ })

struct A7XX_RB_LRZ_CNTL2 {
    bool							enable_bidirectional_lrz;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_LRZ_CNTL2(...) pack_A7XX_RB_LRZ_CNTL2(__struct_cast(A7XX_RB_LRZ_CNTL2) { __VA_ARGS__ })

struct A6XX_RB_VIEWPORT_ZCLAMP_MIN {
    float							rb_viewport_zclamp_min;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_VIEWPORT_ZCLAMP_MIN(...) pack_A6XX_RB_VIEWPORT_ZCLAMP_MIN(__struct_cast(A6XX_RB_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A6XX_RB_VIEWPORT_ZCLAMP_MAX {
    float							rb_viewport_zclamp_max;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_VIEWPORT_ZCLAMP_MAX(...) pack_A6XX_RB_VIEWPORT_ZCLAMP_MAX(__struct_cast(A6XX_RB_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG {
    float							rb_viewport_zclamp_min_reg;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(__i, ...) pack_A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(__i, __struct_cast(A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG) { __VA_ARGS__ })

struct A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG {
    float							rb_viewport_zclamp_max_reg;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(__i, ...) pack_A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(__i, __struct_cast(A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_0 {
    uint32_t							unk0;
    uint32_t							unk16;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_0(struct A6XX_RB_RESOLVE_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xffffe000) == 0);
    assert((fields.unk16                             & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x07ff1fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d0,
        .value =
            (fields.unk0                              <<  0) |
            (fields.unk16                             << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_0(...) pack_A6XX_RB_RESOLVE_CNTL_0(__struct_cast(A6XX_RB_RESOLVE_CNTL_0) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_1 {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_1(struct A6XX_RB_RESOLVE_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d1,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_1(...) pack_A6XX_RB_RESOLVE_CNTL_1(__struct_cast(A6XX_RB_RESOLVE_CNTL_1) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_2 {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_2(struct A6XX_RB_RESOLVE_CNTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d2,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_2(...) pack_A6XX_RB_RESOLVE_CNTL_2(__struct_cast(A6XX_RB_RESOLVE_CNTL_2) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_3 {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_RESOLVE_CNTL_3(...) pack_A6XX_RB_RESOLVE_CNTL_3(__struct_cast(A6XX_RB_RESOLVE_CNTL_3) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CNTL_3 {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_CNTL_3(...) pack_A8XX_RB_RESOLVE_CNTL_3(__struct_cast(A8XX_RB_RESOLVE_CNTL_3) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CNTL_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_CNTL_4(...) pack_A8XX_RB_RESOLVE_CNTL_4(__struct_cast(A8XX_RB_RESOLVE_CNTL_4) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CNTL_5 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_CNTL_5(...) pack_A8XX_RB_RESOLVE_CNTL_5(__struct_cast(A8XX_RB_RESOLVE_CNTL_5) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_WINDOW_OFFSET(struct A6XX_RB_RESOLVE_WINDOW_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d4,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_WINDOW_OFFSET(...) pack_A6XX_RB_RESOLVE_WINDOW_OFFSET(__struct_cast(A6XX_RB_RESOLVE_WINDOW_OFFSET) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_GMEM_BUFFER_INFO {
    enum a3xx_msaa_samples					samples;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(struct A6XX_RB_RESOLVE_GMEM_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000018) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d5,
        .value =
            (fields.samples                           <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(...) pack_A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(__struct_cast(A6XX_RB_RESOLVE_GMEM_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_GMEM_BUFFER_BASE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(struct A6XX_RB_RESOLVE_GMEM_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_GMEM_BUFFER_BASE) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO {
    enum a6xx_tile_mode						tile_mode;
    bool							flags;
    enum a3xx_msaa_samples					samples;
    enum a3xx_color_swap					color_swap;
    enum a6xx_format						color_format;
    bool							unk15;
    bool							mutableen;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0001ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d7,
        .value =
            (fields.tile_mode                         <<  0) |
            (fields.flags                             <<  2) |
            (fields.samples                           <<  3) |
            (fields.color_swap                        <<  5) |
            (fields.color_format                      <<  7) |
            (fields.unk15                             << 15) |
            (fields.mutableen                         << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d8,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH {
    uint32_t							rb_resolve_system_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_resolve_system_buffer_pitch >> 6) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088da,
        .value =
            ((fields.rb_resolve_system_buffer_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH {
    uint32_t							rb_resolve_system_buffer_array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_resolve_system_buffer_array_pitch >> 6) & 0xe0000000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088db,
        .value =
            ((fields.rb_resolve_system_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088dc,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088de,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088df,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW0) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW1) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW2) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW3) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_OPERATION {
    enum a6xx_blit_event_type					type;
    bool							sample_0;
    bool							depth;
    uint32_t							clear_mask;
    uint32_t							last;
    uint32_t							buffer_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_OPERATION(struct A6XX_RB_RESOLVE_OPERATION fields)
{
#ifndef NDEBUG
    assert((fields.type                              & 0xfffffffc) == 0);
    assert((fields.clear_mask                        & 0xfffffff0) == 0);
    assert((fields.last                              & 0xfffffffc) == 0);
    assert((fields.buffer_id                         & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000f3ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e3,
        .value =
            (fields.type                              <<  0) |
            (fields.sample_0                          <<  2) |
            (fields.depth                             <<  3) |
            (fields.clear_mask                        <<  4) |
            (fields.last                              <<  8) |
            (fields.buffer_id                         << 12) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_OPERATION(...) pack_A6XX_RB_RESOLVE_OPERATION(__struct_cast(A6XX_RB_RESOLVE_OPERATION) { __VA_ARGS__ })

struct A7XX_RB_CLEAR_TARGET {
    enum a7xx_blit_clear_mode					clear_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_CLEAR_TARGET(...) pack_A7XX_RB_CLEAR_TARGET(__struct_cast(A7XX_RB_CLEAR_TARGET) { __VA_ARGS__ })

struct A7XX_RB_CCU_CACHE_CNTL {
    uint32_t							depth_offset_hi;
    uint32_t							color_offset_hi;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							color_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_CCU_CACHE_CNTL(...) pack_A7XX_RB_CCU_CACHE_CNTL(__struct_cast(A7XX_RB_CCU_CACHE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CCU_CACHE_CNTL {
    uint32_t							color_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_CCU_CACHE_CNTL(...) pack_A8XX_RB_CCU_CACHE_CNTL(__struct_cast(A8XX_RB_CCU_CACHE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL {
    bool							full_in_gmem;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL(...) pack_A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL(__struct_cast(A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_88F0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNKNOWN_88F0(...) pack_A6XX_RB_UNKNOWN_88F0(__struct_cast(A6XX_RB_UNKNOWN_88F0) { __VA_ARGS__ })

struct A6XX_RB_UNK_FLAG_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_RB_UNK_FLAG_BUFFER_BASE(...) pack_A6XX_RB_UNK_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_UNK_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_UNK_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNK_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_UNK_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_UNK_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_VRS_CONFIG {
    bool							unk2;
    bool							pipeline_fsr_enable;
    bool							attachment_fsr_enable;
    bool							primitive_fsr_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_VRS_CONFIG(struct A6XX_RB_VRS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00040034) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f4,
        .value =
            (fields.unk2                              <<  2) |
            (fields.pipeline_fsr_enable               <<  4) |
            (fields.attachment_fsr_enable             <<  5) |
            (fields.primitive_fsr_enable              << 18) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_VRS_CONFIG(...) pack_A6XX_RB_VRS_CONFIG(__struct_cast(A6XX_RB_VRS_CONFIG) { __VA_ARGS__ })

struct A7XX_RB_BIN_FOVEAT {
    bool							binscaleen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_BIN_FOVEAT(...) pack_A7XX_RB_BIN_FOVEAT(__struct_cast(A7XX_RB_BIN_FOVEAT) { __VA_ARGS__ })

struct A8XX_RB_BIN_FOVEAT_XY_OFFSET {
    uint32_t							xoffset;
    uint32_t							yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_BIN_FOVEAT_XY_OFFSET(__i, ...) pack_A8XX_RB_BIN_FOVEAT_XY_OFFSET(__i, __struct_cast(A8XX_RB_BIN_FOVEAT_XY_OFFSET) { __VA_ARGS__ })

struct A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET {
    uint32_t							xoffset;
    uint32_t							yoffset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET(__i, ...) pack_A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET(__i, __struct_cast(A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_FLAG_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_FLAG_BUFFER_BASE(struct A6XX_RB_DEPTH_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008900,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_DEPTH_FLAG_BUFFER_BASE(...) pack_A6XX_RB_DEPTH_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_DEPTH_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_DEPTH_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							unk8;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(struct A6XX_RB_DEPTH_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xffffff80) == 0);
    assert((fields.unk8                              & 0xfffffff8) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x0fffff7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008902,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            (fields.unk8                              <<  8) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_DEPTH_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_COLOR_FLAG_BUFFER_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_COLOR_FLAG_BUFFER_ADDR(uint32_t __i, struct A6XX_RB_COLOR_FLAG_BUFFER_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008903 + 0x3*__i),
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_COLOR_FLAG_BUFFER_ADDR(__i, ...) pack_A6XX_RB_COLOR_FLAG_BUFFER_ADDR(__i, __struct_cast(A6XX_RB_COLOR_FLAG_BUFFER_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_COLOR_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_COLOR_FLAG_BUFFER_PITCH(uint32_t __i, struct A6XX_RB_COLOR_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008905 + 0x3*__i),
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH(__i, ...) pack_A6XX_RB_COLOR_FLAG_BUFFER_PITCH(__i, __struct_cast(A6XX_RB_COLOR_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_SAMPLE_COUNTER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_SAMPLE_COUNTER_BASE(struct A6XX_RB_SAMPLE_COUNTER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008927,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_SAMPLE_COUNTER_BASE(...) pack_A6XX_RB_SAMPLE_COUNTER_BASE(__struct_cast(A6XX_RB_SAMPLE_COUNTER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_RB_DEPTH_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_DEPTH_GMEM_DIMENSION(...) pack_A8XX_RB_DEPTH_GMEM_DIMENSION(__struct_cast(A8XX_RB_DEPTH_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_STENCIL_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_STENCIL_GMEM_DIMENSION(...) pack_A8XX_RB_STENCIL_GMEM_DIMENSION(__struct_cast(A8XX_RB_STENCIL_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_GMEM_DIMENSION(...) pack_A8XX_RB_RESOLVE_GMEM_DIMENSION(__struct_cast(A8XX_RB_RESOLVE_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_MRT_GMEM_DIMENSION_REG {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_MRT_GMEM_DIMENSION_REG(__i, ...) pack_A8XX_RB_MRT_GMEM_DIMENSION_REG(__i, __struct_cast(A8XX_RB_MRT_GMEM_DIMENSION_REG) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A00 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNKNOWN_8A00(...) pack_A6XX_RB_UNKNOWN_8A00(__struct_cast(A6XX_RB_UNKNOWN_8A00) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A10 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNKNOWN_8A10(...) pack_A6XX_RB_UNKNOWN_8A10(__struct_cast(A6XX_RB_UNKNOWN_8A10) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A20 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNKNOWN_8A20(...) pack_A6XX_RB_UNKNOWN_8A20(__struct_cast(A6XX_RB_UNKNOWN_8A20) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A30 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_UNKNOWN_8A30(...) pack_A6XX_RB_UNKNOWN_8A30(__struct_cast(A6XX_RB_UNKNOWN_8A30) { __VA_ARGS__ })

struct A6XX_RB_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_BLT_CNTL(struct A6XX_RB_A2D_BLT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rotate                            & 0xfffffff8) == 0);
    assert((fields.unk4                              & 0xfffffff8) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unk17                             & 0xfffffffc) == 0);
    assert((fields.mask                              & 0xfffffff0) == 0);
    assert((fields.ifmt                              & 0xfffffff8) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x7fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c00,
        .value =
            (fields.rotate                            <<  0) |
            (fields.overwriteen                       <<  3) |
            (fields.unk4                              <<  4) |
            (fields.solid_color                       <<  7) |
            (fields.color_format                      <<  8) |
            (fields.scissor                           << 16) |
            (fields.unk17                             << 17) |
            (fields.d24s8                             << 19) |
            (fields.mask                              << 20) |
            (fields.ifmt                              << 24) |
            (fields.unk27                             << 27) |
            (fields.unk28                             << 28) |
            (fields.raster_mode                       << 29) |
            (fields.copy                              << 30) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_BLT_CNTL(...) pack_A6XX_RB_A2D_BLT_CNTL(__struct_cast(A6XX_RB_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_A2D_PIXEL_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_PIXEL_CNTL(struct A6XX_RB_A2D_PIXEL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_PIXEL_CNTL(...) pack_A6XX_RB_A2D_PIXEL_CNTL(__struct_cast(A6XX_RB_A2D_PIXEL_CNTL) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						tile_mode;
    enum a3xx_color_swap					color_swap;
    bool							flags;
    bool							srgb;
    enum a3xx_msaa_samples					samples;
    bool							mutableen;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_INFO(struct A6XX_RB_A2D_DEST_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0002ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c17,
        .value =
            (fields.color_format                      <<  0) |
            (fields.tile_mode                         <<  8) |
            (fields.color_swap                        << 10) |
            (fields.flags                             << 12) |
            (fields.srgb                              << 13) |
            (fields.samples                           << 14) |
            (fields.mutableen                         << 17) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_INFO(...) pack_A6XX_RB_A2D_DEST_BUFFER_INFO(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE(struct A6XX_RB_A2D_DEST_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c18,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_BUFFER_PITCH {
    uint32_t							rb_a2d_dest_buffer_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_PITCH(struct A6XX_RB_A2D_DEST_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_buffer_pitch >> 6)   & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1a,
        .value =
            ((fields.rb_a2d_dest_buffer_pitch >> 6)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_PITCH(...) pack_A6XX_RB_A2D_DEST_BUFFER_PITCH(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE_1 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE_1(struct A6XX_RB_A2D_DEST_BUFFER_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1b,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE_1(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE_1(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_BUFFER_PITCH_1 {
    uint32_t							rb_a2d_dest_buffer_pitch_1;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_PITCH_1(struct A6XX_RB_A2D_DEST_BUFFER_PITCH_1 fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_buffer_pitch_1 >> 6) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1d,
        .value =
            ((fields.rb_a2d_dest_buffer_pitch_1 >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_PITCH_1(...) pack_A6XX_RB_A2D_DEST_BUFFER_PITCH_1(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_PITCH_1) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE_2 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE_2(struct A6XX_RB_A2D_DEST_BUFFER_BASE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1e,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE_2(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE_2(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE_2) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c20,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c22,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c23,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1 {
    uint32_t							rb_a2d_dest_flag_buffer_pitch_1;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1 fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_flag_buffer_pitch_1 >> 6) & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c25,
        .value =
            ((fields.rb_a2d_dest_flag_buffer_pitch_1 >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW0(struct A6XX_RB_A2D_CLEAR_COLOR_DW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW0(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW0(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW0) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW1(struct A6XX_RB_A2D_CLEAR_COLOR_DW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW1(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW1(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW1) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW2(struct A6XX_RB_A2D_CLEAR_COLOR_DW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW2(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW2(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW2) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW3(struct A6XX_RB_A2D_CLEAR_COLOR_DW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW3(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW3(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW3) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8C34 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_UNKNOWN_8C34(...) pack_A7XX_RB_UNKNOWN_8C34(__struct_cast(A7XX_RB_UNKNOWN_8C34) { __VA_ARGS__ })

struct A6XX_RB_RBP_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_RBP_CNTL(struct A6XX_RB_RBP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RBP_CNTL(...) pack_A6XX_RB_RBP_CNTL(__struct_cast(A6XX_RB_RBP_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_DBG_ECO_CNTL(struct A6XX_RB_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e04,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DBG_ECO_CNTL(...) pack_A6XX_RB_DBG_ECO_CNTL(__struct_cast(A6XX_RB_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_ADDR_MODE_CNTL {
    enum a5xx_address_mode					rb_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_ADDR_MODE_CNTL(...) pack_A6XX_RB_ADDR_MODE_CNTL(__struct_cast(A6XX_RB_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_CCU_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_CCU_DBG_ECO_CNTL(...) pack_A7XX_RB_CCU_DBG_ECO_CNTL(__struct_cast(A7XX_RB_CCU_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_CCU_CNTL {
    bool							gmem_fast_clear_disable;
    bool							concurrent_resolve;
    uint32_t							depth_offset_hi;
    uint32_t							color_offset_hi;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							color_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_CCU_CNTL(...) pack_A6XX_RB_CCU_CNTL(__struct_cast(A6XX_RB_CCU_CNTL) { __VA_ARGS__ })

struct A7XX_RB_CCU_CNTL {
    bool							gmem_fast_clear_disable;
    enum a7xx_concurrent_resolve_mode				concurrent_resolve_mode;
    enum a7xx_concurrent_unresolve_mode				concurrent_unresolve_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_CCU_CNTL(...) pack_A7XX_RB_CCU_CNTL(__struct_cast(A7XX_RB_CCU_CNTL) { __VA_ARGS__ })

struct A6XX_RB_NC_MODE_CNTL {
    bool							mode;
    uint32_t							lower_bit;
    bool							min_access_length;
    bool							amsbc;
    uint32_t							upper_bit;
    bool							rgb565_predicator;
    uint32_t							unk12;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_NC_MODE_CNTL(...) pack_A6XX_RB_NC_MODE_CNTL(__struct_cast(A6XX_RB_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CCU_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_CCU_NC_MODE_CNTL(...) pack_A8XX_RB_CCU_NC_MODE_CNTL(__struct_cast(A8XX_RB_CCU_NC_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8E09 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_UNKNOWN_8E09(...) pack_A7XX_RB_UNKNOWN_8E09(__struct_cast(A7XX_RB_UNKNOWN_8E09) { __VA_ARGS__ })

struct A8XX_RB_GC_GMEM_PROTECT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_GC_GMEM_PROTECT(...) pack_A8XX_RB_GC_GMEM_PROTECT(__struct_cast(A8XX_RB_GC_GMEM_PROTECT) { __VA_ARGS__ })

struct A8XX_RB_LPAC_GMEM_PROTECT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_LPAC_GMEM_PROTECT(...) pack_A8XX_RB_LPAC_GMEM_PROTECT(__struct_cast(A8XX_RB_LPAC_GMEM_PROTECT) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_RB_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PERFCTR_RB_SEL_REG(uint32_t __i, struct A6XX_RB_PERFCTR_RB_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e10 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PERFCTR_RB_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_RB_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_RB_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_CCU_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_PERFCTR_CCU_SEL_REG(uint32_t __i, struct A6XX_RB_PERFCTR_CCU_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e18 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PERFCTR_CCU_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_CCU_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_CCU_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_CMP_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_CMP_NC_MODE_CNTL(...) pack_A8XX_RB_CMP_NC_MODE_CNTL(__struct_cast(A8XX_RB_CMP_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_PREFETCH_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_RESOLVE_PREFETCH_CNTL(...) pack_A8XX_RB_RESOLVE_PREFETCH_CNTL(__struct_cast(A8XX_RB_RESOLVE_PREFETCH_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CMP_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_CMP_DBG_ECO_CNTL(...) pack_A8XX_RB_CMP_DBG_ECO_CNTL(__struct_cast(A8XX_RB_CMP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_RB_UNSLICE_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_UNSLICE_STATUS(...) pack_A8XX_RB_UNSLICE_STATUS(__struct_cast(A8XX_RB_UNSLICE_STATUS) { __VA_ARGS__ })

struct A6XX_RB_CMP_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_CMP_DBG_ECO_CNTL(...) pack_A6XX_RB_CMP_DBG_ECO_CNTL(__struct_cast(A6XX_RB_CMP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_CMP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_RB_PERFCTR_CMP_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_CMP_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_CMP_SEL_REG) { __VA_ARGS__ })

struct A7XX_RB_PERFCTR_UFC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_PERFCTR_UFC_SEL_REG(__i, ...) pack_A7XX_RB_PERFCTR_UFC_SEL_REG(__i, __struct_cast(A7XX_RB_PERFCTR_UFC_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_PERFCTR_CMP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_PERFCTR_CMP_SEL_REG(__i, ...) pack_A8XX_RB_PERFCTR_CMP_SEL_REG(__i, __struct_cast(A8XX_RB_PERFCTR_CMP_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_PERFCTR_UFC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_PERFCTR_UFC_SEL_REG(__i, ...) pack_A8XX_RB_PERFCTR_UFC_SEL_REG(__i, __struct_cast(A8XX_RB_PERFCTR_UFC_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(struct A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e3b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(...) pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(__struct_cast(A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST) { __VA_ARGS__ })

struct A6XX_RB_SUB_BLOCK_SEL_CNTL_CD {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(struct A6XX_RB_SUB_BLOCK_SEL_CNTL_CD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e3d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(...) pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(__struct_cast(A6XX_RB_SUB_BLOCK_SEL_CNTL_CD) { __VA_ARGS__ })

struct A8XX_RB_UFC_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_UFC_DBG_CNTL(...) pack_A8XX_RB_UFC_DBG_CNTL(__struct_cast(A8XX_RB_UFC_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE {
    bool							rb_context_switch_gmem_save_restore_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e50,
        .value =
            (fields.rb_context_switch_gmem_save_restore_enable <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(...) pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(__struct_cast(A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE) { __VA_ARGS__ })

struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e51,
        .value =
            fields.unknown | fields.dword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(...) pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(__struct_cast(A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_RB_SLICE_UFC_PREFETCH_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_SLICE_UFC_PREFETCH_CNTL(...) pack_A8XX_RB_SLICE_UFC_PREFETCH_CNTL(__struct_cast(A8XX_RB_SLICE_UFC_PREFETCH_CNTL) { __VA_ARGS__ })

struct A8XX_RB_SLICE_UFC_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_RB_SLICE_UFC_DBG_CNTL(...) pack_A8XX_RB_SLICE_UFC_DBG_CNTL(__struct_cast(A8XX_RB_SLICE_UFC_DBG_CNTL) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8E79 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_RB_UNKNOWN_8E79(...) pack_A7XX_RB_UNKNOWN_8E79(__struct_cast(A7XX_RB_UNKNOWN_8E79) { __VA_ARGS__ })

struct A6XX_VPC_GS_PARAM {
    uint32_t							linelengthloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_PARAM(...) pack_A6XX_VPC_GS_PARAM(__struct_cast(A6XX_VPC_GS_PARAM) { __VA_ARGS__ })

struct A6XX_VPC_VS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_VS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_VS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_GS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_GS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_DS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_DS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_VS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_VS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_GS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_GS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_GS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_DS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_DS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_VS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_VS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_GS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_GS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_GS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_DS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_DS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_DS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_VS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VS_SIV_CNTL(...) pack_A6XX_VPC_VS_SIV_CNTL(__struct_cast(A6XX_VPC_VS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_SIV_CNTL(...) pack_A6XX_VPC_GS_SIV_CNTL(__struct_cast(A6XX_VPC_GS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DS_SIV_CNTL(...) pack_A6XX_VPC_DS_SIV_CNTL(__struct_cast(A6XX_VPC_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VS_SIV_CNTL(...) pack_A8XX_VPC_VS_SIV_CNTL(__struct_cast(A8XX_VPC_VS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_GS_SIV_CNTL(...) pack_A8XX_VPC_GS_SIV_CNTL(__struct_cast(A8XX_VPC_GS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DS_SIV_CNTL(...) pack_A8XX_VPC_DS_SIV_CNTL(__struct_cast(A8XX_VPC_DS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VS_SIV_CNTL_V2(...) pack_A6XX_VPC_VS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_VS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_GS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_SIV_CNTL_V2(...) pack_A6XX_VPC_GS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_GS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_DS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DS_SIV_CNTL_V2(...) pack_A6XX_VPC_DS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_DS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_RAST_STREAM_CNTL(...) pack_A6XX_VPC_RAST_STREAM_CNTL(__struct_cast(A6XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_RAST_STREAM_CNTL(...) pack_A7XX_VPC_RAST_STREAM_CNTL(__struct_cast(A7XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_RAST_STREAM_CNTL(...) pack_A8XX_VPC_RAST_STREAM_CNTL(__struct_cast(A8XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_RAST_STREAM_CNTL_V2 {
    uint32_t							stream;
    bool							discard;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_RAST_STREAM_CNTL_V2(...) pack_A7XX_VPC_RAST_STREAM_CNTL_V2(__struct_cast(A7XX_VPC_RAST_STREAM_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9107 {
    bool							raster_discard;
    bool							unk2;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_UNKNOWN_9107(...) pack_A6XX_VPC_UNKNOWN_9107(__struct_cast(A6XX_VPC_UNKNOWN_9107) { __VA_ARGS__ })

struct A6XX_VPC_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_RAST_CNTL(...) pack_A6XX_VPC_RAST_CNTL(__struct_cast(A6XX_VPC_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_RAST_CNTL(...) pack_A8XX_VPC_RAST_CNTL(__struct_cast(A8XX_VPC_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_PC_CNTL(...) pack_A7XX_VPC_PC_CNTL(__struct_cast(A7XX_VPC_PC_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PC_CNTL(...) pack_A8XX_VPC_PC_CNTL(__struct_cast(A8XX_VPC_PC_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_GS_PARAM_0(...) pack_A7XX_VPC_GS_PARAM_0(__struct_cast(A7XX_VPC_GS_PARAM_0) { __VA_ARGS__ })

struct A8XX_VPC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_GS_PARAM_0(...) pack_A8XX_VPC_GS_PARAM_0(__struct_cast(A8XX_VPC_GS_PARAM_0) { __VA_ARGS__ })

struct A7XX_VPC_STEREO_RENDERING_VIEWMASK {
    uint32_t							vpc_stereo_rendering_viewmask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_STEREO_RENDERING_VIEWMASK(...) pack_A7XX_VPC_STEREO_RENDERING_VIEWMASK(__struct_cast(A7XX_VPC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A8XX_VPC_STEREO_RENDERING_VIEWMASK {
    uint32_t							vpc_stereo_rendering_viewmask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_STEREO_RENDERING_VIEWMASK(...) pack_A8XX_VPC_STEREO_RENDERING_VIEWMASK(__struct_cast(A8XX_VPC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A7XX_VPC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_STEREO_RENDERING_CNTL(...) pack_A7XX_VPC_STEREO_RENDERING_CNTL(__struct_cast(A7XX_VPC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_STEREO_RENDERING_CNTL(...) pack_A8XX_VPC_STEREO_RENDERING_CNTL(__struct_cast(A8XX_VPC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_INTERP_MODE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VARYING_INTERP_MODE_MODE(__i, ...) pack_A6XX_VPC_VARYING_INTERP_MODE_MODE(__i, __struct_cast(A6XX_VPC_VARYING_INTERP_MODE_MODE) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_REPLACE_MODE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VARYING_REPLACE_MODE_MODE(__i, ...) pack_A6XX_VPC_VARYING_REPLACE_MODE_MODE(__i, __struct_cast(A6XX_VPC_VARYING_REPLACE_MODE_MODE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_INTERP_MODE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VARYING_INTERP_MODE_MODE(__i, ...) pack_A8XX_VPC_VARYING_INTERP_MODE_MODE(__i, __struct_cast(A8XX_VPC_VARYING_INTERP_MODE_MODE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_REPLACE_MODE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VARYING_REPLACE_MODE_MODE(__i, ...) pack_A8XX_VPC_VARYING_REPLACE_MODE_MODE(__i, __struct_cast(A8XX_VPC_VARYING_REPLACE_MODE_MODE) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9210 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_UNKNOWN_9210(...) pack_A6XX_VPC_UNKNOWN_9210(__struct_cast(A6XX_VPC_UNKNOWN_9210) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9211 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_UNKNOWN_9211(...) pack_A6XX_VPC_UNKNOWN_9211(__struct_cast(A6XX_VPC_UNKNOWN_9211) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, ...) pack_A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, __struct_cast(A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, ...) pack_A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, __struct_cast(A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE) { __VA_ARGS__ })

struct A6XX_VPC_SO_MAPPING_WPTR {
    uint32_t							addr;
    bool							reset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_MAPPING_WPTR(...) pack_A6XX_VPC_SO_MAPPING_WPTR(__struct_cast(A6XX_VPC_SO_MAPPING_WPTR) { __VA_ARGS__ })

struct A8XX_VPC_SO_MAPPING_WPTR {
    uint32_t							addr;
    bool							reset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_MAPPING_WPTR(...) pack_A8XX_VPC_SO_MAPPING_WPTR(__struct_cast(A8XX_VPC_SO_MAPPING_WPTR) { __VA_ARGS__ })

struct A6XX_VPC_SO_MAPPING_PORT {
    uint32_t							a_buf;
    uint32_t							a_off;
    bool							a_en;
    uint32_t							b_buf;
    uint32_t							b_off;
    bool							b_en;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_MAPPING_PORT(...) pack_A6XX_VPC_SO_MAPPING_PORT(__struct_cast(A6XX_VPC_SO_MAPPING_PORT) { __VA_ARGS__ })

struct A8XX_VPC_SO_MAPPING_PORT {
    uint32_t							a_buf;
    uint32_t							a_off;
    bool							a_en;
    uint32_t							b_buf;
    uint32_t							b_off;
    bool							b_en;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_MAPPING_PORT(...) pack_A8XX_VPC_SO_MAPPING_PORT(__struct_cast(A8XX_VPC_SO_MAPPING_PORT) { __VA_ARGS__ })

struct A6XX_VPC_SO_QUERY_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_VPC_SO_QUERY_BASE(...) pack_A6XX_VPC_SO_QUERY_BASE(__struct_cast(A6XX_VPC_SO_QUERY_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_QUERY_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_VPC_SO_QUERY_BASE(...) pack_A8XX_VPC_SO_QUERY_BASE(__struct_cast(A8XX_VPC_SO_QUERY_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_SO_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_VPC_SO_BUFFER_BASE(__i, ...) pack_A6XX_VPC_SO_BUFFER_BASE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_SO_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_BUFFER_SIZE(__i, ...) pack_A6XX_VPC_SO_BUFFER_SIZE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_SIZE) { __VA_ARGS__ })

struct A6XX_VPC_SO_BUFFER_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_BUFFER_STRIDE(__i, ...) pack_A6XX_VPC_SO_BUFFER_STRIDE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_STRIDE) { __VA_ARGS__ })

struct A6XX_VPC_SO_BUFFER_OFFSET {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_BUFFER_OFFSET(__i, ...) pack_A6XX_VPC_SO_BUFFER_OFFSET(__i, __struct_cast(A6XX_VPC_SO_BUFFER_OFFSET) { __VA_ARGS__ })

struct A6XX_VPC_SO_FLUSH_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_VPC_SO_FLUSH_BASE(__i, ...) pack_A6XX_VPC_SO_FLUSH_BASE(__i, __struct_cast(A6XX_VPC_SO_FLUSH_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_VPC_SO_BUFFER_BASE(__i, ...) pack_A8XX_VPC_SO_BUFFER_BASE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_BUFFER_SIZE(__i, ...) pack_A8XX_VPC_SO_BUFFER_SIZE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_SO_BUFFER_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_BUFFER_STRIDE(__i, ...) pack_A8XX_VPC_SO_BUFFER_STRIDE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_STRIDE) { __VA_ARGS__ })

struct A8XX_VPC_SO_BUFFER_OFFSET {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_BUFFER_OFFSET(__i, ...) pack_A8XX_VPC_SO_BUFFER_OFFSET(__i, __struct_cast(A8XX_VPC_SO_BUFFER_OFFSET) { __VA_ARGS__ })

struct A8XX_VPC_SO_FLUSH_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_VPC_SO_FLUSH_BASE(__i, ...) pack_A8XX_VPC_SO_FLUSH_BASE(__i, __struct_cast(A8XX_VPC_SO_FLUSH_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_REPLACE_MODE_CNTL {
    bool							invert;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_REPLACE_MODE_CNTL(...) pack_A6XX_VPC_REPLACE_MODE_CNTL(__struct_cast(A6XX_VPC_REPLACE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_REPLACE_MODE_CNTL {
    bool							invert;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_REPLACE_MODE_CNTL(...) pack_A8XX_VPC_REPLACE_MODE_CNTL(__struct_cast(A8XX_VPC_REPLACE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_ROTATION_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_ROTATION_CNTL(...) pack_A6XX_VPC_ROTATION_CNTL(__struct_cast(A6XX_VPC_ROTATION_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_ROTATION_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_ROTATION_CNTL(...) pack_A8XX_VPC_ROTATION_CNTL(__struct_cast(A8XX_VPC_ROTATION_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_VS_CNTL(...) pack_A6XX_VPC_VS_CNTL(__struct_cast(A6XX_VPC_VS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_GS_CNTL(...) pack_A6XX_VPC_GS_CNTL(__struct_cast(A6XX_VPC_GS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DS_CNTL(...) pack_A6XX_VPC_DS_CNTL(__struct_cast(A6XX_VPC_DS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_VS_CNTL(...) pack_A8XX_VPC_VS_CNTL(__struct_cast(A8XX_VPC_VS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_GS_CNTL(...) pack_A8XX_VPC_GS_CNTL(__struct_cast(A8XX_VPC_GS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DS_CNTL(...) pack_A8XX_VPC_DS_CNTL(__struct_cast(A8XX_VPC_DS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_PS_CNTL {
    uint32_t							numnonposvar;
    uint32_t							primidloc;
    bool							varying;
    uint32_t							viewidloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_PS_CNTL(...) pack_A6XX_VPC_PS_CNTL(__struct_cast(A6XX_VPC_PS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PS_CNTL {
    uint32_t							numnonposvar;
    uint32_t							primidloc;
    bool							varying;
    uint32_t							viewidloc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PS_CNTL(...) pack_A8XX_VPC_PS_CNTL(__struct_cast(A8XX_VPC_PS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_SO_CNTL {
    uint32_t							buf0_stream;
    uint32_t							buf1_stream;
    uint32_t							buf2_stream;
    uint32_t							buf3_stream;
    uint32_t							stream_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_CNTL(...) pack_A6XX_VPC_SO_CNTL(__struct_cast(A6XX_VPC_SO_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_SO_CNTL {
    uint32_t							buf0_stream;
    uint32_t							buf1_stream;
    uint32_t							buf2_stream;
    uint32_t							buf3_stream;
    uint32_t							stream_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_CNTL(...) pack_A8XX_VPC_SO_CNTL(__struct_cast(A8XX_VPC_SO_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_SO_OVERRIDE {
    bool							disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_SO_OVERRIDE(...) pack_A6XX_VPC_SO_OVERRIDE(__struct_cast(A6XX_VPC_SO_OVERRIDE) { __VA_ARGS__ })

struct A8XX_VPC_SO_OVERRIDE {
    bool							disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_SO_OVERRIDE(...) pack_A8XX_VPC_SO_OVERRIDE(__struct_cast(A8XX_VPC_SO_OVERRIDE) { __VA_ARGS__ })

struct A7XX_PC_DGEN_SO_OVERRIDE {
    bool							disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_DGEN_SO_OVERRIDE(...) pack_A7XX_PC_DGEN_SO_OVERRIDE(__struct_cast(A7XX_PC_DGEN_SO_OVERRIDE) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SO_OVERRIDE {
    bool							disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DGEN_SO_OVERRIDE(...) pack_A8XX_PC_DGEN_SO_OVERRIDE(__struct_cast(A8XX_PC_DGEN_SO_OVERRIDE) { __VA_ARGS__ })

struct A6XX_VPC_PS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_PS_RAST_CNTL(...) pack_A6XX_VPC_PS_RAST_CNTL(__struct_cast(A6XX_VPC_PS_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PS_RAST_CNTL(...) pack_A8XX_VPC_PS_RAST_CNTL(__struct_cast(A8XX_VPC_PS_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_ATTR_BUF_GMEM_SIZE {
    uint32_t							vpc_attr_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_ATTR_BUF_GMEM_SIZE(...) pack_A7XX_VPC_ATTR_BUF_GMEM_SIZE(__struct_cast(A7XX_VPC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A7XX_VPC_ATTR_BUF_GMEM_BASE {
    uint32_t							vpc_attr_buf_gmem_base;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_ATTR_BUF_GMEM_BASE(...) pack_A7XX_VPC_ATTR_BUF_GMEM_BASE(__struct_cast(A7XX_VPC_ATTR_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A8XX_VPC_ATTR_BUF_GMEM_SIZE {
    uint32_t							vpc_attr_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_ATTR_BUF_GMEM_SIZE(...) pack_A8XX_VPC_ATTR_BUF_GMEM_SIZE(__struct_cast(A8XX_VPC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_ATTR_BUF_GMEM_BASE {
    uint32_t							vpc_attr_buf_gmem_base;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_ATTR_BUF_GMEM_BASE(...) pack_A8XX_VPC_ATTR_BUF_GMEM_BASE(__struct_cast(A8XX_VPC_ATTR_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A8XX_VPC_POS_BUF_GMEM_SIZE {
    uint32_t							vpc_pos_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_POS_BUF_GMEM_SIZE(...) pack_A8XX_VPC_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_VPC_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_POS_BUF_GMEM_BASE {
    uint32_t							vpc_pos_buf_gmem_base;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_POS_BUF_GMEM_BASE(...) pack_A8XX_VPC_POS_BUF_GMEM_BASE(__struct_cast(A8XX_VPC_POS_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A8XX_VPC_BV_POS_BUF_GMEM_SIZE {
    uint32_t							vpc_bv_pos_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_BV_POS_BUF_GMEM_SIZE(...) pack_A8XX_VPC_BV_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_VPC_BV_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_BV_POS_BUF_GMEM_BASE {
    uint32_t							vpc_bv_pos_buf_gmem_base;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_BV_POS_BUF_GMEM_BASE(...) pack_A8XX_VPC_BV_POS_BUF_GMEM_BASE(__struct_cast(A8XX_VPC_BV_POS_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A7XX_PC_ATTR_BUF_GMEM_SIZE {
    uint32_t							pc_attr_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_ATTR_BUF_GMEM_SIZE(...) pack_A7XX_PC_ATTR_BUF_GMEM_SIZE(__struct_cast(A7XX_PC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_PC_ATTR_BUF_GMEM_SIZE {
    uint32_t							pc_attr_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_ATTR_BUF_GMEM_SIZE(...) pack_A8XX_PC_ATTR_BUF_GMEM_SIZE(__struct_cast(A8XX_PC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_PC_POS_BUF_GMEM_SIZE {
    uint32_t							pc_pos_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_POS_BUF_GMEM_SIZE(...) pack_A8XX_PC_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_PC_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_PC_BV_POS_BUF_GMEM_SIZE {
    uint32_t							pc_bv_pos_buf_gmem_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_BV_POS_BUF_GMEM_SIZE(...) pack_A8XX_PC_BV_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_PC_BV_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A7XX_VPC_UNKNOWN_930A {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_UNKNOWN_930A(...) pack_A7XX_VPC_UNKNOWN_930A(__struct_cast(A7XX_VPC_UNKNOWN_930A) { __VA_ARGS__ })

struct A8XX_VPC_UNKNOWN_9313 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_UNKNOWN_9313(...) pack_A8XX_VPC_UNKNOWN_9313(__struct_cast(A8XX_VPC_UNKNOWN_9313) { __VA_ARGS__ })

struct A8XX_PC_UNKNOWN_9E17 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_UNKNOWN_9E17(...) pack_A8XX_PC_UNKNOWN_9E17(__struct_cast(A8XX_PC_UNKNOWN_9E17) { __VA_ARGS__ })

struct A7XX_VPC_FLATSHADE_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_FLATSHADE_MODE_CNTL(...) pack_A7XX_VPC_FLATSHADE_MODE_CNTL(__struct_cast(A7XX_VPC_FLATSHADE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_FLATSHADE_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_FLATSHADE_MODE_CNTL(...) pack_A8XX_VPC_FLATSHADE_MODE_CNTL(__struct_cast(A8XX_VPC_FLATSHADE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_DBG_ECO_CNTL(...) pack_A6XX_VPC_DBG_ECO_CNTL(__struct_cast(A6XX_VPC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					vpc_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_ADDR_MODE_CNTL(...) pack_A6XX_VPC_ADDR_MODE_CNTL(__struct_cast(A6XX_VPC_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DBG_ECO_CNTL(...) pack_A8XX_VPC_DBG_ECO_CNTL(__struct_cast(A8XX_VPC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DBG_ECO_CNTL_2(...) pack_A8XX_VPC_DBG_ECO_CNTL_2(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_2) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DBG_ECO_CNTL_1(...) pack_A8XX_VPC_DBG_ECO_CNTL_1(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_1) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_DBG_ECO_CNTL_3(...) pack_A8XX_VPC_DBG_ECO_CNTL_3(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_3) { __VA_ARGS__ })

struct A6XX_VPC_LB_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_LB_MODE_CNTL(...) pack_A6XX_VPC_LB_MODE_CNTL(__struct_cast(A6XX_VPC_LB_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_LB_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_LB_MODE_CNTL(...) pack_A8XX_VPC_LB_MODE_CNTL(__struct_cast(A8XX_VPC_LB_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_STATUS(...) pack_A6XX_VPC_STATUS(__struct_cast(A6XX_VPC_STATUS) { __VA_ARGS__ })

struct A8XX_VPC_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_STATUS(...) pack_A8XX_VPC_STATUS(__struct_cast(A8XX_VPC_STATUS) { __VA_ARGS__ })

struct A6XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A6XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A6XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A7XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A7XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A7XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_2_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PERFCTR_VPC_SEL_2_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_2_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_2_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_1_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VPC_PERFCTR_VPC_SEL_1_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_1_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_1_REG) { __VA_ARGS__ })

struct A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(...) pack_A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(__struct_cast(A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(...) pack_A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(__struct_cast(A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_PC_UNKNOWN_980B {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_UNKNOWN_980B(...) pack_A8XX_PC_UNKNOWN_980B(__struct_cast(A8XX_PC_UNKNOWN_980B) { __VA_ARGS__ })

struct A6XX_PC_HS_PARAM_0 {
    uint32_t							pc_hs_param_0;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_HS_PARAM_0(...) pack_A6XX_PC_HS_PARAM_0(__struct_cast(A6XX_PC_HS_PARAM_0) { __VA_ARGS__ })

struct A8XX_PC_HS_PARAM_0 {
    uint32_t							pc_hs_param_0;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_HS_PARAM_0(...) pack_A8XX_PC_HS_PARAM_0(__struct_cast(A8XX_PC_HS_PARAM_0) { __VA_ARGS__ })

struct A6XX_PC_HS_PARAM_1 {
    uint32_t							size;
    uint32_t							unk13;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_HS_PARAM_1(...) pack_A6XX_PC_HS_PARAM_1(__struct_cast(A6XX_PC_HS_PARAM_1) { __VA_ARGS__ })

struct A8XX_PC_HS_PARAM_1 {
    uint32_t							size;
    uint32_t							unk13;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_HS_PARAM_1(...) pack_A8XX_PC_HS_PARAM_1(__struct_cast(A8XX_PC_HS_PARAM_1) { __VA_ARGS__ })

struct A6XX_PC_DS_PARAM {
    enum a6xx_tess_spacing					spacing;
    enum a6xx_tess_output					output;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DS_PARAM(...) pack_A6XX_PC_DS_PARAM(__struct_cast(A6XX_PC_DS_PARAM) { __VA_ARGS__ })

struct A8XX_PC_DS_PARAM {
    enum a6xx_tess_spacing					spacing;
    enum a6xx_tess_output					output;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DS_PARAM(...) pack_A8XX_PC_DS_PARAM(__struct_cast(A8XX_PC_DS_PARAM) { __VA_ARGS__ })

struct A6XX_PC_RESTART_INDEX {
    uint32_t							pc_restart_index;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_RESTART_INDEX(...) pack_A6XX_PC_RESTART_INDEX(__struct_cast(A6XX_PC_RESTART_INDEX) { __VA_ARGS__ })

struct A8XX_PC_RESTART_INDEX {
    uint32_t							pc_restart_index;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_RESTART_INDEX(...) pack_A8XX_PC_RESTART_INDEX(__struct_cast(A8XX_PC_RESTART_INDEX) { __VA_ARGS__ })

struct A6XX_PC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_MODE_CNTL(...) pack_A6XX_PC_MODE_CNTL(__struct_cast(A6XX_PC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_PC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_MODE_CNTL(...) pack_A8XX_PC_MODE_CNTL(__struct_cast(A8XX_PC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_PC_POWER_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_POWER_CNTL(...) pack_A6XX_PC_POWER_CNTL(__struct_cast(A6XX_PC_POWER_CNTL) { __VA_ARGS__ })

struct A6XX_PC_PS_CNTL {
    bool							primitiveiden;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_PS_CNTL(...) pack_A6XX_PC_PS_CNTL(__struct_cast(A6XX_PC_PS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_PS_CNTL {
    bool							primitiveiden;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_PS_CNTL(...) pack_A8XX_PC_PS_CNTL(__struct_cast(A8XX_PC_PS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DGEN_SO_CNTL {
    uint32_t							stream_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DGEN_SO_CNTL(...) pack_A6XX_PC_DGEN_SO_CNTL(__struct_cast(A6XX_PC_DGEN_SO_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SO_CNTL {
    uint32_t							stream_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DGEN_SO_CNTL(...) pack_A8XX_PC_DGEN_SO_CNTL(__struct_cast(A8XX_PC_DGEN_SO_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(...) pack_A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(...) pack_A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_VS_INPUT_CNTL {
    uint32_t							instr_cnt;
    uint32_t							sideband_cnt;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_VS_INPUT_CNTL(...) pack_A8XX_PC_VS_INPUT_CNTL(__struct_cast(A8XX_PC_VS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DRAW_INITIATOR(...) pack_A6XX_PC_DRAW_INITIATOR(__struct_cast(A6XX_PC_DRAW_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_KERNEL_INITIATOR(...) pack_A6XX_PC_KERNEL_INITIATOR(__struct_cast(A6XX_PC_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DRAW_INITIATOR(...) pack_A8XX_PC_DRAW_INITIATOR(__struct_cast(A8XX_PC_DRAW_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_KERNEL_INITIATOR(...) pack_A8XX_PC_KERNEL_INITIATOR(__struct_cast(A8XX_PC_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_EVENT_INITIATOR(...) pack_A6XX_PC_EVENT_INITIATOR(__struct_cast(A6XX_PC_EVENT_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_EVENT_INITIATOR(...) pack_A8XX_PC_EVENT_INITIATOR(__struct_cast(A8XX_PC_EVENT_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_MARKER {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PC_MARKER(struct A6XX_PC_MARKER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009880,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_MARKER(...) pack_A6XX_PC_MARKER(__struct_cast(A6XX_PC_MARKER) { __VA_ARGS__ })

struct A6XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DGEN_RAST_CNTL(...) pack_A6XX_PC_DGEN_RAST_CNTL(__struct_cast(A6XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_DGEN_RAST_CNTL(...) pack_A7XX_PC_DGEN_RAST_CNTL(__struct_cast(A7XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DGEN_RAST_CNTL(...) pack_A8XX_PC_DGEN_RAST_CNTL(__struct_cast(A8XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_PC_HS_PATCH_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_HS_PATCH_SIZE(...) pack_A7XX_PC_HS_PATCH_SIZE(__struct_cast(A7XX_PC_HS_PATCH_SIZE) { __VA_ARGS__ })

struct A8XX_PC_HS_PATCH_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_HS_PATCH_SIZE(...) pack_A8XX_PC_HS_PATCH_SIZE(__struct_cast(A8XX_PC_HS_PATCH_SIZE) { __VA_ARGS__ })

struct A7XX_PC_HS_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_HS_BUFFER_SIZE(...) pack_A7XX_PC_HS_BUFFER_SIZE(__struct_cast(A7XX_PC_HS_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_PC_HS_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_HS_BUFFER_SIZE(...) pack_A8XX_PC_HS_BUFFER_SIZE(__struct_cast(A8XX_PC_HS_BUFFER_SIZE) { __VA_ARGS__ })

struct A7XX_PC_TF_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_TF_BUFFER_SIZE(...) pack_A7XX_PC_TF_BUFFER_SIZE(__struct_cast(A7XX_PC_TF_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_PC_TF_BUFFER_SIZE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_TF_BUFFER_SIZE(...) pack_A8XX_PC_TF_BUFFER_SIZE(__struct_cast(A8XX_PC_TF_BUFFER_SIZE) { __VA_ARGS__ })

struct A6XX_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_CNTL(...) pack_A6XX_PC_CNTL(__struct_cast(A6XX_PC_CNTL) { __VA_ARGS__ })

struct A8XX_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CNTL(...) pack_A8XX_PC_CNTL(__struct_cast(A8XX_PC_CNTL) { __VA_ARGS__ })

struct A6XX_PC_VS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_VS_CNTL(...) pack_A6XX_PC_VS_CNTL(__struct_cast(A6XX_PC_VS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_GS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_GS_CNTL(...) pack_A6XX_PC_GS_CNTL(__struct_cast(A6XX_PC_GS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_HS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_HS_CNTL(...) pack_A6XX_PC_HS_CNTL(__struct_cast(A6XX_PC_HS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DS_CNTL(...) pack_A6XX_PC_DS_CNTL(__struct_cast(A6XX_PC_DS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_VS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_VS_CNTL(...) pack_A8XX_PC_VS_CNTL(__struct_cast(A8XX_PC_VS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_GS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_GS_CNTL(...) pack_A8XX_PC_GS_CNTL(__struct_cast(A8XX_PC_GS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_HS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_HS_CNTL(...) pack_A8XX_PC_HS_CNTL(__struct_cast(A8XX_PC_HS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DS_CNTL(...) pack_A8XX_PC_DS_CNTL(__struct_cast(A8XX_PC_DS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_GS_PARAM_0(...) pack_A6XX_PC_GS_PARAM_0(__struct_cast(A6XX_PC_GS_PARAM_0) { __VA_ARGS__ })

struct A8XX_PC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_GS_PARAM_0(...) pack_A8XX_PC_GS_PARAM_0(__struct_cast(A8XX_PC_GS_PARAM_0) { __VA_ARGS__ })

struct A6XX_PC_PRIMITIVE_CNTL_6 {
    uint32_t							stride_in_vpc;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_PRIMITIVE_CNTL_6(...) pack_A6XX_PC_PRIMITIVE_CNTL_6(__struct_cast(A6XX_PC_PRIMITIVE_CNTL_6) { __VA_ARGS__ })

struct A6XX_PC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_STEREO_RENDERING_CNTL(...) pack_A6XX_PC_STEREO_RENDERING_CNTL(__struct_cast(A6XX_PC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A8XX_PC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_STEREO_RENDERING_CNTL(...) pack_A8XX_PC_STEREO_RENDERING_CNTL(__struct_cast(A8XX_PC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_PC_STEREO_RENDERING_VIEWMASK {
    uint32_t							pc_stereo_rendering_viewmask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_STEREO_RENDERING_VIEWMASK(...) pack_A6XX_PC_STEREO_RENDERING_VIEWMASK(__struct_cast(A6XX_PC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A8XX_PC_STEREO_RENDERING_VIEWMASK {
    uint32_t							pc_stereo_rendering_viewmask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_STEREO_RENDERING_VIEWMASK(...) pack_A8XX_PC_STEREO_RENDERING_VIEWMASK(__struct_cast(A8XX_PC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A6XX_PC_2D_EVENT_CMD {
    enum vgt_event_type						event;
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PC_2D_EVENT_CMD(struct A6XX_PC_2D_EVENT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.event                             & 0xffffff80) == 0);
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ff7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009c00,
        .value =
            (fields.event                             <<  0) |
            (fields.state_id                          <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_2D_EVENT_CMD(...) pack_A6XX_PC_2D_EVENT_CMD(__struct_cast(A6XX_PC_2D_EVENT_CMD) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CHICKEN_BITS_1(...) pack_A8XX_PC_CHICKEN_BITS_1(__struct_cast(A8XX_PC_CHICKEN_BITS_1) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CHICKEN_BITS_2(...) pack_A8XX_PC_CHICKEN_BITS_2(__struct_cast(A8XX_PC_CHICKEN_BITS_2) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CHICKEN_BITS_3(...) pack_A8XX_PC_CHICKEN_BITS_3(__struct_cast(A8XX_PC_CHICKEN_BITS_3) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CHICKEN_BITS_4(...) pack_A8XX_PC_CHICKEN_BITS_4(__struct_cast(A8XX_PC_CHICKEN_BITS_4) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_5 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CHICKEN_BITS_5(...) pack_A8XX_PC_CHICKEN_BITS_5(__struct_cast(A8XX_PC_CHICKEN_BITS_5) { __VA_ARGS__ })

struct A6XX_PC_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DBG_ECO_CNTL(...) pack_A6XX_PC_DBG_ECO_CNTL(__struct_cast(A6XX_PC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DBG_ECO_CNTL(...) pack_A8XX_PC_DBG_ECO_CNTL(__struct_cast(A8XX_PC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_PC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					pc_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_ADDR_MODE_CNTL(...) pack_A6XX_PC_ADDR_MODE_CNTL(__struct_cast(A6XX_PC_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DMA_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_PC_DMA_BASE(...) pack_A6XX_PC_DMA_BASE(__struct_cast(A6XX_PC_DMA_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_PC_DMA_OFFSET {
    uint32_t							pc_dma_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DMA_OFFSET(...) pack_A6XX_PC_DMA_OFFSET(__struct_cast(A6XX_PC_DMA_OFFSET) { __VA_ARGS__ })

struct A6XX_PC_DMA_SIZE {
    uint32_t							pc_dma_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DMA_SIZE(...) pack_A6XX_PC_DMA_SIZE(__struct_cast(A6XX_PC_DMA_SIZE) { __VA_ARGS__ })

struct A8XX_PC_DMA_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_PC_DMA_BASE(...) pack_A8XX_PC_DMA_BASE(__struct_cast(A8XX_PC_DMA_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_PC_DMA_OFFSET {
    uint32_t							pc_dma_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DMA_OFFSET(...) pack_A8XX_PC_DMA_OFFSET(__struct_cast(A8XX_PC_DMA_OFFSET) { __VA_ARGS__ })

struct A8XX_PC_DMA_SIZE {
    uint32_t							pc_dma_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DMA_SIZE(...) pack_A8XX_PC_DMA_SIZE(__struct_cast(A8XX_PC_DMA_SIZE) { __VA_ARGS__ })

struct A6XX_PC_TESS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_PC_TESS_BASE(...) pack_A6XX_PC_TESS_BASE(__struct_cast(A6XX_PC_TESS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_PC_TESS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_PC_TESS_BASE(...) pack_A7XX_PC_TESS_BASE(__struct_cast(A7XX_PC_TESS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_PC_TESS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_PC_TESS_BASE(...) pack_A8XX_PC_TESS_BASE(__struct_cast(A8XX_PC_TESS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_PC_DRAWCALL_CNTL {
    enum pc_di_primtype						prim_type;
    enum pc_di_src_sel						source_select;
    enum pc_di_vis_cull_mode					vis_cull;
    enum a4xx_index_size					index_size;
    enum a6xx_patch_type					patch_type;
    bool							gs_enable;
    bool							tess_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DRAWCALL_CNTL(...) pack_A6XX_PC_DRAWCALL_CNTL(__struct_cast(A6XX_PC_DRAWCALL_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DRAWCALL_INSTANCE_NUM {
    uint32_t							pc_drawcall_instance_num;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DRAWCALL_INSTANCE_NUM(...) pack_A6XX_PC_DRAWCALL_INSTANCE_NUM(__struct_cast(A6XX_PC_DRAWCALL_INSTANCE_NUM) { __VA_ARGS__ })

struct A6XX_PC_DRAWCALL_SIZE {
    uint32_t							pc_drawcall_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DRAWCALL_SIZE(...) pack_A6XX_PC_DRAWCALL_SIZE(__struct_cast(A6XX_PC_DRAWCALL_SIZE) { __VA_ARGS__ })

struct A8XX_PC_DRAWCALL_CNTL {
    enum pc_di_primtype						prim_type;
    enum pc_di_src_sel						source_select;
    enum pc_di_vis_cull_mode					vis_cull;
    enum a4xx_index_size					index_size;
    enum a6xx_patch_type					patch_type;
    bool							gs_enable;
    bool							tess_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DRAWCALL_CNTL(...) pack_A8XX_PC_DRAWCALL_CNTL(__struct_cast(A8XX_PC_DRAWCALL_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DRAWCALL_INSTANCE_NUM {
    uint32_t							pc_drawcall_instance_num;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DRAWCALL_INSTANCE_NUM(...) pack_A8XX_PC_DRAWCALL_INSTANCE_NUM(__struct_cast(A8XX_PC_DRAWCALL_INSTANCE_NUM) { __VA_ARGS__ })

struct A8XX_PC_DRAWCALL_SIZE {
    uint32_t							pc_drawcall_size;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DRAWCALL_SIZE(...) pack_A8XX_PC_DRAWCALL_SIZE(__struct_cast(A8XX_PC_DRAWCALL_SIZE) { __VA_ARGS__ })

struct A6XX_PC_VIS_STREAM_CNTL {
    uint32_t							unk0;
    uint32_t							vsc_size;
    uint32_t							vsc_n;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_VIS_STREAM_CNTL(...) pack_A6XX_PC_VIS_STREAM_CNTL(__struct_cast(A6XX_PC_VIS_STREAM_CNTL) { __VA_ARGS__ })

struct A6XX_PC_PVIS_STREAM_BIN_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_PC_PVIS_STREAM_BIN_BASE(...) pack_A6XX_PC_PVIS_STREAM_BIN_BASE(__struct_cast(A6XX_PC_PVIS_STREAM_BIN_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_PC_DVIS_STREAM_BIN_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_PC_DVIS_STREAM_BIN_BASE(...) pack_A6XX_PC_DVIS_STREAM_BIN_BASE(__struct_cast(A6XX_PC_DVIS_STREAM_BIN_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_PC_AUTO_VERTEX_STRIDE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PC_AUTO_VERTEX_STRIDE(struct A6XX_PC_AUTO_VERTEX_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e0a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_AUTO_VERTEX_STRIDE(...) pack_A6XX_PC_AUTO_VERTEX_STRIDE(__struct_cast(A6XX_PC_AUTO_VERTEX_STRIDE) { __VA_ARGS__ })

struct A8XX_PC_VIS_STREAM_CNTL {
    uint32_t							unk0;
    uint32_t							vsc_size;
    uint32_t							vsc_n;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_VIS_STREAM_CNTL(...) pack_A8XX_PC_VIS_STREAM_CNTL(__struct_cast(A8XX_PC_VIS_STREAM_CNTL) { __VA_ARGS__ })

struct A8XX_PC_PVIS_STREAM_BIN_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_PC_PVIS_STREAM_BIN_BASE(...) pack_A8XX_PC_PVIS_STREAM_BIN_BASE(__struct_cast(A8XX_PC_PVIS_STREAM_BIN_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_PC_DVIS_STREAM_BIN_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_PC_DVIS_STREAM_BIN_BASE(...) pack_A8XX_PC_DVIS_STREAM_BIN_BASE(__struct_cast(A8XX_PC_DVIS_STREAM_BIN_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_PC_DRAWCALL_CNTL_OVERRIDE {
    bool							override;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_DRAWCALL_CNTL_OVERRIDE(...) pack_A6XX_PC_DRAWCALL_CNTL_OVERRIDE(__struct_cast(A6XX_PC_DRAWCALL_CNTL_OVERRIDE) { __VA_ARGS__ })

struct A8XX_PC_DRAWCALL_CNTL_OVERRIDE {
    bool							override;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_DRAWCALL_CNTL_OVERRIDE(...) pack_A8XX_PC_DRAWCALL_CNTL_OVERRIDE(__struct_cast(A8XX_PC_DRAWCALL_CNTL_OVERRIDE) { __VA_ARGS__ })

struct A7XX_PC_UNKNOWN_9E24 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_UNKNOWN_9E24(...) pack_A7XX_PC_UNKNOWN_9E24(__struct_cast(A7XX_PC_UNKNOWN_9E24) { __VA_ARGS__ })

struct A6XX_PC_PERFCTR_PC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_PERFCTR_PC_SEL_REG(__i, ...) pack_A6XX_PC_PERFCTR_PC_SEL_REG(__i, __struct_cast(A6XX_PC_PERFCTR_PC_SEL_REG) { __VA_ARGS__ })

struct A7XX_PC_PERFCTR_PC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_PC_PERFCTR_PC_SEL_REG(__i, ...) pack_A7XX_PC_PERFCTR_PC_SEL_REG(__i, __struct_cast(A7XX_PC_PERFCTR_PC_SEL_REG) { __VA_ARGS__ })

struct A8XX_PC_PERFCTR_PC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_PERFCTR_PC_SEL_REG(__i, ...) pack_A8XX_PC_PERFCTR_PC_SEL_REG(__i, __struct_cast(A8XX_PC_PERFCTR_PC_SEL_REG) { __VA_ARGS__ })

struct A8XX_PC_SLICE_PERFCTR_PC_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_SLICE_PERFCTR_PC_SEL_REG(__i, ...) pack_A8XX_PC_SLICE_PERFCTR_PC_SEL_REG(__i, __struct_cast(A8XX_PC_SLICE_PERFCTR_PC_SEL_REG) { __VA_ARGS__ })

struct A6XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE(...) pack_A6XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE(__struct_cast(A6XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE) { __VA_ARGS__ })

struct A8XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE(...) pack_A8XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE(__struct_cast(A8XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE) { __VA_ARGS__ })

struct A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1(...) pack_A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1(__struct_cast(A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_0 {
    uint32_t							fetch_cnt;
    uint32_t							decode_cnt;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_0(struct A6XX_VFD_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.fetch_cnt                         & 0xffffffc0) == 0);
    assert((fields.decode_cnt                        & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0x00003f3f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a000,
        .value =
            (fields.fetch_cnt                         <<  0) |
            (fields.decode_cnt                        <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_0(...) pack_A6XX_VFD_CNTL_0(__struct_cast(A6XX_VFD_CNTL_0) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_1 {
    uint32_t							regid4vtx;
    uint32_t							regid4inst;
    uint32_t							regid4primid;
    uint32_t							regid4viewid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_1(struct A6XX_VFD_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.regid4vtx                         & 0xffffff00) == 0);
    assert((fields.regid4inst                        & 0xffffff00) == 0);
    assert((fields.regid4primid                      & 0xffffff00) == 0);
    assert((fields.regid4viewid                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a001,
        .value =
            (fields.regid4vtx                         <<  0) |
            (fields.regid4inst                        <<  8) |
            (fields.regid4primid                      << 16) |
            (fields.regid4viewid                      << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_1(...) pack_A6XX_VFD_CNTL_1(__struct_cast(A6XX_VFD_CNTL_1) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_2 {
    uint32_t							regid_hsrelpatchid;
    uint32_t							regid_invocationid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_2(struct A6XX_VFD_CNTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.regid_hsrelpatchid                & 0xffffff00) == 0);
    assert((fields.regid_invocationid                & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a002,
        .value =
            (fields.regid_hsrelpatchid                <<  0) |
            (fields.regid_invocationid                <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_2(...) pack_A6XX_VFD_CNTL_2(__struct_cast(A6XX_VFD_CNTL_2) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_3 {
    uint32_t							regid_dsprimid;
    uint32_t							regid_dsrelpatchid;
    uint32_t							regid_tessx;
    uint32_t							regid_tessy;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_3(struct A6XX_VFD_CNTL_3 fields)
{
#ifndef NDEBUG
    assert((fields.regid_dsprimid                    & 0xffffff00) == 0);
    assert((fields.regid_dsrelpatchid                & 0xffffff00) == 0);
    assert((fields.regid_tessx                       & 0xffffff00) == 0);
    assert((fields.regid_tessy                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a003,
        .value =
            (fields.regid_dsprimid                    <<  0) |
            (fields.regid_dsrelpatchid                <<  8) |
            (fields.regid_tessx                       << 16) |
            (fields.regid_tessy                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_3(...) pack_A6XX_VFD_CNTL_3(__struct_cast(A6XX_VFD_CNTL_3) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_4 {
    uint32_t							unk0;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_4(struct A6XX_VFD_CNTL_4 fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a004,
        .value =
            (fields.unk0                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_4(...) pack_A6XX_VFD_CNTL_4(__struct_cast(A6XX_VFD_CNTL_4) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_5 {
    uint32_t							regid_gsheader;
    uint32_t							unk8;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_5(struct A6XX_VFD_CNTL_5 fields)
{
#ifndef NDEBUG
    assert((fields.regid_gsheader                    & 0xffffff00) == 0);
    assert((fields.unk8                              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a005,
        .value =
            (fields.regid_gsheader                    <<  0) |
            (fields.unk8                              <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_5(...) pack_A6XX_VFD_CNTL_5(__struct_cast(A6XX_VFD_CNTL_5) { __VA_ARGS__ })

struct A6XX_VFD_CNTL_6 {
    bool							primid4psen;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_CNTL_6(struct A6XX_VFD_CNTL_6 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a006,
        .value =
            (fields.primid4psen                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_CNTL_6(...) pack_A6XX_VFD_CNTL_6(__struct_cast(A6XX_VFD_CNTL_6) { __VA_ARGS__ })

struct A6XX_VFD_RENDER_MODE {
    enum a6xx_render_mode					render_mode;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_RENDER_MODE(struct A6XX_VFD_RENDER_MODE fields)
{
#ifndef NDEBUG
    assert((fields.render_mode                       & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a007,
        .value =
            (fields.render_mode                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_RENDER_MODE(...) pack_A6XX_VFD_RENDER_MODE(__struct_cast(A6XX_VFD_RENDER_MODE) { __VA_ARGS__ })

struct A6XX_VFD_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_STEREO_RENDERING_CNTL(struct A6XX_VFD_STEREO_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.views                             & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a008,
        .value =
            (fields.enable                            <<  0) |
            (fields.disablemultipos                   <<  1) |
            (fields.views                             <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_STEREO_RENDERING_CNTL(...) pack_A6XX_VFD_STEREO_RENDERING_CNTL(__struct_cast(A6XX_VFD_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_VFD_MODE_CNTL {
    bool							vertex;
    bool							instance;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_MODE_CNTL(struct A6XX_VFD_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a009,
        .value =
            (fields.vertex                            <<  0) |
            (fields.instance                          <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_MODE_CNTL(...) pack_A6XX_VFD_MODE_CNTL(__struct_cast(A6XX_VFD_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VFD_INDEX_OFFSET {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_INDEX_OFFSET(struct A6XX_VFD_INDEX_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a00e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_INDEX_OFFSET(...) pack_A6XX_VFD_INDEX_OFFSET(__struct_cast(A6XX_VFD_INDEX_OFFSET) { __VA_ARGS__ })

struct A6XX_VFD_INSTANCE_START_OFFSET {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_INSTANCE_START_OFFSET(struct A6XX_VFD_INSTANCE_START_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a00f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_INSTANCE_START_OFFSET(...) pack_A6XX_VFD_INSTANCE_START_OFFSET(__struct_cast(A6XX_VFD_INSTANCE_START_OFFSET) { __VA_ARGS__ })

struct A6XX_VFD_VERTEX_BUFFER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_VERTEX_BUFFER_BASE(uint32_t __i, struct A6XX_VFD_VERTEX_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a010 + 0x4*__i),
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_VFD_VERTEX_BUFFER_BASE(__i, ...) pack_A6XX_VFD_VERTEX_BUFFER_BASE(__i, __struct_cast(A6XX_VFD_VERTEX_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VFD_VERTEX_BUFFER_SIZE {
    uint32_t							vfd_vertex_buffer_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_VERTEX_BUFFER_SIZE(uint32_t __i, struct A6XX_VFD_VERTEX_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.vfd_vertex_buffer_size            & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a012 + 0x4*__i),
        .value =
            (fields.vfd_vertex_buffer_size            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_VERTEX_BUFFER_SIZE(__i, ...) pack_A6XX_VFD_VERTEX_BUFFER_SIZE(__i, __struct_cast(A6XX_VFD_VERTEX_BUFFER_SIZE) { __VA_ARGS__ })

struct A6XX_VFD_VERTEX_BUFFER_STRIDE {
    uint32_t							vfd_vertex_buffer_stride;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_VERTEX_BUFFER_STRIDE(uint32_t __i, struct A6XX_VFD_VERTEX_BUFFER_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.vfd_vertex_buffer_stride          & 0xfffff000) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a013 + 0x4*__i),
        .value =
            (fields.vfd_vertex_buffer_stride          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_VERTEX_BUFFER_STRIDE(__i, ...) pack_A6XX_VFD_VERTEX_BUFFER_STRIDE(__i, __struct_cast(A6XX_VFD_VERTEX_BUFFER_STRIDE) { __VA_ARGS__ })

struct A6XX_VFD_FETCH_INSTR_INSTR {
    uint32_t							idx;
    uint32_t							offset;
    bool							instanced;
    enum a6xx_format						format;
    enum a3xx_color_swap					swap;
    bool							unk30;
    bool							_float;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_FETCH_INSTR_INSTR(uint32_t __i, struct A6XX_VFD_FETCH_INSTR_INSTR fields)
{
#ifndef NDEBUG
    assert((fields.idx                               & 0xffffffe0) == 0);
    assert((fields.offset                            & 0xfffff000) == 0);
    assert((fields.format                            & 0xffffff00) == 0);
    assert((fields.swap                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0xfff3ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a090 + 0x2*__i),
        .value =
            (fields.idx                               <<  0) |
            (fields.offset                            <<  5) |
            (fields.instanced                         << 17) |
            (fields.format                            << 20) |
            (fields.swap                              << 28) |
            (fields.unk30                             << 30) |
            (fields._float                            << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_FETCH_INSTR_INSTR(__i, ...) pack_A6XX_VFD_FETCH_INSTR_INSTR(__i, __struct_cast(A6XX_VFD_FETCH_INSTR_INSTR) { __VA_ARGS__ })

struct A6XX_VFD_FETCH_INSTR_STEP_RATE {
    uint32_t							vfd_fetch_instr_step_rate;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_FETCH_INSTR_STEP_RATE(uint32_t __i, struct A6XX_VFD_FETCH_INSTR_STEP_RATE fields)
{
#ifndef NDEBUG
    assert((fields.vfd_fetch_instr_step_rate         & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a091 + 0x2*__i),
        .value =
            (fields.vfd_fetch_instr_step_rate         <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_FETCH_INSTR_STEP_RATE(__i, ...) pack_A6XX_VFD_FETCH_INSTR_STEP_RATE(__i, __struct_cast(A6XX_VFD_FETCH_INSTR_STEP_RATE) { __VA_ARGS__ })

struct A6XX_VFD_DEST_CNTL_INSTR {
    uint32_t							writemask;
    uint32_t							regid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_VFD_DEST_CNTL_INSTR(uint32_t __i, struct A6XX_VFD_DEST_CNTL_INSTR fields)
{
#ifndef NDEBUG
    assert((fields.writemask                         & 0xfffffff0) == 0);
    assert((fields.regid                             & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a0d0 + 0x1*__i),
        .value =
            (fields.writemask                         <<  0) |
            (fields.regid                             <<  4) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VFD_DEST_CNTL_INSTR(__i, ...) pack_A6XX_VFD_DEST_CNTL_INSTR(__i, __struct_cast(A6XX_VFD_DEST_CNTL_INSTR) { __VA_ARGS__ })

struct A6XX_VFD_POWER_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VFD_POWER_CNTL(...) pack_A6XX_VFD_POWER_CNTL(__struct_cast(A6XX_VFD_POWER_CNTL) { __VA_ARGS__ })

struct A7XX_VFD_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VFD_DBG_ECO_CNTL(...) pack_A7XX_VFD_DBG_ECO_CNTL(__struct_cast(A7XX_VFD_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_VFD_ADDR_MODE_CNTL {
    enum a5xx_address_mode					vfd_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VFD_ADDR_MODE_CNTL(...) pack_A6XX_VFD_ADDR_MODE_CNTL(__struct_cast(A6XX_VFD_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VFD_PERFCTR_VFD_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_VFD_PERFCTR_VFD_SEL_REG(__i, ...) pack_A6XX_VFD_PERFCTR_VFD_SEL_REG(__i, __struct_cast(A6XX_VFD_PERFCTR_VFD_SEL_REG) { __VA_ARGS__ })

struct A7XX_VFD_PERFCTR_VFD_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_VFD_PERFCTR_VFD_SEL_REG(__i, ...) pack_A7XX_VFD_PERFCTR_VFD_SEL_REG(__i, __struct_cast(A7XX_VFD_PERFCTR_VFD_SEL_REG) { __VA_ARGS__ })

struct A8XX_VFD_CB_BV_THRESHOLD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VFD_CB_BV_THRESHOLD(...) pack_A8XX_VFD_CB_BV_THRESHOLD(__struct_cast(A8XX_VFD_CB_BV_THRESHOLD) { __VA_ARGS__ })

struct A8XX_VFD_CB_BR_THRESHOLD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VFD_CB_BR_THRESHOLD(...) pack_A8XX_VFD_CB_BR_THRESHOLD(__struct_cast(A8XX_VFD_CB_BR_THRESHOLD) { __VA_ARGS__ })

struct A8XX_VFD_CB_BUSY_REQ_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VFD_CB_BUSY_REQ_CNT(...) pack_A8XX_VFD_CB_BUSY_REQ_CNT(__struct_cast(A8XX_VFD_CB_BUSY_REQ_CNT) { __VA_ARGS__ })

struct A8XX_VFD_CB_LP_REQ_CNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_VFD_CB_LP_REQ_CNT(...) pack_A8XX_VFD_CB_LP_REQ_CNT(__struct_cast(A8XX_VFD_CB_LP_REQ_CNT) { __VA_ARGS__ })

struct A6XX_SP_VS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    bool							mergedregs;
    bool							earlypreamble;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_CNTL_0(struct A6XX_SP_VS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x483fffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a800,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.mergedregs                        << 20) |
            (fields.earlypreamble                     << 21) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_CNTL_0(...) pack_A6XX_SP_VS_CNTL_0(__struct_cast(A6XX_SP_VS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_VS_BOOLEAN_CF_MASK {
    uint32_t							sp_vs_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_BOOLEAN_CF_MASK(struct A6XX_SP_VS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_vs_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a801,
        .value =
            (fields.sp_vs_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_VS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_VS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_VS_OUTPUT_CNTL {
    uint32_t							out;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_OUTPUT_CNTL(struct A6XX_SP_VS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.out                               & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a802,
        .value =
            (fields.out                               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_OUTPUT_CNTL(...) pack_A6XX_SP_VS_OUTPUT_CNTL(__struct_cast(A6XX_SP_VS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_SP_VS_OUTPUT_REG {
    uint32_t							a_regid;
    uint32_t							a_compmask;
    uint32_t							b_regid;
    uint32_t							b_compmask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_OUTPUT_REG(uint32_t __i, struct A6XX_SP_VS_OUTPUT_REG fields)
{
#ifndef NDEBUG
    assert((fields.a_regid                           & 0xffffff00) == 0);
    assert((fields.a_compmask                        & 0xfffffff0) == 0);
    assert((fields.b_regid                           & 0xffffff00) == 0);
    assert((fields.b_compmask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a803 + 0x1*__i),
        .value =
            (fields.a_regid                           <<  0) |
            (fields.a_compmask                        <<  8) |
            (fields.b_regid                           << 16) |
            (fields.b_compmask                        << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_OUTPUT_REG(__i, ...) pack_A6XX_SP_VS_OUTPUT_REG(__i, __struct_cast(A6XX_SP_VS_OUTPUT_REG) { __VA_ARGS__ })

struct A6XX_SP_VS_VPC_DEST_REG {
    uint32_t							outloc0;
    uint32_t							outloc1;
    uint32_t							outloc2;
    uint32_t							outloc3;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_VPC_DEST_REG(uint32_t __i, struct A6XX_SP_VS_VPC_DEST_REG fields)
{
#ifndef NDEBUG
    assert((fields.outloc0                           & 0xffffff00) == 0);
    assert((fields.outloc1                           & 0xffffff00) == 0);
    assert((fields.outloc2                           & 0xffffff00) == 0);
    assert((fields.outloc3                           & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a813 + 0x1*__i),
        .value =
            (fields.outloc0                           <<  0) |
            (fields.outloc1                           <<  8) |
            (fields.outloc2                           << 16) |
            (fields.outloc3                           << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_VPC_DEST_REG(__i, ...) pack_A6XX_SP_VS_VPC_DEST_REG(__i, __struct_cast(A6XX_SP_VS_VPC_DEST_REG) { __VA_ARGS__ })

struct A6XX_SP_VS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_vs_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_VS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_vs_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a81b,
        .value =
            (fields.sp_vs_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_VS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_VS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_VS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_BASE(struct A6XX_SP_VS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a81c,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_VS_BASE(...) pack_A6XX_SP_VS_BASE(__struct_cast(A6XX_SP_VS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_VS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_PVT_MEM_PARAM(struct A6XX_SP_VS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a81e,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_PVT_MEM_PARAM(...) pack_A6XX_SP_VS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_VS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_VS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_PVT_MEM_BASE(struct A6XX_SP_VS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a81f,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_VS_PVT_MEM_BASE(...) pack_A6XX_SP_VS_PVT_MEM_BASE(__struct_cast(A6XX_SP_VS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_VS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_PVT_MEM_SIZE(struct A6XX_SP_VS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a821,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_PVT_MEM_SIZE(...) pack_A6XX_SP_VS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_VS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_VS_TSIZE {
    uint32_t							sp_vs_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_TSIZE(struct A6XX_SP_VS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_vs_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a822,
        .value =
            (fields.sp_vs_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_TSIZE(...) pack_A6XX_SP_VS_TSIZE(__struct_cast(A6XX_SP_VS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_VS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_CONFIG(struct A6XX_SP_VS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a823,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_CONFIG(...) pack_A6XX_SP_VS_CONFIG(__struct_cast(A6XX_SP_VS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_VS_INSTR_SIZE {
    uint32_t							sp_vs_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_INSTR_SIZE(struct A6XX_SP_VS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_vs_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a824,
        .value =
            (fields.sp_vs_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_INSTR_SIZE(...) pack_A6XX_SP_VS_INSTR_SIZE(__struct_cast(A6XX_SP_VS_INSTR_SIZE) { __VA_ARGS__ })

struct A6XX_SP_VS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_VS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a825,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_VS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_VS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_VS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_VS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_VS_HYSTERESIS(...) pack_A6XX_SP_VS_HYSTERESIS(__struct_cast(A6XX_SP_VS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_VS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_VS_HYSTERESIS(...) pack_A8XX_SP_VS_HYSTERESIS(__struct_cast(A8XX_SP_VS_HYSTERESIS) { __VA_ARGS__ })

struct A7XX_SP_VS_VGS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_VS_VGS_CNTL(...) pack_A7XX_SP_VS_VGS_CNTL(__struct_cast(A7XX_SP_VS_VGS_CNTL) { __VA_ARGS__ })

struct A6XX_SP_HS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    bool							earlypreamble;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_CNTL_0(struct A6XX_SP_HS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x481fffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a830,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.earlypreamble                     << 20) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_CNTL_0(...) pack_A6XX_SP_HS_CNTL_0(__struct_cast(A6XX_SP_HS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_HS_CNTL_1 {
    uint32_t							sp_hs_cntl_1;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_CNTL_1(struct A6XX_SP_HS_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.sp_hs_cntl_1                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a831,
        .value =
            (fields.sp_hs_cntl_1                      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_CNTL_1(...) pack_A6XX_SP_HS_CNTL_1(__struct_cast(A6XX_SP_HS_CNTL_1) { __VA_ARGS__ })

struct A6XX_SP_HS_BOOLEAN_CF_MASK {
    uint32_t							sp_hs_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_BOOLEAN_CF_MASK(struct A6XX_SP_HS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_hs_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a832,
        .value =
            (fields.sp_hs_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_HS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_HS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_HS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_hs_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_HS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_hs_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a833,
        .value =
            (fields.sp_hs_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_HS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_HS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_HS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_BASE(struct A6XX_SP_HS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a834,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_HS_BASE(...) pack_A6XX_SP_HS_BASE(__struct_cast(A6XX_SP_HS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_HS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_PVT_MEM_PARAM(struct A6XX_SP_HS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a836,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_PVT_MEM_PARAM(...) pack_A6XX_SP_HS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_HS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_HS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_PVT_MEM_BASE(struct A6XX_SP_HS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a837,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_HS_PVT_MEM_BASE(...) pack_A6XX_SP_HS_PVT_MEM_BASE(__struct_cast(A6XX_SP_HS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_HS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_PVT_MEM_SIZE(struct A6XX_SP_HS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a839,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_PVT_MEM_SIZE(...) pack_A6XX_SP_HS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_HS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_HS_TSIZE {
    uint32_t							sp_hs_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_TSIZE(struct A6XX_SP_HS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_hs_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a83a,
        .value =
            (fields.sp_hs_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_TSIZE(...) pack_A6XX_SP_HS_TSIZE(__struct_cast(A6XX_SP_HS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_HS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_CONFIG(struct A6XX_SP_HS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a83b,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_CONFIG(...) pack_A6XX_SP_HS_CONFIG(__struct_cast(A6XX_SP_HS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_HS_INSTR_SIZE {
    uint32_t							sp_hs_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_INSTR_SIZE(struct A6XX_SP_HS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_hs_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a83c,
        .value =
            (fields.sp_hs_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_INSTR_SIZE(...) pack_A6XX_SP_HS_INSTR_SIZE(__struct_cast(A6XX_SP_HS_INSTR_SIZE) { __VA_ARGS__ })

struct A6XX_SP_HS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_HS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a83d,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_HS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_HS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_HS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_HS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_HS_HYSTERESIS(...) pack_A6XX_SP_HS_HYSTERESIS(__struct_cast(A6XX_SP_HS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_HS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_HS_HYSTERESIS(...) pack_A8XX_SP_HS_HYSTERESIS(__struct_cast(A8XX_SP_HS_HYSTERESIS) { __VA_ARGS__ })

struct A7XX_SP_HS_VGS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HS_VGS_CNTL(...) pack_A7XX_SP_HS_VGS_CNTL(__struct_cast(A7XX_SP_HS_VGS_CNTL) { __VA_ARGS__ })

struct A6XX_SP_DS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    bool							earlypreamble;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_CNTL_0(struct A6XX_SP_DS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x481fffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a840,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.earlypreamble                     << 20) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_CNTL_0(...) pack_A6XX_SP_DS_CNTL_0(__struct_cast(A6XX_SP_DS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_DS_BOOLEAN_CF_MASK {
    uint32_t							sp_ds_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_BOOLEAN_CF_MASK(struct A6XX_SP_DS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_ds_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a841,
        .value =
            (fields.sp_ds_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_DS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_DS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_DS_OUTPUT_CNTL {
    uint32_t							out;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_OUTPUT_CNTL(struct A6XX_SP_DS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.out                               & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a842,
        .value =
            (fields.out                               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_OUTPUT_CNTL(...) pack_A6XX_SP_DS_OUTPUT_CNTL(__struct_cast(A6XX_SP_DS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_SP_DS_OUTPUT_REG {
    uint32_t							a_regid;
    uint32_t							a_compmask;
    uint32_t							b_regid;
    uint32_t							b_compmask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_OUTPUT_REG(uint32_t __i, struct A6XX_SP_DS_OUTPUT_REG fields)
{
#ifndef NDEBUG
    assert((fields.a_regid                           & 0xffffff00) == 0);
    assert((fields.a_compmask                        & 0xfffffff0) == 0);
    assert((fields.b_regid                           & 0xffffff00) == 0);
    assert((fields.b_compmask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a843 + 0x1*__i),
        .value =
            (fields.a_regid                           <<  0) |
            (fields.a_compmask                        <<  8) |
            (fields.b_regid                           << 16) |
            (fields.b_compmask                        << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_OUTPUT_REG(__i, ...) pack_A6XX_SP_DS_OUTPUT_REG(__i, __struct_cast(A6XX_SP_DS_OUTPUT_REG) { __VA_ARGS__ })

struct A6XX_SP_DS_VPC_DEST_REG {
    uint32_t							outloc0;
    uint32_t							outloc1;
    uint32_t							outloc2;
    uint32_t							outloc3;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_VPC_DEST_REG(uint32_t __i, struct A6XX_SP_DS_VPC_DEST_REG fields)
{
#ifndef NDEBUG
    assert((fields.outloc0                           & 0xffffff00) == 0);
    assert((fields.outloc1                           & 0xffffff00) == 0);
    assert((fields.outloc2                           & 0xffffff00) == 0);
    assert((fields.outloc3                           & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a853 + 0x1*__i),
        .value =
            (fields.outloc0                           <<  0) |
            (fields.outloc1                           <<  8) |
            (fields.outloc2                           << 16) |
            (fields.outloc3                           << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_VPC_DEST_REG(__i, ...) pack_A6XX_SP_DS_VPC_DEST_REG(__i, __struct_cast(A6XX_SP_DS_VPC_DEST_REG) { __VA_ARGS__ })

struct A6XX_SP_DS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_ds_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_DS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_ds_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a85b,
        .value =
            (fields.sp_ds_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_DS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_DS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_DS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_BASE(struct A6XX_SP_DS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a85c,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_DS_BASE(...) pack_A6XX_SP_DS_BASE(__struct_cast(A6XX_SP_DS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_DS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_PVT_MEM_PARAM(struct A6XX_SP_DS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a85e,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_PVT_MEM_PARAM(...) pack_A6XX_SP_DS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_DS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_DS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_PVT_MEM_BASE(struct A6XX_SP_DS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a85f,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_DS_PVT_MEM_BASE(...) pack_A6XX_SP_DS_PVT_MEM_BASE(__struct_cast(A6XX_SP_DS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_DS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_PVT_MEM_SIZE(struct A6XX_SP_DS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a861,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_PVT_MEM_SIZE(...) pack_A6XX_SP_DS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_DS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_DS_TSIZE {
    uint32_t							sp_ds_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_TSIZE(struct A6XX_SP_DS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_ds_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a862,
        .value =
            (fields.sp_ds_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_TSIZE(...) pack_A6XX_SP_DS_TSIZE(__struct_cast(A6XX_SP_DS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_DS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_CONFIG(struct A6XX_SP_DS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a863,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_CONFIG(...) pack_A6XX_SP_DS_CONFIG(__struct_cast(A6XX_SP_DS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_DS_INSTR_SIZE {
    uint32_t							sp_ds_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_INSTR_SIZE(struct A6XX_SP_DS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_ds_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a864,
        .value =
            (fields.sp_ds_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_INSTR_SIZE(...) pack_A6XX_SP_DS_INSTR_SIZE(__struct_cast(A6XX_SP_DS_INSTR_SIZE) { __VA_ARGS__ })

struct A6XX_SP_DS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_DS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a865,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_DS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_DS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_DS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_DS_HYSTERESIS(...) pack_A6XX_SP_DS_HYSTERESIS(__struct_cast(A6XX_SP_DS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_DS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_DS_HYSTERESIS(...) pack_A8XX_SP_DS_HYSTERESIS(__struct_cast(A8XX_SP_DS_HYSTERESIS) { __VA_ARGS__ })

struct A7XX_SP_DS_VGS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DS_VGS_CNTL(...) pack_A7XX_SP_DS_VGS_CNTL(__struct_cast(A7XX_SP_DS_VGS_CNTL) { __VA_ARGS__ })

struct A6XX_SP_GS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    bool							earlypreamble;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_CNTL_0(struct A6XX_SP_GS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x481fffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a870,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.earlypreamble                     << 20) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_CNTL_0(...) pack_A6XX_SP_GS_CNTL_0(__struct_cast(A6XX_SP_GS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_GS_CNTL_1 {
    uint32_t							sp_gs_cntl_1;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_CNTL_1(struct A6XX_SP_GS_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.sp_gs_cntl_1                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a871,
        .value =
            (fields.sp_gs_cntl_1                      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_CNTL_1(...) pack_A6XX_SP_GS_CNTL_1(__struct_cast(A6XX_SP_GS_CNTL_1) { __VA_ARGS__ })

struct A6XX_SP_GS_BOOLEAN_CF_MASK {
    uint32_t							sp_gs_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_BOOLEAN_CF_MASK(struct A6XX_SP_GS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_gs_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a872,
        .value =
            (fields.sp_gs_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_GS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_GS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_GS_OUTPUT_CNTL {
    uint32_t							out;
    uint32_t							flags_regid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_OUTPUT_CNTL(struct A6XX_SP_GS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.out                               & 0xffffffc0) == 0);
    assert((fields.flags_regid                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00003fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a873,
        .value =
            (fields.out                               <<  0) |
            (fields.flags_regid                       <<  6) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_OUTPUT_CNTL(...) pack_A6XX_SP_GS_OUTPUT_CNTL(__struct_cast(A6XX_SP_GS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_SP_GS_OUTPUT_REG {
    uint32_t							a_regid;
    uint32_t							a_compmask;
    uint32_t							b_regid;
    uint32_t							b_compmask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_OUTPUT_REG(uint32_t __i, struct A6XX_SP_GS_OUTPUT_REG fields)
{
#ifndef NDEBUG
    assert((fields.a_regid                           & 0xffffff00) == 0);
    assert((fields.a_compmask                        & 0xfffffff0) == 0);
    assert((fields.b_regid                           & 0xffffff00) == 0);
    assert((fields.b_compmask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a874 + 0x1*__i),
        .value =
            (fields.a_regid                           <<  0) |
            (fields.a_compmask                        <<  8) |
            (fields.b_regid                           << 16) |
            (fields.b_compmask                        << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_OUTPUT_REG(__i, ...) pack_A6XX_SP_GS_OUTPUT_REG(__i, __struct_cast(A6XX_SP_GS_OUTPUT_REG) { __VA_ARGS__ })

struct A6XX_SP_GS_VPC_DEST_REG {
    uint32_t							outloc0;
    uint32_t							outloc1;
    uint32_t							outloc2;
    uint32_t							outloc3;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_VPC_DEST_REG(uint32_t __i, struct A6XX_SP_GS_VPC_DEST_REG fields)
{
#ifndef NDEBUG
    assert((fields.outloc0                           & 0xffffff00) == 0);
    assert((fields.outloc1                           & 0xffffff00) == 0);
    assert((fields.outloc2                           & 0xffffff00) == 0);
    assert((fields.outloc3                           & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a884 + 0x1*__i),
        .value =
            (fields.outloc0                           <<  0) |
            (fields.outloc1                           <<  8) |
            (fields.outloc2                           << 16) |
            (fields.outloc3                           << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_VPC_DEST_REG(__i, ...) pack_A6XX_SP_GS_VPC_DEST_REG(__i, __struct_cast(A6XX_SP_GS_VPC_DEST_REG) { __VA_ARGS__ })

struct A6XX_SP_GS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_gs_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_GS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_gs_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a88c,
        .value =
            (fields.sp_gs_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_GS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_GS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_GS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_BASE(struct A6XX_SP_GS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a88d,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_GS_BASE(...) pack_A6XX_SP_GS_BASE(__struct_cast(A6XX_SP_GS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_PVT_MEM_PARAM(struct A6XX_SP_GS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a88f,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_PVT_MEM_PARAM(...) pack_A6XX_SP_GS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_GS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_GS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_PVT_MEM_BASE(struct A6XX_SP_GS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a890,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_GS_PVT_MEM_BASE(...) pack_A6XX_SP_GS_PVT_MEM_BASE(__struct_cast(A6XX_SP_GS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_PVT_MEM_SIZE(struct A6XX_SP_GS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a892,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_PVT_MEM_SIZE(...) pack_A6XX_SP_GS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_GS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_GS_TSIZE {
    uint32_t							sp_gs_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_TSIZE(struct A6XX_SP_GS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_gs_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a893,
        .value =
            (fields.sp_gs_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_TSIZE(...) pack_A6XX_SP_GS_TSIZE(__struct_cast(A6XX_SP_GS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_GS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_CONFIG(struct A6XX_SP_GS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a894,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_CONFIG(...) pack_A6XX_SP_GS_CONFIG(__struct_cast(A6XX_SP_GS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_GS_INSTR_SIZE {
    uint32_t							sp_gs_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_INSTR_SIZE(struct A6XX_SP_GS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_gs_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a895,
        .value =
            (fields.sp_gs_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_INSTR_SIZE(...) pack_A6XX_SP_GS_INSTR_SIZE(__struct_cast(A6XX_SP_GS_INSTR_SIZE) { __VA_ARGS__ })

struct A6XX_SP_GS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_GS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a896,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_GS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_GS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_GS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_GS_HYSTERESIS(...) pack_A6XX_SP_GS_HYSTERESIS(__struct_cast(A6XX_SP_GS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_GS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_GS_HYSTERESIS(...) pack_A8XX_SP_GS_HYSTERESIS(__struct_cast(A8XX_SP_GS_HYSTERESIS) { __VA_ARGS__ })

struct A7XX_SP_GS_VGS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_GS_VGS_CNTL(...) pack_A7XX_SP_GS_VGS_CNTL(__struct_cast(A7XX_SP_GS_VGS_CNTL) { __VA_ARGS__ })

struct A6XX_SP_VS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_SAMPLER_BASE(struct A6XX_SP_VS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8a0,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_VS_SAMPLER_BASE(...) pack_A6XX_SP_VS_SAMPLER_BASE(__struct_cast(A6XX_SP_VS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_HS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_SAMPLER_BASE(struct A6XX_SP_HS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8a2,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_HS_SAMPLER_BASE(...) pack_A6XX_SP_HS_SAMPLER_BASE(__struct_cast(A6XX_SP_HS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_DS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_SAMPLER_BASE(struct A6XX_SP_DS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8a4,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_DS_SAMPLER_BASE(...) pack_A6XX_SP_DS_SAMPLER_BASE(__struct_cast(A6XX_SP_DS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_SAMPLER_BASE(struct A6XX_SP_GS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8a6,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_GS_SAMPLER_BASE(...) pack_A6XX_SP_GS_SAMPLER_BASE(__struct_cast(A6XX_SP_GS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_VS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_VS_TEXMEMOBJ_BASE(struct A6XX_SP_VS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8a8,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_VS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_VS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_VS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_HS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_HS_TEXMEMOBJ_BASE(struct A6XX_SP_HS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8aa,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_HS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_HS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_HS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_DS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DS_TEXMEMOBJ_BASE(struct A6XX_SP_DS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8ac,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_DS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_DS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_DS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GS_TEXMEMOBJ_BASE(struct A6XX_SP_GS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a8ae,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_GS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_GS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_GS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_PS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    enum a6xx_threadsize					threadsize;
    bool							unk21;
    bool							varying;
    bool							lodpixmask;
    bool							inoutregoverlap;
    bool							unk25;
    bool							pixlodenable;
    bool							earlypreamble;
    bool							mergedregs;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_CNTL_0(struct A6XX_SP_PS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.threadsize                        & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0xdfffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a980,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.threadsize                        << 20) |
            (fields.unk21                             << 21) |
            (fields.varying                           << 22) |
            (fields.lodpixmask                        << 23) |
            (fields.inoutregoverlap                   << 24) |
            (fields.unk25                             << 25) |
            (fields.pixlodenable                      << 26) |
            (fields.earlypreamble                     << 28) |
            (fields.mergedregs                        << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_CNTL_0(...) pack_A6XX_SP_PS_CNTL_0(__struct_cast(A6XX_SP_PS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_PS_BOOLEAN_CF_MASK {
    uint32_t							sp_ps_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_BOOLEAN_CF_MASK(struct A6XX_SP_PS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_ps_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a981,
        .value =
            (fields.sp_ps_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_PS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_PS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_PS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_ps_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_PS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_ps_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a982,
        .value =
            (fields.sp_ps_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_PS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_PS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_PS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_BASE(struct A6XX_SP_PS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a983,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_PS_BASE(...) pack_A6XX_SP_PS_BASE(__struct_cast(A6XX_SP_PS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_PS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_PVT_MEM_PARAM(struct A6XX_SP_PS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a985,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_PVT_MEM_PARAM(...) pack_A6XX_SP_PS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_PS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_PS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_PVT_MEM_BASE(struct A6XX_SP_PS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a986,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_PS_PVT_MEM_BASE(...) pack_A6XX_SP_PS_PVT_MEM_BASE(__struct_cast(A6XX_SP_PS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_PS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_PVT_MEM_SIZE(struct A6XX_SP_PS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a988,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_PVT_MEM_SIZE(...) pack_A6XX_SP_PS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_PS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_BLEND_CNTL {
    uint32_t							enable_blend;
    bool							independent_blend_en;
    bool							dual_color_in_enable;
    bool							alpha_to_coverage;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_BLEND_CNTL(...) pack_A6XX_SP_BLEND_CNTL(__struct_cast(A6XX_SP_BLEND_CNTL) { __VA_ARGS__ })

struct A8XX_SP_BLEND_CNTL {
    uint32_t							enable_blend;
    bool							independent_blend_en;
    bool							dual_color_in_enable;
    bool							alpha_to_coverage;
    bool							alpha_to_one;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_BLEND_CNTL(...) pack_A8XX_SP_BLEND_CNTL(__struct_cast(A8XX_SP_BLEND_CNTL) { __VA_ARGS__ })

struct A6XX_SP_SRGB_CNTL {
    bool							srgb_mrt0;
    bool							srgb_mrt1;
    bool							srgb_mrt2;
    bool							srgb_mrt3;
    bool							srgb_mrt4;
    bool							srgb_mrt5;
    bool							srgb_mrt6;
    bool							srgb_mrt7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_SRGB_CNTL(struct A6XX_SP_SRGB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a98a,
        .value =
            (fields.srgb_mrt0                         <<  0) |
            (fields.srgb_mrt1                         <<  1) |
            (fields.srgb_mrt2                         <<  2) |
            (fields.srgb_mrt3                         <<  3) |
            (fields.srgb_mrt4                         <<  4) |
            (fields.srgb_mrt5                         <<  5) |
            (fields.srgb_mrt6                         <<  6) |
            (fields.srgb_mrt7                         <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_SRGB_CNTL(...) pack_A6XX_SP_SRGB_CNTL(__struct_cast(A6XX_SP_SRGB_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PS_OUTPUT_MASK {
    uint32_t							rt0;
    uint32_t							rt1;
    uint32_t							rt2;
    uint32_t							rt3;
    uint32_t							rt4;
    uint32_t							rt5;
    uint32_t							rt6;
    uint32_t							rt7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_OUTPUT_MASK(struct A6XX_SP_PS_OUTPUT_MASK fields)
{
#ifndef NDEBUG
    assert((fields.rt0                               & 0xfffffff0) == 0);
    assert((fields.rt1                               & 0xfffffff0) == 0);
    assert((fields.rt2                               & 0xfffffff0) == 0);
    assert((fields.rt3                               & 0xfffffff0) == 0);
    assert((fields.rt4                               & 0xfffffff0) == 0);
    assert((fields.rt5                               & 0xfffffff0) == 0);
    assert((fields.rt6                               & 0xfffffff0) == 0);
    assert((fields.rt7                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a98b,
        .value =
            (fields.rt0                               <<  0) |
            (fields.rt1                               <<  4) |
            (fields.rt2                               <<  8) |
            (fields.rt3                               << 12) |
            (fields.rt4                               << 16) |
            (fields.rt5                               << 20) |
            (fields.rt6                               << 24) |
            (fields.rt7                               << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_OUTPUT_MASK(...) pack_A6XX_SP_PS_OUTPUT_MASK(__struct_cast(A6XX_SP_PS_OUTPUT_MASK) { __VA_ARGS__ })

struct A6XX_SP_PS_OUTPUT_CNTL {
    bool							dual_color_in_enable;
    uint32_t							depth_regid;
    uint32_t							sampmask_regid;
    uint32_t							stencilref_regid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_OUTPUT_CNTL(struct A6XX_SP_PS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.depth_regid                       & 0xffffff00) == 0);
    assert((fields.sampmask_regid                    & 0xffffff00) == 0);
    assert((fields.stencilref_regid                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffff01) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a98c,
        .value =
            (fields.dual_color_in_enable              <<  0) |
            (fields.depth_regid                       <<  8) |
            (fields.sampmask_regid                    << 16) |
            (fields.stencilref_regid                  << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_OUTPUT_CNTL(...) pack_A6XX_SP_PS_OUTPUT_CNTL(__struct_cast(A6XX_SP_PS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PS_MRT_CNTL {
    uint32_t							mrt;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_MRT_CNTL(struct A6XX_SP_PS_MRT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mrt                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a98d,
        .value =
            (fields.mrt                               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_MRT_CNTL(...) pack_A6XX_SP_PS_MRT_CNTL(__struct_cast(A6XX_SP_PS_MRT_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PS_OUTPUT_REG {
    uint32_t							regid;
    bool							half_precision;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_OUTPUT_REG(uint32_t __i, struct A6XX_SP_PS_OUTPUT_REG fields)
{
#ifndef NDEBUG
    assert((fields.regid                             & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a98e + 0x1*__i),
        .value =
            (fields.regid                             <<  0) |
            (fields.half_precision                    <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_OUTPUT_REG(__i, ...) pack_A6XX_SP_PS_OUTPUT_REG(__i, __struct_cast(A6XX_SP_PS_OUTPUT_REG) { __VA_ARGS__ })

struct A6XX_SP_PS_MRT_REG {
    enum a6xx_format						color_format;
    bool							color_sint;
    bool							color_uint;
    bool							unk10;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_MRT_REG(uint32_t __i, struct A6XX_SP_PS_MRT_REG fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a996 + 0x1*__i),
        .value =
            (fields.color_format                      <<  0) |
            (fields.color_sint                        <<  8) |
            (fields.color_uint                        <<  9) |
            (fields.unk10                             << 10) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_MRT_REG(__i, ...) pack_A6XX_SP_PS_MRT_REG(__i, __struct_cast(A6XX_SP_PS_MRT_REG) { __VA_ARGS__ })

struct A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL {
    uint32_t							count;
    bool							ij_write_disable;
    bool							endofquad;
    bool							write_color_to_output;
    uint32_t							constslotid;
    uint32_t							constslotid4coord;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL(struct A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.count                             & 0xfffffff8) == 0);
    assert((fields.constslotid                       & 0xfffffe00) == 0);
    assert((fields.constslotid4coord                 & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x01ff7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a99e,
        .value =
            (fields.count                             <<  0) |
            (fields.ij_write_disable                  <<  3) |
            (fields.endofquad                         <<  4) |
            (fields.write_color_to_output             <<  5) |
            (fields.constslotid                       <<  6) |
            (fields.constslotid4coord                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL(...) pack_A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL(__struct_cast(A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PS_INITIAL_TEX_LOAD_CMD {
    uint32_t							src;
    uint32_t							samp_id;
    uint32_t							tex_id;
    uint32_t							dst;
    uint32_t							wrmask;
    bool							half;
    bool							unk27;
    bool							bindless;
    enum a6xx_tex_prefetch_cmd					cmd;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD(__i, ...) pack_A6XX_SP_PS_INITIAL_TEX_LOAD_CMD(__i, __struct_cast(A6XX_SP_PS_INITIAL_TEX_LOAD_CMD) { __VA_ARGS__ })

struct A7XX_SP_PS_INITIAL_TEX_LOAD_CMD {
    uint32_t							src;
    uint32_t							samp_id;
    uint32_t							tex_id;
    uint32_t							dst;
    uint32_t							wrmask;
    bool							half;
    bool							bindless;
    enum a6xx_tex_prefetch_cmd					cmd;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD(__i, ...) pack_A7XX_SP_PS_INITIAL_TEX_LOAD_CMD(__i, __struct_cast(A7XX_SP_PS_INITIAL_TEX_LOAD_CMD) { __VA_ARGS__ })

struct A6XX_SP_PS_INITIAL_TEX_INDEX_CMD {
    uint32_t							samp_id;
    uint32_t							tex_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_INITIAL_TEX_INDEX_CMD(uint32_t __i, struct A6XX_SP_PS_INITIAL_TEX_INDEX_CMD fields)
{
#ifndef NDEBUG
    assert((fields.samp_id                           & 0xffff0000) == 0);
    assert((fields.tex_id                            & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000a9a3 + 0x1*__i),
        .value =
            (fields.samp_id                           <<  0) |
            (fields.tex_id                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_INITIAL_TEX_INDEX_CMD(__i, ...) pack_A6XX_SP_PS_INITIAL_TEX_INDEX_CMD(__i, __struct_cast(A6XX_SP_PS_INITIAL_TEX_INDEX_CMD) { __VA_ARGS__ })

struct A6XX_SP_PS_TSIZE {
    uint32_t							sp_ps_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_TSIZE(struct A6XX_SP_PS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_ps_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9a7,
        .value =
            (fields.sp_ps_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_TSIZE(...) pack_A6XX_SP_PS_TSIZE(__struct_cast(A6XX_SP_PS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_UNKNOWN_A9A8 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_UNKNOWN_A9A8(struct A6XX_SP_UNKNOWN_A9A8 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9a8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_UNKNOWN_A9A8(...) pack_A6XX_SP_UNKNOWN_A9A8(__struct_cast(A6XX_SP_UNKNOWN_A9A8) { __VA_ARGS__ })

struct A6XX_SP_PS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_PS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9a9,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_PS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_PS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_PS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_HYSTERESIS(...) pack_A6XX_SP_PS_HYSTERESIS(__struct_cast(A6XX_SP_PS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_PS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_PS_HYSTERESIS(...) pack_A8XX_SP_PS_HYSTERESIS(__struct_cast(A8XX_SP_PS_HYSTERESIS) { __VA_ARGS__ })

struct A6XX_SP_CS_CNTL_0 {
    enum a3xx_threadmode					threadmode;
    uint32_t							halfregfootprint;
    uint32_t							fullregfootprint;
    bool							unk13;
    uint32_t							branchstack;
    uint32_t							fullregfootprint_lsb;
    uint32_t							halfregfootprint_lsb;
    enum a6xx_threadsize					threadsize;
    bool							unk21;
    bool							unk22;
    bool							earlypreamble;
    bool							mergedregs;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_CNTL_0(struct A6XX_SP_CS_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.threadmode                        & 0xfffffffe) == 0);
    assert((fields.halfregfootprint                  & 0xffffffc0) == 0);
    assert((fields.fullregfootprint                  & 0xffffffc0) == 0);
    assert((fields.branchstack                       & 0xffffffc0) == 0);
    assert((fields.fullregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.halfregfootprint_lsb              & 0xfffffffe) == 0);
    assert((fields.threadsize                        & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0xc8ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b0,
        .value =
            (fields.threadmode                        <<  0) |
            (fields.halfregfootprint                  <<  1) |
            (fields.fullregfootprint                  <<  7) |
            (fields.unk13                             << 13) |
            (fields.branchstack                       << 14) |
            (fields.fullregfootprint_lsb              << 27) |
            (fields.halfregfootprint_lsb              << 30) |
            (fields.threadsize                        << 20) |
            (fields.unk21                             << 21) |
            (fields.unk22                             << 22) |
            (fields.earlypreamble                     << 23) |
            (fields.mergedregs                        << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_CNTL_0(...) pack_A6XX_SP_CS_CNTL_0(__struct_cast(A6XX_SP_CS_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_CS_CNTL_1 {
    uint32_t							shared_size;
    enum a6xx_const_ram_mode					constantrammode;
    bool							alt_lm_encode;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_CNTL_1(struct A6XX_SP_CS_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.shared_size                       & 0xffffffe0) == 0);
    assert((fields.constantrammode                   & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0400007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b1,
        .value =
            (fields.shared_size                       <<  0) |
            (fields.constantrammode                   <<  5) |
            (fields.alt_lm_encode                     << 26) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_CNTL_1(...) pack_A6XX_SP_CS_CNTL_1(__struct_cast(A6XX_SP_CS_CNTL_1) { __VA_ARGS__ })

struct A6XX_SP_CS_BOOLEAN_CF_MASK {
    uint32_t							sp_cs_boolean_cf_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_BOOLEAN_CF_MASK(struct A6XX_SP_CS_BOOLEAN_CF_MASK fields)
{
#ifndef NDEBUG
    assert((fields.sp_cs_boolean_cf_mask             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b2,
        .value =
            (fields.sp_cs_boolean_cf_mask             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_BOOLEAN_CF_MASK(...) pack_A6XX_SP_CS_BOOLEAN_CF_MASK(__struct_cast(A6XX_SP_CS_BOOLEAN_CF_MASK) { __VA_ARGS__ })

struct A6XX_SP_CS_PROGRAM_COUNTER_OFFSET {
    uint32_t							sp_cs_program_counter_offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_PROGRAM_COUNTER_OFFSET(struct A6XX_SP_CS_PROGRAM_COUNTER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.sp_cs_program_counter_offset      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b3,
        .value =
            (fields.sp_cs_program_counter_offset      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_PROGRAM_COUNTER_OFFSET(...) pack_A6XX_SP_CS_PROGRAM_COUNTER_OFFSET(__struct_cast(A6XX_SP_CS_PROGRAM_COUNTER_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_CS_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_BASE(struct A6XX_SP_CS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b4,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_CS_BASE(...) pack_A6XX_SP_CS_BASE(__struct_cast(A6XX_SP_CS_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_PVT_MEM_PARAM {
    uint32_t							memsizeperitem;
    uint32_t							hwstacksizeperthread;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_PVT_MEM_PARAM(struct A6XX_SP_CS_PVT_MEM_PARAM fields)
{
#ifndef NDEBUG
    assert(((fields.memsizeperitem >> 9)             & 0xffffff00) == 0);
    assert((fields.hwstacksizeperthread              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff0000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b6,
        .value =
            ((fields.memsizeperitem >> 9)             <<  0) |
            (fields.hwstacksizeperthread              << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_PVT_MEM_PARAM(...) pack_A6XX_SP_CS_PVT_MEM_PARAM(__struct_cast(A6XX_SP_CS_PVT_MEM_PARAM) { __VA_ARGS__ })

struct A6XX_SP_CS_PVT_MEM_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_PVT_MEM_BASE(struct A6XX_SP_CS_PVT_MEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b7,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_CS_PVT_MEM_BASE(...) pack_A6XX_SP_CS_PVT_MEM_BASE(__struct_cast(A6XX_SP_CS_PVT_MEM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_PVT_MEM_SIZE {
    uint32_t							totalpvtmemsize;
    bool							perwavememlayout;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_PVT_MEM_SIZE(struct A6XX_SP_CS_PVT_MEM_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.totalpvtmemsize >> 12)           & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x8003ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9b9,
        .value =
            ((fields.totalpvtmemsize >> 12)           <<  0) |
            (fields.perwavememlayout                  << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_PVT_MEM_SIZE(...) pack_A6XX_SP_CS_PVT_MEM_SIZE(__struct_cast(A6XX_SP_CS_PVT_MEM_SIZE) { __VA_ARGS__ })

struct A6XX_SP_CS_TSIZE {
    uint32_t							sp_cs_tsize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_TSIZE(struct A6XX_SP_CS_TSIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_cs_tsize                       & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9ba,
        .value =
            (fields.sp_cs_tsize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_TSIZE(...) pack_A6XX_SP_CS_TSIZE(__struct_cast(A6XX_SP_CS_TSIZE) { __VA_ARGS__ })

struct A6XX_SP_CS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_CONFIG(struct A6XX_SP_CS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9bb,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_CONFIG(...) pack_A6XX_SP_CS_CONFIG(__struct_cast(A6XX_SP_CS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_CS_INSTR_SIZE {
    uint32_t							sp_cs_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_INSTR_SIZE(struct A6XX_SP_CS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_cs_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9bc,
        .value =
            (fields.sp_cs_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_INSTR_SIZE(...) pack_A6XX_SP_CS_INSTR_SIZE(__struct_cast(A6XX_SP_CS_INSTR_SIZE) { __VA_ARGS__ })

struct A6XX_SP_CS_PVT_MEM_STACK_OFFSET {
    uint32_t							offset;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_PVT_MEM_STACK_OFFSET(struct A6XX_SP_CS_PVT_MEM_STACK_OFFSET fields)
{
#ifndef NDEBUG
    assert(((fields.offset >> 11)                    & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x0007ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9bd,
        .value =
            ((fields.offset >> 11)                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_PVT_MEM_STACK_OFFSET(...) pack_A6XX_SP_CS_PVT_MEM_STACK_OFFSET(__struct_cast(A6XX_SP_CS_PVT_MEM_STACK_OFFSET) { __VA_ARGS__ })

struct A6XX_SP_CS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_HYSTERESIS(...) pack_A6XX_SP_CS_HYSTERESIS(__struct_cast(A6XX_SP_CS_HYSTERESIS) { __VA_ARGS__ })

struct A8XX_SP_CS_HYSTERESIS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_CS_HYSTERESIS(...) pack_A8XX_SP_CS_HYSTERESIS(__struct_cast(A8XX_SP_CS_HYSTERESIS) { __VA_ARGS__ })

struct A7XX_SP_CS_VGS_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_VGS_CNTL(...) pack_A7XX_SP_CS_VGS_CNTL(__struct_cast(A7XX_SP_CS_VGS_CNTL) { __VA_ARGS__ })

struct A6XX_SP_CS_WIE_CNTL_0 {
    uint32_t							wgidconstid;
    uint32_t							wgsizeconstid;
    uint32_t							wgoffsetconstid;
    uint32_t							localidregid;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_WIE_CNTL_0(struct A6XX_SP_CS_WIE_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.wgidconstid                       & 0xffffff00) == 0);
    assert((fields.wgsizeconstid                     & 0xffffff00) == 0);
    assert((fields.wgoffsetconstid                   & 0xffffff00) == 0);
    assert((fields.localidregid                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9c2,
        .value =
            (fields.wgidconstid                       <<  0) |
            (fields.wgsizeconstid                     <<  8) |
            (fields.wgoffsetconstid                   << 16) |
            (fields.localidregid                      << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_WIE_CNTL_0(...) pack_A6XX_SP_CS_WIE_CNTL_0(__struct_cast(A6XX_SP_CS_WIE_CNTL_0) { __VA_ARGS__ })

struct A6XX_SP_CS_WIE_CNTL_1 {
    uint32_t							linearlocalidregid;
    bool							single_sp_core;
    enum a6xx_threadsize					threadsize;
    bool							threadsize_scalar;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_WIE_CNTL_1(...) pack_A6XX_SP_CS_WIE_CNTL_1(__struct_cast(A6XX_SP_CS_WIE_CNTL_1) { __VA_ARGS__ })

struct A7XX_SP_CS_WIE_CNTL_1 {
    uint32_t							linearlocalidregid;
    enum a6xx_threadsize					threadsize;
    bool							threadsize_scalar;
    enum a7xx_workitem_rast_order				workitemrastorder;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_WIE_CNTL_1(...) pack_A7XX_SP_CS_WIE_CNTL_1(__struct_cast(A7XX_SP_CS_WIE_CNTL_1) { __VA_ARGS__ })

struct A6XX_SP_PS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_SAMPLER_BASE(struct A6XX_SP_PS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9e0,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_PS_SAMPLER_BASE(...) pack_A6XX_SP_PS_SAMPLER_BASE(__struct_cast(A6XX_SP_PS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_SAMPLER_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_SAMPLER_BASE(struct A6XX_SP_CS_SAMPLER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9e2,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_CS_SAMPLER_BASE(...) pack_A6XX_SP_CS_SAMPLER_BASE(__struct_cast(A6XX_SP_CS_SAMPLER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_PS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_TEXMEMOBJ_BASE(struct A6XX_SP_PS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9e4,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_PS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_PS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_PS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_TEXMEMOBJ_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_TEXMEMOBJ_BASE(struct A6XX_SP_CS_TEXMEMOBJ_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9e6,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_CS_TEXMEMOBJ_BASE(...) pack_A6XX_SP_CS_TEXMEMOBJ_BASE(__struct_cast(A6XX_SP_CS_TEXMEMOBJ_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_UAV_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_SP_CS_UAV_BASE(...) pack_A6XX_SP_CS_UAV_BASE(__struct_cast(A6XX_SP_CS_UAV_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_SP_CS_UAV_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_CS_UAV_BASE(...) pack_A7XX_SP_CS_UAV_BASE(__struct_cast(A7XX_SP_CS_UAV_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_CS_USIZE {
    uint32_t							sp_cs_usize;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_USIZE(struct A6XX_SP_CS_USIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_cs_usize                       & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000aa00,
        .value =
            (fields.sp_cs_usize                       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_USIZE(...) pack_A6XX_SP_CS_USIZE(__struct_cast(A6XX_SP_CS_USIZE) { __VA_ARGS__ })

struct A7XX_SP_PS_VGS_CNTL {
    uint32_t							sp_ps_vgs_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_VGS_CNTL(...) pack_A7XX_SP_PS_VGS_CNTL(__struct_cast(A7XX_SP_PS_VGS_CNTL) { __VA_ARGS__ })

struct A7XX_SP_PS_OUTPUT_CONST_CNTL {
    bool							enabled;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_OUTPUT_CONST_CNTL(...) pack_A7XX_SP_PS_OUTPUT_CONST_CNTL(__struct_cast(A7XX_SP_PS_OUTPUT_CONST_CNTL) { __VA_ARGS__ })

struct A7XX_SP_PS_OUTPUT_CONST_MASK {
    uint32_t							rt0;
    uint32_t							rt1;
    uint32_t							rt2;
    uint32_t							rt3;
    uint32_t							rt4;
    uint32_t							rt5;
    uint32_t							rt6;
    uint32_t							rt7;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_OUTPUT_CONST_MASK(...) pack_A7XX_SP_PS_OUTPUT_CONST_MASK(__struct_cast(A7XX_SP_PS_OUTPUT_CONST_MASK) { __VA_ARGS__ })

struct A8XX_SP_MRT_BLEND_CNTL_REG {
    bool							color_blend_en;
    bool							alpha_blend_en;
    uint32_t							component_write_mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_MRT_BLEND_CNTL_REG(__i, ...) pack_A8XX_SP_MRT_BLEND_CNTL_REG(__i, __struct_cast(A8XX_SP_MRT_BLEND_CNTL_REG) { __VA_ARGS__ })

struct A8XX_SP_ALPHA_TEST_CNTL {
    bool							alpha_test;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_ALPHA_TEST_CNTL(...) pack_A8XX_SP_ALPHA_TEST_CNTL(__struct_cast(A8XX_SP_ALPHA_TEST_CNTL) { __VA_ARGS__ })

struct A6XX_SP_UNKNOWN_AAF2 {
    uint32_t							sp_unknown_aaf2;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_UNKNOWN_AAF2(struct A6XX_SP_UNKNOWN_AAF2 fields)
{
#ifndef NDEBUG
    assert((fields.sp_unknown_aaf2                   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000aaf2,
        .value =
            (fields.sp_unknown_aaf2                   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_UNKNOWN_AAF2(...) pack_A6XX_SP_UNKNOWN_AAF2(__struct_cast(A6XX_SP_UNKNOWN_AAF2) { __VA_ARGS__ })

struct A6XX_SP_MODE_CNTL {
    bool							constant_demotion_enable;
    enum a6xx_isam_mode						isammode;
    bool							shared_consts_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_MODE_CNTL(struct A6XX_SP_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.isammode                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ab00,
        .value =
            (fields.constant_demotion_enable          <<  0) |
            (fields.isammode                          <<  1) |
            (fields.shared_consts_enable              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_MODE_CNTL(...) pack_A6XX_SP_MODE_CNTL(__struct_cast(A6XX_SP_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_AB01 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_UNKNOWN_AB01(...) pack_A7XX_SP_UNKNOWN_AB01(__struct_cast(A7XX_SP_UNKNOWN_AB01) { __VA_ARGS__ })

struct A7XX_SP_HLSQ_MODE_CNTL {
    bool							shared_consts_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HLSQ_MODE_CNTL(...) pack_A7XX_SP_HLSQ_MODE_CNTL(__struct_cast(A7XX_SP_HLSQ_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PS_CONFIG {
    bool							bindless_tex;
    bool							bindless_samp;
    bool							bindless_uav;
    bool							bindless_ubo;
    bool							enabled;
    uint32_t							ntex;
    uint32_t							nsamp;
    uint32_t							nuav;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_CONFIG(struct A6XX_SP_PS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.ntex                              & 0xffffff00) == 0);
    assert((fields.nsamp                             & 0xffffffe0) == 0);
    assert((fields.nuav                              & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x1fffff0f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ab04,
        .value =
            (fields.bindless_tex                      <<  0) |
            (fields.bindless_samp                     <<  1) |
            (fields.bindless_uav                      <<  2) |
            (fields.bindless_ubo                      <<  3) |
            (fields.enabled                           <<  8) |
            (fields.ntex                              <<  9) |
            (fields.nsamp                             << 17) |
            (fields.nuav                              << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_CONFIG(...) pack_A6XX_SP_PS_CONFIG(__struct_cast(A6XX_SP_PS_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_PS_INSTR_SIZE {
    uint32_t							sp_ps_instr_size;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PS_INSTR_SIZE(struct A6XX_SP_PS_INSTR_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.sp_ps_instr_size                  & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ab05,
        .value =
            (fields.sp_ps_instr_size                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PS_INSTR_SIZE(...) pack_A6XX_SP_PS_INSTR_SIZE(__struct_cast(A6XX_SP_PS_INSTR_SIZE) { __VA_ARGS__ })

struct A8XX_SP_BIN_SIZE {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_BIN_SIZE(...) pack_A8XX_SP_BIN_SIZE(__struct_cast(A8XX_SP_BIN_SIZE) { __VA_ARGS__ })

struct A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GFX_UAV_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GFX_UAV_BASE(struct A6XX_SP_GFX_UAV_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ab1a,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_SP_GFX_UAV_BASE(...) pack_A6XX_SP_GFX_UAV_BASE(__struct_cast(A6XX_SP_GFX_UAV_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_SP_GFX_USIZE {
    uint32_t							sp_gfx_usize;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_GFX_USIZE(...) pack_A6XX_SP_GFX_USIZE(__struct_cast(A6XX_SP_GFX_USIZE) { __VA_ARGS__ })

struct A8XX_SP_GFX_USIZE {
    uint32_t							sp_gfx_usize;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_GFX_USIZE(...) pack_A8XX_SP_GFX_USIZE(__struct_cast(A8XX_SP_GFX_USIZE) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_AB22 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_UNKNOWN_AB22(...) pack_A7XX_SP_UNKNOWN_AB22(__struct_cast(A7XX_SP_UNKNOWN_AB22) { __VA_ARGS__ })

struct A8XX_SP_UNKNOWN_AB23 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_UNKNOWN_AB23(...) pack_A8XX_SP_UNKNOWN_AB23(__struct_cast(A8XX_SP_UNKNOWN_AB23) { __VA_ARGS__ })

struct A6XX_SP_A2D_OUTPUT_INFO {
    bool							half_precision;
    enum a6xx_sp_a2d_output_ifmt_type				ifmt_type;
    enum a6xx_format						color_format;
    bool							srgb;
    uint32_t							mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_A2D_OUTPUT_INFO(...) pack_A6XX_SP_A2D_OUTPUT_INFO(__struct_cast(A6XX_SP_A2D_OUTPUT_INFO) { __VA_ARGS__ })

struct A7XX_SP_A2D_OUTPUT_INFO {
    bool							half_precision;
    enum a6xx_sp_a2d_output_ifmt_type				ifmt_type;
    enum a6xx_format						color_format;
    bool							srgb;
    uint32_t							mask;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_A2D_OUTPUT_INFO(...) pack_A7XX_SP_A2D_OUTPUT_INFO(__struct_cast(A7XX_SP_A2D_OUTPUT_INFO) { __VA_ARGS__ })

struct A6XX_SP_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_DBG_ECO_CNTL(struct A6XX_SP_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_DBG_ECO_CNTL(...) pack_A6XX_SP_DBG_ECO_CNTL(__struct_cast(A6XX_SP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_SP_ADDR_MODE_CNTL {
    enum a5xx_address_mode					sp_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_ADDR_MODE_CNTL(...) pack_A6XX_SP_ADDR_MODE_CNTL(__struct_cast(A6XX_SP_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_SP_SHADER_PROFILING {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_SHADER_PROFILING(...) pack_A8XX_SP_SHADER_PROFILING(__struct_cast(A8XX_SP_SHADER_PROFILING) { __VA_ARGS__ })

struct A6XX_SP_NC_MODE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_NC_MODE_CNTL(struct A6XX_SP_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae02,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_NC_MODE_CNTL(...) pack_A6XX_SP_NC_MODE_CNTL(__struct_cast(A6XX_SP_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_SP_CHICKEN_BITS {
    bool							eolm_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CHICKEN_BITS(struct A6XX_SP_CHICKEN_BITS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000002) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae03,
        .value =
            (fields.eolm_enable                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CHICKEN_BITS(...) pack_A6XX_SP_CHICKEN_BITS(__struct_cast(A6XX_SP_CHICKEN_BITS) { __VA_ARGS__ })

struct A6XX_SP_NC_MODE_CNTL_2 {
    bool							f16_no_inf;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_NC_MODE_CNTL_2(struct A6XX_SP_NC_MODE_CNTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000008) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae04,
        .value =
            (fields.f16_no_inf                        <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_NC_MODE_CNTL_2(...) pack_A6XX_SP_NC_MODE_CNTL_2(__struct_cast(A6XX_SP_NC_MODE_CNTL_2) { __VA_ARGS__ })

struct A8XX_SP_SS_CHICKEN_BITS_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_SS_CHICKEN_BITS_0(...) pack_A8XX_SP_SS_CHICKEN_BITS_0(__struct_cast(A8XX_SP_SS_CHICKEN_BITS_0) { __VA_ARGS__ })

struct A7XX_SP_ISDB_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_ISDB_CNTL(...) pack_A7XX_SP_ISDB_CNTL(__struct_cast(A7XX_SP_ISDB_CNTL) { __VA_ARGS__ })

struct A6XX_SP_PERFCTR_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PERFCTR_CNTL(struct A6XX_SP_PERFCTR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae07,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PERFCTR_CNTL(...) pack_A6XX_SP_PERFCTR_CNTL(__struct_cast(A6XX_SP_PERFCTR_CNTL) { __VA_ARGS__ })

struct A7XX_SP_CHICKEN_BITS_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CHICKEN_BITS_1(...) pack_A7XX_SP_CHICKEN_BITS_1(__struct_cast(A7XX_SP_CHICKEN_BITS_1) { __VA_ARGS__ })

struct A7XX_SP_CHICKEN_BITS_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CHICKEN_BITS_2(...) pack_A7XX_SP_CHICKEN_BITS_2(__struct_cast(A7XX_SP_CHICKEN_BITS_2) { __VA_ARGS__ })

struct A7XX_SP_CHICKEN_BITS_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CHICKEN_BITS_3(...) pack_A7XX_SP_CHICKEN_BITS_3(__struct_cast(A7XX_SP_CHICKEN_BITS_3) { __VA_ARGS__ })

struct A8XX_SP_CHICKEN_BITS_4 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_CHICKEN_BITS_4(...) pack_A8XX_SP_CHICKEN_BITS_4(__struct_cast(A8XX_SP_CHICKEN_BITS_4) { __VA_ARGS__ })

struct A6XX_SP_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_STATUS(struct A6XX_SP_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae0c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_STATUS(...) pack_A6XX_SP_STATUS(__struct_cast(A6XX_SP_STATUS) { __VA_ARGS__ })

struct A6XX_SP_PERFCTR_SHADER_MASK {
    bool							vs;
    bool							hs;
    bool							ds;
    bool							gs;
    bool							fs;
    bool							cs;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_PERFCTR_SHADER_MASK(struct A6XX_SP_PERFCTR_SHADER_MASK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae0f,
        .value =
            (fields.vs                                <<  0) |
            (fields.hs                                <<  1) |
            (fields.ds                                <<  2) |
            (fields.gs                                <<  3) |
            (fields.fs                                <<  4) |
            (fields.cs                                <<  5) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_PERFCTR_SHADER_MASK(...) pack_A6XX_SP_PERFCTR_SHADER_MASK(__struct_cast(A6XX_SP_PERFCTR_SHADER_MASK) { __VA_ARGS__ })

struct A6XX_SP_PERFCTR_SP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PERFCTR_SP_SEL_REG(__i, ...) pack_A6XX_SP_PERFCTR_SP_SEL_REG(__i, __struct_cast(A6XX_SP_PERFCTR_SP_SEL_REG) { __VA_ARGS__ })

struct A7XX_SP_PERFCTR_HLSQ_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PERFCTR_HLSQ_SEL_REG(__i, ...) pack_A7XX_SP_PERFCTR_HLSQ_SEL_REG(__i, __struct_cast(A7XX_SP_PERFCTR_HLSQ_SEL_REG) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_AE6A {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_UNKNOWN_AE6A(...) pack_A7XX_SP_UNKNOWN_AE6A(__struct_cast(A7XX_SP_UNKNOWN_AE6A) { __VA_ARGS__ })

struct A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP(...) pack_A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP(__struct_cast(A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP) { __VA_ARGS__ })

struct A7XX_SP_HLSQ_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HLSQ_DBG_ECO_CNTL(...) pack_A7XX_SP_HLSQ_DBG_ECO_CNTL(__struct_cast(A7XX_SP_HLSQ_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A7XX_SP_READ_SEL {
    uint32_t							context;
    uint32_t							slice;
    enum a7xx_state_location					location;
    enum adreno_pipe						pipe;
    enum a7xx_statetype_id					statetype;
    uint32_t							usptp;
    uint32_t							sptp;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_READ_SEL(...) pack_A7XX_SP_READ_SEL(__struct_cast(A7XX_SP_READ_SEL) { __VA_ARGS__ })

struct A7XX_SP_DBG_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DBG_CNTL(...) pack_A7XX_SP_DBG_CNTL(__struct_cast(A7XX_SP_DBG_CNTL) { __VA_ARGS__ })

struct A7XX_SP_HLSQ_DBG_ECO_CNTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HLSQ_DBG_ECO_CNTL_1(...) pack_A7XX_SP_HLSQ_DBG_ECO_CNTL_1(__struct_cast(A7XX_SP_HLSQ_DBG_ECO_CNTL_1) { __VA_ARGS__ })

struct A7XX_SP_HLSQ_DBG_ECO_CNTL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HLSQ_DBG_ECO_CNTL_2(...) pack_A7XX_SP_HLSQ_DBG_ECO_CNTL_2(__struct_cast(A7XX_SP_HLSQ_DBG_ECO_CNTL_2) { __VA_ARGS__ })

struct A8XX_SP_HLSQ_DBG_ECO_CNTL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_HLSQ_DBG_ECO_CNTL_3(...) pack_A8XX_SP_HLSQ_DBG_ECO_CNTL_3(__struct_cast(A8XX_SP_HLSQ_DBG_ECO_CNTL_3) { __VA_ARGS__ })

struct A7XX_SP_PERFCTR_SP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PERFCTR_SP_SEL_REG(__i, ...) pack_A7XX_SP_PERFCTR_SP_SEL_REG(__i, __struct_cast(A7XX_SP_PERFCTR_SP_SEL_REG) { __VA_ARGS__ })

struct A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE(struct A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ae52,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE(...) pack_A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE(__struct_cast(A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE) { __VA_ARGS__ })

struct A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN(...) pack_A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN(__struct_cast(A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN(...) pack_A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN(__struct_cast(A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_SP_LPAC_CPI_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_LPAC_CPI_STATUS(...) pack_A8XX_SP_LPAC_CPI_STATUS(__struct_cast(A8XX_SP_LPAC_CPI_STATUS) { __VA_ARGS__ })

struct A8XX_SP_LPAC_DBG_STATUS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_LPAC_DBG_STATUS(...) pack_A8XX_SP_LPAC_DBG_STATUS(__struct_cast(A8XX_SP_LPAC_DBG_STATUS) { __VA_ARGS__ })

struct A8XX_SP_LPAC_ISDB_BATCH_COUNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_LPAC_ISDB_BATCH_COUNT(...) pack_A8XX_SP_LPAC_ISDB_BATCH_COUNT(__struct_cast(A8XX_SP_LPAC_ISDB_BATCH_COUNT) { __VA_ARGS__ })

struct A8XX_SP_LPAC_ISDB_BATCH_COUNT_INCR_EN {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_LPAC_ISDB_BATCH_COUNT_INCR_EN(...) pack_A8XX_SP_LPAC_ISDB_BATCH_COUNT_INCR_EN(__struct_cast(A8XX_SP_LPAC_ISDB_BATCH_COUNT_INCR_EN) { __VA_ARGS__ })

struct A8XX_SP_LPAC_ISDB_BATCH_COUNT_SHADERS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_LPAC_ISDB_BATCH_COUNT_SHADERS(...) pack_A8XX_SP_LPAC_ISDB_BATCH_COUNT_SHADERS(__struct_cast(A8XX_SP_LPAC_ISDB_BATCH_COUNT_SHADERS) { __VA_ARGS__ })

struct A7XX_SP_ISDB_BATCH_COUNT {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_ISDB_BATCH_COUNT(...) pack_A7XX_SP_ISDB_BATCH_COUNT(__struct_cast(A7XX_SP_ISDB_BATCH_COUNT) { __VA_ARGS__ })

struct A7XX_SP_ISDB_BATCH_COUNT_INCR_EN {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_ISDB_BATCH_COUNT_INCR_EN(...) pack_A7XX_SP_ISDB_BATCH_COUNT_INCR_EN(__struct_cast(A7XX_SP_ISDB_BATCH_COUNT_INCR_EN) { __VA_ARGS__ })

struct A7XX_SP_ISDB_BATCH_COUNT_SHADERS {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_ISDB_BATCH_COUNT_SHADERS(...) pack_A7XX_SP_ISDB_BATCH_COUNT_SHADERS(__struct_cast(A7XX_SP_ISDB_BATCH_COUNT_SHADERS) { __VA_ARGS__ })

struct A7XX_SP_ISDB_DEBUG_CONFIG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_ISDB_DEBUG_CONFIG(...) pack_A7XX_SP_ISDB_DEBUG_CONFIG(__struct_cast(A7XX_SP_ISDB_DEBUG_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_SELF_THROTTLE_CONTROL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_SELF_THROTTLE_CONTROL(...) pack_A7XX_SP_SELF_THROTTLE_CONTROL(__struct_cast(A7XX_SP_SELF_THROTTLE_CONTROL) { __VA_ARGS__ })

struct A7XX_SP_DISPATCH_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DISPATCH_CNTL(...) pack_A7XX_SP_DISPATCH_CNTL(__struct_cast(A7XX_SP_DISPATCH_CNTL) { __VA_ARGS__ })

struct A7XX_SP_SW_DEBUG_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_SW_DEBUG_ADDR(...) pack_A7XX_SP_SW_DEBUG_ADDR(__struct_cast(A7XX_SP_SW_DEBUG_ADDR) { __VA_ARGS__ })

struct A7XX_SP_ISDB_DEBUG_ADDR {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_ISDB_DEBUG_ADDR(...) pack_A7XX_SP_ISDB_DEBUG_ADDR(__struct_cast(A7XX_SP_ISDB_DEBUG_ADDR) { __VA_ARGS__ })

struct A7XX_SP_PERFCTR_HLSQ_SEL_2_0_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PERFCTR_HLSQ_SEL_2_0_REG(__i, ...) pack_A7XX_SP_PERFCTR_HLSQ_SEL_2_0_REG(__i, __struct_cast(A7XX_SP_PERFCTR_HLSQ_SEL_2_0_REG) { __VA_ARGS__ })

struct A6XX_TPL1_CS_BORDER_COLOR_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_CS_BORDER_COLOR_BASE(struct A6XX_TPL1_CS_BORDER_COLOR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b180,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_TPL1_CS_BORDER_COLOR_BASE(...) pack_A6XX_TPL1_CS_BORDER_COLOR_BASE(__struct_cast(A6XX_TPL1_CS_BORDER_COLOR_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_PS_ROTATION_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_PS_ROTATION_CNTL(struct A6XX_TPL1_PS_ROTATION_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b182,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_PS_ROTATION_CNTL(...) pack_A6XX_TPL1_PS_ROTATION_CNTL(__struct_cast(A6XX_TPL1_PS_ROTATION_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_PS_SWIZZLE_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_PS_SWIZZLE_CNTL(struct A6XX_TPL1_PS_SWIZZLE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b183,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_PS_SWIZZLE_CNTL(...) pack_A6XX_TPL1_PS_SWIZZLE_CNTL(__struct_cast(A6XX_TPL1_PS_SWIZZLE_CNTL) { __VA_ARGS__ })

struct A6XX_SP_UNKNOWN_B190 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_UNKNOWN_B190(struct A6XX_SP_UNKNOWN_B190 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b190,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_UNKNOWN_B190(...) pack_A6XX_SP_UNKNOWN_B190(__struct_cast(A6XX_SP_UNKNOWN_B190) { __VA_ARGS__ })

struct A6XX_SP_UNKNOWN_B191 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_UNKNOWN_B191(struct A6XX_SP_UNKNOWN_B191 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b191,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_UNKNOWN_B191(...) pack_A6XX_SP_UNKNOWN_B191(__struct_cast(A6XX_SP_UNKNOWN_B191) { __VA_ARGS__ })

struct A8XX_TPL1_A2D_BIN_SIZE {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_A2D_BIN_SIZE(...) pack_A8XX_TPL1_A2D_BIN_SIZE(__struct_cast(A8XX_TPL1_A2D_BIN_SIZE) { __VA_ARGS__ })

struct A8XX_TPL1_A2D_FILTER_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_A2D_FILTER_CNTL(...) pack_A8XX_TPL1_A2D_FILTER_CNTL(__struct_cast(A8XX_TPL1_A2D_FILTER_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_RAS_MSAA_CNTL(struct A6XX_TPL1_RAS_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unk2                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b300,
        .value =
            (fields.samples                           <<  0) |
            (fields.unk2                              <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_RAS_MSAA_CNTL(...) pack_A6XX_TPL1_RAS_MSAA_CNTL(__struct_cast(A6XX_TPL1_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_DEST_MSAA_CNTL(struct A6XX_TPL1_DEST_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b301,
        .value =
            (fields.samples                           <<  0) |
            (fields.msaa_disable                      <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_DEST_MSAA_CNTL(...) pack_A6XX_TPL1_DEST_MSAA_CNTL(__struct_cast(A6XX_TPL1_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_GFX_BORDER_COLOR_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_GFX_BORDER_COLOR_BASE(struct A6XX_TPL1_GFX_BORDER_COLOR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b302,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_TPL1_GFX_BORDER_COLOR_BASE(...) pack_A6XX_TPL1_GFX_BORDER_COLOR_BASE(__struct_cast(A6XX_TPL1_GFX_BORDER_COLOR_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_MSAA_SAMPLE_POS_CNTL(...) pack_A6XX_TPL1_MSAA_SAMPLE_POS_CNTL(__struct_cast(A6XX_TPL1_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0(...) pack_A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1(...) pack_A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A6XX_TPL1_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_WINDOW_OFFSET(struct A6XX_TPL1_WINDOW_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b307,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_WINDOW_OFFSET(...) pack_A6XX_TPL1_WINDOW_OFFSET(__struct_cast(A6XX_TPL1_WINDOW_OFFSET) { __VA_ARGS__ })

struct A8XX_TPL1_BIN_SIZE {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_BIN_SIZE(...) pack_A8XX_TPL1_BIN_SIZE(__struct_cast(A8XX_TPL1_BIN_SIZE) { __VA_ARGS__ })

struct A6XX_TPL1_MODE_CNTL {
    enum a6xx_isam_mode						isammode;
    enum a6xx_coord_round					texcoordroundmode;
    enum a6xx_coord_round					arraycoordroundmode;
    enum a6xx_nearest_mode					nearestmipsnap;
    bool							samplereplicate;
    bool							destdatatypeoverride;
    bool							pack_samp_reduced_precision;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_MODE_CNTL(...) pack_A6XX_TPL1_MODE_CNTL(__struct_cast(A6XX_TPL1_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_TPL1_MODE_CNTL {
    enum a6xx_isam_mode						isammode;
    enum a6xx_coord_round					texcoordroundmode;
    enum a6xx_coord_round					arraycoordroundmode;
    enum a6xx_nearest_mode					nearestmipsnap;
    bool							samplereplicate;
    bool							destdatatypeoverride;
    bool							pack_samp_reduced_precision;
    bool							clamp_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_MODE_CNTL(...) pack_A8XX_TPL1_MODE_CNTL(__struct_cast(A8XX_TPL1_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_B310 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_UNKNOWN_B310(...) pack_A7XX_SP_UNKNOWN_B310(__struct_cast(A7XX_SP_UNKNOWN_B310) { __VA_ARGS__ })

struct A6XX_TPL1_A2D_SRC_TEXTURE_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						tile_mode;
    enum a3xx_color_swap					color_swap;
    bool							flags;
    bool							srgb;
    enum a3xx_msaa_samples					samples;
    bool							filter;
    bool							unk17;
    bool							samples_average;
    bool							unk19;
    bool							unk20;
    bool							unk21;
    bool							unk22;
    uint32_t							unk23;
    bool							unk28;
    bool							mutableen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_INFO(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_INFO) { __VA_ARGS__ })

struct A6XX_TPL1_A2D_SRC_TEXTURE_SIZE {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_SIZE(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_SIZE(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_SIZE) { __VA_ARGS__ })

struct A6XX_TPL1_A2D_SRC_TEXTURE_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_BASE(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_BASE(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_A2D_SRC_TEXTURE_PITCH {
    uint32_t							unk0;
    uint32_t							pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_PITCH(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_PITCH) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_SRC_TEXTURE_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						tile_mode;
    enum a3xx_color_swap					color_swap;
    bool							flags;
    bool							srgb;
    enum a3xx_msaa_samples					samples;
    bool							filter;
    bool							unk17;
    bool							samples_average;
    bool							unk19;
    bool							unk20;
    bool							unk21;
    bool							unk22;
    uint32_t							unk23;
    bool							unk28;
    bool							mutableen;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_INFO(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_INFO) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_SRC_TEXTURE_SIZE {
    uint32_t							width;
    uint32_t							height;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_SIZE(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_SIZE(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_SIZE) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_SRC_TEXTURE_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_BASE(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_BASE(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_TPL1_A2D_SRC_TEXTURE_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A8XX_TPL1_A2D_SRC_TEXTURE_BASE(...) pack_A8XX_TPL1_A2D_SRC_TEXTURE_BASE(__struct_cast(A8XX_TPL1_A2D_SRC_TEXTURE_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_TPL1_A2D_SRC_TEXTURE_PITCH {
    uint32_t							pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_PITCH(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_PITCH) { __VA_ARGS__ })

struct A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1 {
    uint32_t							tpl1_a2d_src_texture_pitch_1;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1) { __VA_ARGS__ })

struct A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1 {
    uint32_t							tpl1_a2d_src_texture_pitch_1;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2 {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH {
    uint32_t							tpl1_a2d_src_texture_flag_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(...) pack_A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(__struct_cast(A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH {
    uint32_t							tpl1_a2d_src_texture_flag_pitch;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(...) pack_A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(__struct_cast(A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH) { __VA_ARGS__ })

struct A6XX_SP_PS_UNKNOWN_B4CD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_UNKNOWN_B4CD(...) pack_A6XX_SP_PS_UNKNOWN_B4CD(__struct_cast(A6XX_SP_PS_UNKNOWN_B4CD) { __VA_ARGS__ })

struct A6XX_SP_PS_UNKNOWN_B4CE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_UNKNOWN_B4CE(...) pack_A6XX_SP_PS_UNKNOWN_B4CE(__struct_cast(A6XX_SP_PS_UNKNOWN_B4CE) { __VA_ARGS__ })

struct A6XX_SP_PS_UNKNOWN_B4CF {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_UNKNOWN_B4CF(...) pack_A6XX_SP_PS_UNKNOWN_B4CF(__struct_cast(A6XX_SP_PS_UNKNOWN_B4CF) { __VA_ARGS__ })

struct A6XX_SP_PS_UNKNOWN_B4D0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_UNKNOWN_B4D0(...) pack_A6XX_SP_PS_UNKNOWN_B4D0(__struct_cast(A6XX_SP_PS_UNKNOWN_B4D0) { __VA_ARGS__ })

struct A6XX_SP_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_WINDOW_OFFSET(...) pack_A6XX_SP_WINDOW_OFFSET(__struct_cast(A6XX_SP_WINDOW_OFFSET) { __VA_ARGS__ })

struct A7XX_SP_PS_UNKNOWN_B4CD {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_UNKNOWN_B4CD(...) pack_A7XX_SP_PS_UNKNOWN_B4CD(__struct_cast(A7XX_SP_PS_UNKNOWN_B4CD) { __VA_ARGS__ })

struct A7XX_SP_PS_UNKNOWN_B4CE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_UNKNOWN_B4CE(...) pack_A7XX_SP_PS_UNKNOWN_B4CE(__struct_cast(A7XX_SP_PS_UNKNOWN_B4CE) { __VA_ARGS__ })

struct A7XX_SP_PS_UNKNOWN_B4CF {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_UNKNOWN_B4CF(...) pack_A7XX_SP_PS_UNKNOWN_B4CF(__struct_cast(A7XX_SP_PS_UNKNOWN_B4CF) { __VA_ARGS__ })

struct A7XX_SP_PS_UNKNOWN_B4D0 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_UNKNOWN_B4D0(...) pack_A7XX_SP_PS_UNKNOWN_B4D0(__struct_cast(A7XX_SP_PS_UNKNOWN_B4D0) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_WINDOW_OFFSET(...) pack_A7XX_TPL1_A2D_WINDOW_OFFSET(__struct_cast(A7XX_TPL1_A2D_WINDOW_OFFSET) { __VA_ARGS__ })

struct A7XX_TPL1_A2D_BLT_CNTL {
    bool							raw_copy;
    enum a6xx_tex_type						type;
    uint32_t							start_offset_texels;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_A2D_BLT_CNTL(...) pack_A7XX_TPL1_A2D_BLT_CNTL(__struct_cast(A7XX_TPL1_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A8XX_TPL1_A2D_BLT_CNTL {
    bool							raw_copy;
    enum a6xx_tex_type						type;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_A2D_BLT_CNTL(...) pack_A8XX_TPL1_A2D_BLT_CNTL(__struct_cast(A8XX_TPL1_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A7XX_SP_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_WINDOW_OFFSET(...) pack_A7XX_SP_WINDOW_OFFSET(__struct_cast(A7XX_SP_WINDOW_OFFSET) { __VA_ARGS__ })

struct A8XX_SP_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_WINDOW_OFFSET(...) pack_A8XX_SP_WINDOW_OFFSET(__struct_cast(A8XX_SP_WINDOW_OFFSET) { __VA_ARGS__ })

struct A6XX_TPL1_DBG_ECO_CNTL {
    bool							linear_mipmap_fallback_in_blocks;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_DBG_ECO_CNTL(struct A6XX_TPL1_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x02000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b600,
        .value =
            (fields.linear_mipmap_fallback_in_blocks  << 25) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_DBG_ECO_CNTL(...) pack_A6XX_TPL1_DBG_ECO_CNTL(__struct_cast(A6XX_TPL1_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_ADDR_MODE_CNTL {
    enum a5xx_address_mode					tpl1_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_ADDR_MODE_CNTL(...) pack_A6XX_TPL1_ADDR_MODE_CNTL(__struct_cast(A6XX_TPL1_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_DBG_ECO_CNTL1 {
    bool							tp_ubwc_flag_hint;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_DBG_ECO_CNTL1(struct A6XX_TPL1_DBG_ECO_CNTL1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00040000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b602,
        .value =
            (fields.tp_ubwc_flag_hint                 << 18) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_DBG_ECO_CNTL1(...) pack_A6XX_TPL1_DBG_ECO_CNTL1(__struct_cast(A6XX_TPL1_DBG_ECO_CNTL1) { __VA_ARGS__ })

struct A6XX_TPL1_NC_MODE_CNTL {
    bool							mode;
    uint32_t							lower_bit;
    bool							min_access_length;
    uint32_t							upper_bit;
    uint32_t							unk6;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_TPL1_NC_MODE_CNTL(struct A6XX_TPL1_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.lower_bit                         & 0xfffffffc) == 0);
    assert((fields.upper_bit                         & 0xfffffffe) == 0);
    assert((fields.unk6                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000000df) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b604,
        .value =
            (fields.mode                              <<  0) |
            (fields.lower_bit                         <<  1) |
            (fields.min_access_length                 <<  3) |
            (fields.upper_bit                         <<  4) |
            (fields.unk6                              <<  6) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_TPL1_NC_MODE_CNTL(...) pack_A6XX_TPL1_NC_MODE_CNTL(__struct_cast(A6XX_TPL1_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_TPL1_UNKNOWN_B605 {
    uint32_t							tpl1_unknown_b605;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_UNKNOWN_B605(...) pack_A6XX_TPL1_UNKNOWN_B605(__struct_cast(A6XX_TPL1_UNKNOWN_B605) { __VA_ARGS__ })

struct A6XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, ...) pack_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, __struct_cast(A6XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG) { __VA_ARGS__ })

struct A7XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, ...) pack_A7XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, __struct_cast(A7XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG) { __VA_ARGS__ })

struct A8XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, ...) pack_A8XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG(__i, __struct_cast(A8XX_TPL1_BICUBIC_WEIGHTS_TABLE_REG) { __VA_ARGS__ })

struct A6XX_TPL1_PERFCTR_TP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_TPL1_PERFCTR_TP_SEL_REG(__i, ...) pack_A6XX_TPL1_PERFCTR_TP_SEL_REG(__i, __struct_cast(A6XX_TPL1_PERFCTR_TP_SEL_REG) { __VA_ARGS__ })

struct A7XX_TPL1_PERFCTR_TP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_TPL1_PERFCTR_TP_SEL_REG(__i, ...) pack_A7XX_TPL1_PERFCTR_TP_SEL_REG(__i, __struct_cast(A7XX_TPL1_PERFCTR_TP_SEL_REG) { __VA_ARGS__ })

struct A8XX_TPL1_PERFCTR_TP_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_TPL1_PERFCTR_TP_SEL_REG(__i, ...) pack_A8XX_TPL1_PERFCTR_TP_SEL_REG(__i, __struct_cast(A8XX_TPL1_PERFCTR_TP_SEL_REG) { __VA_ARGS__ })

struct A6XX_SP_VS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_VS_CONST_CONFIG(...) pack_A6XX_SP_VS_CONST_CONFIG(__struct_cast(A6XX_SP_VS_CONST_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_HS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_HS_CONST_CONFIG(...) pack_A6XX_SP_HS_CONST_CONFIG(__struct_cast(A6XX_SP_HS_CONST_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_DS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_DS_CONST_CONFIG(...) pack_A6XX_SP_DS_CONST_CONFIG(__struct_cast(A6XX_SP_DS_CONST_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_GS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_GS_CONST_CONFIG(...) pack_A6XX_SP_GS_CONST_CONFIG(__struct_cast(A6XX_SP_GS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_VS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_VS_CONST_CONFIG(...) pack_A7XX_SP_VS_CONST_CONFIG(__struct_cast(A7XX_SP_VS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_HS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_HS_CONST_CONFIG(...) pack_A7XX_SP_HS_CONST_CONFIG(__struct_cast(A7XX_SP_HS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_DS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DS_CONST_CONFIG(...) pack_A7XX_SP_DS_CONST_CONFIG(__struct_cast(A7XX_SP_DS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_GS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_GS_CONST_CONFIG(...) pack_A7XX_SP_GS_CONST_CONFIG(__struct_cast(A7XX_SP_GS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_RENDER_CNTL {
    bool							fs_disable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_RENDER_CNTL(...) pack_A7XX_SP_RENDER_CNTL(__struct_cast(A7XX_SP_RENDER_CNTL) { __VA_ARGS__ })

struct A7XX_SP_DITHER_CNTL {
    enum adreno_rb_dither_mode					dither_mode_mrt0;
    enum adreno_rb_dither_mode					dither_mode_mrt1;
    enum adreno_rb_dither_mode					dither_mode_mrt2;
    enum adreno_rb_dither_mode					dither_mode_mrt3;
    enum adreno_rb_dither_mode					dither_mode_mrt4;
    enum adreno_rb_dither_mode					dither_mode_mrt5;
    enum adreno_rb_dither_mode					dither_mode_mrt6;
    enum adreno_rb_dither_mode					dither_mode_mrt7;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DITHER_CNTL(...) pack_A7XX_SP_DITHER_CNTL(__struct_cast(A7XX_SP_DITHER_CNTL) { __VA_ARGS__ })

struct A7XX_SP_VRS_CONFIG {
    bool							pipeline_fsr_enable;
    bool							attachment_fsr_enable;
    bool							primitive_fsr_enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_VRS_CONFIG(...) pack_A7XX_SP_VRS_CONFIG(__struct_cast(A7XX_SP_VRS_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_PS_CNTL_1 {
    uint32_t							sysval_regs_count;
    bool							defer_wave_alloc_dis;
    uint32_t							evict_buf_mode;
    uint32_t							wave_pair_mode;
    uint32_t							num_total_var;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_CNTL_1(...) pack_A7XX_SP_PS_CNTL_1(__struct_cast(A7XX_SP_PS_CNTL_1) { __VA_ARGS__ })

struct A6XX_HLSQ_LOAD_STATE_GEOM_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_GEOM_CMD(struct A6XX_HLSQ_LOAD_STATE_GEOM_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b820,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_LOAD_STATE_GEOM_CMD(...) pack_A6XX_HLSQ_LOAD_STATE_GEOM_CMD(__struct_cast(A6XX_HLSQ_LOAD_STATE_GEOM_CMD) { __VA_ARGS__ })

struct A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR(struct A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b821,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR(...) pack_A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR(__struct_cast(A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_HLSQ_LOAD_STATE_GEOM_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_GEOM_DATA(struct A6XX_HLSQ_LOAD_STATE_GEOM_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b823,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_LOAD_STATE_GEOM_DATA(...) pack_A6XX_HLSQ_LOAD_STATE_GEOM_DATA(__struct_cast(A6XX_HLSQ_LOAD_STATE_GEOM_DATA) { __VA_ARGS__ })

struct A6XX_SP_PS_WAVE_CNTL {
    enum a6xx_threadsize					threadsize;
    bool							varyings;
    uint32_t							unk2;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_WAVE_CNTL(...) pack_A6XX_SP_PS_WAVE_CNTL(__struct_cast(A6XX_SP_PS_WAVE_CNTL) { __VA_ARGS__ })

struct A6XX_HLSQ_UNKNOWN_B981 {
    bool							hlsq_unknown_b981;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_UNKNOWN_B981(...) pack_A6XX_HLSQ_UNKNOWN_B981(__struct_cast(A6XX_HLSQ_UNKNOWN_B981) { __VA_ARGS__ })

struct A6XX_SP_LB_PARAM_LIMIT {
    uint32_t							primallocthreshold;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_LB_PARAM_LIMIT(...) pack_A6XX_SP_LB_PARAM_LIMIT(__struct_cast(A6XX_SP_LB_PARAM_LIMIT) { __VA_ARGS__ })

struct A6XX_SP_REG_PROG_ID_0 {
    uint32_t							faceregid;
    uint32_t							sampleid;
    uint32_t							samplemask;
    uint32_t							centerrhw;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_REG_PROG_ID_0(...) pack_A6XX_SP_REG_PROG_ID_0(__struct_cast(A6XX_SP_REG_PROG_ID_0) { __VA_ARGS__ })

struct A6XX_SP_REG_PROG_ID_1 {
    uint32_t							ij_persp_pixel;
    uint32_t							ij_linear_pixel;
    uint32_t							ij_persp_centroid;
    uint32_t							ij_linear_centroid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_REG_PROG_ID_1(...) pack_A6XX_SP_REG_PROG_ID_1(__struct_cast(A6XX_SP_REG_PROG_ID_1) { __VA_ARGS__ })

struct A6XX_SP_REG_PROG_ID_2 {
    uint32_t							ij_persp_sample;
    uint32_t							ij_linear_sample;
    uint32_t							xycoordregid;
    uint32_t							zwcoordregid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_REG_PROG_ID_2(...) pack_A6XX_SP_REG_PROG_ID_2(__struct_cast(A6XX_SP_REG_PROG_ID_2) { __VA_ARGS__ })

struct A6XX_SP_REG_PROG_ID_3 {
    uint32_t							linelengthregid;
    uint32_t							foveationqualityregid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_REG_PROG_ID_3(...) pack_A6XX_SP_REG_PROG_ID_3(__struct_cast(A6XX_SP_REG_PROG_ID_3) { __VA_ARGS__ })

struct A6XX_SP_CS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_CONST_CONFIG(...) pack_A6XX_SP_CS_CONST_CONFIG(__struct_cast(A6XX_SP_CS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_PS_WAVE_CNTL {
    enum a6xx_threadsize					threadsize;
    bool							varyings;
    uint32_t							unk2;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_WAVE_CNTL(...) pack_A7XX_SP_PS_WAVE_CNTL(__struct_cast(A7XX_SP_PS_WAVE_CNTL) { __VA_ARGS__ })

struct A8XX_SP_PS_WAVE_CNTL {
    bool							varyings;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_PS_WAVE_CNTL(...) pack_A8XX_SP_PS_WAVE_CNTL(__struct_cast(A8XX_SP_PS_WAVE_CNTL) { __VA_ARGS__ })

struct A7XX_SP_LB_PARAM_LIMIT {
    uint32_t							primallocthreshold;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_LB_PARAM_LIMIT(...) pack_A7XX_SP_LB_PARAM_LIMIT(__struct_cast(A7XX_SP_LB_PARAM_LIMIT) { __VA_ARGS__ })

struct A7XX_SP_REG_PROG_ID_0 {
    uint32_t							faceregid;
    uint32_t							sampleid;
    uint32_t							samplemask;
    uint32_t							centerrhw;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_REG_PROG_ID_0(...) pack_A7XX_SP_REG_PROG_ID_0(__struct_cast(A7XX_SP_REG_PROG_ID_0) { __VA_ARGS__ })

struct A7XX_SP_REG_PROG_ID_1 {
    uint32_t							ij_persp_pixel;
    uint32_t							ij_linear_pixel;
    uint32_t							ij_persp_centroid;
    uint32_t							ij_linear_centroid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_REG_PROG_ID_1(...) pack_A7XX_SP_REG_PROG_ID_1(__struct_cast(A7XX_SP_REG_PROG_ID_1) { __VA_ARGS__ })

struct A7XX_SP_REG_PROG_ID_2 {
    uint32_t							ij_persp_sample;
    uint32_t							ij_linear_sample;
    uint32_t							xycoordregid;
    uint32_t							zwcoordregid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_REG_PROG_ID_2(...) pack_A7XX_SP_REG_PROG_ID_2(__struct_cast(A7XX_SP_REG_PROG_ID_2) { __VA_ARGS__ })

struct A7XX_SP_REG_PROG_ID_3 {
    uint32_t							linelengthregid;
    uint32_t							foveationqualityregid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_REG_PROG_ID_3(...) pack_A7XX_SP_REG_PROG_ID_3(__struct_cast(A7XX_SP_REG_PROG_ID_3) { __VA_ARGS__ })

struct A7XX_SP_CS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_CONST_CONFIG(...) pack_A7XX_SP_CS_CONST_CONFIG(__struct_cast(A7XX_SP_CS_CONST_CONFIG) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_0 {
    uint32_t							kerneldim;
    uint32_t							localsizex;
    uint32_t							localsizey;
    uint32_t							localsizez;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_0(...) pack_A6XX_SP_CS_NDRANGE_0(__struct_cast(A6XX_SP_CS_NDRANGE_0) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_1 {
    uint32_t							globalsize_x;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_1(...) pack_A6XX_SP_CS_NDRANGE_1(__struct_cast(A6XX_SP_CS_NDRANGE_1) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_2 {
    uint32_t							globaloff_x;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_2(...) pack_A6XX_SP_CS_NDRANGE_2(__struct_cast(A6XX_SP_CS_NDRANGE_2) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_3 {
    uint32_t							globalsize_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_3(...) pack_A6XX_SP_CS_NDRANGE_3(__struct_cast(A6XX_SP_CS_NDRANGE_3) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_4 {
    uint32_t							globaloff_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_4(...) pack_A6XX_SP_CS_NDRANGE_4(__struct_cast(A6XX_SP_CS_NDRANGE_4) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_5 {
    uint32_t							globalsize_z;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_5(...) pack_A6XX_SP_CS_NDRANGE_5(__struct_cast(A6XX_SP_CS_NDRANGE_5) { __VA_ARGS__ })

struct A6XX_SP_CS_NDRANGE_6 {
    uint32_t							globaloff_z;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_NDRANGE_6(...) pack_A6XX_SP_CS_NDRANGE_6(__struct_cast(A6XX_SP_CS_NDRANGE_6) { __VA_ARGS__ })

struct A6XX_SP_CS_CONST_CONFIG_0 {
    uint32_t							wgidconstid;
    uint32_t							wgsizeconstid;
    uint32_t							wgoffsetconstid;
    uint32_t							localidregid;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_CONST_CONFIG_0(...) pack_A6XX_SP_CS_CONST_CONFIG_0(__struct_cast(A6XX_SP_CS_CONST_CONFIG_0) { __VA_ARGS__ })

struct A6XX_SP_CS_WGE_CNTL {
    uint32_t							linearlocalidregid;
    bool							single_sp_core;
    enum a6xx_threadsize					threadsize;
    bool							threadsize_scalar;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_WGE_CNTL(...) pack_A6XX_SP_CS_WGE_CNTL(__struct_cast(A6XX_SP_CS_WGE_CNTL) { __VA_ARGS__ })

struct A6XX_SP_CS_KERNEL_GROUP_X {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_KERNEL_GROUP_X(...) pack_A6XX_SP_CS_KERNEL_GROUP_X(__struct_cast(A6XX_SP_CS_KERNEL_GROUP_X) { __VA_ARGS__ })

struct A6XX_SP_CS_KERNEL_GROUP_Y {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_KERNEL_GROUP_Y(...) pack_A6XX_SP_CS_KERNEL_GROUP_Y(__struct_cast(A6XX_SP_CS_KERNEL_GROUP_Y) { __VA_ARGS__ })

struct A6XX_SP_CS_KERNEL_GROUP_Z {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_CS_KERNEL_GROUP_Z(...) pack_A6XX_SP_CS_KERNEL_GROUP_Z(__struct_cast(A6XX_SP_CS_KERNEL_GROUP_Z) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_0 {
    uint32_t							kerneldim;
    uint32_t							localsizex;
    uint32_t							localsizey;
    uint32_t							localsizez;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_0(...) pack_A7XX_SP_CS_NDRANGE_0(__struct_cast(A7XX_SP_CS_NDRANGE_0) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_1 {
    uint32_t							globalsize_x;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_1(...) pack_A7XX_SP_CS_NDRANGE_1(__struct_cast(A7XX_SP_CS_NDRANGE_1) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_2 {
    uint32_t							globaloff_x;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_2(...) pack_A7XX_SP_CS_NDRANGE_2(__struct_cast(A7XX_SP_CS_NDRANGE_2) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_3 {
    uint32_t							globalsize_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_3(...) pack_A7XX_SP_CS_NDRANGE_3(__struct_cast(A7XX_SP_CS_NDRANGE_3) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_4 {
    uint32_t							globaloff_y;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_4(...) pack_A7XX_SP_CS_NDRANGE_4(__struct_cast(A7XX_SP_CS_NDRANGE_4) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_5 {
    uint32_t							globalsize_z;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_5(...) pack_A7XX_SP_CS_NDRANGE_5(__struct_cast(A7XX_SP_CS_NDRANGE_5) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_6 {
    uint32_t							globaloff_z;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_6(...) pack_A7XX_SP_CS_NDRANGE_6(__struct_cast(A7XX_SP_CS_NDRANGE_6) { __VA_ARGS__ })

struct A7XX_SP_CS_KERNEL_GROUP_X {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_KERNEL_GROUP_X(...) pack_A7XX_SP_CS_KERNEL_GROUP_X(__struct_cast(A7XX_SP_CS_KERNEL_GROUP_X) { __VA_ARGS__ })

struct A7XX_SP_CS_KERNEL_GROUP_Y {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_KERNEL_GROUP_Y(...) pack_A7XX_SP_CS_KERNEL_GROUP_Y(__struct_cast(A7XX_SP_CS_KERNEL_GROUP_Y) { __VA_ARGS__ })

struct A7XX_SP_CS_KERNEL_GROUP_Z {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_KERNEL_GROUP_Z(...) pack_A7XX_SP_CS_KERNEL_GROUP_Z(__struct_cast(A7XX_SP_CS_KERNEL_GROUP_Z) { __VA_ARGS__ })

struct A7XX_SP_CS_WGE_CNTL {
    uint32_t							linearlocalidregid;
    enum a6xx_threadsize					threadsize;
    bool							workgrouprastorderzfirsten;
    uint32_t							wgtilewidth;
    uint32_t							wgtileheight;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_WGE_CNTL(...) pack_A7XX_SP_CS_WGE_CNTL(__struct_cast(A7XX_SP_CS_WGE_CNTL) { __VA_ARGS__ })

struct A7XX_SP_CS_NDRANGE_7 {
    uint32_t							localsizex;
    uint32_t							localsizey;
    uint32_t							localsizez;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_CS_NDRANGE_7(...) pack_A7XX_SP_CS_NDRANGE_7(__struct_cast(A7XX_SP_CS_NDRANGE_7) { __VA_ARGS__ })

struct A6XX_HLSQ_LOAD_STATE_FRAG_CMD {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_FRAG_CMD(struct A6XX_HLSQ_LOAD_STATE_FRAG_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b9a0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_LOAD_STATE_FRAG_CMD(...) pack_A6XX_HLSQ_LOAD_STATE_FRAG_CMD(__struct_cast(A6XX_HLSQ_LOAD_STATE_FRAG_CMD) { __VA_ARGS__ })

struct A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR {
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR(struct A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b9a1,
        .value =
            fields.unknown | fields.qword,
#ifndef TU_CS_H
        .bo = fields.bo,
        .is_address = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
#else
        .is_address = true,
#endif
    };

}

#define A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR(...) pack_A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR(__struct_cast(A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_HLSQ_LOAD_STATE_FRAG_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_LOAD_STATE_FRAG_DATA(struct A6XX_HLSQ_LOAD_STATE_FRAG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000b9a3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_LOAD_STATE_FRAG_DATA(...) pack_A6XX_HLSQ_LOAD_STATE_FRAG_DATA(__struct_cast(A6XX_HLSQ_LOAD_STATE_FRAG_DATA) { __VA_ARGS__ })

struct A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_HLSQ_CS_CTRL_REG1 {
    uint32_t							shared_size;
    enum a6xx_const_ram_mode					constantrammode;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_CS_CTRL_REG1(...) pack_A6XX_HLSQ_CS_CTRL_REG1(__struct_cast(A6XX_HLSQ_CS_CTRL_REG1) { __VA_ARGS__ })

struct A6XX_SP_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_DRAW_INITIATOR(...) pack_A6XX_SP_DRAW_INITIATOR(__struct_cast(A6XX_SP_DRAW_INITIATOR) { __VA_ARGS__ })

struct A6XX_SP_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_KERNEL_INITIATOR(...) pack_A6XX_SP_KERNEL_INITIATOR(__struct_cast(A6XX_SP_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A6XX_SP_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_EVENT_INITIATOR(...) pack_A6XX_SP_EVENT_INITIATOR(__struct_cast(A6XX_SP_EVENT_INITIATOR) { __VA_ARGS__ })

struct A6XX_SP_UPDATE_CNTL {
    bool							vs_state;
    bool							hs_state;
    bool							ds_state;
    bool							gs_state;
    bool							fs_state;
    bool							cs_state;
    bool							cs_uav;
    bool							gfx_uav;
    bool							cs_shared_const;
    bool							gfx_shared_const;
    uint32_t							cs_bindless;
    uint32_t							gfx_bindless;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_UPDATE_CNTL(...) pack_A6XX_SP_UPDATE_CNTL(__struct_cast(A6XX_SP_UPDATE_CNTL) { __VA_ARGS__ })

struct A7XX_SP_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_DRAW_INITIATOR(...) pack_A7XX_SP_DRAW_INITIATOR(__struct_cast(A7XX_SP_DRAW_INITIATOR) { __VA_ARGS__ })

struct A7XX_SP_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_KERNEL_INITIATOR(...) pack_A7XX_SP_KERNEL_INITIATOR(__struct_cast(A7XX_SP_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A7XX_SP_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_EVENT_INITIATOR(...) pack_A7XX_SP_EVENT_INITIATOR(__struct_cast(A7XX_SP_EVENT_INITIATOR) { __VA_ARGS__ })

struct A7XX_SP_UPDATE_CNTL {
    bool							vs_state;
    bool							hs_state;
    bool							ds_state;
    bool							gs_state;
    bool							fs_state;
    bool							cs_state;
    bool							cs_uav;
    bool							gfx_uav;
    uint32_t							cs_bindless;
    uint32_t							gfx_bindless;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_UPDATE_CNTL(...) pack_A7XX_SP_UPDATE_CNTL(__struct_cast(A7XX_SP_UPDATE_CNTL) { __VA_ARGS__ })

struct A8XX_SP_UPDATE_CNTL {
    bool							vs_state;
    bool							hs_state;
    bool							ds_state;
    bool							gs_state;
    bool							fs_state;
    bool							cs_state;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_UPDATE_CNTL(...) pack_A8XX_SP_UPDATE_CNTL(__struct_cast(A8XX_SP_UPDATE_CNTL) { __VA_ARGS__ })

struct A6XX_SP_CS_BINDLESS_INVALIDATE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_CS_BINDLESS_INVALIDATE(struct A6XX_SP_CS_BINDLESS_INVALIDATE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000a9c0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_CS_BINDLESS_INVALIDATE(...) pack_A6XX_SP_CS_BINDLESS_INVALIDATE(__struct_cast(A6XX_SP_CS_BINDLESS_INVALIDATE) { __VA_ARGS__ })

struct A6XX_SP_GFX_BINDLESS_INVALIDATE {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_SP_GFX_BINDLESS_INVALIDATE(struct A6XX_SP_GFX_BINDLESS_INVALIDATE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000ab08,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_SP_GFX_BINDLESS_INVALIDATE(...) pack_A6XX_SP_GFX_BINDLESS_INVALIDATE(__struct_cast(A6XX_SP_GFX_BINDLESS_INVALIDATE) { __VA_ARGS__ })

struct A6XX_SP_PS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_SP_PS_CONST_CONFIG(...) pack_A6XX_SP_PS_CONST_CONFIG(__struct_cast(A6XX_SP_PS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_PS_CONST_CONFIG {
    uint32_t							constlen;
    bool							enabled;
    bool							read_imm_shared_consts;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_PS_CONST_CONFIG(...) pack_A7XX_SP_PS_CONST_CONFIG(__struct_cast(A7XX_SP_PS_CONST_CONFIG) { __VA_ARGS__ })

struct A7XX_SP_SHARED_CONSTANT_GFX_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_SHARED_CONSTANT_GFX_REG(__i, ...) pack_A7XX_SP_SHARED_CONSTANT_GFX_REG(__i, __struct_cast(A7XX_SP_SHARED_CONSTANT_GFX_REG) { __VA_ARGS__ })

struct A8XX_SP_SHARED_CONSTANT_GFX_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_SP_SHARED_CONSTANT_GFX_REG(__i, ...) pack_A8XX_SP_SHARED_CONSTANT_GFX_REG(__i, __struct_cast(A8XX_SP_SHARED_CONSTANT_GFX_REG) { __VA_ARGS__ })

struct A6XX_HLSQ_SHARED_CONSTS {
    bool							enable;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_SHARED_CONSTS(...) pack_A6XX_HLSQ_SHARED_CONSTS(__struct_cast(A6XX_HLSQ_SHARED_CONSTS) { __VA_ARGS__ })

struct A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR {
    enum a6xx_bindless_descriptor_size				desc_size;
#ifndef TU_CS_H
    __bo_type							bo;
    uint32_t							bo_offset;
#endif

    uint64_t							qword;
    uint64_t							unknown;
};

#define A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR(__i, ...) pack_A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR(__i, __struct_cast(A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_HLSQ_2D_EVENT_CMD {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_2D_EVENT_CMD(struct A6XX_HLSQ_2D_EVENT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.event                             & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x0000ff7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000bd80,
        .value =
            (fields.state_id                          <<  8) |
            (fields.event                             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_2D_EVENT_CMD(...) pack_A6XX_HLSQ_2D_EVENT_CMD(__struct_cast(A6XX_HLSQ_2D_EVENT_CMD) { __VA_ARGS__ })

struct A6XX_HLSQ_UNKNOWN_BE00 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_UNKNOWN_BE00(...) pack_A6XX_HLSQ_UNKNOWN_BE00(__struct_cast(A6XX_HLSQ_UNKNOWN_BE00) { __VA_ARGS__ })

struct A6XX_HLSQ_UNKNOWN_BE01 {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_UNKNOWN_BE01(...) pack_A6XX_HLSQ_UNKNOWN_BE01(__struct_cast(A6XX_HLSQ_UNKNOWN_BE01) { __VA_ARGS__ })

struct A6XX_HLSQ_DBG_ECO_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_DBG_ECO_CNTL(...) pack_A6XX_HLSQ_DBG_ECO_CNTL(__struct_cast(A6XX_HLSQ_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_HLSQ_ADDR_MODE_CNTL {
    enum a5xx_address_mode					hlsq_addr_mode_cntl;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_ADDR_MODE_CNTL(...) pack_A6XX_HLSQ_ADDR_MODE_CNTL(__struct_cast(A6XX_HLSQ_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_HLSQ_UNKNOWN_BE08 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_UNKNOWN_BE08(struct A6XX_HLSQ_UNKNOWN_BE08 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000be08,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_UNKNOWN_BE08(...) pack_A6XX_HLSQ_UNKNOWN_BE08(__struct_cast(A6XX_HLSQ_UNKNOWN_BE08) { __VA_ARGS__ })

struct A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG(uint32_t __i, struct A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000be10 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG(__i, ...) pack_A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG(__i, __struct_cast(A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG) { __VA_ARGS__ })

struct A6XX_HLSQ_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_HLSQ_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE(...) pack_A6XX_HLSQ_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE(__struct_cast(A6XX_HLSQ_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE) { __VA_ARGS__ })

struct A7XX_SP_AHB_READ_APERTURE {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_SP_AHB_READ_APERTURE(...) pack_A7XX_SP_AHB_READ_APERTURE(__struct_cast(A7XX_SP_AHB_READ_APERTURE) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_0CE2 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_UNKNOWN_0CE2(...) pack_A7XX_SP_UNKNOWN_0CE2(__struct_cast(A7XX_SP_UNKNOWN_0CE2) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_0CE4 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_UNKNOWN_0CE4(...) pack_A7XX_SP_UNKNOWN_0CE4(__struct_cast(A7XX_SP_UNKNOWN_0CE4) { __VA_ARGS__ })

struct A7XX_SP_UNKNOWN_0CE6 {
    uint64_t							qword;
    uint64_t							unknown;
};

#define A7XX_SP_UNKNOWN_0CE6(...) pack_A7XX_SP_UNKNOWN_0CE6(__struct_cast(A7XX_SP_UNKNOWN_0CE6) { __VA_ARGS__ })

struct A6XX_CP_EVENT_START {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_EVENT_START(struct A6XX_CP_EVENT_START fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d600,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_EVENT_START(...) pack_A6XX_CP_EVENT_START(__struct_cast(A6XX_CP_EVENT_START) { __VA_ARGS__ })

struct A6XX_CP_EVENT_END {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_EVENT_END(struct A6XX_CP_EVENT_END fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d601,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_EVENT_END(...) pack_A6XX_CP_EVENT_END(__struct_cast(A6XX_CP_EVENT_END) { __VA_ARGS__ })

struct A6XX_CP_2D_EVENT_START {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_2D_EVENT_START(struct A6XX_CP_2D_EVENT_START fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d700,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_2D_EVENT_START(...) pack_A6XX_CP_2D_EVENT_START(__struct_cast(A6XX_CP_2D_EVENT_START) { __VA_ARGS__ })

struct A6XX_CP_2D_EVENT_END {
    uint32_t							state_id;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CP_2D_EVENT_END(struct A6XX_CP_2D_EVENT_END fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d701,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_2D_EVENT_END(...) pack_A6XX_CP_2D_EVENT_END(__struct_cast(A6XX_CP_2D_EVENT_END) { __VA_ARGS__ })

struct A6XX_PDC_GPU_ENABLE_PDC {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_ENABLE_PDC(struct A6XX_PDC_GPU_ENABLE_PDC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001140,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_ENABLE_PDC(...) pack_A6XX_PDC_GPU_ENABLE_PDC(__struct_cast(A6XX_PDC_GPU_ENABLE_PDC) { __VA_ARGS__ })

struct A6XX_PDC_GPU_SEQ_START_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_SEQ_START_ADDR(struct A6XX_PDC_GPU_SEQ_START_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001148,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_SEQ_START_ADDR(...) pack_A6XX_PDC_GPU_SEQ_START_ADDR(__struct_cast(A6XX_PDC_GPU_SEQ_START_ADDR) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CONTROL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CONTROL(struct A6XX_PDC_GPU_TCS0_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001540,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CONTROL(...) pack_A6XX_PDC_GPU_TCS0_CONTROL(__struct_cast(A6XX_PDC_GPU_TCS0_CONTROL) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK(struct A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001541,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK(...) pack_A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK(__struct_cast(A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK(struct A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001542,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK(...) pack_A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK(__struct_cast(A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CMD0_MSGID {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CMD0_MSGID(struct A6XX_PDC_GPU_TCS0_CMD0_MSGID fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001543,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CMD0_MSGID(...) pack_A6XX_PDC_GPU_TCS0_CMD0_MSGID(__struct_cast(A6XX_PDC_GPU_TCS0_CMD0_MSGID) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CMD0_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CMD0_ADDR(struct A6XX_PDC_GPU_TCS0_CMD0_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001544,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CMD0_ADDR(...) pack_A6XX_PDC_GPU_TCS0_CMD0_ADDR(__struct_cast(A6XX_PDC_GPU_TCS0_CMD0_ADDR) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS0_CMD0_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS0_CMD0_DATA(struct A6XX_PDC_GPU_TCS0_CMD0_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001545,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS0_CMD0_DATA(...) pack_A6XX_PDC_GPU_TCS0_CMD0_DATA(__struct_cast(A6XX_PDC_GPU_TCS0_CMD0_DATA) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CONTROL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CONTROL(struct A6XX_PDC_GPU_TCS1_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001572,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CONTROL(...) pack_A6XX_PDC_GPU_TCS1_CONTROL(__struct_cast(A6XX_PDC_GPU_TCS1_CONTROL) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK(struct A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001573,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK(...) pack_A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK(__struct_cast(A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK(struct A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001574,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK(...) pack_A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK(__struct_cast(A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CMD0_MSGID {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CMD0_MSGID(struct A6XX_PDC_GPU_TCS1_CMD0_MSGID fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001575,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CMD0_MSGID(...) pack_A6XX_PDC_GPU_TCS1_CMD0_MSGID(__struct_cast(A6XX_PDC_GPU_TCS1_CMD0_MSGID) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CMD0_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CMD0_ADDR(struct A6XX_PDC_GPU_TCS1_CMD0_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001576,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CMD0_ADDR(...) pack_A6XX_PDC_GPU_TCS1_CMD0_ADDR(__struct_cast(A6XX_PDC_GPU_TCS1_CMD0_ADDR) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS1_CMD0_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS1_CMD0_DATA(struct A6XX_PDC_GPU_TCS1_CMD0_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00001577,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS1_CMD0_DATA(...) pack_A6XX_PDC_GPU_TCS1_CMD0_DATA(__struct_cast(A6XX_PDC_GPU_TCS1_CMD0_DATA) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CONTROL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CONTROL(struct A6XX_PDC_GPU_TCS2_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CONTROL(...) pack_A6XX_PDC_GPU_TCS2_CONTROL(__struct_cast(A6XX_PDC_GPU_TCS2_CONTROL) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK(struct A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK(...) pack_A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK(__struct_cast(A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK(struct A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK(...) pack_A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK(__struct_cast(A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CMD0_MSGID {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CMD0_MSGID(struct A6XX_PDC_GPU_TCS2_CMD0_MSGID fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CMD0_MSGID(...) pack_A6XX_PDC_GPU_TCS2_CMD0_MSGID(__struct_cast(A6XX_PDC_GPU_TCS2_CMD0_MSGID) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CMD0_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CMD0_ADDR(struct A6XX_PDC_GPU_TCS2_CMD0_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CMD0_ADDR(...) pack_A6XX_PDC_GPU_TCS2_CMD0_ADDR(__struct_cast(A6XX_PDC_GPU_TCS2_CMD0_ADDR) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS2_CMD0_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS2_CMD0_DATA(struct A6XX_PDC_GPU_TCS2_CMD0_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015a9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS2_CMD0_DATA(...) pack_A6XX_PDC_GPU_TCS2_CMD0_DATA(__struct_cast(A6XX_PDC_GPU_TCS2_CMD0_DATA) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CONTROL {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CONTROL(struct A6XX_PDC_GPU_TCS3_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015d6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CONTROL(...) pack_A6XX_PDC_GPU_TCS3_CONTROL(__struct_cast(A6XX_PDC_GPU_TCS3_CONTROL) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK(struct A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015d7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK(...) pack_A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK(__struct_cast(A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK(struct A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015d8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK(...) pack_A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK(__struct_cast(A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CMD0_MSGID {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CMD0_MSGID(struct A6XX_PDC_GPU_TCS3_CMD0_MSGID fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015d9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CMD0_MSGID(...) pack_A6XX_PDC_GPU_TCS3_CMD0_MSGID(__struct_cast(A6XX_PDC_GPU_TCS3_CMD0_MSGID) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CMD0_ADDR {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CMD0_ADDR(struct A6XX_PDC_GPU_TCS3_CMD0_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015da,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CMD0_ADDR(...) pack_A6XX_PDC_GPU_TCS3_CMD0_ADDR(__struct_cast(A6XX_PDC_GPU_TCS3_CMD0_ADDR) { __VA_ARGS__ })

struct A6XX_PDC_GPU_TCS3_CMD0_DATA {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_TCS3_CMD0_DATA(struct A6XX_PDC_GPU_TCS3_CMD0_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000015db,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_TCS3_CMD0_DATA(...) pack_A6XX_PDC_GPU_TCS3_CMD0_DATA(__struct_cast(A6XX_PDC_GPU_TCS3_CMD0_DATA) { __VA_ARGS__ })

struct A6XX_PDC_GPU_SEQ_MEM_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_PDC_GPU_SEQ_MEM_0(struct A6XX_PDC_GPU_SEQ_MEM_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000000,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PDC_GPU_SEQ_MEM_0(...) pack_A6XX_PDC_GPU_SEQ_MEM_0(__struct_cast(A6XX_PDC_GPU_SEQ_MEM_0) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_A {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_A(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_SEL_A) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_B {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_B(struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000001,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_B(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_B(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_SEL_B) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_C {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_C(struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000002,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_C(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_C(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_SEL_C) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_D {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_D(struct A6XX_CX_DBGC_CFG_DBGBUS_SEL_D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000003,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_D(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_SEL_D(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_SEL_D) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_CNTLT {
    uint32_t							traceen;
    uint32_t							granu;
    uint32_t							segt;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_CNTLT(struct A6XX_CX_DBGC_CFG_DBGBUS_CNTLT fields)
{
#ifndef NDEBUG
    assert((fields.traceen                           & 0xffffffc0) == 0);
    assert((fields.granu                             & 0xfffffff8) == 0);
    assert((fields.segt                              & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xf000703f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000004,
        .value =
            (fields.traceen                           <<  0) |
            (fields.granu                             << 12) |
            (fields.segt                              << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_CNTLT(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_CNTLT) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_CNTLM {
    uint32_t							enable;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_CNTLM(struct A6XX_CX_DBGC_CFG_DBGBUS_CNTLM fields)
{
#ifndef NDEBUG
    assert((fields.enable                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0f000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000005,
        .value =
            (fields.enable                            << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLM(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_CNTLM(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_CNTLM) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0(struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000008,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1(struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000009,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2(struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3(struct A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0(struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1(struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2(struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3(struct A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0 {
    uint32_t							bytel0;
    uint32_t							bytel1;
    uint32_t							bytel2;
    uint32_t							bytel3;
    uint32_t							bytel4;
    uint32_t							bytel5;
    uint32_t							bytel6;
    uint32_t							bytel7;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0(struct A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0 fields)
{
#ifndef NDEBUG
    assert((fields.bytel0                            & 0xfffffff0) == 0);
    assert((fields.bytel1                            & 0xfffffff0) == 0);
    assert((fields.bytel2                            & 0xfffffff0) == 0);
    assert((fields.bytel3                            & 0xfffffff0) == 0);
    assert((fields.bytel4                            & 0xfffffff0) == 0);
    assert((fields.bytel5                            & 0xfffffff0) == 0);
    assert((fields.bytel6                            & 0xfffffff0) == 0);
    assert((fields.bytel7                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000010,
        .value =
            (fields.bytel0                            <<  0) |
            (fields.bytel1                            <<  4) |
            (fields.bytel2                            <<  8) |
            (fields.bytel3                            << 12) |
            (fields.bytel4                            << 16) |
            (fields.bytel5                            << 20) |
            (fields.bytel6                            << 24) |
            (fields.bytel7                            << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1 {
    uint32_t							bytel8;
    uint32_t							bytel9;
    uint32_t							bytel10;
    uint32_t							bytel11;
    uint32_t							bytel12;
    uint32_t							bytel13;
    uint32_t							bytel14;
    uint32_t							bytel15;
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1(struct A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.bytel8                            & 0xfffffff0) == 0);
    assert((fields.bytel9                            & 0xfffffff0) == 0);
    assert((fields.bytel10                           & 0xfffffff0) == 0);
    assert((fields.bytel11                           & 0xfffffff0) == 0);
    assert((fields.bytel12                           & 0xfffffff0) == 0);
    assert((fields.bytel13                           & 0xfffffff0) == 0);
    assert((fields.bytel14                           & 0xfffffff0) == 0);
    assert((fields.bytel15                           & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000011,
        .value =
            (fields.bytel8                            <<  0) |
            (fields.bytel9                            <<  4) |
            (fields.bytel10                           <<  8) |
            (fields.bytel11                           << 12) |
            (fields.bytel12                           << 16) |
            (fields.bytel13                           << 20) |
            (fields.bytel14                           << 24) |
            (fields.bytel15                           << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1(struct A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1) { __VA_ARGS__ })

struct A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2(struct A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000030,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2(...) pack_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2(__struct_cast(A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2) { __VA_ARGS__ })

struct A7XX_CX_DBGC_CFG_DBGBUS_SEL_A {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CX_DBGC_CFG_DBGBUS_SEL_A(...) pack_A7XX_CX_DBGC_CFG_DBGBUS_SEL_A(__struct_cast(A7XX_CX_DBGC_CFG_DBGBUS_SEL_A) { __VA_ARGS__ })

struct A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0(struct A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000001,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0(...) pack_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0(__struct_cast(A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0) { __VA_ARGS__ })

struct A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1 {
    uint32_t							dword;
    uint32_t							unknown;
};

static CONSTEXPR inline struct fd_reg_pair
pack_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1(struct A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000002,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1(...) pack_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1(__struct_cast(A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1) { __VA_ARGS__ })

struct A7XX_CX_MISC_TCM_RET_CNTL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CX_MISC_TCM_RET_CNTL(...) pack_A7XX_CX_MISC_TCM_RET_CNTL(__struct_cast(A7XX_CX_MISC_TCM_RET_CNTL) { __VA_ARGS__ })

struct A8XX_CX_MISC_SLICE_ENABLE_FINAL {
    uint32_t							dword;
    uint32_t							unknown;
};

#define A8XX_CX_MISC_SLICE_ENABLE_FINAL(...) pack_A8XX_CX_MISC_SLICE_ENABLE_FINAL(__struct_cast(A8XX_CX_MISC_SLICE_ENABLE_FINAL) { __VA_ARGS__ })

struct A7XX_CX_MISC_SW_FUSE_VALUE {
    bool							fastblend;
    bool							lpac;
    bool							raytracing;
    uint32_t							dword;
    uint32_t							unknown;
};

#define A7XX_CX_MISC_SW_FUSE_VALUE(...) pack_A7XX_CX_MISC_SW_FUSE_VALUE(__struct_cast(A7XX_CX_MISC_SW_FUSE_VALUE) { __VA_ARGS__ })

#ifdef __cplusplus
struct __CP_RB_RPTR_WR {
    /* A7XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_WR(struct __CP_RB_RPTR_WR fields) {
  if (CHIP >= A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000803,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_WR(VARIANT, ...) __CP_RB_RPTR_WR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_RPTR_ADDR_BV {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_ADDR_BV(struct __CP_RB_RPTR_ADDR_BV fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000808,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_ADDR_BV(VARIANT, ...) __CP_RB_RPTR_ADDR_BV<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_RPTR_BV {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_BV(struct __CP_RB_RPTR_BV fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_BV(VARIANT, ...) __CP_RB_RPTR_BV<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_BASE_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_BASE_LPAC(struct __CP_RB_BASE_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080b,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_BASE_LPAC(VARIANT, ...) __CP_RB_BASE_LPAC<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_CNTL_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_CNTL_LPAC(struct __CP_RB_CNTL_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080d,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_CNTL_LPAC(VARIANT, ...) __CP_RB_CNTL_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_RPTR_WR_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_WR_LPAC(struct __CP_RB_RPTR_WR_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_WR_LPAC(VARIANT, ...) __CP_RB_RPTR_WR_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_RPTR_ADDR_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_ADDR_LPAC(struct __CP_RB_RPTR_ADDR_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080f,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_ADDR_LPAC(VARIANT, ...) __CP_RB_RPTR_ADDR_LPAC<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_RPTR_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_RPTR_LPAC(struct __CP_RB_RPTR_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000811,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_RPTR_LPAC(VARIANT, ...) __CP_RB_RPTR_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RB_WPTR_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RB_WPTR_LPAC(struct __CP_RB_WPTR_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000812,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RB_WPTR_LPAC(VARIANT, ...) __CP_RB_WPTR_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SMMU_STREAM_ID_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SMMU_STREAM_ID_LPAC(struct __CP_SMMU_STREAM_ID_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000814,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SMMU_STREAM_ID_LPAC(VARIANT, ...) __CP_SMMU_STREAM_ID_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_CNTL(struct __CP_SQE_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000808,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000815,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_CNTL(VARIANT, ...) __CP_SQE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_INSTR_BASE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_INSTR_BASE(struct __CP_SQE_INSTR_BASE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000816,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000830,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_INSTR_BASE(VARIANT, ...) __CP_SQE_INSTR_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_INSTR_BASE_0 {
    /* A8XX- fields: */
    /* A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_INSTR_BASE_0(struct __CP_AQE_INSTR_BASE_0 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000818,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b70,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_INSTR_BASE_0(VARIANT, ...) __CP_AQE_INSTR_BASE_0<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_INSTR_BASE_1 {
    /* A8XX- fields: */
    /* A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_INSTR_BASE_1(struct __CP_AQE_INSTR_BASE_1 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081a,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b72,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_INSTR_BASE_1(VARIANT, ...) __CP_AQE_INSTR_BASE_1<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CP2GMU_STATUS {
    /* A6XX-A7XX fields: */
    bool							ifpc;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CP2GMU_STATUS(struct __CP_CP2GMU_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000812,
        .value =
            (fields.ifpc                              <<  0) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000822,
        .value =
            (fields.ifpc                              <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CP2GMU_STATUS(VARIANT, ...) __CP_CP2GMU_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_HW_FAULT {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_HW_FAULT(struct __CP_HW_FAULT fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000821,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_HW_FAULT(VARIANT, ...) __CP_HW_FAULT<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_INTERRUPT_STATUS {
    /* A6XX-A7XX fields: */
    bool							cp_opcode_error;
    bool							cp_ucode_error;
    bool							cp_hw_fault_error;
    bool							cp_register_protection_error;
    bool							cp_ahb_error;
    bool							cp_vsd_parity_error;
    bool							cp_illegal_instr_error;
    bool							cp_opcode_error_lpac;
    bool							cp_ucode_error_lpac;
    bool							cp_hw_fault_error_lpac;
    bool							cp_register_protection_error_lpac;
    bool							cp_illegal_instr_error_lpac;
    bool							cp_opcode_error_bv;
    bool							cp_ucode_error_bv;
    bool							cp_hw_fault_error_bv;
    bool							cp_register_protection_error_bv;
    bool							cp_illegal_instr_error_bv;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_INTERRUPT_STATUS(struct __CP_INTERRUPT_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0003fff7) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000823,
        .value =
            (fields.cp_opcode_error                   <<  0) |
            (fields.cp_ucode_error                    <<  1) |
            (fields.cp_hw_fault_error                 <<  2) |
            (fields.cp_register_protection_error      <<  4) |
            (fields.cp_ahb_error                      <<  5) |
            (fields.cp_vsd_parity_error               <<  6) |
            (fields.cp_illegal_instr_error            <<  7) |
            (fields.cp_opcode_error_lpac              <<  8) |
            (fields.cp_ucode_error_lpac               <<  9) |
            (fields.cp_hw_fault_error_lpac            << 10) |
            (fields.cp_register_protection_error_lpac << 11) |
            (fields.cp_illegal_instr_error_lpac       << 12) |
            (fields.cp_opcode_error_bv                << 13) |
            (fields.cp_ucode_error_bv                 << 14) |
            (fields.cp_hw_fault_error_bv              << 15) |
            (fields.cp_register_protection_error_bv   << 16) |
            (fields.cp_illegal_instr_error_bv         << 17) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_INTERRUPT_STATUS(VARIANT, ...) __CP_INTERRUPT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_STATUS(struct __CP_PROTECT_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.addr                              & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x0073ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000824,
        .value =
            (fields.addr                              <<  0) |
            (fields.read                              << 20) |
            (fields.cp_halted                         << 21) |
            (fields.access_violation                  << 22) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_STATUS(VARIANT, ...) __CP_PROTECT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_STATUS_PIPE {
    /* A8XX- fields: */
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_STATUS_PIPE(struct __CP_PROTECT_STATUS_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.addr                              & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x0073ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084f,
        .value =
            (fields.addr                              <<  0) |
            (fields.read                              << 20) |
            (fields.cp_halted                         << 21) |
            (fields.access_violation                  << 22) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_STATUS_PIPE(VARIANT, ...) __CP_PROTECT_STATUS_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_STATUS_1 {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_STATUS_1(struct __CP_STATUS_1 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000825,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_STATUS_1(VARIANT, ...) __CP_STATUS_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SEMAPHORE_REG_0 {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SEMAPHORE_REG_0(struct __CP_SEMAPHORE_REG_0 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000825,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SEMAPHORE_REG_0(VARIANT, ...) __CP_SEMAPHORE_REG_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SCRATCH_GLOBAL_REG {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SCRATCH_GLOBAL_REG(int __i, struct __CP_SCRATCH_GLOBAL_REG fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000082a + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SCRATCH_GLOBAL_REG(VARIANT, __i, ...) __CP_SCRATCH_GLOBAL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SCRATCH_PIPE_REG {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SCRATCH_PIPE_REG(int __i, struct __CP_SCRATCH_PIPE_REG fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000830 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SCRATCH_PIPE_REG(VARIANT, __i, ...) __CP_SCRATCH_PIPE_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RL_ERROR_DETAILS_0 {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RL_ERROR_DETAILS_0(struct __CP_RL_ERROR_DETAILS_0 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000840,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RL_ERROR_DETAILS_0(VARIANT, ...) __CP_RL_ERROR_DETAILS_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RL_ERROR_DETAILS_1 {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RL_ERROR_DETAILS_1(struct __CP_RL_ERROR_DETAILS_1 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000841,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RL_ERROR_DETAILS_1(VARIANT, ...) __CP_RL_ERROR_DETAILS_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MISC_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MISC_CNTL(struct __CP_MISC_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000840,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084c,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MISC_CNTL(VARIANT, ...) __CP_MISC_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_ICACHE_CNTL_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_ICACHE_CNTL_PIPE(struct __CP_SQE_ICACHE_CNTL_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_ICACHE_CNTL_PIPE(VARIANT, ...) __CP_SQE_ICACHE_CNTL_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_DCACHE_CNTL_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_DCACHE_CNTL_PIPE(struct __CP_SQE_DCACHE_CNTL_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b1,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_DCACHE_CNTL_PIPE(VARIANT, ...) __CP_SQE_DCACHE_CNTL_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_HW_FAULT_STATUS_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_HW_FAULT_STATUS_PIPE(struct __CP_HW_FAULT_STATUS_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b3,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_HW_FAULT_STATUS_PIPE(VARIANT, ...) __CP_HW_FAULT_STATUS_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_HW_FAULT_STATUS_MASK_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_HW_FAULT_STATUS_MASK_PIPE(struct __CP_HW_FAULT_STATUS_MASK_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b4,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_HW_FAULT_STATUS_MASK_PIPE(VARIANT, ...) __CP_HW_FAULT_STATUS_MASK_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_INTERRUPT_STATUS_GLOBAL {
    /* A8XX- fields: */
    bool							hwfaultbr;
    bool							hwfaultbv;
    bool							hwfaultlpac;
    bool							hwfaultaqe0;
    bool							hwfaultaqe1;
    bool							hwfaultddebr;
    bool							hwfaultddebv;
    bool							swfaultbr;
    bool							swfaultbv;
    bool							swfaultlpac;
    bool							swfaultaqe0;
    bool							swfaultaqe1;
    bool							swfaultddebr;
    bool							swfaultddebv;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_INTERRUPT_STATUS_GLOBAL(struct __CP_INTERRUPT_STATUS_GLOBAL fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x007f007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b5,
        .value =
            (fields.hwfaultbr                         <<  0) |
            (fields.hwfaultbv                         <<  1) |
            (fields.hwfaultlpac                       <<  2) |
            (fields.hwfaultaqe0                       <<  3) |
            (fields.hwfaultaqe1                       <<  4) |
            (fields.hwfaultddebr                      <<  5) |
            (fields.hwfaultddebv                      <<  6) |
            (fields.swfaultbr                         << 16) |
            (fields.swfaultbv                         << 17) |
            (fields.swfaultlpac                       << 18) |
            (fields.swfaultaqe0                       << 19) |
            (fields.swfaultaqe1                       << 20) |
            (fields.swfaultddebr                      << 21) |
            (fields.swfaultddebv                      << 22) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_INTERRUPT_STATUS_GLOBAL(VARIANT, ...) __CP_INTERRUPT_STATUS_GLOBAL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_INTERRUPT_STATUS_MASK_GLOBAL {
    /* A8XX- fields: */
    bool							hwfaultbr;
    bool							hwfaultbv;
    bool							hwfaultlpac;
    bool							hwfaultaqe0;
    bool							hwfaultaqe1;
    bool							hwfaultddebr;
    bool							hwfaultddebv;
    bool							swfaultbr;
    bool							swfaultbv;
    bool							swfaultlpac;
    bool							swfaultaqe0;
    bool							swfaultaqe1;
    bool							swfaultddebr;
    bool							swfaultddebv;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_INTERRUPT_STATUS_MASK_GLOBAL(struct __CP_INTERRUPT_STATUS_MASK_GLOBAL fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x007f007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b6,
        .value =
            (fields.hwfaultbr                         <<  0) |
            (fields.hwfaultbv                         <<  1) |
            (fields.hwfaultlpac                       <<  2) |
            (fields.hwfaultaqe0                       <<  3) |
            (fields.hwfaultaqe1                       <<  4) |
            (fields.hwfaultddebr                      <<  5) |
            (fields.hwfaultddebv                      <<  6) |
            (fields.swfaultbr                         << 16) |
            (fields.swfaultbv                         << 17) |
            (fields.swfaultlpac                       << 18) |
            (fields.swfaultaqe0                       << 19) |
            (fields.swfaultaqe1                       << 20) |
            (fields.swfaultddebr                      << 21) |
            (fields.swfaultddebv                      << 22) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_INTERRUPT_STATUS_MASK_GLOBAL(VARIANT, ...) __CP_INTERRUPT_STATUS_MASK_GLOBAL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_INTERRUPT_STATUS_PIPE {
    /* A8XX- fields: */
    bool							csfrbwrap;
    bool							csfib1wrap;
    bool							csfib2wrap;
    bool							csfib3wrap;
    bool							csfsdswrap;
    bool							csfmrbwrap;
    bool							csfvsdwrap;
    bool							opcodeerror;
    bool							vsdparityerror;
    bool							registerprotectionerror;
    bool							illegalinstruction;
    bool							smmufault;
    bool							vbifresp;
    bool							rtwrovf;
    bool							lrzrtwrovf;
    bool							lrzrtrefcntovf;
    bool							lrzrtclrresmiss;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_INTERRUPT_STATUS_PIPE(struct __CP_INTERRUPT_STATUS_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x07c01f7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b7,
        .value =
            (fields.csfrbwrap                         <<  0) |
            (fields.csfib1wrap                        <<  1) |
            (fields.csfib2wrap                        <<  2) |
            (fields.csfib3wrap                        <<  3) |
            (fields.csfsdswrap                        <<  4) |
            (fields.csfmrbwrap                        <<  5) |
            (fields.csfvsdwrap                        <<  6) |
            (fields.opcodeerror                       <<  8) |
            (fields.vsdparityerror                    <<  9) |
            (fields.registerprotectionerror           << 10) |
            (fields.illegalinstruction                << 11) |
            (fields.smmufault                         << 12) |
            (fields.vbifresp                          << 22) |
            (fields.rtwrovf                           << 23) |
            (fields.lrzrtwrovf                        << 24) |
            (fields.lrzrtrefcntovf                    << 25) |
            (fields.lrzrtclrresmiss                   << 26) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_INTERRUPT_STATUS_PIPE(VARIANT, ...) __CP_INTERRUPT_STATUS_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_INTERRUPT_STATUS_MASK_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_INTERRUPT_STATUS_MASK_PIPE(struct __CP_INTERRUPT_STATUS_MASK_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b8,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_INTERRUPT_STATUS_MASK_PIPE(VARIANT, ...) __CP_INTERRUPT_STATUS_MASK_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PIPE_STATUS_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PIPE_STATUS_PIPE(struct __CP_PIPE_STATUS_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b9,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PIPE_STATUS_PIPE(VARIANT, ...) __CP_PIPE_STATUS_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_GPU_BATCH_ID_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_GPU_BATCH_ID_PIPE(struct __CP_GPU_BATCH_ID_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ba,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_GPU_BATCH_ID_PIPE(VARIANT, ...) __CP_GPU_BATCH_ID_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_STATUS_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_STATUS_PIPE(struct __CP_SQE_STATUS_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008bb,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_STATUS_PIPE(VARIANT, ...) __CP_SQE_STATUS_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APRIV_CNTL {
    /* A6XX-A7XX fields: */
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APRIV_CNTL(struct __CP_APRIV_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000844,
        .value =
            (fields.cdwrite                           <<  6) |
            (fields.cdread                            <<  5) |
            (fields.scratchwt                         <<  4) |
            (fields.rbrpwb                            <<  3) |
            (fields.rbprivlevel                       <<  2) |
            (fields.rbfetch                           <<  1) |
            (fields.icache                            <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APRIV_CNTL(VARIANT, ...) __CP_APRIV_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APRIV_CNTL_PIPE {
    /* A8XX- fields: */
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APRIV_CNTL_PIPE(struct __CP_APRIV_CNTL_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084d,
        .value =
            (fields.cdwrite                           <<  6) |
            (fields.cdread                            <<  5) |
            (fields.scratchwt                         <<  4) |
            (fields.rbrpwb                            <<  3) |
            (fields.rbprivlevel                       <<  2) |
            (fields.rbfetch                           <<  1) |
            (fields.icache                            <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APRIV_CNTL_PIPE(VARIANT, ...) __CP_APRIV_CNTL_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PREEMPT_THRESHOLD {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PREEMPT_THRESHOLD(struct __CP_PREEMPT_THRESHOLD fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ec,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PREEMPT_THRESHOLD(VARIANT, ...) __CP_PREEMPT_THRESHOLD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_THRESHOLDS_1 {
    /* A6XX fields: */
    uint32_t							mrb_start;
    uint32_t							vsd_start;
    uint32_t							ib1_start;
    uint32_t							ib2_start;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_THRESHOLDS_1(struct __CP_ROQ_THRESHOLDS_1 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert(((fields.mrb_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.vsd_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.ib1_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.ib2_start >> 2)                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c1,
        .value =
            ((fields.mrb_start >> 2)                  <<  0) |
            ((fields.vsd_start >> 2)                  <<  8) |
            ((fields.ib1_start >> 2)                  << 16) |
            ((fields.ib2_start >> 2)                  << 24) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_THRESHOLDS_1(VARIANT, ...) __CP_ROQ_THRESHOLDS_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_THRESHOLDS_2 {
    /* A6XX fields: */
    uint32_t							sds_start;
    uint32_t							roq_size;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_THRESHOLDS_2(struct __CP_ROQ_THRESHOLDS_2 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert(((fields.sds_start >> 2)                  & 0xfffffe00) == 0);
    assert(((fields.roq_size >> 2)                   & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff01ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c2,
        .value =
            ((fields.sds_start >> 2)                  <<  0) |
            ((fields.roq_size >> 2)                   << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_THRESHOLDS_2(VARIANT, ...) __CP_ROQ_THRESHOLDS_2<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MEM_POOL_SIZE {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MEM_POOL_SIZE(struct __CP_MEM_POOL_SIZE fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c3,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MEM_POOL_SIZE(VARIANT, ...) __CP_MEM_POOL_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CHICKEN_DBG {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CHICKEN_DBG(struct __CP_CHICKEN_DBG fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000841,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CHICKEN_DBG(VARIANT, ...) __CP_CHICKEN_DBG<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CHICKEN_DBG_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CHICKEN_DBG_PIPE(struct __CP_CHICKEN_DBG_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b2,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CHICKEN_DBG_PIPE(VARIANT, ...) __CP_CHICKEN_DBG_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ADDR_MODE_CNTL {
    /* A6XX fields: */
    enum a5xx_address_mode					cp_addr_mode_cntl;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ADDR_MODE_CNTL(struct __CP_ADDR_MODE_CNTL fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.cp_addr_mode_cntl                 & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000842,
        .value =
            (fields.cp_addr_mode_cntl                 <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ADDR_MODE_CNTL(VARIANT, ...) __CP_ADDR_MODE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_DBG_ECO_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_DBG_ECO_CNTL(struct __CP_DBG_ECO_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000843,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_DBG_ECO_CNTL(VARIANT, ...) __CP_DBG_ECO_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_CNTL {
    /* A6XX-A7XX fields: */
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_CNTL(struct __CP_PROTECT_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000b) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084f,
        .value =
            (fields.last_span_inf_range               <<  3) |
            (fields.access_fault_on_viol_en           <<  1) |
            (fields.access_prot_en                    <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_CNTL(VARIANT, ...) __CP_PROTECT_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_CNTL_PIPE {
    /* A8XX- fields: */
    uint32_t							halt_sqe_range;
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_CNTL_PIPE(struct __CP_PROTECT_CNTL_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.halt_sqe_range                    & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff000b) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084e,
        .value =
            (fields.halt_sqe_range                    << 16) |
            (fields.last_span_inf_range               <<  3) |
            (fields.access_fault_on_viol_en           <<  1) |
            (fields.access_prot_en                    <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_CNTL_PIPE(VARIANT, ...) __CP_PROTECT_CNTL_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SCRATCH_REG {
    /* A6XX-A7XX fields: */
    uint32_t							cp_scratch_reg;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SCRATCH_REG(int __i, struct __CP_SCRATCH_REG fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.cp_scratch_reg                    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000883 + 0x1*__i),
        .value =
            (fields.cp_scratch_reg                    <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SCRATCH_REG(VARIANT, __i, ...) __CP_SCRATCH_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_REG {
    /* A6XX-A7XX fields: */
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_REG(int __i, struct __CP_PROTECT_REG fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000850 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_REG(VARIANT, __i, ...) __CP_PROTECT_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_GLOBAL_REG {
    /* A8XX- fields: */
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_GLOBAL_REG(int __i, struct __CP_PROTECT_GLOBAL_REG fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000850 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_GLOBAL_REG(VARIANT, __i, ...) __CP_PROTECT_GLOBAL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PROTECT_PIPE_REG {
    /* A8XX- fields: */
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PROTECT_PIPE_REG(int __i, struct __CP_PROTECT_PIPE_REG fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008a0 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PROTECT_PIPE_REG(VARIANT, __i, ...) __CP_PROTECT_PIPE_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_CNTL {
    /* A6XX-A7XX fields: */
    bool							stop;
    uint32_t							level;
    bool							uses_gmem;
    bool							skip_save_restore;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_CNTL(struct __CP_CONTEXT_SWITCH_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.level                             & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000003c1) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a0,
        .value =
            (fields.stop                              <<  0) |
            (fields.level                             <<  6) |
            (fields.uses_gmem                         <<  8) |
            (fields.skip_save_restore                 <<  9) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.level                             & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000003c1) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c0,
        .value =
            (fields.stop                              <<  0) |
            (fields.level                             <<  6) |
            (fields.uses_gmem                         <<  8) |
            (fields.skip_save_restore                 <<  9) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_CNTL(VARIANT, ...) __CP_CONTEXT_SWITCH_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_SMMU_INFO {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_SMMU_INFO(struct __CP_CONTEXT_SWITCH_SMMU_INFO fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a1,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c1,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_SMMU_INFO(VARIANT, ...) __CP_CONTEXT_SWITCH_SMMU_INFO<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(struct __CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a3,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c3,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(VARIANT, ...) __CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(struct __CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a5,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c5,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(VARIANT, ...) __CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(struct __CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a7,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c7,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(VARIANT, ...) __CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CONTEXT_SWITCH_LEVEL_STATUS {
    /* A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CONTEXT_SWITCH_LEVEL_STATUS(struct __CP_CONTEXT_SWITCH_LEVEL_STATUS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ab,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008cb,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CONTEXT_SWITCH_LEVEL_STATUS(VARIANT, ...) __CP_CONTEXT_SWITCH_LEVEL_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_PERFCTR_CP_SEL_REG {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_PERFCTR_CP_SEL_REG(int __i, struct __CP_PERFCTR_CP_SEL_REG fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008d0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008d0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_PERFCTR_CP_SEL_REG(VARIANT, __i, ...) __CP_PERFCTR_CP_SEL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_PERFCTR_CP_SEL_REG {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_PERFCTR_CP_SEL_REG(int __i, struct __CP_BV_PERFCTR_CP_SEL_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008e0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_PERFCTR_CP_SEL_REG(VARIANT, __i, ...) __CP_BV_PERFCTR_CP_SEL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CRASH_DUMP_SCRIPT_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CRASH_DUMP_SCRIPT_BASE(struct __CP_CRASH_DUMP_SCRIPT_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000900,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000842,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CRASH_DUMP_SCRIPT_BASE(VARIANT, ...) __CP_CRASH_DUMP_SCRIPT_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CRASH_DUMP_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CRASH_DUMP_CNTL(struct __CP_CRASH_DUMP_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000902,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000844,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CRASH_DUMP_CNTL(VARIANT, ...) __CP_CRASH_DUMP_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_CRASH_DUMP_STATUS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_CRASH_DUMP_STATUS(struct __CP_CRASH_DUMP_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000903,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000845,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_CRASH_DUMP_STATUS(VARIANT, ...) __CP_CRASH_DUMP_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_STAT_ADDR {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_STAT_ADDR(struct __CP_SQE_STAT_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000908,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_STAT_ADDR(VARIANT, ...) __CP_SQE_STAT_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_STAT_DATA {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_STAT_DATA(struct __CP_SQE_STAT_DATA fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000909,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_STAT_DATA(VARIANT, ...) __CP_SQE_STAT_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_DRAW_STATE_ADDR {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_DRAW_STATE_ADDR(struct __CP_DRAW_STATE_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_DRAW_STATE_ADDR(VARIANT, ...) __CP_DRAW_STATE_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_DRAW_STATE_DATA {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_DRAW_STATE_DATA(struct __CP_DRAW_STATE_DATA fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_DRAW_STATE_DATA(VARIANT, ...) __CP_DRAW_STATE_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_DBG_ADDR {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_DBG_ADDR(struct __CP_ROQ_DBG_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090c,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_DBG_ADDR(VARIANT, ...) __CP_ROQ_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_DBG_DATA {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_DBG_DATA(struct __CP_ROQ_DBG_DATA fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090d,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_DBG_DATA(VARIANT, ...) __CP_ROQ_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MEM_POOL_DBG_ADDR {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MEM_POOL_DBG_ADDR(struct __CP_MEM_POOL_DBG_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MEM_POOL_DBG_ADDR(VARIANT, ...) __CP_MEM_POOL_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MEM_POOL_DBG_DATA {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MEM_POOL_DBG_DATA(struct __CP_MEM_POOL_DBG_DATA fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090f,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MEM_POOL_DBG_DATA(VARIANT, ...) __CP_MEM_POOL_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_UCODE_DBG_ADDR {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_UCODE_DBG_ADDR(struct __CP_SQE_UCODE_DBG_ADDR fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000910,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_UCODE_DBG_ADDR(VARIANT, ...) __CP_SQE_UCODE_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_UCODE_DBG_DATA {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_UCODE_DBG_DATA(struct __CP_SQE_UCODE_DBG_DATA fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000911,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_UCODE_DBG_DATA(VARIANT, ...) __CP_SQE_UCODE_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_STAT_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_STAT_ADDR_PIPE(struct __CP_SQE_STAT_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_STAT_ADDR_PIPE(VARIANT, ...) __CP_SQE_STAT_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_STAT_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_STAT_DATA_PIPE(struct __CP_SQE_STAT_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f1,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_STAT_DATA_PIPE(VARIANT, ...) __CP_SQE_STAT_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_DRAW_STATE_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_DRAW_STATE_ADDR_PIPE(struct __CP_DRAW_STATE_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f2,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_DRAW_STATE_ADDR_PIPE(VARIANT, ...) __CP_DRAW_STATE_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_DRAW_STATE_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_DRAW_STATE_DATA_PIPE(struct __CP_DRAW_STATE_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f3,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_DRAW_STATE_DATA_PIPE(VARIANT, ...) __CP_DRAW_STATE_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_DBG_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_DBG_ADDR_PIPE(struct __CP_ROQ_DBG_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f4,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_DBG_ADDR_PIPE(VARIANT, ...) __CP_ROQ_DBG_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_DBG_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_DBG_DATA_PIPE(struct __CP_ROQ_DBG_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f5,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_DBG_DATA_PIPE(VARIANT, ...) __CP_ROQ_DBG_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MEM_POOL_DBG_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MEM_POOL_DBG_ADDR_PIPE(struct __CP_MEM_POOL_DBG_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f6,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MEM_POOL_DBG_ADDR_PIPE(VARIANT, ...) __CP_MEM_POOL_DBG_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MEM_POOL_DBG_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MEM_POOL_DBG_DATA_PIPE(struct __CP_MEM_POOL_DBG_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f7,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MEM_POOL_DBG_DATA_PIPE(VARIANT, ...) __CP_MEM_POOL_DBG_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_UCODE_DBG_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_UCODE_DBG_ADDR_PIPE(struct __CP_SQE_UCODE_DBG_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f8,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_UCODE_DBG_ADDR_PIPE(VARIANT, ...) __CP_SQE_UCODE_DBG_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_UCODE_DBG_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_UCODE_DBG_DATA_PIPE(struct __CP_SQE_UCODE_DBG_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f9,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_UCODE_DBG_DATA_PIPE(VARIANT, ...) __CP_SQE_UCODE_DBG_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RESOURCE_TABLE_DBG_ADDR_BV {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RESOURCE_TABLE_DBG_ADDR_BV(struct __CP_RESOURCE_TABLE_DBG_ADDR_BV fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fa,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RESOURCE_TABLE_DBG_ADDR_BV(VARIANT, ...) __CP_RESOURCE_TABLE_DBG_ADDR_BV<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RESOURCE_TABLE_DBG_DATA_BV {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RESOURCE_TABLE_DBG_DATA_BV(struct __CP_RESOURCE_TABLE_DBG_DATA_BV fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fb,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RESOURCE_TABLE_DBG_DATA_BV(VARIANT, ...) __CP_RESOURCE_TABLE_DBG_DATA_BV<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_FIFO_DBG_ADDR_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_FIFO_DBG_ADDR_LPAC(struct __CP_FIFO_DBG_ADDR_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fc,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_FIFO_DBG_ADDR_LPAC(VARIANT, ...) __CP_FIFO_DBG_ADDR_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_FIFO_DBG_DATA_LPAC {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_FIFO_DBG_DATA_LPAC(struct __CP_FIFO_DBG_DATA_LPAC fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fd,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_FIFO_DBG_DATA_LPAC(VARIANT, ...) __CP_FIFO_DBG_DATA_LPAC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_FIFO_DBG_ADDR_DDE_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_FIFO_DBG_ADDR_DDE_PIPE(struct __CP_FIFO_DBG_ADDR_DDE_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fe,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_FIFO_DBG_ADDR_DDE_PIPE(VARIANT, ...) __CP_FIFO_DBG_ADDR_DDE_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_FIFO_DBG_DATA_DDE_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_FIFO_DBG_DATA_DDE_PIPE(struct __CP_FIFO_DBG_DATA_DDE_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ff,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_FIFO_DBG_DATA_DDE_PIPE(VARIANT, ...) __CP_FIFO_DBG_DATA_DDE_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SLICE_MEM_POOL_DBG_ADDR_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(struct __CP_SLICE_MEM_POOL_DBG_ADDR_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b00,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(VARIANT, ...) __CP_SLICE_MEM_POOL_DBG_ADDR_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SLICE_MEM_POOL_DBG_DATA_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SLICE_MEM_POOL_DBG_DATA_PIPE(struct __CP_SLICE_MEM_POOL_DBG_DATA_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b01,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SLICE_MEM_POOL_DBG_DATA_PIPE(VARIANT, ...) __CP_SLICE_MEM_POOL_DBG_DATA_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SLICE_CHICKEN_DBG_PIPE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SLICE_CHICKEN_DBG_PIPE(struct __CP_SLICE_CHICKEN_DBG_PIPE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b93,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SLICE_CHICKEN_DBG_PIPE(VARIANT, ...) __CP_SLICE_CHICKEN_DBG_PIPE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB1_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB1_BASE(struct __CP_IB1_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000928,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000900,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB1_BASE(VARIANT, ...) __CP_IB1_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB1_REM_SIZE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB1_REM_SIZE(struct __CP_IB1_REM_SIZE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000902,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB1_REM_SIZE(VARIANT, ...) __CP_IB1_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB2_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB2_BASE(struct __CP_IB2_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092b,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000904,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB2_BASE(VARIANT, ...) __CP_IB2_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB2_REM_SIZE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB2_REM_SIZE(struct __CP_IB2_REM_SIZE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092d,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000906,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB2_REM_SIZE(VARIANT, ...) __CP_IB2_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SDS_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SDS_BASE(struct __CP_SDS_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092e,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090c,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SDS_BASE(VARIANT, ...) __CP_SDS_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SDS_REM_SIZE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SDS_REM_SIZE(struct __CP_SDS_REM_SIZE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000930,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SDS_REM_SIZE(VARIANT, ...) __CP_SDS_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MRB_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MRB_BASE(struct __CP_MRB_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000931,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000910,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MRB_BASE(VARIANT, ...) __CP_MRB_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MRB_REM_SIZE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MRB_REM_SIZE(struct __CP_MRB_REM_SIZE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000933,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000912,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MRB_REM_SIZE(VARIANT, ...) __CP_MRB_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_VSD_BASE {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_VSD_BASE(struct __CP_VSD_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000934,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000914,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_VSD_BASE(VARIANT, ...) __CP_VSD_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB1_INIT_SIZE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB1_INIT_SIZE(struct __CP_IB1_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000903,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000943,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB1_INIT_SIZE(VARIANT, ...) __CP_IB1_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB2_INIT_SIZE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB2_INIT_SIZE(struct __CP_IB2_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000907,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000944,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB2_INIT_SIZE(VARIANT, ...) __CP_IB2_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB3_BASE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB3_BASE(struct __CP_IB3_BASE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000908,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB3_BASE(VARIANT, ...) __CP_IB3_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB3_REM_SIZE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB3_REM_SIZE(struct __CP_IB3_REM_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB3_REM_SIZE(VARIANT, ...) __CP_IB3_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_IB3_INIT_SIZE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_IB3_INIT_SIZE(struct __CP_IB3_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_IB3_INIT_SIZE(VARIANT, ...) __CP_IB3_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SDS_INIT_SIZE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SDS_INIT_SIZE(struct __CP_SDS_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090f,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000945,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SDS_INIT_SIZE(VARIANT, ...) __CP_SDS_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_MRB_INIT_SIZE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_MRB_INIT_SIZE(struct __CP_MRB_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000913,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000946,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_MRB_INIT_SIZE(VARIANT, ...) __CP_MRB_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_VSD_REM_SIZE {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_VSD_REM_SIZE(struct __CP_VSD_REM_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000916,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_VSD_REM_SIZE(VARIANT, ...) __CP_VSD_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_VSD_INIT_SIZE {
    /* A8XX- fields: */
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_VSD_INIT_SIZE(struct __CP_VSD_INIT_SIZE fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000917,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000947,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_VSD_INIT_SIZE(VARIANT, ...) __CP_VSD_INIT_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_RB_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_RB_STATUS(struct __CP_ROQ_RB_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000939,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000920,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_RB_STATUS(VARIANT, ...) __CP_ROQ_RB_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_IB1_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_IB1_STATUS(struct __CP_ROQ_IB1_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093a,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000921,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_IB1_STATUS(VARIANT, ...) __CP_ROQ_IB1_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_IB2_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_IB2_STATUS(struct __CP_ROQ_IB2_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093b,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000922,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_IB2_STATUS(VARIANT, ...) __CP_ROQ_IB2_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_SDS_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_SDS_STATUS(struct __CP_ROQ_SDS_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093c,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000924,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_SDS_STATUS(VARIANT, ...) __CP_ROQ_SDS_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_MRB_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_MRB_STATUS(struct __CP_ROQ_MRB_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093d,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000925,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_MRB_STATUS(VARIANT, ...) __CP_ROQ_MRB_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_VSD_STATUS {
    /* A6XX-A7XX fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_VSD_STATUS(struct __CP_ROQ_VSD_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093e,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000926,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_VSD_STATUS(VARIANT, ...) __CP_ROQ_VSD_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_IB3_STATUS {
    /* A8XX- fields: */
    uint32_t							rptr;
    uint32_t							wptr;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_IB3_STATUS(struct __CP_ROQ_IB3_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000923,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_IB3_STATUS(VARIANT, ...) __CP_ROQ_IB3_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_RB {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_RB(struct __CP_ROQ_AVAIL_RB fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000948,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000918,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_RB(VARIANT, ...) __CP_ROQ_AVAIL_RB<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_IB1 {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_IB1(struct __CP_ROQ_AVAIL_IB1 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000949,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000919,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_IB1(VARIANT, ...) __CP_ROQ_AVAIL_IB1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_IB2 {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_IB2(struct __CP_ROQ_AVAIL_IB2 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094a,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091a,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_IB2(VARIANT, ...) __CP_ROQ_AVAIL_IB2<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_SDS {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_SDS(struct __CP_ROQ_AVAIL_SDS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094b,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091c,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_SDS(VARIANT, ...) __CP_ROQ_AVAIL_SDS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_MRB {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_MRB(struct __CP_ROQ_AVAIL_MRB fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094c,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091d,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_MRB(VARIANT, ...) __CP_ROQ_AVAIL_MRB<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_VSD {
    /* A6XX-A7XX fields: */
    uint32_t							rem;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_VSD(struct __CP_ROQ_AVAIL_VSD fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094d,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091e,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_VSD(VARIANT, ...) __CP_ROQ_AVAIL_VSD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ROQ_AVAIL_IB3 {
    /* A8XX- fields: */
    uint32_t							rem;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ROQ_AVAIL_IB3(struct __CP_ROQ_AVAIL_IB3 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091b,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ROQ_AVAIL_IB3(VARIANT, ...) __CP_ROQ_AVAIL_IB3<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ALWAYS_ON_COUNTER {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ALWAYS_ON_COUNTER(struct __CP_ALWAYS_ON_COUNTER fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000980,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008e7,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ALWAYS_ON_COUNTER(VARIANT, ...) __CP_ALWAYS_ON_COUNTER<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_ALWAYS_ON_CONTEXT {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_ALWAYS_ON_CONTEXT(struct __CP_ALWAYS_ON_CONTEXT fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000982,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008e9,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_ALWAYS_ON_CONTEXT(VARIANT, ...) __CP_ALWAYS_ON_CONTEXT<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AHB_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AHB_CNTL(struct __CP_AHB_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000098d,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000838,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AHB_CNTL(VARIANT, ...) __CP_AHB_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APERTURE_CNTL_HOST {
    /* A6XX fields: */
    /* A7XX fields: */
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    /* A8XX- fields: */
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APERTURE_CNTL_HOST(struct __CP_APERTURE_CNTL_HOST fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a00,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.pipe                              & 0xfffffffc) == 0);
    assert((fields.cluster                           & 0xfffffff8) == 0);
    assert((fields.context                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00003730) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a00,
        .value =
            (fields.pipe                              << 12) |
            (fields.cluster                           <<  8) |
            (fields.context                           <<  4) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081c,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APERTURE_CNTL_HOST(VARIANT, ...) __CP_APERTURE_CNTL_HOST<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APERTURE_CNTL_SQE {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APERTURE_CNTL_SQE(struct __CP_APERTURE_CNTL_SQE fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a01,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APERTURE_CNTL_SQE(VARIANT, ...) __CP_APERTURE_CNTL_SQE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APERTURE_CNTL_CD {
    /* A6XX fields: */
    /* A7XX fields: */
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    /* A8XX- fields: */
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APERTURE_CNTL_CD(struct __CP_APERTURE_CNTL_CD fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a03,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.pipe                              & 0xfffffffc) == 0);
    assert((fields.cluster                           & 0xfffffff8) == 0);
    assert((fields.context                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00003730) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a03,
        .value =
            (fields.pipe                              << 12) |
            (fields.cluster                           <<  8) |
            (fields.context                           <<  4) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081e,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APERTURE_CNTL_CD(VARIANT, ...) __CP_APERTURE_CNTL_CD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RESERVED_REG_REG {
    /* A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RESERVED_REG_REG(int __i, struct __CP_RESERVED_REG_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000a9c + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000958 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RESERVED_REG_REG(VARIANT, __i, ...) __CP_RESERVED_REG_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_APERTURE_CNTL_GMU {
    /* A8XX- fields: */
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_APERTURE_CNTL_GMU(struct __CP_APERTURE_CNTL_GMU fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081d,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_APERTURE_CNTL_GMU(VARIANT, ...) __CP_APERTURE_CNTL_GMU<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_PROTECT_STATUS {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_PROTECT_STATUS(struct __CP_BV_PROTECT_STATUS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a61,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_PROTECT_STATUS(VARIANT, ...) __CP_BV_PROTECT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_HW_FAULT {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_HW_FAULT(struct __CP_BV_HW_FAULT fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a64,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_HW_FAULT(VARIANT, ...) __CP_BV_HW_FAULT<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_RB_RPTR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_RB_RPTR(struct __CP_BV_RB_RPTR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a66,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_RB_RPTR(VARIANT, ...) __CP_BV_RB_RPTR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_IB1_BASE {
    /* A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_IB1_BASE(struct __CP_BV_IB1_BASE fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a6d,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_IB1_BASE(VARIANT, ...) __CP_BV_IB1_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_IB1_REM_SIZE {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_IB1_REM_SIZE(struct __CP_BV_IB1_REM_SIZE fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a70,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_IB1_REM_SIZE(VARIANT, ...) __CP_BV_IB1_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_IB2_BASE {
    /* A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_IB2_BASE(struct __CP_BV_IB2_BASE fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a71,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_IB2_BASE(VARIANT, ...) __CP_BV_IB2_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_IB2_REM_SIZE {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_IB2_REM_SIZE(struct __CP_BV_IB2_REM_SIZE fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a74,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_IB2_REM_SIZE(VARIANT, ...) __CP_BV_IB2_REM_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_DRAW_STATE_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_DRAW_STATE_ADDR(struct __CP_BV_DRAW_STATE_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a81,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_DRAW_STATE_ADDR(VARIANT, ...) __CP_BV_DRAW_STATE_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_DRAW_STATE_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_DRAW_STATE_DATA(struct __CP_BV_DRAW_STATE_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a82,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_DRAW_STATE_DATA(VARIANT, ...) __CP_BV_DRAW_STATE_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_ROQ_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_ROQ_DBG_ADDR(struct __CP_BV_ROQ_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a83,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_ROQ_DBG_ADDR(VARIANT, ...) __CP_BV_ROQ_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_ROQ_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_ROQ_DBG_DATA(struct __CP_BV_ROQ_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a84,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_ROQ_DBG_DATA(VARIANT, ...) __CP_BV_ROQ_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_SQE_UCODE_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_SQE_UCODE_DBG_ADDR(struct __CP_BV_SQE_UCODE_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a85,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_SQE_UCODE_DBG_ADDR(VARIANT, ...) __CP_BV_SQE_UCODE_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_SQE_UCODE_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_SQE_UCODE_DBG_DATA(struct __CP_BV_SQE_UCODE_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a86,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_SQE_UCODE_DBG_DATA(VARIANT, ...) __CP_BV_SQE_UCODE_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_SQE_STAT_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_SQE_STAT_ADDR(struct __CP_BV_SQE_STAT_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a87,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_SQE_STAT_ADDR(VARIANT, ...) __CP_BV_SQE_STAT_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_SQE_STAT_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_SQE_STAT_DATA(struct __CP_BV_SQE_STAT_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a88,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_SQE_STAT_DATA(VARIANT, ...) __CP_BV_SQE_STAT_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_ROQ_AVAIL_RB {
    /* A7XX fields: */
    uint32_t							rem;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_ROQ_AVAIL_RB(struct __CP_BV_ROQ_AVAIL_RB fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a8f,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_ROQ_AVAIL_RB(VARIANT, ...) __CP_BV_ROQ_AVAIL_RB<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_ROQ_AVAIL_IB1 {
    /* A7XX fields: */
    uint32_t							rem;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_ROQ_AVAIL_IB1(struct __CP_BV_ROQ_AVAIL_IB1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a90,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_ROQ_AVAIL_IB1(VARIANT, ...) __CP_BV_ROQ_AVAIL_IB1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_ROQ_AVAIL_IB2 {
    /* A7XX fields: */
    uint32_t							rem;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_ROQ_AVAIL_IB2(struct __CP_BV_ROQ_AVAIL_IB2 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a91,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_ROQ_AVAIL_IB2(VARIANT, ...) __CP_BV_ROQ_AVAIL_IB2<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_MEM_POOL_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_MEM_POOL_DBG_ADDR(struct __CP_BV_MEM_POOL_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a96,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_MEM_POOL_DBG_ADDR(VARIANT, ...) __CP_BV_MEM_POOL_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_MEM_POOL_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_MEM_POOL_DBG_DATA(struct __CP_BV_MEM_POOL_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a97,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_MEM_POOL_DBG_DATA(VARIANT, ...) __CP_BV_MEM_POOL_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_RB_RPTR_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_RB_RPTR_ADDR(struct __CP_BV_RB_RPTR_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a98,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_RB_RPTR_ADDR(VARIANT, ...) __CP_BV_RB_RPTR_ADDR<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RESOURCE_TABLE_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RESOURCE_TABLE_DBG_ADDR(struct __CP_RESOURCE_TABLE_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a9a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RESOURCE_TABLE_DBG_ADDR(VARIANT, ...) __CP_RESOURCE_TABLE_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_RESOURCE_TABLE_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_RESOURCE_TABLE_DBG_DATA(struct __CP_RESOURCE_TABLE_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a9b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_RESOURCE_TABLE_DBG_DATA(VARIANT, ...) __CP_RESOURCE_TABLE_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_APRIV_CNTL {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_APRIV_CNTL(struct __CP_BV_APRIV_CNTL fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ad0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_APRIV_CNTL(VARIANT, ...) __CP_BV_APRIV_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_BV_CHICKEN_DBG {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_BV_CHICKEN_DBG(struct __CP_BV_CHICKEN_DBG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ada,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_BV_CHICKEN_DBG(VARIANT, ...) __CP_BV_CHICKEN_DBG<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_DRAW_STATE_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_DRAW_STATE_ADDR(struct __CP_LPAC_DRAW_STATE_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_DRAW_STATE_ADDR(VARIANT, ...) __CP_LPAC_DRAW_STATE_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_DRAW_STATE_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_DRAW_STATE_DATA(struct __CP_LPAC_DRAW_STATE_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_DRAW_STATE_DATA(VARIANT, ...) __CP_LPAC_DRAW_STATE_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_ROQ_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_ROQ_DBG_ADDR(struct __CP_LPAC_ROQ_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0c,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_ROQ_DBG_ADDR(VARIANT, ...) __CP_LPAC_ROQ_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_AC_UCODE_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_AC_UCODE_DBG_ADDR(struct __CP_SQE_AC_UCODE_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b27,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_AC_UCODE_DBG_ADDR(VARIANT, ...) __CP_SQE_AC_UCODE_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_AC_UCODE_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_AC_UCODE_DBG_DATA(struct __CP_SQE_AC_UCODE_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b28,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_AC_UCODE_DBG_DATA(VARIANT, ...) __CP_SQE_AC_UCODE_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_AC_STAT_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_AC_STAT_ADDR(struct __CP_SQE_AC_STAT_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b29,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_AC_STAT_ADDR(VARIANT, ...) __CP_SQE_AC_STAT_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_SQE_AC_STAT_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_SQE_AC_STAT_DATA(struct __CP_SQE_AC_STAT_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b2a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_SQE_AC_STAT_DATA(VARIANT, ...) __CP_SQE_AC_STAT_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_APRIV_CNTL {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_APRIV_CNTL(struct __CP_LPAC_APRIV_CNTL fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b31,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_APRIV_CNTL(VARIANT, ...) __CP_LPAC_APRIV_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_PROG_FIFO_SIZE {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_PROG_FIFO_SIZE(struct __CP_LPAC_PROG_FIFO_SIZE fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b34,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_PROG_FIFO_SIZE(VARIANT, ...) __CP_LPAC_PROG_FIFO_SIZE<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_ROQ_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_ROQ_DBG_DATA(struct __CP_LPAC_ROQ_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b35,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_ROQ_DBG_DATA(VARIANT, ...) __CP_LPAC_ROQ_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_FIFO_DBG_DATA {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_FIFO_DBG_DATA(struct __CP_LPAC_FIFO_DBG_DATA fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b36,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_FIFO_DBG_DATA(VARIANT, ...) __CP_LPAC_FIFO_DBG_DATA<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_FIFO_DBG_ADDR {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_FIFO_DBG_ADDR(struct __CP_LPAC_FIFO_DBG_ADDR fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b40,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_FIFO_DBG_ADDR(VARIANT, ...) __CP_LPAC_FIFO_DBG_ADDR<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_SQE_CNTL {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_SQE_CNTL(struct __CP_LPAC_SQE_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b81,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_SQE_CNTL(VARIANT, ...) __CP_LPAC_SQE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_LPAC_SQE_INSTR_BASE {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_LPAC_SQE_INSTR_BASE(struct __CP_LPAC_SQE_INSTR_BASE fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b82,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_LPAC_SQE_INSTR_BASE(VARIANT, ...) __CP_LPAC_SQE_INSTR_BASE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_APRIV_CNTL {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_APRIV_CNTL(struct __CP_AQE_APRIV_CNTL fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b78,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_APRIV_CNTL(VARIANT, ...) __CP_AQE_APRIV_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_ROQ_DBG_ADDR_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_ROQ_DBG_ADDR_0(struct __CP_AQE_ROQ_DBG_ADDR_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ba8,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_ROQ_DBG_ADDR_0(VARIANT, ...) __CP_AQE_ROQ_DBG_ADDR_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_ROQ_DBG_ADDR_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_ROQ_DBG_ADDR_1(struct __CP_AQE_ROQ_DBG_ADDR_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ba9,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_ROQ_DBG_ADDR_1(VARIANT, ...) __CP_AQE_ROQ_DBG_ADDR_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_ROQ_DBG_DATA_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_ROQ_DBG_DATA_0(struct __CP_AQE_ROQ_DBG_DATA_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bac,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_ROQ_DBG_DATA_0(VARIANT, ...) __CP_AQE_ROQ_DBG_DATA_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_ROQ_DBG_DATA_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_ROQ_DBG_DATA_1(struct __CP_AQE_ROQ_DBG_DATA_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bad,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_ROQ_DBG_DATA_1(VARIANT, ...) __CP_AQE_ROQ_DBG_DATA_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_UCODE_DBG_ADDR_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_UCODE_DBG_ADDR_0(struct __CP_AQE_UCODE_DBG_ADDR_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_UCODE_DBG_ADDR_0(VARIANT, ...) __CP_AQE_UCODE_DBG_ADDR_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_UCODE_DBG_ADDR_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_UCODE_DBG_ADDR_1(struct __CP_AQE_UCODE_DBG_ADDR_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb1,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_UCODE_DBG_ADDR_1(VARIANT, ...) __CP_AQE_UCODE_DBG_ADDR_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_UCODE_DBG_DATA_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_UCODE_DBG_DATA_0(struct __CP_AQE_UCODE_DBG_DATA_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb4,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_UCODE_DBG_DATA_0(VARIANT, ...) __CP_AQE_UCODE_DBG_DATA_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_UCODE_DBG_DATA_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_UCODE_DBG_DATA_1(struct __CP_AQE_UCODE_DBG_DATA_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb5,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_UCODE_DBG_DATA_1(VARIANT, ...) __CP_AQE_UCODE_DBG_DATA_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_STAT_ADDR_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_STAT_ADDR_0(struct __CP_AQE_STAT_ADDR_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb8,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_STAT_ADDR_0(VARIANT, ...) __CP_AQE_STAT_ADDR_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_STAT_ADDR_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_STAT_ADDR_1(struct __CP_AQE_STAT_ADDR_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb9,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_STAT_ADDR_1(VARIANT, ...) __CP_AQE_STAT_ADDR_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_STAT_DATA_0 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_STAT_DATA_0(struct __CP_AQE_STAT_DATA_0 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bbc,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_STAT_DATA_0(VARIANT, ...) __CP_AQE_STAT_DATA_0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __CP_AQE_STAT_DATA_1 {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__CP_AQE_STAT_DATA_1(struct __CP_AQE_STAT_DATA_1 fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bbd,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define CP_AQE_STAT_DATA_1(VARIANT, ...) __CP_AQE_STAT_DATA_1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __VSC_ADDR_MODE_CNTL {
    /* A6XX fields: */
    enum a5xx_address_mode					vsc_addr_mode_cntl;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__VSC_ADDR_MODE_CNTL(struct __VSC_ADDR_MODE_CNTL fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.vsc_addr_mode_cntl                & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c01,
        .value =
            (fields.vsc_addr_mode_cntl                <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define VSC_ADDR_MODE_CNTL(VARIANT, ...) __VSC_ADDR_MODE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GPR0_CNTL {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GPR0_CNTL(struct __RBBM_GPR0_CNTL fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000018,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GPR0_CNTL(VARIANT, ...) __RBBM_GPR0_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_INT_0_STATUS {
    /* A6XX-A7XX fields: */
    bool							rbbm_gpu_idle;
    bool							cp_ahb_error;
    bool							cp_ipc_intr_0;
    bool							cp_ipc_intr_1;
    bool							rbbm_atb_asyncfifo_overflow;
    bool							rbbm_gpc_error;
    bool							cp_sw;
    bool							cp_hw_error;
    bool							cp_ccu_flush_depth_ts;
    bool							cp_ccu_flush_color_ts;
    bool							cp_ccu_resolve_ts;
    bool							cp_ib2;
    bool							cp_ib1;
    bool							cp_rb;
    bool							pm4cpinterrupt;
    bool							pm4cpinterruptlpac;
    bool							cp_rb_done_ts;
    bool							cp_wt_done_ts;
    bool							cp_cache_flush_ts;
    bool							cp_cache_flush_ts_lpac;
    bool							rbbm_atb_bus_overflow;
    bool							rbbm_hang_detect;
    bool							uche_oob_access;
    bool							uche_trap_intr;
    bool							debbus_intr_0;
    bool							debbus_intr_1;
    bool							tsbwriteerror;
    bool							swfuseviolation;
    bool							isdb_cpu_irq;
    bool							isdb_under_debug;
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_INT_0_STATUS(struct __RBBM_INT_0_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0xfff7fff3) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000201,
        .value =
            (fields.rbbm_gpu_idle                     <<  0) |
            (fields.cp_ahb_error                      <<  1) |
            (fields.cp_ipc_intr_0                     <<  4) |
            (fields.cp_ipc_intr_1                     <<  5) |
            (fields.rbbm_atb_asyncfifo_overflow       <<  6) |
            (fields.rbbm_gpc_error                    <<  7) |
            (fields.cp_sw                             <<  8) |
            (fields.cp_hw_error                       <<  9) |
            (fields.cp_ccu_flush_depth_ts             << 10) |
            (fields.cp_ccu_flush_color_ts             << 11) |
            (fields.cp_ccu_resolve_ts                 << 12) |
            (fields.cp_ib2                            << 13) |
            (fields.cp_ib1                            << 14) |
            (fields.cp_rb                             << 15) |
            (fields.pm4cpinterrupt                    << 15) |
            (fields.pm4cpinterruptlpac                << 16) |
            (fields.cp_rb_done_ts                     << 17) |
            (fields.cp_wt_done_ts                     << 18) |
            (fields.cp_cache_flush_ts                 << 20) |
            (fields.cp_cache_flush_ts_lpac            << 21) |
            (fields.rbbm_atb_bus_overflow             << 22) |
            (fields.rbbm_hang_detect                  << 23) |
            (fields.uche_oob_access                   << 24) |
            (fields.uche_trap_intr                    << 25) |
            (fields.debbus_intr_0                     << 26) |
            (fields.debbus_intr_1                     << 27) |
            (fields.tsbwriteerror                     << 28) |
            (fields.swfuseviolation                   << 29) |
            (fields.isdb_cpu_irq                      << 30) |
            (fields.isdb_under_debug                  << 31) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0xfff7fff3) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000006a,
        .value =
            (fields.rbbm_gpu_idle                     <<  0) |
            (fields.cp_ahb_error                      <<  1) |
            (fields.cp_ipc_intr_0                     <<  4) |
            (fields.cp_ipc_intr_1                     <<  5) |
            (fields.rbbm_atb_asyncfifo_overflow       <<  6) |
            (fields.rbbm_gpc_error                    <<  7) |
            (fields.cp_sw                             <<  8) |
            (fields.cp_hw_error                       <<  9) |
            (fields.cp_ccu_flush_depth_ts             << 10) |
            (fields.cp_ccu_flush_color_ts             << 11) |
            (fields.cp_ccu_resolve_ts                 << 12) |
            (fields.cp_ib2                            << 13) |
            (fields.cp_ib1                            << 14) |
            (fields.cp_rb                             << 15) |
            (fields.pm4cpinterrupt                    << 15) |
            (fields.pm4cpinterruptlpac                << 16) |
            (fields.cp_rb_done_ts                     << 17) |
            (fields.cp_wt_done_ts                     << 18) |
            (fields.cp_cache_flush_ts                 << 20) |
            (fields.cp_cache_flush_ts_lpac            << 21) |
            (fields.rbbm_atb_bus_overflow             << 22) |
            (fields.rbbm_hang_detect                  << 23) |
            (fields.uche_oob_access                   << 24) |
            (fields.uche_trap_intr                    << 25) |
            (fields.debbus_intr_0                     << 26) |
            (fields.debbus_intr_1                     << 27) |
            (fields.tsbwriteerror                     << 28) |
            (fields.swfuseviolation                   << 29) |
            (fields.isdb_cpu_irq                      << 30) |
            (fields.isdb_under_debug                  << 31) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_INT_0_STATUS(VARIANT, ...) __RBBM_INT_0_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_STATUS {
    /* A6XX-A7XX fields: */
    bool							gpu_busy_ign_ahb;
    bool							gpu_busy_ign_ahb_cp;
    bool							hlsq_busy;
    bool							vsc_busy;
    bool							tpl1_busy;
    bool							sp_busy;
    bool							uche_busy;
    bool							vpc_busy;
    bool							vfd_busy;
    bool							tess_busy;
    bool							pc_vsd_busy;
    bool							pc_dcall_busy;
    bool							com_dcom_busy;
    bool							lrz_busy;
    bool							a2d_busy;
    bool							ccu_busy;
    bool							rb_busy;
    bool							ras_busy;
    bool							tse_busy;
    bool							vbif_busy;
    bool							gfx_dbgc_busy;
    bool							cp_busy;
    bool							cp_ahb_busy_cp_master;
    bool							cp_ahb_busy_cx_master;
    /* A8XX- fields: */
    bool							slice_busy_ign_cp;
    bool							cp_slice_busy;
    bool							unslice_busy_ign_ahb;
    bool							unslice_busy_ign_ahb_cp;
    bool							cp_slice_rl_busy;
    bool							unslice_top_busy;
    bool							ufc_busy;
    bool							pc_busy;
    bool							cmp_busy;
    bool							dcmp_busy;
    bool							vbif_gx_busy;
    bool							dbgc_perf_busy;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_STATUS(struct __RBBM_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000210,
        .value =
            (fields.gpu_busy_ign_ahb                  << 23) |
            (fields.gpu_busy_ign_ahb_cp               << 22) |
            (fields.hlsq_busy                         << 21) |
            (fields.vsc_busy                          << 20) |
            (fields.tpl1_busy                         << 19) |
            (fields.sp_busy                           << 18) |
            (fields.uche_busy                         << 17) |
            (fields.vpc_busy                          << 16) |
            (fields.vfd_busy                          << 15) |
            (fields.tess_busy                         << 14) |
            (fields.pc_vsd_busy                       << 13) |
            (fields.pc_dcall_busy                     << 12) |
            (fields.com_dcom_busy                     << 11) |
            (fields.lrz_busy                          << 10) |
            (fields.a2d_busy                          <<  9) |
            (fields.ccu_busy                          <<  8) |
            (fields.rb_busy                           <<  7) |
            (fields.ras_busy                          <<  6) |
            (fields.tse_busy                          <<  5) |
            (fields.vbif_busy                         <<  4) |
            (fields.gfx_dbgc_busy                     <<  3) |
            (fields.cp_busy                           <<  2) |
            (fields.cp_ahb_busy_cp_master             <<  1) |
            (fields.cp_ahb_busy_cx_master             <<  0) |
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00fe7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000012,
        .value =
            (fields.gpu_busy_ign_ahb                  << 23) |
            (fields.gpu_busy_ign_ahb_cp               << 22) |
            (fields.slice_busy_ign_cp                 << 21) |
            (fields.cp_slice_busy                     << 20) |
            (fields.unslice_busy_ign_ahb              << 19) |
            (fields.unslice_busy_ign_ahb_cp           << 18) |
            (fields.cp_slice_rl_busy                  << 17) |
            (fields.unslice_top_busy                  << 14) |
            (fields.ufc_busy                          << 13) |
            (fields.hlsq_busy                         << 12) |
            (fields.vsc_busy                          << 11) |
            (fields.uche_busy                         << 10) |
            (fields.vpc_busy                          <<  9) |
            (fields.pc_busy                           <<  8) |
            (fields.cmp_busy                          <<  7) |
            (fields.dcmp_busy                         <<  6) |
            (fields.vbif_gx_busy                      <<  5) |
            (fields.dbgc_perf_busy                    <<  4) |
            (fields.gfx_dbgc_busy                     <<  3) |
            (fields.cp_busy                           <<  2) |
            (fields.cp_ahb_busy_cp_master             <<  1) |
            (fields.cp_ahb_busy_cx_master             <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_STATUS(VARIANT, ...) __RBBM_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_STATUS1 {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_STATUS1(struct __RBBM_STATUS1 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000211,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000013,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_STATUS1(VARIANT, ...) __RBBM_STATUS1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_STATUS2 {
    /* A6XX-A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_STATUS2(struct __RBBM_STATUS2 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000212,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_STATUS2(VARIANT, ...) __RBBM_STATUS2<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_STATUS3 {
    /* A6XX-A7XX fields: */
    bool							smmu_stalled_on_fault;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_STATUS3(struct __RBBM_STATUS3 fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x01000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000213,
        .value =
            (fields.smmu_stalled_on_fault             << 24) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_STATUS3(VARIANT, ...) __RBBM_STATUS3<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GFX_STATUS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GFX_STATUS(struct __RBBM_GFX_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000015,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GFX_STATUS(VARIANT, ...) __RBBM_GFX_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GFX_STATUS1 {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GFX_STATUS1(struct __RBBM_GFX_STATUS1 fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000016,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GFX_STATUS1(VARIANT, ...) __RBBM_GFX_STATUS1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_LPAC_STATUS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_LPAC_STATUS(struct __RBBM_LPAC_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000018,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_LPAC_STATUS(VARIANT, ...) __RBBM_LPAC_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GFX_BR_STATUS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GFX_BR_STATUS(struct __RBBM_GFX_BR_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GFX_BR_STATUS(VARIANT, ...) __RBBM_GFX_BR_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GFX_BV_STATUS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GFX_BV_STATUS(struct __RBBM_GFX_BV_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001c,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GFX_BV_STATUS(VARIANT, ...) __RBBM_GFX_BV_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_MISC_STATUS {
    /* A8XX- fields: */
    bool							smmu_stalled_on_fault;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_MISC_STATUS(struct __RBBM_MISC_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001e,
        .value =
            (fields.smmu_stalled_on_fault             <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_MISC_STATUS(VARIANT, ...) __RBBM_MISC_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_VBIF_GX_RESET_STATUS {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_VBIF_GX_RESET_STATUS(struct __RBBM_VBIF_GX_RESET_STATUS fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000215,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_VBIF_GX_RESET_STATUS(VARIANT, ...) __RBBM_VBIF_GX_RESET_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE_CP {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE_CP(struct __RBBM_CLOCK_MODE_CP fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000260,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE_CP(VARIANT, ...) __RBBM_CLOCK_MODE_CP<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE_BV_LRZ {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE_BV_LRZ(struct __RBBM_CLOCK_MODE_BV_LRZ fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000284,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE_BV_LRZ(VARIANT, ...) __RBBM_CLOCK_MODE_BV_LRZ<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE_BV_GRAS {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE_BV_GRAS(struct __RBBM_CLOCK_MODE_BV_GRAS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000285,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE_BV_GRAS(VARIANT, ...) __RBBM_CLOCK_MODE_BV_GRAS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE2_GRAS {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE2_GRAS(struct __RBBM_CLOCK_MODE2_GRAS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000286,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE2_GRAS(VARIANT, ...) __RBBM_CLOCK_MODE2_GRAS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE_BV_VFD {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE_BV_VFD(struct __RBBM_CLOCK_MODE_BV_VFD fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000287,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE_BV_VFD(VARIANT, ...) __RBBM_CLOCK_MODE_BV_VFD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_CLOCK_MODE_BV_GPC {
    /* A7XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_CLOCK_MODE_BV_GPC(struct __RBBM_CLOCK_MODE_BV_GPC fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000288,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_CLOCK_MODE_BV_GPC(VARIANT, ...) __RBBM_CLOCK_MODE_BV_GPC<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SW_FUSE_INT_STATUS {
    /* A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SW_FUSE_INT_STATUS(struct __RBBM_SW_FUSE_INT_STATUS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000002c0,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000071,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SW_FUSE_INT_STATUS(VARIANT, ...) __RBBM_SW_FUSE_INT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SW_FUSE_INT_MASK {
    /* A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SW_FUSE_INT_MASK(struct __RBBM_SW_FUSE_INT_MASK fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000002c1,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000072,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SW_FUSE_INT_MASK(VARIANT, ...) __RBBM_SW_FUSE_INT_MASK<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_CP_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_CP_REG(int __i, struct __RBBM_PERFCTR_CP_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000400 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000300 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001b0 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_CP_REG(VARIANT, __i, ...) __RBBM_PERFCTR_CP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_RBBM_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_RBBM_REG(int __i, struct __RBBM_PERFCTR_RBBM_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000041c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000031c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001cc + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_RBBM_REG(VARIANT, __i, ...) __RBBM_PERFCTR_RBBM_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_PC_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_PC_REG(int __i, struct __RBBM_PERFCTR_PC_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000424 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000324 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001d4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_PC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_PC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_VFD_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_VFD_REG(int __i, struct __RBBM_PERFCTR_VFD_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000434 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000334 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001e4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_VFD_REG(VARIANT, __i, ...) __RBBM_PERFCTR_VFD_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_HLSQ_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_HLSQ_REG(int __i, struct __RBBM_PERFCTR_HLSQ_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000444 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000344 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001f4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_HLSQ_REG(VARIANT, __i, ...) __RBBM_PERFCTR_HLSQ_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_VPC_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_VPC_REG(int __i, struct __RBBM_PERFCTR_VPC_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000450 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000350 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000200 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_VPC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_VPC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_CCU_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_CCU_REG(int __i, struct __RBBM_PERFCTR_CCU_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000045c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000035c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000020c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_CCU_REG(VARIANT, __i, ...) __RBBM_PERFCTR_CCU_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_TSE_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_TSE_REG(int __i, struct __RBBM_PERFCTR_TSE_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000466 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000366 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000216 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_TSE_REG(VARIANT, __i, ...) __RBBM_PERFCTR_TSE_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_RAS_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_RAS_REG(int __i, struct __RBBM_PERFCTR_RAS_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000046e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000036e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000021e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_RAS_REG(VARIANT, __i, ...) __RBBM_PERFCTR_RAS_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_UCHE_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_UCHE_REG(int __i, struct __RBBM_PERFCTR_UCHE_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000476 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000376 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000226 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_UCHE_REG(VARIANT, __i, ...) __RBBM_PERFCTR_UCHE_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_TP_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_TP_REG(int __i, struct __RBBM_PERFCTR_TP_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000048e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000038e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000256 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_TP_REG(VARIANT, __i, ...) __RBBM_PERFCTR_TP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_SP_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_SP_REG(int __i, struct __RBBM_PERFCTR_SP_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004a6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003a6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000026e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_SP_REG(VARIANT, __i, ...) __RBBM_PERFCTR_SP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_RB_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_RB_REG(int __i, struct __RBBM_PERFCTR_RB_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004d6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003d6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000029e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_RB_REG(VARIANT, __i, ...) __RBBM_PERFCTR_RB_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_VSC_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_VSC_REG(int __i, struct __RBBM_PERFCTR_VSC_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004e6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003e6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ae + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_VSC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_VSC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LRZ_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LRZ_REG(int __i, struct __RBBM_PERFCTR_LRZ_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004ea + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003ea + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002b2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LRZ_REG(VARIANT, __i, ...) __RBBM_PERFCTR_LRZ_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_CMP_REG {
    /* A6XX fields: */
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_CMP_REG(int __i, struct __RBBM_PERFCTR_CMP_REG fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004f2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003f2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ba + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_CMP_REG(VARIANT, __i, ...) __RBBM_PERFCTR_CMP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_UFC_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_UFC_REG(int __i, struct __RBBM_PERFCTR_UFC_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003fa + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002c2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_UFC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_UFC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR2_HLSQ_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR2_HLSQ_REG(int __i, struct __RBBM_PERFCTR2_HLSQ_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000410 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002e2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR2_HLSQ_REG(VARIANT, __i, ...) __RBBM_PERFCTR2_HLSQ_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR2_CP_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR2_CP_REG(int __i, struct __RBBM_PERFCTR2_CP_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000041c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ee + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR2_CP_REG(VARIANT, __i, ...) __RBBM_PERFCTR2_CP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR2_SP_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR2_SP_REG(int __i, struct __RBBM_PERFCTR2_SP_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000042a + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002fc + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR2_SP_REG(VARIANT, __i, ...) __RBBM_PERFCTR2_SP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR2_TP_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR2_TP_REG(int __i, struct __RBBM_PERFCTR2_TP_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000442 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000314 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR2_TP_REG(VARIANT, __i, ...) __RBBM_PERFCTR2_TP_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR2_UFC_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR2_UFC_REG(int __i, struct __RBBM_PERFCTR2_UFC_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000044e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000324 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR2_UFC_REG(VARIANT, __i, ...) __RBBM_PERFCTR2_UFC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_PC_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_PC_REG(int __i, struct __RBBM_PERFCTR_BV_PC_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000460 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000328 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_PC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_PC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_VFD_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_VFD_REG(int __i, struct __RBBM_PERFCTR_BV_VFD_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000470 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000338 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_VFD_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_VFD_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_VPC_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_VPC_REG(int __i, struct __RBBM_PERFCTR_BV_VPC_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000480 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000348 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_VPC_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_VPC_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_TSE_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_TSE_REG(int __i, struct __RBBM_PERFCTR_BV_TSE_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000048c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000354 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_TSE_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_TSE_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_RAS_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_RAS_REG(int __i, struct __RBBM_PERFCTR_BV_RAS_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000494 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000035c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_RAS_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_RAS_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_LRZ_REG {
    /* A7XX fields: */
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_LRZ_REG(int __i, struct __RBBM_PERFCTR_BV_LRZ_REG fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000049c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000364 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_LRZ_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_LRZ_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_CCU_REG {
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_CCU_REG(int __i, struct __RBBM_PERFCTR_BV_CCU_REG fields) {
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000036c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_CCU_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_CCU_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_BV_RB_REG {
    /* A8XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_BV_RB_REG(int __i, struct __RBBM_PERFCTR_BV_RB_REG fields) {
  if (CHIP == A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000372 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_BV_RB_REG(VARIANT, __i, ...) __RBBM_PERFCTR_BV_RB_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_CNTL(struct __RBBM_PERFCTR_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000500,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000460,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_CNTL(VARIANT, ...) __RBBM_PERFCTR_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LOAD_CMD0 {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LOAD_CMD0(struct __RBBM_PERFCTR_LOAD_CMD0 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000501,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LOAD_CMD0(VARIANT, ...) __RBBM_PERFCTR_LOAD_CMD0<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LOAD_CMD1 {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LOAD_CMD1(struct __RBBM_PERFCTR_LOAD_CMD1 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000502,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LOAD_CMD1(VARIANT, ...) __RBBM_PERFCTR_LOAD_CMD1<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LOAD_CMD2 {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LOAD_CMD2(struct __RBBM_PERFCTR_LOAD_CMD2 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000503,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LOAD_CMD2(VARIANT, ...) __RBBM_PERFCTR_LOAD_CMD2<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LOAD_CMD3 {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LOAD_CMD3(struct __RBBM_PERFCTR_LOAD_CMD3 fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000504,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LOAD_CMD3(VARIANT, ...) __RBBM_PERFCTR_LOAD_CMD3<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_LOAD_VALUE {
    /* A6XX fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_LOAD_VALUE(struct __RBBM_PERFCTR_LOAD_VALUE fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000505,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_LOAD_VALUE(VARIANT, ...) __RBBM_PERFCTR_LOAD_VALUE<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_RBBM_SEL_REG {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_RBBM_SEL_REG(int __i, struct __RBBM_PERFCTR_RBBM_SEL_REG fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000507 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000441 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_RBBM_SEL_REG(VARIANT, __i, ...) __RBBM_PERFCTR_RBBM_SEL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_GPU_BUSY_MASKED {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_GPU_BUSY_MASKED(struct __RBBM_PERFCTR_GPU_BUSY_MASKED fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050b,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000019e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_GPU_BUSY_MASKED(VARIANT, ...) __RBBM_PERFCTR_GPU_BUSY_MASKED<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_SRAM_INIT_CMD {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_SRAM_INIT_CMD(struct __RBBM_PERFCTR_SRAM_INIT_CMD fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000449,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_SRAM_INIT_CMD(VARIANT, ...) __RBBM_PERFCTR_SRAM_INIT_CMD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_SRAM_INIT_STATUS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_SRAM_INIT_STATUS(struct __RBBM_PERFCTR_SRAM_INIT_STATUS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050f,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000019f,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_SRAM_INIT_STATUS(VARIANT, ...) __RBBM_PERFCTR_SRAM_INIT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_FLUSH_HOST_STATUS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_FLUSH_HOST_STATUS(struct __RBBM_PERFCTR_FLUSH_HOST_STATUS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000001a1,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_FLUSH_HOST_STATUS(VARIANT, ...) __RBBM_PERFCTR_FLUSH_HOST_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PERFCTR_FLUSH_HOST_CMD {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PERFCTR_FLUSH_HOST_CMD(struct __RBBM_PERFCTR_FLUSH_HOST_CMD fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000044c,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PERFCTR_FLUSH_HOST_CMD(VARIANT, ...) __RBBM_PERFCTR_FLUSH_HOST_CMD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_ISDB_CNT {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_ISDB_CNT(struct __RBBM_ISDB_CNT fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000533,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002d,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_ISDB_CNT(VARIANT, ...) __RBBM_ISDB_CNT<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_NC_MODE_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_NC_MODE_CNTL(struct __RBBM_NC_MODE_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000534,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000440,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_NC_MODE_CNTL(VARIANT, ...) __RBBM_NC_MODE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SNAPSHOT_STATUS {
    /* A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SNAPSHOT_STATUS(struct __RBBM_SNAPSHOT_STATUS fields) {
  if (CHIP == A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000535,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002e,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SNAPSHOT_STATUS(VARIANT, ...) __RBBM_SNAPSHOT_STATUS<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_PERFCTR_CNTL {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_PERFCTR_CNTL(struct __RBBM_SLICE_PERFCTR_CNTL fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000500,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_PERFCTR_CNTL(VARIANT, ...) __RBBM_SLICE_PERFCTR_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_INTERFACE_HANG_INT_CNTL {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_INTERFACE_HANG_INT_CNTL(struct __RBBM_SLICE_INTERFACE_HANG_INT_CNTL fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000058f,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_INTERFACE_HANG_INT_CNTL(VARIANT, ...) __RBBM_SLICE_INTERFACE_HANG_INT_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_PERFCTR_RBBM_SEL_REG {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_PERFCTR_RBBM_SEL_REG(int __i, struct __RBBM_SLICE_PERFCTR_RBBM_SEL_REG fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000005e0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_PERFCTR_RBBM_SEL_REG(VARIANT, __i, ...) __RBBM_SLICE_PERFCTR_RBBM_SEL_REG<VARIANT>(__i, {__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_PERFCTR_SRAM_INIT_CMD {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(struct __RBBM_SLICE_PERFCTR_SRAM_INIT_CMD fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005e8,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(VARIANT, ...) __RBBM_SLICE_PERFCTR_SRAM_INIT_CMD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(struct __RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005eb,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(VARIANT, ...) __RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SLICE_NC_MODE_CNTL {
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SLICE_NC_MODE_CNTL(struct __RBBM_SLICE_NC_MODE_CNTL fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005ec,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SLICE_NC_MODE_CNTL(VARIANT, ...) __RBBM_SLICE_NC_MODE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_IAVERTICES {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_IAVERTICES(struct __RBBM_PIPESTAT_IAVERTICES fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000540,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000380,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_IAVERTICES(VARIANT, ...) __RBBM_PIPESTAT_IAVERTICES<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_IAPRIMITIVES {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_IAPRIMITIVES(struct __RBBM_PIPESTAT_IAPRIMITIVES fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000542,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000382,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_IAPRIMITIVES(VARIANT, ...) __RBBM_PIPESTAT_IAPRIMITIVES<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_VSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_VSINVOCATIONS(struct __RBBM_PIPESTAT_VSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000544,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000384,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_VSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_VSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_HSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_HSINVOCATIONS(struct __RBBM_PIPESTAT_HSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000546,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000390,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_HSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_HSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_DSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_DSINVOCATIONS(struct __RBBM_PIPESTAT_DSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000548,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000392,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_DSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_DSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_GSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_GSINVOCATIONS(struct __RBBM_PIPESTAT_GSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054a,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000386,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_GSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_GSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_GSPRIMITIVES {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_GSPRIMITIVES(struct __RBBM_PIPESTAT_GSPRIMITIVES fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054c,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000388,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_GSPRIMITIVES(VARIANT, ...) __RBBM_PIPESTAT_GSPRIMITIVES<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_CINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_CINVOCATIONS(struct __RBBM_PIPESTAT_CINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054e,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038a,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_CINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_CINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_CPRIMITIVES {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_CPRIMITIVES(struct __RBBM_PIPESTAT_CPRIMITIVES fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000550,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038c,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_CPRIMITIVES(VARIANT, ...) __RBBM_PIPESTAT_CPRIMITIVES<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_PSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_PSINVOCATIONS(struct __RBBM_PIPESTAT_PSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000552,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038e,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_PSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_PSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_CSINVOCATIONS {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_CSINVOCATIONS(struct __RBBM_PIPESTAT_CSINVOCATIONS fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000554,
        .value =
            fields.unknown | fields.qword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000394,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_CSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_CSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_ASINVOCATIONS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_ASINVOCATIONS(struct __RBBM_PIPESTAT_ASINVOCATIONS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000396,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_ASINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_ASINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_MSINVOCATIONS {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_MSINVOCATIONS(struct __RBBM_PIPESTAT_MSINVOCATIONS fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000398,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_MSINVOCATIONS(VARIANT, ...) __RBBM_PIPESTAT_MSINVOCATIONS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_PIPESTAT_MSPRIMITIVES {
    /* A8XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_PIPESTAT_MSPRIMITIVES(struct __RBBM_PIPESTAT_MSPRIMITIVES fields) {
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000039a,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_PIPESTAT_MSPRIMITIVES(VARIANT, ...) __RBBM_PIPESTAT_MSPRIMITIVES<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SECVID_TSB_ADDR_MODE_CNTL {
    /* A6XX fields: */
    enum a5xx_address_mode					rbbm_secvid_tsb_addr_mode_cntl;
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SECVID_TSB_ADDR_MODE_CNTL(struct __RBBM_SECVID_TSB_ADDR_MODE_CNTL fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.rbbm_secvid_tsb_addr_mode_cntl    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f810,
        .value =
            (fields.rbbm_secvid_tsb_addr_mode_cntl    <<  0) |
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SECVID_TSB_ADDR_MODE_CNTL(VARIANT, ...) __RBBM_SECVID_TSB_ADDR_MODE_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_SECVID_TSB_STATUS {
    /* A7XX- fields: */
    /* fallback fields: */
    uint64_t							unknown;
    uint64_t							qword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_SECVID_TSB_STATUS(struct __RBBM_SECVID_TSB_STATUS fields) {
  if (CHIP >= A7XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000fc00,
        .value =
            fields.unknown | fields.qword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_SECVID_TSB_STATUS(VARIANT, ...) __RBBM_SECVID_TSB_STATUS<VARIANT>({__VA_ARGS__}), { .reg = 0 }
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_VBIF_CLIENT_QOS_CNTL {
    /* A6XX fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_VBIF_CLIENT_QOS_CNTL(struct __RBBM_VBIF_CLIENT_QOS_CNTL fields) {
  if (CHIP == A6XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000010,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_VBIF_CLIENT_QOS_CNTL(VARIANT, ...) __RBBM_VBIF_CLIENT_QOS_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GBIF_CLIENT_QOS_CNTL {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GBIF_CLIENT_QOS_CNTL(struct __RBBM_GBIF_CLIENT_QOS_CNTL fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000011,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000008,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GBIF_CLIENT_QOS_CNTL(VARIANT, ...) __RBBM_GBIF_CLIENT_QOS_CNTL<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GBIF_HALT {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GBIF_HALT(struct __RBBM_GBIF_HALT fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000016,
        .value =
            fields.unknown | fields.dword,
    };
  } else
  if (CHIP >= A8XX) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000a,
        .value =
            fields.unknown | fields.dword,
    };
  } else
    assert(!"invalid variant");
  return (struct fd_reg_pair){};
}
#define RBBM_GBIF_HALT(VARIANT, ...) __RBBM_GBIF_HALT<VARIANT>({__VA_ARGS__})
#endif /* __cplusplus */
#ifdef __cplusplus
struct __RBBM_GBIF_HALT_ACK {
    /* A6XX-A7XX fields: */
    /* A8XX- fields: */
    /* fallback fields: */
    uint32_t							unknown;
    uint32_t							dword;
};
template <chip CHIP>
static CONSTEXPR inline struct fd_reg_pair
__RBBM_GBIF_HALT_ACK(struct __RBBM_GBIF_HALT_ACK fields) {
  if ((CHIP >= A6XX) && (CHIP <= A7XX)) {
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct 