/* ExportDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ExportDialog.vala, do not modify */

/*
* Copyright 2009-2013 Yorba Foundation
*           2017-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	EXPORT_DIALOG_0_PROPERTY,
	EXPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* export_dialog_properties[EXPORT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ExportDialogPrivate {
	GtkComboBoxText* quality_combo;
	GtkComboBoxText* constraint_combo;
	GtkComboBoxText* format_combo;
	GtkCheckButton* export_metadata;
	GeeArrayList* format_options;
	GtkSpinButton* pixels_spinbutton;
	GtkWidget* export_button;
};

static gint ExportDialog_private_offset;
static gpointer export_dialog_parent_class = NULL;
static ScaleConstraint export_dialog_current_constraint;
static ScaleConstraint export_dialog_current_constraint = SCALE_CONSTRAINT_ORIGINAL;
static ExportFormatParameters export_dialog_current_parameters;
static ExportFormatParameters export_dialog_current_parameters = {0};
static gint export_dialog_current_scale;
static gint export_dialog_current_scale = 1200;

static void export_dialog_format_add_option (ExportDialog* self,
                                      const gchar* format_name);
static void export_dialog_format_set_active_text (ExportDialog* self,
                                           const gchar* text);
static PhotoFileFormat export_dialog_get_specified_format (ExportDialog* self);
static gchar* export_dialog_get_label_for_parameters (ExportDialog* self,
                                               ExportFormatParameters* params);
static void export_dialog_on_format_changed (ExportDialog* self);
static void export_dialog_on_constraint_changed (ExportDialog* self);
static void export_dialog_on_pixels_changed (ExportDialog* self);
static GObject * export_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void _export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void _export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self);
static void _export_dialog___lambda41_ (ExportDialog* self);
static void __export_dialog___lambda41__gtk_entry_activate (GtkEntry* _sender,
                                                     gpointer self);
static void export_dialog_finalize (GObject * obj);
static GType export_dialog_get_type_once (void);

const ScaleConstraint EXPORT_DIALOG_CONSTRAINT_ARRAY[4] = {SCALE_CONSTRAINT_ORIGINAL, SCALE_CONSTRAINT_DIMENSIONS, SCALE_CONSTRAINT_WIDTH, SCALE_CONSTRAINT_HEIGHT};
const JpegQuality EXPORT_DIALOG_QUALITY_ARRAY[4] = {JPEG_QUALITY_LOW, JPEG_QUALITY_MEDIUM, JPEG_QUALITY_HIGH, JPEG_QUALITY_MAXIMUM};

static inline gpointer
export_dialog_get_instance_private (ExportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ExportDialog_private_offset);
}

ExportDialog*
export_dialog_construct (GType object_type,
                         const gchar* title)
{
	ExportDialog * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (ExportDialog*) g_object_new (object_type, "resizable", FALSE, "title", title, NULL);
	return self;
}

ExportDialog*
export_dialog_new (const gchar* title)
{
	return export_dialog_construct (TYPE_EXPORT_DIALOG, title);
}

static void
export_dialog_format_add_option (ExportDialog* self,
                                 const gchar* format_name)
{
	GeeArrayList* _tmp0_;
	GtkComboBoxText* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format_name != NULL);
	_tmp0_ = self->priv->format_options;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, format_name);
	_tmp1_ = self->priv->format_combo;
	gtk_combo_box_text_append_text (_tmp1_, format_name);
}

static void
export_dialog_format_set_active_text (ExportDialog* self,
                                      const gchar* text)
{
	gint selection_ticker = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	selection_ticker = 0;
	{
		GeeArrayList* _current_text_list = NULL;
		GeeArrayList* _tmp0_;
		gint _current_text_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _current_text_index = 0;
		_tmp0_ = self->priv->format_options;
		_current_text_list = _tmp0_;
		_tmp1_ = _current_text_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_current_text_size = _tmp3_;
		_current_text_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* current_text = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gint _tmp10_;
			_current_text_index = _current_text_index + 1;
			_tmp4_ = _current_text_index;
			_tmp5_ = _current_text_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _current_text_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _current_text_index);
			current_text = (gchar*) _tmp7_;
			_tmp8_ = current_text;
			if (g_strcmp0 (_tmp8_, text) == 0) {
				GtkComboBoxText* _tmp9_;
				_tmp9_ = self->priv->format_combo;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp9_, selection_ticker);
				_g_free0 (current_text);
				return;
			}
			_tmp10_ = selection_ticker;
			selection_ticker = _tmp10_ + 1;
			_g_free0 (current_text);
		}
	}
	g_error ("ExportDialog.vala:175: format_set_active_text: text '%s' isn't in comb" \
"o box", text);
}

static PhotoFileFormat
export_dialog_get_specified_format (ExportDialog* self)
{
	gint index = 0;
	GtkComboBoxText* _tmp0_;
	PhotoFileFormat* writeable_formats = NULL;
	gint _tmp1_ = 0;
	PhotoFileFormat* _tmp2_;
	gint writeable_formats_length1;
	gint _writeable_formats_size_;
	PhotoFileFormat _tmp3_;
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->format_combo;
	index = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	if (index < EXPORT_DIALOG_NUM_SPECIAL_FORMATS) {
		index = EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
	}
	index -= EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
	_tmp2_ = photo_file_format_get_writeable (&_tmp1_);
	writeable_formats = _tmp2_;
	writeable_formats_length1 = _tmp1_;
	_writeable_formats_size_ = writeable_formats_length1;
	_tmp3_ = writeable_formats[index];
	result = _tmp3_;
	writeable_formats = (g_free (writeable_formats), NULL);
	return result;
}

static gchar*
export_dialog_get_label_for_parameters (ExportDialog* self,
                                        ExportFormatParameters* params)
{
	ExportFormatParameters _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
			result = _tmp1_;
			return result;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
			result = _tmp2_;
			return result;
		}
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp3_;
			PhotoFileFormatProperties* _tmp4_;
			PhotoFileFormatProperties* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = *params;
			_tmp4_ = photo_file_format_get_properties (_tmp3_.specified_format);
			_tmp5_ = _tmp4_;
			_tmp6_ = photo_file_format_properties_get_user_visible_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_photo_file_format_properties_unref0 (_tmp5_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			g_error ("ExportDialog.vala:200: get_label_for_parameters: unrecognized export f" \
"ormat mode");
		}
	}
}

gboolean
export_dialog_execute (ExportDialog* self,
                       gint* scale,
                       ScaleConstraint* constraint,
                       ExportFormatParameters* parameters)
{
	gint _vala_scale = 0;
	ScaleConstraint _vala_constraint = 0;
	ExportFormatParameters _tmp0_;
	ExportFormatParameters _tmp2_;
	ExportFormatParameters _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean ok = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parameters != NULL, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp0_ = *parameters;
	if (_tmp0_.mode != EXPORT_FORMAT_MODE_LAST) {
		GtkComboBoxText* _tmp1_;
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
		export_dialog_current_constraint = _vala_constraint;
		_tmp1_ = self->priv->constraint_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, 0);
	}
	_tmp2_ = *parameters;
	if (_tmp2_.mode == EXPORT_FORMAT_MODE_LAST) {
		ExportFormatParameters _tmp3_;
		_tmp3_ = export_dialog_current_parameters;
		*parameters = _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		ExportFormatParameters _tmp5_;
		_tmp5_ = *parameters;
		if (_tmp5_.mode == EXPORT_FORMAT_MODE_SPECIFIED) {
			ExportFormatParameters _tmp6_;
			_tmp6_ = *parameters;
			_tmp4_ = !photo_file_format_can_write (_tmp6_.specified_format);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			(*parameters).specified_format = photo_file_format_get_system_default_format ();
		}
	}
	_tmp7_ = *parameters;
	_tmp8_ = export_dialog_get_label_for_parameters (self, &_tmp7_);
	_tmp9_ = _tmp8_;
	export_dialog_format_set_active_text (self, _tmp9_);
	_g_free0 (_tmp9_);
	export_dialog_on_format_changed (self);
	ok = gtk_dialog_run ((GtkDialog*) self) == ((gint) GTK_RESPONSE_OK);
	if (ok) {
		gint index = 0;
		GtkComboBoxText* _tmp10_;
		ScaleConstraint _tmp11_;
		GtkSpinButton* _tmp12_;
		gboolean _tmp13_ = FALSE;
		GtkCheckButton* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		GtkComboBoxText* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gboolean _tmp23_;
		_tmp10_ = self->priv->constraint_combo;
		index = gtk_combo_box_get_active ((GtkComboBox*) _tmp10_);
		_vala_assert (index >= 0, "index >= 0");
		_tmp11_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[index];
		_vala_constraint = _tmp11_;
		export_dialog_current_constraint = _vala_constraint;
		_tmp12_ = self->priv->pixels_spinbutton;
		_vala_scale = (gint) gtk_spin_button_get_value (_tmp12_);
		if (_vala_constraint != SCALE_CONSTRAINT_ORIGINAL) {
			_vala_assert (_vala_scale > 0, "scale > 0");
		}
		export_dialog_current_scale = _vala_scale;
		_tmp14_ = self->priv->export_metadata;
		_tmp15_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			GtkCheckButton* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = self->priv->export_metadata;
			_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = _tmp19_;
		} else {
			_tmp13_ = FALSE;
		}
		(*parameters).export_metadata = _tmp13_;
		_tmp20_ = self->priv->format_combo;
		_tmp21_ = gtk_combo_box_text_get_active_text (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strcmp0 (_tmp22_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
		_g_free0 (_tmp22_);
		if (_tmp23_) {
			export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_UNMODIFIED;
			(*parameters).mode = export_dialog_current_parameters.mode;
		} else {
			GtkComboBoxText* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp27_;
			_tmp24_ = self->priv->format_combo;
			_tmp25_ = gtk_combo_box_text_get_active_text (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strcmp0 (_tmp26_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
			_g_free0 (_tmp26_);
			if (_tmp27_) {
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_CURRENT;
				(*parameters).mode = export_dialog_current_parameters.mode;
			} else {
				ExportFormatParameters _tmp28_;
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_SPECIFIED;
				(*parameters).mode = export_dialog_current_parameters.mode;
				export_dialog_current_parameters.specified_format = export_dialog_get_specified_format (self);
				(*parameters).specified_format = export_dialog_current_parameters.specified_format;
				_tmp28_ = export_dialog_current_parameters;
				if (_tmp28_.specified_format == PHOTO_FILE_FORMAT_JFIF) {
					GtkComboBoxText* _tmp29_;
					JpegQuality _tmp30_;
					_tmp29_ = self->priv->quality_combo;
					_tmp30_ = EXPORT_DIALOG_QUALITY_ARRAY[gtk_combo_box_get_active ((GtkComboBox*) _tmp29_)];
					export_dialog_current_parameters.quality = _tmp30_;
					(*parameters).quality = export_dialog_current_parameters.quality;
				}
			}
		}
	} else {
		_vala_scale = 0;
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
	}
	gtk_widget_destroy ((GtkWidget*) self);
	result = ok;
	if (scale) {
		*scale = _vala_scale;
	}
	if (constraint) {
		*constraint = _vala_constraint;
	}
	return result;
}

static void
export_dialog_on_constraint_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	gboolean jpeg = FALSE;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileFormatProperties* _tmp5_;
	PhotoFileFormatProperties* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GtkSpinButton* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GtkComboBoxText* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->constraint_combo;
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active ((GtkComboBox*) _tmp0_)];
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
	_tmp2_ = self->priv->format_combo;
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = photo_file_format_get_properties (PHOTO_FILE_FORMAT_JFIF);
	_tmp6_ = _tmp5_;
	_tmp7_ = photo_file_format_properties_get_user_visible_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) == 0;
	_g_free0 (_tmp8_);
	_photo_file_format_properties_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	jpeg = _tmp9_;
	_tmp10_ = self->priv->pixels_spinbutton;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, !original);
	if (!original) {
		_tmp11_ = jpeg;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp12_ = self->priv->quality_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp11_);
	if (original) {
		GtkWidget* _tmp13_;
		_tmp13_ = self->priv->export_button;
		gtk_widget_set_sensitive (_tmp13_, TRUE);
	} else {
		export_dialog_on_pixels_changed (self);
	}
}

static void
export_dialog_on_format_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->constraint_combo;
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active ((GtkComboBox*) _tmp0_)];
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
	_tmp2_ = self->priv->format_combo;
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		GtkComboBoxText* _tmp6_;
		GtkComboBoxText* _tmp7_;
		GtkComboBoxText* _tmp8_;
		GtkSpinButton* _tmp9_;
		GtkCheckButton* _tmp10_;
		GtkCheckButton* _tmp11_;
		_tmp6_ = self->priv->constraint_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp6_, 0);
		_tmp7_ = self->priv->constraint_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = self->priv->quality_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = self->priv->pixels_spinbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->export_metadata;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp10_, FALSE);
		_tmp11_ = self->priv->export_metadata;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
	} else {
		GtkComboBoxText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = self->priv->format_combo;
		_tmp13_ = gtk_combo_box_text_get_active_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strcmp0 (_tmp14_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
		_g_free0 (_tmp14_);
		if (_tmp15_) {
			GtkComboBoxText* _tmp16_;
			GtkComboBoxText* _tmp17_;
			GtkSpinButton* _tmp18_;
			GtkCheckButton* _tmp19_;
			_tmp16_ = self->priv->constraint_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
			_tmp17_ = self->priv->quality_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, FALSE);
			_tmp18_ = self->priv->pixels_spinbutton;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, !original);
			_tmp19_ = self->priv->export_metadata;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, TRUE);
		} else {
			GtkComboBoxText* _tmp20_;
			gboolean jpeg = FALSE;
			gboolean _tmp21_ = FALSE;
			GtkComboBoxText* _tmp22_;
			GtkCheckButton* _tmp23_;
			_tmp20_ = self->priv->constraint_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
			jpeg = export_dialog_get_specified_format (self) == PHOTO_FILE_FORMAT_JFIF;
			if (!original) {
				_tmp21_ = jpeg;
			} else {
				_tmp21_ = FALSE;
			}
			_tmp22_ = self->priv->quality_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, _tmp21_);
			_tmp23_ = self->priv->export_metadata;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, TRUE);
		}
	}
}

static void
export_dialog_on_pixels_changed (ExportDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSpinButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->pixels_spinbutton;
	if (((gint) gtk_entry_get_text_length ((GtkEntry*) _tmp1_)) > 0) {
		GtkSpinButton* _tmp2_;
		_tmp2_ = self->priv->pixels_spinbutton;
		_tmp0_ = gtk_spin_button_get_value (_tmp2_) > ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp3_;
		_tmp3_ = self->priv->export_button;
		gtk_widget_set_sensitive (_tmp3_, TRUE);
	} else {
		GtkWidget* _tmp4_;
		_tmp4_ = self->priv->export_button;
		gtk_widget_set_sensitive (_tmp4_, FALSE);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	export_dialog_on_constraint_changed ((ExportDialog*) self);
}

static void
_export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
	export_dialog_on_format_changed ((ExportDialog*) self);
}

static void
_export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                       gpointer self)
{
	export_dialog_on_pixels_changed ((ExportDialog*) self);
}

static void
_export_dialog___lambda41_ (ExportDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSpinButton* _tmp1_;
	_tmp1_ = self->priv->pixels_spinbutton;
	if (((gint) gtk_entry_get_text_length ((GtkEntry*) _tmp1_)) > 0) {
		GtkSpinButton* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->pixels_spinbutton;
		_tmp3_ = gtk_entry_get_text ((GtkEntry*) _tmp2_);
		_tmp0_ = atoi (_tmp3_) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	} else {
		GtkSpinButton* _tmp4_;
		_tmp4_ = self->priv->pixels_spinbutton;
		gtk_spin_button_set_value (_tmp4_, (gdouble) export_dialog_current_scale);
	}
}

static void
__export_dialog___lambda41__gtk_entry_activate (GtkEntry* _sender,
                                                gpointer self)
{
	_export_dialog___lambda41_ ((ExportDialog*) self);
}

static GObject *
export_dialog_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ExportDialog * self;
	GtkLabel* format_label = NULL;
	GtkComboBoxText* _tmp0_;
	GtkWidget* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkComboBoxText* _tmp3_;
	gint _tmp4_ = 0;
	PhotoFileFormat* _tmp5_;
	GtkLabel* quality_label = NULL;
	GtkComboBoxText* _tmp10_;
	GtkWidget* _tmp11_;
	GtkLabel* _tmp12_ = NULL;
	GtkComboBoxText* _tmp13_;
	gint ctr = 0;
	GtkLabel* constraint_label = NULL;
	GtkComboBoxText* _tmp20_;
	GtkWidget* _tmp21_;
	GtkLabel* _tmp22_ = NULL;
	GtkComboBoxText* _tmp23_;
	GtkSpinButton* _tmp29_ = NULL;
	GtkLabel* size_label = NULL;
	GtkSpinButton* _tmp30_;
	GtkWidget* _tmp31_;
	GtkLabel* _tmp32_ = NULL;
	GtkCheckButton* _tmp33_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp34_ = NULL;
	GtkGrid* _tmp35_;
	GtkLabel* _tmp36_;
	GtkGrid* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkGrid* _tmp39_;
	GtkLabel* _tmp40_;
	GtkGrid* _tmp41_;
	GtkComboBoxText* _tmp42_;
	GtkGrid* _tmp43_;
	GtkLabel* _tmp44_;
	GtkGrid* _tmp45_;
	GtkComboBoxText* _tmp46_;
	GtkGrid* _tmp47_;
	GtkLabel* _tmp48_;
	GtkGrid* _tmp49_;
	GtkSpinButton* _tmp50_;
	GtkGrid* _tmp51_;
	GtkCheckButton* _tmp52_;
	GtkBox* _tmp53_;
	GtkGrid* _tmp54_;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	GtkWidget* _tmp57_;
	GtkWidget* _tmp58_;
	GtkWidget* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkWidget* _tmp61_;
	GtkComboBoxText* _tmp64_;
	GtkComboBoxText* _tmp65_;
	GtkSpinButton* _tmp66_;
	GtkSpinButton* _tmp67_;
	parent_class = G_OBJECT_CLASS (export_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORT_DIALOG, ExportDialog);
	_tmp0_ = self->priv->format_combo;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	_tmp2_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Format:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (_tmp2_, _tmp1_);
	_g_object_unref0 (_tmp1_);
	gtk_label_set_use_underline (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	format_label = _tmp2_;
	_tmp3_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->format_combo);
	self->priv->format_combo = _tmp3_;
	export_dialog_format_add_option (self, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
	export_dialog_format_add_option (self, EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
	_tmp5_ = photo_file_format_get_writeable (&_tmp4_);
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
		format_collection = _tmp5_;
		format_collection_length1 = _tmp4_;
		for (format_it = 0; format_it < format_collection_length1; format_it = format_it + 1) {
			PhotoFileFormat format = 0;
			format = format_collection[format_it];
			{
				PhotoFileFormatProperties* _tmp6_;
				PhotoFileFormatProperties* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp6_ = photo_file_format_get_properties (format);
				_tmp7_ = _tmp6_;
				_tmp8_ = photo_file_format_properties_get_user_visible_name (_tmp7_);
				_tmp9_ = _tmp8_;
				export_dialog_format_add_option (self, _tmp9_);
				_g_free0 (_tmp9_);
				_photo_file_format_properties_unref0 (_tmp7_);
			}
		}
		format_collection = (g_free (format_collection), NULL);
	}
	_tmp10_ = self->priv->quality_combo;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Quality:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	gtk_label_set_use_underline (_tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	quality_label = _tmp12_;
	_tmp13_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->quality_combo);
	self->priv->quality_combo = _tmp13_;
	ctr = 0;
	{
		JpegQuality* quality_collection = NULL;
		gint quality_collection_length1 = 0;
		gint _quality_collection_size_ = 0;
		gint quality_it = 0;
		quality_collection = EXPORT_DIALOG_QUALITY_ARRAY;
		quality_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_QUALITY_ARRAY);
		for (quality_it = 0; quality_it < quality_collection_length1; quality_it = quality_it + 1) {
			JpegQuality quality = 0;
			quality = quality_collection[quality_it];
			{
				GtkComboBoxText* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				ExportFormatParameters _tmp17_;
				gint _tmp19_;
				_tmp14_ = self->priv->quality_combo;
				_tmp15_ = jpeg_quality_to_string (quality);
				_tmp16_ = _tmp15_;
				gtk_combo_box_text_append_text (_tmp14_, _tmp16_);
				_g_free0 (_tmp16_);
				_tmp17_ = export_dialog_current_parameters;
				if (quality == _tmp17_.quality) {
					GtkComboBoxText* _tmp18_;
					_tmp18_ = self->priv->quality_combo;
					gtk_combo_box_set_active ((GtkComboBox*) _tmp18_, ctr);
				}
				_tmp19_ = ctr;
				ctr = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = self->priv->constraint_combo;
	_tmp21_ = _g_object_ref0 ((GtkWidget*) _tmp20_);
	_tmp22_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Scaling constraint:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (_tmp22_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	gtk_label_set_use_underline (_tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	constraint_label = _tmp22_;
	_tmp23_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->constraint_combo);
	self->priv->constraint_combo = _tmp23_;
	ctr = 0;
	{
		ScaleConstraint* constraint_collection = NULL;
		gint constraint_collection_length1 = 0;
		gint _constraint_collection_size_ = 0;
		gint constraint_it = 0;
		constraint_collection = EXPORT_DIALOG_CONSTRAINT_ARRAY;
		constraint_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_CONSTRAINT_ARRAY);
		for (constraint_it = 0; constraint_it < constraint_collection_length1; constraint_it = constraint_it + 1) {
			ScaleConstraint constraint = 0;
			constraint = constraint_collection[constraint_it];
			{
				GtkComboBoxText* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gint _tmp28_;
				_tmp24_ = self->priv->constraint_combo;
				_tmp25_ = scale_constraint_to_string (constraint);
				_tmp26_ = _tmp25_;
				gtk_combo_box_text_append_text (_tmp24_, _tmp26_);
				_g_free0 (_tmp26_);
				if (constraint == export_dialog_current_constraint) {
					GtkComboBoxText* _tmp27_;
					_tmp27_ = self->priv->constraint_combo;
					gtk_combo_box_set_active ((GtkComboBox*) _tmp27_, ctr);
				}
				_tmp28_ = ctr;
				ctr = _tmp28_ + 1;
			}
		}
	}
	_tmp29_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 999999, (gdouble) 1);
	gtk_spin_button_set_digits (_tmp29_, (guint) 0);
	gtk_entry_set_max_length ((GtkEntry*) _tmp29_, 6);
	gtk_spin_button_set_value (_tmp29_, (gdouble) export_dialog_current_scale);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->pixels_spinbutton);
	self->priv->pixels_spinbutton = _tmp29_;
	_tmp30_ = self->priv->pixels_spinbutton;
	_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
	_tmp32_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Size in pixels:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (_tmp32_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	gtk_label_set_use_underline (_tmp32_, TRUE);
	g_object_ref_sink (_tmp32_);
	size_label = _tmp32_;
	_tmp33_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Export metadata"));
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp33_, TRUE);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->export_metadata);
	self->priv->export_metadata = _tmp33_;
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp34_, 12);
	gtk_grid_set_row_spacing (_tmp34_, 6);
	g_object_set ((GtkWidget*) _tmp34_, "margin", 12, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp34_, 0);
	g_object_ref_sink (_tmp34_);
	grid = _tmp34_;
	_tmp35_ = grid;
	_tmp36_ = format_label;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 0, 0, 1, 1);
	_tmp37_ = grid;
	_tmp38_ = self->priv->format_combo;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 1, 0, 1, 1);
	_tmp39_ = grid;
	_tmp40_ = quality_label;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 0, 1, 1, 1);
	_tmp41_ = grid;
	_tmp42_ = self->priv->quality_combo;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 1, 1, 1, 1);
	_tmp43_ = grid;
	_tmp44_ = constraint_label;
	gtk_grid_attach (_tmp43_, (GtkWidget*) _tmp44_, 0, 2, 1, 1);
	_tmp45_ = grid;
	_tmp46_ = self->priv->constraint_combo;
	gtk_grid_attach (_tmp45_, (GtkWidget*) _tmp46_, 1, 2, 1, 1);
	_tmp47_ = grid;
	_tmp48_ = size_label;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 0, 3, 1, 1);
	_tmp49_ = grid;
	_tmp50_ = self->priv->pixels_spinbutton;
	gtk_grid_attach (_tmp49_, (GtkWidget*) _tmp50_, 1, 3, 1, 1);
	_tmp51_ = grid;
	_tmp52_ = self->priv->export_metadata;
	gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, 1, 4, 1, 1);
	_tmp53_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp54_ = grid;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp55_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("_Export"), (gint) GTK_RESPONSE_OK);
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_g_object_unref0 (self->priv->export_button);
	self->priv->export_button = _tmp56_;
	_tmp57_ = self->priv->export_button;
	gtk_widget_set_can_default (_tmp57_, TRUE);
	_tmp58_ = self->priv->export_button;
	g_object_set (_tmp58_, "has-default", TRUE, NULL);
	_tmp59_ = self->priv->export_button;
	_tmp60_ = gtk_widget_get_style_context (_tmp59_);
	gtk_style_context_add_class (_tmp60_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp61_ = self->priv->export_button;
	gtk_widget_grab_focus (_tmp61_);
	if (export_dialog_current_constraint == SCALE_CONSTRAINT_ORIGINAL) {
		GtkSpinButton* _tmp62_;
		GtkComboBoxText* _tmp63_;
		_tmp62_ = self->priv->pixels_spinbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp62_, FALSE);
		_tmp63_ = self->priv->quality_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp63_, FALSE);
	}
	_tmp64_ = self->priv->constraint_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp64_, "changed", (GCallback) _export_dialog_on_constraint_changed_gtk_combo_box_changed, self, 0);
	_tmp65_ = self->priv->format_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp65_, "changed", (GCallback) _export_dialog_on_format_changed_gtk_combo_box_changed, self, 0);
	_tmp66_ = self->priv->pixels_spinbutton;
	g_signal_connect_object ((GtkEditable*) _tmp66_, "changed", (GCallback) _export_dialog_on_pixels_changed_gtk_editable_changed, self, 0);
	_tmp67_ = self->priv->pixels_spinbutton;
	g_signal_connect_object ((GtkEntry*) _tmp67_, "activate", (GCallback) __export_dialog___lambda41__gtk_entry_activate, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (size_label);
	_g_object_unref0 (constraint_label);
	_g_object_unref0 (quality_label);
	_g_object_unref0 (format_label);
	return obj;
}

static void
export_dialog_class_init (ExportDialogClass * klass,
                          gpointer klass_data)
{
	ExportFormatParameters _tmp0_ = {0};
	export_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExportDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = export_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = export_dialog_finalize;
	export_format_parameters_current (&_tmp0_);
	export_dialog_current_parameters = _tmp0_;
}

static void
export_dialog_instance_init (ExportDialog * self,
                             gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = export_dialog_get_instance_private (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->format_options = _tmp0_;
}

static void
export_dialog_finalize (GObject * obj)
{
	ExportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORT_DIALOG, ExportDialog);
	_g_object_unref0 (self->priv->quality_combo);
	_g_object_unref0 (self->priv->constraint_combo);
	_g_object_unref0 (self->priv->format_combo);
	_g_object_unref0 (self->priv->export_metadata);
	_g_object_unref0 (self->priv->format_options);
	_g_object_unref0 (self->priv->pixels_spinbutton);
	_g_object_unref0 (self->priv->export_button);
	G_OBJECT_CLASS (export_dialog_parent_class)->finalize (obj);
}

static GType
export_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportDialog), 0, (GInstanceInitFunc) export_dialog_instance_init, NULL };
	GType export_dialog_type_id;
	export_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "ExportDialog", &g_define_type_info, 0);
	ExportDialog_private_offset = g_type_add_instance_private (export_dialog_type_id, sizeof (ExportDialogPrivate));
	return export_dialog_type_id;
}

GType
export_dialog_get_type (void)
{
	static volatile gsize export_dialog_type_id__once = 0;
	if (g_once_init_enter (&export_dialog_type_id__once)) {
		GType export_dialog_type_id;
		export_dialog_type_id = export_dialog_get_type_once ();
		g_once_init_leave (&export_dialog_type_id__once, export_dialog_type_id);
	}
	return export_dialog_type_id__once;
}

