#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkMPASReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFAccessor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXArrayAccessor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFCAMReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFCFReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFCFWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFPOPReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetCDFUGRIDReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSLACParticleReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSLACReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIONetCDFCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkMPASReader_Init(csi);
  vtkNetCDFAccessor_Init(csi);
  vtkXArrayAccessor_Init(csi);
  vtkNetCDFCAMReader_Init(csi);
  vtkNetCDFCFReader_Init(csi);
  vtkNetCDFCFWriter_Init(csi);
  vtkNetCDFPOPReader_Init(csi);
  vtkNetCDFReader_Init(csi);
  vtkNetCDFUGRIDReader_Init(csi);
  vtkSLACParticleReader_Init(csi);
  vtkSLACReader_Init(csi);
}
